/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import com.sun.jna.Platform;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.GlobalConfig;
import oshi.util.Memoizer;
import oshi.util.tuples.Pair;

public abstract class AbstractOperatingSystem
implements OperatingSystem {
    public static final String OSHI_OS_UNIX_WHOCOMMAND = "oshi.os.unix.whoCommand";
    protected static final boolean USE_WHO_COMMAND = GlobalConfig.get("oshi.os.unix.whoCommand", false);
    private final Supplier<String> manufacturer = Memoizer.memoize(this::queryManufacturer);
    private final Supplier<Pair<String, OperatingSystem.OSVersionInfo>> familyVersionInfo = Memoizer.memoize(this::queryFamilyVersionInfo);
    private final Supplier<Integer> bitness = Memoizer.memoize(this::queryPlatformBitness);

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    protected abstract String queryManufacturer();

    @Override
    public String getFamily() {
        return this.familyVersionInfo.get().getA();
    }

    @Override
    public OperatingSystem.OSVersionInfo getVersionInfo() {
        return this.familyVersionInfo.get().getB();
    }

    protected abstract Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo();

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    private int queryPlatformBitness() {
        if (Platform.is64Bit()) {
            return 64;
        }
        int jvmBitness = System.getProperty("os.arch").indexOf("64") != -1 ? 64 : 32;
        return this.queryBitness(jvmBitness);
    }

    protected abstract int queryBitness(int var1);

    @Override
    public List<OSProcess> getProcesses(Predicate<OSProcess> filter, Comparator<OSProcess> sort, int limit) {
        return this.queryAllProcesses().stream().filter(filter == null ? OperatingSystem.ProcessFiltering.ALL_PROCESSES : filter).sorted(sort == null ? OperatingSystem.ProcessSorting.NO_SORTING : sort).limit(limit > 0 ? (long)limit : Long.MAX_VALUE).collect(Collectors.toList());
    }

    protected abstract List<OSProcess> queryAllProcesses();

    @Override
    public List<OSProcess> getChildProcesses(int parentPid, Predicate<OSProcess> filter, Comparator<OSProcess> sort, int limit) {
        return this.queryChildProcesses(parentPid).stream().filter(filter == null ? OperatingSystem.ProcessFiltering.ALL_PROCESSES : filter).sorted(sort == null ? OperatingSystem.ProcessSorting.NO_SORTING : sort).limit(limit > 0 ? (long)limit : Long.MAX_VALUE).collect(Collectors.toList());
    }

    protected abstract List<OSProcess> queryChildProcesses(int var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getManufacturer()).append(' ').append(this.getFamily()).append(' ').append(this.getVersionInfo());
        return sb.toString();
    }
}

