/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.mesh;

import net.imagej.mesh.MarchingCubesRealType;
import net.imagej.mesh.Mesh;
import net.imagej.mesh.naive.NaiveDoubleMesh;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.view.Views;
import org.apache.commons.math3.util.MathArrays;

class MarchingCubesBooleanType {
    private static final double[] p0 = new double[]{0.0, 0.0, 1.0};
    private static final double[] p1 = new double[]{1.0, 0.0, 1.0};
    private static final double[] p2 = new double[]{1.0, 0.0, 0.0};
    private static final double[] p3 = new double[]{0.0, 0.0, 0.0};
    private static final double[] p4 = new double[]{0.0, 1.0, 1.0};
    private static final double[] p5 = new double[]{1.0, 1.0, 1.0};
    private static final double[] p6 = new double[]{1.0, 1.0, 0.0};
    private static final double[] p7 = new double[]{0.0, 1.0, 0.0};

    MarchingCubesBooleanType() {
    }

    private static <T extends BooleanType<T>> byte[] mask(RandomAccessibleInterval<T> input) {
        int i;
        int msx = (int)input.dimension(0);
        int msy = (int)input.dimension(1);
        int msz = (int)input.dimension(2);
        int isx = msx + 2;
        int isy = msy + 2;
        int isz = msz + 2;
        int is = isx * isy * isz;
        byte[] indices = new byte[is];
        Cursor c = Views.flatIterable(input).cursor();
        int j = isx * isy + isx + 1;
        for (int z = 0; z < msz; ++z) {
            for (int y = 0; y < msy; ++y) {
                for (int x = 0; x < msx; ++x) {
                    if (((BooleanType)c.next()).get()) {
                        indices[j] = 1;
                    }
                    ++j;
                }
                j += 2;
            }
            j += 2 * isx;
        }
        for (i = 0; i < is - 1; ++i) {
            indices[i] = MarchingCubesBooleanType.ubyte(indices[i] | indices[i + 1] << 1);
        }
        for (i = 0; i < is - isx; ++i) {
            indices[i] = MarchingCubesBooleanType.ubyte(indices[i] | indices[i + isx] << 2);
        }
        for (i = 0; i < is - isx * isy; ++i) {
            indices[i] = MarchingCubesBooleanType.ubyte(indices[i] | indices[i + isx * isy] << 4);
        }
        return indices;
    }

    private static byte ubyte(int unsignedByte) {
        return (byte)(unsignedByte & 0xFF);
    }

    static <T extends BooleanType<T>> Mesh calculate(RandomAccessibleInterval<T> input) {
        double[][] vertlist = new double[12][];
        int msx = (int)input.dimension(0);
        int msy = (int)input.dimension(1);
        int msz = (int)input.dimension(2);
        int isx = msx + 2;
        int isy = msy + 2;
        int isz = msz + 2;
        byte[] mask = MarchingCubesBooleanType.mask(input);
        NaiveDoubleMesh output = new NaiveDoubleMesh();
        int minX = (int)input.min(0) - 1;
        int minY = (int)input.min(1) - 1;
        int minZ = (int)input.min(2) - 1;
        int maxX = (int)input.max(0) + 1;
        int maxY = (int)input.max(1) + 1;
        int maxZ = (int)input.max(2) + 1;
        for (int z = minZ; z < maxZ; ++z) {
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    int mz = z - minZ;
                    int my = y - minY;
                    int mx = x - minX;
                    int mindex = mask[mz * (isx * isy) + my * isx + mx] & 0xFF;
                    int EDGE = MarchingCubesRealType.EDGE_TABLE[mindex];
                    if (EDGE == 0) continue;
                    if (0 != (EDGE & 1)) {
                        vertlist[0] = MarchingCubesBooleanType.interpolatePoint(p0, p1, (mindex & 0x20) != 0);
                    }
                    if (0 != (EDGE & 2)) {
                        vertlist[1] = MarchingCubesBooleanType.interpolatePoint(p1, p2, (mindex & 2) != 0);
                    }
                    if (0 != (EDGE & 4)) {
                        vertlist[2] = MarchingCubesBooleanType.interpolatePoint(p2, p3, (mindex & 1) != 0);
                    }
                    if (0 != (EDGE & 8)) {
                        vertlist[3] = MarchingCubesBooleanType.interpolatePoint(p3, p0, (mindex & 0x10) != 0);
                    }
                    if (0 != (EDGE & 0x10)) {
                        vertlist[4] = MarchingCubesBooleanType.interpolatePoint(p4, p5, (mindex & 0x80) != 0);
                    }
                    if (0 != (EDGE & 0x20)) {
                        vertlist[5] = MarchingCubesBooleanType.interpolatePoint(p5, p6, (mindex & 8) != 0);
                    }
                    if (0 != (EDGE & 0x40)) {
                        vertlist[6] = MarchingCubesBooleanType.interpolatePoint(p6, p7, (mindex & 4) != 0);
                    }
                    if (0 != (EDGE & 0x80)) {
                        vertlist[7] = MarchingCubesBooleanType.interpolatePoint(p7, p4, (mindex & 0x40) != 0);
                    }
                    if (0 != (EDGE & 0x100)) {
                        vertlist[8] = MarchingCubesBooleanType.interpolatePoint(p0, p4, (mindex & 0x40) != 0);
                    }
                    if (0 != (EDGE & 0x200)) {
                        vertlist[9] = MarchingCubesBooleanType.interpolatePoint(p1, p5, (mindex & 0x80) != 0);
                    }
                    if (0 != (EDGE & 0x400)) {
                        vertlist[10] = MarchingCubesBooleanType.interpolatePoint(p2, p6, (mindex & 8) != 0);
                    }
                    if (0 != (EDGE & 0x800)) {
                        vertlist[11] = MarchingCubesBooleanType.interpolatePoint(p3, p7, (mindex & 4) != 0);
                    }
                    byte[] TRIANGLE = MarchingCubesRealType.TRIANGLE_TABLE[mindex];
                    for (int i = 0; i < TRIANGLE.length; i += 3) {
                        double v0x = vertlist[TRIANGLE[i]][0];
                        double v0y = vertlist[TRIANGLE[i]][1];
                        double v0z = vertlist[TRIANGLE[i]][2];
                        double v1x = vertlist[TRIANGLE[i + 1]][0];
                        double v1y = vertlist[TRIANGLE[i + 1]][1];
                        double v1z = vertlist[TRIANGLE[i + 1]][2];
                        double v2x = vertlist[TRIANGLE[i + 2]][0];
                        double v2y = vertlist[TRIANGLE[i + 2]][1];
                        double v2z = vertlist[TRIANGLE[i + 2]][2];
                        if (!MarchingCubesBooleanType.positiveArea(v0x, v0y, v0z, v1x, v1y, v1z, v2x, v2y, v2z)) continue;
                        output.triangles().add((double)x + v0x, (double)y + v0y, (double)z + v0z, (double)x + v1x, (double)y + v1y, (double)z + v1z, (double)x + v2x, (double)y + v2y, (double)z + v2z);
                    }
                }
            }
        }
        return output;
    }

    private static boolean positiveArea(double v0x, double v0y, double v0z, double v1x, double v1y, double v1z, double v2x, double v2y, double v2z) {
        double p1x = v0x - v1x;
        double p1y = v0y - v1y;
        double p1z = v0z - v1z;
        double p2x = v2x - v0x;
        double p2y = v2y - v0y;
        double p2z = v2z - v0z;
        double cpx = MathArrays.linearCombination((double)p1y, (double)p2z, (double)(-p1z), (double)p2y);
        double cpy = MathArrays.linearCombination((double)p1z, (double)p2x, (double)(-p1x), (double)p2z);
        double cpz = MathArrays.linearCombination((double)p1x, (double)p2y, (double)(-p1y), (double)p2x);
        return cpx != 0.0 || cpy != 0.0 || cpz != 0.0;
    }

    private static double[] interpolatePoint(double[] p0, double[] p1, boolean v1) {
        return v1 ? p1 : p0;
    }
}

