/*
 * Decompiled with CFR 0.152.
 */
package nrrd;

class NrrdAxisInfo {
    long size;
    double spacing = Double.NaN;
    double min = Double.NaN;
    double max = Double.NaN;
    double[] spaceDirection = null;
    String center;
    String kind;
    String label;
    String units;

    NrrdAxisInfo() {
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public String getUnits() {
        return this.units;
    }

    public double getSpacing() {
        return this.spacing;
    }

    public double[] getSpaceDirection() {
        return this.spaceDirection;
    }

    public void setUnits(String units) throws Exception {
        if (this.spaceDirection != null) {
            throw new Exception("Conflict between existing space direction and per axis unit field");
        }
        this.units = units;
    }

    public void setMin(double min) throws Exception {
        if (this.spaceDirection != null) {
            throw new Exception("Conflict between existing space direction and axis min field");
        }
        this.min = min;
    }

    public void setMax(double max) throws Exception {
        if (this.spaceDirection != null) {
            throw new Exception("Conflict between existing space direction and axis max field");
        }
        this.max = max;
    }

    public void setSpacing(double spacing) throws Exception {
        if (this.spaceDirection != null) {
            throw new Exception("Conflict between existing space direction and spacing field");
        }
        this.spacing = spacing;
    }

    public void setSpaceDirection(double[] spaceDirection) throws Exception {
        if (!Double.isNaN(this.spacing)) {
            throw new Exception("Conflict between existing spacing field and space direction");
        }
        if (!Double.isNaN(this.max)) {
            throw new Exception("Conflict between existing axis max field and space direction");
        }
        if (!Double.isNaN(this.min)) {
            throw new Exception("Conflict between existing axis min field and space direction");
        }
        if (this.units != null && !this.units.equals("")) {
            throw new Exception("Conflict between existing non-empty units field and space direction");
        }
        this.spaceDirection = spaceDirection;
    }
}

