/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.localThickness;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import sc.fiji.localThickness.Clean_Up_Local_Thickness;
import sc.fiji.localThickness.Distance_Ridge;
import sc.fiji.localThickness.EDT_S1D;
import sc.fiji.localThickness.Local_Thickness_Driver;
import sc.fiji.localThickness.Local_Thickness_Parallel;
import sc.fiji.localThickness.MaskThicknessMapWithOriginal;

public class LocalThicknessWrapper
implements PlugInFilter {
    private static final String DEFAULT_TITLE_SUFFIX = "_LocThk";
    private final EDT_S1D geometryToDistancePlugin = new EDT_S1D();
    private ImagePlus image;
    private final Distance_Ridge distanceRidgePlugin = new Distance_Ridge();
    private final Local_Thickness_Parallel localThicknessPlugin = new Local_Thickness_Parallel();
    private final Clean_Up_Local_Thickness thicknessCleaningPlugin = new Clean_Up_Local_Thickness();
    private final MaskThicknessMapWithOriginal thicknessMask = new MaskThicknessMapWithOriginal();
    public int threshold = 128;
    public boolean inverse = false;
    public boolean maskThicknessMap = true;
    public boolean calibratePixels = true;
    private ImagePlus resultImage = null;
    private boolean showOptions = false;
    private String titleSuffix = "_LocThk";

    public LocalThicknessWrapper() {
        this.setSilence(true);
        this.geometryToDistancePlugin.showOptions = this.showOptions;
    }

    public void setShowOptions(boolean show) {
        this.showOptions = show;
        this.geometryToDistancePlugin.showOptions = show;
    }

    public void setSilence(boolean silent) {
        this.distanceRidgePlugin.runSilent = silent;
        this.localThicknessPlugin.runSilent = silent;
        this.thicknessCleaningPlugin.runSilent = silent;
        this.geometryToDistancePlugin.runSilent = silent;
    }

    public ImagePlus processImage(ImagePlus inputImage) {
        String originalTitle = Local_Thickness_Driver.stripExtension(inputImage.getTitle());
        this.resultImage = null;
        this.geometryToDistancePlugin.setup("", inputImage);
        if (!this.showOptions) {
            this.geometryToDistancePlugin.inverse = this.inverse;
            this.geometryToDistancePlugin.thresh = this.threshold;
            this.geometryToDistancePlugin.run(null);
        } else {
            this.geometryToDistancePlugin.run(null);
            if (this.geometryToDistancePlugin.gotCancelled()) {
                this.resultImage = null;
                return this.getResultImage();
            }
            this.inverse = this.geometryToDistancePlugin.inverse;
            this.threshold = this.geometryToDistancePlugin.thresh;
        }
        this.resultImage = this.geometryToDistancePlugin.getResultImage();
        this.distanceRidgePlugin.setup("", this.resultImage);
        this.distanceRidgePlugin.run(null);
        this.resultImage = this.distanceRidgePlugin.getResultImage();
        this.localThicknessPlugin.setup("", this.resultImage);
        this.localThicknessPlugin.run(null);
        this.resultImage = this.localThicknessPlugin.getResultImage();
        this.thicknessCleaningPlugin.setup("", this.resultImage);
        this.thicknessCleaningPlugin.run(null);
        this.resultImage = this.thicknessCleaningPlugin.getResultImage();
        if (this.maskThicknessMap) {
            this.thicknessMask.inverse = this.inverse;
            this.thicknessMask.threshold = this.threshold;
            this.resultImage = this.thicknessMask.trimOverhang(inputImage, this.resultImage);
        }
        this.resultImage.setTitle(originalTitle + this.titleSuffix);
        this.resultImage.copyScale(inputImage);
        if (this.calibratePixels) {
            this.calibratePixels();
        }
        return this.getResultImage();
    }

    private void calibratePixels() {
        this.pixelValuesToCalibratedValues();
        this.backgroundToNaN(0);
    }

    private void backgroundToNaN(int backgroundColor) {
        if (this.resultImage == null) {
            throw new NullPointerException("The resultImage in LocalThicknessWrapper is null");
        }
        int depth = this.resultImage.getNSlices();
        int pixelsPerSlice = this.resultImage.getWidth() * this.resultImage.getHeight();
        ImageStack stack = this.resultImage.getStack();
        for (int z = 1; z <= depth; ++z) {
            float[] pixels = (float[])stack.getPixels(z);
            for (int i = 0; i < pixelsPerSlice; ++i) {
                if (Float.compare(pixels[i], backgroundColor) != 0) continue;
                pixels[i] = Float.NaN;
            }
        }
    }

    private void pixelValuesToCalibratedValues() {
        if (this.resultImage == null) {
            throw new NullPointerException("The resultImage in LocalThicknessWrapper is null");
        }
        double pixelWidth = this.resultImage.getCalibration().pixelWidth;
        ImageStack stack = this.resultImage.getStack();
        int depth = stack.getSize();
        for (int z = 1; z <= depth; ++z) {
            stack.getProcessor(z).multiply(pixelWidth);
        }
        StackStatistics stackStatistics = new StackStatistics(this.resultImage);
        double maxPixelValue = stackStatistics.max;
        this.resultImage.getProcessor().setMinAndMax(0.0, maxPixelValue);
    }

    public void setTitleSuffix(String imageTitleSuffix) {
        this.titleSuffix = imageTitleSuffix;
        if (this.titleSuffix == null || this.titleSuffix.isEmpty()) {
            this.titleSuffix = DEFAULT_TITLE_SUFFIX;
        }
    }

    public ImagePlus getResultImage() {
        return this.resultImage;
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 1;
    }

    public void run(ImageProcessor ip) {
        this.processImage(this.image);
        if (this.resultImage == null) {
            return;
        }
        this.resultImage.show();
        IJ.run((String)"Fire");
    }
}

