/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.localThickness;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Frame;

public class EDT_S1D
implements PlugInFilter {
    public static final int DEFAULT_THRESHOLD = 128;
    public static final boolean DEFAULT_INVERSE = false;
    private ImagePlus imp;
    private boolean cancelled;
    public byte[][] data;
    public int w;
    public int h;
    public int d;
    public int thresh = 128;
    public boolean inverse = false;
    public boolean showOptions = true;
    public boolean runSilent = false;
    private ImagePlus resultImage;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 1;
    }

    public void run(ImageProcessor ip) {
        int thread;
        int thread2;
        int thread3;
        this.resultImage = null;
        ImageStack stack = this.imp.getStack();
        this.w = stack.getWidth();
        this.h = stack.getHeight();
        this.d = this.imp.getStackSize();
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.cancelled = false;
        if (this.showOptions && !this.getScale()) {
            this.cancelled = true;
            return;
        }
        this.data = new byte[this.d][];
        for (int k = 0; k < this.d; ++k) {
            this.data[k] = (byte[])stack.getPixels(k + 1);
        }
        ImageStack sStack = new ImageStack(this.w, this.h);
        float[][] s = new float[this.d][];
        for (int k = 0; k < this.d; ++k) {
            FloatProcessor ipk = new FloatProcessor(this.w, this.h);
            sStack.addSlice(null, (ImageProcessor)ipk);
            s[k] = (float[])ipk.getPixels();
        }
        IJ.showStatus((String)"EDT transformation 1/3");
        Step1Thread[] s1t = new Step1Thread[nThreads];
        for (thread3 = 0; thread3 < nThreads; ++thread3) {
            s1t[thread3] = new Step1Thread(thread3, nThreads, this.w, this.h, this.d, this.thresh, s, this.data);
            s1t[thread3].start();
        }
        try {
            for (thread3 = 0; thread3 < nThreads; ++thread3) {
                s1t[thread3].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted in step 1 .");
        }
        IJ.showStatus((String)"EDT transformation 2/3");
        Step2Thread[] s2t = new Step2Thread[nThreads];
        for (thread2 = 0; thread2 < nThreads; ++thread2) {
            s2t[thread2] = new Step2Thread(thread2, nThreads, this.w, this.h, this.d, s);
            s2t[thread2].start();
        }
        try {
            for (thread2 = 0; thread2 < nThreads; ++thread2) {
                s2t[thread2].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted in step 2 .");
        }
        IJ.showStatus((String)"EDT transformation 3/3");
        Step3Thread[] s3t = new Step3Thread[nThreads];
        for (thread = 0; thread < nThreads; ++thread) {
            s3t[thread] = new Step3Thread(thread, nThreads, this.w, this.h, this.d, s, this.data);
            s3t[thread].start();
        }
        try {
            for (thread = 0; thread < nThreads; ++thread) {
                s3t[thread].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted in step 3 .");
        }
        float distMax = 0.0f;
        int wh = this.w * this.h;
        for (int k = 0; k < this.d; ++k) {
            float[] sk = s[k];
            for (int ind = 0; ind < wh; ++ind) {
                float dist;
                if ((this.data[k][ind] & 0xFF) < this.thresh ^ this.inverse) {
                    sk[ind] = 0.0f;
                    continue;
                }
                sk[ind] = dist = (float)Math.sqrt(sk[ind]);
                distMax = dist > distMax ? dist : distMax;
            }
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"Done");
        String title = this.stripExtension(this.imp.getTitle());
        int slices = this.imp.getNSlices();
        int channels = this.imp.getNChannels();
        int frames = this.imp.getNFrames();
        this.resultImage = IJ.createHyperStack((String)(title + "_EDT"), (int)this.w, (int)this.h, (int)channels, (int)slices, (int)frames, (int)32);
        this.resultImage.setStack(sStack, channels, slices, frames);
        this.resultImage.getProcessor().setMinAndMax(0.0, (double)distMax);
        if (!this.runSilent) {
            this.resultImage.show();
            IJ.run((String)"Fire");
        }
    }

    String stripExtension(String name) {
        int dotIndex;
        if (name != null && (dotIndex = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    public ImagePlus getResultImage() {
        return this.resultImage;
    }

    boolean getScale() {
        this.thresh = (int)Prefs.get((String)"edtS1.thresh", (double)128.0);
        this.inverse = Prefs.get((String)"edtS1.inverse", (boolean)false);
        GenericDialog gd = new GenericDialog("EDT...", (Frame)IJ.getInstance());
        gd.addNumericField("Threshold (1 to 255; value < thresh is background)", (double)this.thresh, 0);
        gd.addCheckbox("Inverse case (background when value >= thresh)", this.inverse);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.thresh = (int)gd.getNextNumber();
        this.inverse = gd.getNextBoolean();
        Prefs.set((String)"edtS1.thresh", (int)this.thresh);
        Prefs.set((String)"edtS1.inverse", (boolean)this.inverse);
        return true;
    }

    public boolean gotCancelled() {
        return this.cancelled;
    }

    class Step3Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        byte[][] data;

        public Step3Thread(int thread, int nThreads, int w, int h, int d, float[][] s, byte[][] data) {
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.s = s;
            this.data = data;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int noResult = 3 * (n + 1) * (n + 1);
            int[] tempInt = new int[n];
            int[] tempS = new int[n];
            for (int j = this.thread; j < this.h; j += this.nThreads) {
                IJ.showProgress((double)((double)j / (1.0 * (double)this.h)));
                for (int i = 0; i < this.w; ++i) {
                    int zStop;
                    int zStart;
                    int k;
                    boolean nonempty = false;
                    for (k = 0; k < this.d; ++k) {
                        tempS[k] = (int)this.s[k][i + this.w * j];
                        if (tempS[k] <= 0) continue;
                        nonempty = true;
                    }
                    if (!nonempty) continue;
                    for (zStart = 0; zStart < this.d - 1 && tempS[zStart] == 0; ++zStart) {
                    }
                    if (zStart > 0) {
                        --zStart;
                    }
                    for (zStop = this.d - 1; zStop > 0 && tempS[zStop] == 0; --zStop) {
                    }
                    if (zStop < this.d - 1) {
                        ++zStop;
                    }
                    for (k = 0; k < this.d; ++k) {
                        if (!((this.data[k][i + this.w * j] & 0xFF) >= EDT_S1D.this.thresh ^ EDT_S1D.this.inverse)) continue;
                        int min = noResult;
                        int zBegin = zStart;
                        int zEnd = zStop;
                        if (zBegin > k) {
                            zBegin = k;
                        }
                        if (zEnd < k) {
                            zEnd = k;
                        }
                        int delta = k - zBegin;
                        for (int z = zBegin; z <= zEnd; ++z) {
                            int test;
                            if ((test = tempS[z] + delta * delta--) >= min) continue;
                            min = test;
                        }
                        tempInt[k] = min;
                    }
                    for (k = 0; k < this.d; ++k) {
                        this.s[k][i + this.w * j] = tempInt[k];
                    }
                }
            }
        }
    }

    class Step2Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;

        public Step2Thread(int thread, int nThreads, int w, int h, int d, float[][] s) {
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.s = s;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int noResult = 3 * (n + 1) * (n + 1);
            int[] tempInt = new int[n];
            int[] tempS = new int[n];
            for (int k = this.thread; k < this.d; k += this.nThreads) {
                IJ.showProgress((double)((double)k / (1.0 * (double)this.d)));
                float[] sk = this.s[k];
                for (int i = 0; i < this.w; ++i) {
                    int j;
                    boolean nonempty = false;
                    for (j = 0; j < this.h; ++j) {
                        tempS[j] = (int)sk[i + this.w * j];
                        if (tempS[j] <= 0) continue;
                        nonempty = true;
                    }
                    if (!nonempty) continue;
                    for (j = 0; j < this.h; ++j) {
                        int min = noResult;
                        int delta = j;
                        for (int y = 0; y < this.h; ++y) {
                            int test;
                            if ((test = tempS[y] + delta * delta--) >= min) continue;
                            min = test;
                        }
                        tempInt[j] = min;
                    }
                    for (j = 0; j < this.h; ++j) {
                        sk[i + this.w * j] = tempInt[j];
                    }
                }
            }
        }
    }

    class Step1Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        int thresh;
        float[][] s;
        byte[][] data;

        public Step1Thread(int thread, int nThreads, int w, int h, int d, int thresh, float[][] s, byte[][] data) {
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.thresh = thresh;
            this.data = data;
            this.s = s;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int noResult = 3 * (n + 1) * (n + 1);
            boolean[] background = new boolean[n];
            for (int k = this.thread; k < this.d; k += this.nThreads) {
                IJ.showProgress((double)((double)k / (1.0 * (double)this.d)));
                float[] sk = this.s[k];
                byte[] dk = this.data[k];
                for (int j = 0; j < this.h; ++j) {
                    int i;
                    for (i = 0; i < this.w; ++i) {
                        background[i] = (dk[i + this.w * j] & 0xFF) < this.thresh ^ EDT_S1D.this.inverse;
                    }
                    for (i = 0; i < this.w; ++i) {
                        int test;
                        int x;
                        int min = noResult;
                        for (x = i; x < this.w; ++x) {
                            if (!background[x]) continue;
                            test = i - x;
                            test *= test;
                            min = test;
                            break;
                        }
                        for (x = i - 1; x >= 0; --x) {
                            if (!background[x]) continue;
                            test = i - x;
                            if ((test *= test) >= min) break;
                            min = test;
                            break;
                        }
                        sk[i + this.w * j] = min;
                    }
                }
            }
        }
    }
}

