/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.ometiff;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class TileIterator
implements Iterator<IntsKey> {
    final AtomicLong nTilesInQueue = new AtomicLong();
    final int maxTilesInQueue;
    final int nr;
    final int nt;
    final int nc;
    final int nz;
    final Map<Integer, Integer> resToNY;
    final Map<Integer, Integer> resToNX;
    int ir = 0;
    int it = 0;
    int ic = 0;
    int iz = 0;
    int iy = 0;
    int ix = -1;

    public TileIterator(int nr, int nt, int nc, int nz, Map<Integer, Integer> resToNY, Map<Integer, Integer> resToNX, int maxTilesInQueue) {
        this.nr = nr;
        this.nt = nt;
        this.nc = nc;
        this.nz = nz;
        this.resToNY = resToNY;
        this.resToNX = resToNX;
        this.maxTilesInQueue = maxTilesInQueue;
    }

    @Override
    public synchronized boolean hasNext() {
        boolean last = this.ir == this.nr - 1 && this.it == this.nt - 1 && this.ic == this.nc - 1 && this.iz == this.nz - 1 && this.iy == this.resToNY.get(this.ir) - 1 && this.ix == this.resToNX.get(this.ir) - 1;
        return !last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IntsKey next() {
        ++this.ix;
        if (this.ix == this.resToNX.get(this.ir)) {
            this.ix = 0;
            ++this.iy;
            if (this.iy == this.resToNY.get(this.ir)) {
                this.iy = 0;
                ++this.iz;
                if (this.iz == this.nz) {
                    this.iz = 0;
                    ++this.ic;
                    if (this.ic == this.nc) {
                        this.ic = 0;
                        ++this.it;
                        if (this.it == this.nt) {
                            this.it = 0;
                            ++this.ir;
                            if (this.ir == this.nr) {
                                return null;
                            }
                        }
                    }
                }
            }
        }
        while (this.nTilesInQueue.get() >= (long)this.maxTilesInQueue) {
            AtomicLong atomicLong = this.nTilesInQueue;
            synchronized (atomicLong) {
                try {
                    this.nTilesInQueue.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.nTilesInQueue.incrementAndGet();
        return new IntsKey(new int[]{this.ir, this.it, this.ic, this.iz, this.iy, this.ix});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementQueue() {
        this.nTilesInQueue.decrementAndGet();
        AtomicLong atomicLong = this.nTilesInQueue;
        synchronized (atomicLong) {
            this.nTilesInQueue.notifyAll();
        }
    }

    public static final class IntsKey {
        public final int[] array;

        public IntsKey(int[] array) {
            this.array = array;
        }

        public int[] getArray() {
            return (int[])this.array.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntsKey bytesKey = (IntsKey)o;
            return Arrays.equals(this.array, bytesKey.array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }
}

