/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.ometiff;

import java.util.HashSet;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

public class SourceToByteArray {
    public static <T> boolean validPixelType(T t) {
        HashSet<Class> validClasses = new HashSet<Class>();
        validClasses.add(UnsignedByteType.class);
        validClasses.add(UnsignedShortType.class);
        validClasses.add(ARGBType.class);
        validClasses.add(FloatType.class);
        return validClasses.contains(t.getClass());
    }

    public static <T> byte[] raiToByteArray(RandomAccessibleInterval<T> rai, T pixelInstance) {
        long nBytes = rai.dimension(0);
        for (int d = 1; d < rai.numDimensions(); ++d) {
            nBytes *= rai.dimension(d);
        }
        if (pixelInstance instanceof UnsignedByteType) {
            RealCursor c = Views.flatIterable(rai).cursor();
            if ((nBytes *= 1L) > Integer.MAX_VALUE) {
                System.err.println("Too many bytes during export!");
                return null;
            }
            byte[] out = new byte[(int)nBytes];
            int i = 0;
            while ((long)i < nBytes) {
                out[i] = ((UnsignedByteType)c.next()).getByte();
                ++i;
            }
            return out;
        }
        if (pixelInstance instanceof UnsignedShortType) {
            RealCursor c = Views.flatIterable(rai).cursor();
            if ((nBytes *= 2L) > Integer.MAX_VALUE) {
                System.err.println("Too many bytes during export!");
                return null;
            }
            byte[] out = new byte[(int)nBytes];
            int i = 0;
            while ((long)i < nBytes) {
                int value = ((UnsignedShortType)c.next()).get();
                out[i] = (byte)(value >>> 8);
                out[i + 1] = (byte)value;
                i += 2;
            }
            return out;
        }
        if (pixelInstance instanceof ARGBType) {
            RealCursor c = Views.flatIterable(rai).cursor();
            if ((nBytes *= 3L) > Integer.MAX_VALUE) {
                System.err.println("Too many bytes during export!");
                return null;
            }
            byte[] out = new byte[(int)nBytes];
            int i = 0;
            while ((long)i < nBytes) {
                int value = ((ARGBType)c.next()).get();
                out[i] = (byte)(value >>> 16);
                out[i + 1] = (byte)(value >>> 8);
                out[i + 2] = (byte)value;
                i += 3;
            }
            return out;
        }
        if (pixelInstance instanceof FloatType) {
            RealCursor c = Views.flatIterable(rai).cursor();
            if ((nBytes *= 4L) > Integer.MAX_VALUE) {
                System.err.println("Too many bytes during export!");
                return null;
            }
            byte[] out = new byte[(int)nBytes];
            int i = 0;
            while ((long)i < nBytes) {
                int intBits = Float.floatToIntBits(((FloatType)c.next()).get());
                out[i] = (byte)(intBits >>> 24);
                out[i + 1] = (byte)(intBits >>> 16);
                out[i + 2] = (byte)(intBits >>> 8);
                out[i + 3] = (byte)intBits;
                i += 4;
            }
            return out;
        }
        throw new UnsupportedOperationException("Unsupported pixel type of class " + pixelInstance.getClass().getName());
    }
}

