/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.ometiff;

import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.kheops.CZTRange;
import ch.epfl.biop.kheops.KheopsHelper;
import ch.epfl.biop.kheops.ometiff.AverageImageScaler;
import ch.epfl.biop.kheops.ometiff.SourceToByteArray;
import ch.epfl.biop.kheops.ometiff.TileIterator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import loci.common.image.IImageScaler;
import loci.formats.MetadataTools;
import loci.formats.in.OMETiffReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.IPyramidStore;
import loci.formats.meta.MetadataStore;
import loci.formats.out.OMETiffWriter;
import loci.formats.out.PyramidOMETiffWriter;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.display.ColorConverter;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import ome.codecs.CompressionType;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.meta.MetadataConverter;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import org.apache.commons.io.FilenameUtils;
import org.scijava.task.Task;
import org.scijava.task.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMETiffExporter<T extends NumericType<T>> {
    private static final Logger logger = LoggerFactory.getLogger(OMETiffExporter.class);
    final Map<Integer, Map<Integer, RandomAccessibleInterval<T>>> ctToRAI;
    final IMetadata oriMetadata;
    final int oriMetaDataSeries;
    final CZTRange range;
    final long tileX;
    final long tileY;
    final int nResolutionLevels;
    final int downsample;
    final String compression;
    final boolean compressTempFile;
    final File file;
    final int nThreads;
    final int dstSeries = 0;
    long totalTiles;
    final T pixelInstance;
    final int width;
    final int height;
    final int sizeT;
    final int sizeC;
    final int sizeZ;
    final Map<Integer, Integer> mapResToWidth = new HashMap<Integer, Integer>();
    final Map<Integer, Integer> mapResToHeight = new HashMap<Integer, Integer>();
    final Map<Integer, Integer> resToNY = new HashMap<Integer, Integer>();
    final Map<Integer, Integer> resToNX = new HashMap<Integer, Integer>();
    final boolean isLittleEndian;
    final boolean isRGB;
    final boolean isInterleaved;
    final boolean isFloat;
    final int bytesPerPixel;
    final AtomicLong writtenTiles = new AtomicLong();
    final Map<TileIterator.IntsKey, byte[]> computedBlocks;
    final TileIterator tileIterator;
    final Task writerTask;
    final Object tileLock = new Object();
    OMETiffWriter currentLevelWriter;
    final ThreadLocal<OMETiffReader> localReader = new ThreadLocal();
    final ThreadLocal<IImageScaler> localScaler = new ThreadLocal();
    final ThreadLocal<Integer> localResolution = new ThreadLocal();
    volatile int currentLevelWritten = -1;
    volatile boolean isCanceled = false;

    protected OMETiffExporter(Map<Integer, Map<Integer, RandomAccessibleInterval<T>>> ctToRAI, IMetadata originalOmeMeta, int originalSeries, OMETiffExporterBuilder.WriterOptions writerSettings) throws Exception {
        if (writerSettings.taskService != null) {
            this.writerTask = writerSettings.taskService.createTask("Writing: " + new File(writerSettings.path).getName());
            this.writerTask.setCancelCallBack(this::cancelExport);
        } else {
            this.writerTask = null;
        }
        this.ctToRAI = ctToRAI;
        this.oriMetadata = originalOmeMeta;
        this.oriMetaDataSeries = originalSeries;
        RandomAccessibleInterval<T> model = ctToRAI.get(0).get(0);
        this.pixelInstance = (NumericType)model.getAt(0, 0, 0);
        this.isRGB = this.pixelInstance instanceof ARGBType;
        this.isInterleaved = this.oriMetadata.getPixelsInterleaved(this.oriMetaDataSeries);
        this.isLittleEndian = false;
        if (this.pixelInstance instanceof UnsignedShortType) {
            this.bytesPerPixel = 2;
            this.isFloat = false;
        } else if (this.pixelInstance instanceof UnsignedByteType) {
            this.bytesPerPixel = 1;
            this.isFloat = false;
        } else if (this.pixelInstance instanceof FloatType) {
            this.bytesPerPixel = 4;
            this.isFloat = true;
        } else if (this.pixelInstance instanceof ARGBType) {
            this.bytesPerPixel = 1;
            this.isFloat = false;
        } else {
            throw new UnsupportedOperationException("Unhandled pixel type class: " + this.pixelInstance.getClass().getName());
        }
        this.width = (Integer)originalOmeMeta.getPixelsSizeX(originalSeries).getValue();
        this.height = (Integer)originalOmeMeta.getPixelsSizeY(originalSeries).getValue();
        int iniSizeZ = (Integer)originalOmeMeta.getPixelsSizeZ(originalSeries).getValue();
        int iniSizeT = (Integer)originalOmeMeta.getPixelsSizeT(originalSeries).getValue();
        int iniSizeC = (Integer)originalOmeMeta.getPixelsSizeC(originalSeries).getValue();
        this.range = CZTRange.builder().setC(writerSettings.rangeC).setT(writerSettings.rangeT).setZ(writerSettings.rangeZ).get(this.isRGB ? 1 : iniSizeC, iniSizeZ, iniSizeT);
        this.sizeC = this.range.getRangeC().size();
        this.sizeZ = this.range.getRangeZ().size();
        this.sizeT = this.range.getRangeT().size();
        logger.debug(writerSettings.path + " Exported image size: #C" + this.sizeC + "#Z" + this.sizeZ + "#T" + this.sizeT);
        this.mapResToWidth.put(0, this.width);
        this.mapResToHeight.put(0, this.height);
        for (int i = 0; i < writerSettings.nResolutions - 1; ++i) {
            this.mapResToWidth.put(i + 1, (int)((double)this.width / Math.pow(writerSettings.downSample, i + 1)));
            this.mapResToHeight.put(i + 1, (int)((double)this.height / Math.pow(writerSettings.downSample, i + 1)));
        }
        this.compressTempFile = writerSettings.compressTempFiles;
        this.downsample = writerSettings.downSample;
        this.nResolutionLevels = writerSettings.nResolutions;
        this.file = new File(writerSettings.path);
        this.compression = writerSettings.compression;
        this.nThreads = writerSettings.nThreads;
        int tempTileSizeX = writerSettings.tileX;
        int tempTileSizeY = writerSettings.tileY;
        if (this.width <= writerSettings.tileX && (tempTileSizeX = this.width) % 16 != 0) {
            tempTileSizeX += 16;
        }
        if (this.height <= writerSettings.tileY && (tempTileSizeY = this.height) % 16 != 0) {
            tempTileSizeY += 16;
        }
        this.tileX = tempTileSizeX < 16 ? 16L : (long)(Math.round((float)tempTileSizeX / 16.0f) * 16);
        this.tileY = tempTileSizeY < 16 ? 16L : (long)(Math.round((float)tempTileSizeY / 16.0f) * 16);
        for (int r = 0; r < writerSettings.nResolutions; ++r) {
            int maxY;
            int maxX;
            if (r != 0) {
                maxX = this.mapResToWidth.get(r);
                maxY = this.mapResToHeight.get(r);
            } else {
                maxX = this.width;
                maxY = this.height;
            }
            int nXTiles = (int)Math.ceil((double)maxX / (double)writerSettings.tileX);
            int nYTiles = (int)Math.ceil((double)maxY / (double)writerSettings.tileY);
            this.resToNX.put(r, nXTiles);
            this.resToNY.put(r, nYTiles);
        }
        this.writtenTiles.set(0L);
        this.tileIterator = new TileIterator(this.nResolutionLevels, this.sizeT, this.sizeC, this.sizeZ, this.resToNY, this.resToNX, writerSettings.maxTilesInQueue);
        this.computedBlocks = new ConcurrentHashMap<TileIterator.IntsKey, byte[]>(this.nThreads * 3 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExport() {
        this.isCanceled = true;
        Object object = this.tileLock;
        synchronized (object) {
            this.tileLock.notifyAll();
        }
    }

    private byte[] getBytesFromRAIs(TileIterator.IntsKey key) {
        int r = key.array[0];
        int t = key.array[1];
        int c = key.array[2];
        int z = key.array[3];
        int y = key.array[4];
        int x = key.array[5];
        long startX = (long)x * this.tileX;
        long startY = (long)y * this.tileY;
        long endX = (long)(x + 1) * this.tileX;
        long endY = (long)(y + 1) * this.tileY;
        int maxX = this.width;
        int maxY = this.height;
        if (endX > (long)maxX) {
            endX = maxX;
        }
        if (endY > (long)maxY) {
            endY = maxY;
        }
        RandomAccessibleInterval<T> rai = this.ctToRAI.get(this.range.getRangeC().get(c)).get(this.range.getRangeT().get(t));
        IntervalView<T> slice = Views.hyperSlice(rai, 2, (long)this.range.getRangeZ().get(z).intValue());
        return SourceToByteArray.raiToByteArray(Views.interval(slice, new FinalInterval(new long[]{startX, startY}, new long[]{endX - 1L, endY - 1L})), this.pixelInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTile(TileIterator.IntsKey key) throws Exception {
        int r = key.array[0];
        int t = key.array[1];
        int c = key.array[2];
        int z = key.array[3];
        int y = key.array[4];
        int x = key.array[5];
        long startX = (long)x * this.tileX;
        long startY = (long)y * this.tileY;
        if (r == 0) {
            this.localResolution.set(r);
            this.computedBlocks.put(key, this.getBytesFromRAIs(key));
        } else {
            while (r != this.currentLevelWritten && !this.isCanceled) {
                Object object = this.tileLock;
                synchronized (object) {
                    this.tileLock.wait();
                }
            }
            if (!this.isCanceled) {
                long effTileSizeY;
                if (this.localResolution.get() == null || this.localResolution.get() != r) {
                    if (this.localReader.get() != null) {
                        this.localReader.get().close();
                        logger.debug("Local reader of " + this.file.getName() + " closed.");
                    } else {
                        this.localScaler.set(new AverageImageScaler());
                    }
                    OMETiffReader reader = new OMETiffReader();
                    IMetadata omeMeta = MetadataTools.createOMEXMLMetadata();
                    reader.setMetadataStore((MetadataStore)omeMeta);
                    reader.setId(this.getFileName(r - 1));
                    reader.setSeries(0);
                    this.localReader.set(reader);
                    this.localResolution.set(r);
                }
                int plane = t * this.sizeZ * this.sizeC + c * this.sizeZ + z;
                long effTileSizeX = this.tileX * (long)this.downsample;
                if (startX * (long)this.downsample + effTileSizeX >= (long)this.mapResToWidth.get(r - 1).intValue()) {
                    effTileSizeX = (long)this.mapResToWidth.get(r - 1).intValue() - startX * (long)this.downsample;
                }
                if (startY * (long)this.downsample + (effTileSizeY = this.tileY * (long)this.downsample) >= (long)this.mapResToHeight.get(r - 1).intValue()) {
                    effTileSizeY = (long)this.mapResToHeight.get(r - 1).intValue() - startY * (long)this.downsample;
                }
                byte[] tileBytePreviousLevel = this.localReader.get().openBytes(plane, (int)(startX * (long)this.downsample), (int)(startY * (long)this.downsample), (int)effTileSizeX, (int)effTileSizeY);
                byte[] tileByte = this.localScaler.get().downsample(tileBytePreviousLevel, (int)effTileSizeX, (int)effTileSizeY, (double)this.downsample, this.bytesPerPixel, this.isLittleEndian, this.isFloat, this.isRGB ? 3 : 1, false);
                this.computedBlocks.put(key, tileByte);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean computeNextTile() throws Exception {
        TileIterator.IntsKey key = null;
        Object object = this.tileIterator;
        synchronized (object) {
            if (this.tileIterator.hasNext()) {
                key = this.tileIterator.next();
            }
        }
        if (key == null) {
            object = this.tileLock;
            synchronized (object) {
                this.tileLock.notifyAll();
            }
            if (this.localReader.get() != null) {
                this.localReader.get().close();
                logger.debug("Local reader of " + this.file.getName() + " closed.");
            }
            return false;
        }
        if (this.isCanceled) {
            if (this.localReader.get() != null) {
                this.localReader.get().close();
                logger.debug(this.file.getAbsolutePath() + "\t Thread " + Thread.currentThread() + " local reader closed.");
            }
            return false;
        }
        this.computeTile(key);
        object = this.tileLock;
        synchronized (object) {
            this.tileLock.notifyAll();
        }
        return true;
    }

    private void copyChannelsMeta(IMetadata metaDst, int seriesDst, IMetadata metaSrc, int seriesSrc) {
        if (this.isRGB) {
            MetadataConverter.convertChannels((MetadataRetrieve)metaSrc, (int)seriesSrc, (int)0, (ome.xml.meta.MetadataStore)metaDst, (int)seriesDst, (int)0, (boolean)true);
        } else {
            for (int c = 0; c < this.sizeC; ++c) {
                int srcC = this.range.getRangeC().get(c);
                MetadataConverter.convertChannels((MetadataRetrieve)metaSrc, (int)seriesSrc, (int)srcC, (ome.xml.meta.MetadataStore)metaDst, (int)seriesDst, (int)c, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() throws Exception {
        try {
            int r;
            if (this.writerTask != null) {
                this.writerTask.setStatusMessage("Exporting " + this.file.getName() + " with " + this.nThreads + " threads.");
            }
            IMetadata omeMeta = MetadataTools.createOMEXMLMetadata();
            IMetadata currentLevelOmeMeta = MetadataTools.createOMEXMLMetadata();
            MetadataTools.populateMetadata((MetadataStore)omeMeta, (int)0, (String)this.oriMetadata.getImageName(this.oriMetaDataSeries), (boolean)this.isLittleEndian, (String)(this.isRGB ? DimensionOrder.XYCZT.getValue() : DimensionOrder.XYZCT.getValue()), (String)this.oriMetadata.getPixelsType(this.oriMetaDataSeries).toString(), (int)this.width, (int)this.height, (int)this.range.getRangeZ().size(), (int)(this.isRGB ? 3 : this.range.getRangeC().size()), (int)this.range.getRangeT().size(), (int)((Integer)this.oriMetadata.getChannelSamplesPerPixel(this.oriMetaDataSeries, 0).getValue()));
            omeMeta.setPixelsInterleaved(this.oriMetadata.getPixelsInterleaved(this.oriMetaDataSeries), 0);
            MetadataTools.verifyMinimumPopulated((loci.formats.meta.MetadataRetrieve)omeMeta, (int)0);
            MetadataTools.populateMetadata((MetadataStore)currentLevelOmeMeta, (int)0, (String)this.oriMetadata.getImageName(this.oriMetaDataSeries), (boolean)this.isLittleEndian, (String)(this.isRGB ? DimensionOrder.XYCZT.getValue() : DimensionOrder.XYZCT.getValue()), (String)this.oriMetadata.getPixelsType(this.oriMetaDataSeries).toString(), (int)this.width, (int)this.height, (int)this.range.getRangeZ().size(), (int)(this.isRGB ? 3 : this.range.getRangeC().size()), (int)this.range.getRangeT().size(), (int)((Integer)this.oriMetadata.getChannelSamplesPerPixel(this.oriMetaDataSeries, 0).getValue()));
            omeMeta.setPixelsInterleaved(this.oriMetadata.getPixelsInterleaved(this.oriMetaDataSeries), 0);
            MetadataTools.verifyMinimumPopulated((loci.formats.meta.MetadataRetrieve)currentLevelOmeMeta, (int)0);
            KheopsHelper.transferSeriesMeta((MetadataRetrieve)this.oriMetadata, this.oriMetaDataSeries, (ome.xml.meta.MetadataStore)omeMeta, this.dstSeries);
            MetadataConverter.convertMetadata((MetadataRetrieve)omeMeta, (ome.xml.meta.MetadataStore)currentLevelOmeMeta);
            this.copyChannelsMeta(omeMeta, this.dstSeries, this.oriMetadata, this.oriMetaDataSeries);
            this.copyChannelsMeta(currentLevelOmeMeta, this.dstSeries, this.oriMetadata, this.oriMetaDataSeries);
            for (int r2 = 0; r2 < this.nResolutionLevels - 1; ++r2) {
                ((IPyramidStore)omeMeta).setResolutionSizeX(new PositiveInteger(this.mapResToWidth.get(r2 + 1)), 0, r2 + 1);
                ((IPyramidStore)omeMeta).setResolutionSizeY(new PositiveInteger(this.mapResToHeight.get(r2 + 1)), 0, r2 + 1);
            }
            PyramidOMETiffWriter writer = new PyramidOMETiffWriter();
            writer.setMetadataRetrieve((loci.formats.meta.MetadataRetrieve)omeMeta);
            writer.setWriteSequentially(true);
            writer.setBigTiff(true);
            writer.setId(this.file.getAbsolutePath());
            writer.setSeries(0);
            writer.setCompression(this.compression);
            writer.setTileSizeX((int)this.tileX);
            writer.setTileSizeY((int)this.tileY);
            writer.setInterleaved(omeMeta.getPixelsInterleaved(0).booleanValue());
            this.totalTiles = 0L;
            for (r = 0; r < this.nResolutionLevels; ++r) {
                int nXTiles = (int)Math.ceil((double)this.mapResToWidth.get(r).intValue() / (double)this.tileX);
                int nYTiles = (int)Math.ceil((double)this.mapResToHeight.get(r).intValue() / (double)this.tileY);
                this.totalTiles += (long)(nXTiles * nYTiles);
            }
            this.totalTiles *= (long)(this.sizeT * this.sizeC * this.sizeZ);
            if (this.writerTask != null) {
                this.writerTask.setProgressMaximum(this.totalTiles);
            }
            for (int i = 0; i < this.nThreads; ++i) {
                logger.debug(this.file.getName() + " Export: Starting " + this.nThreads + " threads.");
                new Thread(() -> {
                    try {
                        while (this.computeNextTile()) {
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    logger.debug(this.file.getAbsolutePath() + "\t Thread " + Thread.currentThread() + " stopped.");
                }).start();
            }
            for (r = 0; r < this.nResolutionLevels; ++r) {
                Object unitX;
                int maxX = this.mapResToWidth.get(r);
                int maxY = this.mapResToHeight.get(r);
                int nXTiles = (int)Math.ceil((double)maxX / (double)this.tileX);
                int nYTiles = (int)Math.ceil((double)maxY / (double)this.tileY);
                if (r < this.nResolutionLevels - 1) {
                    this.currentLevelWriter = new OMETiffWriter();
                    this.currentLevelWriter.setWriteSequentially(true);
                    currentLevelOmeMeta.setPixelsSizeX(new PositiveInteger(Integer.valueOf(maxX)), 0);
                    currentLevelOmeMeta.setPixelsSizeY(new PositiveInteger(Integer.valueOf(maxY)), 0);
                    unitX = UNITS.REFERENCEFRAME;
                    double pixPhysicalSizeX = 1.0;
                    if (omeMeta.getPixelsPhysicalSizeX(this.oriMetaDataSeries) != null) {
                        if (omeMeta.getPixelsPhysicalSizeX(this.oriMetaDataSeries).value() != null) {
                            pixPhysicalSizeX = omeMeta.getPixelsPhysicalSizeX(this.oriMetaDataSeries).value().doubleValue();
                        } else {
                            logger.warn("UNSPECIFIED PIXEL SIZE IN X, please set it (override pixel size)");
                        }
                        if (omeMeta.getPixelsPhysicalSizeX(this.oriMetaDataSeries).unit() != null) {
                            unitX = omeMeta.getPixelsPhysicalSizeX(this.oriMetaDataSeries).unit();
                        } else {
                            logger.warn("UNSPECIFIED PIXEL UNIT IN X, please set it (override pixel size)");
                        }
                    } else {
                        logger.warn("UNSPECIFIED PIXEL SIZE IN X, please set it (override pixel size)");
                    }
                    currentLevelOmeMeta.setPixelsPhysicalSizeX(new Length((Number)(pixPhysicalSizeX * Math.pow(this.downsample, r + 1)), (Unit)unitX), 0);
                    Unit unitY = UNITS.REFERENCEFRAME;
                    double pixPhysicalSizeY = 1.0;
                    if (omeMeta.getPixelsPhysicalSizeY(this.oriMetaDataSeries) != null) {
                        if (omeMeta.getPixelsPhysicalSizeY(this.oriMetaDataSeries).value() != null) {
                            pixPhysicalSizeY = omeMeta.getPixelsPhysicalSizeY(this.oriMetaDataSeries).value().doubleValue();
                        } else {
                            logger.warn("UNSPECIFIED PIXEL SIZE IN Y, please set it (override pixel size)");
                        }
                        if (omeMeta.getPixelsPhysicalSizeY(this.oriMetaDataSeries).unit() != null) {
                            unitY = omeMeta.getPixelsPhysicalSizeY(this.oriMetaDataSeries).unit();
                        } else {
                            logger.warn("UNSPECIFIED PIXEL UNIT IN Y, please set it (override pixel size)");
                        }
                    } else {
                        logger.warn("UNSPECIFIED PIXEL SIZE IN Y, please set it (override pixel size)");
                    }
                    currentLevelOmeMeta.setPixelsPhysicalSizeY(new Length((Number)(pixPhysicalSizeY * Math.pow(this.downsample, r + 1)), unitY), 0);
                    currentLevelOmeMeta.setPixelsDimensionOrder(DimensionOrder.XYCZT, 0);
                    this.currentLevelWriter.setMetadataRetrieve((loci.formats.meta.MetadataRetrieve)currentLevelOmeMeta);
                    this.currentLevelWriter.setBigTiff(true);
                    this.currentLevelWriter.setId(this.getFileName(r));
                    this.currentLevelWriter.setSeries(0);
                    if (this.compressTempFile) {
                        this.currentLevelWriter.setCompression(CompressionType.LZW.getCompression());
                    }
                    this.currentLevelWriter.setTileSizeX((int)this.tileX);
                    this.currentLevelWriter.setTileSizeY((int)this.tileY);
                    if (r == 0) {
                        this.currentLevelWriter.setInterleaved(true);
                    } else {
                        this.currentLevelWriter.setInterleaved(false);
                    }
                }
                if (r > 0) {
                    writer.setInterleaved(false);
                }
                logger.debug("Saving resolution size " + r);
                writer.setResolution(r);
                this.currentLevelWritten = r;
                unitX = this.tileLock;
                synchronized (unitX) {
                    this.tileLock.notifyAll();
                }
                block18: for (int t = 0; t < this.sizeT; ++t) {
                    for (int c = 0; c < this.sizeC; ++c) {
                        for (int z = 0; z < this.sizeZ; ++z) {
                            int plane = t * this.sizeZ * this.sizeC + c * this.sizeZ + z;
                            if (r == 0) {
                                int oriC = this.range.getRangeC().get(c);
                                int oriZ = this.range.getRangeZ().get(z);
                                int oriT = this.range.getRangeT().get(t);
                                int oriPlane = this.getOriginalPlaneIndex(oriC, oriZ, oriT);
                                omeMeta.setPlaneTheC(new NonNegativeInteger(Integer.valueOf(c)), 0, plane);
                                omeMeta.setPlaneTheZ(new NonNegativeInteger(Integer.valueOf(z)), 0, plane);
                                omeMeta.setPlaneTheT(new NonNegativeInteger(Integer.valueOf(t)), 0, plane);
                                KheopsHelper.transferPlaneMeta((MetadataRetrieve)this.oriMetadata, this.oriMetaDataSeries, oriPlane, (ome.xml.meta.MetadataStore)omeMeta, 0, plane);
                            }
                            for (int y = 0; y < nYTiles; ++y) {
                                for (int x = 0; x < nXTiles; ++x) {
                                    long startX = (long)x * this.tileX;
                                    long startY = (long)y * this.tileY;
                                    long endX = (long)(x + 1) * this.tileX;
                                    long endY = (long)(y + 1) * this.tileY;
                                    if (endX > (long)maxX) {
                                        endX = maxX;
                                    }
                                    if (endY > (long)maxY) {
                                        endY = maxY;
                                    }
                                    TileIterator.IntsKey key = new TileIterator.IntsKey(new int[]{r, t, c, z, y, x});
                                    if (this.nThreads == 0) {
                                        this.computeTile(key);
                                        if (this.isCanceled) {
                                            break block18;
                                        }
                                    } else {
                                        while (!this.computedBlocks.containsKey(key)) {
                                            Object object = this.tileLock;
                                            synchronized (object) {
                                                this.tileLock.wait();
                                            }
                                            if (!this.isCanceled) continue;
                                            break block18;
                                        }
                                    }
                                    if (r < this.nResolutionLevels - 1) {
                                        this.currentLevelWriter.saveBytes(plane, this.computedBlocks.get(key), (int)startX, (int)startY, (int)(endX - startX), (int)(endY - startY));
                                    }
                                    writer.saveBytes(plane, this.computedBlocks.get(key), (int)startX, (int)startY, (int)(endX - startX), (int)(endY - startY));
                                    this.computedBlocks.remove(key);
                                    this.tileIterator.decrementQueue();
                                    if (this.writerTask == null) continue;
                                    this.writerTask.setProgressValue(this.writtenTiles.incrementAndGet());
                                }
                            }
                        }
                    }
                }
                if (r >= this.nResolutionLevels - 1) continue;
                this.currentLevelWriter.close();
            }
            if (this.nThreads == 0) {
                if (this.writerTask != null) {
                    this.writerTask.setStatusMessage("Closing readers.");
                }
                if (this.localReader.get() != null) {
                    this.localReader.get().close();
                    logger.debug("Local reader of " + this.file.getName() + " closed.");
                }
            }
            if (this.writerTask != null) {
                this.writerTask.setStatusMessage("Deleting temporary files.");
            }
            for (r = 0; r < this.nResolutionLevels - 1; ++r) {
                boolean result = new File(this.getFileName(r)).delete();
                if (result) continue;
                logger.warn("File " + this.getFileName(r) + " couldn't be deleted.");
            }
            this.computedBlocks.clear();
            if (this.writerTask != null) {
                int estimateTimeMin = (int)((double)(5L * this.totalTiles) / 100000.0);
                if (estimateTimeMin < 2) {
                    this.writerTask.setStatusMessage("Closing writer... please wait a few minutes.");
                } else {
                    this.writerTask.setStatusMessage("Closing writer... please wait, this can take around " + estimateTimeMin + " minutes.");
                }
            }
            try {
                writer.close();
                logger.debug("Writer of " + this.file.getName() + " closed.");
            }
            catch (Exception e) {
                if (this.isCanceled) {
                    logger.error("Error during cancellation: " + e.getMessage());
                } else {
                    e.printStackTrace();
                }
            }
            finally {
                boolean result;
                if (this.isCanceled && !(result = new File(this.file.getAbsolutePath()).delete())) {
                    logger.warn("Cancellation: could not delete file " + this.file.getAbsolutePath());
                }
            }
        }
        finally {
            if (this.writerTask != null) {
                this.writerTask.finish();
            }
        }
    }

    private int getOriginalPlaneIndex(int oriC, int oriZ, int oriT) {
        switch (this.oriMetadata.getPixelsDimensionOrder(this.oriMetaDataSeries)) {
            case XYZCT: {
                return oriT * this.sizeC * this.sizeZ + oriC * this.sizeZ + oriZ;
            }
            case XYZTC: {
                return oriC * this.sizeT * this.sizeZ + oriT * this.sizeZ + oriZ;
            }
            case XYCTZ: {
                return oriZ * this.sizeT * this.sizeC + oriT * this.sizeC + oriC;
            }
            case XYCZT: {
                return oriT * this.sizeZ * this.sizeC + oriZ * this.sizeC + oriC;
            }
            case XYTCZ: {
                return oriZ * this.sizeC * this.sizeT + oriC * this.sizeT + oriT;
            }
            case XYTZC: {
                return oriC * this.sizeZ * this.sizeT + oriZ * this.sizeT + oriT;
            }
        }
        throw new IllegalArgumentException("Unknown dimension order " + this.oriMetadata.getPixelsDimensionOrder(this.oriMetaDataSeries));
    }

    private String getFileName(int r) {
        return FilenameUtils.removeExtension((String)this.file.getAbsolutePath()) + "_lvl_" + r + ".ome.tiff";
    }

    public static OMETiffExporterBuilder.Data.DataBuilder builder() {
        return OMETiffExporterBuilder.defineData();
    }

    public static class OMETiffExporterBuilder {
        public static Data.DataBuilder defineData() {
            return new Data.DataBuilder();
        }

        public static class WriterOptions {
            public final int nThreads;
            public final String rangeC;
            public final String rangeZ;
            public final String rangeT;
            public final String path;
            public final int tileX;
            public final int tileY;
            public final String compression;
            public final boolean compressTempFiles;
            public final int maxTilesInQueue;
            public final TaskService taskService;
            public final int nResolutions;
            public final int downSample;

            private WriterOptions(WriterOptionsBuilder builder) {
                this.nThreads = builder.nThreads;
                this.rangeC = builder.rangeC;
                this.rangeZ = builder.rangeZ;
                this.rangeT = builder.rangeT;
                this.path = builder.filePath;
                this.tileX = builder.tileX;
                this.tileY = builder.tileY;
                this.compression = builder.compression;
                this.compressTempFiles = builder.compressTempFiles;
                this.maxTilesInQueue = builder.maxTilesInQueue;
                this.taskService = builder.taskService;
                this.nResolutions = builder.nResolutions;
                this.downSample = builder.downSample;
            }

            public static class WriterOptionsBuilder {
                final Data data;
                final MetaData metaData;
                int nThreads = Runtime.getRuntime().availableProcessors();
                String rangeC = "";
                String rangeZ = "";
                String rangeT = "";
                String filePath = "";
                int tileX = 512;
                int tileY = 512;
                String compression = "LZW";
                boolean compressTempFiles = true;
                int maxTilesInQueue = 60;
                TaskService taskService = null;
                int nResolutions = 1;
                int downSample = 2;

                public WriterOptionsBuilder(MetaData metaData, Data data) {
                    this.data = data;
                    this.metaData = metaData;
                }

                public WriterOptionsBuilder nThreads(int nThreads) {
                    this.nThreads = nThreads;
                    return this;
                }

                public WriterOptionsBuilder rangeC(String rangeC) {
                    this.rangeC = rangeC;
                    return this;
                }

                public WriterOptionsBuilder rangeZ(String rangeZ) {
                    this.rangeZ = rangeZ;
                    return this;
                }

                public WriterOptionsBuilder rangeT(String rangeT) {
                    this.rangeT = rangeT;
                    return this;
                }

                public WriterOptionsBuilder tileSize(int tileX, int tileY) {
                    this.tileX = tileX;
                    this.tileY = tileY;
                    return this;
                }

                public WriterOptionsBuilder downsample(int downsample) {
                    this.downSample = downsample;
                    return this;
                }

                public WriterOptionsBuilder nResolutionLevels(int nResolutions) {
                    this.nResolutions = nResolutions;
                    return this;
                }

                public WriterOptionsBuilder lzw() {
                    this.compression = CompressionType.LZW.getCompression();
                    return this;
                }

                public WriterOptionsBuilder j2k() {
                    this.compression = CompressionType.J2K.getCompression();
                    return this;
                }

                public WriterOptionsBuilder j2kLossy() {
                    this.compression = CompressionType.J2K_LOSSY.getCompression();
                    return this;
                }

                public WriterOptionsBuilder jpg() {
                    this.compression = CompressionType.JPEG.getCompression();
                    return this;
                }

                public WriterOptionsBuilder monitor(TaskService taskService) {
                    this.taskService = taskService;
                    return this;
                }

                public WriterOptionsBuilder maxTilesInQueue(int max) {
                    this.maxTilesInQueue = max;
                    return this;
                }

                public WriterOptionsBuilder compression(String compression) {
                    this.compression = compression;
                    return this;
                }

                public WriterOptionsBuilder compression(int code) {
                    this.compression = CompressionType.get((int)code).getCompression();
                    return this;
                }

                public WriterOptionsBuilder compressTemporaryFiles(boolean compressTempFile) {
                    this.compressTempFiles = compressTempFile;
                    return this;
                }

                public WriterOptionsBuilder savePath(String path) {
                    this.filePath = path;
                    return this;
                }

                public OMETiffExporter create() throws Exception {
                    if (this.filePath == null || this.filePath.trim().equals("")) {
                        throw new IOException("Invalid path file");
                    }
                    if (new File(this.filePath).exists()) {
                        throw new IOException("Path " + this.filePath + " already exists");
                    }
                    if (!this.filePath.endsWith(".ome.tiff") && !this.filePath.endsWith(".ome.tif")) {
                        System.out.println("Warning: You try to export an ome tiff file but did not specify an '.ome.tiff' extension.");
                    }
                    WriterOptions wOpts = new WriterOptions(this);
                    Map map = this.data.ctToRAI;
                    IMetadata iMetadata = this.metaData.omeMeta;
                    this.metaData.getClass();
                    return new OMETiffExporter(map, iMetadata, 0, wOpts);
                }
            }
        }

        public static class MetaData {
            public final int series = 0;
            public final IMetadata omeMeta;

            private MetaData(MetaDataBuilder builder) {
                this.omeMeta = builder.omeMeta;
            }

            public static class MetaDataBuilder {
                final int series = 0;
                IMetadata omeMeta;
                final Data data;
                final boolean isRGB;

                public MetaDataBuilder(Data data, String imageName) {
                    String dimensionOrder;
                    int samplePerPixel;
                    String pixelType;
                    this.data = data;
                    this.omeMeta = MetadataTools.createOMEXMLMetadata();
                    if (data.pixelInstance instanceof UnsignedShortType) {
                        pixelType = PixelType.UINT16.toString();
                        samplePerPixel = 1;
                        this.isRGB = false;
                        dimensionOrder = DimensionOrder.XYZCT.getValue();
                    } else if (data.pixelInstance instanceof UnsignedByteType) {
                        pixelType = PixelType.UINT8.toString();
                        samplePerPixel = 1;
                        this.isRGB = false;
                        dimensionOrder = DimensionOrder.XYZCT.getValue();
                    } else if (data.pixelInstance instanceof FloatType) {
                        pixelType = PixelType.FLOAT.toString();
                        samplePerPixel = 1;
                        this.isRGB = false;
                        dimensionOrder = DimensionOrder.XYZCT.getValue();
                    } else if (data.pixelInstance instanceof ARGBType) {
                        pixelType = PixelType.UINT8.toString();
                        samplePerPixel = 3;
                        this.isRGB = true;
                        dimensionOrder = DimensionOrder.XYCZT.getValue();
                    } else {
                        throw new UnsupportedOperationException("Unhandled pixel type class: " + data.pixelInstance.getClass().getName());
                    }
                    MetadataTools.populateMetadata((MetadataStore)this.omeMeta, (int)0, (String)imageName, (boolean)true, (String)dimensionOrder, (String)pixelType, (int)data.pixelsSizeX, (int)data.pixelsSizeY, (int)data.pixelsSizeZ, (int)(this.isRGB ? data.pixelsSizeC * 3 : data.pixelsSizeC), (int)data.pixelsSizeT, (int)samplePerPixel);
                    if (this.isRGB) {
                        this.omeMeta.setChannelID("Channel:0", 0, 0);
                        this.omeMeta.setChannelName("Channel_0", 0, 0);
                        this.omeMeta.setPixelsInterleaved(Boolean.valueOf(true), 0);
                    } else {
                        this.omeMeta.setPixelsInterleaved(Boolean.valueOf(false), 0);
                        for (int c = 0; c < data.pixelsSizeC; ++c) {
                            this.omeMeta.setChannelID("Channel:0:" + c, 0, c);
                            this.omeMeta.setChannelName("Channel_" + c, 0, c);
                            this.omeMeta.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(1)), 0, c);
                            this.omeMeta.setChannelColor(new Color(255, 255, 255, 255), 0, c);
                        }
                    }
                    this.omeMeta.setPixelsPhysicalSizeX(new Length((Number)1, UNITS.REFERENCEFRAME), 0);
                    this.omeMeta.setPixelsPhysicalSizeY(new Length((Number)1, UNITS.REFERENCEFRAME), 0);
                    this.omeMeta.setPixelsPhysicalSizeZ(new Length((Number)1, UNITS.REFERENCEFRAME), 0);
                }

                public MetaDataBuilder imageName(String imageName) {
                    this.omeMeta.setImageName(imageName, 0);
                    return this;
                }

                public MetaDataBuilder channelName(int channel, String channelName) {
                    this.omeMeta.setChannelID("Channel:0:" + channel, 0, channel);
                    this.omeMeta.setChannelName(channelName, 0, channel);
                    return this;
                }

                public MetaDataBuilder channelColor(int channel, int r, int g, int b, int a) {
                    this.omeMeta.setChannelColor(new Color(r, g, b, a), 0, channel);
                    return this;
                }

                public MetaDataBuilder applyOnMeta(Function<IMetadata, IMetadata> f) {
                    this.omeMeta = f.apply(this.omeMeta);
                    return this;
                }

                public MetaDataBuilder planePosition(Length originX, Length originY, Length originZ, int planeIndex) {
                    this.omeMeta.setPlanePositionX(originX, 0, planeIndex);
                    this.omeMeta.setPlanePositionY(originY, 0, planeIndex);
                    this.omeMeta.setPlanePositionZ(originZ, 0, planeIndex);
                    return this;
                }

                public MetaDataBuilder planePositionMicrometer(double originX, double originY, double originZ, int planeIndex) {
                    return this.planePosition(new Length((Number)originX, UNITS.MICROMETER), new Length((Number)originY, UNITS.MICROMETER), new Length((Number)originZ, UNITS.MICROMETER), planeIndex);
                }

                public MetaDataBuilder planePositionMillimeter(double originX, double originY, double originZ, int planeIndex) {
                    return this.planePosition(new Length((Number)originX, UNITS.MILLIMETER), new Length((Number)originY, UNITS.MILLIMETER), new Length((Number)originZ, UNITS.MILLIMETER), planeIndex);
                }

                public MetaDataBuilder pixelsTimeIncrementInS(double timeInS) {
                    this.omeMeta.setPixelsTimeIncrement(new Time((Number)timeInS, UNITS.SECOND), 0);
                    return this;
                }

                public MetaDataBuilder voxelPhysicalSize(Length physicalSizeX, Length physicalSizeY, Length physicalSizeZ) {
                    this.omeMeta.setPixelsPhysicalSizeX(physicalSizeX, 0);
                    this.omeMeta.setPixelsPhysicalSizeY(physicalSizeY, 0);
                    this.omeMeta.setPixelsPhysicalSizeZ(physicalSizeZ, 0);
                    return this;
                }

                public MetaDataBuilder voxelPhysicalSizeMicrometer(double physicalSizeXInMicrometer, double physicalSizeYInMicrometer, double physicalSizeZInMicrometer) {
                    return this.voxelPhysicalSize(new Length((Number)physicalSizeXInMicrometer, UNITS.MICROMETER), new Length((Number)physicalSizeYInMicrometer, UNITS.MICROMETER), new Length((Number)physicalSizeZInMicrometer, UNITS.MICROMETER));
                }

                public MetaDataBuilder voxelPhysicalSizeMillimeter(double physicalSizeXInMillimeter, double physicalSizeYInMillimeter, double physicalSizeZInMillimeter) {
                    return this.voxelPhysicalSize(new Length((Number)physicalSizeXInMillimeter, UNITS.MILLIMETER), new Length((Number)physicalSizeYInMillimeter, UNITS.MILLIMETER), new Length((Number)physicalSizeZInMillimeter, UNITS.MILLIMETER));
                }

                public WriterOptions.WriterOptionsBuilder defineWriteOptions() {
                    return new WriterOptions.WriterOptionsBuilder(new MetaData(this), this.data);
                }

                public MetaDataBuilder putMetadataFromSources(SourceAndConverter<?> sac, Unit<Length> unit) {
                    return this.putMetadataFromSources(new SourceAndConverter[]{sac}, unit);
                }

                public MetaDataBuilder putMetadataFromSources(SourceAndConverter<?>[] sacs, Unit<Length> unit) {
                    Source[] sources = new Source[sacs.length];
                    for (int i = 0; i < sacs.length; ++i) {
                        sources[i] = sacs[i].getSpimSource();
                    }
                    this.putMetadataFromSources(sources, unit);
                    int sizeC = sources.length;
                    for (int c = 0; c < sizeC; ++c) {
                        if (!(sacs[c].getConverter() instanceof ColorConverter)) continue;
                        int colorCode = ((ColorConverter)((Object)sacs[c].getConverter())).getColor().get();
                        int colorRed = ARGBType.red(colorCode);
                        int colorGreen = ARGBType.green(colorCode);
                        int colorBlue = ARGBType.blue(colorCode);
                        int colorAlpha = ARGBType.alpha(colorCode);
                        this.channelColor(c, colorRed, colorGreen, colorBlue, colorAlpha);
                    }
                    return this;
                }

                public MetaDataBuilder putMetadataFromSources(Source<?>[] sources, Unit<Length> unit) {
                    AffineTransform3D mat = new AffineTransform3D();
                    Source<?> model = sources[0];
                    model.getSourceTransform(0, 0, mat);
                    double[] m = mat.getRowPackedCopy();
                    double[] voxelSizes = new double[3];
                    for (int d = 0; d < 3; ++d) {
                        voxelSizes[d] = Math.sqrt(m[d] * m[d] + m[d + 4] * m[d + 4] + m[d + 8] * m[d + 8]);
                    }
                    this.voxelPhysicalSize(new Length((Number)voxelSizes[0], unit), new Length((Number)voxelSizes[1], unit), new Length((Number)voxelSizes[2], unit));
                    RealPoint origin = new RealPoint(3);
                    mat.apply((RealLocalizable)origin, (RealPositionable)origin);
                    this.planePosition(new Length((Number)origin.getDoublePosition(0), unit), new Length((Number)origin.getDoublePosition(1), unit), new Length((Number)origin.getDoublePosition(2), unit), 0);
                    return this;
                }
            }
        }

        public static class Data<T> {
            protected final int pixelsSizeX;
            protected final int pixelsSizeY;
            protected final int pixelsSizeZ;
            protected final int pixelsSizeC;
            protected final int pixelsSizeT;
            protected final Map<Integer, Map<Integer, RandomAccessibleInterval<T>>> ctToRAI;
            protected final T pixelInstance;

            private Data(DataBuilder<T> builder) {
                this.pixelsSizeX = ((DataBuilder)builder).nPixelX;
                this.pixelsSizeY = ((DataBuilder)builder).nPixelY;
                this.pixelsSizeZ = ((DataBuilder)builder).nPixelZ;
                this.pixelsSizeC = ((DataBuilder)builder).nChannels;
                this.pixelsSizeT = ((DataBuilder)builder).nTimePoints;
                this.ctToRAI = ((DataBuilder)builder).ctToRAI;
                this.pixelInstance = builder.pixelInstance;
            }

            public static class DataBuilder<T> {
                private int nPixelX = -1;
                private int nPixelY = -1;
                private int nPixelZ = -1;
                private int nChannels = -1;
                private int nTimePoints = -1;
                private final Map<Integer, Map<Integer, RandomAccessibleInterval<T>>> ctToRAI = new HashMap<Integer, Map<Integer, RandomAccessibleInterval<T>>>();
                T pixelInstance;

                public DataBuilder<T> put(int channel, Source<T> source) throws UnsupportedOperationException {
                    int t = 0;
                    while (source.isPresent(t)) {
                        this.putXYZRAI(channel, t, source.getSource(t, 0));
                        ++t;
                    }
                    return this;
                }

                public DataBuilder<T> put(Source<T> source) throws UnsupportedOperationException {
                    return this.put(0, source);
                }

                public DataBuilder<T> put(SourceAndConverter<T>[] sources) throws UnsupportedOperationException {
                    for (int c = 0; c < sources.length; ++c) {
                        this.put(c, sources[c]);
                    }
                    return this;
                }

                public DataBuilder<T> put(int c, SourceAndConverter<T> source) throws UnsupportedOperationException {
                    this.put(c, source.getSpimSource());
                    return this;
                }

                public DataBuilder<T> put(SourceAndConverter<T> source) throws UnsupportedOperationException {
                    this.put(0, source.getSpimSource());
                    return this;
                }

                public DataBuilder<T> putXYZRAI(int channel, int timepoint, RandomAccessibleInterval<T> rai) throws UnsupportedOperationException {
                    if (rai.numDimensions() == 2) {
                        rai = Views.addDimension(rai, 0L, 0L);
                    }
                    this.validate(channel, timepoint);
                    this.validate(rai);
                    this.ctToRAI.get(channel).put(timepoint, rai);
                    return this;
                }

                public DataBuilder<T> putXYZRAI(RandomAccessibleInterval<T> rai) throws UnsupportedOperationException {
                    this.putXYZRAI(0, 0, rai);
                    return this;
                }

                public MetaData.MetaDataBuilder defineMetaData(String imageName) {
                    if (this.nChannels < 1) {
                        throw new UnsupportedOperationException("No channel found, nChannels = " + this.nChannels + ". You probably did not specify any data.");
                    }
                    if (this.nTimePoints < 1) {
                        throw new UnsupportedOperationException("No timepoint found, nTimepoints = " + this.nTimePoints + ". You probably did not specify any data.");
                    }
                    for (int c = 0; c < this.nChannels; ++c) {
                        for (int t = 0; t < this.nTimePoints; ++t) {
                            if (!this.ctToRAI.containsKey(c)) {
                                throw new UnsupportedOperationException("Channel " + c + " missing. You probably forgot to specify the data for this channel.");
                            }
                            if (this.ctToRAI.get(c).containsKey(t)) continue;
                            throw new UnsupportedOperationException("Timepoint " + t + " missing for channel " + c + ". You probably forgot to specify the data for this channel and timepoint.");
                        }
                    }
                    Data data = new Data(this);
                    return new MetaData.MetaDataBuilder(data, imageName);
                }

                private void validate(int channel, int timepoint) throws UnsupportedOperationException {
                    if (channel < 0) {
                        throw new UnsupportedOperationException("Channel index can't be negative");
                    }
                    if (timepoint < 0) {
                        throw new UnsupportedOperationException("Timepoint index can't be negative");
                    }
                    if (channel + 1 > this.nChannels) {
                        this.nChannels = channel + 1;
                    }
                    if (timepoint + 1 > this.nTimePoints) {
                        this.nTimePoints = timepoint + 1;
                    }
                    if (!this.ctToRAI.containsKey(channel)) {
                        this.ctToRAI.put(channel, new HashMap());
                    }
                    if (this.ctToRAI.get(channel).containsKey(timepoint)) {
                        throw new UnsupportedOperationException("You can't specify two times the same channel and timepoint");
                    }
                }

                private void validate(RandomAccessibleInterval<T> rai) throws UnsupportedOperationException {
                    if (rai.numDimensions() != 3) {
                        throw new UnsupportedOperationException("All random accessible intervals should be 3D");
                    }
                    if (this.nPixelX == -1) {
                        if (rai.dimension(0) > Integer.MAX_VALUE) {
                            throw new UnsupportedOperationException("Image too big along X (" + rai.dimension(0) + ">" + Integer.MAX_VALUE + ")");
                        }
                        if (rai.dimension(1) > Integer.MAX_VALUE) {
                            throw new UnsupportedOperationException("Image too big along Y (" + rai.dimension(1) + ">" + Integer.MAX_VALUE + ")");
                        }
                        if (rai.dimension(2) > Integer.MAX_VALUE) {
                            throw new UnsupportedOperationException("Image too big along Z (" + rai.dimension(2) + ">" + Integer.MAX_VALUE + ")");
                        }
                        this.nPixelX = (int)rai.dimension(0);
                        this.nPixelY = (int)rai.dimension(1);
                        this.nPixelZ = (int)rai.dimension(2);
                        this.pixelInstance = rai.getAt(0, 0, 0);
                        if (!SourceToByteArray.validPixelType(this.pixelInstance)) {
                            throw new UnsupportedOperationException("Unhandled pixel type class: " + this.pixelInstance.getClass().getName());
                        }
                    }
                    if (rai.dimension(0) != (long)this.nPixelX) {
                        throw new UnsupportedOperationException("All random accessible intervals should have the same dimension (size X: " + this.nPixelX + " != " + rai.dimension(0));
                    }
                    if (rai.dimension(1) != (long)this.nPixelY) {
                        throw new UnsupportedOperationException("All random accessible intervals should have the same dimension (size Y: " + this.nPixelY + " != " + rai.dimension(1));
                    }
                    if (rai.dimension(2) != (long)this.nPixelZ) {
                        throw new UnsupportedOperationException("All random accessible intervals should have the same dimension (size Z: " + this.nPixelZ + " != " + rai.dimension(2));
                    }
                }
            }
        }
    }
}

