/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.ometiff;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import loci.common.image.IImageScaler;

public class AverageImageScaler
implements IImageScaler {
    public byte[] downsample(byte[] srcImage, int width, int height, double scaleFactor, int bytesPerPixel, boolean littleEndian, boolean floatingPoint, int channels, boolean interleaved) {
        if (scaleFactor != (double)((int)scaleFactor)) {
            throw new UnsupportedOperationException("Unsupported non integer scale factor");
        }
        int scaleInt = (int)scaleFactor;
        if (scaleInt == 1) {
            return srcImage;
        }
        if (scaleFactor < 1.0) {
            throw new IllegalArgumentException("Scale factor cannot be less than 1");
        }
        int newW = width / scaleInt;
        int newH = height / scaleInt;
        byte[][] allshifts = new byte[scaleInt * scaleInt][newW * newH * bytesPerPixel * channels];
        for (int ys = 0; ys < scaleInt; ++ys) {
            for (int xs = 0; xs < scaleInt; ++xs) {
                allshifts[ys * scaleInt + xs] = this.getBufferWithShift(srcImage, width, height, scaleInt, bytesPerPixel, littleEndian, floatingPoint, channels, interleaved, xs, ys);
            }
        }
        int nPix = newW * newH * channels;
        int nShifts = scaleInt * scaleInt;
        int offs = 0;
        if (bytesPerPixel == 1) {
            byte[] avg = new byte[newW * newH * bytesPerPixel * channels];
            for (int iPix = 0; iPix < nPix; ++iPix) {
                int v = 0;
                for (int is = 0; is < nShifts; ++is) {
                    v += allshifts[is][offs] & 0xFF;
                }
                avg[offs] = (byte)(v / nShifts);
                offs += bytesPerPixel;
            }
            return avg;
        }
        if (bytesPerPixel == 2) {
            ByteBuffer buffer = ByteBuffer.allocate(nPix * 2);
            ShortBuffer bufferShort = buffer.asShortBuffer();
            for (int iPix = 0; iPix < nPix; ++iPix) {
                int v = 0;
                for (int is = 0; is < nShifts; ++is) {
                    byte hi = allshifts[is][offs];
                    byte lo = allshifts[is][offs + 1];
                    v += (hi & 0xFF) << 8 | lo & 0xFF;
                }
                bufferShort.put((short)(v / nShifts));
                offs += bytesPerPixel;
            }
            return buffer.array();
        }
        if (bytesPerPixel == 4 && floatingPoint) {
            float fnShifts = nShifts;
            ByteBuffer buffer = ByteBuffer.allocate(nPix * 4);
            for (int iPix = 0; iPix < nPix; ++iPix) {
                int v = 0;
                for (int is = 0; is < nShifts; ++is) {
                    int asInt = (allshifts[is][offs] & 0xFF) << 24 | (allshifts[is][offs + 1] & 0xFF) << 16 | (allshifts[is][offs + 2] & 0xFF) << 8 | allshifts[is][offs + 3] & 0xFF;
                    v = (int)((float)v + Float.intBitsToFloat(asInt));
                }
                buffer.putFloat((float)v / fnShifts);
                offs += bytesPerPixel;
            }
            return buffer.array();
        }
        throw new UnsupportedOperationException("Cannot handle pixel type with " + bytesPerPixel + " bytes per pixels (float = " + floatingPoint + "). Please contribute!");
    }

    private byte[] getBufferWithShift(byte[] srcImage, int width, int height, int scaleFactor, int bytesPerPixel, boolean littleEndian, boolean floatingPoint, int channels, boolean interleaved, int shiftX, int shiftY) {
        int newW = width / scaleFactor;
        int newH = height / scaleFactor;
        if (newW == width && newH == height) {
            return srcImage;
        }
        int yd = height / newH * width - width;
        int yr = height % newH;
        int xd = width / newW;
        int xr = width % newW;
        byte[] outBuf = new byte[newW * newH * bytesPerPixel * channels];
        int count = interleaved ? 1 : channels;
        int pixelChannels = interleaved ? channels : 1;
        for (int c = 0; c < count; ++c) {
            int srcOffset = c * width * height;
            srcOffset += shiftX + shiftY * width;
            int destOffset = c * newW * newH;
            int ye = 0;
            for (int yyy = newH; yyy > 0; --yyy) {
                int xe = 0;
                for (int xxx = newW; xxx > 0; --xxx) {
                    for (int rgb = 0; rgb < pixelChannels; ++rgb) {
                        if (bytesPerPixel < 0) continue;
                        System.arraycopy(srcImage, bytesPerPixel * (srcOffset * pixelChannels + rgb), outBuf, bytesPerPixel * (destOffset * pixelChannels + rgb), bytesPerPixel);
                    }
                    ++destOffset;
                    srcOffset += xd;
                    if ((xe += xr) < newW) continue;
                    xe -= newW;
                    ++srcOffset;
                }
                srcOffset += yd;
                if ((ye += yr) < newH) continue;
                ye -= newH;
                srcOffset += width;
            }
        }
        return outBuf;
    }
}

