/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.command.deprecated;

import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import loci.common.DebugTools;
import loci.formats.FormatException;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.tools.ImageConverter;
import org.apache.commons.io.FilenameUtils;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Deprecated
@Plugin(type=Command.class, menuPath="Plugins>BIOP>Kheops>(Deprecated) Kheops - No Param. Convert File to Pyramidal OME  ")
public class KheopsSimpleCommand
implements Command {
    @Parameter(label="Select an input file (required)", style="open")
    File input_path;
    public static Consumer<String> logger = IJ::log;

    public void run() {
        Instant start = Instant.now();
        String fileName = this.input_path.getName();
        int pyramidResolution_max = 6;
        int pyramidScale = 2;
        int tileSize = 512;
        ImageReader reader = new ImageReader();
        try {
            logger.accept(this.input_path.toString());
            reader.setId(this.input_path.toString());
            int img_width = reader.getSizeX();
            int img_height = reader.getSizeY();
            logger.accept("width : " + img_width);
            int smallest = Math.min(img_width, img_height);
            int pyramidResolution = (int)Math.round((Math.log(smallest) - Math.log(tileSize)) / Math.log(pyramidScale));
            logger.accept("pyramidResolution : " + pyramidResolution);
            if (pyramidResolution > pyramidResolution_max) {
                pyramidResolution = pyramidResolution_max;
            }
            String fileNameWithOutExt = FilenameUtils.removeExtension((String)fileName) + ".ome.tiff";
            File parent_dir = new File(this.input_path.getParent());
            File output_path = new File(parent_dir, fileNameWithOutExt);
            String[] params = new String[]{this.input_path.toString(), output_path.toString(), "-overwrite", "-pyramid-resolutions", String.valueOf(pyramidResolution), "-pyramid-scale", String.valueOf(pyramidScale), "-tilex", String.valueOf(tileSize), "-tiley", String.valueOf(tileSize), "-noflat", "-bigtiff"};
            DebugTools.enableLogging((String)"INFO");
            ImageConverter converter = new ImageConverter();
            if (!converter.testConvert((IFormatWriter)new ImageWriter(), params)) {
                logger.accept("Ooups! Something went wrong, contact BIOP team");
            } else {
                logger.accept("Jobs Done !");
            }
        }
        catch (IOException | FormatException e) {
            e.printStackTrace();
        }
        Instant finish = Instant.now();
        long timeElapsed = Duration.between(start, finish).toMillis();
        logger.accept(this.input_path.getName() + "\t OME TIFF conversion (Deprecated Kheops Simple Command) \t Run time=\t" + timeElapsed / 1000L + "\t s");
    }
}

