/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.command.deprecated;

import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.function.Consumer;
import loci.common.DebugTools;
import loci.formats.FormatException;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.tools.ImageConverter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Deprecated
@Plugin(type=Command.class, menuPath="Plugins>BIOP>Kheops>(Deprecated) Kheops - Adv. Convert File to Pyramidal OME")
public class KheopsAdvCommand
implements Command {
    @Parameter(label="Select an input file (required)")
    File input_path;
    @Parameter(label="Specify an output folder (optional)", style="directory", required=false, persist=false)
    File output_dir;
    @Parameter(label="Individual Tile size (in pixel)")
    int tileSize = 512;
    @Parameter(label="Compression", choices={"Uncompressed", "LZW", "JPEG-2000", "JPEG-2000 Lossy", "JPEG", "zlib"})
    String compression = "Uncompressed";
    @Parameter(label="Save as BIG  ome.tiff?")
    boolean bigtiff = true;
    @Parameter(label="Input image is a pyramid file, keep pyramid geometry?", style="directory")
    Boolean keep_pyramid_geometry = true;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    String message = "If 'keep pyramid geometry' is false, please specify the values below";
    @Parameter(label="Pyramid level(s)")
    int pyramidResolution = 2;
    @Parameter(label="Pyramid level downsampling factor")
    int pyramidScale = 4;
    public static Consumer<String> logger = IJ::log;

    public void run() {
        File output_path;
        Instant start = Instant.now();
        String fileName = this.input_path.getName();
        String fileNameWithOutExt = FilenameUtils.removeExtension((String)fileName) + ".ome.tiff";
        boolean isOutputNull = false;
        if (this.output_dir == null || this.output_dir.toString().equals("")) {
            isOutputNull = true;
            File parent_dir = new File(this.input_path.getParent());
            output_path = new File(parent_dir, fileNameWithOutExt);
        } else {
            this.output_dir.mkdirs();
            output_path = new File(this.output_dir, fileNameWithOutExt);
        }
        Object[] params = new String[]{this.input_path.toString(), output_path.toString(), "-overwrite", "-tilex", String.valueOf(this.tileSize), "-tiley", String.valueOf(this.tileSize), "-noflat"};
        if (!this.keep_pyramid_geometry.booleanValue()) {
            Object[] newPyr_params = new String[]{"-pyramid-resolutions", String.valueOf(this.pyramidResolution), "-pyramid-scale", String.valueOf(this.pyramidScale)};
            params = (String[])ArrayUtils.addAll((Object[])params, (Object[])newPyr_params);
        }
        if (!this.compression.equals("Uncompressed")) {
            Object[] newCom_param = new String[]{"-compression", this.compression};
            params = (String[])ArrayUtils.addAll((Object[])params, (Object[])newCom_param);
        }
        if (this.bigtiff) {
            params = (String[])ArrayUtils.add((Object[])params, (Object)"-bigtiff");
        }
        logger.accept(Arrays.toString(params));
        try {
            DebugTools.enableLogging((String)"INFO");
            ImageConverter converter = new ImageConverter();
            if (!converter.testConvert((IFormatWriter)new ImageWriter(), (String[])params)) {
                logger.accept("Ooups! Something went wrong, contact BIOP team");
            } else {
                logger.accept("Jobs Done !");
            }
        }
        catch (IOException | FormatException e) {
            e.printStackTrace();
        }
        if (isOutputNull) {
            this.output_dir = null;
        }
        Instant finish = Instant.now();
        long timeElapsed = Duration.between(start, finish).toMillis();
        logger.accept(this.input_path.getName() + "\t OME TIFF conversion (Deprecated Kheops Adv. Command) \t Run time=\t" + timeElapsed / 1000L + "\t s");
    }
}

