/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.kheops.KheopsHelper;
import ch.epfl.biop.kheops.ometiff.OMETiffExporter;
import java.io.File;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.apache.commons.io.FilenameUtils;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.TaskService;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Export>Export Sources To OME Tiff (build pyramid)", description="Saves Bdv sources as a multi-channel OME-Tiff file, with multi-resolution levels recomputed from the highest resolution level")
public class KheopsExportSourcesCommand
implements Command {
    @Parameter(label="Sources to export")
    public SourceAndConverter[] sacs;
    @Parameter(label="Selected Channels. Leave blank for all", required=false)
    String range_channels = "";
    @Parameter(label="Selected Slices. Leave blank for all", required=false)
    String range_slices = "";
    @Parameter(label="Selected Timepoints. Leave blank for all", required=false)
    String range_frames = "";
    @Parameter(label="Output file", style="save")
    public File file;
    @Parameter(label="Physical unit", choices={"MILLIMETER", "MICROMETER"})
    String unit;
    @Parameter(label="Override voxel sizes")
    boolean override_voxel_size;
    @Parameter(label="Voxel size in micrometer (XY)", style="format:#.000")
    double vox_size_xy_um;
    @Parameter(label="Voxel Z size in micrometer (Z)", style="format:#.000")
    double vox_size_z_um;
    @Parameter(label="Number of resolution levels")
    int n_resolution_levels = 4;
    @Parameter(label="Scaling factor between resolution levels")
    int downscaling = 2;
    @Parameter(label="Tile Size X (negative: no tiling)")
    int tile_size_x = 512;
    @Parameter(label="Tile Size Y (negative: no tiling)")
    int tile_size_y = 512;
    @Parameter(label="Number of threads (0 = serial)")
    int n_threads = 8;
    @Parameter(label="Compression type", choices={"LZW", "Uncompressed", "JPEG-2000", "JPEG-2000 Lossy", "JPEG"})
    String compression = "LZW";
    @Parameter(label="Compress temporary files (save space on drive during pyramid building)")
    boolean compress_temp_files = false;
    @Parameter
    TaskService taskService;
    @Parameter
    LogService logger;

    public void run() {
        Unit lUnit;
        switch (this.unit) {
            case "MILLIMETER": {
                lUnit = UNITS.MILLIMETER;
                break;
            }
            case "MICROMETER": {
                lUnit = UNITS.MICROMETER;
                break;
            }
            default: {
                this.logger.error((Object)("Unknown unit: " + this.unit));
                System.err.println("Unknown unit: " + this.unit);
                return;
            }
        }
        Instant start = Instant.now();
        List<SourceAndConverter> sources = Arrays.asList(this.sacs);
        this.sacs = sources.toArray(new SourceAndConverter[0]);
        int max_tiles_queue = 256;
        String imageName = FilenameUtils.removeExtension((String)this.file.getName());
        if (imageName.endsWith(".ome")) {
            imageName = FilenameUtils.removeExtension((String)imageName);
        }
        try {
            OMETiffExporter.OMETiffExporterBuilder.MetaData.MetaDataBuilder builder = OMETiffExporter.builder().put(this.sacs).defineMetaData(FilenameUtils.removeExtension((String)imageName)).putMetadataFromSources(this.sacs, (Unit<Length>)lUnit);
            if (this.override_voxel_size) {
                builder.voxelPhysicalSizeMicrometer(this.vox_size_xy_um, this.vox_size_xy_um, this.vox_size_z_um);
            }
            builder.defineWriteOptions().maxTilesInQueue(max_tiles_queue).compression(this.compression).compressTemporaryFiles(this.compress_temp_files).nThreads(this.n_threads).downsample(this.downscaling).nResolutionLevels(this.n_resolution_levels).rangeT(this.range_frames).rangeC(this.range_channels).rangeZ(this.range_slices).monitor(this.taskService).savePath(this.file.getAbsolutePath()).tileSize(this.tile_size_x, this.tile_size_y).create().export();
            KheopsHelper.writeElapsedTime(start, this.logger.subLogger(this.getClass().getSimpleName()), this.file.getName() + " export time:");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

