/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.kheops.KheopsHelper;
import ch.epfl.biop.kheops.ometiff.OMETiffExporter;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.function.Consumer;
import loci.common.DebugTools;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.apache.commons.io.FilenameUtils;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.TaskService;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Kheops>Kheops - Convert Image to Pyramidal OME TIFF")
public class KheopsExportImagePlusCommand
implements Command {
    @Parameter(label="Image")
    ImagePlus image;
    @Parameter(label="Output folder (optional)", style="directory")
    File output_dir;
    @Parameter(label="Compression type", choices={"LZW", "Uncompressed", "JPEG-2000", "JPEG-2000 Lossy", "JPEG"})
    String compression = "LZW";
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false, required=false)
    String message = "<html><b>Subset in CTZ. Leave fields blank to export all.<br></b>You can use commas or colons to separate ranges. eg. '1:2:10' or '1,3,5,8'. '-1' is the last index.</html>";
    @Parameter(label="Channels subset:", required=false)
    String subset_channels = "";
    @Parameter(label="Slices subset:", required=false)
    String subset_slices = "";
    @Parameter(label="Timepoints subset:", required=false)
    String subset_frames = "";
    @Parameter(label="Compress temporary files (LZW)")
    boolean compress_temp_files = false;
    public static Consumer<String> logger = IJ::log;
    @Parameter
    TaskService taskService;

    public void run() {
        Instant start = Instant.now();
        String imageTitle = this.image.getTitle();
        int tileSize = 512;
        int nThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        if (!this.output_dir.exists()) {
            this.output_dir.mkdirs();
        }
        DebugTools.enableLogging((String)"WARN");
        int numberOfBlocksComputedInAdvance = 64;
        KheopsHelper.SourcesInfo sourcesInfo = KheopsHelper.getSourcesFromImage(this.image, numberOfBlocksComputedInAdvance, nThreads);
        HashSet<String> paths = new HashSet<String>();
        String fileNameWithOutExt = FilenameUtils.removeExtension((String)imageTitle);
        boolean appendSuffix = false;
        int counter = 0;
        if (paths.contains(fileNameWithOutExt)) {
            fileNameWithOutExt = fileNameWithOutExt + "_s0";
        }
        while (paths.contains(fileNameWithOutExt)) {
            fileNameWithOutExt = appendSuffix ? fileNameWithOutExt.substring(0, fileNameWithOutExt.length() - 2) + "_" + counter : fileNameWithOutExt + "_" + counter;
            appendSuffix = true;
            ++counter;
        }
        paths.add(fileNameWithOutExt);
        SourceAndConverter[] sources = sourcesInfo.idToSources.get(0).toArray(new SourceAndConverter[0]);
        File output_path = new File(this.output_dir, fileNameWithOutExt + ".ome.tiff");
        if (output_path.exists()) {
            IJ.log((String)("Error: file " + output_path.getAbsolutePath() + " already exists. Skipped!"));
        } else {
            int sizeFullResolution = (int)Math.min(sources[0].getSpimSource().getSource(0, 0).max(0), sources[0].getSpimSource().getSource(0, 0).max(1));
            int nResolutions = 1;
            while (sizeFullResolution > tileSize) {
                sizeFullResolution /= 2;
                ++nResolutions;
            }
            try {
                Unit u;
                if (this.image.getCalibration() == null) {
                    logger.accept("No calibration!");
                    u = UNITS.REFERENCEFRAME;
                    this.image.setCalibration(new Calibration());
                } else {
                    u = BioFormatsHelper.getUnitFromString((String)this.image.getCalibration().getUnit());
                    if (u == null) {
                        u = this.image.getCalibration().getUnit().equals("um") || this.image.getCalibration().getUnit().equals("micron") || this.image.getCalibration().getUnit().equals("\u00b5m") ? UNITS.MICROMETER : UNITS.REFERENCEFRAME;
                    }
                }
                OMETiffExporter.OMETiffExporterBuilder.MetaData.MetaDataBuilder builder = OMETiffExporter.builder().put(sources).defineMetaData(this.image.getTitle()).putMetadataFromSources(sources, (Unit<Length>)u).pixelsTimeIncrementInS(this.image.getCalibration().frameInterval);
                OMETiffExporter exporter = builder.defineWriteOptions().maxTilesInQueue(numberOfBlocksComputedInAdvance).compression(this.compression).compressTemporaryFiles(this.compress_temp_files).nThreads(nThreads).downsample(2).nResolutionLevels(nResolutions).rangeT(this.subset_frames).rangeC(this.subset_channels).rangeZ(this.subset_slices).monitor(this.taskService).savePath(output_path.getAbsolutePath()).tileSize(tileSize, tileSize).create();
                exporter.export();
            }
            catch (Exception e) {
                IJ.log((String)("Error with " + output_path + " export: " + e.getMessage()));
            }
        }
        Instant finish = Instant.now();
        long timeElapsed = Duration.between(start, finish).toMillis();
        logger.accept(imageTitle + "\t OME TIFF conversion (Kheops) \t Run time=\t" + timeElapsed / 1000L + "\t s\t parallel = \t " + false + "\t nProcessors = \t" + nThreads);
    }
}

