/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.kheops.IntRangeParser;
import ch.epfl.biop.kheops.KheopsHelper;
import ch.epfl.biop.kheops.ometiff.OMETiffExporter;
import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import loci.common.DebugTools;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.in.OIRReader;
import loci.formats.meta.IMetadata;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.MetadataStore;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.Task;
import org.scijava.task.TaskService;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Kheops>Kheops - Convert File to Pyramidal OME TIFF", description="Converts a Bio-Formats readable file to pyramidal OME TIFFs files (one file per series).")
public class KheopsCommand
implements Command {
    @Parameter(label="Select an input file (required)", style="open")
    File input_path;
    @Parameter(label="Output folder (optional)", style="directory", required=false)
    File output_dir;
    @Parameter(label="Compression type", choices={"LZW", "Uncompressed", "JPEG-2000", "JPEG-2000 Lossy", "JPEG"})
    String compression = "LZW";
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false, required=false)
    String message = "<html><b>Subset in CTZ and series. Leave fields blank to export all.<br></b>You can use commas or colons to separate ranges. eg. '1:2:10' or '1,3,5,8'. '-1' is the last index.</html>";
    @Parameter(label="Series subset:", required=false)
    String subset_series = "";
    @Parameter(label="Channels subset:", required=false)
    String subset_channels = "";
    @Parameter(label="Slices subset:", required=false)
    String subset_slices = "";
    @Parameter(label="Timepoints subset:", required=false)
    String subset_frames = "";
    @Parameter(label="Compress temporary files (LZW)")
    boolean compress_temp_files = false;
    @Parameter(label="Override voxel sizes")
    boolean override_voxel_size;
    @Parameter(label="XY Voxel size in micrometer", style="format:0.000")
    double vox_size_xy;
    @Parameter(label="Z Voxel size in micrometer", style="format:0.000")
    double vox_size_z;
    public static Consumer<String> logger = IJ::log;
    @Parameter
    TaskService taskService;
    @Parameter
    Context context;
    final Object cancelConcatenatorLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        List<Integer> series;
        KheopsHelper.SourcesInfo sourcesInfo;
        Instant start = Instant.now();
        String fileName = this.input_path.getName();
        int tileSize = 1024;
        int nThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        File parent_dir = new File(this.input_path.getParent());
        if (this.output_dir == null || this.output_dir.toString().equals("")) {
            this.output_dir = parent_dir;
        } else {
            this.output_dir.mkdirs();
        }
        DebugTools.enableLogging((String)"OFF");
        int numberOfBlocksComputedInAdvance = 64;
        if (FilenameUtils.isExtension((String)this.input_path.getAbsolutePath(), (String)"oir")) {
            System.out.println("OIR File detected! Reading full plane.");
            OIRReader r = new OIRReader();
            try {
                r.setId(this.input_path.getAbsolutePath());
                sourcesInfo = KheopsHelper.getSourcesFromFile(this.input_path.getAbsolutePath(), r.getSizeX(), r.getSizeY(), 6, 1, false, "CORNER", this.context);
            }
            catch (IOException | FormatException e) {
                throw new RuntimeException(e);
            }
        } else {
            sourcesInfo = KheopsHelper.getSourcesFromFile(this.input_path.getAbsolutePath(), tileSize, tileSize, numberOfBlocksComputedInAdvance, 1, false, "CORNER", this.context);
        }
        int nSeriesOriginal = sourcesInfo.idToSources.keySet().size();
        try {
            series = new IntRangeParser(this.subset_series).get(nSeriesOriginal);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        boolean process_series_in_parallel = series.size() != 1;
        HashMap indexToFilePath = new HashMap();
        HashSet paths = new HashSet();
        Task iniBatchTask = null;
        int sSeries = series.size();
        if (sSeries > 1) {
            iniBatchTask = this.taskService.createTask("OME-Tiff export of " + this.input_path.getName());
            iniBatchTask.setProgressMaximum((long)series.size());
            iniBatchTask.start();
        }
        Task batchTask = iniBatchTask;
        try {
            series.forEach(iSeries -> {
                String fileNameWithOutExt = FilenameUtils.removeExtension((String)fileName);
                if (series.size() > 1) {
                    fileNameWithOutExt = sourcesInfo.idToSeriesIndex.containsKey(iSeries) ? fileNameWithOutExt + "_" + sourcesInfo.idToImageName.get(sourcesInfo.seriesToId.get(iSeries)).getName() : fileNameWithOutExt + "_" + iSeries;
                }
                boolean appendSuffix = false;
                int counter = 0;
                if (paths.contains(fileNameWithOutExt)) {
                    fileNameWithOutExt = fileNameWithOutExt + "_s" + iSeries;
                }
                while (paths.contains(fileNameWithOutExt)) {
                    fileNameWithOutExt = appendSuffix ? fileNameWithOutExt.substring(0, fileNameWithOutExt.length() - 2) + "_" + counter : fileNameWithOutExt + "_" + counter;
                    appendSuffix = true;
                    ++counter;
                }
                paths.add(fileNameWithOutExt);
                indexToFilePath.put(iSeries, fileNameWithOutExt + ".ome.tiff");
            });
            Stream idStream = series.stream();
            if (process_series_in_parallel) {
                idStream = (Stream)idStream.parallel();
            }
            boolean parallelProcess = process_series_in_parallel;
            idStream.forEach(iSeries -> {
                block18: {
                    if (batchTask == null || !batchTask.isCanceled()) {
                        SourceAndConverter[] sources = sourcesInfo.idToSources.get(iSeries).toArray(new SourceAndConverter[0]);
                        File output_path = new File(this.output_dir, (String)indexToFilePath.get(iSeries));
                        if (output_path.exists()) {
                            IJ.log((String)("Error: file " + output_path.getAbsolutePath() + " already exists. Skipped!"));
                        } else {
                            int sizeFullResolution = (int)Math.min(sources[0].getSpimSource().getSource(0, 0).max(0), sources[0].getSpimSource().getSource(0, 0).max(1));
                            int nResolutions = 1;
                            while (sizeFullResolution > tileSize) {
                                sizeFullResolution /= 2;
                                ++nResolutions;
                            }
                            try {
                                Object object;
                                OMETiffExporter.OMETiffExporterBuilder.MetaData.MetaDataBuilder builder = OMETiffExporter.builder().put(sources).defineMetaData("Image").applyOnMeta(meta -> {
                                    IFormatReader reader = null;
                                    try {
                                        try {
                                            reader = (IFormatReader)sourcesInfo.readerPool.acquire();
                                            IMetadata medataSrc = (IMetadata)reader.getMetadataStore();
                                            KheopsHelper.transferSeriesMeta((MetadataRetrieve)medataSrc, iSeries, (MetadataStore)meta, 0);
                                        }
                                        finally {
                                            sourcesInfo.readerPool.recycle((Object)reader);
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    return meta;
                                });
                                if (this.override_voxel_size) {
                                    builder.voxelPhysicalSizeMicrometer(this.vox_size_xy, this.vox_size_xy, this.vox_size_z);
                                }
                                OMETiffExporter exporter = builder.defineWriteOptions().maxTilesInQueue(numberOfBlocksComputedInAdvance).compression(this.compression).compressTemporaryFiles(this.compress_temp_files).nThreads(parallelProcess ? 0 : nThreads).downsample(2).nResolutionLevels(nResolutions).rangeT(this.subset_frames).rangeC(this.subset_channels).rangeZ(this.subset_slices).monitor(this.taskService).savePath(output_path.getAbsolutePath()).tileSize(tileSize, tileSize).create();
                                if (batchTask != null) {
                                    object = this.cancelConcatenatorLock;
                                    synchronized (object) {
                                        Runnable callback = batchTask.getCancelCallBack();
                                        batchTask.setCancelCallBack(() -> {
                                            callback.run();
                                            exporter.cancelExport();
                                        });
                                    }
                                }
                                exporter.export();
                                if (batchTask == null) break block18;
                                object = this.cancelConcatenatorLock;
                                synchronized (object) {
                                    batchTask.setProgressValue(batchTask.getProgressValue() + 1L);
                                }
                            }
                            catch (Exception e) {
                                IJ.log((String)("Error with " + output_path + " export: " + e.getMessage()));
                                if (batchTask != null) {
                                    Object object = this.cancelConcatenatorLock;
                                    synchronized (object) {
                                        batchTask.setProgressValue(batchTask.getProgressValue() + 1L);
                                    }
                                }
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            sourcesInfo.readerPool.shutDown(reader -> {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        finally {
            if (batchTask != null) {
                batchTask.finish();
            }
        }
        Instant finish = Instant.now();
        long timeElapsed = Duration.between(start, finish).toMillis();
        logger.accept(this.input_path.getName() + "\t OME TIFF conversion (Kheops) \t Run time=\t" + timeElapsed / 1000L + "\t s\t parallel = \t " + process_series_in_parallel + "\t nProcessors = \t" + nThreads);
    }
}

