/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops.command;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.kheops.IntRangeParser;
import ch.epfl.biop.kheops.KheopsHelper;
import ch.epfl.biop.kheops.ometiff.OMETiffExporter;
import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Consumer;
import loci.common.DebugTools;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.in.OIRReader;
import loci.formats.meta.IMetadata;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.MetadataStore;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.Task;
import org.scijava.task.TaskService;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Kheops>Kheops - Batch Convert Files to Pyramidal OME TIFF", description="Converts in parallel Bio-Formats readable files to pyramidal OME TIFFs files.")
public class KheopsBatchCommand
implements Command {
    @Parameter(label="Select input files (required)", style="open")
    File[] input_paths;
    @Parameter(label="Output folder (optional)", style="directory", required=false)
    File output_dir;
    @Parameter(label="Compression type", choices={"LZW", "Uncompressed", "JPEG-2000", "JPEG-2000 Lossy", "JPEG"})
    String compression = "LZW";
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false, required=false)
    String message = "<html><b>Subset in CTZ and series. Leave fields blank to export all.<br></b>You can use commas or colons to separate ranges. eg. '1:2:10' or '1,3,5,8'. '-1' is the last index.</html>";
    @Parameter(label="Series subset:", required=false)
    String subset_series = "";
    @Parameter(label="Channels subset:", required=false)
    String subset_channels = "";
    @Parameter(label="Slices subset:", required=false)
    String subset_slices = "";
    @Parameter(label="Timepoints subset:", required=false)
    String subset_frames = "";
    @Parameter(label="Compress temporary files (LZW)")
    boolean compress_temp_files = false;
    @Parameter(label="Override voxel sizes")
    boolean override_voxel_size;
    @Parameter(label="XY Voxel size in micrometer", style="format:0.000")
    double vox_size_xy;
    @Parameter(label="Z Voxel size in micrometer", style="format:0.000")
    double vox_size_z;
    final Set<String> paths = new HashSet<String>();
    public static Consumer<String> logger = IJ::log;
    @Parameter
    TaskService taskService;
    @Parameter
    LogService logService;
    @Parameter
    Context context;
    final Object cancelConcatenatorLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int tileSize = 512;
        int nThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        Instant start = Instant.now();
        DebugTools.enableLogging((String)"OFF");
        if (this.input_paths.length < (Runtime.getRuntime().availableProcessors() + 1) / 2) {
            IJ.log((String)"You selected a few files only, the batch kheops command may be slower than the normal kheops with the batch button");
        }
        if (this.output_dir == null || this.output_dir.toString().equals("")) {
            this.output_dir = new File(this.input_paths[0].getParent());
        } else {
            this.output_dir.mkdirs();
        }
        Task iniBatchTask = null;
        int nFiles = this.input_paths.length;
        if (nFiles > 1) {
            iniBatchTask = this.taskService.createTask("OME-Tiff export of " + nFiles + " files.");
            iniBatchTask.setProgressMaximum((long)nFiles);
            iniBatchTask.start();
        }
        Task batchTask = iniBatchTask;
        try {
            ForkJoinPool customThreadPool = new ForkJoinPool(nThreads);
            try {
                ((ForkJoinTask)customThreadPool.submit(() -> {
                    Arrays.asList(this.input_paths).parallelStream().forEach(input_path -> {
                        if (batchTask == null || !batchTask.isCanceled()) {
                            List<Integer> series;
                            KheopsHelper.SourcesInfo sourcesInfo;
                            IJ.log((String)("Processing " + input_path));
                            String fileName = input_path.getName();
                            if (FilenameUtils.isExtension((String)input_path.getAbsolutePath(), (String)"oir")) {
                                System.out.println("OIR File detected! Reading full plane.");
                                OIRReader r = new OIRReader();
                                try {
                                    r.setId(input_path.getAbsolutePath());
                                    sourcesInfo = KheopsHelper.getSourcesFromFile(input_path.getAbsolutePath(), r.getSizeX(), r.getSizeY(), 1, 1, false, "CORNER", this.context);
                                }
                                catch (IOException | FormatException e) {
                                    throw new RuntimeException(e);
                                }
                            } else {
                                sourcesInfo = KheopsHelper.getSourcesFromFile(input_path.getAbsolutePath(), tileSize, tileSize, 1, 1, false, "CORNER", this.context);
                            }
                            int nSeriesOriginal = sourcesInfo.idToSources.keySet().size();
                            try {
                                series = new IntRangeParser(this.subset_series).get(nSeriesOriginal);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new RuntimeException(e);
                            }
                            series.forEach(iSeries -> {
                                if (batchTask == null || !batchTask.isCanceled()) {
                                    String fileNameWithOutExt = FilenameUtils.removeExtension((String)fileName);
                                    SourceAndConverter[] sources = sourcesInfo.idToSources.get(iSeries).toArray(new SourceAndConverter[0]);
                                    if (series.size() > 1) {
                                        fileNameWithOutExt = sourcesInfo.idToSeriesIndex.containsKey(iSeries) ? fileNameWithOutExt + "_" + sourcesInfo.idToImageName.get(sourcesInfo.seriesToId.get(iSeries)).getName() : fileNameWithOutExt + "_" + iSeries;
                                    }
                                    Set<String> set = this.paths;
                                    synchronized (set) {
                                        boolean appendSuffix = false;
                                        int counter = 0;
                                        if (this.paths.contains(fileNameWithOutExt)) {
                                            fileNameWithOutExt = fileNameWithOutExt + "_s" + iSeries;
                                        }
                                        while (this.paths.contains(fileNameWithOutExt)) {
                                            fileNameWithOutExt = appendSuffix ? fileNameWithOutExt.substring(0, fileNameWithOutExt.length() - 2) + "_" + counter : fileNameWithOutExt + "_" + counter;
                                            appendSuffix = true;
                                            ++counter;
                                        }
                                        this.paths.add(fileNameWithOutExt);
                                    }
                                    fileNameWithOutExt = fileNameWithOutExt + ".ome.tiff";
                                    File output_path = new File(this.output_dir, fileNameWithOutExt);
                                    if (output_path.exists()) {
                                        IJ.log((String)("Error: file " + output_path.getAbsolutePath() + " already exists. Skipped!"));
                                    } else {
                                        int sizeFullResolution = (int)Math.min(sources[0].getSpimSource().getSource(0, 0).max(0), sources[0].getSpimSource().getSource(0, 0).max(1));
                                        int nResolutions = 1;
                                        while (sizeFullResolution > tileSize) {
                                            sizeFullResolution /= 2;
                                            ++nResolutions;
                                        }
                                        try {
                                            OMETiffExporter.OMETiffExporterBuilder.MetaData.MetaDataBuilder builder = OMETiffExporter.builder().put(sources).defineMetaData("Image").applyOnMeta(meta -> {
                                                IFormatReader reader = null;
                                                try {
                                                    try {
                                                        reader = (IFormatReader)sourcesInfo.readerPool.acquire();
                                                        IMetadata medataSrc = (IMetadata)reader.getMetadataStore();
                                                        KheopsHelper.transferSeriesMeta((MetadataRetrieve)medataSrc, iSeries, (MetadataStore)meta, 0);
                                                    }
                                                    finally {
                                                        sourcesInfo.readerPool.recycle((Object)reader);
                                                    }
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                                return meta;
                                            });
                                            if (this.override_voxel_size) {
                                                builder.voxelPhysicalSizeMicrometer(this.vox_size_xy, this.vox_size_xy, this.vox_size_z);
                                            }
                                            OMETiffExporter exporter = builder.defineWriteOptions().compression(this.compression).compressTemporaryFiles(this.compress_temp_files).nThreads(0).downsample(2).nResolutionLevels(nResolutions).rangeT(this.subset_frames).rangeC(this.subset_channels).rangeZ(this.subset_slices).monitor(this.taskService).savePath(output_path.getAbsolutePath()).tileSize(tileSize, tileSize).create();
                                            if (batchTask != null) {
                                                Object object = this.cancelConcatenatorLock;
                                                synchronized (object) {
                                                    Runnable callback = batchTask.getCancelCallBack();
                                                    batchTask.setCancelCallBack(() -> {
                                                        callback.run();
                                                        exporter.cancelExport();
                                                    });
                                                }
                                            }
                                            exporter.export();
                                        }
                                        catch (Exception e) {
                                            IJ.log((String)("Error with " + fileNameWithOutExt + " export."));
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            });
                            sourcesInfo.readerPool.shutDown(reader -> {
                                try {
                                    reader.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            });
                            if (batchTask != null) {
                                Object object = this.cancelConcatenatorLock;
                                synchronized (object) {
                                    batchTask.setProgressValue(batchTask.getProgressValue() + 1L);
                                }
                            }
                        }
                    });
                    return 0;
                })).get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            customThreadPool.shutdown();
            Instant finish = Instant.now();
            long timeElapsed = Duration.between(start, finish).toMillis();
            logger.accept("\t Batch OME TIFF conversion (Kheops) \t Run time=\t" + timeElapsed / 1000L + "\t s ");
            KheopsHelper.writeElapsedTime(start, this.logService.subLogger(this.getClass().getSimpleName()), "Batch export time:");
        }
        finally {
            if (batchTask != null) {
                batchTask.finish();
            }
        }
    }
}

