/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops;

import bdv.SpimSource;
import bdv.ViewerImgLoader;
import bdv.VolatileSpimSource;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ij.IJ;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicMultiResolutionSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import net.imglib2.Volatile;
import net.imglib2.converter.Converter;
import net.imglib2.display.RealARGBColorConverter;
import net.imglib2.display.ScaledARGBConverter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;

public class SourceAndConverterFromSpimDataCreator {
    private final AbstractSpimData asd;
    private final Map<Integer, SourceAndConverter> setupIdToSourceAndConverter;
    private final Map<SourceAndConverter, Map<String, Object>> sourceAndConverterToMetadata;

    public SourceAndConverterFromSpimDataCreator(AbstractSpimData asd) {
        this.asd = asd;
        this.setupIdToSourceAndConverter = new HashMap<Integer, SourceAndConverter>();
        this.sourceAndConverterToMetadata = new HashMap<SourceAndConverter, Map<String, Object>>();
        this.createSourceAndConverters();
    }

    public Map<Integer, SourceAndConverter> getSetupIdToSourceAndConverter() {
        return this.setupIdToSourceAndConverter;
    }

    public Map<String, Object> getMetadata(SourceAndConverter<?> sourceAndConverter) {
        return this.sourceAndConverterToMetadata.get(sourceAndConverter);
    }

    private void createSourceAndConverters() {
        boolean nonVolatile = WrapBasicImgLoader.wrapImgLoaderIfNecessary(this.asd);
        if (nonVolatile) {
            System.err.println("WARNING:\nOpening <SpimData> dataset that is not suited for interactive browsing.\nConsider resaving as HDF5 for better performance.");
        }
        AbstractSequenceDescription seq = this.asd.getSequenceDescription();
        ViewerImgLoader imgLoader = (ViewerImgLoader)seq.getImgLoader();
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            int setupId = setup.getId();
            BasicMultiResolutionSetupImgLoader vsil = imgLoader.getSetupImgLoader(setupId);
            String sourceName = SourceAndConverterFromSpimDataCreator.createSetupName(setup);
            Object type = vsil.getImageType();
            if (type instanceof RealType) {
                this.createRealTypeSourceAndConverter(nonVolatile, setupId, sourceName);
            } else if (type instanceof ARGBType) {
                this.createARGBTypeSourceAndConverter(setupId, sourceName);
            } else {
                IJ.error((String)("Cannot open Spimdata with Source of type " + type.getClass().getSimpleName()));
            }
            this.sourceAndConverterToMetadata.put(this.setupIdToSourceAndConverter.get(setupId), new HashMap());
        }
        WrapBasicImgLoader.removeWrapperIfPresent(this.asd);
    }

    private void createRealTypeSourceAndConverter(boolean nonVolatile, int setupId, String sourceName) {
        SpimSource s = new SpimSource(this.asd, setupId, sourceName);
        Converter nonVolatileConverter = SourceAndConverterFromSpimDataCreator.createConverterRealType((RealType)s.getType());
        if (!nonVolatile) {
            VolatileSpimSource vs = new VolatileSpimSource(this.asd, setupId, sourceName);
            Converter volatileConverter = SourceAndConverterFromSpimDataCreator.createConverterRealType((RealType)vs.getType());
            this.setupIdToSourceAndConverter.put(setupId, new SourceAndConverter(s, nonVolatileConverter, new SourceAndConverter(vs, volatileConverter)));
        } else {
            this.setupIdToSourceAndConverter.put(setupId, new SourceAndConverter(s, nonVolatileConverter));
        }
    }

    private void createARGBTypeSourceAndConverter(int setupId, String sourceName) {
        VolatileSpimSource vs = new VolatileSpimSource(this.asd, setupId, sourceName);
        SpimSource s = new SpimSource(this.asd, setupId, sourceName);
        Converter nonVolatileConverter = SourceAndConverterFromSpimDataCreator.createConverterARGBType(s);
        if (vs != null) {
            Converter volatileConverter = SourceAndConverterFromSpimDataCreator.createConverterARGBType(vs);
            this.setupIdToSourceAndConverter.put(setupId, new SourceAndConverter(s, nonVolatileConverter, new SourceAndConverter(vs, volatileConverter)));
        } else {
            this.setupIdToSourceAndConverter.put(setupId, new SourceAndConverter(s, nonVolatileConverter));
        }
    }

    private static String createSetupName(BasicViewSetup setup) {
        Channel channel;
        if (setup.hasName() && !setup.getName().trim().equals("")) {
            return setup.getName();
        }
        String name = "";
        Angle angle = (Angle)setup.getAttribute(Angle.class);
        if (angle != null) {
            name = name + (name.isEmpty() ? "" : " ") + "a " + angle.getName();
        }
        if ((channel = (Channel)setup.getAttribute(Channel.class)) != null) {
            name = name + (name.isEmpty() ? "" : " ") + "c " + channel.getName();
        }
        if (channel == null && angle == null) {
            name = name + "id " + setup.getId();
        }
        return name;
    }

    public static <T extends RealType<T>> Converter createConverterRealType(T type) {
        double typeMin = Math.max(0.0, Math.min(type.getMinValue(), 65535.0));
        double typeMax = Math.max(0.0, Math.min(type.getMaxValue(), 65535.0));
        RealARGBColorConverter<T> converter = RealARGBColorConverter.create(type, typeMin, typeMax);
        converter.setColor(new ARGBType(-1));
        return converter;
    }

    public static Converter createConverterARGBType(Source source) {
        ScaledARGBConverter converter = source.getType() instanceof Volatile ? new ScaledARGBConverter.VolatileARGB(0.0, 255.0) : new ScaledARGBConverter.ARGB(0.0, 255.0);
        return converter;
    }
}

