/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops;

import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.n5.N5ImageLoader;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.OpenersImageLoader;
import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.ResourcePool;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.bioformats.entity.SeriesIndex;
import ch.epfl.biop.bdv.img.entity.ImageName;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusToSpimData;
import ch.epfl.biop.bdv.img.opener.Opener;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import ch.epfl.biop.kheops.SourceAndConverterFromSpimDataCreator;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import loci.formats.IFormatReader;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Channel;
import net.imglib2.cache.ref.BoundedSoftRefLoaderCache;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.meta.MetadataConverter;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.MetadataStore;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.scijava.Context;
import org.scijava.log.Logger;
import spimdata.util.Displaysettings;

public class KheopsHelper {
    public static SourcesInfo getSourcesFromFile(String path, int tileX, int tileY, int maxCacheSize, int nParallelJobs, boolean splitRGB, String position_convention, Context context) {
        ArrayList<OpenerSettings> openerSettings = new ArrayList<OpenerSettings>();
        File f = new File(path);
        int nSeries = BioFormatsHelper.getNSeries((File)f);
        for (int i = 0; i < nSeries; ++i) {
            openerSettings.add(OpenerSettings.BioFormats().location(f).setSerie(i).micrometer().cacheBlockSize(tileX, tileY, 1).readerPoolSize(nParallelJobs).splitRGBChannels(splitRGB).positionConvention(position_convention).context(context));
        }
        AbstractSpimData asd = OpenersToSpimData.getSpimData(openerSettings);
        boolean result = KheopsHelper.boundSpimDataCache(asd, maxCacheSize * nParallelJobs, nParallelJobs, nParallelJobs);
        if (!result) {
            System.out.println("Warning: could not bound cache of spimdata. The memory may get full.");
        }
        Map<Integer, SourceAndConverter> idToSource = new SourceAndConverterFromSpimDataCreator(asd).getSetupIdToSourceAndConverter();
        SourcesInfo info = new SourcesInfo();
        OpenersImageLoader loader = (OpenersImageLoader)asd.getSequenceDescription().getImgLoader();
        info.readerPool = ((Opener)loader.openers.get(0)).getPixelReader();
        idToSource.keySet().forEach(id -> {
            Displaysettings displaysettings;
            BasicViewSetup bvs = (BasicViewSetup)asd.getSequenceDescription().getViewSetups().get(id);
            SeriesIndex si = (SeriesIndex)bvs.getAttribute(SeriesIndex.class);
            Channel channel = (Channel)bvs.getAttribute(Channel.class);
            ImageName imageName = (ImageName)bvs.getAttribute(ImageName.class);
            if (si != null) {
                info.idToSeriesIndex.put((Integer)id, si);
                info.idToChannels.put((Integer)id, channel.getName());
                info.idToImageName.put((Integer)id, imageName);
                info.seriesToId.put(si.getId(), (Integer)id);
            }
            if ((displaysettings = (Displaysettings)bvs.getAttribute(Displaysettings.class)) != null) {
                Displaysettings.applyDisplaysettings((SourceAndConverter)((SourceAndConverter)idToSource.get(id)), (Displaysettings)displaysettings);
            }
        });
        int nSources = idToSource.size();
        for (int id2 = 0; id2 < nSources; ++id2) {
            SourceAndConverter source = idToSource.get(id2);
            if (info.idToSeriesIndex.get(id2) != null) {
                int sn_id = info.idToSeriesIndex.get(id2).getId();
                if (!info.idToSources.containsKey(sn_id)) {
                    info.idToSources.put(sn_id, new ArrayList());
                }
                info.idToSources.get(sn_id).add(source);
                continue;
            }
            IJ.log((String)("Id " + id2 + " will not be exported. Note that 16 bits RGB images are unsupported."));
        }
        return info;
    }

    private static boolean boundSpimDataCache(AbstractSpimData<?> asd, int nBlocks, int nThreads, int nPriorities) {
        BoundedSoftRefLoaderCache loaderCache = new BoundedSoftRefLoaderCache(nBlocks);
        BasicImgLoader imageLoader = asd.getSequenceDescription().getImgLoader();
        VolatileGlobalCellCache cache = new VolatileGlobalCellCache(nPriorities, nThreads);
        try {
            Field backingCacheField = VolatileGlobalCellCache.class.getDeclaredField("backingCache");
            backingCacheField.setAccessible(true);
            backingCacheField.set(cache, loaderCache);
            if (imageLoader instanceof Hdf5ImageLoader) {
                Field cacheField = Hdf5ImageLoader.class.getDeclaredField("cache");
                cacheField.setAccessible(true);
                cacheField.set(imageLoader, cache);
                return true;
            }
            if (imageLoader instanceof N5ImageLoader) {
                Field cacheField = N5ImageLoader.class.getDeclaredField("cache");
                cacheField.setAccessible(true);
                cacheField.set(imageLoader, cache);
                return true;
            }
            Field cacheField = imageLoader.getClass().getDeclaredField("cache");
            cacheField.setAccessible(true);
            cacheField.set(imageLoader, cache);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void writeElapsedTime(Instant start, Logger logger, String message) {
        long elapsed = Duration.between(start, Instant.now()).toMillis();
        String fullMessage = message + ":  " + DurationFormatUtils.formatDuration((long)elapsed, (String)"H:mm:ss", (boolean)true);
        logger.info((Object)fullMessage);
        IJ.log((String)fullMessage);
    }

    public static void transferSeriesMeta(MetadataRetrieve metaSrc, int seriesSrc, MetadataStore metaDst, int seriesDst) {
        metaDst.setCreator(metaSrc.getCreator());
        metaDst.setImageAcquisitionDate(metaSrc.getImageAcquisitionDate(seriesSrc), seriesDst);
        metaDst.setImageName(metaSrc.getImageName(seriesSrc), seriesDst);
        metaDst.setImageDescription(metaSrc.getImageDescription(seriesSrc), seriesDst);
        metaDst.setPixelsPhysicalSizeX(metaSrc.getPixelsPhysicalSizeX(seriesSrc), seriesDst);
        metaDst.setPixelsPhysicalSizeY(metaSrc.getPixelsPhysicalSizeY(seriesSrc), seriesDst);
        metaDst.setPixelsPhysicalSizeZ(metaSrc.getPixelsPhysicalSizeZ(seriesSrc), seriesDst);
        metaDst.setPixelsTimeIncrement(metaSrc.getPixelsTimeIncrement(seriesSrc), seriesDst);
        int planeCount = metaSrc.getPlaneCount(seriesSrc);
        for (int i = 0; i < planeCount; ++i) {
            KheopsHelper.transferPlaneMeta(metaSrc, seriesSrc, i, metaDst, seriesDst, i);
        }
        int sizeC = metaSrc.getChannelCount(seriesSrc);
        for (int ch = 0; ch < sizeC; ++ch) {
            MetadataConverter.convertChannels((MetadataRetrieve)metaSrc, (int)seriesSrc, (int)ch, (MetadataStore)metaDst, (int)seriesDst, (int)ch, (boolean)true);
        }
    }

    public static void transferPlaneMeta(MetadataRetrieve metaSrc, int seriesSrc, int planeSrc, MetadataStore metaDst, int seriesDst, int planeDst) {
        if (metaSrc.getPlaneCount(seriesSrc) > planeSrc) {
            Length pz;
            Length py;
            Length px;
            Time dt;
            Time t = metaSrc.getPlaneExposureTime(seriesSrc, planeSrc);
            if (t != null) {
                metaDst.setPlaneExposureTime(t, seriesDst, planeDst);
            }
            if ((dt = metaSrc.getPlaneDeltaT(seriesSrc, planeSrc)) != null) {
                metaDst.setPlaneDeltaT(dt, seriesDst, planeDst);
            }
            if ((px = metaSrc.getPlanePositionX(seriesSrc, planeSrc)) != null) {
                metaDst.setPlanePositionX(px, seriesDst, planeDst);
            }
            if ((py = metaSrc.getPlanePositionY(seriesSrc, planeSrc)) != null) {
                metaDst.setPlanePositionY(py, seriesDst, planeDst);
            }
            if ((pz = metaSrc.getPlanePositionZ(seriesSrc, planeSrc)) != null) {
                metaDst.setPlanePositionZ(pz, seriesDst, planeDst);
            }
        }
    }

    public static SourcesInfo getSourcesFromImage(ImagePlus image, int maxCacheSize, int nParallelJobs) {
        AbstractSpimData asd = ImagePlusToSpimData.getSpimData((ImagePlus)image);
        boolean result = KheopsHelper.boundSpimDataCache(asd, maxCacheSize * nParallelJobs, nParallelJobs, nParallelJobs);
        if (!result) {
            System.out.println("Warning: could not bound cache of spimdata. The memory may get full.");
        }
        Map<Integer, SourceAndConverter> idToSource = new SourceAndConverterFromSpimDataCreator(asd).getSetupIdToSourceAndConverter();
        SourcesInfo info = new SourcesInfo();
        idToSource.keySet().forEach(id -> {
            Displaysettings displaysettings;
            BasicViewSetup bvs = (BasicViewSetup)asd.getSequenceDescription().getViewSetups().get(id);
            SeriesIndex si = (SeriesIndex)bvs.getAttribute(SeriesIndex.class);
            Channel channel = (Channel)bvs.getAttribute(Channel.class);
            ImageName imageName = (ImageName)bvs.getAttribute(ImageName.class);
            if (si != null) {
                info.idToSeriesIndex.put((Integer)id, si);
                info.idToChannels.put((Integer)id, channel.getName());
                info.idToImageName.put((Integer)id, imageName);
                info.seriesToId.put(si.getId(), (Integer)id);
            }
            if ((displaysettings = (Displaysettings)bvs.getAttribute(Displaysettings.class)) != null) {
                Displaysettings.applyDisplaysettings((SourceAndConverter)((SourceAndConverter)idToSource.get(id)), (Displaysettings)displaysettings);
            }
        });
        int nSources = idToSource.size();
        for (int id2 = 0; id2 < nSources; ++id2) {
            SourceAndConverter source = idToSource.get(id2);
            int sn_id = 0;
            if (!info.idToSources.containsKey(sn_id)) {
                info.idToSources.put(sn_id, new ArrayList());
            }
            info.idToSources.get(sn_id).add(source);
        }
        return info;
    }

    public static class SourcesInfo {
        public final Map<Integer, List<SourceAndConverter>> idToSources = new HashMap<Integer, List<SourceAndConverter>>();
        public final Map<Integer, ImageName> idToImageName = new HashMap<Integer, ImageName>();
        public final Map<Integer, SeriesIndex> idToSeriesIndex = new HashMap<Integer, SeriesIndex>();
        public final Map<Integer, String> idToChannels = new HashMap<Integer, String>();
        public final Map<Integer, Integer> seriesToId = new HashMap<Integer, Integer>();
        public ResourcePool<IFormatReader> readerPool;
    }
}

