/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.kheops;

import ch.epfl.biop.kheops.IntRangeParser;
import java.util.Collections;
import java.util.List;

public class CZTRange {
    final List<Integer> rangeC;
    final List<Integer> rangeZ;
    final List<Integer> rangeT;

    public CZTRange(List<Integer> rangeC, List<Integer> rangeZ, List<Integer> rangeT) {
        this.rangeC = Collections.unmodifiableList(rangeC);
        this.rangeZ = Collections.unmodifiableList(rangeZ);
        this.rangeT = Collections.unmodifiableList(rangeT);
    }

    public int[] getCZTDimensions() {
        return new int[]{this.rangeC.size(), this.rangeZ.size(), this.rangeT.size()};
    }

    public List<Integer> getRangeC() {
        return this.rangeC;
    }

    public List<Integer> getRangeZ() {
        return this.rangeZ;
    }

    public List<Integer> getRangeT() {
        return this.rangeT;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("C:");
        this.rangeC.forEach(c -> builder.append(c + ","));
        builder.append(" Z:");
        this.rangeZ.forEach(z -> builder.append(z + ","));
        builder.append(" T:");
        this.rangeT.forEach(t -> builder.append(t + ","));
        return builder.toString();
    }

    public long getTotalPlanes() {
        return (long)this.rangeC.size() * (long)this.rangeZ.size() * (long)this.rangeT.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String expressionRangeC = "";
        private String expressionRangeZ = "";
        private String expressionRangeT = "";

        public Builder setC(String exp) {
            this.expressionRangeC = exp;
            return this;
        }

        public Builder setZ(String exp) {
            this.expressionRangeZ = exp;
            return this;
        }

        public Builder setT(String exp) {
            this.expressionRangeT = exp;
            return this;
        }

        public CZTRange get(int nC, int nZ, int nT) throws Exception {
            List<Integer> rangeC = new IntRangeParser(this.expressionRangeC).get(nC);
            List<Integer> rangeZ = new IntRangeParser(this.expressionRangeZ).get(nZ);
            List<Integer> rangeT = new IntRangeParser(this.expressionRangeT).get(nT);
            return new CZTRange(rangeC, rangeZ, rangeT);
        }
    }
}

