/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.kheops.KheopsHelper;
import ch.epfl.biop.kheops.ometiff.OMETiffExporter;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import loci.common.DebugTools;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.apache.commons.io.FilenameUtils;
import org.scijava.task.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePlusToOMETiff {
    private static final Logger logger = LoggerFactory.getLogger(ImagePlusToOMETiff.class);

    public static void writeToOMETiff(ImagePlus image, File outFile, String compression, TaskService taskService) throws Exception {
        Instant start = Instant.now();
        String imageTitle = image.getTitle();
        int tileSize = 512;
        int nThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        File output_dir = outFile.getParentFile();
        DebugTools.enableLogging((String)"WARN");
        int numberOfBlocksComputedInAdvance = 64;
        KheopsHelper.SourcesInfo sourcesInfo = KheopsHelper.getSourcesFromImage(image, numberOfBlocksComputedInAdvance, nThreads);
        HashSet<String> paths = new HashSet<String>();
        String fileNameWithOutExt = FilenameUtils.removeExtension((String)imageTitle);
        boolean appendSuffix = false;
        int counter = 0;
        if (paths.contains(fileNameWithOutExt)) {
            fileNameWithOutExt = fileNameWithOutExt + "_s0";
        }
        while (paths.contains(fileNameWithOutExt)) {
            fileNameWithOutExt = appendSuffix ? fileNameWithOutExt.substring(0, fileNameWithOutExt.length() - 2) + "_" + counter : fileNameWithOutExt + "_" + counter;
            appendSuffix = true;
            ++counter;
        }
        paths.add(fileNameWithOutExt);
        SourceAndConverter[] sources = sourcesInfo.idToSources.get(0).toArray(new SourceAndConverter[0]);
        File output_path = new File(output_dir, fileNameWithOutExt + ".ome.tiff");
        if (output_path.exists()) {
            IJ.log((String)("Error: file " + output_path.getAbsolutePath() + " already exists. Skipped!"));
        } else {
            int sizeFullResolution = (int)Math.min(sources[0].getSpimSource().getSource(0, 0).max(0), sources[0].getSpimSource().getSource(0, 0).max(1));
            int nResolutions = 1;
            while (sizeFullResolution > tileSize) {
                sizeFullResolution /= 2;
                ++nResolutions;
            }
            try {
                Unit u;
                if (image.getCalibration() == null) {
                    logger.warn("No calibration!");
                    u = UNITS.REFERENCEFRAME;
                    image.setCalibration(new Calibration());
                } else {
                    u = BioFormatsHelper.getUnitFromString((String)image.getCalibration().getUnit());
                    if (u == null) {
                        u = image.getCalibration().getUnit().equals("um") || image.getCalibration().getUnit().equals("\u00b5m") ? UNITS.MICROMETER : UNITS.REFERENCEFRAME;
                    }
                }
                OMETiffExporter.OMETiffExporterBuilder.MetaData.MetaDataBuilder builder = OMETiffExporter.builder().put(sources).defineMetaData(image.getTitle()).putMetadataFromSources(sources, (Unit<Length>)u).pixelsTimeIncrementInS(image.getCalibration().frameInterval);
                OMETiffExporter.OMETiffExporterBuilder.WriterOptions.WriterOptionsBuilder exportBuilder = builder.defineWriteOptions().maxTilesInQueue(numberOfBlocksComputedInAdvance).compression(compression).compressTemporaryFiles(false).nThreads(nThreads).downsample(2).nResolutionLevels(nResolutions).savePath(output_path.getAbsolutePath()).tileSize(tileSize, tileSize);
                if (taskService != null) {
                    exportBuilder.monitor(taskService);
                }
                exportBuilder.create().export();
            }
            catch (Exception e) {
                IJ.log((String)("Error with " + output_path + " export: " + e.getMessage()));
            }
        }
        Instant finish = Instant.now();
        long timeElapsed = Duration.between(start, finish).toMillis();
        logger.info(imageTitle + "\t OME TIFF conversion (Kheops) \t Run time=\t" + timeElapsed / 1000L + "\t s\t parallel = \t " + false + "\t nProcessors = \t" + nThreads);
    }

    public static Unit<Length> getUnitFromCalibration(Calibration cal) {
        switch (cal.getUnit()) {
            case "um": 
            case "\u03bcm": 
            case "\u03b5m": 
            case "\u00b5m": 
            case "micrometer": {
                return UNITS.MICROMETER;
            }
            case "mm": 
            case "millimeter": {
                return UNITS.MILLIMETER;
            }
            case "cm": 
            case "centimeter": {
                return UNITS.CENTIMETER;
            }
            case "m": 
            case "meter": {
                return UNITS.METRE;
            }
        }
        return UNITS.REFERENCEFRAME;
    }
}

