/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Pipe;
import ini.trakem2.display.YesNoDialog;
import ini.trakem2.imaging.FloatProcessorT2;
import ini.trakem2.persistence.Loader;
import ini.trakem2.plugin.TPlugIn;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.CachingThread;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.TaskOnEDT;
import ini.trakem2.utils.Worker;
import ini.trakem2.vector.VectorString3D;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Utils
implements PlugIn {
    public static String version = "1.0a 2012-07-04";
    public static boolean debug = false;
    public static boolean debug_mouse = false;
    public static boolean debug_sql = false;
    public static boolean debug_event = false;
    public static boolean debug_clip = false;
    public static boolean debug_thing = false;
    private static PrintStream printer = System.out;
    public static final double FL_ERROR = 1.0E-7;
    private static LogDispatcher logger = null;
    private static StatusDispatcher status = null;
    private static double last_progress = 0.0;
    private static int last_percent = 0;
    public static String last_dir = Prefs.getString((String)"dir.image");
    public static String last_file = null;
    public static final boolean java3d = Utils.isJava3DInstalled();
    private static Frame frame = null;

    public static void debug(String msg) {
        if (debug) {
            IJ.log((String)msg);
        }
    }

    public static void debugMouse(String msg) {
        if (debug_mouse) {
            IJ.log((String)msg);
        }
    }

    public static final void setup(ControlWindow master) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != status) {
                    status.quit();
                }
                if (null != logger) {
                    logger.quit();
                }
                logger = new LogDispatcher(Thread.currentThread().getThreadGroup());
                status = new StatusDispatcher(Thread.currentThread().getThreadGroup());
            }
        });
    }

    public static final void destroy(ControlWindow master) {
        if (null != status) {
            status.quit();
            status = null;
        }
        if (null != logger) {
            logger.quit();
            logger = null;
        }
    }

    public static synchronized void setLogStream(PrintStream ps) {
        printer = ps;
    }

    public static PrintStream getLogStream() {
        return printer;
    }

    public static final void log(String msg) {
        if (ControlWindow.isGUIEnabled() && null != logger) {
            logger.log(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static final void logStamped(String msg) {
        if (ControlWindow.isGUIEnabled() && null != logger) {
            logger.log(new Date().toString() + " : " + msg);
        } else {
            System.out.println(new Date().toString() + " : " + msg);
        }
    }

    public static final void logAll(String msg) {
        if (!ControlWindow.isGUIEnabled()) {
            System.out.println(msg);
            return;
        }
        System.out.println(msg);
        if (null != IJ.getInstance() && null != logger) {
            logger.log(msg);
        }
        if (null != status) {
            status.showStatus(msg);
        }
    }

    public static final void log2(String msg) {
        System.out.println(msg);
    }

    public static final void log2(Object ob) {
        Utils.log2(null, ob);
    }

    public static final void log2(String msg, Object ob) {
        Utils.log2((null != msg ? msg : "") + ob + "\n\t" + Utils.toString(ob) + "\n");
    }

    public static final void log2(String msg, Object ob1, Object ... ob) {
        StringBuilder sb = new StringBuilder(null == msg ? "" : msg + "\n");
        sb.append(ob1.toString()).append(" : ").append(Utils.toString(ob1)).append('\n');
        for (int i = 0; i < ob.length; ++i) {
            sb.append(ob.toString()).append(" : ").append(Utils.toString(ob[i])).append('\n');
        }
        sb.setLength(sb.length() - 1);
        Utils.log2(sb.toString());
    }

    public static final void log(Object ob) {
        Utils.log(Utils.toString(ob));
    }

    public static final void log(String msg, Object ob) {
        Utils.log((null != msg ? msg : "") + "\n\t" + Utils.toString(ob));
    }

    public static final void log2(Object ... ob) {
        Utils.log2(Utils.toString(ob));
    }

    public static final void logMany2(Object ... ob) {
        Utils.log2(Utils.toString(ob));
    }

    public static final String toString(Object ob) {
        int len;
        Object s;
        if (null == ob) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int closing = 93;
        if (ob instanceof String[]) {
            s = (String[])ob;
            for (int i = 0; i < ((String[])s).length; ++i) {
                sb.append(s[i]).append(", ");
            }
        } else if (ob instanceof int[]) {
            s = (int[])ob;
            for (int i = 0; i < ((String[])s).length; ++i) {
                sb.append((int)s[i]).append(", ");
            }
        } else if (ob instanceof double[]) {
            s = (double[])ob;
            for (int i = 0; i < ((String[])s).length; ++i) {
                sb.append((double)s[i]).append(", ");
            }
        } else if (ob instanceof float[]) {
            s = (float[])ob;
            for (int i = 0; i < ((String[])s).length; ++i) {
                sb.append((float)s[i]).append(", ");
            }
        } else if (ob instanceof char[]) {
            s = (char[])ob;
            for (int i = 0; i < ((String[])s).length; ++i) {
                sb.append((char)s[i]).append(", ");
            }
        } else if (ob instanceof Object[]) {
            s = (Object[])ob;
            for (int i = 0; i < ((Object)s).length; ++i) {
                sb.append(Utils.toString(s[i])).append(", ");
            }
        } else if (ob instanceof Iterable) {
            s = (Iterable)ob;
            Iterator it = s.iterator();
            while (it.hasNext()) {
                sb.append(Utils.toString(it.next())).append(", ");
            }
        } else if (ob instanceof Map) {
            sb.setCharAt(0, '{');
            closing = 125;
            s = (Map)ob;
            for (Map.Entry e : s.entrySet()) {
                sb.append(Utils.toString(e.getKey())).append(" => ").append(Utils.toString(e.getValue())).append(", ");
            }
        } else if (ob instanceof long[]) {
            s = (long[])ob;
            for (int i = 0; i < ((String[])s).length; ++i) {
                sb.append((long)s[i]).append(", ");
            }
        } else if (ob instanceof short[]) {
            s = (short[])ob;
            for (int i = 0; i < ((String[])s).length; ++i) {
                sb.append((int)s[i]).append(", ");
            }
        } else if (ob instanceof boolean[]) {
            s = (boolean[])ob;
            for (int i = 0; i < ((String[])s).length; ++i) {
                sb.append((boolean)s[i]).append(", ");
            }
        } else {
            return ob.toString();
        }
        if ((len = sb.length()) > 2) {
            sb.setLength(len - 2);
        }
        sb.append((char)closing);
        sb.append('\n');
        return sb.toString();
    }

    public static void setDebug(boolean debug) {
        Utils.debug = debug;
    }

    public static void setDebugMouse(boolean debug_mouse) {
        Utils.debug_mouse = debug_mouse;
    }

    public static void setDebugSQL(boolean debug_sql) {
        Utils.debug_sql = debug_sql;
    }

    public static final void printCaller(Object called_object) {
        StackTraceElement[] elems = new Exception().getStackTrace();
        if (elems.length < 3) {
            Utils.log2("Stack trace too short! No useful info");
        } else {
            Utils.log2("#### START TRACE ####\nObject " + called_object.getClass().getName() + " called at: " + elems[1].getFileName() + " " + elems[1].getLineNumber() + ": " + elems[1].getMethodName() + "()\n    by: " + elems[2].getClassName() + " " + elems[2].getLineNumber() + ": " + elems[2].getMethodName() + "()");
            Utils.log2("==== END ====");
        }
    }

    public static final void printCaller(Object called_object, int lines) {
        StackTraceElement[] elems = new Exception().getStackTrace();
        if (elems.length < 3) {
            Utils.log2("Stack trace too short! No useful info");
        } else {
            Utils.log2("#### START TRACE ####\nObject " + called_object.getClass().getName() + " called at: " + elems[1].getFileName() + " " + elems[1].getLineNumber() + ": " + elems[1].getMethodName() + "()\n    by: " + elems[2].getClassName() + " " + elems[2].getLineNumber() + ": " + elems[2].getMethodName() + "()");
            for (int i = 3; i < lines + 2 && i < elems.length; ++i) {
                Utils.log2("\tby: " + elems[i].getClassName() + " " + elems[i].getLineNumber() + ": " + elems[i].getMethodName() + "()");
            }
            Utils.log2("==== END ====");
        }
    }

    public static final String caller(Object called) {
        StackTraceElement[] elems = new Exception().getStackTrace();
        if (elems.length < 3) {
            Utils.log2("Stack trace too short! No useful info");
            return null;
        }
        return elems[2].getClassName();
    }

    public static final void restoreMenuBar() {
        MenuBar menu_bar = Menus.getMenuBar();
        int n_menus = menu_bar.getMenuCount();
        for (int i = 0; i < n_menus; ++i) {
            Menu menu = menu_bar.getMenu(i);
            Utils.restoreMenu(menu);
        }
    }

    private static void restoreMenu(Menu menu) {
        int n_menuitems = menu.getItemCount();
        for (int i = 0; i < n_menuitems; ++i) {
            MenuItem menu_item = menu.getItem(i);
            if (menu_item instanceof Menu) {
                Utils.restoreMenu((Menu)menu_item);
            }
            menu_item.setEnabled(true);
        }
    }

    public static final void showMessage(String msg) {
        if (!ControlWindow.isGUIEnabled()) {
            System.out.println(msg);
        } else {
            IJ.showMessage((String)msg);
        }
    }

    public static final void showMessage(String title, String msg) {
        if (!ControlWindow.isGUIEnabled()) {
            System.out.println(title + "\n" + msg);
        } else {
            IJ.showMessage((String)title, (String)msg);
        }
    }

    public static final void showMessageT(final String msg) {
        new Thread(){

            @Override
            public void run() {
                this.setPriority(5);
                Utils.showMessage(msg);
            }
        }.start();
    }

    public static final void showStatus(String msg, boolean focus) {
        if (null == IJ.getInstance() || !ControlWindow.isGUIEnabled() || null == status) {
            System.out.println(msg);
            return;
        }
        if (focus) {
            IJ.getInstance().toFront();
        }
        status.showStatus(msg);
    }

    public static final void showStatus(String msg) {
        Utils.showStatus(msg, false);
    }

    public static final void showProgress(double p) {
        if (null == IJ.getInstance() || !ControlWindow.isGUIEnabled() || null == status) {
            int percent;
            if (0.0 == p) {
                last_progress = 0.0;
                last_percent = 0;
                return;
            }
            if (last_progress + 0.01 > p && last_percent != (percent = (int)(p * 100.0))) {
                System.out.println(percent + " %");
                last_percent = percent;
            }
            last_progress = p;
            return;
        }
        status.showProgress(p);
    }

    public static void debugDialog() {
        GenericDialog gd = new GenericDialog("Debug:");
        gd.addCheckbox("debug", debug);
        gd.addCheckbox("debug mouse", debug_mouse);
        gd.addCheckbox("debug sql", debug_sql);
        gd.addCheckbox("debug event", debug_event);
        gd.addCheckbox("debug clip", debug_clip);
        gd.addCheckbox("debug thing", debug_thing);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        debug = gd.getNextBoolean();
        debug_mouse = gd.getNextBoolean();
        debug_sql = gd.getNextBoolean();
        debug_event = gd.getNextBoolean();
        debug_clip = gd.getNextBoolean();
        debug_thing = gd.getNextBoolean();
    }

    public static ImagePlus[] findOpenStacks() {
        ImagePlus[] imp = Utils.scanWindowManager("stacks");
        if (null == imp) {
            return null;
        }
        return imp;
    }

    public static ImagePlus[] findOpenImages() {
        ImagePlus[] imp = Utils.scanWindowManager("images");
        if (null == imp) {
            return null;
        }
        return imp;
    }

    public static ImagePlus[] findAllOpenImages() {
        return Utils.scanWindowManager("all");
    }

    private static ImagePlus[] scanWindowManager(String type) {
        int[] all_ids = WindowManager.getIDList();
        if (null == all_ids) {
            return null;
        }
        ImagePlus[] imp = new ImagePlus[all_ids.length];
        int next = 0;
        for (int i = 0; i < all_ids.length; ++i) {
            ImagePlus image = WindowManager.getImage((int)all_ids[i]);
            if (type.equals("stacks") ? image.getStackSize() <= 1 : type.equals("images") && image.getStackSize() > 1) continue;
            imp[next] = image;
            ++next;
        }
        if (next != all_ids.length) {
            ImagePlus[] imp2 = new ImagePlus[next];
            System.arraycopy(imp, 0, imp2, 0, next);
            imp = imp2;
        }
        if (0 == next) {
            return null;
        }
        return imp;
    }

    public static String cutNumber(double d, int n_decimals) {
        return Utils.cutNumber(d, n_decimals, false);
    }

    public static final String cutNumber(double d, int n_decimals, boolean remove_trailing_zeros) {
        int i;
        String num = new Double(d).toString();
        int i_e = num.indexOf("E-");
        if (-1 != i_e) {
            int exp = Integer.parseInt(num.substring(i_e + 2));
            if (n_decimals < exp) {
                StringBuilder sb = new StringBuilder("0.");
                for (int count = n_decimals; count > 0; --count) {
                    sb.append('0');
                }
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder("0.");
            for (int count = exp - 1; count > 0; --count) {
                sb.append('0');
            }
            sb.append(num.charAt(0));
            int i_end = 2 + n_decimals - exp;
            if (i_end > i_e) {
                i_end = i_e;
            }
            sb.append(num.substring(2, i_end));
            return sb.toString();
        }
        int i_dot = num.indexOf(46);
        StringBuilder sb = new StringBuilder(num.substring(0, i_dot + 1));
        for (i = i_dot + 1; i < n_decimals + i_dot + 1 && i < num.length(); ++i) {
            sb.append(num.charAt(i));
        }
        if (remove_trailing_zeros) {
            for (i = sb.length() - 1; i > i_dot + 1 && '0' == sb.charAt(i); --i) {
                sb.setLength(i);
            }
        }
        return sb.toString();
    }

    public static final String zeroPad(int i, int n_digits) {
        StringBuilder sb = new StringBuilder();
        sb.append(i);
        for (int len = sb.length(); len < n_digits; ++len) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static final boolean check(final String msg) {
        try {
            return new TaskOnEDT<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    YesNoCancelDialog dialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Execute?", msg);
                    if (dialog.yesPressed()) {
                        return true;
                    }
                    return false;
                }
            }).get();
        }
        catch (Throwable t) {
            IJError.print(t);
            return false;
        }
    }

    public static final boolean checkYN(final String msg) {
        try {
            return new TaskOnEDT<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    YesNoDialog yn = new YesNoDialog((Frame)IJ.getInstance(), "Execute?", msg);
                    if (yn.yesPressed()) {
                        return true;
                    }
                    return false;
                }
            }).get();
        }
        catch (Throwable t) {
            IJError.print(t);
            return false;
        }
    }

    public static final String d2s(double d, int n_decimals) {
        return IJ.d2s((double)d, (int)n_decimals);
    }

    public static final String[] getHexRGBColor(Color color) {
        String b;
        String g;
        int c = color.getRGB();
        String r = Integer.toHexString((c & 0xFF0000) >> 16);
        if (1 == r.length()) {
            r = "0" + r;
        }
        if (1 == (g = Integer.toHexString((c & 0xFF00) >> 8)).length()) {
            g = "0" + g;
        }
        if (1 == (b = Integer.toHexString(c & 0xFF)).length()) {
            b = "0" + b;
        }
        return new String[]{r, g, b};
    }

    public static final String asHexRGBColor(Color color) {
        StringBuilder sb = new StringBuilder(6);
        Utils.asHexRGBColor(sb, color);
        return sb.toString();
    }

    public static final void asHexRGBColor(StringBuilder sb, Color color) {
        int c = color.getRGB();
        String r = Integer.toHexString((c & 0xFF0000) >> 16);
        if (1 == r.length()) {
            sb.append('0');
        }
        sb.append(r);
        String g = Integer.toHexString((c & 0xFF00) >> 8);
        if (1 == g.length()) {
            sb.append('0');
        }
        sb.append(g);
        String b = Integer.toHexString(c & 0xFF);
        if (1 == b.length()) {
            sb.append('0');
        }
        sb.append(b);
    }

    public static final Color getRGBColorFromHex(String hex) {
        if (hex.length() < 6) {
            return null;
        }
        return new Color(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16));
    }

    public static final int[] get4Ints(int hex) {
        return new int[]{(hex & 0xFF000000) >> 24, (hex & 0xFF0000) >> 16, (hex & 0xFF00) >> 8, hex & 0xFF};
    }

    public void run(String arg) {
        try {
            new TaskOnEDT<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    IJ.showMessage((String)"TrakEM2", (String)("TrakEM2 " + version + "\nCopyright Albert Cardona & Rodney Douglas\n" + "Institute for Neuroinformatics, Univ/ETH Zurich.\n" + "\nRegistration library copyright Stephan Saalfeld, MPI-CBG.\n" + "\nLens correction copyright Verena Kaynig, ETH Zurich.\n" + "\nSome parts copyright Ignacio Arganda, INI Univ/ETH Zurich."));
                    return true;
                }
            }).get();
        }
        catch (Throwable t) {
            IJError.print(t);
        }
    }

    public static final File chooseFile(String name, String extension) {
        return Utils.chooseFile(null, name, extension);
    }

    public static final File chooseFile(final String default_dir, final String name, final String extension) {
        try {
            return new TaskOnEDT<File>(new Callable<File>(){

                @Override
                public File call() {
                    File f;
                    SaveDialog sd;
                    String filename;
                    String name2 = null;
                    if (null != name && null != extension) {
                        name2 = name + extension;
                    } else if (null != name) {
                        name2 = name;
                    } else if (null != extension) {
                        name2 = "untitled" + extension;
                    }
                    if (null != default_dir) {
                        OpenDialog.setDefaultDirectory((String)default_dir);
                    }
                    if (null == (filename = (sd = new SaveDialog("Save", OpenDialog.getDefaultDirectory(), name2, extension)).getFileName()) || filename.toLowerCase().startsWith("null")) {
                        return null;
                    }
                    String dir = sd.getDirectory();
                    if (IJ.isWindows()) {
                        dir = dir.replace('\\', '/');
                    }
                    if (!dir.endsWith("/")) {
                        dir = dir + "/";
                    }
                    if ((f = new File(dir + filename)).exists() && ControlWindow.isGUIEnabled()) {
                        YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Overwrite?", "File " + filename + " exists! Overwrite?");
                        if (d.cancelPressed()) {
                            return null;
                        }
                        if (!d.yesPressed()) {
                            return Utils.chooseFile(name, extension);
                        }
                    }
                    return f;
                }
            }).get();
        }
        catch (Throwable t) {
            IJError.print(t);
            return null;
        }
    }

    public static final String[] selectFile(String title_msg) {
        try {
            return new TaskOnEDT<String[]>(new Callable<String[]>(){

                @Override
                public String[] call() {
                    OpenDialog od = new OpenDialog("Select file", OpenDialog.getDefaultDirectory(), null);
                    String file = od.getFileName();
                    if (null == file || file.toLowerCase().startsWith("null")) {
                        return null;
                    }
                    String dir = od.getDirectory();
                    File f = null;
                    if (null != dir) {
                        if (IJ.isWindows()) {
                            dir = dir.replace('\\', '/');
                        }
                        if (!dir.endsWith("/")) {
                            dir = dir + "/";
                        }
                        f = new File(dir + file);
                    }
                    if (null == dir || !f.exists()) {
                        Utils.log2("No proper file selected.");
                        return null;
                    }
                    return new String[]{dir, file};
                }
            }).get();
        }
        catch (Throwable t) {
            IJError.print(t);
            return null;
        }
    }

    public static final boolean saveToFile(final File f, final String contents) {
        if (null == f) {
            return false;
        }
        try {
            return new TaskOnEDT<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    OutputStreamWriter dos = null;
                    try {
                        dos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(f), contents.length()), "8859_1");
                        dos.write(contents, 0, contents.length());
                        dos.flush();
                        dos.close();
                    }
                    catch (Exception e) {
                        IJError.print(e);
                        Utils.showMessage("ERROR: Most likely did NOT save your file.");
                        try {
                            if (null != dos) {
                                dos.close();
                            }
                        }
                        catch (Exception ee) {
                            IJError.print(ee);
                        }
                        return false;
                    }
                    return true;
                }
            }).get();
        }
        catch (Throwable t) {
            IJError.print(t);
            return false;
        }
    }

    public static final boolean saveToFile(String name, String extension, String contents) {
        if (null == contents) {
            Utils.log2("Utils.saveToFile: contents is null");
            return false;
        }
        File f = Utils.chooseFile(name, extension);
        return Utils.saveToFile(f, contents);
    }

    public static final String cleanString(String s) {
        s = s.trim();
        while (-1 != s.indexOf("  ")) {
            s = s.replaceAll("  ", " ");
        }
        return s;
    }

    public static final String openTextFile(String path) {
        if (null == path || !new File(path).exists()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader r = null;
        try {
            String s;
            r = new BufferedReader(new FileReader(path));
            while (null != (s = r.readLine())) {
                sb.append(s).append('\n');
            }
        }
        catch (Exception e) {
            IJError.print(e);
            if (null != r) {
                try {
                    r.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            return null;
        }
        return sb.toString();
    }

    public static final String[] openTextFileLines(String path) {
        if (null == path || !new File(path).exists()) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        try {
            String s;
            BufferedReader r = new BufferedReader(new FileReader(path));
            while (null != (s = r.readLine())) {
                al.add(s);
            }
            r.close();
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        String[] sal = new String[al.size()];
        al.toArray(sal);
        return sal;
    }

    public static final char[] openTextFileChars(String path) {
        File f = null;
        if (null == path || !(f = new File(path)).exists()) {
            Utils.log("File not found: " + path);
            return null;
        }
        char[] src = new char[(int)f.length()];
        try {
            BufferedReader r = new BufferedReader(new FileReader(path));
            r.read(src, 0, src.length);
            r.close();
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        return src;
    }

    public static final double getCos(double x1, double y1, double x2, double y2) {
        return (x1 * x2 + y1 * y2) / (Math.sqrt(x1 * x1 + y1 * y1) * Math.sqrt(x2 * x2 + y2 * y2));
    }

    public static final String removeExtension(String path) {
        int i_dot = path.lastIndexOf(46);
        if (-1 == i_dot || i_dot + 4 != path.length()) {
            return path;
        }
        return path.substring(0, i_dot);
    }

    public static final void addEnablerListener(Checkbox master, final Component[] enable, final Component[] disable) {
        master.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    this.process(enable, true);
                    this.process(disable, false);
                } else {
                    this.process(enable, false);
                    this.process(disable, true);
                }
            }

            private void process(Component[] c, boolean state) {
                if (null == c) {
                    return;
                }
                for (int i = 0; i < c.length; ++i) {
                    c[i].setEnabled(state);
                }
            }
        });
    }

    public static final boolean wrongImageJVersion() {
        boolean b = IJ.versionLessThan((String)"1.37g");
        if (b) {
            Utils.showMessage("TrakEM2 requires ImageJ 1.37g or above.");
        }
        return b;
    }

    private static final boolean isJava3DInstalled() {
        try {
            Class.forName("org.scijava.vecmath.Point3f");
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public static final void addLayerRangeChoices(Layer selected, GenericDialog gd) {
        Utils.addLayerRangeChoices(selected, selected, gd);
    }

    public static final void addLayerRangeChoices(Layer first, Layer last, GenericDialog gd) {
        String[] layers = new String[first.getParent().size()];
        final ArrayList<String> al_layer_titles = new ArrayList<String>();
        int i = 0;
        for (Layer layer : first.getParent().getLayers()) {
            layers[i] = first.getProject().findLayerThing(layer).toString();
            al_layer_titles.add(layers[i]);
            ++i;
        }
        int i_first = first.getParent().indexOf(first);
        int i_last = last.getParent().indexOf(last);
        gd.addChoice("Start: ", layers, layers[i_first]);
        Vector v = gd.getChoices();
        final Choice cstart = (Choice)v.get(v.size() - 1);
        gd.addChoice("End: ", layers, layers[i_last]);
        final Choice cend = (Choice)v.get(v.size() - 1);
        cstart.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int index = al_layer_titles.indexOf(ie.getItem());
                if (index > cend.getSelectedIndex()) {
                    cend.select(index);
                }
            }
        });
        cend.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int index = al_layer_titles.indexOf(ie.getItem());
                if (index < cstart.getSelectedIndex()) {
                    cstart.select(index);
                }
            }
        });
    }

    public static final void addLayerChoice(String label, Layer selected, GenericDialog gd) {
        String[] layers = new String[selected.getParent().size()];
        ArrayList<String> al_layer_titles = new ArrayList<String>();
        int i = 0;
        for (Layer layer : selected.getParent().getLayers()) {
            layers[i] = selected.getProject().findLayerThing(layer).toString();
            al_layer_titles.add(layers[i]);
            ++i;
        }
        int i_layer = selected.getParent().indexOf(selected);
        gd.addChoice(label, layers, layers[i_layer]);
    }

    public static final void addRGBColorSliders(GenericDialog gd, Color color) {
        gd.addSlider("Red: ", 0.0, 255.0, (double)color.getRed());
        gd.addSlider("Green: ", 0.0, 255.0, (double)color.getGreen());
        gd.addSlider("Blue: ", 0.0, 255.0, (double)color.getBlue());
    }

    public static final ImageProcessor convertTo(ImageProcessor ip, int type, boolean scaling) {
        switch (type) {
            case 0: {
                return ip.convertToByte(scaling);
            }
            case 1: {
                return ip.convertToShort(scaling);
            }
            case 2: {
                return ip.convertToFloat();
            }
            case 4: {
                return ip.convertToRGB();
            }
            case 3: {
                ImagePlus imp = new ImagePlus("", ip.convertToRGB());
                new ImageConverter(imp).convertRGBtoIndexedColor(256);
                return imp.getProcessor();
            }
        }
        return null;
    }

    public static final double[] copy(double[] a, int new_length) {
        double[] b = new double[new_length];
        int len = a.length > new_length ? new_length : a.length;
        System.arraycopy(a, 0, b, 0, len);
        return b;
    }

    public static final long[] copy(long[] a, int new_length) {
        long[] b = new long[new_length];
        int len = a.length > new_length ? new_length : a.length;
        System.arraycopy(a, 0, b, 0, len);
        return b;
    }

    public static final double[] copy(double[] a, int first, int new_length) {
        double[] b = new double[new_length];
        int len = new_length < a.length - first ? new_length : a.length - first;
        System.arraycopy(a, first, b, 0, len);
        return b;
    }

    public static final long[] copy(long[] a, int first, int new_length) {
        long[] b = new long[new_length];
        int len = new_length < a.length - first ? new_length : a.length - first;
        System.arraycopy(a, first, b, 0, len);
        return b;
    }

    public static final void reverse(double[] a) {
        int left = 0;
        for (int right = a.length - 1; left < right; ++left, --right) {
            double tmp = a[left];
            a[left] = a[right];
            a[right] = tmp;
        }
    }

    public static final void reverse(long[] a) {
        int left = 0;
        for (int right = a.length - 1; left < right; ++left, --right) {
            long tmp = a[left];
            a[left] = a[right];
            a[right] = tmp;
        }
    }

    public static final double[] toDouble(int[] a, int len) {
        double[] b = new double[len];
        for (int i = 0; i < len; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public static final int[] toInt(double[] a, int len) {
        int[] b = new int[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (int)a[i];
        }
        return b;
    }

    public static final boolean isPopupTrigger(MouseEvent me) {
        return me.isPopupTrigger() && me.getButton() != 0 || IJ.isWindows() && 0 != (me.getModifiers() & 4);
    }

    public static final void updateComponent(final Component c) {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.repaint();
            }
        });
    }

    public static final void revalidateComponent(final Component c) {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.invalidate();
                c.validate();
                c.repaint();
            }
        });
    }

    public static final String now() {
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        int min = c.get(12);
        int sec = c.get(13);
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour).append(':');
        if (min < 10) {
            sb.append('0');
        }
        sb.append(min).append(':');
        if (sec < 10) {
            sb.append(0);
        }
        return sb.append(sec).toString();
    }

    public static final void sleep(long miliseconds) {
        try {
            Thread.sleep(miliseconds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final Color mix(Color c1, Color c2) {
        float d2;
        float d1;
        float[] b = Color.RGBtoHSB(c1.getRed(), c1.getGreen(), c1.getBlue(), new float[3]);
        float[] c = Color.RGBtoHSB(c2.getRed(), c2.getGreen(), c2.getBlue(), new float[3]);
        float[] a = new float[3];
        float h1 = b[0];
        float h2 = c[0];
        if (h1 < h2) {
            float tmp = h1;
            h1 = h2;
            h2 = tmp;
        }
        if ((d1 = h2 - h1) < (d2 = 1.0f + h1 - h2)) {
            a[0] = h1 + d1 / 2.0f;
        } else {
            a[0] = h2 + d2 / 2.0f;
            if (a[0] > 1.0f) {
                a[0] = a[0] - 1.0f;
            }
        }
        for (int i = 1; i < 3; ++i) {
            a[i] = (b[i] + c[i]) / 2.0f;
        }
        return Color.getHSBColor(a[0], a[1], a[2]);
    }

    public static final String getCharacter(int i) {
        int k = --i / 26;
        char c = (char)(i % 26 + 65);
        if (0 == k) {
            return Character.toString(c);
        }
        return Utils.getCharacter(k) + c;
    }

    public static final Object getField(Object ob, String field_name) {
        if (null == ob || null == field_name) {
            return null;
        }
        return Utils.getField(ob, ob.getClass(), field_name);
    }

    public static final Object getField(Object ob, Class<?> c, String field_name) {
        try {
            Field f = c.getDeclaredField(field_name);
            f.setAccessible(true);
            return f.get(ob);
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    public static final void setField(Object ob, Class<?> c, String field_name, Object value) {
        try {
            Field f = c.getDeclaredField(field_name);
            f.setAccessible(true);
            f.set(ob, value);
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    public static final FloatProcessor fastConvertToFloat(ByteProcessor ip) {
        byte[] pix = (byte[])ip.getPixels();
        float[] data = new float[pix.length];
        for (int i = 0; i < pix.length; ++i) {
            data[i] = pix[i] & 0xFF;
        }
        FloatProcessorT2 fp = new FloatProcessorT2(ip.getWidth(), ip.getHeight(), data, ip.getColorModel(), ip.getMin(), ip.getMax());
        return fp;
    }

    public static final FloatProcessor fastConvertToFloat(ShortProcessor ip) {
        short[] pix = (short[])ip.getPixels();
        float[] data = new float[pix.length];
        for (int i = 0; i < pix.length; ++i) {
            data[i] = pix[i] & 0xFFFF;
        }
        FloatProcessorT2 fp = new FloatProcessorT2(ip.getWidth(), ip.getHeight(), data, ip.getColorModel(), ip.getMin(), ip.getMax());
        return fp;
    }

    public static final FloatProcessor fastConvertToFloat(ImageProcessor ip, int type) {
        switch (type) {
            case 1: {
                return Utils.fastConvertToFloat((ShortProcessor)ip);
            }
            case 2: {
                return (FloatProcessor)ip;
            }
            case 0: 
            case 3: {
                return Utils.fastConvertToFloat((ByteProcessor)ip);
            }
            case 4: {
                return (FloatProcessor)ip.convertToFloat();
            }
        }
        return null;
    }

    public static final FloatProcessor fastConvertToFloat(ImageProcessor ip) {
        if (ip instanceof ByteProcessor) {
            return Utils.fastConvertToFloat((ByteProcessor)ip);
        }
        if (ip instanceof ShortProcessor) {
            return Utils.fastConvertToFloat((ShortProcessor)ip);
        }
        return (FloatProcessor)ip.convertToFloat();
    }

    public static final ResultsTable createResultsTable(final String title, final String[] columns) {
        try {
            return new TaskOnEDT<ResultsTable>(new Callable<ResultsTable>(){

                @Override
                public ResultsTable call() {
                    ResultsTable rt;
                    TextWindow tw = (TextWindow)WindowManager.getFrame((String)title);
                    if (null != tw && null != (rt = (ResultsTable)Utils.getField(tw.getTextPanel(), "rt"))) {
                        return rt;
                    }
                    rt = new ResultsTable();
                    rt.setPrecision(2);
                    for (int i = 0; i < columns.length; ++i) {
                        rt.setHeading(i, columns[i]);
                    }
                    return rt;
                }
            }).get();
        }
        catch (Throwable t) {
            IJError.print(t);
            return null;
        }
    }

    public static final ImageProcessor createProcessor(int type, int width, int height) {
        switch (type) {
            case 0: {
                return new ByteProcessor(width, height);
            }
            case 1: {
                return new ShortProcessor(width, height);
            }
            case 2: {
                return new FloatProcessor(width, height);
            }
            case 4: {
                return new ColorProcessor(width, height);
            }
        }
        return null;
    }

    public static void paint(Pipe pipe, Map<Layer, ImageProcessor> slices, int value, float scale) {
        VectorString3D vs = pipe.asVectorString3D();
        vs.resample(1.0);
        double[] px = vs.getPoints(0);
        double[] py = vs.getPoints(1);
        double[] pz = vs.getPoints(2);
        double[] pr = vs.getDependent(0);
        for (int i = 0; i < px.length - 1; ++i) {
            ImageProcessor ip = slices.get(pipe.getLayerSet().getNearestLayer(pz[i]));
            if (null == ip) continue;
            OvalRoi ov = new OvalRoi((int)((px[i] - pr[i]) * (double)scale), (int)((py[i] - pr[i]) * (double)scale), (int)(pr[i] * 2.0 * (double)scale), (int)(pr[i] * 2.0 * (double)scale));
            ip.setRoi((Roi)ov);
            ip.setValue((double)value);
            ip.fill(ip.getMask());
        }
    }

    public static final boolean matches(String pattern, String s) {
        return Pattern.compile(pattern).matcher(s).matches();
    }

    public static final boolean isValidIdentifier(String s) {
        if (null == s) {
            return false;
        }
        if (!Utils.matches("^[a-zA-Z]+[a-zA-Z1-9_]*$", s)) {
            Utils.log("Invalid identifier " + s);
            return false;
        }
        return true;
    }

    public static final String makeValidIdentifier(String s) {
        if (null == s) {
            return null;
        }
        Pattern pat = Pattern.compile("\\b[a-zA-Z]+[\\w]*\\b");
        Matcher m = pat.matcher(s);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            sb.append(m.group()).append('_');
        }
        if (0 == sb.length()) {
            return null;
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static final int indexOf(Object needle, Object[] haystack) {
        for (int i = 0; i < haystack.length; ++i) {
            if (!haystack[i].equals(needle)) continue;
            return i;
        }
        return -1;
    }

    public static final boolean removeFile(File f) {
        return Utils.removeFile(f, true, null);
    }

    private static final boolean removeFile(File f, boolean stop_if_dir_not_empty, ArrayList<String> removed_paths) {
        if (null == f || !f.exists()) {
            return false;
        }
        try {
            if (!Utils.isTrakEM2Subfile(f)) {
                Utils.log2("REFUSING to remove file " + f + "\n-->REASON: not in a '/trakem2.' file path");
                return false;
            }
            if (!f.isDirectory()) {
                return f.delete();
            }
            ArrayList<File> dirs = new ArrayList<File>();
            dirs.add(f);
            do {
                int i = dirs.size() - 1;
                File fdir = (File)dirs.get(i);
                Utils.log2("Examining folder for deletion: " + fdir.getName());
                boolean remove = true;
                File[] files = fdir.listFiles();
                if (null != files) {
                    for (File file : files) {
                        String name = file.getName();
                        if (name.equals(".") || name.equals("..")) continue;
                        if (file.isDirectory()) {
                            remove = false;
                            dirs.add(file);
                            continue;
                        }
                        if (file.isHidden()) {
                            if (!file.delete()) {
                                Utils.log("Failed to delete hidden file " + file.getAbsolutePath());
                                return false;
                            }
                            if (null == removed_paths) continue;
                            removed_paths.add(file.getAbsolutePath());
                            continue;
                        }
                        if (stop_if_dir_not_empty) {
                            return false;
                        }
                        if (!file.delete()) {
                            Utils.log("Failed to delete visible file " + file.getAbsolutePath());
                            return false;
                        }
                        if (null == removed_paths) continue;
                        removed_paths.add(file.getAbsolutePath());
                    }
                }
                if (!remove) continue;
                dirs.remove(i);
                if (!fdir.delete()) {
                    return false;
                }
                Utils.log2("Removed folder " + fdir.getAbsolutePath());
            } while (dirs.size() > 0);
            return true;
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
    }

    public static boolean isTrakEM2Subfile(File f) throws Exception {
        return Utils.isTrakEM2Subpath(f.getCanonicalPath());
    }

    public static boolean isTrakEM2Subpath(String path) {
        if (IJ.isWindows()) {
            path = path.replace('\\', '/');
        }
        return -1 != path.toLowerCase().indexOf("/trakem2.");
    }

    public static final boolean removePrefixedFiles(File parent, final String prefix, ArrayList<String> removed_paths) {
        if (null == parent || !parent.isDirectory()) {
            return false;
        }
        try {
            if (!Utils.isTrakEM2Subfile(parent)) {
                Utils.log2("REFUSING to remove files recursively under folder " + parent + "\n-->REASON: not in a '/trakem2.' file path");
                return false;
            }
            File[] list = parent.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            });
            boolean success = true;
            ArrayList<String> a = null;
            if (null != removed_paths) {
                a = new ArrayList<String>();
            }
            if (null != list && list.length > 0) {
                for (File f : list) {
                    if (!Utils.removeFile(f, false, a)) {
                        success = false;
                    }
                    if (null == removed_paths) continue;
                    removed_paths.addAll(a);
                    a.clear();
                }
            }
            return success;
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
    }

    public static final int getControlModifier() {
        return IJ.isMacOSX() ? 4 : 2;
    }

    public static final boolean isControlDown(InputEvent e) {
        return IJ.isMacOSX() ? e.isMetaDown() : e.isControlDown();
    }

    public static final void drawPoint(Graphics g, int x, int y) {
        g.setColor(Color.white);
        g.drawLine(x - 4, y + 2, x + 8, y + 2);
        g.drawLine(x + 2, y - 4, x + 2, y + 8);
        g.setColor(Color.yellow);
        g.fillRect(x + 1, y + 1, 3, 3);
        g.setColor(Color.black);
        g.drawRect(x, y, 4, 4);
    }

    public static final String trim(CharSequence sb) {
        char c;
        int start = 0;
        do {
            c = sb.charAt(start);
            ++start;
        } while ('\t' == c || ' ' == c || '\n' == c);
        int end = sb.length() - 1;
        do {
            c = sb.charAt(end);
            --end;
        } while ('\n' == c || ' ' == c || '\t' == c);
        return sb.subSequence(start - 1, end + 2).toString();
    }

    public static final void wait(Collection<Future<?>> fus) {
        for (Future<?> fu : fus) {
            if (null == fu) continue;
            try {
                fu.get();
            }
            catch (Exception e) {
                IJError.print(e);
                if (!Thread.currentThread().isInterrupted()) continue;
                return;
            }
        }
    }

    public static final void waitIfAlive(Collection<Future<?>> fus, boolean throwException) {
        for (Future<?> fu : fus) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (null == fu) continue;
            try {
                fu.get();
            }
            catch (Exception e) {
                if (!throwException) continue;
                IJError.print(e);
            }
        }
    }

    public static final String fixDir(String path) {
        if (IJ.isWindows()) {
            path = path.replace('\\', '/');
        }
        return '/' == path.charAt(path.length() - 1) ? path : new StringBuilder(path.length() + 1).append(path).append('/').toString();
    }

    public static final ThreadPoolExecutor newFixedThreadPool(int n_proc) {
        return Utils.newFixedThreadPool(n_proc, null);
    }

    public static final ThreadPoolExecutor newFixedThreadPool(String namePrefix) {
        return Utils.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), namePrefix);
    }

    public static final ThreadPoolExecutor newFixedThreadPool(int n_proc, String namePrefix) {
        return Utils.newFixedThreadPool(n_proc, namePrefix, true);
    }

    public static final ThreadPoolExecutor newFixedThreadPool(int n_proc, final String namePrefix, final boolean use_caching_thread) {
        ThreadPoolExecutor exec = (ThreadPoolExecutor)Executors.newFixedThreadPool(n_proc);
        exec.setThreadFactory(new ThreadFactory(){
            final AtomicInteger ai = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                String name = (null == namePrefix ? tg.getName() : namePrefix) + '-' + this.ai.incrementAndGet();
                Thread t = use_caching_thread ? new CachingThread(tg, r, name) : new Thread(tg, r, name);
                t.setDaemon(true);
                t.setPriority(5);
                return t;
            }
        });
        return exec;
    }

    public static final boolean equalContent(Collection<?> a, Collection<?> b) {
        if (null == a && null != b || null != b && null == b) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<?> ia = a.iterator();
        Iterator<?> ib = b.iterator();
        while (ia.hasNext()) {
            if (ia.next().equals(ib.next())) continue;
            return false;
        }
        return true;
    }

    public static final boolean equalContent(Map<?, ?> a, Map<?, ?> b) {
        if (null == a && null != b || null != b && null == b) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry<?, ?> e : a.entrySet()) {
            Object ob = b.get(e.getKey());
            if (null != ob && !ob.equals(e.getValue())) {
                return false;
            }
            if (null == e.getValue() || e.getValue().equals(ob)) continue;
            return false;
        }
        return true;
    }

    public static final boolean addPlugIns(JPopupMenu popup, String menu, Project project, Callable<Displayable> active) {
        JMenu m = Utils.addPlugIns(menu, project, active);
        if (null == m) {
            return false;
        }
        popup.add(m);
        return true;
    }

    public static final JMenu addPlugIns(String menu, final Project project, final Callable<Displayable> active) {
        JMenuItem item;
        TreeMap<String, TPlugIn> plugins = project.getPlugins(menu);
        if (0 == plugins.size()) {
            return null;
        }
        Displayable d = null;
        try {
            d = active.call();
        }
        catch (Exception e) {
            IJError.print(e);
        }
        JMenu m = new JMenu("Plugins");
        int count = 0;
        for (final Map.Entry e : plugins.entrySet()) {
            item = new JMenuItem((String)e.getKey());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Bureaucrat.createAndStart((Worker)new Worker.Task((String)e.getKey()){

                        @Override
                        public void exec() {
                            try {
                                ((TPlugIn)e.getValue()).invoke(active.call());
                            }
                            catch (Exception e) {
                                IJError.print(e);
                            }
                        }
                    }, project);
                }
            });
            item.setEnabled(((TPlugIn)e.getValue()).applies(d));
            if (count < 9) {
                item.setAccelerator(KeyStroke.getKeyStroke(49 + count, Utils.getControlModifier(), true));
            }
            m.add(item);
            ++count;
        }
        if (0 == m.getItemCount()) {
            return null;
        }
        m.addSeparator();
        for (final Map.Entry e : plugins.entrySet()) {
            item = new JMenuItem("Setup " + (String)e.getKey());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Bureaucrat.createAndStart((Worker)new Worker.Task((String)e.getKey()){

                        @Override
                        public void exec() {
                            try {
                                ((TPlugIn)e.getValue()).setup(active.call());
                            }
                            catch (Exception e) {
                                IJError.print(e);
                            }
                        }
                    }, project);
                }
            });
            m.add(item);
        }
        return m;
    }

    public static final Bureaucrat launchTPlugIn(KeyEvent ke, String menu, Project project, final Displayable active) {
        try {
            int index;
            TreeMap<String, TPlugIn> plugins;
            if (0 == (ke.getModifiers() ^ Utils.getControlModifier()) && (plugins = project.getPlugins("Display")).size() > 0 && (index = ke.getKeyCode() - 49) < plugins.size()) {
                int count = 0;
                for (final Map.Entry<String, TPlugIn> e : plugins.entrySet()) {
                    if (index != count) {
                        ++count;
                        continue;
                    }
                    return Bureaucrat.createAndStart((Worker)new Worker.Task(e.getKey()){

                        @Override
                        public void exec() {
                            ((TPlugIn)e.getValue()).invoke(active);
                        }
                    }, project);
                }
            }
        }
        catch (Throwable t) {
            IJError.print(t);
        }
        return null;
    }

    public static final Dimension getDimensions(String text, Font font) {
        if (null == frame) {
            frame = new Frame();
            frame.pack();
            frame.setBackground(Color.white);
        }
        FontMetrics fm = frame.getFontMetrics(font);
        int[] w = fm.getWidths();
        int width = 0;
        for (int i = text.length() - 1; i > -1; --i) {
            char c = text.charAt(i);
            if (c >= '\u0100') continue;
            width += w[c];
        }
        return new Dimension(width, fm.getHeight());
    }

    public static final InputStream createStream(String path_or_url) throws Exception {
        return 0 == path_or_url.indexOf("http://") ? new URL(path_or_url).openStream() : new BufferedInputStream(new FileInputStream(path_or_url));
    }

    public static final List<Long> asList(long[] ids) {
        return Utils.asList(ids, 0, ids.length);
    }

    public static final List<Long> asList(long[] ids, int first, int length) {
        ArrayList<Long> l = new ArrayList<Long>();
        if (null == ids) {
            return l;
        }
        for (int i = first; i < length; ++i) {
            l.add(ids[i]);
        }
        return l;
    }

    public static void setEnabled(Container root, boolean b) {
        LinkedList<Container> cs = new LinkedList<Container>();
        cs.add(root);
        while (cs.size() > 0) {
            for (Component c : ((Container)cs.removeLast()).getComponents()) {
                if (c instanceof Container) {
                    cs.add((Container)c);
                }
                c.setEnabled(b);
            }
        }
    }

    public static final boolean ensure(String filepath) {
        return Utils.ensure(new File(filepath));
    }

    public static final synchronized boolean ensure(File f) {
        File parent = f.getParentFile();
        if (!parent.exists()) {
            if (!parent.mkdirs()) {
                Utils.log("FAILED to create directories " + parent.getAbsolutePath());
                return false;
            }
        } else if (!parent.canWrite()) {
            Utils.log("Cannot write to parent directory " + parent.getAbsolutePath());
            return false;
        }
        return true;
    }

    public static final int luminance(Color c) {
        return (int)((float)c.getRed() * 0.3f + (float)c.getGreen() * 0.6f + (float)c.getBlue() * 0.1f + 0.5f);
    }

    public static final void invokeLater(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static final void showAllTables(HashMap<Class<?>, ResultsTable> ht) {
        for (Map.Entry<Class<?>, ResultsTable> entry : ht.entrySet()) {
            String title;
            Class<?> c = entry.getKey();
            if (ProjectThing.Profile_List.class == c) {
                title = "Profile List";
            } else {
                title = c.getName();
                int idot = title.lastIndexOf(46);
                if (-1 != idot) {
                    title = title.substring(idot + 1);
                }
            }
            entry.getValue().show(title + " results");
        }
    }

    public static final IndexColorModel fireLUT() {
        ImagePlus imp = new ImagePlus("fire", (ImageProcessor)new ByteProcessor(1, 1));
        IJ.run((ImagePlus)imp, (String)"Fire", (String)"");
        return (IndexColorModel)imp.getProcessor().getColorModel();
    }

    public static final BufferedImage convertToBufferedImage(ByteProcessor bp) {
        bp.setMinAndMax(0.0, 255.0);
        Image img = bp.createImage();
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi = new BufferedImage(bp.getWidth(), bp.getHeight(), 13, Loader.GRAY_LUT);
        bi.createGraphics().drawImage(img, 0, 0, null);
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean safeCopy(String source, String target) throws IOException {
        File f2 = new File(target);
        if (f2.exists()) {
            return false;
        }
        RandomAccessFile sra = null;
        RandomAccessFile tra = null;
        try {
            Utils.ensure(f2);
            sra = new RandomAccessFile(new File(source), "r");
            tra = new RandomAccessFile(f2, "rw");
            sra.getChannel().transferTo(0L, sra.length(), tra.getChannel());
        }
        finally {
            if (null != tra) {
                tra.close();
            }
            if (null != sra) {
                sra.close();
            }
        }
        return true;
    }

    public static final <A, B> ArrayList<B> castCollection(Collection<A> classAs, Class<B> type, boolean doThrow) {
        ArrayList<A> classBs = new ArrayList<A>(classAs.size());
        for (A a : classAs) {
            try {
                classBs.add(a);
            }
            catch (ClassCastException cce) {
                if (!doThrow) continue;
                throw cce;
            }
        }
        return classBs;
    }

    private static final class StatusDispatcher
    extends Thread {
        private volatile String msg = null;
        private volatile double progress = -1.0;

        public StatusDispatcher(ThreadGroup tg) {
            super(tg, "T2-Status-Dispatcher");
            this.setPriority(5);
            try {
                this.setDaemon(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void quit() {
            this.interrupt();
            StatusDispatcher statusDispatcher = this;
            synchronized (statusDispatcher) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showStatus(String msg) {
            try {
                StatusDispatcher statusDispatcher = this;
                synchronized (statusDispatcher) {
                    this.msg = msg;
                    this.notify();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showProgress(double progress) {
            try {
                StatusDispatcher statusDispatcher = this;
                synchronized (statusDispatcher) {
                    this.progress = progress;
                    this.notify();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    String msg = null;
                    double progress = -1.0;
                    StatusDispatcher statusDispatcher = this;
                    synchronized (statusDispatcher) {
                        if (null != this.msg) {
                            msg = this.msg;
                            this.msg = null;
                        }
                        if (-1.0 != this.progress) {
                            progress = this.progress;
                            this.progress = -1.0;
                        }
                    }
                    if (null != msg) {
                        IJ.showStatus((String)msg);
                        msg = null;
                    }
                    if (-1.0 != progress) {
                        IJ.showProgress((double)progress);
                    }
                    Thread.sleep(100L);
                    statusDispatcher = this;
                    synchronized (statusDispatcher) {
                        if (null == this.msg && -1.0 == this.progress) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (InterruptedException msg) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static final class LogDispatcher
    extends Thread {
        private final StringBuilder cache = new StringBuilder();

        public LogDispatcher(ThreadGroup tg) {
            super(tg, "T2-Log-Dispatcher");
            this.setPriority(5);
            try {
                this.setDaemon(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void quit() {
            this.interrupt();
            StringBuilder stringBuilder = this.cache;
            synchronized (stringBuilder) {
                this.cache.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void log(String msg) {
            try {
                StringBuilder stringBuilder = this.cache;
                synchronized (stringBuilder) {
                    this.cache.append(msg).append('\n');
                    this.cache.notify();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuilder sb = new StringBuilder();
            while (!this.isInterrupted()) {
                try {
                    StringBuilder stringBuilder;
                    long start = System.currentTimeMillis();
                    do {
                        stringBuilder = this.cache;
                        synchronized (stringBuilder) {
                            if (this.cache.length() > 0) {
                                sb.append((CharSequence)this.cache);
                                this.cache.setLength(0);
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    } while (System.currentTimeMillis() - start < 1000L);
                    if (sb.length() > 0) {
                        IJ.log((String)sb.toString());
                        sb.setLength(0);
                    }
                    stringBuilder = this.cache;
                    synchronized (stringBuilder) {
                        if (0 == this.cache.length()) {
                            try {
                                this.cache.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

