/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.IJ;
import ij.Menus;
import ij.gui.Toolbar;
import ij.plugin.MacroInstaller;
import ini.trakem2.display.Display;
import ini.trakem2.utils.Utils;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;

public class ProjectToolbar
implements MouseListener {
    public static final int SELECT = 10;
    public static final int PENCIL = 15;
    public static final int PEN = 16;
    public static final int BRUSH = 17;
    public static final int WAND = 18;
    private static String startup_macros = null;
    private static ProjectToolbar instance = null;

    private ProjectToolbar() {
    }

    public static synchronized void setProjectToolbar() {
        if (null == instance) {
            instance = new ProjectToolbar();
        }
        MacroInstaller installer = new MacroInstaller();
        boolean toolbar_present = false;
        try {
            ActionListener[] al = Menus.getMacrosMenu().getActionListeners();
            MacroInstaller minst = null;
            for (int j = al.length - 1; j > -1; --j) {
                if (!(al[j] instanceof MacroInstaller)) continue;
                minst = (MacroInstaller)al[j];
                break;
            }
            if (null != minst) {
                Field f_macroNames = MacroInstaller.class.getDeclaredField("macroNames");
                f_macroNames.setAccessible(true);
                Object ob = f_macroNames.get(minst);
                if (null != ob) {
                    String[] macroNames = (String[])ob;
                    if (null == macroNames) {
                        return;
                    }
                    if (macroNames.length > 3 && null != macroNames[0] && 0 == macroNames[0].indexOf("Select and Transform") && null != macroNames[1] && 0 == macroNames[1].indexOf("Freehand") && null != macroNames[2] && 0 == macroNames[2].indexOf("Pen") && null != macroNames[3] && 0 == macroNames[3].indexOf("Align")) {
                        toolbar_present = true;
                    }
                }
            }
        }
        catch (Exception e) {
            Utils.log2("Can't check if toolbar is in place.");
        }
        if (!toolbar_present) {
            int tool = Toolbar.getToolId();
            StringBuilder sb_tools = new StringBuilder();
            sb_tools.append("macro 'Select and Transform Tool-C000L2242L2363L3494L35b5L46c6L4797L48a8L49b9L5a6aL8acaL5b6bL9bdbL5c5cLacdcLbdcd' {\ncall('ini.trakem2.utils.ProjectToolbar.toolChanged', 'SELECT');\n}\n").append("macro 'Freehand Tool-C000Lb0c0La1d1L92e2L83f3L74f4L65e5L56d6L47c7L38b8L29a9L2a2aL4a9aL1b2bL5b8bL1c1cL6c7cL0d1dL5d6dL0e0eL3e5eL0f3f' {\ncall('ini.trakem2.utils.ProjectToolbar.toolChanged', 'PENCIL');\n}\n").append("macro 'Pen Tool-C000L8080L7191L7292L6363L8383La3a3L6464L8484Lb4b4L5555L8585Lb5b5L4646L8686Lc6c6L4747Lc7c7L3838Ld8d8L4949Lc9c9L4a4aLcacaL5b5bLbbbbL5c5cLbcbcL4dcdL5e5eLbebeL5fbf' {\ncall('ini.trakem2.utils.ProjectToolbar.toolChanged', 'PEN');\n}\n").append("macro 'Brush Tool - C037La077Ld098L6859L4a2fL2f4fL3f99L5e9bL9b98L6888L5e8dL888c' {\ncall('ini.trakem2.utils.ProjectToolbar.toolChanged', 'BRUSH');\n}\n");
            installer.install(sb_tools.toString());
            Toolbar.getInstance().setTool(tool);
        }
    }

    public static void toolChanged(String tool_name) {
    }

    public static void setImageJToolbar() {
        block7: {
            File f;
            String macros_path;
            MouseListener[] ml = Toolbar.getInstance().getMouseListeners();
            for (int i = 0; i < ml.length; ++i) {
                if (!ml[i].equals(instance)) continue;
                Toolbar.getInstance().removeMouseListener((MouseListener)instance);
                break;
            }
            if (null == startup_macros && null != (macros_path = Menus.getMacrosPath()) && (f = new File(macros_path)).isDirectory()) {
                String[] mf = f.list();
                for (int i = 0; i < mf.length; ++i) {
                    if (!mf[i].toLowerCase().equals("startupmacros.txt")) continue;
                    startup_macros = Utils.openTextFile(macros_path + "/" + mf[i]);
                    break;
                }
            }
            if (null == startup_macros && "1.53t".compareTo("1.38a") >= 0) {
                try {
                    MacroInstaller mi = new MacroInstaller();
                    String path = "/macros/StartupMacros.txt";
                    Method m = MacroInstaller.class.getDeclaredMethod("installFromIJJar", new Class[0]);
                    m.invoke((Object)mi, path);
                    return;
                }
                catch (Exception e) {
                    if (null == IJ.getInstance() || !IJ.getInstance().quitting()) break block7;
                    Utils.log("Failed to restore ImageJ toolbar");
                }
            }
        }
        if (null != startup_macros) {
            new MacroInstaller().install(startup_macros);
        }
    }

    public static void destroy() {
        if (null != IJ.getInstance() && !IJ.getInstance().quitting()) {
            ProjectToolbar.setImageJToolbar();
        }
    }

    public static void setTool(final int t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Toolbar.getInstance().setTool(t);
            }
        });
        Display.repaintToolbar();
    }

    public static int getToolId() {
        int tool = Toolbar.getToolId();
        if (8 == tool) {
            return 18;
        }
        return tool;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int ij_tool = Toolbar.getToolId();
        Utils.log2("Tool: " + ij_tool);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    public static int getBrushSize() {
        int brushSize = 15;
        try {
            Field f = Toolbar.class.getDeclaredField("brushSize");
            f.setAccessible(true);
            brushSize = (Integer)f.get(Toolbar.getInstance());
            if (brushSize < 1) {
                brushSize = 15;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return brushSize;
    }

    public static int setBrushSize(int inc) {
        int brushSize = 15;
        try {
            Field f = Toolbar.class.getDeclaredField("brushSize");
            f.setAccessible(true);
            brushSize = (Integer)f.get(Toolbar.getInstance());
            brushSize = brushSize + inc < 1 ? 1 : (brushSize += inc);
            f.setInt(Toolbar.getInstance(), brushSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return brushSize;
    }

    public static void keyPressed(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 112: {
                ProjectToolbar.setTool(0);
                break;
            }
            case 113: {
                ProjectToolbar.setTool(2);
                break;
            }
            case 114: {
                ProjectToolbar.setTool(3);
                break;
            }
            case 115: {
                ProjectToolbar.setTool(9);
                break;
            }
            case 116: {
                ProjectToolbar.setTool(11);
                break;
            }
            case 117: {
                ProjectToolbar.setTool(12);
                break;
            }
            case 118: {
                break;
            }
            case 119: {
                break;
            }
            case 120: {
                ProjectToolbar.setTool(10);
                break;
            }
            case 121: {
                ProjectToolbar.setTool(15);
                break;
            }
            case 122: {
                ProjectToolbar.setTool(16);
                break;
            }
            case 123: {
                ProjectToolbar.setTool(17);
            }
        }
    }

    public static boolean isDataEditTool(int tool) {
        switch (tool) {
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public static final int getForegroundColorValue() {
        return Utils.luminance(Toolbar.getForegroundColor());
    }
}

