/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.io;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.PlanarImage;
import javax.swing.JFrame;

public class ImageSaver {
    private static final Object OBDIRS = new Object();
    private static final Map<String, Object> pathlocks = new HashMap<String, Object>();
    public static final DirectColorModel RGBA_COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    public static final DirectColorModel RGBA_PRE_COLOR_MODEL = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final DirectColorModel RGB_COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255);
    public static final Field Bbuf;

    private ImageSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean checkPath(String path) {
        if (null == path) {
            Utils.log("Null path, can't save.");
            return false;
        }
        File fdir = new File(path).getParentFile();
        if (!fdir.exists()) {
            try {
                Object object = OBDIRS;
                synchronized (object) {
                    if (!fdir.exists()) {
                        fdir.mkdirs();
                    }
                    return fdir.exists();
                }
            }
            catch (Exception e) {
                IJError.print(e, true);
                Utils.log("Can't use path: " + path + "\nCheck your file read/write permissions.");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object getPathLock(String path) {
        Object lock = null;
        Map<String, Object> map = pathlocks;
        synchronized (map) {
            lock = pathlocks.get(path);
            if (null == lock) {
                lock = new Object();
                pathlocks.put(path, lock);
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void removePathLock(String path) {
        Map<String, Object> map = pathlocks;
        synchronized (map) {
            pathlocks.remove(path);
        }
    }

    public static final boolean saveAsJpeg(ImageProcessor ip, String path, float quality, boolean as_grey) {
        if (null == ip) {
            Utils.log("Null ip, can't saveAsJpeg");
            return false;
        }
        BufferedImage bi = null;
        bi = as_grey ? new BufferedImage(ip.getWidth(), ip.getHeight(), 10) : new BufferedImage(ip.getWidth(), ip.getHeight(), 1);
        Graphics2D g = bi.createGraphics();
        Image awt = ip.createImage();
        g.drawImage(awt, 0, 0, null);
        g.dispose();
        awt.flush();
        boolean b = ImageSaver.saveAsJpeg(bi, path, quality, as_grey);
        bi.flush();
        return b;
    }

    public static final BufferedImage createGrayImage(byte[] pixels, int width, int height) {
        WritableRaster wr = Loader.GRAY_LUT.createCompatibleWritableRaster(1, 1);
        SampleModel sm = wr.getSampleModel().createCompatibleSampleModel(width, height);
        DataBufferByte db = new DataBufferByte(pixels, width * height, 0);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(Loader.GRAY_LUT, raster, false, null);
    }

    public static final boolean saveAsGreyJpeg(byte[] pixels, int width, int height, String path, float quality) {
        return ImageSaver.saveAsJpeg(ImageSaver.createGrayImage(pixels, width, height), path, quality, true);
    }

    public static final BufferedImage createImage(int[] pixels, int width, int height, DirectColorModel cm) {
        WritableRaster wr = cm.createCompatibleWritableRaster(1, 1);
        SampleModel sm = wr.getSampleModel().createCompatibleSampleModel(width, height);
        DataBufferInt dataBuffer = new DataBufferInt(pixels, width * height, 0);
        WritableRaster rgbRaster = Raster.createWritableRaster(sm, dataBuffer, null);
        return new BufferedImage(cm, rgbRaster, cm == RGBA_PRE_COLOR_MODEL, null);
    }

    public static final BufferedImage createRGBImage(int[] pixels, int width, int height) {
        return ImageSaver.createImage(pixels, width, height, RGB_COLOR_MODEL);
    }

    public static final BufferedImage createARGBImage(int[] pixels, int width, int height) {
        return ImageSaver.createImage(pixels, width, height, RGBA_COLOR_MODEL);
    }

    public static final BufferedImage createARGBImagePre(int[] pixels, int width, int height) {
        return ImageSaver.createImage(pixels, width, height, RGBA_PRE_COLOR_MODEL);
    }

    public static final boolean saveAsARGBJpeg(int[] pixels, int width, int height, String path, float quality) {
        return ImageSaver.saveAsJpeg(ImageSaver.createARGBImage(pixels, width, height), path, quality, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean saveAsJpeg(BufferedImage bi, String path, float quality, boolean as_grey) {
        if (!ImageSaver.checkPath(path)) {
            return false;
        }
        if (quality < 0.0f) {
            quality = 0.0f;
        }
        if (quality > 1.0f) {
            quality = 1.0f;
        }
        Object object = ImageSaver.getPathLock(path);
        synchronized (object) {
            ImageOutputStream ios = null;
            ImageWriter writer = null;
            BufferedImage grey = bi;
            try {
                writer = ImageIO.getImageWritersByFormatName("jpeg").next();
                ByteArrayOutputStream baos2332 = new ByteArrayOutputStream(ImageSaver.estimateJPEGFileSize(bi.getWidth(), bi.getHeight()));
                ios = ImageIO.createImageOutputStream(baos2332);
                writer.setOutput(ios);
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality(quality);
                if (as_grey && bi.getType() != 10) {
                    grey = new BufferedImage(bi.getWidth(), bi.getHeight(), 10);
                    grey.createGraphics().drawImage((Image)bi, 0, 0, null);
                }
                IIOImage iioImage = new IIOImage(grey, null, null);
                writer.write(null, iioImage, param);
                AbstractInterruptibleChannel ch = null;
                try {
                    RandomAccessFile ra = new RandomAccessFile(new File(path), "rw");
                    ByteBuffer bb = ByteBuffer.wrap((byte[])Bbuf.get(baos2332), 0, baos2332.size());
                    ch = ra.getChannel();
                    while (bb.hasRemaining()) {
                        ((FileChannel)ch).write(bb);
                    }
                    return true;
                }
                finally {
                    if (null != ch) {
                        ch.close();
                    }
                    ios.close();
                }
            }
            catch (Exception e) {
                IJError.print(e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (null != writer) {
                    try {
                        writer.dispose();
                    }
                    catch (Exception exception) {}
                }
                if (bi != grey) {
                    try {
                        grey.flush();
                    }
                    catch (Exception exception) {}
                }
                ImageSaver.removePathLock(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final BufferedImage open(String path, boolean as_grey) {
        InputStream stream = null;
        BufferedImage bi = null;
        Object object = ImageSaver.getPathLock(path);
        synchronized (object) {
            block29: {
                block28: {
                    stream = ImageSaver.openStream(path);
                    if (null != stream) break block28;
                    BufferedImage bufferedImage = null;
                    ImageSaver.removePathLock(path);
                    if (null != stream) {
                        try {
                            stream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return bufferedImage;
                }
                try {
                    bi = ImageSaver.openFromStream(stream, as_grey);
                }
                catch (Throwable e) {
                    try {
                        try {
                            Utils.log2("Decoder failed for " + path);
                            Thread.sleep(50L);
                            if (null != stream) {
                                try {
                                    stream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (null != (stream = ImageSaver.openStream(path))) {
                                bi = ImageSaver.openFromStream(stream, as_grey);
                            }
                            break block29;
                        }
                        catch (Exception e2) {
                            IJError.print(e2, true);
                        }
                        break block29;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        ImageSaver.removePathLock(path);
                        if (null != stream) {
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                ImageSaver.removePathLock(path);
                if (null != stream) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return bi;
        }
    }

    private static final InputStream openStream(String path) {
        try {
            File f = new File(path);
            return new BufferedInputStream(new FileInputStream(f), (int)Math.min(f.length(), 35000000L));
        }
        catch (FileNotFoundException fnfe) {
            try {
                if (FSLoader.isURL(path)) {
                    return new URL(path).openStream();
                }
            }
            catch (Throwable e) {
                IJError.print(e, true);
            }
        }
        catch (Throwable t) {
            IJError.print(t, true);
        }
        return null;
    }

    public static final BufferedImage openFromStream(InputStream stream, boolean as_grey) {
        try {
            if (as_grey) {
                BufferedImage bi = ImageIO.read(stream);
                if (bi.getType() != 10) {
                    BufferedImage grey = new BufferedImage(bi.getWidth(), bi.getHeight(), 10);
                    grey.createGraphics().drawImage((Image)bi, 0, 0, null);
                    bi.flush();
                    return grey;
                }
                return bi;
            }
            return ImageIO.read(stream);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static final boolean saveAsZip(ImagePlus imp, String path) {
        String name;
        if (null == imp) {
            Utils.log("Null imp, can't saveAsZip");
            return false;
        }
        if (!ImageSaver.checkPath(path)) {
            return false;
        }
        FileInfo fi = imp.getFileInfo();
        if (!path.endsWith(".zip")) {
            path = path + ".zip";
        }
        if ((name = imp.getTitle()).endsWith(".zip")) {
            name = name.substring(0, name.length() - 4);
        }
        if (!name.endsWith(".tif")) {
            name = name + ".tif";
        }
        fi.description = ImageSaver.getDescriptionString(imp, fi);
        Object info = imp.getProperty("Info");
        if (info != null && info instanceof String) {
            fi.info = (String)info;
        }
        fi.sliceLabels = imp.getStack().getSliceLabels();
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(zos));
            zos.putNextEntry(new ZipEntry(name));
            TiffEncoder te = new TiffEncoder(fi);
            te.write(out);
            out.close();
        }
        catch (IOException e) {
            IJError.print(e);
            return false;
        }
        return true;
    }

    public static final String getDescriptionString(ImagePlus imp, FileInfo fi) {
        boolean enhancedLut;
        int frames;
        int slices;
        int channels;
        Calibration cal = imp.getCalibration();
        StringBuilder sb = new StringBuilder(100);
        sb.append("ImageJ=1.53t\n");
        if (fi.nImages > 1 && fi.fileType != 12) {
            sb.append("images=" + fi.nImages + "\n");
        }
        if ((channels = imp.getNChannels()) > 1) {
            sb.append("channels=" + channels + "\n");
        }
        if ((slices = imp.getNSlices()) > 1) {
            sb.append("slices=" + slices + "\n");
        }
        if ((frames = imp.getNFrames()) > 1) {
            sb.append("frames=" + frames + "\n");
        }
        if (fi.unit != null) {
            sb.append("unit=" + fi.unit + "\n");
        }
        if (fi.valueUnit != null && fi.calibrationFunction != 22) {
            sb.append("cf=" + fi.calibrationFunction + "\n");
            if (fi.coefficients != null) {
                for (int i = 0; i < fi.coefficients.length; ++i) {
                    sb.append("c" + i + "=" + fi.coefficients[i] + "\n");
                }
            }
            sb.append("vunit=" + fi.valueUnit + "\n");
            if (cal.zeroClip()) {
                sb.append("zeroclip=true\n");
            }
        }
        if (fi.nImages > 1) {
            if (fi.pixelDepth != 0.0 && fi.pixelDepth != 1.0) {
                sb.append("spacing=" + fi.pixelDepth + "\n");
            }
            if (cal.fps != 0.0) {
                if ((double)((int)cal.fps) == cal.fps) {
                    sb.append("fps=" + (int)cal.fps + "\n");
                } else {
                    sb.append("fps=" + cal.fps + "\n");
                }
            }
            sb.append("loop=" + (cal.loop ? "true" : "false") + "\n");
            if (cal.frameInterval != 0.0) {
                if ((double)((int)cal.frameInterval) == cal.frameInterval) {
                    sb.append("finterval=" + (int)cal.frameInterval + "\n");
                } else {
                    sb.append("finterval=" + cal.frameInterval + "\n");
                }
            }
            if (!cal.getTimeUnit().equals("sec")) {
                sb.append("tunit=" + cal.getTimeUnit() + "\n");
            }
        }
        ImageProcessor ip = imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        int type = imp.getType();
        boolean bl = enhancedLut = !(type != 0 && type != 3 || min == 0.0 && max == 255.0);
        if (enhancedLut || type == 1 || type == 2) {
            sb.append("min=" + min + "\n");
            sb.append("max=" + max + "\n");
        }
        if (cal.xOrigin != 0.0) {
            sb.append("xorigin=" + cal.xOrigin + "\n");
        }
        if (cal.yOrigin != 0.0) {
            sb.append("yorigin=" + cal.yOrigin + "\n");
        }
        if (cal.zOrigin != 0.0) {
            sb.append("zorigin=" + cal.zOrigin + "\n");
        }
        if (cal.info != null && cal.info.length() <= 64 && cal.info.indexOf(61) == -1 && cal.info.indexOf(10) == -1) {
            sb.append("info=" + cal.info + "\n");
        }
        sb.append('\u0000');
        return new String(sb);
    }

    public static final int estimateJPEGFileSize(int w, int h) {
        long area = w * h;
        return (int)((1.08018E-8 * (double)area * (double)area + 0.315521 * (double)area + 8283.24) * 1.2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean saveAsJpegAlpha(BufferedImage awt, String path, float quality) {
        if (!ImageSaver.checkPath(path)) {
            return false;
        }
        Object object = ImageSaver.getPathLock(path);
        synchronized (object) {
            try {
                ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
                if (null != writer) {
                    ImageWriteParam iwp = writer.getDefaultWriteParam();
                    iwp.setCompressionMode(2);
                    iwp.setCompressionQuality(quality);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(ImageSaver.estimateJPEGFileSize(awt.getWidth(), awt.getHeight()));
                    ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
                    RandomAccessFile ra = null;
                    AbstractInterruptibleChannel ch = null;
                    try {
                        writer.setOutput(ios);
                        writer.write(writer.getDefaultStreamMetadata(iwp), new IIOImage(awt, null, null), iwp);
                        ra = new RandomAccessFile(new File(path), "rw");
                        ByteBuffer bb = ByteBuffer.wrap((byte[])Bbuf.get(baos), 0, baos.size());
                        ch = ra.getChannel();
                        while (bb.hasRemaining()) {
                            ((FileChannel)ch).write(bb);
                        }
                        ((FileChannel)ch).force(false);
                    }
                    finally {
                        if (null != ch) {
                            ch.close();
                        }
                        ios.close();
                    }
                    boolean bl = true;
                    return bl;
                }
                ImageIO.write((RenderedImage)awt, "jpeg", new File(path));
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException fnfe) {
                Utils.log2("saveAsJpegAlpha: Path not found: " + path);
            }
            catch (Exception e) {
                IJError.print(e, true);
            }
            finally {
                ImageSaver.removePathLock(path);
            }
            return false;
        }
    }

    public static final boolean saveAsJpegAlpha(Image awt, String path, float quality) {
        BufferedImage bi = ImageSaver.asBufferedImage(awt);
        boolean b = ImageSaver.saveAsJpegAlpha(bi, path, quality);
        if (bi != awt) {
            bi.flush();
        }
        return b;
    }

    public static final BufferedImage asBufferedImage(Image awt) {
        BufferedImage bi = null;
        if (awt instanceof BufferedImage) {
            bi = (BufferedImage)awt;
        } else {
            bi = new BufferedImage(awt.getWidth(null), awt.getHeight(null), 2);
            bi.createGraphics().drawImage(awt, 0, 0, null);
        }
        return bi;
    }

    public static BufferedImage openJpegAlpha(String path) {
        return ImageSaver.openImage(path, true);
    }

    public static BufferedImage openPNGAlpha(String path) {
        return ImageSaver.openImage(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage openImage(String path, boolean ensure_premultiplied_alpha) {
        Object object = ImageSaver.getPathLock(path);
        synchronized (object) {
            try {
                BufferedImage img = ImageIO.read(new File(path));
                if (ensure_premultiplied_alpha || img.getType() == 2 || img.getType() == 0) {
                    BufferedImage imgPre = new BufferedImage(img.getWidth(), img.getHeight(), 3);
                    imgPre.createGraphics().drawImage((Image)img, 0, 0, null);
                    img.flush();
                    BufferedImage bufferedImage = imgPre;
                    return bufferedImage;
                }
                BufferedImage bufferedImage = img;
                return bufferedImage;
            }
            catch (FileNotFoundException fnfe) {
                Utils.log2("openImage: Path not found: " + path);
            }
            catch (Exception e) {
                Utils.log2("openImage: cannot open " + path);
            }
            finally {
                ImageSaver.removePathLock(path);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage openGreyImage(String path) {
        Object object = ImageSaver.getPathLock(path);
        synchronized (object) {
            try {
                BufferedImage bufferedImage = ImageSaver.asGrey(ImageIO.read(new File(path)));
                return bufferedImage;
            }
            catch (FileNotFoundException fnfe) {
                Utils.log2("openImage: Path not found: " + path);
            }
            catch (Exception e) {
                Utils.log2("openImage: cannot open " + path);
            }
            finally {
                ImageSaver.removePathLock(path);
            }
            return null;
        }
    }

    public static final BufferedImage asGrey(BufferedImage bi) {
        if (null == bi) {
            return null;
        }
        if (bi.getType() == 10) {
            return bi;
        }
        BufferedImage grey = new BufferedImage(bi.getWidth(), bi.getHeight(), 10);
        grey.createGraphics().drawImage((Image)bi, 0, 0, null);
        bi.flush();
        return grey;
    }

    public static final void debugAlpha() {
        BufferedImage bi = new BufferedImage(512, 512, 2);
        Image baboon = new Opener().openImage("http://rsb.info.nih.gov/ij/images/baboon.jpg").getProcessor().createImage();
        bi.createGraphics().drawImage(baboon, 0, 0, null);
        baboon.flush();
        int[] ramp = (int[])NewImage.createRGBImage((String)"ramp", (int)512, (int)512, (int)1, (int)2).getProcessor().getPixels();
        bi.getAlphaRaster().setPixels(0, 0, 512, 512, ramp);
        String path = "/home/albert/temp/baboonramp.jpg";
        ImageSaver.saveAsJpegAlpha(bi, path, 0.75f);
        BufferedImage awt = ImageSaver.openJpegAlpha(path);
        JFrame frame = new JFrame("test alpha");
        final BufferedImage background = frame.getGraphicsConfiguration().createCompatibleImage(512, 512);
        Image some = new Opener().openImage("http://rsb.info.nih.gov/ij/images/bridge.gif").getProcessor().createImage();
        Graphics g = ((Image)background).getGraphics();
        g.drawImage(some, 0, 0, null);
        some.flush();
        g.drawImage(awt, 0, 0, null);
        Canvas canvas = new Canvas(){

            @Override
            public void paint(Graphics g) {
                g.drawImage(background, 0, 0, null);
            }
        };
        canvas.setSize(512, 512);
        frame.getContentPane().add(canvas);
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean saveAsPNG(ImageProcessor ip, String path) {
        Image awt = null;
        try {
            awt = ip.createImage();
            boolean bl = ImageSaver.saveAsPNG(awt, path);
            return bl;
        }
        catch (Exception e) {
            IJError.print(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != awt) {
                awt.flush();
            }
        }
    }

    public static final boolean saveAsPNG(Image awt, String path) {
        try {
            BufferedImage bi = null;
            if (awt instanceof BufferedImage) {
                bi = (BufferedImage)awt;
            } else {
                bi = new BufferedImage(awt.getWidth(null), awt.getHeight(null), 2);
                bi.createGraphics().drawImage(awt, 0, 0, null);
            }
            return ImageSaver.saveAsPNG(bi, path);
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean saveAsPNG(BufferedImage awt, String path) {
        if (!ImageSaver.checkPath(path)) {
            return false;
        }
        Object object = ImageSaver.getPathLock(path);
        synchronized (object) {
            try {
                boolean bl = ImageIO.write((RenderedImage)awt, "png", new File(path));
                return bl;
            }
            catch (FileNotFoundException fnfe) {
                Utils.log2("saveAsPng: Path not found: " + path);
            }
            catch (Exception e) {
                IJError.print(e, true);
            }
            finally {
                ImageSaver.removePathLock(path);
            }
            return false;
        }
    }

    public static final boolean saveAsTIFF(ImageProcessor ip, String path, boolean as_grey) {
        try {
            return ImageSaver.saveAsTIFF(ip.getBufferedImage(), path, as_grey);
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean saveAsTIFF(Image awt, String path, boolean as_grey) {
        Image bi = null;
        try {
            if (awt instanceof BufferedImage) {
                boolean bl = ImageSaver.saveAsTIFF((BufferedImage)awt, path, as_grey);
                return bl;
            }
            bi = new BufferedImage(awt.getWidth(null), awt.getHeight(null), as_grey ? 10 : 2);
            ((BufferedImage)bi).createGraphics().drawImage(awt, 0, 0, null);
            boolean bl = ImageSaver.saveAsTIFF((BufferedImage)bi, path, false);
            return bl;
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            if (null != bi) {
                bi.flush();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean saveAsTIFF(BufferedImage bi, String path, boolean as_grey) {
        if (!ImageSaver.checkPath(path)) {
            return false;
        }
        Object object = ImageSaver.getPathLock(path);
        synchronized (object) {
            OutputStream out = null;
            try {
                if (as_grey) {
                    bi = ImageSaver.asGrey(bi);
                }
                TIFFEncodeParam param = new TIFFEncodeParam();
                param.setCompression(1);
                out = new BufferedOutputStream(new FileOutputStream(path));
                ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)out, (ImageEncodeParam)param).encode((RenderedImage)bi);
                out.flush();
                File f = new File(path);
                boolean bl = f.exists() && f.length() > 0L;
                return bl;
            }
            catch (FileNotFoundException fnfe) {
                Utils.log2("saveAsTIFF: Path not found: " + path);
            }
            catch (Exception e) {
                IJError.print(e, true);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (Exception fnfe) {}
                }
                ImageSaver.removePathLock(path);
            }
            return false;
        }
    }

    private static final BufferedImage openTIFF(String path) throws Exception {
        return PlanarImage.wrapRenderedImage((RenderedImage)ImageCodec.createImageDecoder((String)"TIFF", (File)new File(path), (ImageDecodeParam)new TIFFDecodeParam()).decodeAsRenderedImage()).getAsBufferedImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BufferedImage openTIFF(String path, boolean ensure_premultiplied_alpha) {
        Object object = ImageSaver.getPathLock(path);
        synchronized (object) {
            try {
                BufferedImage img = ImageSaver.openTIFF(path);
                if (ensure_premultiplied_alpha || img.getType() == 2 || img.getType() == 0) {
                    BufferedImage imgPre = new BufferedImage(img.getWidth(), img.getHeight(), 3);
                    imgPre.createGraphics().drawImage((Image)img, 0, 0, null);
                    img.flush();
                    BufferedImage bufferedImage = imgPre;
                    return bufferedImage;
                }
                BufferedImage bufferedImage = img;
                return bufferedImage;
            }
            catch (Exception e) {
                Utils.log2("openTIFF: cannot open " + path + " :\n\t" + e);
            }
            finally {
                ImageSaver.removePathLock(path);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BufferedImage openGreyTIFF(String path) {
        Object object = ImageSaver.getPathLock(path);
        synchronized (object) {
            try {
                BufferedImage bufferedImage = ImageSaver.asGrey(ImageSaver.openTIFF(path));
                return bufferedImage;
            }
            catch (Exception e) {
                Utils.log2("openGreyTIFF: cannot open " + path + " :\n\t" + e);
            }
            finally {
                ImageSaver.removePathLock(path);
            }
            return null;
        }
    }

    static {
        Field b = null;
        try {
            b = ByteArrayOutputStream.class.getDeclaredField("buf");
            b.setAccessible(true);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        Bbuf = b;
    }
}

