/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import fiji.geom.AreaCalculations;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.StackWindow;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.analysis.Centrality;
import ini.trakem2.analysis.Vertex;
import ini.trakem2.display.AreaTree;
import ini.trakem2.display.Connector;
import ini.trakem2.display.Coordinate;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Node;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Region;
import ini.trakem2.display.Tag;
import ini.trakem2.display.Tree;
import ini.trakem2.display.TreeConnectorsView;
import ini.trakem2.display.Treeline;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.parallel.Process;
import ini.trakem2.parallel.TaskFactory;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import mpicbg.models.CoordinateTransform;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;

public abstract class Tree<T>
extends ZDisplayable
implements VectorData {
    protected final Map<Layer, Set<Node<T>>> node_layer_map = new HashMap<Layer, Set<Node<T>>>();
    protected final Set<Node<T>> end_nodes = new HashSet<Node<T>>();
    protected Node<T> root = null;
    private final List<Node<T>> tolink = new ArrayList<Node<T>>();
    private Node<T> marked = null;
    private Node<T> active = null;
    private Node<T> last_added = null;
    private Node<T> last_edited = null;
    private Node<T> last_visited = null;
    private static Polygon MARKED_PARENT;
    private static Polygon MARKED_CHILD;
    private static Node<?> to_tag;
    private static Node<?> to_untag;
    private static boolean show_tag_dialogs;
    private TreeNodesDataView tndv = null;

    protected Tree(Project project, String title) {
        super(project, title, 0.0, 0.0);
    }

    protected Tree(Project project, long id, HashMap<String, String> ht_attr, HashMap<Displayable, String> ht_links) {
        super(project, id, ht_attr, ht_links);
    }

    protected Tree(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean locked, AffineTransform at) {
        super(project, id, title, locked, at, width, height);
        this.alpha = alpha;
        this.visible = visible;
        this.color = color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Node<T>> getNodesAt(Layer layer) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> s = this.node_layer_map.get(layer);
            return null == s ? new HashSet<Node<T>>() : new HashSet<Node<T>>(s);
        }
    }

    protected final Set<Node<T>> getNodesToPaint(Layer active_layer) {
        return this.getNodesToPaint(active_layer, active_layer.getParent().getColorCueLayerRange(active_layer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<Node<T>> getNodesToPaint(Layer active_layer, List<Layer> color_cue_layers) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            if (this.layer_set.color_cues) {
                HashSet<Node<Object>> nodes = null;
                if (-1 == this.layer_set.n_layers_color_cue) {
                    nodes = new HashSet<Node<T>>();
                    for (Set<Node<T>> ns : this.node_layer_map.values()) {
                        nodes.addAll(ns);
                    }
                } else {
                    for (Layer la : color_cue_layers) {
                        Set<Node<T>> ns = this.node_layer_map.get(la);
                        if (null == ns) continue;
                        if (null == nodes) {
                            nodes = new HashSet();
                        }
                        nodes.addAll(ns);
                    }
                }
                return nodes;
            }
            Set<Node<T>> nodeSet = this.node_layer_map.get(active_layer);
            HashSet<Node<T>> hashSet = null == nodeSet ? null : new HashSet<Node<T>>(nodeSet);
            return hashSet;
        }
    }

    @Override
    public final void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        this.paint(g, srcRect, magnification, active, channels, active_layer, layers, this.layer_set.paint_arrows, this.layer_set.paint_tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers, boolean with_arrows, boolean with_tags) {
        Color above;
        Color below;
        if (null == this.root) {
            this.setupForDisplay();
            if (null == this.root) {
                return;
            }
        }
        Composite original_composite = null;
        AffineTransform gt = null;
        Stroke stroke = null;
        if (this.layer_set.use_color_cue_colors) {
            below = Color.red;
            above = Color.blue;
        } else {
            below = this.color;
            above = this.color;
        }
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> nodes = this.getNodesToPaint(active_layer, layers);
            if (null != nodes) {
                if (srcRect.x > 0 && srcRect.y > 0 && srcRect.width < (int)this.layer_set.getLayerWidth() && srcRect.height < (int)this.layer_set.getLayerHeight()) {
                    try {
                        Rectangle localRect = this.at.createInverse().createTransformedShape(srcRect).getBounds();
                        Iterator<Node<T>> it = nodes.iterator();
                        while (it.hasNext()) {
                            Node<T> nd = it.next();
                            if (nd.isRoughlyInside(localRect)) continue;
                            it.remove();
                        }
                    }
                    catch (NoninvertibleTransformException nite) {
                        IJError.print(nite);
                    }
                }
                if (this.alpha != 1.0f) {
                    original_composite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, this.alpha));
                }
                gt = g.getTransform();
                g.setTransform(DisplayCanvas.DEFAULT_AFFINE);
                stroke = g.getStroke();
                g.setStroke(DisplayCanvas.DEFAULT_STROKE);
                AffineTransform to_screen = new AffineTransform();
                to_screen.scale(magnification, magnification);
                to_screen.translate(-srcRect.x, -srcRect.y);
                to_screen.concatenate(this.at);
                Node[] handles = active ? new Node[nodes.size()] : null;
                int next = 0;
                ArrayList<Runnable> tags_tasks = new ArrayList<Runnable>();
                for (Node<T> nd : nodes) {
                    Runnable task = nd.paint(g, active_layer, active, srcRect, magnification, nodes, this, to_screen, with_arrows, with_tags, this.layer_set.paint_edge_confidence_boxes, true, above, below);
                    if (null != task) {
                        tags_tasks.add(task);
                    }
                    if (nd == this.marked) {
                        if (null == MARKED_CHILD) {
                            Tree.createMarks();
                        }
                        Composite c = g.getComposite();
                        g.setXORMode(Color.green);
                        float[] fps = new float[]{nd.x, nd.y};
                        this.at.transform(fps, 0, fps, 0, 1);
                        AffineTransform aff = new AffineTransform();
                        aff.translate((double)(fps[0] - (float)srcRect.x) * magnification, (double)(fps[1] - (float)srcRect.y) * magnification);
                        g.fill(aff.createTransformedShape(active ? MARKED_PARENT : MARKED_CHILD));
                        g.setComposite(c);
                    }
                    if (!active || active_layer != nd.la) continue;
                    handles[next++] = nd;
                }
                for (Runnable task : tags_tasks) {
                    task.run();
                }
                if (active) {
                    for (int i = 0; i < next; ++i) {
                        handles[i].paintHandle(g, srcRect, magnification, this);
                    }
                }
            }
        }
        if (null != gt) {
            g.setTransform(gt);
            g.setStroke(stroke);
        }
        if (null != original_composite) {
            g.setComposite(original_composite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Rectangle getPaintingBounds() {
        Rectangle box = null;
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            for (Collection collection : this.node_layer_map.values()) {
                Rectangle b = this.getBounds(collection);
                if (null == box) {
                    box = b;
                    continue;
                }
                if (null == b) continue;
                box.add(b);
            }
        }
        return box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle getBounds(Rectangle tmp, Layer layer) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Collection nodes = this.node_layer_map.get(layer);
            if (null == nodes) {
                if (null == tmp) {
                    return new Rectangle();
                }
                tmp.setBounds(0, 0, 0, 0);
                return tmp;
            }
            Rectangle r = this.getBounds(nodes);
            if (null == tmp) {
                if (null == r) {
                    return new Rectangle();
                }
                return r;
            }
            if (null == r) {
                tmp.setRect(0.0, 0.0, 0.0, 0.0);
            } else {
                tmp.setRect(r);
            }
            return tmp;
        }
    }

    protected Rectangle getBounds(Collection<? extends Node<T>> nodes) {
        Rectangle b = null;
        for (Node<T> nd : nodes) {
            if (null == b) {
                b = new Rectangle((int)nd.x, (int)nd.y, 1, 1);
                continue;
            }
            b.add((int)nd.x, (int)nd.y);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean calculateBoundingBox(Layer la) {
        try {
            if (null == this.root) {
                this.at.setToIdentity();
                this.width = 0.0f;
                this.height = 0.0f;
                boolean bl = false;
                return bl;
            }
            Rectangle box = this.getPaintingBounds();
            this.width = box.width;
            this.height = box.height;
            if (0 == box.x && 0 == box.y) {
                boolean bl = false;
                return bl;
            }
            Map<Layer, Set<Node<T>>> map = this.node_layer_map;
            synchronized (map) {
                for (Collection collection : this.node_layer_map.values()) {
                    for (Node nd : collection) {
                        nd.translate(-box.x, -box.y);
                    }
                }
            }
            this.at.translate(box.x, box.y);
            boolean bl = true;
            return bl;
        }
        finally {
            this.updateBucket(la);
        }
    }

    public void repaint(boolean repaint_navigator, Layer la) {
        Rectangle box = this.getBoundingBox(null);
        this.calculateBoundingBox(la);
        box.add(this.getBoundingBox(null));
        Display.repaint(this.layer_set, (Displayable)this, box, 10, repaint_navigator);
    }

    private synchronized void setupForDisplay() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(Area area, double z_first, double z_last) {
        if (null == this.root) {
            return false;
        }
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            try {
                Area a = area.createTransformedArea(this.at.createInverse());
                for (Map.Entry<Layer, Set<Node<T>>> e : this.node_layer_map.entrySet()) {
                    double z = e.getKey().getZ();
                    if (!(z >= z_first) || !(z <= z_last)) continue;
                    for (Node<T> nd : e.getValue()) {
                        if (!nd.intersects(a)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Layer getFirstLayer() {
        if (null == this.root) {
            return null;
        }
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            ArrayList<Layer> las = new ArrayList<Layer>(this.node_layer_map.keySet());
            Collections.sort(las, Layer.COMPARATOR);
            return las.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addToLinkLater(Node<T> nd) {
        List<Node<T>> list = this.tolink;
        synchronized (list) {
            this.tolink.add(nd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeFromLinkLater(Node<T> nd) {
        List<Node<T>> list = this.tolink;
        synchronized (list) {
            this.tolink.remove(nd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean linkPatches() {
        ArrayList<Node<T>> tolink;
        if (null == this.root) {
            return false;
        }
        List<Node<T>> list = this.tolink;
        synchronized (list) {
            tolink = new ArrayList<Node<T>>(this.tolink);
            this.tolink.clear();
        }
        if (tolink.isEmpty()) {
            return true;
        }
        boolean must_lock = false;
        for (Node<T> nd : tolink) {
            for (Patch patch : nd.findLinkTargets(this.at)) {
                this.link(patch);
                if (!patch.locked) continue;
                must_lock = true;
            }
        }
        if (must_lock && !this.locked) {
            this.setLocked(true);
            return true;
        }
        return false;
    }

    protected abstract Tree<T> newInstance();

    protected abstract Node<T> newNode(float var1, float var2, Layer var3, Node<?> var4);

    protected Node<T> createNewNode(float lx, float ly, Layer layer, Node<?> modelNode) {
        Node<T> nd = this.newNode(lx, ly, layer, modelNode);
        if (null == modelNode) {
            return nd;
        }
        nd.setColor(modelNode.getColor());
        return nd;
    }

    public abstract Node<T> newNode(HashMap<String, String> var1);

    @Override
    public boolean isDeletable() {
        return null == this.root;
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_node";
        if (hs.contains("t2_node")) {
            return;
        }
        hs.add("t2_node");
        sb_header.append(indent).append("<!ELEMENT t2_tag EMPTY>\n");
        sb_header.append(indent).append("<!ATTLIST ").append("t2_tag name").append(" NMTOKEN #REQUIRED>\n");
        sb_header.append(indent).append("<!ATTLIST ").append("t2_tag key").append(" NMTOKEN #REQUIRED>\n");
        sb_header.append(indent).append("<!ELEMENT t2_node (t2_area*,t2_tag*)>\n");
        sb_header.append(indent).append("<!ATTLIST ").append("t2_node x").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_node y").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_node lid").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_node c").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_node r NMTOKEN #IMPLIED>\n");
    }

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        String type = "t2_" + this.getClass().getSimpleName().toLowerCase();
        sb_body.append(indent).append("<").append(type).append('\n');
        String in = indent + "\t";
        super.exportXML(sb_body, in, options);
        String[] RGB = Utils.getHexRGBColor(this.color);
        sb_body.append(in).append("style=\"fill:none;stroke-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";stroke-width:1.0px;stroke-opacity:1.0\"\n");
        sb_body.append(indent).append(">\n");
        super.restXML(sb_body, in, options);
        if (null != this.root) {
            this.exportXML(this, in, sb_body, this.root);
        }
        sb_body.append(indent).append("</").append(type).append(">\n");
    }

    private final void exportXML(Tree<T> tree, String indent_base, StringBuilder sb, Node<T> root) {
        LinkedList list = new LinkedList();
        list.add(root);
        HashMap<Node, Integer> table = new HashMap<Node, Integer>();
        StringBuilder indent = new StringBuilder(indent_base);
        while (!list.isEmpty()) {
            Node node = (Node)list.getLast();
            if (null == node.children) {
                this.dataNodeXML(tree, indent, sb, node);
                list.removeLast();
                continue;
            }
            Integer ii = (Integer)table.get(node);
            if (null == ii) {
                this.dataNodeXML(tree, indent, sb, node);
                table.put(node, 0);
                list.add(node.children[0]);
                continue;
            }
            int i = ii;
            if (i == node.children.length - 1) {
                Tree.closeNodeXML(indent, sb);
                list.removeLast();
                table.remove(node);
                continue;
            }
            list.add(node.children[i + 1]);
            table.put(node, i + 1);
        }
    }

    private final void dataNodeXML(Tree<T> tree, StringBuilder indent, StringBuilder sb, Node<T> node) {
        byte conf;
        sb.append((CharSequence)indent).append("<t2_node x=\"").append(node.x).append("\" y=\"").append(node.y).append("\" lid=\"").append(node.la.getId()).append('\"');
        if (null != node.parent && 5 != (conf = node.getConfidence())) {
            sb.append(" c=\"").append(conf).append('\"');
        }
        if (null != node.color) {
            sb.append(" color=\"");
            Utils.asHexRGBColor(sb, node.color);
            sb.append('\"');
        }
        tree.exportXMLNodeAttributes(indent, sb, node);
        sb.append(">\n");
        indent.append(' ');
        boolean data = tree.exportXMLNodeData(indent, sb, node);
        if (data) {
            if (null != node.tags) {
                this.exportTags(node, sb, indent);
            }
            if (null == node.children) {
                indent.setLength(indent.length() - 1);
                sb.append((CharSequence)indent).append("</t2_node>\n");
                return;
            }
        } else if (null == node.children) {
            if (null != node.tags) {
                this.exportTags(node, sb, indent);
                sb.append((CharSequence)indent).append("</t2_node>\n");
            } else {
                sb.setLength(sb.length() - 3);
                sb.append("\" />\n");
            }
        } else if (null != node.tags) {
            this.exportTags(node, sb, indent);
        }
        indent.setLength(indent.length() - 1);
    }

    protected abstract boolean exportXMLNodeAttributes(StringBuilder var1, StringBuilder var2, Node<T> var3);

    protected abstract boolean exportXMLNodeData(StringBuilder var1, StringBuilder var2, Node<T> var3);

    private final void exportTags(Node<T> node, StringBuilder sb, StringBuilder indent) {
        for (Tag tag : node.getTags()) {
            sb.append((CharSequence)indent).append("<t2_tag name=\"").append(Displayable.getXMLSafeValue(tag.toString())).append("\" key=\"").append((char)tag.getKeyCode()).append("\" />\n");
        }
    }

    private static final void closeNodeXML(StringBuilder indent, StringBuilder sb) {
        sb.append((CharSequence)indent).append("</t2_node>\n");
    }

    @Deprecated
    public List<Point3f> generateTriangles(double scale_, int parallels, int resample) {
        return this.generateSkeleton((double)scale_, (int)parallels, (int)resample).verts;
    }

    public MeshData generateSkeleton(double scale_, int parallels, int resample) {
        if (null == this.root) {
            return null;
        }
        ArrayList<Point3f> list = new ArrayList<Point3f>();
        ArrayList<Color3f> colors = new ArrayList<Color3f>();
        LinkedList todo = new LinkedList();
        todo.add(this.root);
        float scale = (float)scale_;
        Calibration cal = this.layer_set.getCalibration();
        float pixelWidthScaled = (float)cal.pixelWidth * scale;
        float pixelHeightScaled = (float)cal.pixelHeight * scale;
        int sign = cal.pixelDepth < 0.0 ? -1 : 1;
        float[] fps = new float[2];
        HashMap<Node, Point3f> points = new HashMap<Node, Point3f>();
        HashMap<Color, Color3f> cached_colors = new HashMap<Color, Color3f>();
        Color3f cf = new Color3f(this.color);
        cached_colors.put(this.color, cf);
        boolean go = true;
        while (go) {
            Node node = (Node)todo.removeFirst();
            if (null != node.children) {
                for (Node nd : node.children) {
                    todo.add(nd);
                }
            }
            go = !todo.isEmpty();
            Point3f p = (Point3f)points.get(node);
            if (null == p) {
                fps[0] = node.x;
                fps[1] = node.y;
                this.at.transform(fps, 0, fps, 0, 1);
                p = new Point3f(fps[0] * pixelWidthScaled, fps[1] * pixelHeightScaled, (float)node.la.getZ() * pixelWidthScaled * (float)sign);
                points.put(node, p);
            }
            if (null == node.parent) continue;
            list.add((Point3f)points.get(node.parent));
            list.add(p);
            if (null == node.color) {
                colors.add(cf);
                colors.add(cf);
            } else {
                Color3f c = (Color3f)cached_colors.get(node.color);
                if (null == c) {
                    c = new Color3f(node.color);
                    cached_colors.put(node.color, c);
                }
                colors.add(c);
                colors.add(c);
            }
            if (!go || node.parent == ((Node)todo.getFirst()).parent) continue;
            points.remove(node.parent);
        }
        return new MeshData(list, colors);
    }

    @Override
    final Class<?> getInternalDataPackageClass() {
        return DPTree.class;
    }

    @Override
    synchronized Object getDataPackage() {
        return new DPTree(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reRoot(float x, float y, Layer layer, double magnification) {
        if (!this.at.isIdentity()) {
            Point2D.Double po = this.inverseTransformPoint(x, y);
            x = (float)po.x;
            y = (float)po.y;
        }
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> nodes = this.node_layer_map.get(layer);
            if (null == nodes || nodes.isEmpty()) {
                Utils.log("No node at " + x + ", " + y + ", " + layer);
                return false;
            }
            nodes = null;
            Node<T> nd = this.findNode(x, y, layer, magnification);
            if (null == nd) {
                Utils.log("No node near " + x + ", " + y + ", " + layer);
                return false;
            }
            return this.reRoot(nd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reRoot(Node<T> nd) {
        if (null == nd) {
            return false;
        }
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> nodes = this.node_layer_map.get(nd.la);
            if (null == nodes || !nodes.contains(nd)) {
                return false;
            }
            this.end_nodes.add(this.root);
            this.end_nodes.remove(nd);
            nd.setRoot();
            this.root = nd;
        }
        this.updateView();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tree<T>> splitNear(float x, float y, Layer layer, double magnification) {
        try {
            Object po;
            if (!this.at.isIdentity()) {
                po = this.inverseTransformPoint(x, y);
                x = (float)((Point2D.Double)po).x;
                y = (float)((Point2D.Double)po).y;
            }
            po = this.node_layer_map;
            synchronized (po) {
                Set<Node<T>> nodes = this.node_layer_map.get(layer);
                if (null == nodes || nodes.isEmpty()) {
                    Utils.log("No nodes at " + x + ", " + y + ", " + layer);
                    return null;
                }
                nodes = null;
                Node<T> nd = this.findNode(x, y, layer, magnification);
                if (null == nd) {
                    Utils.log("No node near " + x + ", " + y + ", " + layer + ", mag=" + magnification);
                    return null;
                }
                if (null == nd.parent) {
                    Utils.log("Cannot split at a root point!");
                    return null;
                }
                return this.splitAt(nd);
            }
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tree<T>> splitAt(Node<T> nd) {
        if (null == nd) {
            return null;
        }
        try {
            ArrayList<Tree<T>> a;
            Map<Layer, Set<Node<T>>> map = this.node_layer_map;
            synchronized (map) {
                Set<Node<T>> nodes = this.node_layer_map.get(nd.la);
                if (null == nodes || !nodes.contains(nd)) {
                    return null;
                }
                ArrayList<Node<T>> subtree_nodes = new ArrayList<Node<T>>(nd.getSubtreeNodes());
                for (Node node : subtree_nodes) {
                    this.removeReview(node);
                }
                this.removeNode(nd, subtree_nodes);
                nd.parent = null;
                Tree<T> t = this.newInstance();
                t.addToDatabase();
                t.root = nd;
                t.cacheSubtree(subtree_nodes);
                t.calculateBoundingBox(null);
                a = new ArrayList<Tree<T>>();
                a.add(this);
                a.add(t);
            }
            this.calculateBoundingBox(null);
            return a;
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    protected void cacheSubtree(Iterable<Node<T>> nodes) {
        this.cache(nodes, this.end_nodes, this.node_layer_map);
    }

    protected void clearCache() {
        this.end_nodes.clear();
        this.node_layer_map.clear();
        this.setLastAdded(null);
        this.setLastEdited(null);
        this.setLastMarked(null);
        this.setLastVisited(null);
    }

    private final void cache(Iterable<Node<T>> nodes, Collection<Node<T>> end_nodes, Map<Layer, Set<Node<T>>> node_layer_map) {
        for (Node<T> child : nodes) {
            Set<Node<T>> nds;
            if (null == child.children) {
                end_nodes.add(child);
            }
            if (null == (nds = node_layer_map.get(child.la))) {
                nds = new HashSet<Node<T>>();
                node_layer_map.put(child.la, nds);
            }
            nds.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCache() {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            this.clearCache();
            if (null == this.root) {
                return;
            }
            this.cacheSubtree(this.root.getSubtreeNodes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Layer layer, double x, double y) {
        if (null == this.root) {
            return false;
        }
        Display front = Display.getFront();
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            double mag;
            Set<Node<T>> nodes = this.node_layer_map.get(layer);
            if (null == nodes) {
                return false;
            }
            float radius = 10.0f;
            if (null != front && (radius = (float)(10.0 / (mag = front.getCanvas().getMagnification()))) < 2.0f) {
                radius = 2.0f;
            }
            Point2D.Double po = this.inverseTransformPoint(x, y);
            return this.isAnyNear(nodes, (float)po.x, (float)po.y, radius * radius);
        }
    }

    protected boolean isAnyNear(Collection<Node<T>> nodes, float lx, float ly, float radius) {
        for (Node<T> nd : nodes) {
            if (!nd.isNear(lx, ly, radius)) continue;
            return true;
        }
        return false;
    }

    public Node<T> getRoot() {
        return this.root;
    }

    protected Coordinate<Node<T>> createCoordinate(Node<T> nd) {
        if (null == nd) {
            return null;
        }
        float x = nd.x;
        float y = nd.y;
        if (!this.at.isIdentity()) {
            float[] dps = new float[]{x, y};
            this.at.transform(dps, 0, dps, 0, 1);
            x = dps[0];
            y = dps[1];
        }
        return new Coordinate<Node<T>>(x, y, nd.la, nd);
    }

    public Coordinate<Node<T>> findPreviousBranchOrRootPoint(float x, float y, Layer layer, DisplayCanvas dc) {
        Node<T> nd = this.findNodeNear(x, y, layer, dc);
        if (null == nd) {
            return null;
        }
        return this.createCoordinate(nd.findPreviousBranchOrRootPoint());
    }

    public Coordinate<Node<T>> findNextBranchOrEndPoint(float x, float y, Layer layer, DisplayCanvas dc) {
        Node<T> nd = this.findNodeNear(x, y, layer, dc);
        if (null == nd) {
            return null;
        }
        return this.createCoordinate(nd.findNextBranchOrEndPoint());
    }

    protected Coordinate<Node<T>> findNearAndGetNext(float x, float y, Layer layer, DisplayCanvas dc) {
        Node<T> nd = this.findNodeNear(x, y, layer, dc);
        if (null == nd) {
            nd = this.last_visited;
        }
        if (null == nd) {
            return null;
        }
        int n_children = nd.getChildrenCount();
        if (0 == n_children) {
            return null;
        }
        if (1 == n_children) {
            this.setLastVisited(nd.children[0]);
            return this.createCoordinate(nd.children[0]);
        }
        if (!this.at.isIdentity()) {
            Point2D.Double po = this.inverseTransformPoint(x, y);
            x = (float)po.x;
            y = (float)po.y;
        }
        if (null != (nd = this.findNearestChildEdge(nd, x, y))) {
            this.setLastVisited(nd);
        }
        return this.createCoordinate(nd);
    }

    protected Coordinate<Node<T>> findNearAndGetPrevious(float x, float y, Layer layer, DisplayCanvas dc) {
        Node<T> nd = this.findNodeNear(x, y, layer, dc);
        if (null == nd) {
            nd = this.last_visited;
        }
        if (null == nd || null == nd.parent) {
            return null;
        }
        this.setLastVisited(nd.parent);
        return this.createCoordinate(nd.parent);
    }

    public Coordinate<Node<T>> getLastEdited() {
        return this.createCoordinate(this.last_edited);
    }

    public Coordinate<Node<T>> getLastAdded() {
        return this.createCoordinate(this.last_added);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<T> setEdgeConfidence(byte confidence) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            if (null == this.last_visited) {
                return null;
            }
            this.last_visited.setConfidence(confidence);
            this.updateViewData(this.last_visited);
            return this.last_visited;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<T> adjustEdgeConfidence(int inc, float x, float y, Layer layer, DisplayCanvas dc) {
        Node<T> nearest;
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            nearest = this.findNodeConfidenceBox(x, y, layer, dc.getMagnification());
            if (null == nearest) {
                nearest = this.findNodeNear(x, y, layer, dc, true);
            }
            if (null == nearest) {
                return null;
            }
            if (!nearest.adjustConfidence(inc)) {
                return null;
            }
        }
        if (null != nearest) {
            this.updateViewData(nearest);
        }
        return nearest;
    }

    private Node<T> findNodeConfidenceBox(float x, float y, Layer layer, double magnification) {
        Set<Node<T>> nodes = this.node_layer_map.get(layer);
        if (null == nodes) {
            return null;
        }
        Point2D.Double po = this.inverseTransformPoint(x, y);
        x = (float)po.x;
        y = (float)po.y;
        float radius = (float)(10.0 / magnification);
        if (radius < 2.0f) {
            radius = 2.0f;
        }
        radius *= radius;
        float min_sq_dist = Float.MAX_VALUE;
        Node<T> nearest = null;
        for (Node<T> nd : nodes) {
            float d;
            if (null == nd.parent || !((d = (float)(Math.pow((nd.parent.x + nd.x) / 2.0f - x, 2.0) + Math.pow((nd.parent.y + nd.y) / 2.0f - y, 2.0))) < min_sq_dist) || !(d < radius)) continue;
            min_sq_dist = d;
            nearest = nd;
        }
        return nearest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node<T> findNode(float lx, float ly, Layer layer, double magnification) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            return this.findClosestNode((Collection)this.node_layer_map.get(layer), lx, ly, magnification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node<T> findClosestNodeW(float wx, float wy, Layer layer, double magnification) {
        if (null == this.root) {
            return null;
        }
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> nodes = this.node_layer_map.get(layer);
            if (null == nodes) {
                return null;
            }
            return this.findClosestNodeW(nodes, wx, wy, magnification);
        }
    }

    public Node<T> findClosestNodeW(Collection<Node<T>> nodes, float wx, float wy, double magnification) {
        float lx = wx;
        float ly = wy;
        if (!this.at.isIdentity()) {
            Point2D.Double po = this.inverseTransformPoint(wx, wy);
            lx = (float)po.x;
            ly = (float)po.y;
        }
        return this.findClosestNode(nodes, lx, ly, magnification);
    }

    protected Layer toClosestPaintedNode(Layer active_layer, float wx, float wy, double magnification) {
        Node<T> nd = this.findClosestNodeW(this.getNodesToPaint(active_layer), wx, wy, magnification);
        if (null != nd) {
            this.setLastVisited(nd);
            return nd.la;
        }
        return null;
    }

    public Node<T> findClosestNode(Collection<Node<T>> nodes, float lx, float ly, double magnification) {
        if (null == nodes || nodes.isEmpty()) {
            return null;
        }
        double d = 10.0 / magnification;
        if (d < 2.0) {
            d = 2.0;
        }
        float min_dist = Float.MAX_VALUE;
        Node<T> nd = null;
        for (Node<T> node : nodes) {
            float dist = Math.abs(node.x - lx) + Math.abs(node.y - ly);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            nd = node;
        }
        return (double)min_dist < d ? nd : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node<T> findNearestNode(float lx, float ly, Layer layer) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> nodes = this.node_layer_map.get(layer);
            if (null == nodes) {
                return null;
            }
            return this.findNearestNode(lx, ly, (float)layer.getZ(), layer.getParent().getCalibration(), nodes);
        }
    }

    private final Node<T> findNearestNode(float lx, float ly, float lz, Calibration cal, Collection<Node<T>> nodes) {
        if (null == nodes) {
            return null;
        }
        float pixelWidth = (float)cal.pixelWidth;
        float pixelHeight = (float)cal.pixelHeight;
        Node<T> nearest = null;
        float sqdist = Float.MAX_VALUE;
        for (Node<T> nd : nodes) {
            float d = (float)(Math.pow(pixelWidth * (nd.x - lx), 2.0) + Math.pow(pixelHeight * (nd.y - ly), 2.0) + Math.pow((double)pixelWidth * (nd.la.getZ() - (double)lz), 2.0));
            if (!(d < sqdist)) continue;
            sqdist = d;
            nearest = nd;
        }
        return nearest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node<T> findNearestEndNode(float lx, float ly, Layer layer) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            return this.findNearestNode(lx, ly, (float)layer.getZ(), layer.getParent().getCalibration(), this.end_nodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertNode(Node<T> parent, Node<T> child, Node<T> in_between, byte confidence) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            byte b = parent.getConfidence(child);
            parent.remove(child);
            parent.add(in_between, b);
            in_between.add(child, confidence);
            Collection<Node<T>> subtree = in_between.getSubtreeNodes();
            this.cacheSubtree(subtree);
            this.setLastAdded(in_between);
        }
        this.updateView();
        this.addToLinkLater(in_between);
        return true;
    }

    public Node<T>[] findNearestEdge(float x_pl, float y_pl, Layer layer, double magnification) {
        if (null == this.root) {
            return null;
        }
        Set<Node<T>> nodes = this.getNodesToPaint(layer);
        if (null == nodes) {
            return null;
        }
        double d = 10.0 / magnification;
        if (d < 2.0) {
            d = 2.0;
        }
        double min_dist = Double.MAX_VALUE;
        Node[] ns = new Node[2];
        for (Node node : nodes) {
            if (null == node.children) continue;
            for (Node child : node.children) {
                double dist = M.distancePointToSegment(x_pl, y_pl, node.x, node.y, child.x, child.y);
                if (!(dist < min_dist) || !(dist < d)) continue;
                min_dist = dist;
                ns[0] = node;
                ns[1] = child;
            }
        }
        if (null == ns[0]) {
            return null;
        }
        return ns;
    }

    private Node<T> findNearestChildEdge(Node<T> parent, float lx, float ly) {
        if (null == parent || null == parent.children) {
            return null;
        }
        Node nd = null;
        double min_dist = Double.MAX_VALUE;
        for (Node child : parent.children) {
            double dist = M.distancePointToSegment(lx, ly, parent.x, parent.y, child.x, child.y);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            nd = child;
        }
        return nd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(Node<T> parent, Node<T> child, byte confidence) {
        boolean added = false;
        Collection<Node<T>> subtree = null;
        Object object = this.node_layer_map;
        synchronized (object) {
            Set<Node<T>> nodes = this.node_layer_map.get(child.la);
            if (null == nodes) {
                nodes = new HashSet<Node<T>>();
                this.node_layer_map.put(child.la, nodes);
            }
            if (nodes.add(child)) {
                if (null != parent) {
                    if (!parent.hasChildren() && !this.end_nodes.remove(parent)) {
                        Utils.log("WARNING: parent wasn't in end_nodes list!");
                    }
                    parent.add(child, confidence);
                }
                if (null == child.children && !this.end_nodes.add(child)) {
                    Utils.log("WARNING: child was already in end_nodes list!");
                }
                subtree = child.getSubtreeNodes();
                this.cacheSubtree(subtree);
                this.setLastAdded(child);
                added = true;
            } else if (0 == nodes.size()) {
                this.node_layer_map.remove(child.la);
            }
        }
        if (added) {
            this.repaint(true, child.la);
            this.updateView();
            if (null != subtree) {
                object = this.tolink;
                synchronized (object) {
                    this.tolink.addAll(subtree);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean popNode(Node<T> node) {
        switch (node.getChildrenCount()) {
            case 0: {
                this.removeNode(node, null);
                return true;
            }
            case 1: {
                if (null == node.parent) {
                    this.root = node.children[0];
                    this.root.parent = null;
                    this.root.confidence = (byte)5;
                    if (node == this.last_visited) {
                        this.setLastVisited(this.root);
                    }
                } else {
                    node.parent.children[node.parent.indexOf(node)] = node.children[0];
                    node.children[0].parent = node.parent;
                    if (node == this.last_visited) {
                        this.setLastVisited(node.parent);
                    }
                }
                Map<Layer, Set<Node<T>>> map = this.node_layer_map;
                synchronized (map) {
                    this.node_layer_map.get(node.la).remove(node);
                }
                this.fireNodeRemoved(node);
                this.updateView();
                return true;
            }
        }
        return false;
    }

    public void removeNode(Node<T> node) {
        this.removeNode(node, node.getSubtreeNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(Node<T> node, Collection<Node<T>> subtree_nodes) {
        Object object = this.node_layer_map;
        synchronized (object) {
            if (null == node.parent) {
                this.root = null;
                this.clearCache();
            } else {
                if (null != node.children) {
                    Utils.log2("Removing children of node " + node);
                    for (Node<T> nd : subtree_nodes) {
                        this.node_layer_map.get(nd.la).remove(nd);
                        if (null != nd.children || this.end_nodes.remove(nd)) continue;
                        Utils.log2("WARNING: node to remove doesn't have any children but wasn't in end_nodes list!");
                    }
                } else {
                    Utils.log2("Just removing node " + node);
                    this.end_nodes.remove(node);
                    this.node_layer_map.get(node.la).remove(node);
                }
                if (1 == node.parent.getChildrenCount()) {
                    this.end_nodes.add(node.parent);
                }
                this.setLastVisited(node.parent);
                node.parent.remove(node);
            }
            this.fireNodeRemoved(node);
        }
        object = this.tolink;
        synchronized (object) {
            if (null != subtree_nodes) {
                this.tolink.removeAll(subtree_nodes);
            } else {
                this.tolink.remove(node);
            }
        }
        this.updateView();
    }

    public boolean canJoin(List<? extends Tree<T>> ts) {
        if (null == this.marked) {
            Utils.log("No marked node in to-be parent Tree " + this);
            return false;
        }
        if (null == this.root) {
            Utils.log("The root of this tree is null!");
            return false;
        }
        if (1 == ts.size()) {
            Utils.log("No other trees to join!");
            return false;
        }
        for (Tree<T> tl : ts) {
            if (this == tl) continue;
            if (null == tl.root) {
                Utils.log("Can't join: tree #" + tl.id + " does not have any nodes!");
                return false;
            }
            if (this.getClass() != tl.getClass()) {
                Utils.log("For joining, all trees must be of the same kind!");
                return false;
            }
            if (null != tl.marked) continue;
            Utils.log("No marked node in to-be child treeline " + tl);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean join(List<? extends Tree<T>> ts) {
        if (!this.canJoin(ts)) {
            return false;
        }
        for (Tree<T> tl : ts) {
            AffineTransform at_inv;
            if (this == tl) continue;
            tl.marked.setRoot();
            try {
                at_inv = this.at.createInverse();
            }
            catch (NoninvertibleTransformException nite) {
                IJError.print(nite);
                return false;
            }
            AffineTransform aff = new AffineTransform(tl.at);
            aff.preConcatenate(at_inv);
            float[] fps = new float[2];
            for (Node<T> nd : tl.marked.getSubtreeNodes()) {
                fps[0] = nd.x;
                fps[1] = nd.y;
                aff.transform(fps, 0, fps, 0, 1);
                nd.x = fps[0];
                nd.y = fps[1];
                nd.transformData(aff);
                this.removeReview(nd);
            }
            this.addNode(this.marked, tl.marked, (byte)5);
            tl.root = null;
            tl.setLastMarked(null);
            Map<Layer, Set<Node<T>>> map = tl.node_layer_map;
            synchronized (map) {
                tl.node_layer_map.clear();
            }
            tl.end_nodes.clear();
        }
        this.updateView();
        return true;
    }

    protected Node<T> findNodeNear(float x, float y, Layer layer, DisplayCanvas dc) {
        return this.findNodeNear(x, y, layer, dc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<T> findNodeNear(float x, float y, Layer layer, DisplayCanvas dc, boolean use_receiver_when_null) {
        if (!this.at.isIdentity()) {
            Point2D.Double po = this.inverseTransformPoint(x, y);
            x = (float)po.x;
            y = (float)po.y;
        }
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> nodes = this.node_layer_map.get(layer);
            if (null == nodes || nodes.isEmpty()) {
                Utils.log("No nodes at " + x + ", " + y + ", " + layer);
                return null;
            }
            Node<T> nd = this.findNode(x, y, layer, dc.getMagnification());
            if (null == nd) {
                Area a;
                try {
                    a = new Area(dc.getSrcRect()).createTransformedArea(this.at.createInverse());
                }
                catch (NoninvertibleTransformException nite) {
                    IJError.print(nite);
                    return null;
                }
                int count = 0;
                for (Node<T> node : nodes) {
                    if (!node.intersects(a)) continue;
                    nd = node;
                    if (++count <= 1) continue;
                    nd = null;
                    break;
                }
            }
            Node<T> receiver = this.last_visited;
            if (null == nd && use_receiver_when_null && null != receiver && receiver.la == layer) {
                float[] f = new float[]{receiver.x, receiver.y};
                this.at.transform(f, 0, f, 0, 1);
                if (dc.getSrcRect().contains((int)f[0], (int)f[1])) {
                    nd = receiver;
                }
            }
            return nd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markNear(float x, float y, Layer layer, double magnification) {
        if (!this.at.isIdentity()) {
            Point2D.Double po = this.inverseTransformPoint(x, y);
            x = (float)po.x;
            y = (float)po.y;
        }
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> nodes = this.node_layer_map.get(layer);
            if (null == nodes || nodes.isEmpty()) {
                Utils.log("No nodes at " + x + ", " + y + ", " + layer);
                return false;
            }
            nodes = null;
            Node<T> found = this.findNode(x, y, layer, magnification);
            if (null == found) {
                Utils.log("No node near " + x + ", " + y + ", " + layer + ", mag=" + magnification);
                return false;
            }
            this.setLastMarked(found);
            return true;
        }
    }

    public boolean unmark() {
        if (null != this.marked) {
            this.setLastMarked(null);
            return true;
        }
        return false;
    }

    protected void setActive(Node<T> nd) {
        this.active = nd;
    }

    protected Node<T> getActive() {
        return this.active;
    }

    protected void setLastEdited(Node<T> nd) {
        this.last_edited = nd;
        this.setLastVisited(nd);
    }

    protected void setLastAdded(Node<T> nd) {
        this.last_added = nd;
        this.setLastVisited(nd);
    }

    public void setLastMarked(Node<T> nd) {
        this.marked = nd;
        this.setLastVisited(nd);
    }

    protected void setLastVisited(Node<T> nd) {
        this.last_visited = nd;
    }

    public Node<T> getMarked() {
        return this.marked;
    }

    public Node<T> getLastVisited() {
        return this.last_visited;
    }

    @Override
    public void deselect() {
        this.setLastVisited(null);
    }

    protected void fireNodeRemoved(Node<T> nd) {
        if (nd == this.marked) {
            this.marked = null;
        }
        if (nd == this.last_added) {
            this.last_added = null;
        }
        if (nd == this.last_edited) {
            this.last_edited = null;
        }
        if (nd == this.last_visited) {
            this.last_visited = null != nd.parent ? nd.parent : (nd.getChildrenCount() > 0 ? nd.children[0] : null);
        }
        this.removeFromLinkLater(nd);
        this.removeReview(nd);
    }

    protected void clearState() {
        this.last_visited = null;
        this.last_edited = null;
        this.last_added = null;
        this.marked = null;
    }

    private static final void createMarks() {
        MARKED_PARENT = new Polygon(new int[]{0, -1, -2, -4, -18, -18, -4, -2, -1}, new int[]{0, -2, -3, -4, -4, 4, 4, 3, 2}, 9);
        MARKED_CHILD = new Polygon(new int[]{0, 10, 12, 12, 22, 22, 12, 12, 10}, new int[]{0, 10, 10, 4, 4, -4, -4, -10, -10}, 9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mousePressed(MouseEvent me, Layer layer, int x_p, int y_p, double mag) {
        if (16 != ProjectToolbar.getToolId()) {
            return;
        }
        if (null != this.root) {
            int x_pl = x_p;
            int y_pl = y_p;
            if (!this.at.isIdentity()) {
                Point2D.Double po = this.inverseTransformPoint(x_p, y_p);
                x_pl = (int)po.x;
                y_pl = (int)po.y;
            }
            Node<T> found = this.findNode(x_pl, y_pl, layer, mag);
            this.setActive(found);
            if (null != found) {
                if (2 == me.getClickCount()) {
                    this.setLastMarked(found);
                    this.setActive(null);
                    return;
                }
                if (!me.isShiftDown() || !Utils.isControlDown(me)) return;
                if (me.isAltDown()) {
                    this.removeNode(found);
                } else if (!this.popNode(found)) {
                    Utils.log("Can't pop out branch point!\nUse shift+control+alt+click to remove a branch point and its subtree.");
                    this.setActive(null);
                    return;
                }
                this.repaint(false, layer);
                this.setActive(null);
                return;
            }
            if (2 == me.getClickCount()) {
                this.setLastMarked(null);
                return;
            }
            if (me.isAltDown()) {
                return;
            }
            if (me.isShiftDown()) {
                Node<T>[] ns = this.findNearestEdge(x_pl, y_pl, layer, mag);
                if (null == ns) return;
                found = this.createNewNode(x_pl, y_pl, layer, ns[0]);
                this.insertNode(ns[0], ns[1], found, ns[0].getConfidence(ns[1]));
                this.setActive(found);
                return;
            } else {
                Node<T> nearest = this.last_visited;
                if (null == nearest) {
                    Utils.showMessage("Before adding a new node, please activate an existing node\nby clicking on it, or pushing 'g' on it.");
                    return;
                }
                found = this.createNewNode(x_pl, y_pl, layer, nearest);
                this.addNode(nearest, found, (byte)5);
                this.setActive(found);
                this.repaint(true, layer);
            }
            return;
        }
        this.root = this.createNewNode(x_p, y_p, layer, null);
        this.addNode(null, this.root, (byte)0);
        this.setActive(this.root);
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        this.translateActive(me, la, x_d, y_d, x_d_old, y_d_old);
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        int tool = ProjectToolbar.getToolId();
        this.translateActive(me, la, x_r, y_d, x_d, y_d);
        if (16 == tool || 15 == tool) {
            this.repaint(true, la);
        }
        this.updateViewData(this.active);
        this.setLastVisited(this.active);
        this.setActive(null);
    }

    private final void translateActive(MouseEvent me, Layer la, int x_d, int y_d, int x_d_old, int y_d_old) {
        if (null == this.active || me.isAltDown() || Utils.isControlDown(me)) {
            return;
        }
        if (!this.at.isIdentity()) {
            Point2D.Double pd = this.inverseTransformPoint(x_d, y_d);
            x_d = (int)pd.x;
            y_d = (int)pd.y;
            Point2D.Double pdo = this.inverseTransformPoint(x_d_old, y_d_old);
            x_d_old = (int)pdo.x;
            y_d_old = (int)pdo.y;
        }
        this.active.translate(x_d - x_d_old, y_d - y_d_old);
        this.repaint(false, la);
        this.setLastEdited(this.active);
    }

    protected boolean isTagging() {
        return null != to_tag || null != to_untag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void keyPressed(KeyEvent ke) {
        block75: {
            block73: {
                block72: {
                    block71: {
                        block70: {
                            block69: {
                                switch (ProjectToolbar.getToolId()) {
                                    case 16: 
                                    case 17: {
                                        break;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                                source = ke.getSource();
                                if (!(source instanceof DisplayCanvas)) {
                                    return;
                                }
                                keyCode = ke.getKeyCode();
                                dc = (DisplayCanvas)source;
                                if (null == Tree.to_tag && null == Tree.to_untag) break block75;
                                if (!Character.isLetterOrDigit((char)keyCode) || !Character.isDigit((char)keyCode) && !Character.isUpperCase((char)keyCode)) {
                                    Utils.showStatus("Canceled tagging");
                                    Tree.to_tag = null;
                                    Tree.to_untag = null;
                                    ke.consume();
                                    return;
                                }
                                if (!Tree.show_tag_dialogs && 48 == keyCode) {
                                    Tree.show_tag_dialogs = true;
                                    ke.consume();
                                    return;
                                }
                                untag = null != Tree.to_untag;
                                target = untag != false ? Tree.to_untag : Tree.to_tag;
                                this.layer_set.addPreDataEditStep(this);
                                if (!Tree.show_tag_dialogs) break block69;
                                if (untag) {
                                    if (this.layer_set.askToRemoveTag(keyCode)) {
                                        this.layer_set.addDataEditStep(this);
                                    }
                                } else {
                                    t = this.layer_set.askForNewTag(keyCode);
                                    if (null != t) {
                                        target.addTag(t);
                                        Display.repaint(this.layer_set);
                                        this.layer_set.addDataEditStep(this);
                                    }
                                }
                                Tree.show_tag_dialogs = false;
                                this.updateViewData(untag != false ? Tree.to_untag : Tree.to_tag);
                                Tree.to_tag = null;
                                Tree.to_untag = null;
                                ke.consume();
                                return;
                            }
                            ts = this.layer_set.getTags(keyCode);
                            if (!ts.isEmpty()) ** GOTO lbl67
                            if (!untag) break block70;
                            this.updateViewData(untag != false ? Tree.to_untag : Tree.to_tag);
                            Tree.to_tag = null;
                            Tree.to_untag = null;
                            ke.consume();
                            return;
                        }
                        if (null != this.layer_set.askForNewTag(keyCode)) break block71;
                        this.updateViewData(untag != false ? Tree.to_untag : Tree.to_tag);
                        Tree.to_tag = null;
                        Tree.to_untag = null;
                        ke.consume();
                        return;
                    }
                    ts = this.layer_set.getTags(keyCode);
lbl67:
                    // 2 sources

                    target_tags = target.getTags();
                    if (!untag || null != target_tags && !target_tags.isEmpty()) break block72;
                    this.updateViewData(untag != false ? Tree.to_untag : Tree.to_tag);
                    Tree.to_tag = null;
                    Tree.to_untag = null;
                    ke.consume();
                    return;
                }
                if (ts.size() <= 1) ** GOTO lbl128
                if (!untag || null == target_tags) break block73;
                count = 0;
                t = null;
                for (final Tag tag : target_tags) {
                    if (tag.getKeyCode() != keyCode) continue;
                    ++count;
                    t = tag;
                }
                if (true != count) break block73;
                target.removeTag(t);
                Display.repaint(this.layer_set);
                this.updateViewData(untag != false ? Tree.to_untag : Tree.to_tag);
                Tree.to_tag = null;
                Tree.to_untag = null;
                ke.consume();
                return;
            }
            try {
                block76: {
                    popup = new JPopupMenu();
                    popup.add(new JLabel(untag != false ? "Untag:" : "Tag:"));
                    i = 1;
                    for (final Tag tag : ts) {
                        item = new JMenuItem(tag.toString());
                        popup.add(item);
                        if (i < 10) {
                            item.setAccelerator(KeyStroke.getKeyStroke(48 + i, 0, true));
                        }
                        ++i;
                        if (null != target_tags) {
                            if (untag) {
                                item.setEnabled(target_tags.contains(tag));
                            } else {
                                item.setEnabled(target_tags.contains(tag) == false);
                            }
                        }
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                if (untag) {
                                    target.removeTag(tag);
                                } else {
                                    target.addTag(tag);
                                }
                                Display.repaint(Tree.this.layer_set);
                                Tree.this.layer_set.addDataEditStep(Tree.this);
                                Tree.this.updateViewData(target);
                            }
                        });
                    }
                    popup.addSeparator();
                    item = new JMenuItem(untag != false ? "Remove tag..." : "Define new tag...");
                    popup.add(item);
                    item.setAccelerator(KeyStroke.getKeyStroke(48, 0, true));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            if (untag) {
                                Tree.this.layer_set.askToRemoveTag(keyCode);
                            } else {
                                Tag t = Tree.this.layer_set.askForNewTag(keyCode);
                                if (null == t) {
                                    return;
                                }
                                target.addTag(t);
                                Display.repaint(Tree.this.layer_set);
                            }
                            Tree.this.layer_set.addDataEditStep(Tree.this);
                            Tree.this.updateViewData(target);
                        }
                    });
                    fp = new float[]{target.x, target.y};
                    this.at.transform(fp, 0, fp, 0, 1);
                    srcRect = dc.getSrcRect();
                    magnification = dc.getMagnification();
                    x = (int)((double)(fp[0] - (float)srcRect.x) * magnification);
                    y = (int)((double)(fp[1] - (float)srcRect.y) * magnification);
                    popup.show((Component)dc, x, y);
                    break block76;
lbl128:
                    // 1 sources

                    if (untag) {
                        target.removeTag(ts.first());
                    } else {
                        target.addTag(ts.first());
                    }
                    Display.repaint(this.layer_set);
                    this.layer_set.addDataEditStep(this);
                }
                this.updateViewData(untag != false ? Tree.to_untag : Tree.to_tag);
                Tree.to_tag = null;
                Tree.to_untag = null;
            }
            catch (Throwable var18_27) {
                this.updateViewData(untag != false ? Tree.to_untag : Tree.to_tag);
                Tree.to_tag = null;
                Tree.to_untag = null;
                ke.consume();
                throw var18_27;
            }
            ke.consume();
            return;
        }
        po = dc.getCursorLoc();
        if (keyCode >= 48 && keyCode <= 53) {
            if (null != this.setEdgeConfidence((byte)(keyCode - 48))) {
                Display.repaint(this.layer_set);
                ke.consume();
            }
            return;
        }
        modifiers = ke.getModifiers();
        display = Display.getFront();
        layer = display.getLayer();
        nd = null;
        c = null;
        try {
            switch (keyCode) {
                case 84: {
                    if (0 == modifiers) {
                        Tree.to_tag = this.findNodeNear(po.x, po.y, layer, dc, true);
                    } else if (0 == (modifiers ^ 1)) {
                        Tree.to_untag = this.findNodeNear(po.x, po.y, layer, dc, true);
                    }
                    ke.consume();
                    return;
                }
            }
            if (0 == modifiers) {
                switch (keyCode) {
                    case 82: {
                        nd = this.root;
                        display.center(this.createCoordinate(this.root));
                        ke.consume();
                        return;
                    }
                    case 66: {
                        c = this.findPreviousBranchOrRootPoint(po.x, po.y, layer, dc);
                        if (null == c) {
                            return;
                        }
                        nd = (Node<T>)c.object;
                        display.center(c);
                        ke.consume();
                        return;
                    }
                    case 78: {
                        c = this.findNextBranchOrEndPoint(po.x, po.y, layer, dc);
                        if (null == c) {
                            return;
                        }
                        nd = (Node)c.object;
                        display.center(c);
                        ke.consume();
                        return;
                    }
                    case 76: {
                        c = this.getLastAdded();
                        if (null == c) {
                            return;
                        }
                        nd = (Node<T>)c.object;
                        display.center(c);
                        ke.consume();
                        return;
                    }
                    case 69: {
                        c = this.getLastEdited();
                        if (null == c) {
                            return;
                        }
                        nd = (Node)c.object;
                        display.center(c);
                        ke.consume();
                        return;
                    }
                    case 93: {
                        display.animateBrowsingTo(this.findNearAndGetNext(po.x, po.y, layer, dc));
                        ke.consume();
                        return;
                    }
                    case 91: {
                        display.animateBrowsingTo(this.findNearAndGetPrevious(po.x, po.y, layer, dc));
                        ke.consume();
                        return;
                    }
                    case 71: {
                        nd = this.findClosestNodeW(this.getNodesToPaint(layer), (float)po.x, po.y, dc.getMagnification());
                        if (null == nd) break;
                        display.toLayer(nd.la);
                        if (nd != this.last_visited) {
                            this.setLastVisited(nd);
                            display.getCanvas().repaint(false);
                        }
                        ke.consume();
                        return;
                    }
                }
            }
            if (16 == ProjectToolbar.getToolId() && 0 == (modifiers ^ 1) && 67 == keyCode) {
                nd = this.findClosestNodeW(this.getNodesToPaint(layer), (float)po.x, po.y, dc.getMagnification());
                if (null == nd && null != (last = this.getLastVisited()) && layer == last.getLayer()) {
                    nd = last;
                }
                if (null != nd && this.adjustNodeColors(nd)) {
                    ke.consume();
                    return;
                }
            }
        }
        finally {
            if (null != nd) {
                this.setLastVisited(nd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean adjustNodeColors(final Node<T> nd) {
        Color color = null == nd.color ? this.color : nd.color;
        GenericDialog gd = new GenericDialog("Node colors");
        gd.addSlider("Red: ", 0.0, 255.0, (double)color.getRed());
        gd.addSlider("Green: ", 0.0, 255.0, (double)color.getGreen());
        gd.addSlider("Blue: ", 0.0, 255.0, (double)color.getBlue());
        final Scrollbar red = (Scrollbar)gd.getSliders().get(0);
        final Scrollbar green = (Scrollbar)gd.getSliders().get(1);
        final Scrollbar blue = (Scrollbar)gd.getSliders().get(2);
        Color original = nd.color;
        Displayable.SliderListener slc = new Displayable.SliderListener(){

            @Override
            public void update() {
                nd.setColor(new Color(red.getValue(), green.getValue(), blue.getValue()));
                Display.repaint();
            }
        };
        red.addAdjustmentListener(slc);
        green.addAdjustmentListener(slc);
        blue.addAdjustmentListener(slc);
        String[] choices = new String[]{"this node only", "nodes until next branch or end node", "entire subtree"};
        gd.addChoice("Apply to:", choices, choices[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            nd.setColor(original);
            Display.repaint();
            return false;
        }
        try {
            this.layer_set.addDataEditStep(this);
            Color c = new Color(red.getValue(), green.getValue(), blue.getValue());
            switch (gd.getNextChoiceIndex()) {
                case 0: {
                    boolean bl = true;
                    return bl;
                }
                case 1: {
                    for (Node<T> node : new Node.NodeCollection<T>(nd, Node.SlabIterator.class)) {
                        node.setColor(c);
                    }
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    for (Node<T> node : new Node.NodeCollection<T>(nd, Node.BreadthFirstSubtreeIterator.class)) {
                        node.setColor(c);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            this.layer_set.removeLastUndoStep();
        }
        finally {
            this.layer_set.addDataEditStep(this);
            Display.repaint();
        }
        return true;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int modifiers = mwe.getModifiers();
        if (0 == (1 ^ modifiers)) {
            Object source = mwe.getSource();
            if (!(source instanceof DisplayCanvas)) {
                return;
            }
            DisplayCanvas dc = (DisplayCanvas)source;
            Layer la = dc.getDisplay().getLayer();
            int rotation = mwe.getWheelRotation();
            double magnification = dc.getMagnification();
            Rectangle srcRect = dc.getSrcRect();
            float x = (float)((double)mwe.getX() / magnification + (double)srcRect.x);
            float y = (float)((double)mwe.getY() / magnification + (double)srcRect.y);
            this.adjustEdgeConfidence(rotation > 0 ? 1 : -1, x, y, la, dc);
            Display.repaint(this);
            mwe.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoot(Node<T> new_root) {
        this.root = new_root;
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            if (null == new_root) {
                this.clearCache();
            } else {
                this.cacheSubtree(new_root.getSubtreeNodes());
            }
        }
    }

    @Override
    public void paintSnapshot(Graphics2D g, Layer layer, List<Layer> layers, Rectangle srcRect, double mag) {
        switch (this.layer_set.getSnapshotsMode()) {
            case 0: {
                this.paint(g, srcRect, mag, false, -1, layer, layers, false, false);
                return;
            }
            case 1: {
                this.paintAsBox(g);
                return;
            }
        }
    }

    public Set<Node<T>> getEndNodes() {
        return new HashSet<Node<T>>(this.end_nodes);
    }

    public ImagePlus flyThroughMarked(int width, int height, double magnification, int type, String dir) {
        if (null == this.marked) {
            return null;
        }
        return this.flyThrough(this.root, this.marked, width, height, magnification, type, dir);
    }

    public LinkedList<Region<Node<T>>> generateRegions(Node<T> first, Node<T> last, int width, int height, double magnification) {
        LinkedList<Region<Node<T>>> regions = new LinkedList<Region<Node<T>>>();
        Node<T> node = last;
        float[] fps = new float[2];
        while (null != node) {
            fps[0] = node.x;
            fps[1] = node.y;
            this.at.transform(fps, 0, fps, 0, 1);
            regions.addFirst(new Region<Node<T>>(new Rectangle((int)fps[0] - width / 2, (int)fps[1] - height / 2, width, height), node.la, node));
            if (first == node) break;
            node = node.parent;
        }
        return regions;
    }

    public ImagePlus flyThrough(Node<T> first, Node<T> last, int width, int height, double magnification, int type, String dir) {
        return this.project.getLoader().createFlyThrough(this.generateRegions(first, last, width, height, magnification), magnification, type, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultsTable measure(ResultsTable rt) {
        if (null == this.root) {
            return rt;
        }
        double cable = 0.0;
        double lb_cable = 0.0;
        int branch_points = 0;
        Calibration cal = this.layer_set.getCalibration();
        double pixelWidth = cal.pixelWidth;
        double pixelHeight = cal.pixelHeight;
        float[] fps = new float[4];
        float[] fpp = new float[2];
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            for (Collection collection : this.node_layer_map.values()) {
                for (Node nd : collection) {
                    if (nd.getChildrenCount() > 1) {
                        ++branch_points;
                    }
                    if (null == nd.parent) continue;
                    fps[0] = nd.x;
                    fps[2] = nd.parent.x;
                    fps[1] = nd.y;
                    fps[3] = nd.parent.y;
                    this.at.transform(fps, 0, fps, 0, 2);
                    cable += Math.sqrt(Math.pow((double)(fps[0] - fps[2]) * pixelWidth, 2.0) + Math.pow((double)(fps[1] - fps[3]) * pixelHeight, 2.0) + Math.pow((nd.la.getZ() - nd.parent.la.getZ()) * pixelWidth, 2.0));
                    if (1 == nd.getChildrenCount()) continue;
                    Node prev = nd.findPreviousBranchOrRootPoint();
                    if (null == prev) {
                        Utils.log("ERROR: Can't find the previous branch or root point for node " + nd);
                        continue;
                    }
                    fpp[0] = prev.x;
                    fpp[1] = prev.y;
                    this.at.transform(fpp, 0, fpp, 0, 1);
                    lb_cable += Math.sqrt(Math.pow((double)(fpp[0] - fps[0]) * pixelWidth, 2.0) + Math.pow((double)(fpp[1] - fps[1]) * pixelHeight, 2.0) + Math.pow((nd.la.getZ() - nd.parent.la.getZ()) * pixelWidth, 2.0));
                }
            }
        }
        if (null == rt) {
            rt = Utils.createResultsTable("Tree results", new String[]{"id", "N branch points", "N end points", "Cable length", "LB Cable length"});
        }
        rt.incrementCounter();
        rt.addLabel("units", cal.getUnit());
        rt.addValue(0, (double)this.id);
        rt.addValue(1, (double)branch_points);
        rt.addValue(2, (double)this.end_nodes.size());
        rt.addValue(3, cable);
        rt.addValue(4, lb_cable);
        return rt;
    }

    @Override
    public boolean intersects(Layer layer, Rectangle r) {
        Set<Node<T>> nodes = this.node_layer_map.get(layer);
        if (null == nodes || nodes.isEmpty()) {
            return false;
        }
        try {
            return null != this.findFirstIntersectingNode(nodes, new Area(r).createTransformedArea(this.at.createInverse()));
        }
        catch (NoninvertibleTransformException e) {
            IJError.print(e);
            return false;
        }
    }

    @Override
    public boolean intersects(Layer layer, Area area) {
        return null != this.firstIntersectingNode(layer, area);
    }

    public Node<T> firstIntersectingNode(Layer layer, Area area) {
        Set<Node<T>> nodes = this.node_layer_map.get(layer);
        if (null == nodes || nodes.isEmpty()) {
            return null;
        }
        try {
            return this.findFirstIntersectingNode(nodes, area.createTransformedArea(this.at.createInverse()));
        }
        catch (NoninvertibleTransformException e) {
            IJError.print(e);
            return null;
        }
    }

    protected Node<T> findFirstIntersectingNode(Set<Node<T>> nodes, Area a) {
        for (Node<T> nd : nodes) {
            if (!nd.intersects(a)) continue;
            return nd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paintsAt(Layer layer) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Collection nodes = this.node_layer_map.get(layer);
            return null != nodes && nodes.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeTag(Tag tag) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            for (Map.Entry<Layer, Set<Node<T>>> e : this.node_layer_map.entrySet()) {
                for (Node<T> nd : e.getValue()) {
                    nd.removeTag(tag);
                }
            }
        }
    }

    public Future<JFrame> createMultiTableView() {
        if (null == this.root) {
            return null;
        }
        return this.project.getLoader().doLater(new Callable<JFrame>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public JFrame call() {
                Tree tree = Tree.this;
                synchronized (tree) {
                    try {
                        if (null == Tree.this.tndv) {
                            Tree.this.tndv = new TreeNodesDataView(Tree.this.root);
                            return Tree.this.tndv.frame;
                        }
                        Tree.this.tndv.show();
                        return Tree.this.tndv.frame;
                    }
                    catch (Exception e) {
                        IJError.print(e);
                        return null;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateView() {
        if (null == this.tndv) {
            return;
        }
        TreeNodesDataView treeNodesDataView = this.tndv;
        synchronized (treeNodesDataView) {
            this.tndv.recreate(this.root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateViewData(Node<?> node) {
        if (null == this.tndv) {
            return;
        }
        TreeNodesDataView treeNodesDataView = this.tndv;
        synchronized (treeNodesDataView) {
            this.tndv.updateData(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove2(boolean check) {
        if (super.remove2(check)) {
            Tree tree = this;
            synchronized (tree) {
                if (null != this.tndv) {
                    this.tndv.frame.dispose();
                    this.tndv = null;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean layerRemoved(Layer la) {
        Set<Node<T>> nodes;
        super.layerRemoved(la);
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            nodes = this.node_layer_map.remove(la);
        }
        if (null == nodes) {
            return true;
        }
        Iterator<Node<T>> it = nodes.iterator();
        block7: while (it.hasNext()) {
            int i;
            Node<T> nd = it.next();
            it.remove();
            this.fireNodeRemoved(nd);
            if (null == nd.parent) {
                switch (nd.getChildrenCount()) {
                    case 1: {
                        this.root = nd.children[0];
                        this.root.parent = null;
                        nd.children[0] = null;
                        continue block7;
                    }
                    case 0: {
                        this.root = null;
                        continue block7;
                    }
                }
                this.root = nd.children[0];
                this.root.parent = null;
                nd.children[0] = null;
                for (i = 1; i < nd.children.length; ++i) {
                    nd.children[i].parent = null;
                    this.root.add(nd.children[i], nd.children[i].confidence);
                    nd.children[i] = null;
                }
                continue;
            }
            if (null == nd.children) {
                this.end_nodes.remove(nd);
            } else {
                for (i = 0; i < nd.children.length; ++i) {
                    nd.children[i].parent = null;
                    nd.parent.add(nd.children[i], nd.children[i].confidence);
                }
            }
            nd.parent.remove(nd);
        }
        this.calculateBoundingBox(la);
        this.updateView();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(Layer la, Area roi, CoordinateTransform ict) throws Exception {
        CoordinateTransform chain = null;
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            if (null == this.root) {
                return true;
            }
            Set<Node<T>> nodes = this.node_layer_map.get(la);
            if (null == nodes || nodes.isEmpty()) {
                return true;
            }
            AffineTransform inverse = this.at.createInverse();
            Area localroi = roi.createTransformedArea(inverse);
            for (Node<T> nd : nodes) {
                if (nd.intersects(localroi) && null == chain) {
                    chain = M.wrap(this.at, ict, inverse);
                }
                nd.apply(chain, roi);
            }
        }
        if (null != chain) {
            this.calculateBoundingBox(la);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(VectorDataTransform vdt) throws Exception {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            if (null == this.root) {
                return true;
            }
            Set<Node<T>> nodes = this.node_layer_map.get(vdt.layer);
            if (null == nodes || nodes.isEmpty()) {
                return true;
            }
            VectorDataTransform vlocal = vdt.makeLocalTo(this);
            for (Node<T> nd : nodes) {
                nd.apply(vlocal);
            }
        }
        this.calculateBoundingBox(vdt.layer);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> getLayerIds() {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            ArrayList<Long> ids = new ArrayList<Long>(this.node_layer_map.size());
            for (Layer la : this.node_layer_map.keySet()) {
                ids.add(la.getId());
            }
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Layer> getLayersWithData() {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            return new ArrayList<Layer>(this.node_layer_map.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Area getAreaAt(Layer layer) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Area a = new Area();
            Set<Node<T>> nodes = this.node_layer_map.get(layer);
            if (null == nodes) {
                return a;
            }
            for (Node<T> nd : nodes) {
                a.add(nd.getArea());
            }
            a.transform(this.at);
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isRoughlyInside(Layer layer, Rectangle box) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> nodes = this.node_layer_map.get(layer);
            if (null == nodes) {
                return false;
            }
            try {
                Rectangle local = this.at.createInverse().createTransformedShape(box).getBounds();
                for (Node<T> nd : nodes) {
                    if (!nd.isRoughlyInside(local)) continue;
                    return true;
                }
                return false;
            }
            catch (NoninvertibleTransformException nite) {
                IJError.print(nite);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean crop(List<Layer> range) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            HashSet<Layer> keep = new HashSet<Layer>(range);
            Iterator<Map.Entry<Layer, Set<Node<T>>>> it = this.node_layer_map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Layer, Set<Node<T>>> e = it.next();
                if (keep.contains(e.getKey())) continue;
                it.remove();
                for (Node<T> nd : e.getValue()) {
                    if (null == nd.parent) {
                        if (null == nd.children) {
                            this.root = null;
                            continue;
                        }
                        nd.children[0].parent = null;
                        this.root = nd.children[0];
                        for (int i = 1; i < nd.children.length; ++i) {
                            nd.children[i].parent = null;
                            nd.children[0].add(nd.children[i], nd.children[i].confidence);
                        }
                        continue;
                    }
                    Node nd_parent = nd.parent;
                    nd.parent.remove(nd);
                    if (null == nd.children) continue;
                    for (int i = 0; i < nd.children.length; ++i) {
                        nd.children[i].parent = null;
                        nd_parent.add(nd.children[i], nd.children[i].confidence);
                    }
                }
            }
            this.clearState();
            return true;
        }
    }

    private Future<ImagePlus> openImage(final String path, final Node<T> last) {
        return this.project.getLoader().doLater(new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                try {
                    if (!new File(path).exists()) {
                        Utils.log("Could not find file " + path);
                        return null;
                    }
                    Tree.this.project.getLoader().releaseToFit(1000000000L);
                    Opener op = new Opener();
                    op.setSilentMode(true);
                    final ImagePlus imp = op.openImage(path);
                    if (null == imp) {
                        Utils.log("ERROR: could not open " + path);
                    } else {
                        MouseListener[] ml;
                        StackWindow stack = new StackWindow(imp);
                        for (MouseListener m : ml = stack.getCanvas().getMouseListeners()) {
                            stack.getCanvas().removeMouseListener(m);
                        }
                        stack.getCanvas().addMouseListener((MouseListener)new MouseAdapter(){

                            @Override
                            public void mousePressed(MouseEvent me) {
                                if (2 == me.getClickCount()) {
                                    me.consume();
                                    int slice = imp.getCurrentSlice();
                                    if (slice == imp.getNSlices()) {
                                        Display.centerAt(Tree.this.createCoordinate(last));
                                    } else {
                                        int count = imp.getNSlices() - 1;
                                        for (Node parent = last.getParent(); null != parent; parent = parent.getParent()) {
                                            if (count == slice) {
                                                Display.centerAt(Tree.this.createCoordinate(parent));
                                                break;
                                            }
                                            --count;
                                        }
                                    }
                                }
                            }

                            @Override
                            public void mouseDragged(MouseEvent me) {
                                if (2 == me.getClickCount()) {
                                    me.consume();
                                }
                            }

                            @Override
                            public void mouseReleased(MouseEvent me) {
                                if (2 == me.getClickCount()) {
                                    me.consume();
                                }
                            }
                        });
                        for (MouseListener m : ml) {
                            stack.getCanvas().addMouseListener(m);
                        }
                    }
                    return imp;
                }
                catch (Exception e) {
                    IJError.print(e);
                    return null;
                }
            }
        });
    }

    public Bureaucrat generateAllReviewStacks() {
        return this.generateSubtreeReviewStacks(this.root);
    }

    public Bureaucrat generateSubtreeReviewStacks(final Node<T> root) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Generating review stacks"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exec() {
                if (null == root) {
                    return;
                }
                int nproc = Runtime.getRuntime().availableProcessors();
                ExecutorService exe = Executors.newFixedThreadPool(Math.max(1, Math.min(4, nproc)));
                TreeNodesDataView tndv = Tree.this.tndv;
                if (null != tndv && null != tndv.frame) {
                    Utils.setEnabled(tndv.frame.getContentPane(), false);
                }
                try {
                    ArrayList fus = new ArrayList();
                    final Object dirsync = new Object();
                    ArrayList be_nodes = new ArrayList();
                    for (Node nd : root.getSubtreeNodes()) {
                        Tree.this.removeReview(nd);
                        if (1 == nd.getChildrenCount()) continue;
                        be_nodes.add(nd);
                    }
                    Runnable[] rs = new Runnable[be_nodes.size()];
                    int n_digits = Integer.toString(rs.length).length();
                    int k = 0;
                    for (final Node node : be_nodes) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        final Tag tag = new Tag("#R-" + Utils.zeroPad(k + 1, n_digits), 82);
                        node.addTag(tag);
                        Tree.this.updateViewData(node);
                        rs[k] = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                String filepath = Tree.this.getReviewTagPath(tag);
                                Object object = dirsync;
                                synchronized (object) {
                                    if (!Utils.ensure(filepath)) {
                                        Utils.log("Did NOT create review stack for tag " + tag);
                                        return;
                                    }
                                }
                                Tree.this.createReviewStack(node.findPreviousBranchOrRootPoint(), node, tag, filepath, 512, 512, 1.0, 4);
                            }
                        };
                        ++k;
                    }
                    Display.repaint(Tree.this.getLayerSet());
                    for (int i = 0; i < rs.length; ++i) {
                        fus.add(exe.submit(rs[i]));
                    }
                    Utils.wait(fus);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                finally {
                    if (null != tndv && null != tndv.frame) {
                        Utils.setEnabled(tndv.frame.getContentPane(), true);
                    }
                    exe.shutdown();
                    Display.repaint(Tree.this.getLayerSet());
                }
            }
        }, this.getProject());
    }

    public void createReviewStack(Node<T> first, Node<T> last, Tag tag, String filepath, int width, int height, double magnification, int image_type) {
        try {
            ImagePlus imp = this.project.getLoader().createLazyFlyThrough(this.generateRegions(first, last, width, height, magnification), magnification, image_type, this);
            imp.setTitle(imp.getTitle() + tag.toString());
            IJ.redirectErrorMessages();
            new FileSaver(imp).saveAsZip(filepath);
        }
        catch (Exception e) {
            IJError.print(e);
            Utils.log("\nERROR: NOT created review stack for " + tag.toString());
            return;
        }
    }

    private String getReviewTagPath(Tag tag) {
        return this.getProject().getLoader().getUNUIdFolder() + "tree.review.stacks/" + this.getId() + "/" + tag.toString().substring(1) + ".zip";
    }

    boolean removeReview(Node<T> nd) {
        Set<Tag> tags = nd.getTags();
        if (null == tags) {
            return true;
        }
        for (Tag tag : tags) {
            String s = tag.toString();
            if (!s.startsWith("#R-")) continue;
            try {
                String path = this.getReviewTagPath(tag);
                File f = new File(path);
                if (f.exists() && !f.delete()) {
                    Utils.log("FAILED to delete: " + path + "\n   did NOT remove tag " + tag);
                    return false;
                }
                nd.removeTag(tag);
                this.updateViewData(nd);
            }
            catch (Exception ee) {
                IJError.print(ee);
            }
        }
        return true;
    }

    public Bureaucrat removeReviews() {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Removing review stacks"){

            @Override
            public void exec() {
                boolean success = true;
                for (Map.Entry e : Tree.this.node_layer_map.entrySet()) {
                    for (Node nd : e.getValue()) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        success = success && Tree.this.removeReview(nd);
                    }
                }
                File f = new File(Tree.this.getProject().getLoader().getUNUIdFolder() + "tree.review.stacks/" + Tree.this.getId());
                if (success) {
                    Utils.removeFile(f);
                } else {
                    Utils.log("Could not delete some review stacks.\n --> Directory remains: " + f.getAbsolutePath());
                }
                Display.repaint(Tree.this.getLayerSet());
            }
        }, this.getProject());
    }

    public Map<Node<T>, Collection<Displayable>> findIntersecting(final Class<?> c) throws Exception {
        final HashMap<Node<T>, Collection<Displayable>> m = new HashMap<Node<T>, Collection<Displayable>>();
        Process.progressive(this.root.getSubtreeNodes(), new TaskFactory<Node<T>, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object process(Node<T> nd) {
                Area a = nd.getArea();
                a.transform(Tree.this.at);
                ArrayList<Displayable> col = Tree.this.layer_set.find(c, nd.la, a, false, true);
                if (col.isEmpty()) {
                    return null;
                }
                HashMap hashMap = m;
                synchronized (hashMap) {
                    m.put(nd, col);
                }
                return null;
            }
        });
        return m;
    }

    public List<Connector>[] findConnectors() throws Exception {
        final ArrayList outgoing = new ArrayList();
        final ArrayList incoming = new ArrayList();
        if (null != this.root) {
            Process.progressive(this.root.getSubtreeNodes(), new TaskFactory<Node<T>, Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object process(Node<T> nd) {
                    Area a = nd.getArea();
                    a.transform(Tree.this.at);
                    Collection<Displayable> col = Tree.this.layer_set.findZDisplayables(Connector.class, nd.la, a, false, false);
                    if (col.isEmpty()) {
                        return null;
                    }
                    for (Connector connector : col) {
                        ArrayList arrayList;
                        if (connector.intersectsOrigin(a, nd.la)) {
                            arrayList = outgoing;
                            synchronized (arrayList) {
                                outgoing.add(connector);
                                continue;
                            }
                        }
                        arrayList = incoming;
                        synchronized (arrayList) {
                            incoming.add(connector);
                        }
                    }
                    return null;
                }
            });
        }
        return new List[]{outgoing, incoming};
    }

    @Override
    public String getShortTitle() {
        String title = this.getTitle();
        if (null != title && !this.getClass().getSimpleName().toLowerCase().equals(title.toLowerCase())) {
            return title;
        }
        if (null == this.root) {
            return "Empty";
        }
        Point3f p = this.getOriginPoint(true);
        return "Root: x=" + p.x + (", y=" + p.y) + " z=" + p.z;
    }

    public Point3f getOriginPoint(boolean calibrated) {
        if (null == this.root) {
            return null;
        }
        return this.fix(this.root.asPoint(), calibrated, new float[2]);
    }

    public Point3f asPoint(Node<T> nd, boolean calibrated) {
        return this.fix(nd.asPoint(), calibrated, new float[2]);
    }

    protected Point3f fix(Point3f p, boolean calibrated, float[] f) {
        f[0] = p.x;
        f[1] = p.y;
        this.at.transform(f, 0, f, 0, 1);
        p.x = f[0];
        p.y = f[1];
        if (calibrated) {
            Calibration cal = this.layer_set.getCalibration();
            p.x = (float)((double)p.x * cal.pixelWidth);
            p.y = (float)((double)p.y * cal.pixelHeight);
            p.z = (float)((double)p.z * cal.pixelWidth);
        }
        return p;
    }

    public static <A extends Tree<?>> Map<Tree<?>, Tree<?>> duplicateAs(Collection<Displayable> col, Class<A> target) throws Exception {
        HashMap m = new HashMap();
        for (Displayable d : col) {
            Tree<?> copy;
            if (target.isInstance(d)) {
                Utils.log(d + " is already of class " + target.getSimpleName());
                continue;
            }
            if (!(d instanceof Tree)) {
                Utils.log("Ignoring " + d + ": not a Tree subclass");
                continue;
            }
            Tree src = (Tree)d;
            if (null == src.root) {
                Utils.log("Ignoring empty tree " + src);
                continue;
            }
            if (Treeline.class == target) {
                m.put(src, Tree.copyAs(src, Treeline.class, Treeline.RadiusNode.class));
            } else if (AreaTree.class == target) {
                m.put(src, Tree.copyAs(src, AreaTree.class, AreaTree.AreaNode.class));
            } else {
                Utils.log("Ignoring " + src);
            }
            if (null == (copy = m.get(src))) continue;
            src.layer_set.add(copy);
            if (null != src.project.getProjectTree().addSibling(src, copy)) continue;
            Utils.log("Could not add " + src.getClass().getSimpleName() + " as " + target.getSimpleName());
            m.remove(src);
            src.layer_set.remove(copy);
        }
        return m;
    }

    public static <A extends Tree<?>, B extends Node<?>> A copyAs(Tree<?> src, Class<A> tree_class, Class<B> node_class) throws Exception {
        String title = "copy of " + src.title + " #" + src.id;
        Tree t = (Tree)tree_class.getConstructor(Project.class, String.class).newInstance(src.project, title);
        t.at.setTransform(src.at);
        t.color = src.color;
        t.width = src.width;
        t.height = src.height;
        HashMap<Node, Node> rel = new HashMap<Node, Node>();
        LinkedList todo = new LinkedList();
        todo.add(src.root);
        while (!todo.isEmpty()) {
            Node a = (Node)todo.removeLast();
            if (null != a.children) {
                for (Node child : a.children) {
                    todo.add(child);
                }
            }
            Node copy = (Node)node_class.getConstructor(Float.TYPE, Float.TYPE, Layer.class).newInstance(Float.valueOf(a.x), Float.valueOf(a.y), a.la);
            copy.copyProperties(a);
            rel.put(a, copy);
            if (null == a.parent) {
                t.root = copy;
                continue;
            }
            ((Node)rel.get(a.parent)).add(copy, copy.confidence);
        }
        t.cacheSubtree(t.root.getSubtreeNodes());
        return (A)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<T> guiFindNode(float x, float y, Layer layer, double magnification) {
        Collection nodes;
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            nodes = this.node_layer_map.get(layer);
        }
        if (null == nodes) {
            Utils.log("No nodes in layer " + layer);
            return null;
        }
        Node<T> node = this.findClosestNodeW(nodes, x, y, magnification);
        if (null == node) {
            Utils.log("Could not find any node! Zoom in for better precision.");
        }
        return node;
    }

    public Bureaucrat generateReviewStackForSlab(float x, float y, Layer layer, double magnification) {
        return this.generateReviewStackForSlab(this.guiFindNode(x, y, layer, magnification));
    }

    public Bureaucrat generateSubtreeReviewStacks(int x, int y, Layer layer, double magnification) {
        return this.generateSubtreeReviewStacks(this.guiFindNode(x, y, layer, magnification));
    }

    public Bureaucrat generateReviewStackForSlab(final Node<T> node) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Create review stack"){

            @Override
            public void exec() {
                if (null == node) {
                    return;
                }
                Node first = node.findPreviousBranchOrRootPoint();
                Node last = node.findNextBranchOrEndPoint();
                Set<Tag> tags = last.getTags();
                String name = "#R-slab-1";
                if (null != tags && !tags.isEmpty()) {
                    ArrayList<Integer> a = new ArrayList<Integer>();
                    for (Tag t : tags) {
                        if (!t.toString().startsWith("#R-slab-")) continue;
                        a.add(Integer.parseInt(t.toString().substring(7)));
                    }
                    if (a.isEmpty()) {
                        name = name + 1;
                    } else {
                        Collections.sort(a);
                        name = name + ((Integer)a.get(a.size() - 1) + 1);
                    }
                }
                Tag tag = new Tag(name, 82);
                last.addTag(tag);
                String filepath = Tree.this.getReviewTagPath(tag);
                Utils.ensure(filepath);
                Tree.this.createReviewStack(first, last, tag, filepath, 512, 512, 1.0, 4);
            }
        }, this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultsTable measurePathDistance(Node<T> a, Node<T> b, ResultsTable rt) {
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            Set<Node<T>> nodes1 = this.node_layer_map.get(a.la);
            if (null == nodes1 || !nodes1.contains(a)) {
                Utils.log("Tree.measurePathDistance: node " + a + " does not belong to tree " + this);
                return rt;
            }
            Set<Node<T>> nodes2 = this.node_layer_map.get(b.la);
            if (null == nodes2 || !nodes2.contains(b)) {
                Utils.log("Tree.measurePathDistance: node " + b + " does not belong to tree " + this);
                return rt;
            }
            try {
                return new MeasurePathDistance<T>(this, a, b).show(rt);
            }
            catch (Exception e) {
                IJError.print(e);
                return rt;
            }
        }
    }

    public double measurePathDistance(Node<T> a, Node<T> b) throws Exception {
        return new MeasurePathDistance<T>(this, a, b).getDistance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tag> findTags() {
        HashSet<Tag> tags = new HashSet<Tag>();
        Map<Layer, Set<Node<T>>> map = this.node_layer_map;
        synchronized (map) {
            for (Set<Node<T>> nodes : this.node_layer_map.values()) {
                for (Node<T> node : nodes) {
                    Set<Tag> t = node.getTags();
                    if (null == t) continue;
                    tags.addAll(t);
                }
            }
        }
        return tags;
    }

    @Override
    public void destroy() {
        super.destroy();
        TreeConnectorsView.dispose(this);
    }

    public HashMap<Node<T>, Integer> computeAllDegrees() {
        if (null == this.root) {
            return new HashMap<Node<T>, Integer>();
        }
        return this.root.computeAllDegrees();
    }

    public Collection<Node<T>> getBranchNodes() {
        if (null == this.root) {
            return new ArrayList<Node<T>>();
        }
        return this.root.getBranchNodes();
    }

    public Collection<Node<T>> getBranchAndEndNodes() {
        if (null == this.root) {
            return new ArrayList<Node<T>>();
        }
        return this.root.getBranchAndEndNodes();
    }

    private static final <T> Collection<Vertex<Node<T>>> findNeighbors(Node<T> node, HashMap<Node<T>, Vertex<Node<T>>> m) {
        Node<T> parent = node.getParent();
        ArrayList<Vertex<Node<T>>> neighbors = new ArrayList<Vertex<Node<T>>>();
        if (null != parent) {
            neighbors.add(m.get(parent));
        }
        for (Node<T> child : node.getChildrenNodes()) {
            neighbors.add(m.get(child));
        }
        return neighbors;
    }

    public HashMap<Node<T>, Vertex<Node<T>>> asVertices() {
        HashMap<Node<T>, Vertex<Node<T>>> m = new HashMap<Node<T>, Vertex<Node<T>>>();
        if (null == this.root) {
            return m;
        }
        for (Node<T> node : this.getRoot().getSubtreeNodes()) {
            m.put(node, new Vertex<Node<T>>(node));
        }
        for (Map.Entry entry : m.entrySet()) {
            ((Vertex)entry.getValue()).neighbors.addAll(Tree.findNeighbors((Node)entry.getKey(), m));
        }
        return m;
    }

    public HashMap<Node<T>, Float> computeCentrality() {
        HashMap<Node<T>, Float> cs = new HashMap<Node<T>, Float>();
        if (null == this.root) {
            return cs;
        }
        HashMap<Node<T>, Vertex<Node<T>>> m = this.asVertices();
        Centrality.compute(m.values());
        for (Map.Entry<Node<T>, Vertex<Node<T>>> e : m.entrySet()) {
            cs.put(e.getKey(), Float.valueOf(e.getValue().centrality));
        }
        return cs;
    }

    public void colorizeByNodeBetweennessCentrality() {
        if (null == this.root) {
            return;
        }
        HashMap<Node<T>, Vertex<Node<T>>> m = this.asVertices();
        Centrality.compute(m.values());
        IndexColorModel cm = Utils.fireLUT();
        HashMap<Integer, Color> colors = new HashMap<Integer, Color>();
        double max = 0.0;
        for (Vertex<Node<T>> vertex : m.values()) {
            max = Math.max(max, (double)vertex.centrality);
        }
        for (Map.Entry entry : m.entrySet()) {
            int i = (int)(255.0 * ((double)((Vertex)entry.getValue()).centrality / max) + 0.5);
            Color c = (Color)colors.get(i);
            if (null == c) {
                c = new Color(cm.getRed(i), cm.getGreen(i), cm.getBlue(i));
                colors.put(i, c);
            }
            ((Node)entry.getKey()).setColor(c);
        }
    }

    public void colorizeByBranchBetweennessCentrality(int etching_multiplier) {
        if (null == this.root) {
            return;
        }
        Collection vs = this.asVertices().values();
        Centrality.branchWise(vs, etching_multiplier);
        IndexColorModel cm = Utils.fireLUT();
        HashMap<Integer, Color> colors = new HashMap<Integer, Color>();
        double max = 0.0;
        for (Vertex v : vs) {
            max = Math.max(max, (double)v.centrality);
        }
        if (0.0 == max) {
            Utils.logAll("Branch centrality: all have zero!");
            return;
        }
        for (Vertex v : vs) {
            int i = (int)(255.0 * ((double)v.centrality / max) + 0.5);
            Utils.log("branch centrality: " + v.centrality + " , i: " + i);
            Color c = (Color)colors.get(i);
            if (null == c) {
                c = new Color(cm.getRed(i), cm.getGreen(i), cm.getBlue(i));
                colors.put(i, c);
            }
            ((Node)v.data).setColor(c);
        }
    }

    protected abstract MeasurementPair createMeasurementPair(NodePath var1);

    public List<NodePath> findTaggedPairs(Tag upstream, Tag downstream) {
        ArrayList<NodePath> pairs = new ArrayList<NodePath>();
        if (null == this.root) {
            return pairs;
        }
        for (Node<T> nd : this.root.getSubtreeNodes()) {
            if (!nd.hasTag(downstream)) continue;
            ArrayList path = new ArrayList();
            path.add(nd);
            Node<T> parent = nd.getParent();
            while (!parent.hasTag(upstream)) {
                path.add(parent);
                if (null != (parent = parent.getParent())) continue;
            }
            if (null == parent) continue;
            path.add(parent);
            Collections.reverse(path);
            pairs.add(new NodePath(parent, nd, path));
        }
        return pairs;
    }

    public List<MeasurementPair> measureTaggedPairs(Tag upstream, Tag downstream) {
        ArrayList<MeasurementPair> pairs = new ArrayList<MeasurementPair>();
        for (NodePath np : this.findTaggedPairs(upstream, downstream)) {
            pairs.add(this.createMeasurementPair(np));
        }
        return pairs;
    }

    public void dropAllTags() {
        if (null == this.root) {
            return;
        }
        for (Node<T> nd : this.root.getSubtreeNodes()) {
            nd.removeAllTags();
        }
    }

    static {
        to_tag = null;
        to_untag = null;
        show_tag_dialogs = false;
    }

    public abstract class MeasurementPair
    extends NodePath {
        public final double distance;
        public final List<T> data;
        public final List<Point3f> coords;

        public MeasurementPair(NodePath np) {
            this(np.a, np.b, np.path);
        }

        public MeasurementPair(Node<T> a, Node<T> b, List<Node<T>> path) {
            super(a, b, path);
            this.distance = new MeasurePathDistance(Tree.this, a, b, path).getDistance();
            this.data = this.calibratedData();
            this.coords = new ArrayList<Point3f>();
            AffineTransform aff = this.toCalibration();
            float[] fp = new float[2];
            for (Node nd : path) {
                fp[0] = nd.x;
                fp[1] = nd.y;
                aff.transform(fp, 0, fp, 0, 1);
                this.coords.add(new Point3f(fp[0], fp[1], (float)nd.getLayer().getCalibratedZ()));
            }
        }

        protected abstract List<T> calibratedData();

        public abstract ResultsTable toResultsTable(ResultsTable var1, int var2, double var3, int var5);

        public abstract MeshData createMesh(double var1, int var3);

        public abstract String getResultsTableTitle();

        @Override
        public double measureDistance() {
            return this.distance;
        }

        @Override
        public List<T> getData() {
            return this.data;
        }

        protected final AffineTransform toCalibration() {
            AffineTransform aff = new AffineTransform(Tree.this.at);
            Calibration cal = Tree.this.layer_set.getCalibration();
            aff.preConcatenate(new AffineTransform(cal.pixelWidth, 0.0, 0.0, cal.pixelHeight, 0.0, 0.0));
            return aff;
        }
    }

    public class NodePath
    extends Pair {
        protected final List<Node<T>> path;

        public NodePath(Node<T> a, Node<T> b) {
            this(a, b, Node.findPath(a, b));
        }

        public NodePath(Node<T> a, Node<T> b, List<Node<T>> path) {
            super(a, b);
            this.path = path;
        }

        public List<Node<T>> getPath() {
            return this.path;
        }
    }

    public class Pair {
        public Node<T> a;
        public Node<T> b;

        public Pair(Node<T> a, Node<T> b) {
            this.a = a;
            this.b = b;
        }

        public double measureDistance() throws Exception {
            return new MeasurePathDistance(Tree.this, this.a, this.b).getDistance();
        }

        private List<T> getData(List<Node<T>> path) {
            ArrayList d = new ArrayList();
            for (Node nd : path) {
                d.add(nd.getData());
            }
            return d;
        }

        public List<T> getData() {
            return this.getData(Node.findPath(this.a, this.b));
        }
    }

    public static final class MeasurePathDistance<I> {
        private double dist = 0.0;
        private int branch_points = 0;
        private final float[] fpA = new float[2];
        private final float[] fpB = new float[2];
        private final float firstx;
        private final float firsty;
        private final List<Node<I>> path;
        private final Calibration cal;
        private final Tree<I> tree;
        private final Node<I> a;
        private final Node<I> b;

        public double getDistance() {
            return this.dist;
        }

        public List<Node<I>> getPath() {
            return this.path;
        }

        public int getBranchNodesInPath() {
            return this.branch_points;
        }

        public Point3f getFirstNodeCoordinates() {
            return new Point3f(this.firstx, this.firsty, (float)(this.path.get((int)0).la.getZ() * this.cal.pixelWidth));
        }

        public Point3f getLastNodeCoordinates() {
            if (1 == this.path.size()) {
                return this.getFirstNodeCoordinates();
            }
            return new Point3f(this.fpB[0], this.fpB[1], (float)(this.path.get((int)(this.path.size() - 1)).la.getZ() * this.cal.pixelWidth));
        }

        public MeasurePathDistance(Tree<I> tree, Node<I> a, Node<I> b) {
            this(tree, a, b, Node.findPath(a, b));
        }

        private MeasurePathDistance(Tree<I> tree, Node<I> a, Node<I> b, List<Node<I>> path) {
            this.path = path;
            this.cal = tree.layer_set.getCalibrationCopy();
            this.tree = tree;
            this.a = a;
            this.b = b;
            Iterator<Node<I>> it = path.iterator();
            Node<I> first = it.next();
            if (first.getChildrenCount() > 1) {
                ++this.branch_points;
            }
            this.fpA[0] = first.x;
            this.fpA[1] = first.y;
            tree.at.transform(this.fpA, 0, this.fpA, 0, 1);
            double zA = first.la.getZ();
            this.firstx = this.fpA[0];
            this.firsty = this.fpA[1];
            if (1 == path.size()) {
                this.fpB[0] = this.fpA[0];
                this.fpB[1] = this.fpA[1];
            }
            while (it.hasNext()) {
                Node<I> second = it.next();
                if (second.getChildrenCount() > 1) {
                    ++this.branch_points;
                }
                this.fpB[0] = second.x;
                this.fpB[1] = second.y;
                tree.at.transform(this.fpB, 0, this.fpB, 0, 1);
                double zB = second.la.getZ();
                this.dist += Math.sqrt(Math.pow((double)(this.fpB[0] - this.fpA[0]) * this.cal.pixelWidth, 2.0) + Math.pow((double)(this.fpB[1] - this.fpA[1]) * this.cal.pixelHeight, 2.0) + Math.pow((zB - zA) * this.cal.pixelWidth, 2.0));
                first = second;
                this.fpA[0] = this.fpB[0];
                this.fpA[1] = this.fpB[1];
                zA = zB;
            }
        }

        public ResultsTable show(ResultsTable rt) {
            if (null == rt) {
                rt = Utils.createResultsTable("Tree path measurements", new String[]{"id", "XA", "YA", "Layer A", "XB", "YB", "Layer B", "distance", "N nodes", "N branch points"});
            }
            rt.incrementCounter();
            rt.addLabel("units", this.cal.getUnit());
            rt.addValue(0, (double)((Tree)this.tree).id);
            rt.addValue(1, (double)this.firstx);
            rt.addValue(2, (double)this.firsty);
            rt.addValue(3, (double)(this.tree.layer_set.indexOf(this.a.la) + 1));
            rt.addValue(4, (double)this.fpB[0]);
            rt.addValue(5, (double)this.fpB[1]);
            rt.addValue(6, (double)(this.tree.layer_set.indexOf(this.b.la) + 1));
            rt.addValue(7, this.dist);
            rt.addValue(8, (double)this.path.size());
            rt.addValue(9, (double)this.branch_points);
            return rt;
        }
    }

    public static class MeshData {
        public final List<Color3f> colors;
        public final List<Point3f> verts;

        public MeshData(List<Point3f> v, List<Color3f> c) {
            this.verts = v;
            this.colors = c;
        }
    }

    private class NodeTableModel
    extends AbstractTableModel {
        List<Node<T>> nodes;
        final HashMap<Node<T>, NodeData> nodedata;

        private NodeTableModel(List<Node<T>> nodes, HashMap<Node<T>, NodeData> nodedata) {
            this.nodes = nodes;
            this.nodedata = nodedata;
        }

        private String getDataName() {
            if (this.nodes.isEmpty()) {
                return "Data";
            }
            if (this.nodes.get(0) instanceof Treeline.RadiusNode) {
                return "Radius";
            }
            if (this.nodes.get(0) instanceof AreaTree.AreaNode) {
                return "Area";
            }
            return "Data";
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "X";
                }
                case 2: {
                    return "Y";
                }
                case 3: {
                    return "Z";
                }
                case 4: {
                    return "Layer";
                }
                case 5: {
                    return "Edge confidence";
                }
                case 6: {
                    return this.getDataName();
                }
                case 7: {
                    return "Tags";
                }
                case 8: {
                    return "Reviews";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.nodes.size();
        }

        @Override
        public int getColumnCount() {
            return 9;
        }

        public Object getRawValueAt(int row, int col) {
            if (0 == this.nodes.size()) {
                return null;
            }
            Node nd = this.nodes.get(row);
            switch (col) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return this.getNodeData(nd).x;
                }
                case 2: {
                    return this.getNodeData(nd).y;
                }
                case 3: {
                    return this.getNodeData(nd).z;
                }
                case 4: {
                    return nd.la.getParent().indexOf(nd.la) + 1;
                }
                case 5: {
                    return this.getNodeData(nd).conf;
                }
                case 6: {
                    return this.getNodeData(nd).data;
                }
                case 7: {
                    return this.getNodeData(nd).tags;
                }
                case 8: {
                    return this.getNodeData(nd).reviews;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object o = this.getRawValueAt(row, col);
            return o instanceof Double ? Utils.cutNumber((Double)o, 1) : o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NodeData getNodeData(Node<T> nd) {
            HashMap hashMap = this.nodedata;
            synchronized (hashMap) {
                NodeData ndat = this.nodedata.get(nd);
                if (null == ndat) {
                    ndat = new NodeData(nd);
                    this.nodedata.put(nd, ndat);
                }
                return ndat;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        public void sortByColumn(final int col, final boolean descending) {
            final ArrayList nodes = new ArrayList(this.nodes);
            Collections.sort(nodes, new Comparator<Node<T>>(){

                @Override
                public int compare(Node<T> nd1, Node<T> nd2) {
                    if (descending) {
                        Node tmp = nd1;
                        nd1 = nd2;
                        nd2 = tmp;
                    }
                    Object val1 = NodeTableModel.this.getRawValueAt(nodes.indexOf(nd1), col);
                    Object val2 = NodeTableModel.this.getRawValueAt(nodes.indexOf(nd2), col);
                    if (col > 6) {
                        val1 = NodeTableModel.this.fixStrings(val1);
                        val2 = NodeTableModel.this.fixStrings(val2);
                    }
                    return ((Comparable)val1).compareTo((Comparable)val2);
                }
            });
            this.nodes = nodes;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
        }

        private final Object fixStrings(Object val) {
            if (val.getClass() == String.class) {
                if (0 == ((String)val).length()) {
                    return "zzzzzz";
                }
                return ((String)val).toLowerCase();
            }
            return val;
        }
    }

    private final class NodeData {
        final double x;
        final double y;
        final double z;
        final String data;
        final String tags;
        final String conf;
        final String reviews;

        NodeData(Node<T> nd) {
            float[] fp = new float[]{nd.x, nd.y};
            Tree.this.at.transform(fp, 0, fp, 0, 1);
            Calibration cal = Tree.this.layer_set.getCalibration();
            this.x = (double)fp[0] * cal.pixelHeight;
            this.y = (double)fp[1] * cal.pixelWidth;
            this.z = nd.la.getZ() * cal.pixelWidth;
            this.data = nd.getClass() == AreaTree.AreaNode.class ? Utils.cutNumber(Math.abs(AreaCalculations.area((PathIterator)((AreaTree.AreaNode)nd).getData().getPathIterator(null))) * cal.pixelWidth * cal.pixelHeight, 1) + ' ' + cal.getUnits() + '^' + 2 : Utils.cutNumber(((Treeline.RadiusNode)nd).getData().floatValue(), 1) + ' ' + cal.getUnits();
            this.conf = null == nd.parent ? "root" : Byte.toString(nd.parent.getEdgeConfidence(nd));
            Set<Tag> ts = nd.getTags();
            if (null != ts) {
                StringBuilder sb = new StringBuilder();
                StringBuilder sbr = new StringBuilder();
                for (Tag t : ts) {
                    String s = t.toString();
                    if ('#' == s.charAt(0) && 'R' == s.charAt(1)) {
                        sbr.append(s).append(", ");
                        continue;
                    }
                    sb.append(s).append(", ");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 2);
                }
                if (sbr.length() > 0) {
                    sbr.setLength(sbr.length() - 2);
                }
                this.tags = sb.toString();
                this.reviews = sbr.toString();
            } else {
                this.reviews = "";
                this.tags = "";
            }
        }
    }

    private class TreeNodesDataView {
        private JFrame frame;
        private List<Node<T>> allnodes;
        private List<Node<T>> searchnodes;
        private ini.trakem2.display.Tree$TreeNodesDataView.Table table_branchnodes = new Table();
        private ini.trakem2.display.Tree$TreeNodesDataView.Table table_endnodes = new Table();
        private ini.trakem2.display.Tree$TreeNodesDataView.Table table_allnodes = new Table();
        private ini.trakem2.display.Tree$TreeNodesDataView.Table table_searchnodes = new Table();
        private NodeTableModel model_branchnodes;
        private NodeTableModel model_endnodes;
        private NodeTableModel model_allnodes;
        private NodeTableModel model_searchnodes;
        private final HashMap<Node<T>, NodeData> nodedata = new HashMap();
        private final HashSet<Node<T>> visited_reviews = new HashSet();

        TreeNodesDataView(Node<T> root) {
            this.create(root);
            this.createGUI();
        }

        void show() {
            this.frame.pack();
            this.frame.setVisible(true);
            this.frame.toFront();
        }

        private void createGUI() {
            this.frame = new JFrame("Nodes for " + Tree.this);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    Tree.this.tndv = null;
                }
            });
            JTabbedPane tabs = new JTabbedPane();
            tabs.setPreferredSize(new Dimension(500, 500));
            tabs.add("All nodes", new JScrollPane((Component)this.table_allnodes));
            tabs.add("Branch nodes", new JScrollPane((Component)this.table_branchnodes));
            tabs.add("End nodes", new JScrollPane((Component)this.table_endnodes));
            final JTextField search = new JTextField(14);
            search.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 10) {
                        TreeNodesDataView.this.search(search.getText());
                    }
                }
            });
            JButton b = new JButton("Search");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeNodesDataView.this.search(search.getText());
                }
            });
            JPanel pane = new JPanel();
            GridBagLayout gb = new GridBagLayout();
            pane.setLayout(gb);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.gridwidth = 1;
            c.anchor = 11;
            c.fill = 1;
            c.insets = new Insets(4, 10, 5, 2);
            gb.setConstraints(search, c);
            pane.add(search);
            c.gridx = 1;
            c.weightx = 0.0;
            c.fill = 0;
            c.insets = new Insets(4, 0, 5, 10);
            gb.setConstraints(b, c);
            pane.add(b);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.weighty = 1.0;
            c.fill = 1;
            JScrollPane scp = new JScrollPane((Component)this.table_searchnodes);
            c.insets = new Insets(0, 0, 0, 0);
            gb.setConstraints(scp, c);
            pane.add(scp);
            tabs.add("Search", pane);
            this.frame.getContentPane().add(tabs);
            this.frame.pack();
            GUI.center((Window)this.frame);
            this.frame.setVisible(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void create(Node<T> root) {
            ArrayList allnodes;
            ArrayList<Node> branchnodes = new ArrayList<Node>();
            ArrayList<Node> endnodes = new ArrayList<Node>();
            ArrayList searchnodes = new ArrayList();
            Map map = Tree.this.node_layer_map;
            synchronized (map) {
                allnodes = null == root ? new ArrayList() : new ArrayList(root.getSubtreeNodes());
            }
            block9: for (Node node : allnodes) {
                switch (node.getChildrenCount()) {
                    case 0: {
                        endnodes.add(node);
                        continue block9;
                    }
                    case 1: {
                        continue block9;
                    }
                }
                branchnodes.add(node);
            }
            this.visited_reviews.retainAll(allnodes);
            this.allnodes = allnodes;
            this.searchnodes = searchnodes;
            this.model_branchnodes = new NodeTableModel(branchnodes, this.nodedata);
            this.model_endnodes = new NodeTableModel(endnodes, this.nodedata);
            this.model_allnodes = new NodeTableModel(allnodes, this.nodedata);
            this.model_searchnodes = new NodeTableModel(searchnodes, this.nodedata);
            this.table_branchnodes.setModel(this.model_branchnodes);
            this.table_endnodes.setModel(this.model_endnodes);
            this.table_allnodes.setModel(this.model_allnodes);
            this.table_searchnodes.setModel(this.model_searchnodes);
            try {
                CustomCellRenderer ccr = new CustomCellRenderer();
                this.setCellRenderer((JTable)this.table_branchnodes, ccr);
                this.setCellRenderer((JTable)this.table_endnodes, ccr);
                this.setCellRenderer((JTable)this.table_allnodes, ccr);
                this.setCellRenderer((JTable)this.table_searchnodes, ccr);
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }

        void setCellRenderer(JTable t, DefaultTableCellRenderer ccr) {
            t.setDefaultRenderer(t.getColumnClass(8), ccr);
        }

        void recreate(final Node<T> root) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeNodesDataView.this.create(root);
                    TreeNodesDataView.this.table_branchnodes.resort();
                    TreeNodesDataView.this.table_searchnodes.resort();
                    TreeNodesDataView.this.table_endnodes.resort();
                    TreeNodesDataView.this.table_allnodes.resort();
                    Utils.revalidateComponent(TreeNodesDataView.this.frame);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateData(Node<?> node) {
            HashMap hashMap = this.nodedata;
            synchronized (hashMap) {
                this.nodedata.remove(node);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Utils.revalidateComponent(TreeNodesDataView.this.frame);
                }
            });
        }

        private void search(String regex) {
            StringBuilder sb = new StringBuilder();
            if (!regex.startsWith("^")) {
                sb.append("^.*");
            }
            sb.append(regex);
            if (!regex.endsWith("$")) {
                sb.append(".*$");
            }
            try {
                Pattern pat = Pattern.compile(sb.toString(), 42);
                this.searchnodes = new ArrayList();
                block2: for (Node nd : this.allnodes) {
                    Set<Tag> tags = nd.getTags();
                    if (null == tags) continue;
                    for (Tag tag : tags) {
                        if (!pat.matcher(tag.toString()).matches()) continue;
                        this.searchnodes.add(nd);
                        continue block2;
                    }
                }
                this.model_searchnodes = new NodeTableModel(this.searchnodes, this.nodedata);
                this.table_searchnodes.setModel(this.model_searchnodes);
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }

        private final class Table
        extends JTable {
            private int last_sorted_column = -1;
            private boolean last_sorting_order = true;

            Table() {
                this.getTableHeader().addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        if (2 != me.getClickCount()) {
                            return;
                        }
                        int viewColumn = Table.this.getColumnModel().getColumnIndexAtX(me.getX());
                        int column = Table.this.convertColumnIndexToModel(viewColumn);
                        if (-1 == column) {
                            return;
                        }
                        ((NodeTableModel)Table.this.getModel()).sortByColumn(column, me.isShiftDown());
                        Table.this.last_sorted_column = column;
                        Table.this.last_sorting_order = me.isShiftDown();
                    }
                });
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent me) {
                        final int row = Table.this.rowAtPoint(me.getPoint());
                        if (2 == me.getClickCount()) {
                            Table.this.go(row);
                        } else if (Utils.isPopupTrigger(me)) {
                            if (!Tree.this.project.isInputEnabled()) {
                                Utils.showMessage("Please wait until the current task completes!");
                                return;
                            }
                            JPopupMenu popup = new JPopupMenu();
                            final JMenuItem go = new JMenuItem("Go");
                            popup.add(go);
                            final JMenuItem review = new JMenuItem("Review");
                            popup.add(review);
                            review.setAccelerator(KeyStroke.getKeyStroke(82, 0, true));
                            final JMenuItem rm_review = new JMenuItem("Remove review stack");
                            popup.add(rm_review);
                            popup.addSeparator();
                            final JMenuItem generate = new JMenuItem("Generate all review stacks");
                            popup.add(generate);
                            final JMenuItem gsub = new JMenuItem("Generate review stacks for subtree");
                            popup.add(gsub);
                            final JMenuItem rm_reviews = new JMenuItem("Remove all reviews");
                            popup.add(rm_reviews);
                            popup.addSeparator();
                            final JMenuItem mark_as_reviewed = new JMenuItem("Mark selected as reviewed");
                            popup.add(mark_as_reviewed);
                            final JMenuItem clear_visited_reviews = new JMenuItem("Unmark all reviewed");
                            popup.add(clear_visited_reviews);
                            ActionListener listener = new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    Object src = ae.getSource();
                                    if (go == src) {
                                        Table.this.go(row);
                                    } else if (generate == src) {
                                        if (!Utils.check("Really generate all review stacks?")) {
                                            return;
                                        }
                                        Tree.this.generateSubtreeReviewStacks(Tree.this.root);
                                    } else if (gsub == src) {
                                        if (!Utils.check("Really generate review stacks for the subtree?")) {
                                            return;
                                        }
                                        Tree.this.generateSubtreeReviewStacks(((NodeTableModel)Table.this.getModel()).nodes.get(Table.this.getSelectedRow()));
                                    } else if (review == src) {
                                        Table.this.review(row);
                                    } else if (rm_reviews == src) {
                                        if (!Utils.check("Really remove all review tags and associated stacks?")) {
                                            return;
                                        }
                                        Tree.this.removeReviews();
                                        TreeNodesDataView.this.visited_reviews.clear();
                                    } else if (rm_review == src) {
                                        if (Utils.check("Really remove review stack for " + Table.this.getReviewTags(row))) {
                                            Table.this.removeReview(row);
                                        }
                                    } else if (clear_visited_reviews == src) {
                                        TreeNodesDataView.this.visited_reviews.clear();
                                        Table.this.repaint();
                                    } else if (mark_as_reviewed == src) {
                                        NodeTableModel m = (NodeTableModel)Table.this.getModel();
                                        for (int row2 : Table.this.getSelectedRows()) {
                                            Node nd = m.nodes.get(row2);
                                            if ("".equals(((NodeTableModel)m).getNodeData(nd).reviews)) continue;
                                            TreeNodesDataView.this.visited_reviews.add(nd);
                                        }
                                        Table.this.repaint();
                                    }
                                }
                            };
                            go.addActionListener(listener);
                            review.addActionListener(listener);
                            review.setEnabled(Table.this.hasReviewTag(row));
                            rm_review.addActionListener(listener);
                            rm_review.setEnabled(Table.this.hasReviewTag(row));
                            generate.addActionListener(listener);
                            rm_reviews.addActionListener(listener);
                            clear_visited_reviews.addActionListener(listener);
                            mark_as_reviewed.addActionListener(listener);
                            popup.show(Table.this, me.getX(), me.getY());
                        }
                    }
                });
                this.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent ke) {
                        int keyCode = ke.getKeyCode();
                        int row = Table.this.getSelectedRow();
                        if (keyCode == 71) {
                            if (-1 != row) {
                                Table.this.go(row);
                            }
                        } else if (keyCode == 82 && 0 == ke.getModifiers()) {
                            if (-1 != row) {
                                Table.this.review(row);
                            }
                        } else if (keyCode == 87 && 0 == (Utils.getControlModifier() ^ ke.getModifiers())) {
                            TreeNodesDataView.this.frame.dispose();
                        }
                    }
                });
            }

            String getReviewTags(int row) {
                Node nd = ((NodeTableModel)this.getModel()).nodes.get(row);
                Set<Tag> tags = nd.getTags();
                if (null == tags) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (Tag t : tags) {
                    if (!t.toString().startsWith("#R")) continue;
                    sb.append(t.toString()).append(", ");
                }
                if (0 == sb.length()) {
                    return null;
                }
                sb.setLength(sb.length() - 2);
                return sb.toString();
            }

            void go(int row) {
                Node node = ((NodeTableModel)this.getModel()).nodes.get(row);
                Tree.this.setLastVisited(node);
                Display.centerAt(Tree.this.createCoordinate(node));
            }

            void resort() {
                if (-1 != this.last_sorted_column) {
                    ((NodeTableModel)this.getModel()).sortByColumn(this.last_sorted_column, this.last_sorting_order);
                }
            }

            private boolean hasReviewTag(int row) {
                Node nd = ((NodeTableModel)this.getModel()).nodes.get(row);
                Set<Tag> tags = nd.getTags();
                if (null == tags) {
                    return false;
                }
                for (Tag tag : tags) {
                    if (!tag.toString().startsWith("#R-")) continue;
                    return true;
                }
                return false;
            }

            private void review(int row) {
                Node nd = ((NodeTableModel)this.getModel()).nodes.get(row);
                Set<Tag> tags = nd.getTags();
                if (null == tags) {
                    Utils.log("Node without review tag!");
                    return;
                }
                Tag review_tag = null;
                for (Tag tag : tags) {
                    if (!tag.toString().startsWith("#R-")) continue;
                    review_tag = tag;
                    break;
                }
                if (null == review_tag) {
                    Utils.log("Node without review tag!");
                    return;
                }
                TreeNodesDataView.this.visited_reviews.add(nd);
                Tree.this.openImage(Tree.this.getReviewTagPath(review_tag), nd);
                this.repaint();
            }

            private void removeReview(int row) {
                Node nd = ((NodeTableModel)this.getModel()).nodes.get(row);
                if (null == nd) {
                    return;
                }
                if (Tree.this.removeReview(nd)) {
                    TreeNodesDataView.this.visited_reviews.remove(nd);
                }
                Display.repaint(Tree.this.getLayerSet());
            }
        }

        private final class CustomCellRenderer
        extends DefaultTableCellRenderer {
            private CustomCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (8 == column && TreeNodesDataView.this.visited_reviews.contains(((NodeTableModel)table.getModel()).nodes.get(row))) {
                    c.setForeground(Color.white);
                    c.setBackground(Color.green);
                } else if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    c.setForeground(Color.black);
                    c.setBackground(Color.white);
                }
                return c;
            }
        }
    }

    private final class DPTree
    extends Displayable.DataPackage {
        final Node<T> root;

        DPTree(Tree<T> t) {
            super(t);
            this.root = null == t.root ? null : t.root.clone(t.project);
        }

        @Override
        final boolean to2(Displayable d) {
            super.to1(d);
            Tree t = (Tree)d;
            if (null != this.root) {
                t.root = this.root.clone(t.project);
                t.clearCache();
                t.cacheSubtree(t.root.getSubtreeNodes());
                t.updateView();
            }
            return true;
        }
    }
}

