/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import ini.trakem2.vector.SkinMaker;
import ini.trakem2.vector.VectorString2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mpicbg.models.CoordinateTransform;
import org.scijava.vecmath.Point3f;

public class Profile
extends Displayable
implements VectorData {
    protected int n_points;
    protected double[][] p = new double[2][5];
    protected double[][] p_l = new double[2][5];
    protected double[][] p_r = new double[2][5];
    protected double[][] p_i = new double[2][0];
    protected boolean closed = false;
    private static int index = -1;
    private static int index_l = -1;
    private static int index_r = -1;
    private static boolean is_new_point = false;

    public Profile(Project project, String title, double x, double y) {
        super(project, title, x, y);
        this.n_points = 0;
        this.addToDatabase();
    }

    public Profile(Project project, String title, double x, double y, Point2D.Double[] points) {
        super(project, title, x, y);
        int size = points.length / 3 + 1;
        this.p = new double[2][size];
        this.p_l = new double[2][size];
        this.p_r = new double[2][size];
        this.p[0][0] = points[0].x;
        this.p[1][0] = points[0].y;
        this.p_l[0][0] = this.p[0][0];
        this.p_l[1][0] = this.p[1][0];
        this.p_r[0][0] = points[1].x;
        this.p_r[1][0] = points[1].y;
        ++this.n_points;
        int j = 1;
        int i = 3;
        while (i < points.length - 3) {
            this.p[0][j] = points[i].x;
            this.p[1][j] = points[i].y;
            this.p_l[0][j] = points[i - 1].x;
            this.p_l[1][j] = points[i - 1].y;
            if (null == points[i + 1]) {
                Utils.log("BezierProfile: points[" + i + " + 1] is null !");
            }
            this.p_r[0][j] = points[i + 1].x;
            this.p_r[1][j] = points[i + 1].y;
            ++this.n_points;
            i += 3;
            ++j;
        }
        int last = points.length - 1;
        this.p[0][this.n_points] = points[last].x;
        this.p[1][this.n_points] = points[last].y;
        this.p_l[0][this.n_points] = points[last - 1].x;
        this.p_l[1][this.n_points] = points[last - 1].y;
        this.p_r[0][this.n_points] = this.p[0][this.n_points];
        this.p_r[1][this.n_points] = this.p[1][this.n_points];
        ++this.n_points;
        this.calculateBoundingBox();
        this.addToDatabase();
        this.updateInDatabase("points");
    }

    public Profile(Project project, long id, String title, float alpha, boolean visible, Color color, double[][][] bezarr, boolean closed, boolean locked, AffineTransform at) {
        super(project, id, title, locked, at, 0.0f, 0.0f);
        this.visible = visible;
        this.alpha = alpha;
        this.color = color;
        this.closed = closed;
        this.p_l = bezarr[0];
        this.p = bezarr[1];
        this.p_r = bezarr[2];
        this.n_points = this.p[0].length;
        this.calculateBoundingBox(false);
    }

    public Profile(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean closed, boolean locked, AffineTransform at) {
        super(project, id, title, locked, at, width, height);
        this.visible = visible;
        this.alpha = alpha;
        this.color = color;
        this.closed = closed;
        this.n_points = -1;
    }

    public Profile(Project project, long id, HashMap<String, String> ht, HashMap<Displayable, String> ht_links) {
        super(project, id, ht, ht_links);
        for (Map.Entry<String, String> entry : ht.entrySet()) {
            String key = entry.getKey();
            String data = entry.getValue();
            if (!key.equals("d")) continue;
            ArrayList<String> al_p = new ArrayList<String>();
            ArrayList<String> al_p_r = new ArrayList<String>();
            ArrayList<String> al_p_l = new ArrayList<String>();
            int i_start = data.indexOf(77);
            int i_end = data.indexOf(67);
            String point = data.substring(i_start + 1, i_end).trim();
            al_p.add(point);
            boolean go = true;
            while (go) {
                i_start = i_end;
                if (-1 == (i_end = data.indexOf(67, i_end + 1))) {
                    i_end = data.length() - 1;
                    go = false;
                }
                String txt = data.substring(i_start + 1, i_end).trim();
                while (-1 != txt.indexOf("  ")) {
                    txt = txt.replaceAll("  ", " ");
                }
                txt = txt.replaceAll(" ,", ",");
                String[] points = (txt = txt.replaceAll(", ", ",")).split(" ");
                if (3 == points.length) {
                    al_p_r.add(points[0]);
                    al_p_l.add(points[1]);
                    al_p.add(points[2]);
                    continue;
                }
                Utils.log("Profile constructor from XML: error at parsing points.");
            }
            if (this.closed) {
                al_p_l.add(0, (String)al_p_l.remove(al_p_l.size() - 1));
                al_p.remove(al_p.size() - 1);
            } else {
                al_p_l.add(0, (String)al_p.get(0));
                al_p_r.add((String)al_p.get(al_p.size() - 1));
            }
            if (al_p.size() != al_p_l.size() || al_p_l.size() != al_p_r.size()) {
                Utils.log2("Profile XML parsing: Disagreement in the number of points:\n\tp.length=" + al_p.size() + "\n\tp_l.length=" + al_p_l.size() + "\n\tp_r.length=" + al_p_r.size());
            }
            this.n_points = al_p.size();
            this.p = new double[2][this.n_points];
            this.p_l = new double[2][this.n_points];
            this.p_r = new double[2][this.n_points];
            for (int i = 0; i < this.n_points; ++i) {
                String[] sp = ((String)al_p.get(i)).split(",");
                this.p[0][i] = Double.parseDouble(sp[0]);
                this.p[1][i] = Double.parseDouble(sp[1]);
                sp = ((String)al_p_l.get(i)).split(",");
                this.p_l[0][i] = Double.parseDouble(sp[0]);
                this.p_l[1][i] = Double.parseDouble(sp[1]);
                sp = ((String)al_p_r.get(i)).split(",");
                this.p_r[0][i] = Double.parseDouble(sp[0]);
                this.p_r[1][i] = Double.parseDouble(sp[1]);
            }
            this.p_i = new double[2][0];
            this.generateInterpolatedPoints(0.05);
        }
    }

    private Profile(Project project, String title, double x, double y, float width, float height, float alpha, Color color, int n_points, double[][] p, double[][] p_r, double[][] p_l, double[][] p_i, boolean closed) {
        super(project, title, x, y);
        this.width = width;
        this.height = height;
        this.alpha = alpha;
        this.color = color;
        this.n_points = n_points;
        this.p = p;
        this.p_r = p_r;
        this.p_l = p_l;
        this.p_i = p_i;
        this.closed = closed;
        this.addToDatabase();
        this.updateInDatabase("all");
    }

    protected void enlargeArrays() {
        int length = this.p[0].length;
        double[][] p_copy = new double[2][length + 5];
        double[][] p_l_copy = new double[2][length + 5];
        double[][] p_r_copy = new double[2][length + 5];
        System.arraycopy(this.p[0], 0, p_copy[0], 0, length);
        System.arraycopy(this.p[1], 0, p_copy[1], 0, length);
        System.arraycopy(this.p_l[0], 0, p_l_copy[0], 0, length);
        System.arraycopy(this.p_l[1], 0, p_l_copy[1], 0, length);
        System.arraycopy(this.p_r[0], 0, p_r_copy[0], 0, length);
        System.arraycopy(this.p_r[1], 0, p_r_copy[1], 0, length);
        this.p = p_copy;
        this.p_l = p_l_copy;
        this.p_r = p_r_copy;
    }

    public int getPointCount() {
        return this.n_points;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected int findPoint(double[][] a, double x_p, double y_p, double magnification) {
        int index = -1;
        double d = 10.0 / magnification;
        if (d < 2.0) {
            d = 2.0;
        }
        for (int i = 0; i < this.n_points; ++i) {
            if (!(Math.abs(x_p - a[0][i]) + Math.abs(y_p - a[1][i]) <= d)) continue;
            index = i;
        }
        return index;
    }

    protected void removePoint(int index) {
        if (index < 0) {
            return;
        }
        if (this.n_points - 1 == index) {
            --this.n_points;
        } else {
            --this.n_points;
            for (int i = index; i < this.n_points; ++i) {
                this.p[0][i] = this.p[0][i + 1];
                this.p[1][i] = this.p[1][i + 1];
                this.p_l[0][i] = this.p_l[0][i + 1];
                this.p_l[1][i] = this.p_l[1][i + 1];
                this.p_r[0][i] = this.p_r[0][i + 1];
                this.p_r[1][i] = this.p_r[1][i + 1];
            }
        }
        if (this.closed && this.n_points < 2) {
            this.closed = false;
            this.updateInDatabase("closed");
        }
        this.updateInDatabase("points");
    }

    protected double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    protected void dragPoint(int index, int dx, int dy) {
        double[] dArray = this.p[0];
        int n = index;
        dArray[n] = dArray[n] + (double)dx;
        double[] dArray2 = this.p[1];
        int n2 = index;
        dArray2[n2] = dArray2[n2] + (double)dy;
        double[] dArray3 = this.p_l[0];
        int n3 = index;
        dArray3[n3] = dArray3[n3] + (double)dx;
        double[] dArray4 = this.p_l[1];
        int n4 = index;
        dArray4[n4] = dArray4[n4] + (double)dy;
        double[] dArray5 = this.p_r[0];
        int n5 = index;
        dArray5[n5] = dArray5[n5] + (double)dx;
        double[] dArray6 = this.p_r[1];
        int n6 = index;
        dArray6[n6] = dArray6[n6] + (double)dy;
    }

    protected void resetControlPoints(int index) {
        this.p_l[0][index] = this.p[0][index];
        this.p_l[1][index] = this.p[1][index];
        this.p_r[0][index] = this.p[0][index];
        this.p_r[1][index] = this.p[1][index];
    }

    protected void dragControlPoint(int index, double x_d, double y_d, double[][] p_dragged, double[][] p_adjusted, boolean symmetric) {
        double hypothenusa = symmetric ? this.distance(this.p[0][index], this.p[1][index], p_dragged[0][index], p_dragged[1][index]) : this.distance(this.p[0][index], this.p[1][index], p_adjusted[0][index], p_adjusted[1][index]);
        double angle = Math.atan2(p_dragged[0][index] - this.p[0][index], p_dragged[1][index] - this.p[1][index]) + Math.PI;
        p_dragged[0][index] = x_d;
        p_dragged[1][index] = y_d;
        p_adjusted[0][index] = this.p[0][index] + hypothenusa * Math.sin(angle);
        p_adjusted[1][index] = this.p[1][index] + hypothenusa * Math.cos(angle);
    }

    protected int addPoint(double x_p, double y_p, double magnification, double bezier_finess) {
        int index = this.findClosestPoint(x_p, y_p, magnification, bezier_finess);
        if (this.closed && -1 == index) {
            return -1;
        }
        if (this.p[0].length == this.n_points) {
            this.enlargeArrays();
        }
        if (0 == this.n_points || 1 == this.n_points || -1 == index || index + 1 == this.n_points) {
            double d = x_p;
            this.p_r[0][this.n_points] = d;
            this.p_l[0][this.n_points] = d;
            this.p[0][this.n_points] = d;
            double d2 = y_p;
            this.p_r[1][this.n_points] = d2;
            this.p_l[1][this.n_points] = d2;
            this.p[1][this.n_points] = d2;
            index = this.n_points;
        } else {
            int sh_length = this.n_points - ++index;
            double[][] p_copy = new double[2][sh_length];
            double[][] p_l_copy = new double[2][sh_length];
            double[][] p_r_copy = new double[2][sh_length];
            System.arraycopy(this.p[0], index, p_copy[0], 0, sh_length);
            System.arraycopy(this.p[1], index, p_copy[1], 0, sh_length);
            System.arraycopy(this.p_l[0], index, p_l_copy[0], 0, sh_length);
            System.arraycopy(this.p_l[1], index, p_l_copy[1], 0, sh_length);
            System.arraycopy(this.p_r[0], index, p_r_copy[0], 0, sh_length);
            System.arraycopy(this.p_r[1], index, p_r_copy[1], 0, sh_length);
            double d = x_p;
            this.p_r[0][index] = d;
            this.p_l[0][index] = d;
            this.p[0][index] = d;
            double d3 = y_p;
            this.p_r[1][index] = d3;
            this.p_l[1][index] = d3;
            this.p[1][index] = d3;
            System.arraycopy(p_copy[0], 0, this.p[0], index + 1, sh_length);
            System.arraycopy(p_copy[1], 0, this.p[1], index + 1, sh_length);
            System.arraycopy(p_l_copy[0], 0, this.p_l[0], index + 1, sh_length);
            System.arraycopy(p_l_copy[1], 0, this.p_l[1], index + 1, sh_length);
            System.arraycopy(p_r_copy[0], 0, this.p_r[0], index + 1, sh_length);
            System.arraycopy(p_r_copy[1], 0, this.p_r[1], index + 1, sh_length);
        }
        ++this.n_points;
        this.calculateBoundingBox();
        return index;
    }

    protected int findClosestPoint(double x_p, double y_p, double magnification, double bezier_finess) {
        if (0 == this.p_i[0].length) {
            return -1;
        }
        int index = -1;
        double distance_sq = Double.MAX_VALUE;
        double max = 12.0 / magnification;
        max *= max;
        for (int i = 0; i < this.p_i[0].length; ++i) {
            double distance_sq_i = (this.p_i[0][i] - x_p) * (this.p_i[0][i] - x_p) + (this.p_i[1][i] - y_p) * (this.p_i[1][i] - y_p);
            if (!(distance_sq_i < max) || !(distance_sq_i < distance_sq)) continue;
            index = i;
            distance_sq = distance_sq_i;
        }
        if (-1 != index) {
            int index_found = (int)((double)index * bezier_finess);
            if ((double)index < (double)index_found / bezier_finess) {
                --index_found;
            }
            index = index_found;
        }
        return index;
    }

    public void toggleClosed() {
        this.closed = !this.closed;
        this.updateInDatabase("closed");
    }

    protected void generateInterpolatedPoints(double bezier_finess) {
        if (0 >= this.n_points) {
            return;
        }
        int n = this.n_points;
        if (this.closed && n > 1) {
            ++n;
            if (this.p[0].length == this.n_points) {
                this.enlargeArrays();
            }
            this.p[0][this.n_points] = this.p[0][0];
            this.p[1][this.n_points] = this.p[1][0];
            this.p_l[0][this.n_points] = this.p_l[0][0];
            this.p_l[1][this.n_points] = this.p_l[1][0];
            this.p_r[0][this.n_points] = this.p_r[0][0];
            this.p_r[1][this.n_points] = this.p_r[1][0];
        }
        if (1 == this.n_points) {
            this.p_i = new double[2][1];
            this.p_i[0][0] = this.p[0][0];
            this.p_i[1][0] = this.p[1][0];
            return;
        }
        this.p_i = new double[2][(int)((double)n * (1.0 / bezier_finess))];
        int next = 0;
        for (int i = 0; i < n - 1; ++i) {
            for (double t = 0.0; t < 1.0; t += bezier_finess) {
                double f0 = (1.0 - t) * (1.0 - t) * (1.0 - t);
                double f1 = 3.0 * t * (1.0 - t) * (1.0 - t);
                double f2 = 3.0 * t * t * (1.0 - t);
                double f3 = t * t * t;
                this.p_i[0][next] = f0 * this.p[0][i] + f1 * this.p_r[0][i] + f2 * this.p_l[0][i + 1] + f3 * this.p[0][i + 1];
                this.p_i[1][next] = f0 * this.p[1][i] + f1 * this.p_r[1][i] + f2 * this.p_l[1][i + 1] + f3 * this.p[1][i + 1];
                if (this.p_i[0].length != ++next) continue;
                double[][] p_i_copy = new double[2][this.p_i[0].length + 5];
                System.arraycopy(this.p_i[0], 0, p_i_copy[0], 0, this.p_i[0].length);
                System.arraycopy(this.p_i[1], 0, p_i_copy[1], 0, this.p_i[1].length);
                this.p_i = p_i_copy;
            }
        }
        if (this.p_i[0].length != next) {
            double[][] p_i_copy = new double[2][next];
            System.arraycopy(this.p_i[0], 0, p_i_copy[0], 0, next);
            System.arraycopy(this.p_i[1], 0, p_i_copy[1], 0, next);
            this.p_i = p_i_copy;
        }
    }

    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        if (0 == this.n_points) {
            return;
        }
        if (-1 == this.n_points) {
            this.setupForDisplay();
            if (-1 == this.n_points) {
                Utils.log2("Profile.paint: Some error ocurred, can't load points from database.");
                return;
            }
        }
        Composite original_composite = null;
        if (this.alpha != 1.0f) {
            original_composite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, this.alpha));
        }
        double[][] p = this.p;
        double[][] p_r = this.p_r;
        double[][] p_l = this.p_l;
        double[][] p_i = this.p_i;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            p_l = (double[][])ob[1];
            p_r = (double[][])ob[2];
            p_i = (double[][])ob[3];
        }
        if (active) {
            int oval_radius = (int)Math.ceil(4.0 / magnification);
            int oval_corr = (int)Math.ceil(3.0 / magnification);
            for (int j = 0; j < this.n_points; ++j) {
                DisplayCanvas.drawHandle(g, (int)p[0][j], (int)p[1][j], magnification);
                g.setColor(this.color);
                g.fillOval((int)p_l[0][j] - oval_corr, (int)p_l[1][j] - oval_corr, oval_radius, oval_radius);
                g.fillOval((int)p_r[0][j] - oval_corr, (int)p_r[1][j] - oval_corr, oval_radius, oval_radius);
                g.drawLine((int)p[0][j], (int)p[1][j], (int)p_l[0][j], (int)p_l[1][j]);
                g.drawLine((int)p[0][j], (int)p[1][j], (int)p_r[0][j], (int)p_r[1][j]);
            }
        }
        g.setColor(this.color);
        for (int i = 0; i < p_i[0].length - 1; ++i) {
            g.drawLine((int)p_i[0][i], (int)p_i[1][i], (int)p_i[0][i + 1], (int)p_i[1][i + 1]);
        }
        if (this.closed) {
            g.drawLine((int)p_i[0][p_i[0].length - 1], (int)p_i[1][p_i[0].length - 1], (int)p_i[0][0], (int)p_i[1][0]);
        }
        if (null != original_composite) {
            g.setComposite(original_composite);
        }
    }

    @Override
    public void mousePressed(MouseEvent me, Layer layer, int x_p, int y_p, double mag) {
        if (!this.at.isIdentity()) {
            Point2D.Double po = this.inverseTransformPoint(x_p, y_p);
            x_p = (int)po.x;
            y_p = (int)po.y;
        }
        int tool = ProjectToolbar.getToolId();
        is_new_point = false;
        index_l = -1;
        index_r = -1;
        index = -1;
        if (16 == tool) {
            index = Utils.isControlDown(me) && me.isShiftDown() ? Profile.findNearestPoint(this.p, this.n_points, x_p, y_p) : this.findPoint(this.p, x_p, y_p, mag);
            if (-1 != index) {
                if (Utils.isControlDown(me) && me.isShiftDown()) {
                    this.removePoint(index);
                    index_l = -1;
                    index_r = -1;
                    index = -1;
                    this.generateInterpolatedPoints(0.05);
                    this.repaint(false);
                    return;
                }
                if (me.isAltDown()) {
                    this.resetControlPoints(index);
                    return;
                }
                if (me.isShiftDown() && 0 == index && this.n_points > 1 && !this.closed) {
                    this.closed = true;
                    this.updateInDatabase("closed");
                    this.p_l[0][0] = this.p[0][0];
                    this.p_l[1][0] = this.p[1][0];
                    index = -1;
                    index_r = -1;
                    index_l = 0;
                    this.repaint(false);
                    return;
                }
            }
            index_l = this.findPoint(this.p_l, x_p, y_p, mag);
            index_r = -1;
            if (-1 == index_l) {
                index_r = this.findPoint(this.p_r, x_p, y_p, mag);
            }
            if (-1 == index && -1 == index_l && -1 == index_r && !me.isShiftDown() && !me.isAltDown()) {
                index_l = this.addPoint(x_p, y_p, mag, 0.05);
                if (-1 != index_l) {
                    is_new_point = true;
                } else if (1 == this.n_points) {
                    index_r = index_l;
                    index_l = -1;
                }
                this.repaint(false);
                return;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        int tool;
        if (!this.at.isIdentity()) {
            Point2D.Double p = this.inverseTransformPoint(x_p, y_p);
            x_p = (int)p.x;
            y_p = (int)p.y;
            Point2D.Double pd = this.inverseTransformPoint(x_d, y_d);
            x_d = (int)pd.x;
            y_d = (int)pd.y;
            Point2D.Double pdo = this.inverseTransformPoint(x_d_old, y_d_old);
            x_d_old = (int)pdo.x;
            y_d_old = (int)pdo.y;
        }
        if (16 == (tool = ProjectToolbar.getToolId())) {
            if (-1 != index) {
                if (!me.isAltDown()) {
                    this.dragPoint(index, x_d - x_d_old, y_d - y_d_old);
                } else {
                    this.dragControlPoint(index, x_d, y_d, this.p_l, this.p_r, true);
                }
                this.generateInterpolatedPoints(0.05);
                this.repaint(false);
                return;
            }
            if (-1 != index_r) {
                this.dragControlPoint(index_r, x_d, y_d, this.p_r, this.p_l, is_new_point);
                this.generateInterpolatedPoints(0.05);
                this.repaint(false);
                return;
            }
            if (-1 != index_l) {
                this.dragControlPoint(index_l, x_d, y_d, this.p_l, this.p_r, is_new_point);
                this.generateInterpolatedPoints(0.05);
                this.repaint(false);
                return;
            }
            if (me.isAltDown()) {
                int dx = x_d - x_d_old;
                int dy = y_d - y_d_old;
                this.at.translate(dx, dy);
                this.repaint(false);
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        int tool = ProjectToolbar.getToolId();
        if (16 == tool) {
            this.generateInterpolatedPoints(0.05);
            this.repaint();
        }
        if (-1 != index || -1 != index_r || -1 != index_l) {
            this.updateInDatabase("points");
            this.updateInDatabase("transform+dimensions");
            Display.repaint(layer, this);
        } else if (x_r != x_p || y_r != y_p) {
            this.updateInDatabase("transform+dimensions");
            Display.repaint(layer, this);
        }
        is_new_point = false;
        index_l = -1;
        index_r = -1;
        index = -1;
    }

    protected void calculateBoundingBox() {
        this.calculateBoundingBox(true);
    }

    protected void calculateBoundingBox(boolean adjust_position) {
        int i;
        if (0 == this.n_points) {
            this.height = 0.0f;
            this.width = 0.0f;
            this.updateBucket();
            return;
        }
        double min_x = Double.MAX_VALUE;
        double min_y = Double.MAX_VALUE;
        double max_x = 0.0;
        double max_y = 0.0;
        for (i = 0; i < this.n_points; ++i) {
            if (this.p[0][i] < min_x) {
                min_x = this.p[0][i];
            }
            if (this.p_l[0][i] < min_x) {
                min_x = this.p_l[0][i];
            }
            if (this.p_r[0][i] < min_x) {
                min_x = this.p_r[0][i];
            }
            if (this.p[1][i] < min_y) {
                min_y = this.p[1][i];
            }
            if (this.p_l[1][i] < min_y) {
                min_y = this.p_l[1][i];
            }
            if (this.p_r[1][i] < min_y) {
                min_y = this.p_r[1][i];
            }
            if (this.p[0][i] > max_x) {
                max_x = this.p[0][i];
            }
            if (this.p_l[0][i] > max_x) {
                max_x = this.p_l[0][i];
            }
            if (this.p_r[0][i] > max_x) {
                max_x = this.p_r[0][i];
            }
            if (this.p[1][i] > max_y) {
                max_y = this.p[1][i];
            }
            if (this.p_l[1][i] > max_y) {
                max_y = this.p_l[1][i];
            }
            if (!(this.p_r[1][i] > max_y)) continue;
            max_y = this.p_r[1][i];
        }
        this.width = (float)(max_x - min_x);
        this.height = (float)(max_y - min_y);
        if (adjust_position) {
            i = 0;
            while (i < this.n_points) {
                double[] dArray = this.p[0];
                int n = i;
                dArray[n] = dArray[n] - min_x;
                double[] dArray2 = this.p[1];
                int n2 = i;
                dArray2[n2] = dArray2[n2] - min_y;
                double[] dArray3 = this.p_l[0];
                int n3 = i;
                dArray3[n3] = dArray3[n3] - min_x;
                double[] dArray4 = this.p_l[1];
                int n4 = i;
                dArray4[n4] = dArray4[n4] - min_y;
                double[] dArray5 = this.p_r[0];
                int n5 = i;
                dArray5[n5] = dArray5[n5] - min_x;
                double[] dArray6 = this.p_r[1];
                int n6 = i++;
                dArray6[n6] = dArray6[n6] - min_y;
            }
            i = 0;
            while (i < this.p_i[0].length) {
                double[] dArray = this.p_i[0];
                int n = i;
                dArray[n] = dArray[n] - min_x;
                double[] dArray7 = this.p_i[1];
                int n7 = i++;
                dArray7[n7] = dArray7[n7] - min_y;
            }
            this.at.translate(min_x, min_y);
            this.updateInDatabase("transform");
        }
        this.updateBucket();
        this.updateInDatabase("dimensions");
    }

    @Override
    public void repaint() {
        this.repaint(true);
    }

    public void repaint(boolean repaint_navigator) {
        Rectangle box = this.getBoundingBox(null);
        this.calculateBoundingBox();
        box.add(this.getBoundingBox(null));
        Display.repaint(this.layer, (Displayable)this, box, 5, repaint_navigator);
    }

    public boolean containsPoint(int x_p, int y_p) {
        int n_i = this.p_i[0].length;
        int[] intx = new int[n_i];
        int[] inty = new int[n_i];
        for (int i = 0; i < n_i; ++i) {
            intx[i] = (int)this.p_i[0][i];
            inty[i] = (int)this.p_i[1][i];
        }
        Polygon polygon = new Polygon(intx, inty, n_i);
        return polygon.contains(x_p, y_p);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.p = null;
        this.p_l = null;
        this.p_r = null;
        this.p_i = null;
    }

    private void setupForDisplay() {
        if (null == this.p || null == this.p_l || null == this.p_r) {
            double[][][] bezarr = this.project.getLoader().fetchBezierArrays(this.id);
            if (null == bezarr) {
                Utils.log("Profile.setupForDisplay: could not load the bezier points from the database for id=" + this.id);
                this.p_i = new double[0][0];
                return;
            }
            this.p_l = bezarr[0];
            this.p = bezarr[1];
            this.p_r = bezarr[2];
            this.n_points = this.p[0].length;
            this.generateInterpolatedPoints(0.05);
        }
    }

    public void cache() {
    }

    public void flush() {
        this.p = null;
        this.p_l = null;
        this.p_r = null;
        this.p_i = null;
        this.n_points = -1;
    }

    @Override
    public Polygon getPerimeter() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (null == this.p_i) {
            return null;
        }
        double[][] p_i = this.p_i;
        if (!this.at.isIdentity()) {
            p_i = this.transformPoints(this.p_i);
        }
        int n_i = p_i[0].length;
        int[] intx = new int[n_i];
        int[] inty = new int[n_i];
        for (int i = 0; i < n_i; ++i) {
            intx[i] = (int)p_i[0][i];
            inty[i] = (int)p_i[1][i];
        }
        return new Polygon(intx, inty, n_i);
    }

    public void toShapesFile(StringBuffer data, String group, String color, double z_scale) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        double[][] p = this.p;
        double[][] p_r = this.p_r;
        double[][] p_l = this.p_l;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            p_l = (double[][])ob[1];
            p_r = (double[][])ob[2];
        }
        double z = this.layer.getZ();
        int l = 10;
        data.append("type=bezier").append('\n').append("name=").append(this.project.getMeaningfulTitle(this)).append('\n').append("group=").append(group).append('\n').append("color=").append(color).append('\n').append("supergroup=").append("null").append('\n').append("supercolor=").append("null").append('\n').append("in slice=").append(z * z_scale).append('\n').append("curve_closed=").append(true).append('\n').append("density field=").append(false).append('\n');
        for (int i = 0; i < this.n_points; ++i) {
            data.append("p x=").append(p[0][i]).append('\n').append("p y=").append(p[1][i]).append('\n').append("p_r x=").append(p_r[0][i]).append('\n').append("p_r y=").append(p_r[1][i]).append('\n').append("p_l x=").append(p_l[0][i]).append('\n').append("p_l y=").append(p_l[1][i]).append('\n');
        }
    }

    @Override
    public void exportSVG(StringBuffer data, double z_scale, String indent) {
        String in = indent + "\t";
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return;
        }
        String[] RGB = Utils.getHexRGBColor(this.color);
        double[] a = new double[6];
        this.at.getMatrix(a);
        data.append(indent).append("<path\n").append(in).append("type=\"profile\"\n").append(in).append("id=\"").append(this.id).append("\"\n").append(in).append("transform=\"matrix(").append(a[0]).append(',').append(a[1]).append(',').append(a[2]).append(',').append(a[3]).append(',').append(a[4]).append(',').append(a[5]).append(")\"\n").append(in).append("style=\"fill:none;stroke-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";stroke-width:1.0px;\"\n").append(in).append("d=\"M");
        for (int i = 0; i < this.n_points - 1; ++i) {
            data.append(' ').append(this.p[0][i]).append(',').append(this.p[1][i]).append(" C ").append(this.p_r[0][i]).append(',').append(this.p_r[1][i]).append(' ').append(this.p_l[0][i + 1]).append(',').append(this.p_l[1][i + 1]);
        }
        data.append(' ').append(this.p[0][this.n_points - 1]).append(',').append(this.p[1][this.n_points - 1]);
        if (this.closed) {
            data.append(" C ").append(this.p_r[0][this.n_points - 1]).append(',').append(this.p_r[1][this.n_points - 1]).append(' ').append(this.p_l[0][0]).append(',').append(this.p_l[1][0]).append(' ').append(this.p[0][0]).append(',').append(this.p[1][0]).append(" z");
        }
        data.append("\"\n").append(in).append("z=\"").append(this.layer.getZ() * z_scale).append("\"\n").append(in).append("links=\"");
        if (null != this.hs_linked && 0 != this.hs_linked.size()) {
            int ii = 0;
            int len = this.hs_linked.size();
            for (Displayable d : this.hs_linked) {
                data.append(d.getId());
                if (ii != len - 1) {
                    data.append(',');
                }
                ++ii;
            }
        }
        data.append("\"\n").append(indent).append("/>\n");
    }

    public double[][][] getBezierArrays() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        double[][][] b = new double[3][2][];
        b[0][0] = Utils.copy(this.p_l[0], this.n_points);
        b[0][1] = Utils.copy(this.p_l[1], this.n_points);
        b[1][0] = Utils.copy(this.p[0], this.n_points);
        b[1][1] = Utils.copy(this.p[1], this.n_points);
        b[2][0] = Utils.copy(this.p_r[0], this.n_points);
        b[2][1] = Utils.copy(this.p_r[1], this.n_points);
        return b;
    }

    @Override
    public boolean isDeletable() {
        return 0 == this.n_points;
    }

    @Override
    public boolean isLinked() {
        if (null == this.hs_linked || this.hs_linked.isEmpty()) {
            return false;
        }
        for (Displayable d : this.hs_linked) {
            if (!(d instanceof Patch) || !d.layer.equals(this.layer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canSendTo(Layer target_layer) {
        if (null == this.hs_linked || this.hs_linked.isEmpty()) {
            return false;
        }
        for (Displayable d : this.hs_linked) {
            if (!(d instanceof Profile) || !d.layer.equals(target_layer)) continue;
            return false;
        }
        return true;
    }

    protected double[][] getFirstPoint() {
        if (0 == this.n_points) {
            return null;
        }
        return new double[][]{{this.p_l[0][0], this.p_l[1][0]}, {this.p[0][0], this.p[1][0]}, {this.p_r[0][0], this.p_r[1][0]}};
    }

    protected double[][] getLastPoint() {
        return new double[][]{{this.p_l[0][this.n_points - 1], this.p_l[1][this.n_points - 1]}, {this.p[0][this.n_points - 1], this.p[1][this.n_points - 1]}, {this.p_r[0][this.n_points - 1], this.p_r[1][this.n_points - 1]}};
    }

    public boolean hasPoints() {
        return 0 != this.n_points;
    }

    protected void setPoints(double[][] p_l, double[][] p, double[][] p_r) {
        this.p_l = p_l;
        this.p = p;
        this.p_r = p_r;
        this.n_points = p_l[0].length;
        this.generateInterpolatedPoints(0.05);
    }

    public void setPoints(double[][] p_l, double[][] p, double[][] p_r, boolean update) {
        this.setPoints(p_l, p, p_r);
        this.calculateBoundingBox();
        if (update) {
            this.updateInDatabase("points");
            this.repaint(true);
        }
    }

    protected void addPointsAtBegin(double[][] new_p_l, double[][] new_p, double[][] new_p_r) {
        int i;
        double[][] tmp_p_l = new double[2][this.p_l[0].length + new_p_l[0].length];
        double[][] tmp_p = new double[2][this.p[0].length + new_p[0].length];
        double[][] tmp_p_r = new double[2][this.p_r[0].length + new_p_r[0].length];
        for (i = 0; i < new_p_l[0].length; ++i) {
            tmp_p_l[0][i] = new_p_l[0][i];
            tmp_p_l[1][i] = new_p_l[1][i];
            tmp_p[0][i] = new_p[0][i];
            tmp_p[1][i] = new_p[1][i];
            tmp_p_r[0][i] = new_p_r[0][i];
            tmp_p_r[1][i] = new_p_r[1][i];
        }
        int j = 0;
        while (j < this.n_points) {
            tmp_p_l[0][i] = this.p_l[0][j];
            tmp_p_l[1][i] = this.p_l[1][j];
            tmp_p[0][i] = this.p[0][j];
            tmp_p[1][i] = this.p[1][j];
            tmp_p_r[0][i] = this.p_r[0][j];
            tmp_p_r[1][i] = this.p_r[1][j];
            ++j;
            ++i;
        }
        this.n_points += new_p_l[0].length;
        this.p_l = tmp_p_l;
        this.p = tmp_p;
        this.p_r = tmp_p_r;
        this.generateInterpolatedPoints(0.05);
    }

    protected void addPointsAtEnd(double[][] new_p_l, double[][] new_p, double[][] new_p_r) {
        int i;
        double[][] tmp_p_l = new double[2][this.p_l[0].length + new_p_l[0].length];
        double[][] tmp_p = new double[2][this.p[0].length + new_p[0].length];
        double[][] tmp_p_r = new double[2][this.p_r[0].length + new_p_r[0].length];
        for (i = 0; i < this.n_points; ++i) {
            tmp_p_l[0][i] = this.p_l[0][i];
            tmp_p_l[1][i] = this.p_l[1][i];
            tmp_p[0][i] = this.p[0][i];
            tmp_p[1][i] = this.p[1][i];
            tmp_p_r[0][i] = this.p_r[0][i];
            tmp_p_r[1][i] = this.p_r[1][i];
        }
        for (int j = 0; j < new_p_l[0].length; ++j) {
            tmp_p_l[0][i] = new_p_l[0][j];
            tmp_p_l[1][i] = new_p_l[1][j];
            tmp_p[0][i] = new_p[0][j];
            tmp_p[1][i] = new_p[1][j];
            tmp_p_r[0][i] = new_p_r[0][j];
            tmp_p_r[1][i] = new_p_r[1][j];
            ++i;
        }
        this.n_points += new_p_l[0].length;
        this.p_l = tmp_p_l;
        this.p = tmp_p;
        this.p_r = tmp_p_r;
        this.generateInterpolatedPoints(0.05);
    }

    public int getNearestPointIndex(double x_p, double y_p) {
        int ret = -1;
        double minDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.n_points; ++i) {
            double dx = this.p[0][i] - x_p;
            double dy = this.p[1][i] - y_p;
            double dist = dx * dx + dy * dy;
            if (!(dist < minDist)) continue;
            minDist = dist;
            ret = i;
        }
        return ret;
    }

    public void insertBetween(int startIndex, int endIndex, double[][] tmp_p_l, double[][] tmp_p, double[][] tmp_p_r) {
        int j;
        int i;
        int j2;
        int i2;
        double[][] ending_p_r;
        double[][] ending_p;
        double[][] ending_p_l;
        double[][] beginning_p_r;
        double[][] beginning_p;
        double[][] beginning_p_l;
        if (endIndex < startIndex) {
            for (int i3 = 0; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < tmp_p[0].length / 2; ++j3) {
                    double tmppl = tmp_p_l[i3][j3];
                    double tmpp = tmp_p[i3][j3];
                    double tmppr = tmp_p_r[i3][j3];
                    tmp_p_r[i3][j3] = tmp_p_l[i3][tmp_p_l[0].length - 1 - j3];
                    tmp_p[i3][j3] = tmp_p[i3][tmp_p[0].length - 1 - j3];
                    tmp_p_l[i3][j3] = tmp_p_r[i3][tmp_p_r[0].length - 1 - j3];
                    tmp_p_r[i3][tmp_p_l[0].length - 1 - j3] = tmppl;
                    tmp_p[i3][tmp_p[0].length - 1 - j3] = tmpp;
                    tmp_p_l[i3][tmp_p_r[0].length - 1 - j3] = tmppr;
                }
            }
            int tmp = startIndex;
            startIndex = endIndex;
            endIndex = tmp;
        }
        if (endIndex - startIndex < this.n_points + startIndex - endIndex || !this.closed) {
            beginning_p_l = new double[2][startIndex + 1];
            beginning_p = new double[2][startIndex + 1];
            beginning_p_r = new double[2][startIndex + 1];
            ending_p_l = new double[2][this.n_points - endIndex];
            ending_p = new double[2][this.n_points - endIndex];
            ending_p_r = new double[2][this.n_points - endIndex];
            for (i2 = 0; i2 <= startIndex; ++i2) {
                for (j2 = 0; j2 < 2; ++j2) {
                    beginning_p_l[j2][i2] = this.p_l[j2][i2];
                    beginning_p[j2][i2] = this.p[j2][i2];
                    beginning_p_r[j2][i2] = this.p_r[j2][i2];
                }
            }
            for (i2 = endIndex; i2 < this.n_points; ++i2) {
                for (j2 = 0; j2 < 2; ++j2) {
                    ending_p_l[j2][i2 - endIndex] = this.p_l[j2][i2];
                    ending_p[j2][i2 - endIndex] = this.p[j2][i2];
                    ending_p_r[j2][i2 - endIndex] = this.p_r[j2][i2];
                }
            }
            System.out.println("1");
        } else {
            beginning_p_l = new double[2][endIndex - startIndex + 1];
            beginning_p = new double[2][endIndex - startIndex + 1];
            beginning_p_r = new double[2][endIndex - startIndex + 1];
            ending_p_l = new double[2][0];
            ending_p = new double[2][0];
            ending_p_r = new double[2][0];
            for (i2 = startIndex; i2 <= endIndex; ++i2) {
                for (j2 = 0; j2 < 2; ++j2) {
                    beginning_p_r[j2][endIndex - i2] = this.p_l[j2][i2];
                    beginning_p[j2][endIndex - i2] = this.p[j2][i2];
                    beginning_p_l[j2][endIndex - i2] = this.p_r[j2][i2];
                }
            }
            System.out.println("2");
        }
        double[][] new_p_l = new double[2][beginning_p_l[0].length + ending_p_l[0].length + tmp_p_l[0].length];
        double[][] new_p = new double[2][beginning_p[0].length + ending_p[0].length + tmp_p[0].length];
        double[][] new_p_r = new double[2][beginning_p_r[0].length + ending_p_r[0].length + tmp_p_r[0].length];
        for (i = 0; i < beginning_p[0].length; ++i) {
            for (j = 0; j < 2; ++j) {
                new_p_l[j][i] = beginning_p_l[j][i];
                new_p[j][i] = beginning_p[j][i];
                new_p_r[j][i] = beginning_p_r[j][i];
            }
        }
        for (i = 0; i < tmp_p[0].length; ++i) {
            for (j = 0; j < 2; ++j) {
                new_p_l[j][i + beginning_p[0].length] = tmp_p_l[j][i];
                new_p[j][i + beginning_p[0].length] = tmp_p[j][i];
                new_p_r[j][i + beginning_p[0].length] = tmp_p_r[j][i];
            }
        }
        for (i = 0; i < ending_p[0].length; ++i) {
            for (j = 0; j < 2; ++j) {
                new_p_l[j][i + beginning_p[0].length + tmp_p[0].length] = ending_p_l[j][i];
                new_p[j][i + beginning_p[0].length + tmp_p[0].length] = ending_p[j][i];
                new_p_r[j][i + beginning_p[0].length + tmp_p[0].length] = ending_p_r[j][i];
            }
        }
        this.n_points = new_p[0].length;
        this.p_l = new_p_l;
        this.p = new_p;
        this.p_r = new_p_r;
        this.calculateBoundingBox();
        this.generateInterpolatedPoints(0.05);
    }

    public void printPoints() {
        System.out.println("#####\nw,h: " + this.width + "," + this.height);
        for (int i = 0; i < this.n_points; ++i) {
            System.out.println("x,y: " + this.p[0][i] + " , " + this.p[1][i]);
        }
        System.out.println("\n");
    }

    @Override
    public void snapTo(int cx, int cy, int x_p, int y_p) {
        if (-1 == index) {
            if (-1 != index_l) {
                this.p_l[0][Profile.index_l] = cx;
                this.p_l[1][Profile.index_l] = cy;
            } else if (-1 != index_r) {
                this.p_r[0][Profile.index_r] = cx;
                this.p_r[1][Profile.index_r] = cy;
            }
        }
    }

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        sb_body.append(indent).append("<t2_profile\n");
        String in = indent + "\t";
        super.exportXML(sb_body, in, options);
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        String[] RGB = Utils.getHexRGBColor(this.color);
        sb_body.append(in).append("style=\"fill:none;stroke-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";stroke-width:1.0px;\"\n");
        if (this.n_points > 0) {
            sb_body.append(in).append("d=\"M");
            for (int i = 0; i < this.n_points - 1; ++i) {
                sb_body.append(' ').append(this.p[0][i]).append(',').append(this.p[1][i]).append(" C ").append(this.p_r[0][i]).append(',').append(this.p_r[1][i]).append(' ').append(this.p_l[0][i + 1]).append(',').append(this.p_l[1][i + 1]);
            }
            sb_body.append(' ').append(this.p[0][this.n_points - 1]).append(',').append(this.p[1][this.n_points - 1]);
            if (this.closed) {
                sb_body.append(" C ").append(this.p_r[0][this.n_points - 1]).append(',').append(this.p_r[1][this.n_points - 1]).append(' ').append(this.p_l[0][0]).append(',').append(this.p_l[1][0]).append(' ').append(this.p[0][0]).append(',').append(this.p[1][0]).append(" z");
            }
            sb_body.append("\"\n");
        }
        sb_body.append(indent).append(">\n");
        super.restXML(sb_body, in, options);
        sb_body.append(indent).append("</t2_profile>\n");
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_profile";
        if (hs.contains("t2_profile")) {
            return;
        }
        hs.add("t2_profile");
        sb_header.append(indent).append("<!ELEMENT t2_profile (").append(Displayable.commonDTDChildren()).append(")>\n");
        Displayable.exportDTD("t2_profile", sb_header, hs, indent);
        sb_header.append(indent).append("<!ATTLIST ").append("t2_profile").append(" d").append(" NMTOKEN #REQUIRED>\n");
    }

    public VectorString2D getPerimeter2D() {
        return this.getPerimeter2D(this.layer.getParent().getCalibration());
    }

    private VectorString2D getPerimeter2D(Calibration cal) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return null;
        }
        if (0 == this.p_i[0].length) {
            this.generateInterpolatedPoints(0.05);
        }
        double[][] pi = this.transformPoints(this.p_i);
        VectorString2D sv = null;
        try {
            sv = new VectorString2D(pi[0], pi[1], this.layer.getZ(), this.closed);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        if (null != cal) {
            sv.calibrate(cal);
        }
        return sv;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        super.keyPressed(ke);
        if (ke.isConsumed()) {
            return;
        }
        int key_code = ke.getKeyCode();
        Rectangle box = null;
        switch (key_code) {
            case 88: {
                if (0 != ke.getModifiers() || ProjectToolbar.getToolId() != 16 && ProjectToolbar.getToolId() != 15) break;
                box = this.getBoundingBox(box);
                this.n_points = 0;
                this.p_i = new double[2][0];
                this.calculateBoundingBox(true);
                ke.consume();
                if (this.closed) {
                    this.toggleClosed();
                }
                this.updateInDatabase("points");
                break;
            }
            case 67: {
                if (0 != (ke.getModifiers() ^ 1) || this.n_points <= 1) break;
                this.toggleClosed();
                this.generateInterpolatedPoints(0.05);
                ke.consume();
            }
        }
        if (ke.isConsumed()) {
            Display.repaint(this.layer, box, 5);
        }
    }

    @Override
    public void setColor(Color c) {
        this.setColor(c, new HashSet<Profile>());
    }

    private void setColor(Color c, HashSet<Profile> hs_done) {
        if (hs_done.contains(this)) {
            return;
        }
        hs_done.add(this);
        super.setColor(c);
        HashSet<Displayable> hs = this.getLinked(Profile.class);
        if (null != hs) {
            for (Profile profile : hs) {
                profile.setColor(c, hs_done);
            }
        }
    }

    @Override
    public Displayable clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Profile copy = new Profile(pr, nid, null != this.title ? this.title.toString() : null, this.width, this.height, this.alpha, this.visible, new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()), this.closed, this.locked, (AffineTransform)this.at.clone());
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        copy.n_points = this.n_points;
        copy.p = new double[][]{(double[])this.p[0].clone(), (double[])this.p[1].clone()};
        copy.p_l = new double[][]{(double[])this.p_l[0].clone(), (double[])this.p_l[1].clone()};
        copy.p_r = new double[][]{(double[])this.p_r[0].clone(), (double[])this.p_r[1].clone()};
        copy.p_i = new double[][]{(double[])this.p_i[0].clone(), (double[])this.p_i[1].clone()};
        copy.addToDatabase();
        return copy;
    }

    private Object[] getTransformedData() {
        double[][] p = this.transformPoints(this.p);
        double[][] p_l = this.transformPoints(this.p_l);
        double[][] p_r = this.transformPoints(this.p_r);
        double[][] p_i = this.transformPoints(this.p_i);
        return new Object[]{p, p_l, p_r, p_i};
    }

    public static List<Point3f> generateTriangles(ProjectThing pt, double scale) {
        if (!pt.getType().equals("profile_list")) {
            Utils.log2("Profile: ignoring unhandable ProjectThing type.");
            return null;
        }
        ArrayList<ProjectThing> al = pt.getChildren();
        if (al.size() < 2) {
            Utils.log("profile_list " + pt + " has less than two profiles: can't render in 3D.");
            return null;
        }
        HashSet<Profile> hs = new HashSet<Profile>();
        for (ProjectThing child : al) {
            Object ob = child.getObject();
            if (ob instanceof Profile) {
                hs.add((Profile)ob);
                continue;
            }
            Utils.log2("Render: skipping non Profile class child");
        }
        Profile[] p = new Profile[hs.size()];
        hs.toArray(p);
        boolean hidden = true;
        for (int i = 0; i < p.length; ++i) {
            if (p[i].visible) {
                hidden = false;
                break;
            }
            if (null != p[i] && 0 != p[i].n_points) continue;
            Utils.log("Cannot generate triangle mesh: empty profile " + p[i] + (null != p[i] ? " at layer " + p[i].getLayer() : ""));
            return null;
        }
        if (hidden) {
            return null;
        }
        HashSet<Profile> hs_bases = new HashSet<Profile>();
        HashSet<Profile> hs_done = new HashSet<Profile>();
        ArrayList<Point3f> triangles = new ArrayList<Point3f>();
        do {
            Profile base = null;
            if (hs_bases.size() > 0) {
                base = (Profile)hs_bases.iterator().next();
            } else {
                double min_z = Double.MAX_VALUE;
                for (int i = 0; i < p.length; ++i) {
                    double z;
                    if (hs_done.contains(p[i]) || !((z = p[i].getLayer().getZ()) < min_z)) continue;
                    min_z = z;
                    base = p[i];
                }
                if (null != base) {
                    hs_bases.add(base);
                }
            }
            if (null == base) {
                Utils.log2("No more bases.");
                break;
            }
            ArrayList<Profile> al_profiles = new ArrayList<Profile>();
            al_profiles.add(base);
            Profile last = Profile.accumulate(hs_done, al_profiles, base, 0);
            if (last != base) {
                hs_done.addAll(al_profiles);
                hs_bases.add(last);
                Profile[] profiles = new Profile[al_profiles.size()];
                al_profiles.toArray(profiles);
                List<Point3f> tri = Profile.makeTriangles(profiles, scale);
                if (null == tri) continue;
                triangles.addAll(tri);
                continue;
            }
            hs_bases.remove(base);
        } while (0 != hs_bases.size());
        return triangles;
    }

    private static Profile accumulate(HashSet<Profile> hs_done, ArrayList<Profile> al, Profile step, int z_trend) {
        HashSet<Displayable> hs_linked = step.getLinked(Profile.class);
        if (al.size() > 1 && hs_linked.size() > 2) {
            return step;
        }
        double step_z = step.getLayer().getZ();
        Profile next_step = null;
        boolean started = false;
        for (Displayable ob : hs_linked) {
            if (al.contains(ob) || started || hs_done.contains(ob)) continue;
            started = true;
            next_step = (Profile)ob;
            double next_z = next_step.getLayer().getZ();
            if (0 == z_trend) {
                z_trend = next_z > step_z ? 1 : -1;
                al.add(next_step);
                continue;
            }
            if (next_z > step_z && 1 == z_trend || next_z < step_z && -1 == z_trend) {
                al.add(next_step);
                continue;
            }
            next_step = null;
        }
        Profile last = step;
        if (null != next_step) {
            hs_done.add(next_step);
            last = Profile.accumulate(hs_done, al, next_step, z_trend);
        }
        return last;
    }

    private static List<Point3f> makeTriangles(Profile[] p, double scale) {
        try {
            VectorString2D[] sv = new VectorString2D[p.length];
            boolean closed = true;
            Calibration cal = p[0].getLayerSet().getCalibrationCopy();
            cal.pixelWidth *= scale;
            cal.pixelHeight *= scale;
            for (int i = 0; i < p.length; ++i) {
                if (0 == p[i].n_points) continue;
                if (0 == i) {
                    closed = p[i].closed;
                } else if (p[i].closed != closed) {
                    Utils.log2("All profiles should be either open or closed, not mixed.");
                    return null;
                }
                sv[i] = p[i].getPerimeter2D(cal);
            }
            return SkinMaker.generateTriangles((VectorString2D[])sv, (int)-1, (double)-1.0, (boolean)closed);
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    @Override
    public boolean softRemove() {
        return true;
    }

    @Override
    protected boolean remove2(boolean check) {
        return this.project.getProjectTree().remove(check, this.project.findProjectThing(this), null);
    }

    public double computeLength() {
        if (-1 == this.n_points || 0 == this.p_i[0].length) {
            this.setupForDisplay();
        }
        if (this.p_i[0].length < 2) {
            return 0.0;
        }
        double[][] p_i = this.transformPoints(this.p_i);
        double len = 0.0;
        for (int i = 1; i < p_i[0].length; ++i) {
            len += Math.sqrt(Math.pow(p_i[0][i] - p_i[0][i - 1], 2.0) + Math.pow(p_i[1][i] - p_i[1][i - 1], 2.0));
        }
        if (this.closed) {
            int last = this.p[0].length - 1;
            len += Math.sqrt(Math.pow(p_i[0][last] - p_i[0][0], 2.0) + Math.pow(p_i[1][last] - p_i[1][0], 2.0));
        }
        return len * this.getLayerSet().getCalibration().pixelWidth;
    }

    public double computeArea() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (this.n_points < 2) {
            return 0.0;
        }
        if (!this.closed) {
            return 0.0;
        }
        if (0 == this.p_i[0].length) {
            this.generateInterpolatedPoints(0.05);
        }
        Calibration cal = this.getLayerSet().getCalibration();
        return M.measureArea(new Area(this.getPerimeter()), this.getProject().getLoader()) * cal.pixelWidth * cal.pixelHeight;
    }

    @Override
    public ResultsTable measure(ResultsTable rt) {
        if (null == rt) {
            rt = Utils.createResultsTable("Profile results", new String[]{"id", "length", "side surface: length x thickness", "volume: area x thickness", "name-id"});
        }
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (this.n_points < 2) {
            return null;
        }
        if (0 == this.p_i[0].length) {
            this.generateInterpolatedPoints(0.05);
        }
        Calibration cal = this.getLayerSet().getCalibration();
        double len = this.computeLength();
        double surface_flat = len * this.layer.getThickness() * cal.pixelWidth;
        rt.incrementCounter();
        rt.addLabel("units", cal.getUnit());
        rt.addValue(0, (double)this.id);
        rt.addValue(1, len);
        rt.addValue(2, surface_flat);
        double volume = this.closed ? this.computeArea() * this.layer.getThickness() * cal.pixelWidth : 0.0;
        rt.addValue(3, volume);
        rt.addValue(4, this.getNameId());
        return rt;
    }

    public static ResultsTable measure(Profile[] profiles, ResultsTable rt, long profile_list_id) {
        Utils.log2("profiles.length" + profiles.length);
        if (null == profiles || 0 == profiles.length) {
            return null;
        }
        if (1 == profiles.length) {
            return rt;
        }
        for (Profile p : profiles) {
            if (null != p && 0 != p.n_points) continue;
            Utils.log("Cannot measure: empty profile " + p + (null != p ? " at layer " + p.getLayer() : ""));
            return rt;
        }
        if (null == rt) {
            rt = Utils.createResultsTable("Profile list results", new String[]{"id", "interpolated surface", "surface: sum of length x thickness", "volume", "name-id"});
        }
        Calibration cal = profiles[0].getLayerSet().getCalibration();
        List<Point3f> tri = Profile.makeTriangles(profiles, 1.0);
        int n_tri = tri.size();
        if (0 != n_tri % 3) {
            Utils.log("Profile.measure error: triangle verts list not a multiple of 3 for profile list id " + profile_list_id);
            return rt;
        }
        double surface = 0.0;
        for (int i = 2; i < n_tri; i += 3) {
            surface += M.measureArea(tri.get(i - 2), tri.get(i - 1), tri.get(i));
        }
        double area_first = profiles[0].computeArea();
        double area_last = profiles[profiles.length - 1].computeArea();
        if (profiles[0].closed) {
            surface += area_first;
        }
        if (profiles[profiles.length - 1].closed) {
            surface += area_last;
        }
        double surface_flat = 0.0;
        for (int i = 0; i < profiles.length; ++i) {
            if (0 == profiles[i].p_i[0].length) {
                profiles[i].generateInterpolatedPoints(0.05);
            }
            surface_flat += profiles[i].computeLength() * profiles[i].layer.getThickness() * cal.pixelWidth;
        }
        double volume = area_first * profiles[0].layer.getThickness();
        for (int i = 1; i < profiles.length - 1; ++i) {
            volume += profiles[i].computeArea() * profiles[i].layer.getThickness();
        }
        volume += area_last * profiles[profiles.length - 1].layer.getThickness();
        volume *= cal.pixelWidth;
        rt.incrementCounter();
        rt.addLabel("units", cal.getUnit());
        rt.addValue(0, (double)profile_list_id);
        rt.addValue(1, surface);
        rt.addValue(2, surface_flat);
        rt.addValue(3, volume);
        double nameid = 0.0;
        try {
            nameid = Double.parseDouble(profiles[0].project.findProjectThing(profiles[0]).getParent().getTitle());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        rt.addValue(4, nameid);
        return rt;
    }

    @Override
    final Class<?> getInternalDataPackageClass() {
        return DPProfile.class;
    }

    @Override
    synchronized Object getDataPackage() {
        return new DPProfile(this);
    }

    @Override
    public synchronized boolean apply(Layer la, Area roi, CoordinateTransform ict) throws Exception {
        if (this.layer != la) {
            return true;
        }
        double[] fp = null;
        CoordinateTransform chain = null;
        Area localroi = null;
        AffineTransform inverse = null;
        for (int i = 0; i < this.n_points; ++i) {
            if (null == localroi) {
                inverse = this.at.createInverse();
                localroi = roi.createTransformedArea(inverse);
            }
            if (!localroi.contains(this.p[0][i], this.p[1][i])) continue;
            if (null == chain) {
                chain = M.wrap(this.at, ict, inverse);
                fp = new double[2];
            }
            M.apply(chain, this.p, i, fp);
            M.apply(chain, this.p_l, i, fp);
            M.apply(chain, this.p_r, i, fp);
        }
        if (null != chain) {
            this.generateInterpolatedPoints(0.05);
            this.calculateBoundingBox(true);
        }
        return true;
    }

    @Override
    public boolean apply(VectorDataTransform vdt) throws Exception {
        if (vdt.layer != this.layer) {
            return false;
        }
        double[] fp = new double[2];
        VectorDataTransform vlocal = vdt.makeLocalTo(this);
        block0: for (int i = 0; i < this.n_points; ++i) {
            for (VectorDataTransform.ROITransform rt : vlocal.transforms) {
                if (!rt.roi.contains(this.p[0][i], this.p[1][i])) continue;
                M.apply(rt.ct, this.p, i, fp);
                M.apply(rt.ct, this.p_l, i, fp);
                M.apply(rt.ct, this.p_r, i, fp);
                continue block0;
            }
        }
        this.generateInterpolatedPoints(0.05);
        this.calculateBoundingBox(true);
        return true;
    }

    @Override
    public synchronized boolean isRoughlyInside(Layer layer, Rectangle r) {
        if (this.layer != layer) {
            return false;
        }
        try {
            Rectangle box = this.at.createInverse().createTransformedShape(r).getBounds();
            for (int i = 0; i < this.n_points; ++i) {
                if (!box.contains(this.p[0][i], this.p[1][i])) continue;
                return true;
            }
        }
        catch (NoninvertibleTransformException e) {
            IJError.print(e);
        }
        return false;
    }

    private static final class DPProfile
    extends Displayable.DataPackage {
        final double[][] p;
        final double[][] p_l;
        final double[][] p_r;
        final double[][] p_i;
        final boolean closed;

        DPProfile(Profile profile) {
            super(profile);
            this.p = new double[][]{Utils.copy(profile.p[0], profile.n_points), Utils.copy(profile.p[1], profile.n_points)};
            this.p_r = new double[][]{Utils.copy(profile.p_r[0], profile.n_points), Utils.copy(profile.p_r[1], profile.n_points)};
            this.p_l = new double[][]{Utils.copy(profile.p_l[0], profile.n_points), Utils.copy(profile.p_l[1], profile.n_points)};
            this.p_i = new double[][]{Utils.copy(profile.p_i[0], profile.p_i[0].length), Utils.copy(profile.p_i[1], profile.p_i[0].length)};
            this.closed = profile.closed;
        }

        @Override
        final boolean to2(Displayable d) {
            super.to1(d);
            Profile profile = (Profile)d;
            int len = this.p[0].length;
            profile.p = new double[][]{Utils.copy(this.p[0], len), Utils.copy(this.p[1], len)};
            profile.n_points = this.p[0].length;
            profile.p_r = new double[][]{Utils.copy(this.p_r[0], len), Utils.copy(this.p_r[1], len)};
            profile.p_l = new double[][]{Utils.copy(this.p_l[0], len), Utils.copy(this.p_l[1], len)};
            profile.p_i = new double[][]{Utils.copy(this.p_i[0], this.p_i[0].length), Utils.copy(this.p_i[1], this.p_i[1].length)};
            profile.closed = this.closed;
            return true;
        }
    }
}

