/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import features.ComputeCurvatures;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Line3D;
import ini.trakem2.display.Patch;
import ini.trakem2.display.SNTFunctions;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import ini.trakem2.vector.VectorString3D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mpicbg.models.CoordinateTransform;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Vector3d;

public class Polyline
extends ZDisplayable
implements Line3D,
VectorData {
    protected int n_points;
    protected double[][] p = new double[2][0];
    protected long[] p_layer = new long[0];
    protected static int index;
    private static boolean is_new_point;
    protected static final HashMap<LayerSet, TraceParameters> tr_map;
    protected int last_autotrace_start = -1;

    public Polyline(Project project, String title) {
        super(project, title, 0.0, 0.0);
        this.addToDatabase();
        this.n_points = 0;
    }

    public Polyline(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean locked, AffineTransform at) {
        super(project, id, title, locked, at, width, height);
        this.visible = visible;
        this.alpha = alpha;
        this.visible = visible;
        this.color = color;
        this.n_points = -1;
    }

    public Polyline(Project project, long id, HashMap<String, String> ht_attr, HashMap<Displayable, String> ht_links) {
        super(project, id, ht_attr, ht_links);
        String ps = ht_attr.get("d");
        if (null != ps) {
            String lids = ht_attr.get("layer_ids");
            if (null == lids) {
                Utils.log("ERROR: found 'd' but not 'layer_ids' in XML entry of Polyline #" + this.id);
                return;
            }
            int i_start = ps.indexOf(77);
            int i_L = ps.indexOf(76, i_start + 1);
            int next = 0;
            while (-1 != i_L) {
                if (this.p[0].length == next) {
                    this.enlargeArrays();
                }
                int i_comma = ps.indexOf(44, i_start + 1);
                this.p[0][next] = Double.parseDouble(ps.substring(i_start + 1, i_comma));
                int i_end = i_L = ps.indexOf(76, i_comma);
                if (-1 == i_L) {
                    i_end = ps.length();
                }
                this.p[1][next] = Double.parseDouble(ps.substring(i_comma + 1, i_end));
                i_start = i_L;
                ++next;
            }
            this.n_points = next;
            this.p = new double[][]{Utils.copy(this.p[0], this.n_points), Utils.copy(this.p[1], this.n_points)};
            String[] layer_ids = lids.replaceAll(" ", "").trim().split(",");
            this.p_layer = new long[layer_ids.length];
            for (int i = 0; i < layer_ids.length; ++i) {
                if (i == this.p_layer.length) {
                    this.enlargeArrays();
                }
                this.p_layer[i] = Long.parseLong(layer_ids[i]);
            }
        }
    }

    protected synchronized void enlargeArrays() {
        this.enlargeArrays(5);
    }

    protected synchronized void enlargeArrays(int n_more) {
        int length = this.p[0].length;
        double[][] p_copy = new double[2][length + n_more];
        long[] p_layer_copy = new long[length + n_more];
        System.arraycopy(this.p[0], 0, p_copy[0], 0, length);
        System.arraycopy(this.p[1], 0, p_copy[1], 0, length);
        System.arraycopy(this.p_layer, 0, p_layer_copy, 0, length);
        this.p = p_copy;
        this.p_layer = p_layer_copy;
    }

    protected synchronized int findClosestSegment(int x_p, int y_p, long layer_id, double mag) {
        if (1 == this.n_points) {
            return -1;
        }
        if (0 == this.n_points) {
            return -1;
        }
        int index = -1;
        double d = 10.0 / mag;
        if (d < 2.0) {
            d = 2.0;
        }
        double sq_d = d * d;
        double min_sq_dist = Double.MAX_VALUE;
        Calibration cal = this.layer_set.getCalibration();
        double z = this.layer_set.getLayer(layer_id).getZ() * cal.pixelWidth;
        double x2 = this.p[0][0] * cal.pixelWidth;
        double y2 = this.p[1][0] * cal.pixelHeight;
        double z2 = this.layer_set.getLayer(this.p_layer[0]).getZ() * cal.pixelWidth;
        for (int i = 1; i < this.n_points; ++i) {
            double x1 = x2;
            double y1 = y2;
            double z1 = z2;
            double sq_dist = M.distancePointToSegmentSq((double)x_p * cal.pixelWidth, (double)y_p * cal.pixelHeight, z, x1, y1, z1, x2 = this.p[0][i] * cal.pixelWidth, y2 = this.p[1][i] * cal.pixelHeight, z2 = this.layer_set.getLayer(this.p_layer[i]).getZ() * cal.pixelWidth);
            if (!(sq_dist < sq_d) || !(sq_dist < min_sq_dist)) continue;
            min_sq_dist = sq_dist;
            index = i - 1;
        }
        return index;
    }

    protected synchronized int findPoint(int x_p, int y_p, long layer_id, double mag) {
        int index = -1;
        double d = 10.0 / mag;
        if (d < 2.0) {
            d = 2.0;
        }
        double min_dist = Double.MAX_VALUE;
        for (int i = 0; i < this.n_points; ++i) {
            double dist = Math.abs((double)x_p - this.p[0][i]) + Math.abs((double)y_p - this.p[1][i]);
            if (layer_id != this.p_layer[i] || !(dist <= d) || !(dist <= min_dist)) continue;
            min_dist = dist;
            index = i;
        }
        return index;
    }

    protected synchronized int findNearestPoint(int x_p, int y_p, long layer_id) {
        int index = -1;
        double min_dist = Double.MAX_VALUE;
        for (int i = 0; i < this.n_points; ++i) {
            double sq_dist;
            if (layer_id != this.p_layer[i] || !((sq_dist = Math.pow(this.p[0][i] - (double)x_p, 2.0) + Math.pow(this.p[1][i] - (double)y_p, 2.0)) < min_dist)) continue;
            index = i;
            min_dist = sq_dist;
        }
        return index;
    }

    protected synchronized void removePoint(int index) {
        if (index < 0) {
            return;
        }
        if (this.n_points - 1 == index) {
            --this.n_points;
        } else {
            --this.n_points;
            for (int i = index; i < this.n_points; ++i) {
                this.p[0][i] = this.p[0][i + 1];
                this.p[1][i] = this.p[1][i + 1];
                this.p_layer[i] = this.p_layer[i + 1];
            }
        }
        this.last_autotrace_start = index < this.last_autotrace_start && this.n_points > 0 ? --this.last_autotrace_start : -1;
        this.updateInDatabase("points");
    }

    public void dragPoint(int index, int dx, int dy) {
        if (index < 0 || index >= this.n_points) {
            return;
        }
        double[] dArray = this.p[0];
        int n = index;
        dArray[n] = dArray[n] + (double)dx;
        double[] dArray2 = this.p[1];
        int n2 = index;
        dArray2[n2] = dArray2[n2] + (double)dy;
        if (-1 != this.last_autotrace_start && index >= this.last_autotrace_start) {
            this.last_autotrace_start = -1;
        }
    }

    protected double[] sqDistanceToEndPoints(double x_p, double y_p, long layer_id) {
        Calibration cal = this.layer_set.getCalibration();
        double lz = this.layer_set.getLayer(layer_id).getZ();
        double p0z = this.layer_set.getLayer(this.p_layer[0]).getZ();
        double pNz = this.layer_set.getLayer(this.p_layer[this.n_points - 1]).getZ();
        double sqdist0 = (this.p[0][0] - x_p) * (this.p[0][0] - x_p) * cal.pixelWidth * cal.pixelWidth + (this.p[1][0] - y_p) * (this.p[1][0] - y_p) * cal.pixelHeight * cal.pixelHeight + (lz - p0z) * (lz - p0z) * cal.pixelWidth * cal.pixelWidth;
        double sqdistN = (this.p[0][this.n_points - 1] - x_p) * (this.p[0][this.n_points - 1] - x_p) * cal.pixelWidth * cal.pixelWidth + (this.p[1][this.n_points - 1] - y_p) * (this.p[1][this.n_points - 1] - y_p) * cal.pixelHeight * cal.pixelHeight + (lz - pNz) * (lz - pNz) * cal.pixelWidth * cal.pixelWidth;
        return new double[]{sqdist0, sqdistN};
    }

    public synchronized void insertPoint(int i, int x_p, int y_p, long layer_id) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (this.p[0].length == this.n_points) {
            this.enlargeArrays();
        }
        double[][] p2 = new double[2][this.p[0].length];
        long[] p_layer2 = new long[this.p_layer.length];
        if (0 != i) {
            System.arraycopy(this.p[0], 0, p2[0], 0, i);
            System.arraycopy(this.p[1], 0, p2[1], 0, i);
            System.arraycopy(this.p_layer, 0, p_layer2, 0, i);
        }
        p2[0][i] = x_p;
        p2[1][i] = y_p;
        p_layer2[i] = layer_id;
        if (this.n_points != i) {
            System.arraycopy(this.p[0], i, p2[0], i + 1, this.n_points - i);
            System.arraycopy(this.p[1], i, p2[1], i + 1, this.n_points - i);
            System.arraycopy(this.p_layer, i, p_layer2, i + 1, this.n_points - i);
        }
        this.p = p2;
        this.p_layer = p_layer2;
        ++this.n_points;
    }

    protected synchronized int appendPoint(int x_p, int y_p, long layer_id) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (this.p[0].length == this.n_points) {
            this.enlargeArrays();
        }
        this.p[0][this.n_points] = x_p;
        this.p[1][this.n_points] = y_p;
        this.p_layer[this.n_points] = layer_id;
        ++this.n_points;
        return this.n_points - 1;
    }

    protected synchronized int addPoint(int x_p, int y_p, long layer_id, double magnification) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        int index = 0;
        if (this.n_points > 1) {
            index = this.findClosestSegment(x_p, y_p, layer_id, magnification);
        }
        if (this.p[0].length == this.n_points) {
            this.enlargeArrays();
        }
        if (0 == this.n_points || 1 == this.n_points || index + 1 == this.n_points) {
            this.p[0][this.n_points] = x_p;
            this.p[1][this.n_points] = y_p;
            this.p_layer[this.n_points] = layer_id;
            index = this.n_points;
            this.last_autotrace_start = -1;
        } else if (-1 == index) {
            double[] sqd0N = this.sqDistanceToEndPoints(x_p, y_p, layer_id);
            if (sqd0N[1] < sqd0N[0]) {
                this.p[0][this.n_points] = x_p;
                this.p[1][this.n_points] = y_p;
                this.p_layer[this.n_points] = layer_id;
                index = this.n_points;
                this.last_autotrace_start = -1;
            } else {
                for (int i = this.n_points - 1; i > -1; --i) {
                    this.p[0][i + 1] = this.p[0][i];
                    this.p[1][i + 1] = this.p[1][i];
                    this.p_layer[i + 1] = this.p_layer[i];
                }
                this.p[0][0] = x_p;
                this.p[1][0] = y_p;
                this.p_layer[0] = layer_id;
                index = 0;
                if (-1 != this.last_autotrace_start) {
                    ++this.last_autotrace_start;
                }
            }
        } else {
            int sh_length = this.n_points - ++index;
            double[][] p_copy = new double[2][sh_length];
            long[] p_layer_copy = new long[sh_length];
            System.arraycopy(this.p[0], index, p_copy[0], 0, sh_length);
            System.arraycopy(this.p[1], index, p_copy[1], 0, sh_length);
            System.arraycopy(this.p_layer, index, p_layer_copy, 0, sh_length);
            this.p[0][index] = x_p;
            this.p[1][index] = y_p;
            this.p_layer[index] = layer_id;
            System.arraycopy(p_copy[0], 0, this.p[0], index + 1, sh_length);
            System.arraycopy(p_copy[1], 0, this.p[1], index + 1, sh_length);
            System.arraycopy(p_layer_copy, 0, this.p_layer, index + 1, sh_length);
            if (index < this.last_autotrace_start) {
                ++this.last_autotrace_start;
            }
        }
        ++this.n_points;
        return index;
    }

    protected synchronized void appendPoints(double[] px, double[] py, long[] p_layer_ids, int len) {
        int i = 0;
        int next = this.n_points;
        while (i < len) {
            if (next == this.p[0].length) {
                this.enlargeArrays();
            }
            this.p[0][next] = px[i];
            this.p[1][next] = py[i];
            this.p_layer[next] = p_layer_ids[i];
            ++i;
            ++next;
        }
        this.n_points += len;
        this.updateInDatabase("points");
    }

    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        Color above;
        Color below;
        boolean no_color_cues;
        if (0 == this.n_points) {
            return;
        }
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        Composite original_composite = null;
        if (this.alpha != 1.0f) {
            original_composite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, this.alpha));
        }
        int n_points = this.n_points;
        double[][] p = this.p;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            n_points = p[0].length;
        }
        boolean bl = no_color_cues = !this.layer_set.color_cues;
        if (this.layer_set.use_color_cue_colors) {
            below = Color.red;
            above = Color.blue;
        } else {
            below = this.color;
            above = this.color;
        }
        long layer_id = active_layer.getId();
        double z_current = active_layer.getZ();
        double z = this.layer_set.getLayer(this.p_layer[0]).getZ();
        boolean paint = true;
        if (z < z_current) {
            if (no_color_cues) {
                paint = false;
            } else {
                g.setColor(below);
            }
        } else if (z == z_current) {
            g.setColor(this.color);
        } else if (no_color_cues) {
            paint = false;
        } else {
            g.setColor(above);
        }
        if (paint && n_points > 1) {
            g.drawLine((int)p[0][0], (int)p[1][0], (int)((p[0][0] + p[0][1]) / 2.0), (int)((p[1][0] + p[1][1]) / 2.0));
        }
        if (active && layer_id == this.p_layer[0]) {
            g.setColor(this.color);
            DisplayCanvas.drawHandle(g, p[0][0], p[1][0], srcRect, magnification);
            Composite comp = g.getComposite();
            AffineTransform aff = g.getTransform();
            g.setTransform(new AffineTransform());
            g.setColor(Color.white);
            g.setXORMode(Color.green);
            g.drawString("1", (int)((p[0][0] - (double)srcRect.x) * magnification + 4.0 / magnification), (int)((p[1][0] - (double)srcRect.y) * magnification));
            g.setComposite(comp);
            g.setTransform(aff);
        }
        for (int i = 1; i < n_points; ++i) {
            z = this.layer_set.getLayer(this.p_layer[i]).getZ();
            paint = true;
            if (z < z_current) {
                if (no_color_cues) {
                    paint = false;
                } else {
                    g.setColor(below);
                }
            } else if (z == z_current) {
                g.setColor(this.color);
            } else if (no_color_cues) {
                paint = false;
            } else {
                g.setColor(above);
            }
            if (!paint) continue;
            g.drawLine((int)p[0][i], (int)p[1][i], (int)((p[0][i] + p[0][i - 1]) / 2.0), (int)((p[1][i] + p[1][i - 1]) / 2.0));
            if (i < n_points - 1) {
                g.drawLine((int)p[0][i], (int)p[1][i], (int)((p[0][i] + p[0][i + 1]) / 2.0), (int)((p[1][i] + p[1][i + 1]) / 2.0));
            }
            if (!active || layer_id != this.p_layer[i]) continue;
            g.setColor(this.color);
            DisplayCanvas.drawHandle(g, p[0][i], p[1][i], srcRect, magnification);
        }
        if (null != original_composite) {
            g.setComposite(original_composite);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        switch (keyCode) {
            case 68: {
                if (-1 == this.last_autotrace_start) {
                    if (0 > this.n_points) {
                        Utils.log("Cannot remove last set of autotraced points:\n  Manual editions exist, or never autotraced.");
                    }
                    return;
                }
                int len = this.n_points - this.last_autotrace_start;
                this.n_points = this.last_autotrace_start;
                this.last_autotrace_start = -1;
                this.repaint(true, null);
                HashSet<Long> hs = new HashSet<Long>();
                for (int i = this.n_points + 1; i < this.n_points + len; ++i) {
                    hs.add(this.p_layer[i]);
                }
                for (Long l : hs) {
                    this.updateBucket(this.layer_set.getLayer((long)l));
                }
                Utils.log("Removed " + len + " autotraced points.");
                return;
            }
            case 82: {
                tr_map.remove(this.layer_set);
                ke.consume();
                Utils.log("Reset tracing data for Polyline " + this);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushTraceCache(Project project) {
        HashMap<LayerSet, TraceParameters> hashMap = tr_map;
        synchronized (hashMap) {
            Iterator<LayerSet> it = tr_map.keySet().iterator();
            while (it.hasNext()) {
                if (it.next().getProject() != project) continue;
                it.remove();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me, Layer layer, int x_p, int y_p, double mag) {
        int x_pd = x_p;
        int y_pd = y_p;
        if (!this.at.isIdentity()) {
            Point2D.Double po = this.inverseTransformPoint(x_p, y_p);
            x_p = (int)po.x;
            y_p = (int)po.y;
        }
        int tool = ProjectToolbar.getToolId();
        Display display = ((DisplayCanvas)me.getSource()).getDisplay();
        long layer_id = layer.getId();
        index = this.findPoint(x_p, y_p, layer_id, mag);
        if (15 == tool && this.n_points > 0 && -1 == index && !me.isShiftDown() && !Utils.isControlDown(me)) {
            try {
                SNTFunctions.trace(this, this.project, layer, display, me, x_pd, y_pd);
            }
            catch (NoClassDefFoundError err) {
                IJ.error((String)"Cannot load SNT for line tracing. Do you have the Neuroanatomy update site enabled?");
                IJError.print(err);
            }
            return;
        }
        if (16 == tool || 15 == tool) {
            if (Utils.isControlDown(me) && me.isShiftDown()) {
                long lid = Display.getFrontLayer(this.project).getId();
                if (-1 == index || lid != this.p_layer[index]) {
                    index = this.findNearestPoint(x_p, y_p, layer_id);
                }
                if (-1 != index) {
                    this.removePoint(index);
                    index = -1;
                    this.repaint(false, null);
                }
                return;
            }
            if (-1 != index && layer_id != this.p_layer[index]) {
                index = -1;
            } else if (-1 == index && !me.isShiftDown() && !me.isAltDown()) {
                index = this.addPoint(x_p, y_p, layer_id, mag);
                is_new_point = true;
                this.repaint(false, null);
                return;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        int tool;
        if (!this.at.isIdentity()) {
            Point2D.Double pd = this.inverseTransformPoint(x_d, y_d);
            x_d = (int)pd.x;
            y_d = (int)pd.y;
            Point2D.Double pdo = this.inverseTransformPoint(x_d_old, y_d_old);
            x_d_old = (int)pdo.x;
            y_d_old = (int)pdo.y;
        }
        if (!(16 != (tool = ProjectToolbar.getToolId()) && 15 != tool || -1 == index || me.isAltDown() || me.isShiftDown())) {
            this.dragPoint(index, x_d - x_d_old, y_d - y_d_old);
            this.repaint(false, layer);
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        int tool = ProjectToolbar.getToolId();
        if (16 == tool || 15 == tool) {
            this.repaint(true, layer);
        }
        if (-1 != index) {
            if (is_new_point) {
                this.updateInDatabase("points");
            } else if (-1 != index && index != this.n_points) {
                this.updateInDatabase("points");
            } else if (index != this.n_points) {
                this.updateInDatabase("points");
            }
            this.updateInDatabase("dimensions");
        } else if (x_r != x_p || y_r != y_p) {
            this.updateInDatabase("dimensions");
        }
        this.repaint(true, layer);
        is_new_point = false;
        index = -1;
    }

    @Override
    protected boolean calculateBoundingBox(Layer la) {
        return this.calculateBoundingBox(true, la);
    }

    protected synchronized boolean calculateBoundingBox(boolean adjust_position, Layer la) {
        if (0 == this.n_points) {
            this.height = 0.0f;
            this.width = 0.0f;
            this.updateBucket(la);
            return true;
        }
        double[] m = this.calculateDataBoundingBox();
        this.width = (float)(m[2] - m[0]);
        this.height = (float)(m[3] - m[1]);
        if (adjust_position) {
            int i = 0;
            while (i < this.n_points) {
                double[] dArray = this.p[0];
                int n = i;
                dArray[n] = dArray[n] - m[0];
                double[] dArray2 = this.p[1];
                int n2 = i++;
                dArray2[n2] = dArray2[n2] - m[1];
            }
            this.at.translate(m[0], m[1]);
            this.updateInDatabase("transform");
        }
        this.updateInDatabase("dimensions");
        this.updateBucket(la);
        return true;
    }

    protected double[] calculateDataBoundingBox() {
        double min_x = Double.MAX_VALUE;
        double min_y = Double.MAX_VALUE;
        double max_x = 0.0;
        double max_y = 0.0;
        for (int i = 0; i < this.n_points; ++i) {
            if (this.p[0][i] < min_x) {
                min_x = this.p[0][i];
            }
            if (this.p[1][i] < min_y) {
                min_y = this.p[1][i];
            }
            if (this.p[0][i] > max_x) {
                max_x = this.p[0][i];
            }
            if (!(this.p[1][i] > max_y)) continue;
            max_y = this.p[1][i];
        }
        return new double[]{min_x, min_y, max_x, max_y};
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.p = null;
        this.p_layer = null;
    }

    public synchronized void flush() {
        this.p = null;
        this.p_layer = null;
        this.n_points = -1;
    }

    public void repaint(boolean repaint_navigator, Layer la) {
        Rectangle box = this.getBoundingBox(null);
        this.calculateBoundingBox(true, la);
        box.add(this.getBoundingBox(null));
        Display.repaint(this.layer_set, (Displayable)this, box, 5, repaint_navigator);
    }

    private synchronized void setupForDisplay() {
        if (-1 == this.n_points) {
            this.n_points = 0;
        }
    }

    @Override
    public synchronized Polygon getPerimeter() {
        if (null == this.p || this.p[0].length < 2) {
            return new Polygon();
        }
        int n_points = this.n_points;
        double[][] p = this.p;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            n_points = p[0].length;
        }
        int[] x = new int[n_points];
        int[] y = new int[n_points];
        for (int i = 0; i < n_points; ++i) {
            x[i] = (int)p[0][i];
            y[i] = (int)p[1][i];
        }
        return new Polygon(x, y, n_points);
    }

    @Override
    public synchronized Area getAreaAt(Layer layer) {
        Area a = new Area();
        for (int i = 0; i < this.n_points; ++i) {
            if (this.p_layer[i] != layer.getId()) continue;
            a.add(new Area(new Rectangle2D.Float((float)this.p[0][i], (float)this.p[1][i], 1.0f, 1.0f)));
        }
        a.transform(this.at);
        return a;
    }

    @Override
    public synchronized boolean isRoughlyInside(Layer layer, Rectangle r) {
        try {
            Rectangle box = this.at.createInverse().createTransformedShape(r).getBounds();
            for (int i = 0; i < this.n_points; ++i) {
                if (this.p_layer[i] != layer.getId() || !box.contains(this.p[0][i], this.p[1][i])) continue;
                return true;
            }
        }
        catch (NoninvertibleTransformException e) {
            IJError.print(e);
        }
        return false;
    }

    @Override
    public boolean isDeletable() {
        return 0 == this.n_points;
    }

    @Override
    public int length() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        return this.n_points;
    }

    @Override
    public synchronized boolean contains(Layer layer, double x, double y) {
        double mag;
        Display front = Display.getFront();
        double radius = 10.0;
        if (null != front && (radius = 10.0 / (mag = front.getCanvas().getMagnification())) < 2.0) {
            radius = 2.0;
        }
        Point2D.Double po = this.inverseTransformPoint(x, y);
        return this.containsLocal(layer, po.x, po.y, radius);
    }

    protected boolean containsLocal(Layer layer, double x, double y, double radius) {
        long lid = layer.getId();
        double z = layer.getZ();
        for (int i = 0; i < this.n_points; ++i) {
            if (lid == this.p_layer[i]) {
                if (i > 0 && M.distancePointToLine(x, y, this.p[0][i - 1], this.p[1][i - 1], this.p[0][i], this.p[1][i]) < radius) {
                    return true;
                }
                if (i >= this.n_points - 1 || !(M.distancePointToLine(x, y, this.p[0][i], this.p[1][i], this.p[0][i + 1], this.p[1][i + 1]) < radius)) continue;
                return true;
            }
            if (i <= 0) continue;
            double z1 = this.layer_set.getLayer(this.p_layer[i - 1]).getZ();
            double z2 = this.layer_set.getLayer(this.p_layer[i]).getZ();
            if (!(z1 < z && z < z2) && (!(z2 < z) || !(z < z1)) || !(M.distancePointToLine(x, y, this.p[0][i - 1], this.p[1][i - 1], this.p[0][i], this.p[1][i]) < radius)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean linkPatches() {
        this.unlinkAll(Patch.class);
        HashMap<Long, ArrayList<Integer>> m = new HashMap<Long, ArrayList<Integer>>();
        for (int i = 0; i < this.n_points; ++i) {
            ArrayList<Integer> a = (ArrayList<Integer>)m.get(this.p_layer[i]);
            if (null == a) {
                a = new ArrayList<Integer>();
                m.put(this.p_layer[i], a);
            }
            a.add(i);
        }
        boolean must_lock = false;
        for (Map.Entry e : m.entrySet()) {
            Layer layer = this.layer_set.getLayer((long)((Long)e.getKey()));
            block2: for (Displayable patch : layer.getDisplayables(Patch.class)) {
                Polygon perimeter = patch.getPerimeter();
                for (Integer in : (ArrayList)e.getValue()) {
                    int i = in;
                    if (!perimeter.contains(this.p[0][i], this.p[1][i])) continue;
                    this.link(patch);
                    if (!patch.locked) continue block2;
                    must_lock = true;
                    continue block2;
                }
            }
        }
        if (must_lock && !this.locked) {
            this.setLocked(true);
            return true;
        }
        return false;
    }

    @Override
    public Layer getFirstLayer() {
        if (0 == this.n_points) {
            return this.layer;
        }
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        Layer la = this.layer;
        double z = Double.MAX_VALUE;
        for (int i = 0; i < this.n_points; ++i) {
            Layer layer = this.layer_set.getLayer(this.p_layer[i]);
            if (!(layer.getZ() < Double.MAX_VALUE)) continue;
            la = layer;
        }
        return la;
    }

    @Override
    public synchronized void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        sb_body.append(indent).append("<t2_polyline\n");
        String in = indent + "\t";
        super.exportXML(sb_body, in, options);
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        String[] RGB = Utils.getHexRGBColor(this.color);
        sb_body.append(in).append("style=\"fill:none;stroke-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";stroke-width:1.0px;stroke-opacity:1.0\"\n");
        if (this.n_points > 0) {
            int i;
            sb_body.append(in).append("d=\"M");
            for (i = 0; i < this.n_points - 1; ++i) {
                sb_body.append(" ").append(this.p[0][i]).append(",").append(this.p[1][i]).append(" L");
            }
            sb_body.append(" ").append(this.p[0][this.n_points - 1]).append(',').append(this.p[1][this.n_points - 1]).append("\"\n");
            sb_body.append(in).append("layer_ids=\"");
            for (i = 0; i < this.n_points; ++i) {
                sb_body.append(this.p_layer[i]);
                if (this.n_points - 1 == i) continue;
                sb_body.append(",");
            }
            sb_body.append("\"\n");
        }
        sb_body.append(indent).append(">\n");
        super.restXML(sb_body, in, options);
        sb_body.append(indent).append("</t2_polyline>\n");
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_polyline";
        if (hs.contains("t2_polyline")) {
            return;
        }
        hs.add("t2_polyline");
        sb_header.append(indent).append("<!ELEMENT t2_polyline (").append(Displayable.commonDTDChildren()).append(")>\n");
        Displayable.exportDTD("t2_polyline", sb_header, hs, indent);
        sb_header.append(indent).append("<!ATTLIST ").append("t2_polyline").append(" d").append(" NMTOKEN #REQUIRED>\n");
    }

    @Override
    public synchronized Displayable clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Polyline copy = new Polyline(pr, nid, null != this.title ? this.title.toString() : null, this.width, this.height, this.alpha, this.visible, new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()), this.locked, (AffineTransform)this.at.clone());
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        copy.n_points = this.n_points;
        copy.p = new double[][]{(double[])this.p[0].clone(), (double[])this.p[1].clone()};
        copy.p_layer = (long[])this.p_layer.clone();
        copy.addToDatabase();
        return copy;
    }

    @Override
    public synchronized List<Point3f> generateTriangles(double scale, int parallels, int resample) {
        return this.generateTriangles(scale, parallels, resample, this.layer_set.getCalibrationCopy());
    }

    public synchronized List<Point3f> generateTriangles(double scale, int parallels, int resample, Calibration cal) {
        int n_points;
        double[][] p;
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return null;
        }
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            n_points = p[0].length;
        } else {
            n_points = this.n_points;
            p = this.p;
        }
        ArrayList<Point3f> list = new ArrayList<Point3f>();
        double KW = scale * cal.pixelWidth * (double)resample;
        double KH = scale * cal.pixelHeight * (double)resample;
        for (int i = 0; i < n_points; ++i) {
            list.add(new Point3f((float)(p[0][i] * KW), (float)(p[1][i] * KH), (float)(this.layer_set.getLayer(this.p_layer[i]).getZ() * KW)));
        }
        if (n_points < 2) {
            list.add(list.get(0));
        }
        return list;
    }

    private synchronized Object[] getTransformedData() {
        int n_points = this.n_points;
        double[][] p = this.transformPoints(this.p, n_points);
        return new Object[]{p};
    }

    @Override
    public boolean intersects(Area area, double z_first, double z_last) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        for (int i = 0; i < this.n_points; ++i) {
            double z = this.layer_set.getLayer(this.p_layer[i]).getZ();
            if (z < z_first || z > z_last || !area.contains(this.p[0][i], this.p[1][i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized VectorString3D asVectorString3D() {
        int n_points = this.n_points;
        double[][] p = this.p;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            n_points = p[0].length;
        }
        double[] z_values = new double[n_points];
        for (int i = 0; i < n_points; ++i) {
            z_values[i] = this.layer_set.getLayer(this.p_layer[i]).getZ();
        }
        double[] px = p[0];
        double[] py = p[1];
        double[] pz = z_values;
        VectorString3D vs = null;
        try {
            vs = new VectorString3D(px, py, pz, false);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return vs;
    }

    @Override
    public String getInfo() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        double len = 0.0;
        if (this.n_points > 1) {
            VectorString3D vs = this.asVectorString3D();
            vs.calibrate(this.layer_set.getCalibration());
            len = vs.computeLength();
        }
        return "Length: " + Utils.cutNumber(len, 2, true) + ' ' + this.layer_set.getCalibration().getUnits() + '\n';
    }

    @Override
    public ResultsTable measure(ResultsTable rt) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return rt;
        }
        if (null == rt) {
            rt = Utils.createResultsTable("Polyline results", new String[]{"id", "length", "name-id"});
        }
        double len = 0.0;
        Calibration cal = this.layer_set.getCalibration();
        if (this.n_points > 1) {
            VectorString3D vs = this.asVectorString3D();
            vs.calibrate(cal);
            len = vs.computeLength();
        }
        rt.incrementCounter();
        rt.addLabel("units", cal.getUnit());
        rt.addValue(0, (double)this.id);
        rt.addValue(1, len);
        rt.addValue(2, this.getNameId());
        return rt;
    }

    public static Object[] simplify(double[] px, double[] py, long[] p_layer_ids, int max_iterations, LayerSet layer_set) throws Exception {
        int i;
        if (px.length != py.length || py.length != p_layer_ids.length) {
            return null;
        }
        double[] pz = new double[px.length];
        for (int i2 = 0; i2 < pz.length; ++i2) {
            pz[i2] = layer_set.getLayer(p_layer_ids[i2]).getZ();
        }
        Calibration cal = layer_set.getCalibrationCopy();
        double one_unit = 1.0 / cal.pixelWidth;
        double traced_length = M.distance(px[0], py[0], pz[0], px[px.length - 1], py[py.length - 1], pz[pz.length - 1]);
        double segment_length = one_unit * 5.0;
        int n_new_points = (int)(traced_length / segment_length) + 1;
        double[] rx = new double[n_new_points];
        double[] ry = new double[n_new_points];
        double[] rz = new double[n_new_points];
        rx[0] = px[0];
        rx[rx.length - 1] = px[px.length - 1];
        ry[0] = py[0];
        ry[ry.length - 1] = py[py.length - 1];
        rz[0] = pz[0];
        rz[rz.length - 1] = pz[pz.length - 1];
        Vector3d v = new Vector3d(rx[n_new_points - 1] - rx[0], ry[n_new_points - 1] - ry[0], rz[n_new_points - 1] - rz[0]);
        v.normalize();
        v.scale(segment_length);
        for (int i3 = 1; i3 < n_new_points - 1; ++i3) {
            rx[i3] = rx[0] + v.x * (double)i3;
            ry[i3] = ry[0] + v.y * (double)i3;
            rz[i3] = rz[0] + v.z * (double)i3;
        }
        Pth path = new Pth(rx, ry, rz);
        rz = null;
        ry = null;
        rx = null;
        double d = 1.0;
        Random rand = new Random(System.currentTimeMillis());
        double current_error = Double.MAX_VALUE;
        int missed_in_a_row = 0;
        for (i = 0; i < max_iterations; ++i) {
            Pth copy = path.copy().shakeUpOne(1.0, rand);
            double error = copy.measureErrorSq(px, py, pz);
            if (error < current_error) {
                current_error = error;
                path = copy;
                missed_in_a_row = 0;
                continue;
            }
            if (++missed_in_a_row <= 10 * path.px.length) continue;
            Utils.log2("Stopped random walk at iteration " + i);
            break;
        }
        if (max_iterations == i) {
            Utils.log2("Reached max iterations -- current error: " + current_error);
        }
        long[] plids = new long[path.px.length];
        plids[0] = p_layer_ids[0];
        for (int k = 1; k < path.pz.length; ++k) {
            plids[k] = layer_set.getNearestLayer(path.pz[k]).getId();
        }
        return new Object[]{path.px, path.py, plids};
    }

    @Override
    final Class<?> getInternalDataPackageClass() {
        return DPPolyline.class;
    }

    @Override
    synchronized Object getDataPackage() {
        return new DPPolyline(this);
    }

    @Override
    public synchronized boolean crop(List<Layer> range) {
        HashSet<Long> lids = new HashSet<Long>();
        for (Layer l : range) {
            lids.add(l.getId());
        }
        for (int i = 0; i < this.n_points; ++i) {
            if (lids.contains(this.p_layer[i])) continue;
            this.removePoint(i);
            --i;
        }
        this.calculateBoundingBox(true, null);
        return true;
    }

    public synchronized Polyline sub(int start, int end) {
        Polyline sub = new Polyline(this.project, this.title);
        sub.n_points = end - start + 1;
        sub.p[0] = Utils.copy(this.p[0], start, sub.n_points);
        sub.p[1] = Utils.copy(this.p[1], start, sub.n_points);
        sub.p_layer = new long[sub.n_points];
        System.arraycopy(this.p_layer, start, sub.p_layer, 0, sub.n_points);
        return sub;
    }

    public synchronized void reverse() {
        Utils.reverse(this.p[0]);
        Utils.reverse(this.p[1]);
        Utils.reverse(this.p_layer);
    }

    @Override
    protected synchronized boolean layerRemoved(Layer la) {
        super.layerRemoved(la);
        for (int i = 0; i < this.p_layer.length; ++i) {
            if (la.getId() != this.p_layer[i]) continue;
            this.removePoint(i);
            --i;
        }
        return true;
    }

    @Override
    public synchronized boolean apply(Layer la, Area roi, CoordinateTransform ict) throws Exception {
        double[] fp = null;
        CoordinateTransform chain = null;
        Area localroi = null;
        AffineTransform inverse = null;
        for (int i = 0; i < this.n_points; ++i) {
            if (this.p_layer[i] != la.getId()) continue;
            if (null == localroi) {
                inverse = this.at.createInverse();
                localroi = roi.createTransformedArea(inverse);
            }
            if (!localroi.contains(this.p[0][i], this.p[1][i])) continue;
            if (null == chain) {
                chain = M.wrap(this.at, ict, inverse);
                fp = new double[2];
            }
            M.apply(chain, this.p, i, fp);
        }
        if (null != chain) {
            this.calculateBoundingBox(true, la);
        }
        return true;
    }

    @Override
    public boolean apply(VectorDataTransform vdt) throws Exception {
        double[] fp = new double[2];
        VectorDataTransform vlocal = vdt.makeLocalTo(this);
        block0: for (int i = 0; i < this.n_points; ++i) {
            if (vdt.layer.getId() != this.p_layer[i]) continue;
            for (VectorDataTransform.ROITransform rt : vlocal.transforms) {
                if (!rt.roi.contains(this.p[0][i], this.p[1][i])) continue;
                M.apply(rt.ct, this.p, i, fp);
                continue block0;
            }
        }
        this.calculateBoundingBox(true, vlocal.layer);
        return true;
    }

    @Override
    public synchronized Collection<Long> getLayerIds() {
        return Utils.asList(this.p_layer, 0, this.n_points);
    }

    static {
        is_new_point = false;
        tr_map = new HashMap();
    }

    private static final class DPPolyline
    extends Displayable.DataPackage {
        final double[][] p;
        final long[] p_layer;

        DPPolyline(Polyline polyline) {
            super(polyline);
            this.p = new double[][]{Utils.copy(polyline.p[0], polyline.n_points), Utils.copy(polyline.p[1], polyline.n_points)};
            this.p_layer = new long[polyline.n_points];
            System.arraycopy(polyline.p_layer, 0, this.p_layer, 0, polyline.n_points);
        }

        @Override
        final boolean to2(Displayable d) {
            super.to1(d);
            Polyline polyline = (Polyline)d;
            int len = this.p[0].length;
            polyline.p = new double[][]{Utils.copy(this.p[0], len), Utils.copy(this.p[1], len)};
            polyline.n_points = this.p[0].length;
            polyline.p_layer = new long[len];
            System.arraycopy(this.p_layer, 0, polyline.p_layer, 0, len);
            return true;
        }
    }

    private static class Pth {
        final double[] px;
        final double[] py;
        final double[] pz;

        Pth(double[] px, double[] py, double[] pz) {
            this.px = px;
            this.py = py;
            this.pz = pz;
        }

        final Pth shakeUpOne(double d, Random rand) {
            int i;
            int n = i = rand.nextInt(this.px.length - 1) + 1;
            this.px[n] = this.px[n] + d * (double)(rand.nextBoolean() ? 1 : -1);
            int n2 = i;
            this.py[n2] = this.py[n2] + d * (double)(rand.nextBoolean() ? 1 : -1);
            int n3 = i;
            this.pz[n3] = this.pz[n3] + d * (double)(rand.nextBoolean() ? 1 : -1);
            return this;
        }

        final Pth copy() {
            return new Pth(Utils.copy(this.px, this.px.length), Utils.copy(this.py, this.py.length), Utils.copy(this.pz, this.pz.length));
        }

        final double measureErrorSq(double[] ox, double[] oy, double[] oz) {
            double error = 0.0;
            for (int i = 1; i < ox.length - 1; ++i) {
                double min_dist = Double.MAX_VALUE;
                for (int j = 1; j < this.px.length; ++j) {
                    double dist = M.distancePointToSegmentSq(ox[i], oy[i], oz[i], this.px[j - 1], this.py[j - 1], this.pz[j - 1], this.px[j], this.py[j], this.pz[j]);
                    if (!(dist < min_dist)) continue;
                    min_dist = dist;
                }
                error += min_dist;
            }
            return error;
        }
    }

    static class TraceParameters {
        boolean update = true;
        ImagePlus virtual = null;
        ComputeCurvatures hessian = null;
        Object tracer = null;

        TraceParameters() {
        }
    }
}

