/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Line3D;
import ini.trakem2.display.Patch;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Vector3;
import ini.trakem2.vector.VectorString3D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mpicbg.models.CoordinateTransform;
import org.scijava.vecmath.Point3f;

public class Pipe
extends ZDisplayable
implements Line3D,
VectorData {
    protected int n_points;
    protected double[][] p;
    protected double[][] p_l;
    protected double[][] p_r;
    protected double[][] p_i = new double[2][0];
    protected long[] p_layer;
    protected double[] p_width;
    protected double[] p_width_i = new double[0];
    private static double last_radius = -1.0;
    private static int index;
    private static int index_l;
    private static int index_r;
    private static boolean is_new_point;

    public Pipe(Project project, String title, double x, double y) {
        super(project, title, x, y);
        this.n_points = 0;
        this.p = new double[2][5];
        this.p_l = new double[2][5];
        this.p_r = new double[2][5];
        this.p_layer = new long[5];
        this.p_width = new double[5];
        this.addToDatabase();
    }

    public Pipe(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean locked, AffineTransform at) {
        super(project, id, title, locked, at, width, height);
        this.visible = visible;
        this.alpha = alpha;
        this.visible = visible;
        this.color = color;
        this.n_points = -1;
    }

    public Pipe(Project project, long id, HashMap<String, String> ht, HashMap<Displayable, String> ht_links) {
        super(project, id, ht, ht_links);
        String data = ht.get("d");
        if (null != data) {
            ArrayList<String> al_p = new ArrayList<String>();
            ArrayList<String> al_p_r = new ArrayList<String>();
            ArrayList<String> al_p_l = new ArrayList<String>();
            int i_start = data.indexOf(77);
            int i_end = data.indexOf(67);
            String point = data.substring(i_start + 1, i_end).trim();
            al_p.add(point);
            boolean go = true;
            while (go) {
                i_start = i_end;
                if (-1 == (i_end = data.indexOf(67, i_end + 1))) {
                    i_end = data.length() - 1;
                    go = false;
                }
                String txt = data.substring(i_start + 1, i_end).trim();
                while (-1 != txt.indexOf("  ")) {
                    txt = txt.replaceAll("  ", " ");
                }
                txt = txt.replaceAll(" ,", ",");
                String[] points = (txt = txt.replaceAll(", ", ",")).split(" ");
                if (3 == points.length) {
                    al_p_r.add(points[0]);
                    al_p_l.add(points[1]);
                    al_p.add(points[2]);
                    continue;
                }
                Utils.log("Pipe constructor from XML: error at parsing points.");
            }
            al_p_l.add(0, (String)al_p.get(0));
            al_p_r.add((String)al_p.get(al_p.size() - 1));
            if (al_p.size() != al_p_l.size() || al_p_l.size() != al_p_r.size()) {
                Utils.log2("Pipe XML parsing: Disagreement in the number of points:\n\tp.length=" + al_p.size() + "\n\tp_l.length=" + al_p_l.size() + "\n\tp_r.length=" + al_p_r.size());
            }
            this.n_points = al_p.size();
            this.p = new double[2][this.n_points];
            this.p_l = new double[2][this.n_points];
            this.p_r = new double[2][this.n_points];
            for (int i = 0; i < this.n_points; ++i) {
                String[] sp = ((String)al_p.get(i)).split(",");
                this.p[0][i] = Double.parseDouble(sp[0]);
                this.p[1][i] = Double.parseDouble(sp[1]);
                sp = ((String)al_p_l.get(i)).split(",");
                this.p_l[0][i] = Double.parseDouble(sp[0]);
                this.p_l[1][i] = Double.parseDouble(sp[1]);
                sp = ((String)al_p_r.get(i)).split(",");
                this.p_r[0][i] = Double.parseDouble(sp[0]);
                this.p_r[1][i] = Double.parseDouble(sp[1]);
            }
        }
        if (null != (data = ht.get("layer_ids"))) {
            String[] layer_ids = data.replaceAll(" ", "").trim().split(",");
            this.p_layer = new long[layer_ids.length];
            for (int i = 0; i < layer_ids.length; ++i) {
                this.p_layer[i] = Long.parseLong(layer_ids[i]);
            }
        }
        if (null != (data = ht.get("p_width"))) {
            String[] widths = data.replaceAll(" ", "").trim().split(",");
            this.p_width = new double[widths.length];
            for (int i = 0; i < widths.length; ++i) {
                this.p_width[i] = Double.parseDouble(widths[i]);
            }
        }
        this.p_i = new double[2][0];
        this.p_width_i = new double[0];
        this.generateInterpolatedPoints(0.05);
        if (null == this.p) {
            this.n_points = 0;
            this.p = new double[2][0];
            this.p_l = new double[2][0];
            this.p_r = new double[2][0];
            this.p_width = new double[0];
            this.p_layer = new long[0];
        }
        if (this.n_points != this.p[0].length || this.p[0].length != this.p_width.length || this.p_width.length != this.p_layer.length) {
            Utils.log2("Pipe at parsing XML: inconsistent number of points for id=" + id);
            Utils.log2("\tn_points: " + this.n_points + "  p.length: " + this.p[0].length + "  p_width.length: " + this.p_width.length + "  p_layer.length: " + this.p_layer.length);
        }
    }

    private synchronized void enlargeArrays() {
        int length = this.p[0].length;
        double[][] p_copy = new double[2][length + 5];
        double[][] p_l_copy = new double[2][length + 5];
        double[][] p_r_copy = new double[2][length + 5];
        long[] p_layer_copy = new long[length + 5];
        double[] p_width_copy = new double[length + 5];
        System.arraycopy(this.p[0], 0, p_copy[0], 0, length);
        System.arraycopy(this.p[1], 0, p_copy[1], 0, length);
        System.arraycopy(this.p_l[0], 0, p_l_copy[0], 0, length);
        System.arraycopy(this.p_l[1], 0, p_l_copy[1], 0, length);
        System.arraycopy(this.p_r[0], 0, p_r_copy[0], 0, length);
        System.arraycopy(this.p_r[1], 0, p_r_copy[1], 0, length);
        System.arraycopy(this.p_layer, 0, p_layer_copy, 0, length);
        System.arraycopy(this.p_width, 0, p_width_copy, 0, length);
        this.p = p_copy;
        this.p_l = p_l_copy;
        this.p_r = p_r_copy;
        this.p_layer = p_layer_copy;
        this.p_width = p_width_copy;
    }

    protected synchronized int findPoint(double[][] a, long[] p_layer, int x_p, int y_p, long lid, double magnification) {
        int index = -1;
        double d = 10.0 / magnification;
        if (d < 2.0) {
            d = 2.0;
        }
        double min_dist = Double.MAX_VALUE;
        long i_layer = Display.getFrontLayer(this.project).getId();
        for (int i = 0; i < this.n_points; ++i) {
            if (p_layer[i] != lid) continue;
            double dist = Math.abs((double)x_p - a[0][i]) + Math.abs((double)y_p - a[1][i]);
            if (i_layer != p_layer[i] || !(dist <= d) || !(dist <= min_dist)) continue;
            min_dist = dist;
            index = i;
        }
        return index;
    }

    protected synchronized void removePoint(int index) {
        if (index < 0) {
            return;
        }
        if (this.n_points - 1 == index) {
            --this.n_points;
        } else {
            --this.n_points;
            for (int i = index; i < this.n_points; ++i) {
                this.p[0][i] = this.p[0][i + 1];
                this.p[1][i] = this.p[1][i + 1];
                this.p_l[0][i] = this.p_l[0][i + 1];
                this.p_l[1][i] = this.p_l[1][i + 1];
                this.p_r[0][i] = this.p_r[0][i + 1];
                this.p_r[1][i] = this.p_r[1][i + 1];
                this.p_layer[i] = this.p_layer[i + 1];
                this.p_width[i] = this.p_width[i + 1];
            }
        }
        this.updateInDatabase("points");
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    protected void dragPoint(int index, int dx, int dy) {
        double[] dArray = this.p[0];
        int n = index;
        dArray[n] = dArray[n] + (double)dx;
        double[] dArray2 = this.p[1];
        int n2 = index;
        dArray2[n2] = dArray2[n2] + (double)dy;
        double[] dArray3 = this.p_l[0];
        int n3 = index;
        dArray3[n3] = dArray3[n3] + (double)dx;
        double[] dArray4 = this.p_l[1];
        int n4 = index;
        dArray4[n4] = dArray4[n4] + (double)dy;
        double[] dArray5 = this.p_r[0];
        int n5 = index;
        dArray5[n5] = dArray5[n5] + (double)dx;
        double[] dArray6 = this.p_r[1];
        int n6 = index;
        dArray6[n6] = dArray6[n6] + (double)dy;
    }

    protected void resetControlPoints(int index) {
        this.p_l[0][index] = this.p[0][index];
        this.p_l[1][index] = this.p[1][index];
        this.p_r[0][index] = this.p[0][index];
        this.p_r[1][index] = this.p[1][index];
    }

    protected void dragControlPoint(int index, int x_d, int y_d, double[][] p_dragged, double[][] p_adjusted, boolean symmetric) {
        double hypothenusa = symmetric ? Pipe.distance(this.p[0][index], this.p[1][index], p_dragged[0][index], p_dragged[1][index]) : Pipe.distance(this.p[0][index], this.p[1][index], p_adjusted[0][index], p_adjusted[1][index]);
        double angle = Math.atan2(p_dragged[0][index] - this.p[0][index], p_dragged[1][index] - this.p[1][index]) + Math.PI;
        p_dragged[0][index] = x_d;
        p_dragged[1][index] = y_d;
        p_adjusted[0][index] = this.p[0][index] + hypothenusa * Math.sin(angle);
        p_adjusted[1][index] = this.p[1][index] + hypothenusa * Math.cos(angle);
    }

    private static double getFirstWidth() {
        if (null == Display.getFront()) {
            return 1.0;
        }
        if (-1.0 != last_radius) {
            return last_radius;
        }
        return 10.0 / Display.getFront().getCanvas().getMagnification();
    }

    protected synchronized int addPoint(int x_p, int y_p, double magnification, double bezier_finess, long layer_id) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        int index = this.findClosestPoint(x_p, y_p, magnification, bezier_finess);
        if (this.p[0].length == this.n_points) {
            this.enlargeArrays();
        }
        if (0 == this.n_points || 1 == this.n_points || index + 1 == this.n_points) {
            double d = x_p;
            this.p_r[0][this.n_points] = d;
            this.p_l[0][this.n_points] = d;
            this.p[0][this.n_points] = d;
            double d2 = y_p;
            this.p_r[1][this.n_points] = d2;
            this.p_l[1][this.n_points] = d2;
            this.p[1][this.n_points] = d2;
            this.p_layer[this.n_points] = layer_id;
            this.p_width[this.n_points] = 0 == this.n_points ? Pipe.getFirstWidth() : this.p_width[this.n_points - 1];
            index = this.n_points;
        } else if (-1 == index) {
            double sqdist0;
            Calibration cal = this.layer_set.getCalibration();
            double lz = this.layer_set.getLayer(layer_id).getZ();
            double p0z = this.layer_set.getLayer(this.p_layer[0]).getZ();
            double pNz = this.layer_set.getLayer(this.p_layer[this.n_points - 1]).getZ();
            double sqdistN = (this.p[0][this.n_points - 1] - (double)x_p) * (this.p[0][this.n_points - 1] - (double)x_p) * cal.pixelWidth * cal.pixelWidth + (this.p[1][this.n_points - 1] - (double)y_p) * (this.p[1][this.n_points - 1] - (double)y_p) * cal.pixelHeight * cal.pixelHeight + (lz - pNz) * (lz - pNz) * cal.pixelWidth * cal.pixelWidth;
            if (sqdistN < (sqdist0 = (this.p[0][0] - (double)x_p) * (this.p[0][0] - (double)x_p) * cal.pixelWidth * cal.pixelWidth + (this.p[1][0] - (double)y_p) * (this.p[1][0] - (double)y_p) * cal.pixelHeight * cal.pixelHeight + (lz - p0z) * (lz - p0z) * cal.pixelWidth * cal.pixelWidth)) {
                double d = x_p;
                this.p_r[0][this.n_points] = d;
                this.p_l[0][this.n_points] = d;
                this.p[0][this.n_points] = d;
                double d3 = y_p;
                this.p_r[1][this.n_points] = d3;
                this.p_l[1][this.n_points] = d3;
                this.p[1][this.n_points] = d3;
                this.p_layer[this.n_points] = layer_id;
                this.p_width[this.n_points] = this.p_width[this.n_points - 1];
                index = this.n_points;
            } else {
                for (int i = this.n_points - 1; i > -1; --i) {
                    this.p[0][i + 1] = this.p[0][i];
                    this.p[1][i + 1] = this.p[1][i];
                    this.p_l[0][i + 1] = this.p_l[0][i];
                    this.p_l[1][i + 1] = this.p_l[1][i];
                    this.p_r[0][i + 1] = this.p_r[0][i];
                    this.p_r[1][i + 1] = this.p_r[1][i];
                    this.p_width[i + 1] = this.p_width[i];
                    this.p_layer[i + 1] = this.p_layer[i];
                }
                double d = x_p;
                this.p_r[0][0] = d;
                this.p_l[0][0] = d;
                this.p[0][0] = d;
                double d4 = y_p;
                this.p_r[1][0] = d4;
                this.p_l[1][0] = d4;
                this.p[1][0] = d4;
                this.p_width[0] = this.p_width[1];
                this.p_layer[0] = layer_id;
                index = 0;
            }
        } else {
            int sh_length = this.n_points - ++index;
            double[][] p_copy = new double[2][sh_length];
            double[][] p_l_copy = new double[2][sh_length];
            double[][] p_r_copy = new double[2][sh_length];
            long[] p_layer_copy = new long[sh_length];
            double[] p_width_copy = new double[sh_length];
            System.arraycopy(this.p[0], index, p_copy[0], 0, sh_length);
            System.arraycopy(this.p[1], index, p_copy[1], 0, sh_length);
            System.arraycopy(this.p_l[0], index, p_l_copy[0], 0, sh_length);
            System.arraycopy(this.p_l[1], index, p_l_copy[1], 0, sh_length);
            System.arraycopy(this.p_r[0], index, p_r_copy[0], 0, sh_length);
            System.arraycopy(this.p_r[1], index, p_r_copy[1], 0, sh_length);
            System.arraycopy(this.p_layer, index, p_layer_copy, 0, sh_length);
            System.arraycopy(this.p_width, index, p_width_copy, 0, sh_length);
            double d = x_p;
            this.p_r[0][index] = d;
            this.p_l[0][index] = d;
            this.p[0][index] = d;
            double d5 = y_p;
            this.p_r[1][index] = d5;
            this.p_l[1][index] = d5;
            this.p[1][index] = d5;
            this.p_layer[index] = layer_id;
            this.p_width[index] = this.p_width[index - 1];
            System.arraycopy(p_copy[0], 0, this.p[0], index + 1, sh_length);
            System.arraycopy(p_copy[1], 0, this.p[1], index + 1, sh_length);
            System.arraycopy(p_l_copy[0], 0, this.p_l[0], index + 1, sh_length);
            System.arraycopy(p_l_copy[1], 0, this.p_l[1], index + 1, sh_length);
            System.arraycopy(p_r_copy[0], 0, this.p_r[0], index + 1, sh_length);
            System.arraycopy(p_r_copy[1], 0, this.p_r[1], index + 1, sh_length);
            System.arraycopy(p_layer_copy, 0, this.p_layer, index + 1, sh_length);
            System.arraycopy(p_width_copy, 0, this.p_width, index + 1, sh_length);
        }
        ++this.n_points;
        return index;
    }

    protected synchronized int findClosestPoint(int x_p, int y_p, double magnification, double bezier_finess) {
        int index = -1;
        double distance_sq = Double.MAX_VALUE;
        double max = 12.0 / magnification;
        max *= max;
        for (int i = 0; i < this.p_i[0].length; ++i) {
            double distance_sq_i = (this.p_i[0][i] - (double)x_p) * (this.p_i[0][i] - (double)x_p) + (this.p_i[1][i] - (double)y_p) * (this.p_i[1][i] - (double)y_p);
            if (!(distance_sq_i < max) || !(distance_sq_i < distance_sq)) continue;
            index = i;
            distance_sq = distance_sq_i;
        }
        if (-1 != index) {
            int index_found = (int)Math.round((double)index * bezier_finess);
            if ((double)index < (double)index_found / bezier_finess) {
                --index_found;
            }
            index = index_found;
        }
        return index;
    }

    protected synchronized void generateInterpolatedPoints(double bezier_finess) {
        double[] p_width_i_copy;
        if (0 == this.n_points) {
            return;
        }
        int n = this.n_points;
        if (1 == this.n_points) {
            this.p_i = new double[2][1];
            this.p_i[0][0] = this.p[0][0];
            this.p_i[1][0] = this.p[1][0];
            this.p_width_i = new double[1];
            this.p_width_i[0] = this.p_width[0];
            return;
        }
        this.p_i = new double[2][(int)((double)n * (1.0 / bezier_finess))];
        this.p_width_i = new double[this.p_i[0].length];
        int next = 0;
        for (int i = 0; i < n - 1; ++i) {
            for (double t = 0.0; t < 1.0; t += bezier_finess) {
                double f0 = (1.0 - t) * (1.0 - t) * (1.0 - t);
                double f1 = 3.0 * t * (1.0 - t) * (1.0 - t);
                double f2 = 3.0 * t * t * (1.0 - t);
                double f3 = t * t * t;
                this.p_i[0][next] = f0 * this.p[0][i] + f1 * this.p_r[0][i] + f2 * this.p_l[0][i + 1] + f3 * this.p[0][i + 1];
                this.p_i[1][next] = f0 * this.p[1][i] + f1 * this.p_r[1][i] + f2 * this.p_l[1][i + 1] + f3 * this.p[1][i + 1];
                this.p_width_i[next] = this.p_width[i] * (1.0 - t) + this.p_width[i + 1] * t;
                if (this.p_i[0].length != ++next) continue;
                double[][] p_i_copy = new double[2][this.p_i[0].length + 5];
                double[] p_width_i_copy2 = new double[this.p_width_i.length + 5];
                System.arraycopy(this.p_i[0], 0, p_i_copy[0], 0, this.p_i[0].length);
                System.arraycopy(this.p_i[1], 0, p_i_copy[1], 0, this.p_i[1].length);
                System.arraycopy(this.p_width_i, 0, p_width_i_copy2, 0, this.p_width_i.length);
                this.p_i = p_i_copy;
                this.p_width_i = p_width_i_copy2;
            }
        }
        if (this.p_i[0].length == next) {
            double[][] p_i_copy = new double[2][this.p_i[0].length + 1];
            p_width_i_copy = new double[this.p_width_i.length + 1];
            System.arraycopy(this.p_i[0], 0, p_i_copy[0], 0, this.p_i[0].length);
            System.arraycopy(this.p_i[1], 0, p_i_copy[1], 0, this.p_i[1].length);
            System.arraycopy(this.p_width_i, 0, p_width_i_copy, 0, this.p_width_i.length);
            this.p_i = p_i_copy;
            this.p_width_i = p_width_i_copy;
        }
        this.p_i[0][next] = this.p[0][this.n_points - 1];
        this.p_i[1][next] = this.p[1][this.n_points - 1];
        this.p_width_i[next] = this.p_width[this.n_points - 1];
        if (this.p_i[0].length != ++next) {
            double[][] p_i_copy = new double[2][next];
            p_width_i_copy = new double[next];
            System.arraycopy(this.p_i[0], 0, p_i_copy[0], 0, next);
            System.arraycopy(this.p_i[1], 0, p_i_copy[1], 0, next);
            System.arraycopy(this.p_width_i, 0, p_width_i_copy, 0, next);
            this.p_i = p_i_copy;
            this.p_width_i = p_width_i_copy;
        }
    }

    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        Color above;
        Color below;
        boolean no_color_cues;
        if (0 == this.n_points) {
            return;
        }
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        Composite original_composite = null;
        if (this.alpha != 1.0f) {
            original_composite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, this.alpha));
        }
        int n_points = this.n_points;
        double[][] p = this.p;
        double[][] p_r = this.p_r;
        double[][] p_l = this.p_l;
        double[][] p_i = this.p_i;
        double[] p_width_i = this.p_width_i;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            n_points = p[0].length;
            p_l = (double[][])ob[1];
            p_r = (double[][])ob[2];
            p_i = (double[][])ob[3];
            p_width_i = (double[])ob[5];
        }
        boolean bl = no_color_cues = !this.layer_set.color_cues;
        if (this.layer_set.use_color_cue_colors) {
            below = Color.red;
            above = Color.blue;
        } else {
            below = this.color;
            above = this.color;
        }
        long layer_id = active_layer.getId();
        if (active) {
            int oval_radius = (int)Math.ceil(4.0 / magnification);
            int oval_corr = (int)Math.ceil(3.0 / magnification);
            for (int j = 0; j < n_points; ++j) {
                if (layer_id != this.p_layer[j]) continue;
                DisplayCanvas.drawHandle(g, (int)p[0][j], (int)p[1][j], magnification);
                g.setColor(this.color);
                g.fillOval((int)p_l[0][j] - oval_corr, (int)p_l[1][j] - oval_corr, oval_radius, oval_radius);
                g.fillOval((int)p_r[0][j] - oval_corr, (int)p_r[1][j] - oval_corr, oval_radius, oval_radius);
                g.drawLine((int)p[0][j], (int)p[1][j], (int)p_l[0][j], (int)p_l[1][j]);
                g.drawLine((int)p[0][j], (int)p[1][j], (int)p_r[0][j], (int)p_r[1][j]);
                if (0 != j) continue;
                Composite comp = g.getComposite();
                g.setColor(Color.white);
                g.setXORMode(Color.green);
                g.drawString("1", (int)(p[0][0] + 4.0 / magnification), (int)p[1][0]);
                g.setComposite(comp);
            }
        }
        if (n_points > 1 && p_i[0].length > 1) {
            double angle = 0.0;
            double a90 = Math.toRadians(90.0);
            int n = p_i[0].length;
            double[] r_side_x = new double[n];
            double[] r_side_y = new double[n];
            double[] l_side_x = new double[n];
            double[] l_side_y = new double[n];
            int m = n - 1;
            for (int i = 0; i < n - 1; ++i) {
                angle = Math.atan2(p_i[0][i + 1] - p_i[0][i], p_i[1][i + 1] - p_i[1][i]);
                r_side_x[i] = p_i[0][i] + Math.sin(angle + a90) * p_width_i[i];
                r_side_y[i] = p_i[1][i] + Math.cos(angle + a90) * p_width_i[i];
                l_side_x[i] = p_i[0][i] + Math.sin(angle - a90) * p_width_i[i];
                l_side_y[i] = p_i[1][i] + Math.cos(angle - a90) * p_width_i[i];
            }
            angle = Math.atan2(p_i[0][m] - p_i[0][m - 1], p_i[1][m] - p_i[1][m - 1]);
            r_side_x[m] = p_i[0][m] + Math.sin(angle + a90) * p_width_i[m];
            r_side_y[m] = p_i[1][m] + Math.cos(angle + a90) * p_width_i[m];
            l_side_x[m] = p_i[0][m] + Math.sin(angle - a90) * p_width_i[m];
            l_side_y[m] = p_i[1][m] + Math.cos(angle - a90) * p_width_i[m];
            double z_current = active_layer.getZ();
            if (no_color_cues) {
                g.setColor(this.color);
            }
            for (int j = 0; j < n_points; ++j) {
                if (no_color_cues) {
                    if (layer_id != this.p_layer[j]) {
                        if (0 == j) continue;
                        double z1 = this.layer_set.getLayer(this.p_layer[j - 1]).getZ();
                        double z2 = this.layer_set.getLayer(this.p_layer[j]).getZ();
                        if (!(z1 < z_current && z_current < z2) && (!(z2 < z_current) || !(z_current < z1))) continue;
                    }
                } else {
                    double z = this.layer_set.getLayer(this.p_layer[j]).getZ();
                    if (z < z_current) {
                        g.setColor(below);
                    } else if (z == z_current) {
                        g.setColor(this.color);
                    } else {
                        g.setColor(above);
                    }
                }
                int fi = 0;
                int la = j * 20 - 1;
                if (0 != j) {
                    fi = j * 20 - 10;
                }
                if (n_points - 1 != j) {
                    la += 10;
                }
                if (la >= r_side_x.length) {
                    la = r_side_x.length - 2;
                }
                if (fi > la) {
                    fi = la;
                }
                try {
                    for (int k = fi; k <= la; ++k) {
                        g.drawLine((int)r_side_x[k], (int)r_side_y[k], (int)r_side_x[k + 1], (int)r_side_y[k + 1]);
                        g.drawLine((int)l_side_x[k], (int)l_side_y[k], (int)l_side_x[k + 1], (int)l_side_y[k + 1]);
                    }
                    continue;
                }
                catch (Exception ee) {
                    Utils.log2("Pipe paint failed with: fi=" + fi + " la=" + la + " n_points=" + n_points + " r_side_x.length=" + r_side_x.length);
                }
            }
        }
        if (null != original_composite) {
            g.setComposite(original_composite);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void mousePressed(MouseEvent me, Layer layer, int x_p, int y_p, double mag) {
        int tool;
        if (!this.at.isIdentity()) {
            Point2D.Double po = this.inverseTransformPoint(x_p, y_p);
            x_p = (int)po.x;
            y_p = (int)po.y;
        }
        if (16 == (tool = ProjectToolbar.getToolId())) {
            index = Utils.isControlDown(me) && me.isShiftDown() ? Displayable.findNearestPoint(this.p, this.p_layer, this.n_points, x_p, y_p, layer.getId()) : this.findPoint(this.p, this.p_layer, x_p, y_p, layer.getId(), mag);
            if (-1 != index) {
                if (Utils.isControlDown(me) && me.isShiftDown() && this.p_layer[index] == Display.getFrontLayer(this.project).getId()) {
                    this.removePoint(index);
                    index_l = -1;
                    index_r = -1;
                    index = -1;
                    this.repaint(false, layer);
                    return;
                }
                last_radius = this.p_width[index];
                if (me.isAltDown()) {
                    this.resetControlPoints(index);
                    return;
                }
            }
            index_l = this.findPoint(this.p_l, this.p_layer, x_p, y_p, layer.getId(), mag);
            index_r = -1;
            if (-1 == index_l) {
                index_r = this.findPoint(this.p_r, this.p_layer, x_p, y_p, layer.getId(), mag);
            }
            long layer_id = layer.getId();
            if (-1 != index && layer_id != this.p_layer[index]) {
                index = -1;
            } else if (-1 != index_l && layer_id != this.p_layer[index_l]) {
                index_l = -1;
            } else if (-1 != index_r && layer_id != this.p_layer[index_r]) {
                index_r = -1;
            } else if (-1 == index && -1 == index_l && -1 == index_r && !me.isShiftDown() && !me.isAltDown()) {
                index_l = this.addPoint(x_p, y_p, mag, 0.05, layer_id);
                is_new_point = true;
                if (0 == index_l) {
                    index_r = index_l;
                    index_l = -1;
                }
                if (this.n_points > 1) {
                    this.generateInterpolatedPoints(0.05);
                }
                this.repaint(false, layer);
                return;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        int tool;
        if (!this.at.isIdentity()) {
            Point2D.Double p = this.inverseTransformPoint(x_p, y_p);
            x_p = (int)p.x;
            y_p = (int)p.y;
            Point2D.Double pd = this.inverseTransformPoint(x_d, y_d);
            x_d = (int)pd.x;
            y_d = (int)pd.y;
            Point2D.Double pdo = this.inverseTransformPoint(x_d_old, y_d_old);
            x_d_old = (int)pdo.x;
            y_d_old = (int)pdo.y;
        }
        if (16 == (tool = ProjectToolbar.getToolId())) {
            if (-1 != index) {
                if (!me.isAltDown() && !me.isShiftDown()) {
                    this.dragPoint(index, x_d - x_d_old, y_d - y_d_old);
                } else if (me.isShiftDown()) {
                    this.p_width[Pipe.index] = Math.sqrt(((double)x_d - this.p[0][index]) * ((double)x_d - this.p[0][index]) + ((double)y_d - this.p[1][index]) * ((double)y_d - this.p[1][index]));
                    last_radius = this.p_width[index];
                    Utils.showStatus("radius: " + this.p_width[index], false);
                } else {
                    this.dragControlPoint(index, x_d, y_d, this.p_l, this.p_r, true);
                }
                this.generateInterpolatedPoints(0.05);
                this.repaint(false, layer);
                return;
            }
            if (-1 != index_r) {
                this.dragControlPoint(index_r, x_d, y_d, this.p_r, this.p_l, is_new_point);
                this.generateInterpolatedPoints(0.05);
                this.repaint(false, layer);
                return;
            }
            if (-1 != index_l) {
                this.dragControlPoint(index_l, x_d, y_d, this.p_l, this.p_r, is_new_point);
                this.generateInterpolatedPoints(0.05);
                this.repaint(false, layer);
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        int tool = ProjectToolbar.getToolId();
        if (16 == tool) {
            this.generateInterpolatedPoints(0.05);
            this.repaint(true, layer);
        }
        if (-1 != index || -1 != index_r || -1 != index_l) {
            if (is_new_point) {
                this.updateInDatabase("points");
            } else if (-1 != index && index != this.n_points) {
                this.updateInDatabase(this.getUpdatePointForSQL(index));
            } else if (-1 != index_r) {
                this.updateInDatabase(this.getUpdateRightControlPointForSQL(index_r));
            } else if (-1 != index_l) {
                this.updateInDatabase(this.getUpdateLeftControlPointForSQL(index_l));
            } else if (index != this.n_points) {
                this.updateInDatabase("points");
            }
            this.updateInDatabase("dimensions");
        } else if (x_r != x_p || y_r != y_p) {
            this.updateInDatabase("dimensions");
        }
        this.repaint(true, layer);
        is_new_point = false;
        index_l = -1;
        index_r = -1;
        index = -1;
    }

    @Override
    protected boolean calculateBoundingBox(Layer la) {
        return this.calculateBoundingBox(true, la);
    }

    protected synchronized boolean calculateBoundingBox(boolean adjust_position, Layer la) {
        int i;
        double min_x = Double.MAX_VALUE;
        double min_y = Double.MAX_VALUE;
        double max_x = 0.0;
        double max_y = 0.0;
        if (0 == this.n_points) {
            this.height = 0.0f;
            this.width = 0.0f;
            this.updateBucket(la);
            return true;
        }
        Polygon pol = Pipe.getRawPerimeter(this.p_i, this.p_width_i);
        if (null != pol && 0 != pol.npoints) {
            for (i = 0; i < pol.npoints; ++i) {
                if ((double)pol.xpoints[i] < min_x) {
                    min_x = pol.xpoints[i];
                }
                if ((double)pol.ypoints[i] < min_y) {
                    min_y = pol.ypoints[i];
                }
                if ((double)pol.xpoints[i] > max_x) {
                    max_x = pol.xpoints[i];
                }
                if (!((double)pol.ypoints[i] > max_y)) continue;
                max_y = pol.ypoints[i];
            }
        }
        for (i = 0; i < this.n_points; ++i) {
            if (this.p_l[0][i] < min_x) {
                min_x = this.p_l[0][i];
            }
            if (this.p_r[0][i] < min_x) {
                min_x = this.p_r[0][i];
            }
            if (this.p_l[1][i] < min_y) {
                min_y = this.p_l[1][i];
            }
            if (this.p_r[1][i] < min_y) {
                min_y = this.p_r[1][i];
            }
            if (this.p_l[0][i] > max_x) {
                max_x = this.p_l[0][i];
            }
            if (this.p_r[0][i] > max_x) {
                max_x = this.p_r[0][i];
            }
            if (this.p_l[1][i] > max_y) {
                max_y = this.p_l[1][i];
            }
            if (!(this.p_r[1][i] > max_y)) continue;
            max_y = this.p_r[1][i];
        }
        this.width = (float)(max_x - min_x);
        this.height = (float)(max_y - min_y);
        if (adjust_position) {
            i = 0;
            while (i < this.n_points) {
                double[] dArray = this.p[0];
                int n = i;
                dArray[n] = dArray[n] - min_x;
                double[] dArray2 = this.p[1];
                int n2 = i;
                dArray2[n2] = dArray2[n2] - min_y;
                double[] dArray3 = this.p_l[0];
                int n3 = i;
                dArray3[n3] = dArray3[n3] - min_x;
                double[] dArray4 = this.p_l[1];
                int n4 = i;
                dArray4[n4] = dArray4[n4] - min_y;
                double[] dArray5 = this.p_r[0];
                int n5 = i;
                dArray5[n5] = dArray5[n5] - min_x;
                double[] dArray6 = this.p_r[1];
                int n6 = i++;
                dArray6[n6] = dArray6[n6] - min_y;
            }
            i = 0;
            while (i < this.p_i[0].length) {
                double[] dArray = this.p_i[0];
                int n = i;
                dArray[n] = dArray[n] - min_x;
                double[] dArray7 = this.p_i[1];
                int n7 = i++;
                dArray7[n7] = dArray7[n7] - min_y;
            }
            this.at.translate(min_x, min_y);
            this.updateInDatabase("transform");
        }
        this.updateInDatabase("dimensions");
        this.updateBucket(la);
        return true;
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.p = null;
        this.p_l = null;
        this.p_r = null;
        this.p_layer = null;
        this.p_width = null;
        this.p_i = null;
        this.p_width_i = null;
    }

    public synchronized void flush() {
        this.p = null;
        this.p_l = null;
        this.p_r = null;
        this.p_i = null;
        this.p_width = null;
        this.p_layer = null;
        this.n_points = -1;
    }

    public void repaint(boolean repaint_navigator, Layer la) {
        Rectangle box = this.getBoundingBox(null);
        this.calculateBoundingBox(true, la);
        box.add(this.getBoundingBox(null));
        Display.repaint(this.layer_set, (Displayable)this, box, 5, repaint_navigator);
    }

    private synchronized void setupForDisplay() {
        if (null == this.p || null == this.p_l || null == this.p_r) {
            ArrayList<?> al = this.project.getLoader().fetchPipePoints(this.id);
            this.n_points = al.size();
            this.p = new double[2][this.n_points];
            this.p_l = new double[2][this.n_points];
            this.p_r = new double[2][this.n_points];
            this.p_layer = new long[this.n_points];
            this.p_width = new double[this.n_points];
            Iterator<?> it = al.iterator();
            int i = 0;
            while (it.hasNext()) {
                Object[] ob = (Object[])it.next();
                this.p[0][i] = (Double)ob[0];
                this.p[1][i] = (Double)ob[1];
                this.p_r[0][i] = (Double)ob[2];
                this.p_r[1][i] = (Double)ob[3];
                this.p_l[0][i] = (Double)ob[4];
                this.p_l[1][i] = (Double)ob[5];
                this.p_width[i] = (Double)ob[6];
                this.p_layer[i] = (Long)ob[7];
                ++i;
            }
            this.generateInterpolatedPoints(0.05);
        }
    }

    private static final Polygon getRawPerimeter(double[][] p_i, double[] p_width_i) {
        int n = p_i[0].length;
        if (n < 2) {
            return null;
        }
        double angle = 0.0;
        double a90 = Math.toRadians(90.0);
        double[] r_side_x = new double[n];
        double[] r_side_y = new double[n];
        double[] l_side_x = new double[n];
        double[] l_side_y = new double[n];
        int m = n - 1;
        for (int i = 0; i < n - 1; ++i) {
            angle = Math.atan2(p_i[0][i + 1] - p_i[0][i], p_i[1][i + 1] - p_i[1][i]);
            r_side_x[i] = p_i[0][i] + Math.sin(angle + a90) * p_width_i[i];
            r_side_y[i] = p_i[1][i] + Math.cos(angle + a90) * p_width_i[i];
            l_side_x[i] = p_i[0][i] + Math.sin(angle - a90) * p_width_i[i];
            l_side_y[i] = p_i[1][i] + Math.cos(angle - a90) * p_width_i[i];
        }
        angle = Math.atan2(p_i[0][m] - p_i[0][m - 1], p_i[1][m] - p_i[1][m - 1]);
        r_side_x[m] = p_i[0][m] + Math.sin(angle + a90) * p_width_i[m];
        r_side_y[m] = p_i[1][m] + Math.cos(angle + a90) * p_width_i[m];
        l_side_x[m] = p_i[0][m] + Math.sin(angle - a90) * p_width_i[m];
        l_side_y[m] = p_i[1][m] + Math.cos(angle - a90) * p_width_i[m];
        int[] pol_x = new int[n * 2];
        int[] pol_y = new int[n * 2];
        for (int j = 0; j < n; ++j) {
            pol_x[j] = (int)r_side_x[j];
            pol_y[j] = (int)r_side_y[j];
            pol_x[n + j] = (int)l_side_x[m - j];
            pol_y[n + j] = (int)l_side_y[m - j];
        }
        return new Polygon(pol_x, pol_y, pol_x.length);
    }

    @Override
    public synchronized Polygon getPerimeter() {
        if (null == this.p_i || this.p_i[0].length < 2) {
            return new Polygon();
        }
        double[][] p_i = this.p_i;
        double[] p_width_i = this.p_width_i;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p_i = (double[][])ob[3];
            p_width_i = (double[])ob[5];
        }
        return Pipe.getRawPerimeter(p_i, p_width_i);
    }

    public synchronized void toShapesFile(StringBuffer data, String group, String color, double z_scale) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        int l = 10;
        int n_points = this.n_points;
        double[][] p = this.p;
        double[][] p_r = this.p_r;
        double[][] p_l = this.p_l;
        double[] p_width = this.p_width;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            n_points = p[0].length;
            p_l = (double[][])ob[1];
            p_r = (double[][])ob[2];
            p_width = (double[])ob[4];
        }
        data.append("type=pipe").append('\n').append("name=").append(this.project.getMeaningfulTitle(this)).append('\n').append("group=").append(group).append('\n').append("color=").append(color).append('\n').append("supergroup=").append("null").append('\n').append("supercolor=").append("null").append('\n');
        for (int i = 0; i < n_points; ++i) {
            data.append("p x=").append(p[0][i]).append('\n').append("p y=").append(p[1][i]).append('\n').append("p_r x=").append(p_r[0][i]).append('\n').append("p_r y=").append(p_r[1][i]).append('\n').append("p_l x=").append(p_l[0][i]).append('\n').append("p_l y=").append(p_l[1][i]).append('\n').append("z=").append(this.layer_set.getLayer(this.p_layer[i]).getZ() * z_scale).append('\n').append("width=").append(p_width[i]).append('\n');
        }
    }

    public synchronized String[] getPointsForSQL() {
        String[] sql = new String[this.n_points];
        for (int i = 0; i < this.n_points; ++i) {
            StringBuffer sb = new StringBuffer("INSERT INTO ab_pipe_points (pipe_id, index, x, y, x_r, y_r, x_l, y_l, width, layer_id) VALUES (");
            sb.append(this.id).append(",").append(i).append(",").append(this.p[0][i]).append(",").append(this.p[1][i]).append(",").append(this.p_r[0][i]).append(",").append(this.p_r[1][i]).append(",").append(this.p_l[0][i]).append(",").append(this.p_l[1][i]).append(",").append(this.p_width[i]).append(",").append(this.p_layer[i]).append(")");
            sql[i] = sb.toString();
        }
        return sql;
    }

    public synchronized String getUpdatePointForSQL(int index) {
        if (index < 0 || index > this.n_points - 1) {
            return null;
        }
        StringBuffer sb = new StringBuffer("UPDATE ab_pipe_points SET ");
        sb.append("x=").append(this.p[0][index]).append(", y=").append(this.p[1][index]).append(", x_r=").append(this.p_r[0][index]).append(", y_r=").append(this.p_r[1][index]).append(", x_l=").append(this.p_l[0][index]).append(", y_l=").append(this.p_l[1][index]).append(", width=").append(this.p_width[index]).append(", layer_id=").append(this.p_layer[index]).append(" WHERE pipe_id=").append(this.id).append(" AND index=").append(index);
        return sb.toString();
    }

    String getUpdateLeftControlPointForSQL(int index) {
        if (index < 0 || index > this.n_points - 1) {
            return null;
        }
        StringBuffer sb = new StringBuffer("UPDATE ab_pipe_points SET ");
        sb.append("x_l=").append(this.p_l[0][index]).append(", y_l=").append(this.p_l[1][index]).append(" WHERE pipe_id=").append(this.id).append(" AND index=").append(index);
        return sb.toString();
    }

    String getUpdateRightControlPointForSQL(int index) {
        if (index < 0 || index > this.n_points - 1) {
            return null;
        }
        StringBuffer sb = new StringBuffer("UPDATE ab_pipe_points SET ");
        sb.append("x_r=").append(this.p_r[0][index]).append(", y_r=").append(this.p_r[1][index]).append(" WHERE pipe_id=").append(this.id).append(" AND index=").append(index);
        return sb.toString();
    }

    @Override
    public boolean isDeletable() {
        return 0 == this.n_points;
    }

    @Override
    public int length() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        return this.n_points;
    }

    @Override
    public boolean contains(Layer layer, double x, double y) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return false;
        }
        Point2D.Double po = this.inverseTransformPoint(x, y);
        x = po.x;
        y = po.y;
        if (1 == this.n_points) {
            return Math.abs(this.p[0][0] - x) < 3.0 && Math.abs(this.p[1][0] - y) < 3.0;
        }
        boolean no_color_cues = "true".equals(this.project.getProperty("no_color_cues"));
        double angle = 0.0;
        double a90 = Math.toRadians(90.0);
        int n = this.p_i[0].length;
        double[] r_side_x = new double[n];
        double[] r_side_y = new double[n];
        double[] l_side_x = new double[n];
        double[] l_side_y = new double[n];
        int m = n - 1;
        for (int i = 0; i < n - 1; ++i) {
            angle = Math.atan2(this.p_i[0][i + 1] - this.p_i[0][i], this.p_i[1][i + 1] - this.p_i[1][i]);
            r_side_x[i] = this.p_i[0][i] + Math.sin(angle + a90) * this.p_width_i[i];
            r_side_y[i] = this.p_i[1][i] + Math.cos(angle + a90) * this.p_width_i[i];
            l_side_x[i] = this.p_i[0][i] + Math.sin(angle - a90) * this.p_width_i[i];
            l_side_y[i] = this.p_i[1][i] + Math.cos(angle - a90) * this.p_width_i[i];
        }
        angle = Math.atan2(this.p_i[0][m] - this.p_i[0][m - 1], this.p_i[1][m] - this.p_i[1][m - 1]);
        r_side_x[m] = this.p_i[0][m] + Math.sin(angle + a90) * this.p_width_i[m];
        r_side_y[m] = this.p_i[1][m] + Math.cos(angle + a90) * this.p_width_i[m];
        l_side_x[m] = this.p_i[0][m] + Math.sin(angle - a90) * this.p_width_i[m];
        l_side_y[m] = this.p_i[1][m] + Math.cos(angle - a90) * this.p_width_i[m];
        long layer_id = layer.getId();
        double z_current = layer.getZ();
        int first = 0;
        int last = 0;
        boolean add_pol = false;
        for (int j = 0; j < this.n_points; ++j) {
            if (!no_color_cues && layer_id != this.p_layer[j]) {
                first = j + 1;
                continue;
            }
            last = j;
            if (j == this.n_points - 1 || layer_id != this.p_layer[j + 1]) {
                add_pol = true;
            }
            int fi = 0;
            int la = 0;
            if (no_color_cues) {
                if (0 == j) continue;
                first = j - 1;
                double z1 = this.layer_set.getLayer(this.p_layer[j - 1]).getZ();
                double z2 = this.layer_set.getLayer(this.p_layer[j]).getZ();
                if (z1 == z_current && z_current == z2) {
                    add_pol = true;
                    fi = (j - 1) * 20 - 10;
                    la = j * 20 + 10;
                } else if (z1 < z_current && z_current == z2 || z1 > z_current && z_current == z2) {
                    add_pol = true;
                    fi = (j - 1) * 20 + 10;
                    la = j * 20 + 10;
                } else if (z1 == z_current && z_current < z2 || z1 == z_current && z_current > z2) {
                    add_pol = true;
                    fi = (j - 1) * 20 - 10;
                    la = j * 20 - 10;
                } else {
                    if (!(z1 < z_current && z_current < z2) && (!(z1 > z_current) || !(z_current > z2))) continue;
                    add_pol = true;
                    fi = (j - 1) * 20 + 10;
                    la = j * 20 - 10;
                }
                if (0 == j - 1) {
                    fi = 0;
                }
                if (this.n_points - 1 == j) {
                    la = this.n_points * 20;
                }
            }
            if (!add_pol) continue;
            if (!no_color_cues) {
                fi = 0;
                la = last * 20 - 1;
                if (0 != first) {
                    fi = first * 20 - 10;
                }
                if (this.n_points - 1 != last) {
                    la += 10;
                }
            } else if (fi < 0) {
                fi = 0;
            }
            if (la >= r_side_x.length) {
                la = r_side_x.length - 1;
            }
            int length = la - fi + 1;
            int[] pol_x = new int[length * 2];
            int[] pol_y = new int[length * 2];
            int k = 0;
            int g = fi;
            while (g <= la) {
                pol_x[k] = (int)r_side_x[g];
                pol_y[k] = (int)r_side_y[g];
                pol_x[length + k] = (int)l_side_x[la - k];
                pol_y[length + k] = (int)l_side_y[la - k];
                ++g;
                ++k;
            }
            Polygon pol = new Polygon(pol_x, pol_y, pol_x.length);
            if (pol.contains(x, y)) {
                return true;
            }
            first = j + 1;
            add_pol = false;
        }
        return false;
    }

    private Polygon[] getSubPerimeters(Layer layer) {
        if (this.n_points <= 1) {
            return null;
        }
        int n_points = this.n_points;
        double[][] p = this.p;
        double[][] p_i = this.p_i;
        double[] p_width_i = this.p_width_i;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            n_points = p[0].length;
            p_i = (double[][])ob[3];
            p_width_i = (double[])ob[5];
        }
        double angle = 0.0;
        double a90 = Math.toRadians(90.0);
        int n = p_i[0].length;
        double[] r_side_x = new double[n];
        double[] r_side_y = new double[n];
        double[] l_side_x = new double[n];
        double[] l_side_y = new double[n];
        int m = n - 1;
        for (int i = 0; i < n - 1; ++i) {
            angle = Math.atan2(p_i[0][i + 1] - p_i[0][i], p_i[1][i + 1] - p_i[1][i]);
            r_side_x[i] = p_i[0][i] + Math.sin(angle + a90) * p_width_i[i];
            r_side_y[i] = p_i[1][i] + Math.cos(angle + a90) * p_width_i[i];
            l_side_x[i] = p_i[0][i] + Math.sin(angle - a90) * p_width_i[i];
            l_side_y[i] = p_i[1][i] + Math.cos(angle - a90) * p_width_i[i];
        }
        angle = Math.atan2(p_i[0][m] - p_i[0][m - 1], p_i[1][m] - p_i[1][m - 1]);
        r_side_x[m] = p_i[0][m] + Math.sin(angle + a90) * p_width_i[m];
        r_side_y[m] = p_i[1][m] + Math.cos(angle + a90) * p_width_i[m];
        l_side_x[m] = p_i[0][m] + Math.sin(angle - a90) * p_width_i[m];
        l_side_y[m] = p_i[1][m] + Math.cos(angle - a90) * p_width_i[m];
        long layer_id = layer.getId();
        int first = 0;
        int last = 0;
        boolean add_pol = false;
        ArrayList<Polygon> al = new ArrayList<Polygon>();
        for (int j = 0; j < n_points; ++j) {
            if (layer_id != this.p_layer[j]) {
                first = j + 1;
                continue;
            }
            last = j;
            if (j == n_points - 1 || layer_id != this.p_layer[j + 1]) {
                add_pol = true;
            }
            if (!add_pol) continue;
            int fi = 0;
            int la = last * 20 - 1;
            if (0 != first) {
                fi = first * 20 - 10;
            }
            if (n_points - 1 != last) {
                la += 10;
            }
            int length = la - fi + 1;
            int[] pol_x = new int[length * 2];
            int[] pol_y = new int[length * 2];
            int k = 0;
            int g = fi;
            while (g <= la) {
                pol_x[k] = (int)r_side_x[g];
                pol_y[k] = (int)r_side_y[g];
                pol_x[length + k] = (int)l_side_x[la - k];
                pol_y[length + k] = (int)l_side_y[la - k];
                ++g;
                ++k;
            }
            al.add(new Polygon(pol_x, pol_y, pol_x.length));
            first = j + 1;
            add_pol = false;
        }
        if (al.isEmpty()) {
            return null;
        }
        Polygon[] pols = new Polygon[al.size()];
        al.toArray(pols);
        return pols;
    }

    @Override
    public boolean linkPatches() {
        this.unlinkAll(Patch.class);
        HashSet<Long> hs = new HashSet<Long>();
        boolean must_lock = false;
        for (int l = 0; l < this.n_points; ++l) {
            Long lo = new Long(this.p_layer[l]);
            if (hs.contains(lo)) continue;
            hs.add(lo);
            Layer layer = this.layer_set.getLayer(this.p_layer[l]);
            if (null == layer) {
                Utils.log2("Pipe.linkPatches: ignoring null layer for id " + this.p_layer[l]);
                continue;
            }
            Polygon[] perimeters = this.getSubPerimeters(layer);
            if (null == perimeters) continue;
            Rectangle box = new Rectangle();
            block1: for (Displayable displ : layer.getDisplayables(Patch.class)) {
                for (int i = 0; i < perimeters.length; ++i) {
                    if (!perimeters[i].intersects(displ.getBoundingBox(box))) continue;
                    this.link(displ);
                    if (!displ.locked) continue block1;
                    must_lock = true;
                    continue block1;
                }
            }
        }
        if (must_lock && !this.locked) {
            this.setLocked(true);
            return true;
        }
        return false;
    }

    @Override
    public Layer getFirstLayer() {
        if (0 == this.n_points) {
            return this.layer;
        }
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        Layer la = this.layer;
        double z = Double.MAX_VALUE;
        for (int i = 0; i < this.n_points; ++i) {
            Layer layer = this.layer_set.getLayer(this.p_layer[i]);
            if (!(layer.getZ() < Double.MAX_VALUE)) continue;
            la = layer;
        }
        return la;
    }

    @Override
    public synchronized void exportSVG(StringBuffer data, double z_scale, String indent) {
        int i;
        String in = indent + "\t";
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return;
        }
        String[] RGB = Utils.getHexRGBColor(this.color);
        double[] a = new double[6];
        this.at.getMatrix(a);
        data.append(indent).append("<path\n").append(in).append("type=\"pipe\"\n").append(in).append("id=\"").append(this.id).append("\"\n").append(in).append("transform=\"matrix(").append(a[0]).append(',').append(a[1]).append(',').append(a[2]).append(',').append(a[3]).append(',').append(a[4]).append(',').append(a[5]).append(")\"\n").append(in).append("style=\"fill:none;stroke-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";stroke-width:1.0px;stroke-opacity:1.0\"\n").append(in).append("d=\"M");
        for (i = 0; i < this.n_points - 1; ++i) {
            data.append(" ").append(this.p[0][i]).append(",").append(this.p[1][i]).append(" C ").append(this.p_r[0][i]).append(",").append(this.p_r[1][i]).append(" ").append(this.p_l[0][i + 1]).append(",").append(this.p_l[1][i + 1]);
        }
        data.append(" ").append(this.p[0][this.n_points - 1]).append(',').append(this.p[1][this.n_points - 1]);
        data.append("\"\n").append(in).append("z=\"");
        for (i = 0; i < this.n_points; ++i) {
            data.append(this.layer_set.getLayer(this.p_layer[i]).getZ() * z_scale).append(",");
        }
        data.append(in).append("\"\n");
        data.append(in).append("p_width=\"");
        for (i = 0; i < this.n_points; ++i) {
            data.append(this.p_width[i]).append(",");
        }
        data.append("\"\n").append(in).append("links=\"");
        if (null != this.hs_linked && 0 != this.hs_linked.size()) {
            int ii = 0;
            int len = this.hs_linked.size();
            for (Displayable d : this.hs_linked) {
                data.append(d.getId());
                if (ii != len - 1) {
                    data.append(",");
                }
                ++ii;
            }
        }
        data.append(indent).append("\"\n/>\n");
    }

    public double[][] getBackbone() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        double[][] b = new double[this.p_i[0].length][4];
        int ni = 20;
        int start = 0;
        for (int j = 0; j < this.n_points - 1; ++j) {
            double z1 = this.layer_set.getLayer(this.p_layer[j]).getZ();
            double z2 = this.layer_set.getLayer(this.p_layer[j + 1]).getZ();
            double depth = z2 - z1;
            double radius1 = this.p_width[j];
            double radius2 = this.p_width[j + 1];
            double dif = radius2 - radius1;
            int i = start;
            int k = 0;
            while (i < start + 20) {
                b[i][0] = this.p_i[0][i];
                b[i][1] = this.p_i[1][i];
                b[i][2] = z1 + (double)k * depth / 20.0;
                b[i][3] = radius1 + (double)k * dif / 20.0;
                ++i;
                ++k;
            }
            start += 20;
        }
        start = this.p_i[0].length - 1;
        b[start][0] = this.p[0][this.n_points - 1];
        b[start][1] = this.p[1][this.n_points - 1];
        b[start][2] = this.layer_set.getLayer(this.p_layer[this.n_points - 1]).getZ();
        b[start][3] = this.p_width[this.n_points - 1];
        return b;
    }

    @Override
    public void snapTo(int cx, int cy, int x_p, int y_p) {
        if (-1 == index) {
            if (-1 != index_l) {
                this.p_l[0][Pipe.index_l] = cx;
                this.p_l[1][Pipe.index_l] = cy;
            } else if (-1 != index_r) {
                this.p_r[0][Pipe.index_r] = cx;
                this.p_r[1][Pipe.index_r] = cy;
            }
        }
    }

    @Override
    public synchronized void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        sb_body.append(indent).append("<t2_pipe\n");
        String in = indent + "\t";
        super.exportXML(sb_body, in, options);
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        String[] RGB = Utils.getHexRGBColor(this.color);
        sb_body.append(in).append("style=\"fill:none;stroke-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";stroke-width:1.0px;stroke-opacity:1.0\"\n");
        if (this.n_points > 0) {
            int i;
            sb_body.append(in).append("d=\"M");
            for (i = 0; i < this.n_points - 1; ++i) {
                sb_body.append(" ").append(this.p[0][i]).append(",").append(this.p[1][i]).append(" C ").append(this.p_r[0][i]).append(",").append(this.p_r[1][i]).append(" ").append(this.p_l[0][i + 1]).append(",").append(this.p_l[1][i + 1]);
            }
            sb_body.append(" ").append(this.p[0][this.n_points - 1]).append(',').append(this.p[1][this.n_points - 1]).append("\"\n");
            sb_body.append(in).append("layer_ids=\"");
            for (i = 0; i < this.n_points; ++i) {
                sb_body.append(this.p_layer[i]);
                if (this.n_points - 1 == i) continue;
                sb_body.append(",");
            }
            sb_body.append("\"\n");
            sb_body.append(in).append("p_width=\"");
            for (i = 0; i < this.n_points; ++i) {
                sb_body.append(this.p_width[i]);
                if (this.n_points - 1 == i) continue;
                sb_body.append(",");
            }
            sb_body.append("\"\n");
        }
        sb_body.append(indent).append(">\n");
        super.restXML(sb_body, in, options);
        sb_body.append(indent).append("</t2_pipe>\n");
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_pipe";
        if (hs.contains("t2_pipe")) {
            return;
        }
        hs.add("t2_pipe");
        sb_header.append(indent).append("<!ELEMENT t2_pipe (").append(Displayable.commonDTDChildren()).append(")>\n");
        Displayable.exportDTD("t2_pipe", sb_header, hs, indent);
        sb_header.append(indent).append("<!ATTLIST ").append("t2_pipe").append(" d").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_pipe").append(" p_width").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_pipe").append(" layer_ids").append(" NMTOKEN #REQUIRED>\n");
    }

    public synchronized double[][][] generateMesh(double scale) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return null;
        }
        Utils.log2("Pipe.generateMesh is not implemented yet.");
        return null;
    }

    @Override
    public synchronized Displayable clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Pipe copy = new Pipe(pr, nid, null != this.title ? this.title.toString() : null, this.width, this.height, this.alpha, this.visible, new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()), this.locked, (AffineTransform)this.at.clone());
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        copy.n_points = this.n_points;
        copy.p = new double[][]{(double[])this.p[0].clone(), (double[])this.p[1].clone()};
        copy.p_l = new double[][]{(double[])this.p_l[0].clone(), (double[])this.p_l[1].clone()};
        copy.p_r = new double[][]{(double[])this.p_r[0].clone(), (double[])this.p_r[1].clone()};
        copy.p_layer = (long[])this.p_layer.clone();
        copy.p_width = (double[])this.p_width.clone();
        copy.p_i = new double[][]{(double[])this.p_i[0].clone(), (double[])this.p_i[1].clone()};
        copy.p_width_i = (double[])this.p_width_i.clone();
        copy.addToDatabase();
        return copy;
    }

    @Override
    public synchronized List<Point3f> generateTriangles(double scale, int parallels, int resample) {
        if (this.n_points < 2) {
            return null;
        }
        if (parallels < 3) {
            parallels = 3;
        }
        double[][][] all_points = this.generateJoints(parallels, resample, this.layer_set.getCalibrationCopy());
        return Pipe.generateTriangles(all_points, scale);
    }

    public static List<Point3f> generateTriangles(double[][][] all_points, double scale) {
        int n = all_points.length;
        int parallels = all_points[0].length - 1;
        ArrayList<Point3f> list = new ArrayList<Point3f>();
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < parallels; ++j) {
                list.add(new Point3f((float)(all_points[i][j][0] * scale), (float)(all_points[i][j][1] * scale), (float)(all_points[i][j][2] * scale)));
                list.add(new Point3f((float)(all_points[i][j + 1][0] * scale), (float)(all_points[i][j + 1][1] * scale), (float)(all_points[i][j + 1][2] * scale)));
                list.add(new Point3f((float)(all_points[i + 1][j][0] * scale), (float)(all_points[i + 1][j][1] * scale), (float)(all_points[i + 1][j][2] * scale)));
                list.add(new Point3f((float)(all_points[i + 1][j][0] * scale), (float)(all_points[i + 1][j][1] * scale), (float)(all_points[i + 1][j][2] * scale)));
                list.add(new Point3f((float)(all_points[i][j + 1][0] * scale), (float)(all_points[i][j + 1][1] * scale), (float)(all_points[i][j + 1][2] * scale)));
                list.add(new Point3f((float)(all_points[i + 1][j + 1][0] * scale), (float)(all_points[i + 1][j + 1][1] * scale), (float)(all_points[i + 1][j + 1][2] * scale)));
            }
        }
        return list;
    }

    private double[][][] generateJoints(int parallels, int resample, Calibration cal) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        int n_points = this.n_points;
        double[][] p = this.p;
        double[][] p_i = this.p_i;
        double[] p_width_i = this.p_width_i;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            n_points = p[0].length;
            p_i = (double[][])ob[3];
            p_width_i = (double[])ob[5];
        }
        int n = p_i[0].length;
        int mm = n_points;
        double[] z_values = new double[n];
        int interval_points = n / (mm - 1);
        double z_val = 0.0;
        double z_val_next = 0.0;
        double z_diff = 0.0;
        int c = 0;
        double delta = 0.0;
        for (int j = 0; j < mm - 1; ++j) {
            z_val = this.layer_set.getLayer(this.p_layer[j]).getZ();
            z_val_next = this.layer_set.getLayer(this.p_layer[j + 1]).getZ();
            z_diff = z_val_next - z_val;
            delta = z_diff / (double)interval_points;
            z_values[c] = (0 == j ? z_val : z_values[c - 1]) + delta;
            for (int k = 1; k < interval_points; ++k) {
                z_values[++c] = z_values[c - 1] + delta;
            }
            ++c;
        }
        z_values[n - 1] = this.layer_set.getLayer(this.p_layer[mm - 1]).getZ();
        return Pipe.makeTube(p_i[0], p_i[1], z_values, p_width_i, resample, parallels, cal);
    }

    public static double[][][] makeTube(double[] px, double[] py, double[] pz, double[] p_width_i, int resample, int parallels, Calibration cal) {
        int n = px.length;
        try {
            VectorString3D vs = new VectorString3D(px, py, pz, false);
            if (null != cal) {
                vs.calibrate(cal);
                int i = 0;
                while (i < p_width_i.length) {
                    int n2 = i++;
                    p_width_i[n2] = p_width_i[n2] * cal.pixelWidth;
                }
            }
            vs.addDependent(p_width_i);
            double avg_delta = vs.getAverageDelta();
            double delta = Math.max(avg_delta, 1.0);
            vs.resample(delta);
            px = vs.getPoints(0);
            py = vs.getPoints(1);
            pz = vs.getPoints(2);
            p_width_i = vs.getDependent(0);
            n = vs.length();
        }
        catch (Exception e) {
            IJError.print(e);
        }
        double[][][] all_points = new double[n + 2][parallels + 1][3];
        boolean extra = true;
        for (int cap = 0; cap < parallels + 1; ++cap) {
            all_points[0][cap][0] = px[0];
            all_points[0][cap][1] = py[0];
            all_points[0][cap][2] = pz[0];
            all_points[all_points.length - 1][cap][0] = px[n - 1];
            all_points[all_points.length - 1][cap][1] = py[n - 1];
            all_points[all_points.length - 1][cap][2] = pz[n - 1];
        }
        double angle = Math.PI * 2 / (double)parallels;
        Vector3[] circle = new Vector3[parallels + 1];
        int half_parallels = parallels / 2;
        for (int i = 0; i < n - 1; ++i) {
            double coss;
            double sinn;
            int q;
            Vector3 v3_PR;
            Vector3 v3_P12 = new Vector3(px[i + 1] - px[i], py[i + 1] - py[i], pz[i + 1] - pz[i]);
            if (v3_P12.y < 0.0) {
                v3_PR = new Vector3(v3_P12.y, -v3_P12.x, 0.0);
                v3_PR = v3_PR.normalize(v3_PR);
                circle[half_parallels] = v3_PR = v3_PR.scale(p_width_i[i], v3_PR);
                for (q = half_parallels + 1; q < parallels + 1; ++q) {
                    sinn = Math.sin(angle * (double)(q - half_parallels));
                    coss = Math.cos(angle * (double)(q - half_parallels));
                    circle[q] = Vector3.rotate_v_around_axis(v3_PR, v3_P12, sinn, coss);
                }
                circle[0] = circle[parallels];
                for (int qq = 1; qq < half_parallels; ++qq) {
                    sinn = Math.sin(angle * (double)(qq + half_parallels));
                    coss = Math.cos(angle * (double)(qq + half_parallels));
                    circle[qq] = Vector3.rotate_v_around_axis(v3_PR, v3_P12, sinn, coss);
                }
            } else {
                v3_PR = new Vector3(-v3_P12.y, v3_P12.x, 0.0);
                if (null == (v3_PR = v3_PR.normalize(v3_PR))) {
                    Utils.log2("vp_3r is null: most likely a point was repeated in the list, and thus the vector has length zero.");
                }
                circle[0] = v3_PR = v3_PR.scale(p_width_i[i], v3_PR);
                for (q = 1; q < parallels; ++q) {
                    sinn = Math.sin(angle * (double)q);
                    coss = Math.cos(angle * (double)q);
                    circle[q] = Vector3.rotate_v_around_axis(v3_PR, v3_P12, sinn, coss);
                }
                circle[parallels] = v3_PR;
            }
            for (int j = 0; j < parallels + 1; ++j) {
                all_points[i + 1][j][0] = px[i] + circle[j].x;
                all_points[i + 1][j][1] = py[i] + circle[j].y;
                all_points[i + 1][j][2] = pz[i] + circle[j].z;
            }
        }
        for (int k = 0; k < parallels + 1; ++k) {
            all_points[n - 1 + 1][k][0] = px[n - 1] + circle[k].x;
            all_points[n - 1 + 1][k][1] = py[n - 1] + circle[k].y;
            all_points[n - 1 + 1][k][2] = pz[n - 1] + circle[k].z;
        }
        return all_points;
    }

    private synchronized Object[] getTransformedData() {
        int i;
        int i2;
        int n_points = this.n_points;
        double[][] p = this.transformPoints(this.p, n_points);
        double[][] p_l = this.transformPoints(this.p_l, n_points);
        double[][] p_r = this.transformPoints(this.p_r, n_points);
        double[][] p_i = this.transformPoints(this.p_i, this.p_i[0].length);
        double[] p_width = new double[n_points];
        System.arraycopy(this.p_width, 0, p_width, 0, n_points);
        double[] p_width_i = new double[this.p_width_i.length];
        System.arraycopy(this.p_width_i, 0, p_width_i, 0, p_width_i.length);
        double[][] pw = new double[2][n_points];
        for (i2 = 0; i2 < n_points; ++i2) {
            pw[0][i2] = this.p[0][i2] + p_width[i2];
            pw[1][i2] = this.p[1][i2] + p_width[i2];
        }
        pw = this.transformPoints(pw);
        for (i2 = 0; i2 < n_points; ++i2) {
            p_width[i2] = (Math.abs(pw[0][i2] - p[0][i2]) + Math.abs(pw[1][i2] - p[1][i2])) / 2.0;
        }
        double[][] pwi = new double[2][p_i[0].length];
        for (i = 0; i < p_i[0].length; ++i) {
            pwi[0][i] = this.p_i[0][i] + p_width_i[i];
            pwi[1][i] = this.p_i[1][i] + p_width_i[i];
        }
        pwi = this.transformPoints(pwi);
        for (i = 0; i < p_i[0].length; ++i) {
            p_width_i[i] = (Math.abs(pwi[0][i] - p_i[0][i]) + Math.abs(pwi[1][i] - p_i[1][i])) / 2.0;
        }
        return new Object[]{p, p_l, p_r, p_i, p_width, p_width_i};
    }

    @Override
    public synchronized VectorString3D asVectorString3D() {
        int n_points = this.n_points;
        double[][] p = this.p;
        double[][] p_i = this.p_i;
        double[] p_width_i = this.p_width_i;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            n_points = p[0].length;
            p_i = (double[][])ob[3];
            p_width_i = (double[])ob[5];
        }
        int n = p_i[0].length;
        int mm = n_points;
        double[] z_values = new double[n];
        int interval_points = n / (mm - 1);
        double z_val = 0.0;
        double z_val_next = 0.0;
        double z_diff = 0.0;
        int c = 0;
        double delta = 0.0;
        for (int j = 0; j < mm - 1; ++j) {
            z_val = this.layer_set.getLayer(this.p_layer[j]).getZ();
            z_val_next = this.layer_set.getLayer(this.p_layer[j + 1]).getZ();
            z_diff = z_val_next - z_val;
            delta = z_diff / (double)interval_points;
            z_values[c] = (0 == j ? z_val : z_values[c - 1]) + delta;
            for (int k = 1; k < interval_points; ++k) {
                z_values[++c] = z_values[c - 1] + delta;
            }
            ++c;
        }
        z_values[n - 1] = this.layer_set.getLayer(this.p_layer[mm - 1]).getZ();
        double[] px = p_i[0];
        double[] py = p_i[1];
        double[] pz = z_values;
        VectorString3D vs = null;
        try {
            vs = new VectorString3D(px, py, pz, false);
            vs.addDependent(p_width_i);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return vs;
    }

    @Override
    public String getInfo() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        double len = 0.0;
        if (this.n_points > 1) {
            VectorString3D vs = this.asVectorString3D();
            vs.calibrate(this.layer_set.getCalibration());
            len = vs.computeLength();
        }
        return "Length: " + Utils.cutNumber(len, 2, true) + ' ' + this.layer_set.getCalibration().getUnits() + '\n';
    }

    @Override
    public boolean intersects(Area area, double z_first, double z_last) {
        int i;
        double min_z = Double.MAX_VALUE;
        double max_z = 0.0;
        for (i = 0; i < this.n_points; ++i) {
            double laz = this.layer_set.getLayer(this.p_layer[i]).getZ();
            if (laz < min_z) {
                min_z = laz;
            }
            if (!(laz > max_z)) continue;
            max_z = laz;
        }
        if (z_last < min_z || z_first > max_z) {
            return false;
        }
        for (i = 0; i < this.n_points; ++i) {
            Polygon[] pol = this.getSubPerimeters(this.layer_set.getLayer(this.p_layer[i]));
            if (null == pol) continue;
            for (int k = 0; k < pol.length; ++k) {
                Area a = new Area(pol[k]);
                a.intersect(area);
                Rectangle r = a.getBounds();
                if (0 == r.width || 0 == r.height) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(Layer layer, Rectangle r) {
        Polygon[] pol = this.getSubPerimeters(layer);
        if (null == pol) {
            return false;
        }
        for (Polygon p : pol) {
            if (!new Area(p).intersects(r.x, r.y, r.width, r.height)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(Layer layer, Area area) {
        Polygon[] pol = this.getSubPerimeters(layer);
        if (null == pol) {
            return false;
        }
        for (Polygon p : pol) {
            if (!M.intersects(new Area(p), area)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle getBounds(Rectangle r, Layer layer) {
        Polygon[] pol = this.getSubPerimeters(layer);
        if (null == pol) {
            if (null == r) {
                return new Rectangle();
            }
            r.x = 0;
            r.y = 0;
            r.width = 0;
            r.height = 0;
            return r;
        }
        Area area = new Area();
        for (Polygon p : pol) {
            area.add(new Area(p));
        }
        Rectangle b = area.getBounds();
        if (null == r) {
            return b;
        }
        r.setBounds(b.x, b.y, b.width, b.height);
        return r;
    }

    @Override
    public ResultsTable measure(ResultsTable rt) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return rt;
        }
        if (null == rt) {
            rt = Utils.createResultsTable("Pipe results", new String[]{"id", "length", "name-id"});
        }
        double len = 0.0;
        Calibration cal = this.layer_set.getCalibration();
        if (this.n_points > 1) {
            VectorString3D vs = this.asVectorString3D();
            vs.calibrate(cal);
            len = vs.computeLength();
        }
        rt.incrementCounter();
        rt.addLabel("units", cal.getUnit());
        rt.addValue(0, (double)this.id);
        rt.addValue(1, len);
        rt.addValue(2, this.getNameId());
        return rt;
    }

    @Override
    final Class<?> getInternalDataPackageClass() {
        return DPPipe.class;
    }

    @Override
    synchronized Object getDataPackage() {
        return new DPPipe(this);
    }

    public synchronized void reverse() {
        for (int i = 0; i < this.n_points / 2; ++i) {
            int j = this.n_points - 1 - i;
            Pipe._swap(this.p, i, j);
            Pipe._swap(this.p_l, i, j);
            Pipe._swap(this.p_r, i, j);
            long l = this.p_layer[i];
            this.p_layer[i] = this.p_layer[j];
            this.p_layer[j] = l;
            double r = this.p_width[i];
            this.p_width[i] = this.p_width[j];
            this.p_width[j] = r;
        }
        double[][] a = this.p_l;
        this.p_l = this.p_r;
        this.p_r = a;
        this.generateInterpolatedPoints(0.05);
    }

    private static final void _swap(double[][] a, int i, int j) {
        for (int k = 0; k < 2; ++k) {
            double tmp = a[k][i];
            a[k][i] = a[k][j];
            a[k][j] = tmp;
        }
    }

    @Override
    public synchronized boolean crop(List<Layer> range) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        HashSet<Long> lids = new HashSet<Long>();
        for (Layer l : range) {
            lids.add(l.getId());
        }
        for (int i = 0; i < this.n_points; ++i) {
            if (lids.contains(this.p_layer[i])) continue;
            this.removePoint(i);
            --i;
        }
        this.generateInterpolatedPoints(0.05);
        this.calculateBoundingBox(true, null);
        return true;
    }

    @Override
    protected synchronized boolean layerRemoved(Layer la) {
        super.layerRemoved(la);
        for (int i = 0; i < this.p_layer.length; ++i) {
            if (la.getId() != this.p_layer[i]) continue;
            this.removePoint(i);
            --i;
        }
        return true;
    }

    @Override
    public synchronized boolean apply(Layer la, Area roi, CoordinateTransform ict) throws Exception {
        double[] fp = new double[2];
        CoordinateTransform chain = null;
        Area localroi = null;
        AffineTransform inverse = null;
        for (int i = 0; i < this.n_points; ++i) {
            if (this.p_layer[i] != la.getId()) continue;
            if (null == localroi) {
                inverse = this.at.createInverse();
                localroi = roi.createTransformedArea(inverse);
            }
            if (!localroi.contains(this.p[0][i], this.p[1][i])) continue;
            if (null == chain) {
                chain = M.wrap(this.at, ict, inverse);
                fp = new double[2];
            }
            double ox = this.p[0][i];
            double oy = this.p[1][i];
            M.apply(chain, this.p, i, fp);
            fp[0] = ox + this.p_width[i];
            fp[1] = oy;
            chain.applyInPlace(fp);
            this.p_width[i] = Math.abs(fp[0] - this.p[0][i]);
            M.apply(chain, this.p_l, i, fp);
            M.apply(chain, this.p_r, i, fp);
        }
        if (null != chain) {
            this.generateInterpolatedPoints(0.05);
            this.calculateBoundingBox(true, la);
        }
        return true;
    }

    @Override
    public boolean apply(VectorDataTransform vdt) throws Exception {
        double[] fp = new double[2];
        VectorDataTransform vlocal = vdt.makeLocalTo(this);
        block0: for (int i = 0; i < this.n_points; ++i) {
            if (vdt.layer.getId() != this.p_layer[i]) continue;
            for (VectorDataTransform.ROITransform rt : vlocal.transforms) {
                if (!rt.roi.contains(this.p[0][i], this.p[1][i])) continue;
                double ox = this.p[0][i];
                double oy = this.p[1][i];
                M.apply(rt.ct, this.p, i, fp);
                fp[0] = ox + this.p_width[i];
                fp[1] = oy;
                rt.ct.applyInPlace(fp);
                this.p_width[i] = Math.abs(fp[0] - this.p[0][i]);
                M.apply(rt.ct, this.p_l, i, fp);
                M.apply(rt.ct, this.p_r, i, fp);
                continue block0;
            }
        }
        this.generateInterpolatedPoints(0.05);
        this.calculateBoundingBox(true, vlocal.layer);
        return true;
    }

    @Override
    public synchronized Collection<Long> getLayerIds() {
        return Utils.asList(this.p_layer, 0, this.n_points);
    }

    @Override
    public synchronized Area getAreaAt(Layer layer) {
        Area a = new Area();
        Polygon[] pols = this.getSubPerimeters(layer);
        if (null == pols) {
            return a;
        }
        for (Polygon pol : pols) {
            a.add(new Area(pol));
        }
        return a;
    }

    @Override
    public synchronized boolean isRoughlyInside(Layer layer, Rectangle r) {
        Polygon[] pols = this.getSubPerimeters(layer);
        if (null == pols) {
            return false;
        }
        for (Polygon pol : pols) {
            if (!pol.intersects(r)) continue;
            return true;
        }
        return false;
    }

    static {
        is_new_point = false;
    }

    private static final class DPPipe
    extends Displayable.DataPackage {
        final double[][] p;
        final double[][] p_l;
        final double[][] p_r;
        final double[][] p_i;
        final double[] p_width;
        final double[] p_width_i;
        final long[] p_layer;

        DPPipe(Pipe pipe) {
            super(pipe);
            this.p = new double[][]{Utils.copy(pipe.p[0], pipe.n_points), Utils.copy(pipe.p[1], pipe.n_points)};
            this.p_r = new double[][]{Utils.copy(pipe.p_r[0], pipe.n_points), Utils.copy(pipe.p_r[1], pipe.n_points)};
            this.p_l = new double[][]{Utils.copy(pipe.p_l[0], pipe.n_points), Utils.copy(pipe.p_l[1], pipe.n_points)};
            this.p_width = Utils.copy(pipe.p_width, pipe.n_points);
            this.p_i = new double[][]{Utils.copy(pipe.p_i[0], pipe.p_i[0].length), Utils.copy(pipe.p_i[1], pipe.p_i[0].length)};
            this.p_width_i = Utils.copy(pipe.p_width_i, pipe.p_width_i.length);
            this.p_layer = new long[pipe.n_points];
            System.arraycopy(pipe.p_layer, 0, this.p_layer, 0, pipe.n_points);
        }

        @Override
        final boolean to2(Displayable d) {
            super.to1(d);
            Pipe pipe = (Pipe)d;
            int len = this.p[0].length;
            pipe.p = new double[][]{Utils.copy(this.p[0], len), Utils.copy(this.p[1], len)};
            pipe.n_points = this.p[0].length;
            pipe.p_r = new double[][]{Utils.copy(this.p_r[0], len), Utils.copy(this.p_r[1], len)};
            pipe.p_l = new double[][]{Utils.copy(this.p_l[0], len), Utils.copy(this.p_l[1], len)};
            pipe.p_layer = new long[len];
            System.arraycopy(this.p_layer, 0, pipe.p_layer, 0, len);
            pipe.p_width = Utils.copy(this.p_width, len);
            pipe.p_i = new double[][]{Utils.copy(this.p_i[0], this.p_i[0].length), Utils.copy(this.p_i[1], this.p_i[1].length)};
            pipe.p_width_i = Utils.copy(this.p_width_i, this.p_width_i.length);
            return true;
        }
    }
}

