/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.Project;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Tag;
import ini.trakem2.display.Taggable;
import ini.trakem2.display.Tree;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import mpicbg.models.CoordinateTransform;
import org.scijava.vecmath.Point3f;

public abstract class Node<T>
implements Taggable {
    public static final byte MAX_EDGE_CONFIDENCE = 5;
    protected Node<T> parent = null;
    protected float x;
    protected float y;
    protected Color color;
    protected byte confidence = (byte)5;
    protected Layer la;
    protected Node<T>[] children = null;
    private static final Color receiver_color = Color.green.brighter();
    Object tags = null;

    public Node<T> getParent() {
        return this.parent;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setPosition(float[] p) {
        this.x = p[0];
        this.y = p[1];
    }

    public byte getConfidence() {
        return this.confidence;
    }

    public Layer getLayer() {
        return this.la;
    }

    public ArrayList<Node<T>> getChildrenNodes() {
        ArrayList<Node<T>> a = new ArrayList<Node<T>>();
        if (null == this.children) {
            return a;
        }
        for (int i = 0; i < this.children.length; ++i) {
            a.add(this.children[i]);
        }
        return a;
    }

    public Map<Node<T>, Byte> getChildren() {
        HashMap<Node<T>, Byte> m = new HashMap<Node<T>, Byte>();
        if (null == this.children) {
            return m;
        }
        for (int i = 0; i < this.children.length; ++i) {
            m.put(this.children[i], this.children[i].confidence);
        }
        return m;
    }

    public List<Byte> getEdgeConfidence() {
        ArrayList<Byte> a = new ArrayList<Byte>();
        if (null == this.children) {
            return a;
        }
        for (int i = 0; i < this.children.length; ++i) {
            a.add(this.children[i].confidence);
        }
        return a;
    }

    public byte getEdgeConfidence(Node<T> child) {
        if (null == this.children) {
            return 0;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (child != this.children[i]) continue;
            return this.children[i].confidence;
        }
        return 0;
    }

    public String toString() {
        return "{:x " + this.x + " :y " + this.y + " :layer " + this.la.getId() + '}';
    }

    public Node(float x, float y, Layer la) {
        this.x = x;
        this.y = y;
        this.la = la;
    }

    public Node(HashMap<String, String> attr) {
        this.x = Float.parseFloat(attr.get("x"));
        this.y = Float.parseFloat(attr.get("y"));
        this.la = null;
    }

    public void setLayer(Layer la) {
        this.la = la;
    }

    public final synchronized int add(Node<T> child, byte conf) {
        if (null == child) {
            return -1;
        }
        if (null != child.parent) {
            Utils.log("WARNING: tried to add a node that already had a parent!");
            return -1;
        }
        if (null != this.children) {
            for (Node<T> nd : this.children) {
                if (nd != child) continue;
                Utils.log("WARNING: tried to add a node to a parent that already had the node as a child!");
                return -1;
            }
        }
        this.enlargeArrays(1);
        this.children[this.children.length - 1] = child;
        child.confidence = conf;
        child.parent = this;
        return this.children.length - 1;
    }

    public final synchronized boolean remove(Node<T> child) {
        if (null == this.children) {
            Utils.log("WARNING: tried to remove a child from a childless node!");
            return false;
        }
        int k = -1;
        for (int i = 0; i < this.children.length; ++i) {
            if (child != this.children[i]) continue;
            k = i;
            break;
        }
        if (-1 == k) {
            Utils.log("Not a child!");
            return false;
        }
        child.parent = null;
        if (1 == this.children.length) {
            this.children = null;
            return true;
        }
        Node[] ch = new Node[this.children.length - 1];
        System.arraycopy(this.children, 0, ch, 0, k);
        System.arraycopy(this.children, k + 1, ch, k, this.children.length - k - 1);
        this.children = ch;
        return true;
    }

    private final void enlargeArrays(int n_more) {
        if (null == this.children) {
            this.children = new Node[n_more];
        } else {
            Node[] ch = new Node[this.children.length + n_more];
            System.arraycopy(this.children, 0, ch, 0, this.children.length);
            byte[] co = new byte[this.children.length + n_more];
            this.children = ch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Runnable paint(final Graphics2D g, Layer active_layer, boolean active, Rectangle srcRect, double magnification, Collection<Node<T>> to_paint, Tree<T> tree, AffineTransform to_screen, boolean with_arrows, boolean with_tags, boolean with_confidence_boxes, boolean with_data, Color above, Color below) {
        int parent_x;
        int parent_y;
        Color node_color;
        double actZ = active_layer.getZ();
        double thisZ = this.la.getZ();
        if (null == this.color) {
            node_color = tree.color;
        } else {
            node_color = this.color;
            if (tree.color == above) {
                above = this.color;
            }
            if (tree.color == below) {
                below = this.color;
            }
        }
        final Color local_edge_color = active_layer == this.la ? node_color : (actZ > thisZ ? below : (actZ < thisZ ? above : node_color));
        if (with_data) {
            this.paintData(g, srcRect, tree, to_screen, local_edge_color, active_layer);
        }
        float[] fps = new float[4];
        fps[0] = this.x;
        fps[1] = this.y;
        if (null == this.parent) {
            parent_y = 0;
            parent_x = 0;
            tree.at.transform(fps, 0, fps, 0, 1);
        } else {
            fps[2] = this.parent.x;
            fps[3] = this.parent.y;
            tree.at.transform(fps, 0, fps, 0, 2);
            parent_x = (int)((double)(fps[2] - (float)srcRect.x) * magnification);
            parent_y = (int)((double)(fps[3] - (float)srcRect.y) * magnification);
        }
        final int x = (int)((double)(fps[0] - (float)srcRect.x) * magnification);
        final int y = (int)((double)(fps[1] - (float)srcRect.y) * magnification);
        Runnable tagsTask = with_tags && null != this.tags ? new Runnable(){

            @Override
            public void run() {
                Node.this.paintTags(g, x, y, local_edge_color);
            }
        } : null;
        Node node = this;
        synchronized (node) {
            if (null != this.parent) {
                if (this.parent.la == this.la && this.la == active_layer) {
                    g.setColor(local_edge_color);
                    g.drawLine(x, y, parent_x, parent_y);
                    if (with_arrows) {
                        g.fill(M.createArrowhead(parent_x, parent_y, x, y, magnification));
                    }
                } else if (this.la == active_layer) {
                    g.setColor(local_edge_color);
                    g.drawLine(parent_x + (x - parent_x) / 2, parent_y + (y - parent_y) / 2, x, y);
                    if (with_arrows) {
                        g.fill(M.createArrowhead(parent_x, parent_y, x, y, magnification));
                    }
                    Color c = local_edge_color;
                    if (actZ < this.parent.la.getZ()) {
                        c = above;
                    } else if (actZ > this.parent.la.getZ()) {
                        c = below;
                    }
                    g.setColor(c);
                    g.drawLine(parent_x, parent_y, parent_x + (x - parent_x) / 2, parent_y + (y - parent_y) / 2);
                } else if (this.parent.la == active_layer) {
                    g.setColor(node_color);
                    g.drawLine(parent_x, parent_y, parent_x + (x - parent_x) / 2, parent_y + (y - parent_y) / 2);
                    g.setColor(local_edge_color);
                    g.drawLine(parent_x + (x - parent_x) / 2, parent_y + (y - parent_y) / 2, x, y);
                    if (with_arrows) {
                        g.fill(M.createArrowhead(parent_x, parent_y, x, y, magnification));
                    }
                } else if (thisZ < actZ && actZ < this.parent.la.getZ()) {
                    g.setColor(below);
                    g.drawLine(x, y, parent_x + (x - parent_x) / 2, parent_y + (y - parent_y) / 2);
                    if (with_arrows) {
                        g.fill(M.createArrowhead(parent_x, parent_y, x, y, magnification));
                    }
                    g.setColor(above);
                    g.drawLine(parent_x + (x - parent_x) / 2, parent_y + (y - parent_y) / 2, parent_x, parent_y);
                } else if (thisZ > actZ && actZ > this.parent.la.getZ()) {
                    g.setColor(above);
                    g.drawLine(x, y, parent_x + (x - parent_x) / 2, parent_y + (y - parent_y) / 2);
                    if (with_arrows) {
                        g.fill(M.createArrowhead(parent_x, parent_y, x, y, magnification));
                    }
                    g.setColor(below);
                    g.drawLine(parent_x + (x - parent_x) / 2, parent_y + (y - parent_y) / 2, parent_x, parent_y);
                } else if (thisZ < actZ && this.parent.la.getZ() < actZ || thisZ > actZ && this.parent.la.getZ() > actZ) {
                    g.setColor(local_edge_color);
                    if (to_paint.contains(this.parent)) {
                        g.drawLine(x, y, parent_x, parent_y);
                    } else {
                        g.drawLine(x, y, parent_x + (x - parent_x) / 2, parent_y + (y - parent_y) / 2);
                    }
                    if (with_arrows) {
                        g.fill(M.createArrowhead(parent_x, parent_y, x, y, magnification));
                    }
                }
            } else if (with_arrows && !active) {
                g.setColor(active_layer == this.la ? Color.gray : local_edge_color);
                g.fillOval(x - 6, y - 6, 11, 11);
                g.setColor(Color.black);
                g.drawString("S", x - 3, y + 4);
            }
            if (null != this.children) {
                float[] fp = new float[2];
                for (Node<T> child : this.children) {
                    if (to_paint.contains(child)) continue;
                    fp[0] = child.x;
                    fp[1] = child.y;
                    tree.at.transform(fp, 0, fp, 0, 1);
                    int cx = (int)((double)((int)fp[0] - srcRect.x) * magnification);
                    int cy = (int)((double)((int)fp[1] - srcRect.y) * magnification);
                    if (child.la == this.la) {
                        g.setColor(null == child.color ? tree.color : child.color);
                        g.drawLine(x, y, cx, cy);
                        if (!with_arrows) continue;
                        g.fill(M.createArrowhead(x, y, cx, cy, magnification));
                        continue;
                    }
                    if (child.la.getZ() < actZ) {
                        g.setColor(Color.red);
                    } else if (child.la.getZ() > actZ) {
                        g.setColor(Color.blue);
                    }
                    g.drawLine(x, y, x + (cx - x) / 2, y + (cy - y) / 2);
                }
            }
            if (null != this.parent && active && with_confidence_boxes && (active_layer == this.la || active_layer == this.parent.la || thisZ < actZ && actZ < this.parent.la.getZ())) {
                String s = Integer.toString(this.confidence);
                Dimension dim = Utils.getDimensions(s, g.getFont());
                g.setColor(Color.white);
                int xc = parent_x + (x - parent_x) / 2;
                int yc = parent_y + (y - parent_y) / 2;
                g.fillRect(xc, yc, dim.width + 2, dim.height + 2);
                g.setColor(Color.black);
                g.drawString(s, xc + 1, yc + dim.height + 1);
            }
        }
        return tagsTask;
    }

    protected void paintHandle(Graphics2D g, Rectangle srcRect, double magnification, Tree<T> t) {
        this.paintHandle(g, srcRect, magnification, t, false);
    }

    protected void paintHandle(Graphics2D g, Rectangle srcRect, double magnification, Tree<T> t, boolean paint_background) {
        Color receiver;
        Point2D.Double po = t.transformPoint(this.x, this.y);
        float x = (float)((po.x - (double)srcRect.x) * magnification);
        float y = (float)((po.y - (double)srcRect.y) * magnification);
        Color color = receiver = t.getLastVisited() == this ? receiver_color : null;
        if (null == this.parent) {
            g.setColor(null == receiver ? Color.magenta : receiver);
            g.fillOval((int)x - 6, (int)y - 6, 11, 11);
            g.setColor(Color.black);
            g.drawString("S", (int)x - 3, (int)y + 4);
        } else if (null == this.children) {
            g.setColor(null == receiver ? Color.white : receiver);
            g.fillOval((int)x - 6, (int)y - 6, 11, 11);
            g.setColor(Color.black);
            g.drawString("e", (int)x - 4, (int)y + 3);
        } else if (1 == this.children.length) {
            if (paint_background) {
                g.setColor(Color.black);
                g.fillOval((int)x - 4, (int)y - 4, 9, 9);
            }
            g.setColor(null == receiver ? (null == this.color ? t.getColor() : this.color) : receiver);
            g.fillOval((int)x - 3, (int)y - 3, 7, 7);
        } else {
            g.setColor(null == receiver ? Color.yellow : receiver);
            g.fillOval((int)x - 6, (int)y - 6, 11, 11);
            g.setColor(Color.black);
            g.drawString("Y", (int)x - 4, (int)y + 4);
        }
    }

    public final Collection<Node<T>> getSubtreeNodes() {
        return new NodeCollection(this, BreadthFirstSubtreeIterator.class);
    }

    public final Collection<Node<T>> getSlabNodes() {
        return new NodeCollection(this, SlabIterator.class);
    }

    public final Collection<Node<T>> getBranchAndEndNodes() {
        return new NodeCollection(this, BranchAndEndNodeIterator.class);
    }

    public final Collection<Node<T>> getBranchNodes() {
        return new NodeCollection(this, BranchNodeIterator.class);
    }

    public final Collection<Node<T>> getEndNodes() {
        return new NodeCollection(this, EndNodeIterator.class);
    }

    public final void translate(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public final Node<T> clone(Project pr) {
        HashMap<Long, Layer> ml;
        LinkedList<Object[]> todo = new LinkedList<Object[]>();
        Node<T> root = this.newInstance(this.x, this.y, this.la);
        root.setData(this.getDataCopy());
        root.tags = this.getTagsCopy();
        if (null != this.children) {
            todo.add(new Object[]{root, this.children});
        }
        if (pr != this.la.getProject()) {
            ml = new HashMap<Long, Layer>();
            for (Layer layer : pr.getRootLayerSet().getLayers()) {
                ml.put(layer.getId(), layer);
            }
        } else {
            ml = null;
        }
        if (null != ml) {
            root.la = (Layer)ml.get(root.la.getId());
        }
        while (!todo.isEmpty()) {
            Object[] o = (Object[])todo.removeFirst();
            Node copy = (Node)o[0];
            Node[] original_children = (Node[])o[1];
            copy.children = new Node[original_children.length];
            for (int i = 0; i < original_children.length; ++i) {
                Node ochild = original_children[i];
                copy.children[i] = this.newInstance(ochild.x, ochild.y, ochild.la);
                copy.children[i].setData(ochild.getDataCopy());
                copy.children[i].confidence = ochild.confidence;
                copy.children[i].parent = copy;
                copy.children[i].tags = ochild.getTagsCopy();
                if (null != ml) {
                    copy.children[i].la = (Layer)ml.get(copy.children[i].la.getId());
                }
                if (null == ochild.children) continue;
                todo.add(new Object[]{copy.children[i], ochild.children});
            }
        }
        return root;
    }

    final boolean isNear(float xx, float yy, float sqradius) {
        if ((double)sqradius > Math.pow(xx - this.x, 2.0) + Math.pow(yy - this.y, 2.0)) {
            return true;
        }
        if (null != this.children) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!((double)sqradius > M.distancePointToSegmentSq(xx, yy, 0.0, this.x, this.y, 0.0, (this.children[i].x + this.x) / 2.0f, (this.children[i].y + this.y) / 2.0f, 0.0))) continue;
                return true;
            }
        }
        return null != this.parent && (double)sqradius > M.distancePointToSegmentSq(xx, yy, 0.0, this.x, this.y, 0.0, (this.x + this.parent.x) / 2.0f, (this.y + this.parent.y) / 2.0f, 0.0);
    }

    public final boolean hasChildren() {
        return null != this.children && this.children.length > 0;
    }

    public final int getChildrenCount() {
        if (null == this.children) {
            return 0;
        }
        return this.children.length;
    }

    public final int computeDegree() {
        int result = 0;
        Node<T> node = this;
        while (node != null) {
            ++result;
            node = node.parent;
        }
        return result;
    }

    public static <I> List<Node<I>> findPath(Node<I> a, Node<I> b) {
        int degreeB;
        int degreeA = a.computeDegree();
        ArrayList<Node<I>> listA = new ArrayList<Node<I>>();
        ArrayList<Node<I>> listB = new ArrayList<Node<I>>();
        for (degreeB = b.computeDegree(); degreeB > degreeA; --degreeB) {
            listB.add(b);
            b = b.parent;
        }
        while (degreeA > degreeB) {
            listA.add(a);
            --degreeA;
            a = a.parent;
        }
        while (a != b) {
            listA.add(a);
            listB.add(b);
            a = a.parent;
            b = b.parent;
        }
        listA.add(a);
        ListIterator it = listB.listIterator(listB.size());
        while (it.hasPrevious()) {
            listA.add((Node<I>)it.previous());
        }
        return listA;
    }

    public HashMap<Node<T>, Integer> computeAllDegrees() {
        HashMap<Node<T>, Integer> degrees = new HashMap<Node<T>, Integer>();
        int degree = 1;
        ArrayList<Node<T>> next_level = new ArrayList<Node<T>>();
        ArrayList<Node> current_level = new ArrayList<Node>();
        current_level.add(this);
        do {
            for (Node nd : current_level) {
                degrees.put(nd, degree);
                if (null == nd.children) continue;
                for (Node<T> child : nd.children) {
                    next_level.add(child);
                }
            }
            current_level.clear();
            ArrayList<Node> tmp = current_level;
            current_level = next_level;
            next_level = tmp;
            ++degree;
        } while (!current_level.isEmpty());
        return degrees;
    }

    final void setRoot() {
        LinkedList<Node<T>> path = new LinkedList<Node<T>>();
        path.add(this);
        Node<T> parent = this.parent;
        while (null != parent) {
            path.addFirst(parent);
            parent = parent.parent;
        }
        Node newchild = (Node)path.removeFirst();
        for (Node node : path) {
            byte conf = 5;
            for (int i = 0; i < newchild.children.length; ++i) {
                if (node != newchild.children[i]) continue;
                conf = newchild.children[i].confidence;
                break;
            }
            newchild.remove(node);
            newchild.parent = null;
            node.add(newchild, conf);
            newchild = node;
        }
        this.parent = null;
    }

    public final synchronized boolean setConfidence(byte conf) {
        if (conf < 0 || conf > 5) {
            return false;
        }
        this.confidence = conf;
        return true;
    }

    public final boolean adjustConfidence(int inc) {
        byte conf = (byte)((this.confidence & 0xFF) + inc);
        if (conf < 0 || conf > 5) {
            return false;
        }
        this.confidence = conf;
        return true;
    }

    final byte getConfidence(Node<T> child) {
        if (null == this.children) {
            return -1;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (child != this.children[i]) continue;
            return this.children[i].confidence;
        }
        return -1;
    }

    final int indexOf(Node<T> child) {
        if (null == this.children) {
            return -1;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (child != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized Node<T> findPreviousBranchOrRootPoint() {
        if (null == this.parent) {
            return null;
        }
        Node<T> parent = this.parent;
        while (1 == parent.children.length) {
            if (null == parent.parent) {
                return parent;
            }
            parent = parent.parent;
        }
        return parent;
    }

    public final synchronized Node<T> findNextBranchOrEndPoint() {
        Node<T> child = this;
        while (null != child.children && child.children.length <= 1) {
            child = child.children[0];
        }
        return child;
    }

    public abstract boolean setData(T var1);

    public abstract T getData();

    public abstract T getDataCopy();

    public abstract Node<T> newInstance(float var1, float var2, Layer var3);

    public abstract void paintData(Graphics2D var1, Rectangle var2, Tree<T> var3, AffineTransform var4, Color var5, Layer var6);

    public abstract boolean intersects(Area var1);

    public boolean isRoughlyInside(Rectangle localbox) {
        if (null == this.parent) {
            return localbox.contains((int)this.x, (int)this.y);
        }
        return localbox.intersectsLine(this.parent.x, this.parent.y, this.x, this.y);
    }

    public Area getArea() {
        return new Area(new Rectangle2D.Float(this.x, this.y, 1.0f, 1.0f));
    }

    public Collection<Displayable> findLinkTargets(AffineTransform to_world) {
        float x = this.x;
        float y = this.y;
        if (null != to_world && !to_world.isIdentity()) {
            float[] fp = new float[]{x, y};
            to_world.transform(fp, 0, fp, 0, 1);
            x = fp[0];
            y = fp[1];
        }
        return this.la.find(Patch.class, (int)x, (int)y, true);
    }

    @Override
    public synchronized boolean addTag(Tag tag) {
        Tag[] t2;
        if (null == this.tags) {
            this.tags = tag;
            return true;
        }
        if (this.tags instanceof Tag[]) {
            Tag[] t1;
            for (Tag t : t1 = (Tag[])this.tags) {
                if (!t.equals(tag)) continue;
                return false;
            }
            t2 = new Tag[t1.length + 1];
            System.arraycopy(t1, 0, t2, 0, t1.length);
            t2[t2.length - 1] = tag;
        } else {
            if (tag.equals(this.tags)) {
                return false;
            }
            t2 = new Tag[]{(Tag)this.tags, tag};
        }
        ArrayList<Tag> al = new ArrayList<Tag>(t2.length);
        for (Tag t : t2) {
            al.add(t);
        }
        Collections.sort(al);
        this.tags = al.toArray(t2);
        return true;
    }

    @Override
    public synchronized boolean removeTag(Tag tag) {
        if (null == this.tags) {
            return false;
        }
        if (this.tags instanceof Tag[]) {
            Tag[] t1 = (Tag[])this.tags;
            for (int i = 0; i < t1.length; ++i) {
                if (!t1[i].equals(tag)) continue;
                if (2 == t1.length) {
                    this.tags = 0 == i ? t1[1] : t1[0];
                } else {
                    Tag[] t2 = new Tag[t1.length - 1];
                    if (0 == i) {
                        System.arraycopy(t1, 1, t2, 0, t2.length);
                    } else if (t1.length - 1 == i) {
                        System.arraycopy(t1, 0, t2, 0, t2.length);
                    } else {
                        System.arraycopy(t1, 0, t2, 0, i);
                        System.arraycopy(t1, i + 1, t2, i, t2.length - i);
                    }
                    this.tags = t2;
                }
                return true;
            }
            return false;
        }
        if (this.tags.equals(tag)) {
            this.tags = null;
        }
        return false;
    }

    protected final void copyProperties(Node<?> nd) {
        this.confidence = nd.confidence;
        this.tags = super.getTagsCopy();
    }

    private final synchronized Object getTagsCopy() {
        if (null == this.tags) {
            return null;
        }
        if (this.tags instanceof Tag) {
            return this.tags;
        }
        Tag[] t1 = (Tag[])this.tags;
        Tag[] t2 = new Tag[t1.length];
        System.arraycopy(t1, 0, t2, 0, t1.length);
        return t2;
    }

    public synchronized boolean hasTag(Tag t) {
        if (null == this.tags) {
            return false;
        }
        return this.getTags().contains(t);
    }

    @Override
    public synchronized Set<Tag> getTags() {
        if (null == this.tags) {
            return null;
        }
        TreeSet<Tag> ts = new TreeSet<Tag>();
        if (this.tags instanceof Tag[]) {
            for (Tag t : (Tag[])this.tags) {
                ts.add(t);
            }
        } else {
            ts.add((Tag)this.tags);
        }
        return ts;
    }

    @Override
    public synchronized Set<Tag> removeAllTags() {
        Set<Tag> tags = this.getTags();
        this.tags = null;
        return tags;
    }

    private void paintTags(Graphics2D g, int x, int y, Color background_color) {
        Tag[] tags;
        Tag[] tagArray;
        int ox = x + 20;
        int oy = y + 20;
        Color fontcolor = Color.blue;
        if (Color.red == background_color || Color.blue == background_color) {
            fontcolor = Color.white;
        } else {
            background_color = Taggable.TAG_BACKGROUND;
        }
        Stroke stroke = g.getStroke();
        g.setStroke(Taggable.DASHED_STROKE);
        g.setColor(background_color);
        g.drawLine(x, y, ox, oy);
        g.setStroke(stroke);
        if (this.tags instanceof Tag[]) {
            tagArray = (Tag[])this.tags;
        } else {
            Tag[] tagArray2 = new Tag[1];
            tagArray = tagArray2;
            tagArray2[0] = (Tag)this.tags;
        }
        for (Tag ob : tags = tagArray) {
            String tag = ob.toString();
            Dimension dim = Utils.getDimensions(tag, g.getFont());
            int arc = (int)((float)dim.height / 3.0f);
            RoundRectangle2D.Float rr = new RoundRectangle2D.Float(ox, oy, dim.width + 4, dim.height + 2, arc, arc);
            g.setColor(background_color);
            g.fill(rr);
            g.setColor(fontcolor);
            g.drawString(tag, ox + 2, oy + dim.height - 1);
            oy += dim.height + 3;
        }
    }

    public void apply(CoordinateTransform ct, Area roi) {
        double[] fp = new double[]{this.x, this.y};
        ct.applyInPlace(fp);
        this.x = (float)fp[0];
        this.y = (float)fp[1];
    }

    public void apply(VectorDataTransform vlocal) {
        for (VectorDataTransform.ROITransform rt : vlocal.transforms) {
            if (!rt.roi.contains(this.x, this.y)) continue;
            double[] fp = new double[]{this.x, this.y};
            rt.ct.applyInPlace(fp);
            this.x = (float)fp[0];
            this.y = (float)fp[1];
            break;
        }
    }

    public Point3f asPoint() {
        return new Point3f(this.x, this.y, (float)this.la.getZ());
    }

    protected void transformData(AffineTransform aff) {
    }

    protected final void apply(Operation<T> op, Iterator<Node<T>> nodes) throws Exception {
        while (nodes.hasNext()) {
            op.apply(nodes.next());
        }
    }

    public void applyToSubtree(Operation<T> op) throws Exception {
        this.apply(op, new BreadthFirstSubtreeIterator(this));
    }

    public void applyToSlab(Operation<T> op) throws Exception {
        this.apply(op, new SlabIterator(this));
    }

    public boolean hasSameTags(Node<?> other) {
        if (null == this.tags && null == other.tags) {
            return true;
        }
        Set<Tag> t1 = this.getTags();
        Set<Tag> t2 = other.getTags();
        if (null == t1 || null == t2) {
            return false;
        }
        t1.removeAll(t2);
        return t1.isEmpty();
    }

    public static interface Operation<I> {
        public void apply(Node<I> var1) throws Exception;
    }

    public static class NodeCollection<I>
    extends AbstractCollection<Node<I>> {
        final Node<I> first;
        final Class<?> type;

        public NodeCollection(Node<I> first, Class<?> type) {
            this.first = first;
            this.type = type;
        }

        @Override
        public Iterator<Node<I>> iterator() {
            try {
                return (Iterator)this.type.getConstructor(Node.class).newInstance(this.first);
            }
            catch (NoSuchMethodException nsme) {
                IJError.print(nsme);
            }
            catch (InvocationTargetException ite) {
                IJError.print(ite);
            }
            catch (IllegalAccessException iae) {
                IJError.print(iae);
            }
            catch (InstantiationException ie) {
                IJError.print(ie);
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return null == this.first;
        }

        @Override
        public int size() {
            int count = 0;
            Iterator<Node<I>> it = this.iterator();
            while (it.hasNext()) {
                ++count;
                it.next();
            }
            return count;
        }

        public Node<I>[] toArray() {
            Node[] a = new Node[10];
            int next = 0;
            Iterator<Node<I>> it = this.iterator();
            while (it.hasNext()) {
                if (a.length == next) {
                    Node[] b = new Node[a.length + 10];
                    System.arraycopy(a, 0, b, 0, a.length);
                    a = b;
                }
                a[next++] = it.next();
            }
            return next < a.length ? Arrays.copyOf(a, next) : a;
        }

        @Override
        public <Y> Y[] toArray(Y[] a) {
            Node<I>[] b = this.toArray();
            if (a.length < b.length) {
                return b;
            }
            System.arraycopy(b, 0, a, 0, b.length);
            if (a.length > b.length) {
                a[b.length] = null;
            }
            return a;
        }
    }

    public static class SlabIterator<I>
    extends SubtreeIterator<I> {
        public SlabIterator(Node<I> first) {
            super(first);
        }

        @Override
        public Node<I> next() {
            if (this.todo.isEmpty()) {
                this.next = null;
                return null;
            }
            Node next = (Node)this.todo.removeFirst();
            if (null == next.children || next.children.length > 1) {
                this.next = null;
                return next;
            }
            this.todo.add(next.children[0]);
            this.next = next;
            return next;
        }
    }

    public static class EndNodeIterator<I>
    extends FilteredIterator<I> {
        public EndNodeIterator(Node<I> first) {
            super(first);
        }

        @Override
        public boolean accept(Node<I> node) {
            return 0 == node.getChildrenCount();
        }
    }

    public static class BranchNodeIterator<I>
    extends FilteredIterator<I> {
        public BranchNodeIterator(Node<I> first) {
            super(first);
        }

        @Override
        public boolean accept(Node<I> node) {
            return node.getChildrenCount() > 1;
        }
    }

    public static class BranchAndEndNodeIterator<I>
    extends FilteredIterator<I> {
        public BranchAndEndNodeIterator(Node<I> first) {
            super(first);
        }

        @Override
        public boolean accept(Node<I> node) {
            return 1 != node.getChildrenCount();
        }
    }

    public static abstract class FilteredIterator<I>
    extends SubtreeIterator<I> {
        public FilteredIterator(Node<I> first) {
            super(first);
            this.prepareNext();
        }

        public abstract boolean accept(Node<I> var1);

        private final void prepareNext() {
            while (this.todo.size() > 0) {
                Node nd = (Node)this.todo.removeFirst();
                if (null != nd.children) {
                    for (int i = 0; i < nd.children.length; ++i) {
                        this.todo.add(nd.children[i]);
                    }
                }
                if (!this.accept(nd)) continue;
                this.next = nd;
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return null != this.next;
        }

        @Override
        public Node<I> next() {
            try {
                Node node = this.next;
                return node;
            }
            finally {
                this.prepareNext();
            }
        }
    }

    public static class BreadthFirstSubtreeIterator<I>
    extends SubtreeIterator<I> {
        public BreadthFirstSubtreeIterator(Node<I> first) {
            super(first);
        }

        @Override
        public Node<I> next() {
            if (this.todo.isEmpty()) {
                this.next = null;
                return null;
            }
            this.next = (Node)this.todo.removeFirst();
            if (null != this.next.children) {
                for (int i = 0; i < this.next.children.length; ++i) {
                    this.todo.add(this.next.children[i]);
                }
            }
            return this.next;
        }
    }

    public static abstract class SubtreeIterator<I>
    extends NodeIterator<I> {
        final LinkedList<Node<I>> todo = new LinkedList();

        public SubtreeIterator(Node<I> first) {
            super(first);
            this.todo.add(first);
        }

        @Override
        public boolean hasNext() {
            return this.todo.size() > 0;
        }
    }

    public static abstract class NodeIterator<I>
    implements Iterator<Node<I>> {
        Node<I> next;

        public NodeIterator(Node<I> first) {
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return null != this.next;
        }

        @Override
        public void remove() {
        }
    }
}

