/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.display.AreaContainer;
import ini.trakem2.display.Bucket;
import ini.trakem2.display.Bucketable;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.DoStep;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Overlay;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Polyline;
import ini.trakem2.display.Tag;
import ini.trakem2.display.Tree;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.imaging.LayerStack;
import ini.trakem2.parallel.Process;
import ini.trakem2.parallel.TaskFactory;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.tree.LayerThing;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class LayerSet
extends Displayable
implements Bucketable {
    public static final int NORTH = 0;
    public static final int NORTHEAST = 1;
    public static final int EAST = 2;
    public static final int SOUTHEAST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTHWEST = 5;
    public static final int WEST = 6;
    public static final int NORTHWEST = 7;
    public static final int CENTER = 8;
    public static final int R90 = 9;
    public static final int R270 = 10;
    public static final int FLIP_HORIZONTAL = 11;
    public static final int FLIP_VERTICAL = 12;
    public static final int TOP = 13;
    public static final int UP = 14;
    public static final int DOWN = 15;
    public static final int BOTTOM = 16;
    public static final String[] snapshot_modes = new String[]{"Full", "Outlines", "Disabled"};
    private int snapshots_mode = 0;
    public static final String[] ANCHORS = new String[]{"north", "north east", "east", "southeast", "south", "south west", "west", "north west", "center"};
    public static final String[] ROTATIONS = new String[]{"90 right", "90 left", "Flip horizontally", "Flip vertically"};
    private float layer_width = 5000.0f;
    private float layer_height = 5000.0f;
    private double rot_x;
    private double rot_y;
    private double rot_z;
    private final ArrayList<Layer> al_layers = new ArrayList();
    private HashMap<Long, Layer> idlayers = new HashMap();
    private final Object IDLAYERS_WRITE_LOCK = new Object();
    private final HashMap<Layer, Integer> layerindices = new HashMap();
    private Layer parent = null;
    private final ArrayList<ZDisplayable> al_zdispl = new ArrayList();
    private boolean snapshots_quality = true;
    private int max_dimension = 1024;
    private boolean virtualization_enabled = false;
    protected boolean color_cues = true;
    protected boolean area_color_cues = true;
    protected boolean use_color_cue_colors = true;
    protected boolean paint_arrows = true;
    protected boolean paint_tags = true;
    protected boolean paint_edge_confidence_boxes = true;
    protected int n_layers_color_cue = 0;
    protected boolean prepaint = false;
    protected int preload_ahead = 0;
    private Calibration calibration = new Calibration();
    private static Field sbvalue = null;
    protected HashMap<Layer, LayerBucket> lbucks = new HashMap();
    private final TreeMap<Long, DoStep> edit_history = new TreeMap();
    private long current_edit_time = 0L;
    private DoStep current_edit_step = null;
    private final Map<Displayable, TreeMap<Long, DoStep>> dedits = new HashMap<Displayable, TreeMap<Long, DoStep>>();
    private final TreeMap<Long, DoStep> redo = new TreeMap();
    private Overlay overlay = null;
    private final HashMap<DisplayCanvas.ScreenshotProperties, DisplayCanvas.Screenshot> offscreens = new HashMap();
    private final HashMap<Layer, HashSet<DisplayCanvas.Screenshot>> offscreens2 = new HashMap();
    protected final Map<Integer, HashMap<String, Tag>> tags = new HashMap<Integer, HashMap<String, Tag>>();

    protected LayerSet(Project project, long id) {
        super(project, id, null, false, null, 20.0f, 20.0f);
        Tag TODO = new Tag("TODO", 84);
        Tag UNCERTAIN_END = new Tag("Uncertain end", 85);
        HashMap<String, Tag> m1 = new HashMap<String, Tag>();
        HashMap<String, Tag> m2 = new HashMap<String, Tag>();
        m1.put(TODO.toString(), TODO);
        m2.put(UNCERTAIN_END.toString(), UNCERTAIN_END);
        this.tags.put(84, m1);
        this.tags.put(85, m2);
    }

    public LayerSet(Project project, String title, double x, double y, Layer parent, float layer_width, float layer_height) {
        super(project, title, x, y);
        Tag TODO = new Tag("TODO", 84);
        Tag UNCERTAIN_END = new Tag("Uncertain end", 85);
        HashMap<String, Tag> m1 = new HashMap<String, Tag>();
        HashMap<String, Tag> m2 = new HashMap<String, Tag>();
        m1.put(TODO.toString(), TODO);
        m2.put(UNCERTAIN_END.toString(), UNCERTAIN_END);
        this.tags.put(84, m1);
        this.tags.put(85, m2);
        this.rot_z = 0.0;
        this.rot_y = 0.0;
        this.rot_x = 0.0;
        this.width = 20.0f;
        this.height = 20.0f;
        this.parent = parent;
        this.layer_width = layer_width;
        this.layer_height = layer_height;
        this.addToDatabase();
    }

    public LayerSet(Project project, long id, String title, float width, float height, double rot_x, double rot_y, double rot_z, float layer_width, float layer_height, boolean locked, int snapshots_mode, AffineTransform at) {
        super(project, id, title, locked, at, width, height);
        Tag TODO = new Tag("TODO", 84);
        Tag UNCERTAIN_END = new Tag("Uncertain end", 85);
        HashMap<String, Tag> m1 = new HashMap<String, Tag>();
        HashMap<String, Tag> m2 = new HashMap<String, Tag>();
        m1.put(TODO.toString(), TODO);
        m2.put(UNCERTAIN_END.toString(), UNCERTAIN_END);
        this.tags.put(84, m1);
        this.tags.put(85, m2);
        this.rot_x = rot_x;
        this.rot_y = rot_y;
        this.rot_z = rot_z;
        this.layer_width = layer_width;
        this.layer_height = layer_height;
        this.snapshots_mode = snapshots_mode;
    }

    public LayerSet(Project project, long id, HashMap<String, String> ht_attributes, HashMap<Displayable, String> ht_links) {
        super(project, id, ht_attributes, ht_links);
        Tag TODO = new Tag("TODO", 84);
        Tag UNCERTAIN_END = new Tag("Uncertain end", 85);
        HashMap<String, Tag> m1 = new HashMap<String, Tag>();
        HashMap<String, Tag> m2 = new HashMap<String, Tag>();
        m1.put(TODO.toString(), TODO);
        m2.put(UNCERTAIN_END.toString(), UNCERTAIN_END);
        this.tags.put(84, m1);
        this.tags.put(85, m2);
        String data = ht_attributes.get("layer_width");
        if (null != data) {
            this.layer_width = Float.parseFloat(data);
        } else {
            this.xmlError("layer_width", Float.valueOf(this.layer_width));
        }
        data = ht_attributes.get("layer_height");
        if (null != data) {
            this.layer_height = Float.parseFloat(data);
        } else {
            this.xmlError("layer_height", Float.valueOf(this.layer_height));
        }
        data = ht_attributes.get("rot_x");
        if (null != data) {
            this.rot_x = Double.parseDouble(data);
        } else {
            this.xmlError("rot_x", this.rot_x);
        }
        data = ht_attributes.get("rot_y");
        if (null != data) {
            this.rot_y = Double.parseDouble(data);
        } else {
            this.xmlError("rot_y", this.rot_y);
        }
        data = ht_attributes.get("rot_z");
        if (null != data) {
            this.rot_y = Double.parseDouble(data);
        } else {
            this.xmlError("rot_z", this.rot_z);
        }
        data = ht_attributes.get("snapshots_quality");
        if (null != data) {
            this.snapshots_quality = Boolean.valueOf(data.trim().toLowerCase());
        }
        if (null != (data = ht_attributes.get("snapshots_mode"))) {
            String smode = data.trim();
            for (int i = 0; i < snapshot_modes.length; ++i) {
                if (!smode.equals(snapshot_modes[i])) continue;
                this.snapshots_mode = i;
                break;
            }
        }
        if (null != (data = ht_attributes.get("color_cues"))) {
            this.color_cues = Boolean.valueOf(data.trim().toLowerCase());
        }
        if (null != (data = ht_attributes.get("area_color_cues"))) {
            this.area_color_cues = Boolean.valueOf(data.trim().toLowerCase());
        }
        if (null != (data = ht_attributes.get("n_layers_color_cue"))) {
            this.n_layers_color_cue = Integer.parseInt(data.trim().toLowerCase());
            if (this.n_layers_color_cue < -1) {
                this.n_layers_color_cue = -1;
            }
        }
        if (null != (data = ht_attributes.get("avoid_color_cue_colors"))) {
            boolean bl = this.use_color_cue_colors = Boolean.valueOf(data.trim().toLowerCase()) == false;
        }
        if (null != (data = ht_attributes.get("paint_arrows"))) {
            this.paint_arrows = Boolean.valueOf(data.trim().toLowerCase());
        }
        if (null != (data = ht_attributes.get("paint_tags"))) {
            this.paint_tags = Boolean.valueOf(data.trim().toLowerCase());
        }
        if (null != (data = ht_attributes.get("paint_edge_confidence_boxes"))) {
            this.paint_edge_confidence_boxes = Boolean.valueOf(data.trim().toLowerCase());
        }
        if (null != (data = ht_attributes.get("prepaint"))) {
            this.prepaint = Boolean.valueOf(data.trim().toLowerCase());
        }
        if (null != (data = ht_attributes.get("preload_ahead"))) {
            this.preload_ahead = Integer.parseInt(data);
        }
    }

    public void setup() {
        Layer la0 = this.al_layers.get(0);
        for (ZDisplayable zd : this.al_zdispl) {
            zd.setLayer(la0);
        }
        for (Layer layer : this.al_layers) {
            for (Displayable d : layer.getDisplayables()) {
                if (d.getClass() != LayerSet.class) continue;
                ((LayerSet)d).setup();
            }
        }
    }

    public LayerSet create(Layer parent_layer) {
        if (null == parent_layer) {
            return null;
        }
        GenericDialog gd = ControlWindow.makeGenericDialog("New Layer Set");
        gd.addMessage("In pixels:");
        gd.addNumericField("width: ", (double)this.layer_width, 3);
        gd.addNumericField("height: ", (double)this.layer_height, 3);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        try {
            float width = (float)gd.getNextNumber();
            float height = (float)gd.getNextNumber();
            if (Double.isNaN(width) || Double.isNaN(height)) {
                return null;
            }
            if (0.0f == width || 0.0f == height) {
                Utils.showMessage("Cannot accept zero width or height for LayerSet dimensions.");
                return null;
            }
            return new LayerSet(this.project, "Layer Set", parent_layer.getParent().getLayerWidth() / 2.0f, parent_layer.getParent().getLayerHeight() / 2.0f, parent_layer, width / 2.0f, height / 2.0f);
        }
        catch (Exception e) {
            Utils.log("LayerSet.create: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSilently(Layer layer) {
        if (null == layer || this.al_layers.contains(layer)) {
            return;
        }
        try {
            HashMap<Layer, Integer> hashMap = this.IDLAYERS_WRITE_LOCK;
            synchronized (hashMap) {
                HashMap<Long, Layer> m = new HashMap<Long, Layer>(this.idlayers);
                m.put(layer.getId(), layer);
                this.idlayers = m;
            }
            hashMap = this.layerindices;
            synchronized (hashMap) {
                this.layerindices.clear();
            }
            double z = layer.getZ();
            int i = 0;
            for (Layer la : this.al_layers) {
                if (!(la.getZ() < z)) {
                    this.al_layers.add(i, layer);
                    layer.setParentSilently(this);
                    return;
                }
                ++i;
            }
            this.al_layers.add(layer);
            layer.setParentSilently(this);
        }
        catch (Exception e) {
            Utils.log("LayerSet.addSilently: Not a Layer, not adding DBObject id=" + layer.getId());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Layer layer) {
        Layer l;
        int i;
        if (layer.getProject() != this.project) {
            throw new IllegalArgumentException("LayerSet rejected a Layer: belongs to a different project.");
        }
        if (null != this.idlayers.get(layer.getId())) {
            return;
        }
        double z = layer.getZ();
        int n = this.al_layers.size();
        for (i = 0; i < n && (l = this.al_layers.get(i)).getZ() < z; ++i) {
        }
        if (i < n) {
            this.al_layers.add(i, layer);
        } else {
            this.al_layers.add(layer);
        }
        layer.setParent(this);
        HashMap<Layer, Integer> hashMap = this.IDLAYERS_WRITE_LOCK;
        synchronized (hashMap) {
            HashMap<Long, Layer> m = new HashMap<Long, Layer>(this.idlayers);
            m.put(layer.getId(), layer);
            this.idlayers = m;
        }
        hashMap = this.layerindices;
        synchronized (hashMap) {
            this.layerindices.clear();
        }
        Display.updateLayerScroller(this);
    }

    public void printDebugInfo() {
        Utils.log("LayerSet debug:");
        for (int i = 0; i < this.al_layers.size(); ++i) {
            Utils.log(i + " : " + this.al_layers.get(i).getZ());
        }
    }

    public Layer getParent() {
        return this.parent;
    }

    @Override
    public void setLayer(Layer layer, boolean update) {
        super.setLayer(layer, update);
        if (null != layer) {
            this.parent = layer;
        }
    }

    public void setParent(Layer layer) {
        if (null == layer || layer == this.parent) {
            return;
        }
        this.parent = layer;
        this.updateInDatabase("parent_id");
    }

    public void mousePressed(MouseEvent me, int x_p, int y_p, Rectangle srcRect, double mag) {
        if (10 != ProjectToolbar.getToolId()) {
            return;
        }
        Display.setActive(me, this);
        if (2 == me.getClickCount() && this.al_layers.size() > 0) {
            new Display(this.project, this.al_layers.get(0));
        }
    }

    public void mouseDragged(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old, Rectangle srcRect, double mag) {
        if (10 != ProjectToolbar.getToolId()) {
            return;
        }
        super.translate(x_d - x_d_old, y_d - y_d_old);
        Display.repaint(this.layer, (Displayable)this, 0);
    }

    public void mouseReleased(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r, Rectangle srcRect, double mag) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        Utils.log("LayerSet.keyPressed: not yet implemented.");
    }

    @Override
    public String toString() {
        return this.title;
    }

    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer) {
        Composite original_composite = null;
        if (this.alpha != 1.0f) {
            original_composite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, this.alpha));
        }
        AffineTransform gt = g.getTransform();
        AffineTransform aff = new AffineTransform(this.at);
        aff.preConcatenate(gt);
        g.setTransform(aff);
        g.setColor(this.color);
        g.fillRect(0, 0, (int)this.width, (int)this.height);
        g.setColor(new Color(255 - this.color.getRed(), 255 - this.color.getGreen(), 255 - this.color.getBlue()).brighter());
        int x = (int)(this.width / 5.0f);
        int y = (int)(this.height / 5.0f);
        int width = (int)(this.width / 5.0f);
        int height = (int)(this.height / 5.0f * 3.0f);
        g.fillRect(x, y, width, height);
        x = (int)(this.width / 5.0f * 2.0f);
        y = (int)(this.height / 5.0f * 3.0f);
        width = (int)(this.width / 5.0f * 2.0f);
        height = (int)(this.height / 5.0f);
        g.fillRect(x, y, width, height);
        if (this.alpha != 1.0f) {
            g.setComposite(original_composite);
        }
        g.setTransform(gt);
    }

    @Override
    public float getLayerWidth() {
        return this.layer_width;
    }

    @Override
    public float getLayerHeight() {
        return this.layer_height;
    }

    public double getRotX() {
        return this.rot_x;
    }

    public double getRotY() {
        return this.rot_y;
    }

    public double getRotZ() {
        return this.rot_z;
    }

    public int size() {
        return this.al_layers.size();
    }

    public void setRotVector(double rot_x, double rot_y, double rot_z) {
        if (Double.isNaN(rot_x) || Double.isNaN(rot_y) || Double.isNaN(rot_z)) {
            Utils.showMessage("LayerSet: Rotation vector contains NaNs. Not updating.");
            return;
        }
        if (rot_x == this.rot_x && rot_y == this.rot_y && rot_z == this.rot_z) {
            return;
        }
        this.rot_x = rot_x;
        this.rot_y = rot_y;
        this.rot_z = rot_z;
        this.updateInDatabase("rot");
    }

    public boolean setMinimumDimensions() {
        double x = Double.NaN;
        double y = Double.NaN;
        double xe = 0.0;
        double ye = 0.0;
        double tx = 0.0;
        double ty = 0.0;
        double txe = 0.0;
        double tye = 0.0;
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (int i = this.al_layers.size() - 1; i > -1; --i) {
            al.addAll(this.al_layers.get(i).getDisplayables());
        }
        al.addAll(this.al_zdispl);
        Rectangle b = new Rectangle();
        for (Displayable d : al) {
            b = d.getBoundingBox(b);
            tx = b.x;
            ty = b.y;
            if (Double.isNaN(x) || Double.isNaN(y)) {
                x = tx;
                y = ty;
            }
            txe = tx + (double)b.width;
            tye = ty + (double)b.height;
            if (tx < x) {
                x = tx;
            }
            if (ty < y) {
                y = ty;
            }
            if (txe > xe) {
                xe = txe;
            }
            if (!(tye > ye)) continue;
            ye = tye;
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            Utils.showMessage("No displayable objects, don't know how to resize the canvas and Layerset.");
            return false;
        }
        double w = xe - x;
        double h = ye - y;
        if (w <= 0.0 || h <= 0.0) {
            Utils.log("LayerSet.setMinimumDimensions: zero width or height, NOT resizing.");
            return false;
        }
        if (this.prepareStep(this)) {
            this.addEditStep(new DoResizeLayerSet(this));
        }
        if (0.0 != x || 0.0 != y) {
            this.project.getLoader().startLargeUpdate();
            try {
                AffineTransform at2 = new AffineTransform();
                at2.translate(-x, -y);
                for (Displayable d : al) {
                    d.getAffineTransform().preConcatenate(at2);
                    d.updateInDatabase("transform");
                }
                this.project.getLoader().commitLargeUpdate();
            }
            catch (Exception e) {
                IJError.print(e);
                this.project.getLoader().rollback();
                return false;
            }
        }
        if (w != (double)this.layer_width || h != (double)this.layer_height) {
            this.layer_width = (float)Math.ceil(w);
            this.layer_height = (float)Math.ceil(h);
            this.updateInDatabase("layer_dimensions");
            this.recreateBuckets(true);
            Display.update(this);
            Display.pack(this);
        }
        this.addEditStep(new DoResizeLayerSet(this));
        return true;
    }

    public synchronized void enlargeToFit(Collection<? extends Displayable> ds) {
        Rectangle r = null;
        for (Displayable displayable : ds) {
            if (null == r) {
                r = displayable.getBoundingBox();
                continue;
            }
            r.add(displayable.getBoundingBox());
        }
        if (null == r) {
            return;
        }
        r.add(this.get2DBounds());
        this.setDimensions(r.x, r.y, r.width, r.height);
    }

    public synchronized boolean enlargeToFit(Displayable d, int anchor) {
        Rectangle b;
        Rectangle r = new Rectangle(0, 0, (int)Math.ceil(this.layer_width), (int)Math.ceil(this.layer_height));
        if (r.contains(b = d.getBoundingBox(null))) {
            return false;
        }
        r.add(b);
        return this.setDimensions(r.width, r.height, anchor);
    }

    public void setDimensions(float x, float y, float layer_width, float layer_height) {
        if (this.prepareStep(this)) {
            this.addEditStep(new DoResizeLayerSet(this));
        }
        this.layer_width = layer_width;
        this.layer_height = layer_height;
        AffineTransform affine = new AffineTransform();
        affine.translate(-x, -y);
        for (ZDisplayable zd : this.al_zdispl) {
            zd.getAffineTransform().preConcatenate(affine);
            zd.updateInDatabase("transform");
        }
        for (Layer la : this.al_layers) {
            la.apply(Displayable.class, affine);
        }
        this.recreateBuckets(true);
        Display.update(this);
        this.addEditStep(new DoResizeLayerSet(this));
    }

    public boolean setDimensions(float layer_width, float layer_height, int anchor) {
        Rectangle b;
        if (Double.isNaN(layer_width) || Double.isNaN(layer_height)) {
            Utils.log("LayerSet.setDimensions: NaNs! Not adjusting.");
            return false;
        }
        if (layer_width <= 0.0f || layer_height <= 0.0f) {
            Utils.showMessage("LayerSet: can't accept zero or a minus for layer width or height");
            return false;
        }
        if (anchor < 0 || anchor > 8) {
            Utils.log("LayerSet: wrong anchor, not resizing.");
            return false;
        }
        if (this.prepareStep(this)) {
            this.addEditStep(new DoResizeLayerSet(this));
        }
        double new_x = 0.0;
        double new_y = 0.0;
        switch (anchor) {
            case 0: 
            case 4: 
            case 8: {
                new_x = (layer_width - this.layer_width) / 2.0f;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                new_x = 0.0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                new_x = layer_width - this.layer_width;
            }
        }
        switch (anchor) {
            case 2: 
            case 6: 
            case 8: {
                new_y = (layer_height - this.layer_height) / 2.0f;
                break;
            }
            case 0: 
            case 1: 
            case 7: {
                new_y = 0.0;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                new_y = layer_height - this.layer_height;
            }
        }
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (int i = this.al_layers.size() - 1; i > -1; --i) {
            al.addAll(this.al_layers.get(i).getDisplayables());
        }
        al.addAll(this.al_zdispl);
        if (layer_width < this.layer_width || layer_height < this.layer_height) {
            for (Displayable d : al) {
                b = d.getBoundingBox(null);
                double dw = b.getWidth();
                double dh = b.getHeight();
                if (!((double)b.x + dw + new_x < 0.1 * dw || (double)b.x + 0.9 * dw + new_x > (double)layer_width || (double)b.y + dh + new_y < 0.1 * dh) && !((double)b.y + 0.9 * dh + new_y > (double)layer_height)) continue;
                Utils.showMessage("Cropping " + d + "\nLayerSet: not resizing.");
                return false;
            }
        }
        this.layer_width = layer_width;
        this.layer_height = layer_height;
        if (0.0 != new_x || 0.0 != new_y) {
            for (Displayable d : al) {
                b = d.getBoundingBox(null);
                d.setLocation((double)b.x + new_x, (double)b.y + new_y);
            }
        }
        this.updateInDatabase("layer_dimensions");
        this.recreateBuckets(true);
        Display.update(this);
        Display.pack(this);
        this.addEditStep(new DoResizeLayerSet(this));
        return true;
    }

    @Override
    protected boolean remove2(boolean check) {
        if (check && !Utils.check("Really delete " + this.toString() + (null != this.al_layers && this.al_layers.size() > 0 ? " and all its children?" : ""))) {
            return false;
        }
        LayerThing lt = this.project.findLayerThing(this);
        if (null == lt) {
            return false;
        }
        return this.project.getLayerTree().remove(check, lt, null);
    }

    @Override
    public boolean remove(boolean check) {
        if (check && !Utils.check("Really delete " + this.toString() + (null != this.al_layers && this.al_layers.size() > 0 ? " and all its children?" : ""))) {
            return false;
        }
        while (0 != this.al_layers.size()) {
            if (this.al_layers.get(0).remove(false)) continue;
            Utils.showMessage("LayerSet id= " + this.id + " : Deletion incomplete, check database.");
            return false;
        }
        for (ZDisplayable zd : this.al_zdispl) {
            zd.remove(false);
        }
        if (null != this.parent) {
            this.parent.remove(this);
        }
        this.removeFromDatabase();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Layer layer) {
        if (null == layer || null == this.idlayers.get(layer.getId())) {
            return;
        }
        this.al_layers.remove(layer);
        Object object = this.IDLAYERS_WRITE_LOCK;
        synchronized (object) {
            HashMap<Long, Layer> m = new HashMap<Long, Layer>(this.idlayers);
            m.remove(layer.getId());
            this.idlayers = m;
        }
        object = this.layerindices;
        synchronized (object) {
            this.layerindices.clear();
        }
        for (ZDisplayable zd : new ArrayList<ZDisplayable>(this.al_zdispl)) {
            zd.layerRemoved(layer);
        }
        Display.updateLayerScroller(this);
        Display.updateTitle(this);
        this.removeFromOffscreens(layer);
    }

    public Layer next(Layer layer) {
        int i = this.indexOf(layer);
        if (-1 == i) {
            Utils.log("LayerSet.next: no such Layer " + layer);
            return layer;
        }
        if (this.al_layers.size() - 1 == i) {
            return layer;
        }
        return this.al_layers.get(i + 1);
    }

    public Layer previous(Layer layer) {
        int i = this.indexOf(layer);
        if (-1 == i) {
            Utils.log("LayerSet.previous: no such Layer " + layer);
            return layer;
        }
        if (0 == i) {
            return layer;
        }
        return this.al_layers.get(i - 1);
    }

    public Layer nextNonEmpty(Layer layer) {
        Layer next = layer;
        Layer given = layer;
        do {
            if ((next = this.next(layer = next)).isEmpty()) continue;
            return next;
        } while (next != layer);
        return given;
    }

    public Layer previousNonEmpty(Layer layer) {
        Layer previous = layer;
        Layer given = layer;
        do {
            if ((previous = this.previous(layer = previous)).isEmpty()) continue;
            return previous;
        } while (previous != layer);
        return given;
    }

    public int getLayerIndex(long id) {
        Layer layer = this.getLayer(id);
        if (null == layer) {
            return -1;
        }
        return this.indexOf(layer);
    }

    public Layer getLayer(int i) {
        if (i >= 0 && i < this.al_layers.size()) {
            return this.al_layers.get(i);
        }
        return null;
    }

    public Layer getLayer(long id) {
        return this.idlayers.get(id);
    }

    public Layer getLayer(Long id) {
        return this.idlayers.get(id);
    }

    public Layer getLayer(double z) {
        double error = 1.0E-7;
        for (Layer layer : this.al_layers) {
            if (!(error > Math.abs(layer.getZ() - z))) continue;
            return layer;
        }
        return null;
    }

    public Layer getNearestLayer(double z) {
        double min_dist = Double.MAX_VALUE;
        Layer closest = null;
        for (Layer layer : this.al_layers) {
            double dist = Math.abs(layer.getZ() - z);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            closest = layer;
        }
        return closest;
    }

    public Layer getLayer(double z, double thickness, boolean create) {
        Iterator<Layer> it = this.al_layers.iterator();
        Layer layer = null;
        double error = 1.0E-7;
        while (it.hasNext()) {
            Layer l = it.next();
            if (!(error > Math.abs(l.getZ() - z)) || !(error > Math.abs(l.getThickness() - thickness))) continue;
            layer = l;
        }
        if (create && null == layer && !Double.isNaN(z) && !Double.isNaN(thickness)) {
            layer = new Layer(this.project, z, thickness, this);
            this.add(layer);
            this.project.getLayerTree().addLayer(this, layer);
        }
        return layer;
    }

    public void addZDisplayable(ZDisplayable zdispl) {
        this.add(zdispl);
    }

    public void add(ZDisplayable zdispl) {
        if (null == zdispl || -1 != this.al_zdispl.indexOf(zdispl)) {
            Utils.log2("LayerSet: not adding zdispl");
            return;
        }
        if (zdispl.getProject() != this.project) {
            throw new IllegalArgumentException("LayerSet rejected a ZDisplayable: belongs to a different project.");
        }
        this.al_zdispl.add(zdispl);
        zdispl.setLayerSet(this);
        zdispl.setLayer(this.al_layers.get(0));
        zdispl.updateInDatabase("layer_set_id");
        this.addToBuckets(zdispl, this.al_zdispl.size() - 1);
        Display.add(this, zdispl);
    }

    public void addAll(Collection<? extends ZDisplayable> coll) {
        if (null == coll || 0 == coll.size()) {
            return;
        }
        for (ZDisplayable zDisplayable : coll) {
            this.al_zdispl.add(zDisplayable);
            zDisplayable.setLayerSet(this);
            zDisplayable.setLayer(this.al_layers.get(0));
            zDisplayable.updateInDatabase("layer_set_id");
        }
        this.recreateBuckets(false);
        Display.addAll(this, coll);
    }

    public void addSilently(ZDisplayable zdispl) {
        if (null == zdispl || -1 != this.al_zdispl.indexOf(zdispl)) {
            return;
        }
        try {
            zdispl.setLayer(0 == this.al_layers.size() ? null : this.al_layers.get(0));
            zdispl.setLayerSet(this, false);
            this.al_zdispl.add(zdispl);
        }
        catch (Exception e) {
            Utils.log("LayerSet.addSilently: not adding ZDisplayable with id=" + zdispl.getId());
            IJError.print(e);
            return;
        }
    }

    public boolean remove(ZDisplayable zdispl) {
        if (null == zdispl || null == this.al_zdispl) {
            return false;
        }
        int old_stack_index = this.al_zdispl.indexOf(zdispl);
        if (-1 == old_stack_index) {
            Utils.log2("LayerSet.remove: Not found: " + zdispl);
            return false;
        }
        this.al_zdispl.remove(old_stack_index);
        this.removeFromBuckets(zdispl, old_stack_index);
        this.removeFromOffscreens(zdispl);
        Display.remove(zdispl);
        return true;
    }

    public boolean removeAll(Set<ZDisplayable> zds) {
        if (null == zds || null == this.al_zdispl) {
            return false;
        }
        int count = 0;
        Iterator<ZDisplayable> it = this.al_zdispl.iterator();
        while (it.hasNext()) {
            ZDisplayable zd = it.next();
            if (!zds.contains(zd)) continue;
            it.remove();
            this.removeFromOffscreens(zd);
            Display.remove(zd);
            if (zds.size() != ++count) continue;
            break;
        }
        this.removeFromBuckets(zds);
        Display.updateVisibleTabs(this.project);
        return true;
    }

    public boolean contains(Layer layer) {
        if (null == layer) {
            return false;
        }
        return -1 != this.indexOf(layer);
    }

    public boolean contains(Displayable zdispl) {
        if (null == zdispl) {
            return false;
        }
        return -1 != this.al_zdispl.indexOf(zdispl);
    }

    public ArrayList<Layer> getLayers() {
        return new ArrayList<Layer>(this.al_layers);
    }

    public List<Layer> getLayers(int first, int last) {
        List<Layer> las = this.al_layers.subList(Math.min(first, last), Math.max(first, last) + 1);
        if (first > last) {
            ArrayList<Layer> las2 = new ArrayList<Layer>(las);
            Collections.reverse(las2);
            return las2;
        }
        return new ArrayList<Layer>(las);
    }

    public List<Layer> getLayers(Layer first, Layer last) {
        return this.getLayers(this.indexOf(first), this.indexOf(last));
    }

    public List<Layer> getColorCueLayerRange(Layer active_layer) {
        int size;
        if (this.n_layers_color_cue < 0) {
            return new ArrayList<Layer>(this.al_layers);
        }
        if (0 == this.n_layers_color_cue) {
            ArrayList<Layer> list = new ArrayList<Layer>();
            list.add(active_layer);
            return list;
        }
        int i = this.indexOf(active_layer);
        if (-1 == i) {
            Utils.log("An error ocurred: could not find an index for layer " + active_layer);
            ArrayList<Layer> a = new ArrayList<Layer>();
            a.add(active_layer);
            return a;
        }
        int first = i - this.n_layers_color_cue;
        int last = i + this.n_layers_color_cue;
        if (first < 0) {
            first = 0;
        }
        if (last >= (size = this.al_layers.size())) {
            last = size - 1;
        }
        return this.getLayers(first, last);
    }

    @Override
    public boolean isDeletable() {
        return false;
    }

    @Override
    public void setAlpha(float alpha) {
    }

    public void moveDown(Layer layer, Displayable d) {
        int i = this.indexOf(layer);
        if (this.al_layers.size() - 1 == i || -1 == i) {
            return;
        }
        layer.remove(d);
        this.al_layers.get(i + 1).add(d);
    }

    public void moveUp(Layer layer, Displayable d) {
        int i = this.indexOf(layer);
        if (0 == i || -1 == i) {
            return;
        }
        layer.remove(d);
        this.al_layers.get(i - 1).add(d);
    }

    public void move(Set<Displayable> hs_d, Layer source, Layer target) {
        if (0 == hs_d.size() || null == source || null == target || source == target) {
            return;
        }
        Display.setRepaint(false);
        for (Displayable d : hs_d) {
            if (d instanceof ZDisplayable || source != d.getLayer()) continue;
            source.remove(d);
            target.add(d, false, false);
            d.updateInDatabase("layer_id");
            Display.add(target, d, false);
        }
        Display.setRepaint(true);
        source.updateInDatabase("stack_index");
        target.updateInDatabase("stack_index");
        Display.repaint(source);
        Display.repaint(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<Displayable> setVisible(String type, boolean visible, boolean repaint) {
        type = type.toLowerCase();
        HashSet<Displayable> hs = new HashSet<Displayable>();
        try {
            this.project.getLoader().startLargeUpdate();
            if (type.equals("connector") || type.equals("treeline") || type.equals("areatree") || type.equals("pipe") || type.equals("ball") || type.equals("arealist") || type.equals("polyline") || type.equals("stack") || type.equals("dissector")) {
                for (ZDisplayable zd : this.al_zdispl) {
                    if (visible == zd.isVisible() || !zd.getClass().getName().toLowerCase().endsWith(type)) continue;
                    zd.setVisible(visible, false);
                    hs.add(zd);
                }
            } else {
                for (Layer layer : this.al_layers) {
                    hs.addAll(layer.setVisible(type, visible, false));
                }
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            this.project.getLoader().commitLargeUpdate();
        }
        if (repaint) {
            Display.repaint(this);
        }
        return hs;
    }

    public HashSet<Displayable> hideExcept(ArrayList<Class<?>> type, boolean repaint) {
        HashSet<Displayable> hs = new HashSet<Displayable>();
        for (ZDisplayable zd : this.al_zdispl) {
            if (type.contains(zd.getClass()) || !zd.isVisible()) continue;
            zd.setVisible(false, repaint);
            hs.add(zd);
        }
        for (Layer la : this.al_layers) {
            hs.addAll(la.hideExcept(type, repaint));
        }
        return hs;
    }

    public Collection<Displayable> setAllVisible(boolean repaint) {
        ArrayList<Displayable> col = new ArrayList<Displayable>();
        for (ZDisplayable zd : this.al_zdispl) {
            if (zd.isVisible()) continue;
            zd.setVisible(true, repaint);
            col.add(zd);
        }
        for (Layer la : this.al_layers) {
            col.addAll(la.setAllVisible(repaint));
        }
        return col;
    }

    public boolean contains(Class<?> c) {
        for (ZDisplayable zd : this.al_zdispl) {
            if (zd.getClass() != c) continue;
            return true;
        }
        return false;
    }

    public boolean containsDisplayable(Class<?> c) {
        for (Layer layer : this.al_layers) {
            if (!layer.contains(c)) continue;
            return true;
        }
        return false;
    }

    public double getDepth() {
        if (null == this.al_layers || this.al_layers.isEmpty()) {
            return 0.0;
        }
        return this.al_layers.get(this.al_layers.size() - 1).getZ() - this.al_layers.get(0).getZ();
    }

    public ArrayList<Displayable> getDisplayables() {
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (Layer layer : this.al_layers) {
            al.addAll(layer.getDisplayables());
        }
        return al;
    }

    public ArrayList<Displayable> getDisplayables(Class<?> c) {
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (Layer layer : this.al_layers) {
            al.addAll(layer.getDisplayables(c));
        }
        return al;
    }

    public ArrayList<Displayable> getDisplayables(Class<?> c, Area aroi, boolean visible_only) {
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (Layer layer : this.al_layers) {
            al.addAll(layer.getDisplayables(c, aroi, visible_only));
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Layer layer) {
        HashMap<Layer, Integer> hashMap = this.layerindices;
        synchronized (hashMap) {
            Integer i = this.layerindices.get(layer);
            if (null == i) {
                this.layerindices.clear();
                int k = 0;
                for (Layer la : this.al_layers) {
                    this.layerindices.put(la, k);
                    ++k;
                }
                i = this.layerindices.get(layer);
                if (null == i) {
                    Utils.log("ERROR: could not find an index for layer " + layer);
                    return -1;
                }
            }
            return i;
        }
    }

    public void exportXML(Writer writer, String indent, XMLOptions options) throws Exception {
        StringBuilder sb_body = new StringBuilder(512);
        sb_body.append(indent).append("<t2_layer_set\n");
        String in = indent + "\t";
        super.exportXML(sb_body, in, options);
        sb_body.append(in).append("layer_width=\"").append(this.layer_width).append("\"\n").append(in).append("layer_height=\"").append(this.layer_height).append("\"\n").append(in).append("rot_x=\"").append(this.rot_x).append("\"\n").append(in).append("rot_y=\"").append(this.rot_y).append("\"\n").append(in).append("rot_z=\"").append(this.rot_z).append("\"\n").append(in).append("snapshots_quality=\"").append(this.snapshots_quality).append("\"\n").append(in).append("snapshots_mode=\"").append(snapshot_modes[this.snapshots_mode]).append("\"\n").append(in).append("color_cues=\"").append(this.color_cues).append("\"\n").append(in).append("area_color_cues=\"").append(this.area_color_cues).append("\"\n").append(in).append("avoid_color_cue_colors=\"").append(!this.use_color_cue_colors).append("\"\n").append(in).append("n_layers_color_cue=\"").append(this.n_layers_color_cue).append("\"\n").append(in).append("paint_arrows=\"").append(this.paint_arrows).append("\"\n").append(in).append("paint_tags=\"").append(this.paint_tags).append("\"\n").append(in).append("paint_edge_confidence_boxes=\"").append(this.paint_edge_confidence_boxes).append("\"\n").append(in).append("prepaint=\"").append(this.prepaint).append("\"\n").append(in).append("preload_ahead=\"").append(this.preload_ahead).append("\"\n");
        sb_body.append(indent).append(">\n");
        if (null != this.calibration) {
            sb_body.append(in).append("<t2_calibration\n").append(in).append("\tpixelWidth=\"").append(this.calibration.pixelWidth).append("\"\n").append(in).append("\tpixelHeight=\"").append(this.calibration.pixelHeight).append("\"\n").append(in).append("\tpixelDepth=\"").append(this.calibration.pixelDepth).append("\"\n").append(in).append("\txOrigin=\"").append(this.calibration.xOrigin).append("\"\n").append(in).append("\tyOrigin=\"").append(this.calibration.yOrigin).append("\"\n").append(in).append("\tzOrigin=\"").append(this.calibration.zOrigin).append("\"\n").append(in).append("\tinfo=\"").append(this.calibration.info).append("\"\n").append(in).append("\tvalueUnit=\"").append(this.calibration.getValueUnit()).append("\"\n").append(in).append("\ttimeUnit=\"").append(this.calibration.getTimeUnit()).append("\"\n").append(in).append("\tunit=\"").append(this.calibration.getUnit()).append("\"\n").append(in).append("/>\n");
        }
        if (null == sbvalue) {
            writer.write(sb_body.toString());
        } else {
            writer.write((char[])sbvalue.get(sb_body), 0, sb_body.length());
        }
        int done = 0;
        int total = 0;
        total += this.al_zdispl.size();
        for (Layer la : this.al_layers) {
            total += la.getDisplayableList().size();
        }
        if (null != this.al_zdispl) {
            for (ZDisplayable zd : this.al_zdispl) {
                sb_body.setLength(0);
                zd.exportXML(sb_body, in, options);
                if (null == sbvalue) {
                    writer.write(sb_body.toString());
                    continue;
                }
                writer.write((char[])sbvalue.get(sb_body), 0, sb_body.length());
            }
            Utils.showProgress((double)(done += this.al_zdispl.size()) / (double)total);
        }
        if (null != this.al_layers) {
            for (Layer la : this.al_layers) {
                sb_body.setLength(0);
                la.exportXML(sb_body, in, options);
                if (null == sbvalue) {
                    writer.write(sb_body.toString());
                } else {
                    writer.write((char[])sbvalue.get(sb_body), 0, sb_body.length());
                }
                Utils.showProgress((double)(done += la.getDisplayableList().size()) / (double)total);
            }
        }
        sb_body.setLength(0);
        if (sb_body.length() > 0) {
            super.restXML(sb_body, in, options);
            if (null == sbvalue) {
                writer.write(sb_body.toString());
            } else {
                writer.write((char[])sbvalue.get(sb_body), 0, sb_body.length());
            }
        }
        writer.write(indent + "</t2_layer_set>\n");
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_layer_set";
        if (!hs.contains("t2_layer_set")) {
            sb_header.append(indent).append("<!ELEMENT t2_layer_set (").append(Displayable.commonDTDChildren()).append(",t2_layer,t2_pipe,t2_ball,t2_area_list,t2_calibration,t2_stack,t2_treeline)>\n");
            Displayable.exportDTD("t2_layer_set", sb_header, hs, indent);
            sb_header.append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" layer_width").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" layer_height").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" rot_x").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" rot_y").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" rot_z").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" snapshots_quality").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" color_cues").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" area_color_cues").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" avoid_color_cue_colors").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" n_layers_color_cue").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" paint_arrows").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" paint_tags").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" paint_edge_confidence_boxes").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer_set").append(" preload_ahead").append(" NMTOKEN #REQUIRED>\n");
            sb_header.append(indent).append("<!ELEMENT t2_calibration EMPTY>\n").append(indent).append("<!ATTLIST ").append("t2_calibration pixelWidth").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_calibration pixelHeight").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_calibration pixelDepth").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_calibration xOrigin").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_calibration yOrigin").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_calibration zOrigin").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_calibration info").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_calibration valueUnit").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_calibration timeUnit").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_calibration unit").append(" NMTOKEN #REQUIRED>\n");
        }
    }

    public void setSnapshotsMode(int mode) {
        if (mode == this.snapshots_mode) {
            return;
        }
        this.snapshots_mode = mode;
        Display.repaintSnapshots(this);
        this.updateInDatabase("snapshots_mode");
    }

    public int getSnapshotsMode() {
        return this.snapshots_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        for (Layer layer : this.al_layers) {
            layer.destroy();
        }
        for (ZDisplayable zd : this.al_zdispl) {
            zd.destroy();
        }
        this.al_layers.clear();
        this.al_zdispl.clear();
        HashMap<Layer, Integer> hashMap = this.IDLAYERS_WRITE_LOCK;
        synchronized (hashMap) {
            this.idlayers = new HashMap();
        }
        hashMap = this.layerindices;
        synchronized (hashMap) {
            this.layerindices.clear();
        }
        this.offscreens.clear();
    }

    protected void reposition(Layer layer) {
        if (null == layer || !this.idlayers.containsKey(layer.getId())) {
            return;
        }
        this.al_layers.remove(layer);
        this.addSilently(layer);
    }

    public ArrayList<Layer> getNeighborLayers(Layer layer, int n) {
        int i;
        int end;
        int i_layer = this.indexOf(layer);
        ArrayList<Layer> al = new ArrayList<Layer>();
        if (-1 == i_layer) {
            return al;
        }
        int start = i_layer - n;
        if (start < 0) {
            start = 0;
        }
        if ((end = i_layer + n) > this.al_layers.size()) {
            end = this.al_layers.size();
        }
        for (i = start; i < i_layer; ++i) {
            al.add(this.al_layers.get(i));
        }
        for (i = i_layer + 1; i <= i_layer + n || i < end; ++i) {
            al.add(this.al_layers.get(i));
        }
        return al;
    }

    public boolean isTop(ZDisplayable zd) {
        return null != zd && this.al_zdispl.size() > 0 && this.al_zdispl.indexOf(zd) == this.al_zdispl.size() - 1;
    }

    public boolean isBottom(ZDisplayable zd) {
        return null != zd && this.al_zdispl.size() > 0 && this.al_zdispl.indexOf(zd) == 0;
    }

    protected boolean isTop(Displayable d) {
        if (d instanceof ZDisplayable) {
            return this.isTop((ZDisplayable)d);
        }
        return d.getLayer().isTop(d);
    }

    protected boolean isBottom(Displayable d) {
        if (d instanceof ZDisplayable) {
            return this.isBottom((ZDisplayable)d);
        }
        return d.getLayer().isBottom(d);
    }

    protected synchronized void move(int place, Displayable d) {
        if (d instanceof ZDisplayable) {
            int i = this.al_zdispl.indexOf(d);
            if (-1 == i) {
                Utils.log("LayerSet.move: object does not belong here");
                return;
            }
            int size = this.al_zdispl.size();
            if (1 == size) {
                return;
            }
            switch (place) {
                case 13: {
                    this.al_zdispl.add(this.al_zdispl.remove(i));
                    this.updateRangeInBuckets(d, i, this.al_zdispl.size() - 1);
                    break;
                }
                case 14: {
                    if (size - 1 == i) {
                        return;
                    }
                    this.al_zdispl.add(i + 1, this.al_zdispl.remove(i));
                    this.updateRangeInBuckets(d, i, i + 1);
                    break;
                }
                case 15: {
                    if (0 == i) {
                        return;
                    }
                    this.al_zdispl.add(i - 1, this.al_zdispl.remove(i));
                    this.updateRangeInBuckets(d, i - 1, i);
                    break;
                }
                case 16: {
                    this.al_zdispl.add(0, this.al_zdispl.remove(i));
                    this.updateRangeInBuckets(d, 0, i);
                }
            }
            this.updateInDatabase("stack_index");
            Display.updatePanelIndex(d.getLayer(), d);
        } else {
            switch (place) {
                case 13: {
                    d.getLayer().moveTop(d);
                    break;
                }
                case 14: {
                    d.getLayer().moveUp(d);
                    break;
                }
                case 15: {
                    d.getLayer().moveDown(d);
                    break;
                }
                case 16: {
                    d.getLayer().moveBottom(d);
                }
            }
        }
    }

    public int indexOf(ZDisplayable zd) {
        int k = this.al_zdispl.indexOf(zd);
        if (-1 == k) {
            return -1;
        }
        return this.al_zdispl.size() - k - 1;
    }

    public boolean isEmptyAt(Layer layer) {
        for (ZDisplayable zd : this.al_zdispl) {
            if (!zd.paintsAt(layer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Displayable clone(Project pr, boolean copy_id) {
        Rectangle roi = new Rectangle(0, 0, (int)Math.ceil(this.getLayerWidth()), (int)Math.ceil(this.getLayerHeight()));
        LayerSet copy = (LayerSet)this.clone(pr, this.al_layers.get(0), this.al_layers.get(this.al_layers.size() - 1), roi, false, copy_id, false);
        try {
            LayerSet.cloneInto(this, this.al_layers.get(0), this.al_layers.get(this.al_layers.size() - 1), pr, copy, roi, copy_id);
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        return copy;
    }

    public Displayable clone(Project pr, Layer first, Layer last, Rectangle roi, boolean add_to_tree, boolean copy_id, boolean ignore_hidden_patches) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        LayerSet copy = new LayerSet(pr, nid, this.getTitle(), this.width, this.height, this.rot_x, this.rot_y, this.rot_z, roi.width, roi.height, this.locked, this.snapshots_mode, (AffineTransform)this.at.clone());
        copy.setCalibration(this.getCalibrationCopy());
        copy.snapshots_quality = this.snapshots_quality;
        List<Layer> range = new ArrayList<Layer>(this.al_layers).subList(this.indexOf(first), this.indexOf(last) + 1);
        Utils.log2("range.size() : " + range.size());
        for (Layer layer : range) {
            Layer layercopy = layer.clone(pr, copy, roi, copy_id, ignore_hidden_patches);
            copy.addSilently(layercopy);
            if (!add_to_tree) continue;
            pr.getLayerTree().addLayer(copy, layercopy);
        }
        return copy;
    }

    public static void cloneInto(LayerSet src, Layer src_first, Layer src_last, Project pr, LayerSet copy, Rectangle roi, boolean copy_id) throws Exception {
        AffineTransform trans = new AffineTransform();
        trans.translate(-roi.x, -roi.y);
        ArrayList<Layer> range = copy.getLayers();
        List<Layer> src_range = null;
        if (0 == range.size()) {
            throw new Exception("Cannot cloneInto for a range of zero layers!");
        }
        for (ZDisplayable zd : src.find((Layer)range.get(0), (Layer)range.get(range.size() - 1), new Area(roi))) {
            if (src.project != pr && zd instanceof Tree) {
                ZDisplayable src_zd_copy = (ZDisplayable)zd.clone(src.project, true);
                if (null == src_range) {
                    src_range = new ArrayList<Layer>(src.al_layers).subList(src.indexOf(src_first), src.indexOf(src_last) + 1);
                }
                src_zd_copy.crop(src_range);
                Tree tcopy = (Tree)src_zd_copy.clone(pr, copy_id);
                tcopy.getAffineTransform().preConcatenate(trans);
                copy.addSilently(tcopy);
                tcopy.calculateBoundingBox(null);
                continue;
            }
            ZDisplayable zdcopy = (ZDisplayable)zd.clone(pr, copy_id);
            zdcopy.getAffineTransform().preConcatenate(trans);
            copy.addSilently(zdcopy);
            if (zdcopy.crop(range)) {
                if (zdcopy.isDeletable()) {
                    pr.remove(zdcopy);
                    Utils.log("Skipping empty " + zdcopy);
                    continue;
                }
                zdcopy.calculateBoundingBox(null);
                continue;
            }
            Utils.log("Could not crop " + zd);
        }
        copy.linkPatchesR();
    }

    public LayerStack createLayerStack(Class<?> clazz, int type, int c_alphas) {
        return new LayerStack(this, this.getVirtualizationScale(), type, clazz, c_alphas);
    }

    public int getPixelsMaxDimension() {
        return this.max_dimension;
    }

    public double getVirtualizationScale() {
        double scale = (float)this.max_dimension / Math.max(this.layer_width, this.layer_height);
        return scale > 1.0 ? 1.0 : scale;
    }

    public void setPixelsMaxDimension(int d) {
        if (d > 2) {
            if (d != this.max_dimension) {
                this.max_dimension = d;
                Polyline.flushTraceCache(this.project);
                Utils.log("3D Viewer NOT updated:\n  close it and recreate meshes for any objects you had in it.");
            }
        } else {
            Utils.log("Can't set virtualization max pixels dimension to smaller than 2!");
        }
    }

    public void setPixelsVirtualizationEnabled(boolean b) {
        this.virtualization_enabled = b;
    }

    public boolean isPixelsVirtualizationEnabled() {
        return this.virtualization_enabled;
    }

    public Rectangle get2DBounds() {
        return new Rectangle(0, 0, (int)Math.ceil(this.layer_width), (int)Math.ceil(this.layer_height));
    }

    public void setCalibration(Calibration cal) {
        if (null == cal) {
            return;
        }
        this.calibration = (Calibration)cal.clone();
    }

    public Calibration getCalibration() {
        return this.calibration;
    }

    public Calibration getCalibrationCopy() {
        return this.calibration.copy();
    }

    public boolean isCalibrated() {
        Calibration identity = new Calibration();
        return !identity.equals(this.calibration);
    }

    public void restoreCalibration(HashMap<String, String> ht_attributes) {
        for (Map.Entry<String, String> entry : ht_attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            key.substring(3).toLowerCase();
            try {
                if (key.equals("pixelwidth")) {
                    this.calibration.pixelWidth = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("pixelheight")) {
                    this.calibration.pixelHeight = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("pixeldepth")) {
                    this.calibration.pixelDepth = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("xorigin")) {
                    this.calibration.xOrigin = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("yorigin")) {
                    this.calibration.yOrigin = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("zorigin")) {
                    this.calibration.zOrigin = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("info")) {
                    this.calibration.info = value;
                    continue;
                }
                if (key.equals("valueunit")) {
                    this.calibration.setValueUnit(value);
                    continue;
                }
                if (key.equals("timeunit")) {
                    this.calibration.setTimeUnit(value);
                    continue;
                }
                if (!key.equals("unit")) continue;
                this.calibration.setUnit(value);
            }
            catch (Exception e) {
                Utils.log2("LayerSet.restoreCalibration, key/value failed:" + key + "=\"" + value + "\"");
                IJError.print(e);
            }
        }
    }

    public boolean snapshotsQuality() {
        return this.snapshots_quality;
    }

    public void setSnapshotsQuality(boolean b) {
        this.snapshots_quality = b;
        this.updateInDatabase("snapshots_quality");
    }

    public ArrayList<Displayable> get(Class<?> c) {
        return this.get(new ArrayList<Displayable>(), c);
    }

    public ArrayList<Displayable> get(ArrayList<Displayable> all, Class<?> c) {
        if (null == all) {
            all = new ArrayList();
        }
        if (Displayable.class == c || ZDisplayable.class == c) {
            all.addAll(this.al_zdispl);
        } else {
            for (ZDisplayable zd : this.al_zdispl) {
                if (zd.getClass() != c) continue;
                all.add(zd);
            }
        }
        for (Layer layer : this.al_layers) {
            all.addAll(layer.getDisplayables(c));
            for (Displayable ls : layer.getDisplayables(LayerSet.class)) {
                ((LayerSet)ls).get(all, c);
            }
        }
        return all;
    }

    public Object grab(int first, int last, Rectangle r, double scale, Class<?> c, int c_alphas, int format, int type) {
        if (first < 0 || first > last || last >= this.al_layers.size()) {
            Utils.log("Invalid first and/or last layers.");
            return null;
        }
        this.project.getLoader().releaseToFit(r.width, r.height, type, 1.1f);
        if (3 == format) {
            ImageStack stack = new ImageStack((int)((double)r.width * scale), (int)((double)r.height * scale));
            for (int i = first; i <= last; ++i) {
                Layer la = this.al_layers.get(i);
                Utils.log2("c is " + c);
                ImagePlus imp = this.project.getLoader().getFlatImage(la, r, scale, c_alphas, type, c, null, true);
                if (null != imp) {
                    try {
                        stack.addSlice(imp.getTitle(), imp.getProcessor());
                    }
                    catch (IllegalArgumentException iae) {
                        IJError.print(iae);
                    }
                    continue;
                }
                Utils.log("LayerSet.grab: Ignoring layer " + la);
            }
            if (0 == stack.getSize()) {
                Utils.log("LayerSet.grab: could not make slices.");
                return null;
            }
            return new ImagePlus("Stack " + first + "-" + last, stack);
        }
        if (2 == format) {
            Image[] image = new Image[last - first + 1];
            int i = first;
            int j = 0;
            while (i <= last) {
                image[j] = this.project.getLoader().getFlatAWTImage(this.al_layers.get(i), r, scale, c_alphas, type, c, null, true, Color.black);
                ++i;
                ++j;
            }
            return image;
        }
        return null;
    }

    public Displayable findDisplayable(long id) {
        for (Layer la : this.al_layers) {
            for (Displayable d : la.getDisplayables()) {
                if (d.getId() != id) continue;
                return d;
            }
        }
        return null;
    }

    @Override
    public DBObject findById(long id) {
        if (this.id == id) {
            return this;
        }
        for (ZDisplayable zd : this.al_zdispl) {
            if (zd.getId() != id) continue;
            return zd;
        }
        for (Layer la : this.al_layers) {
            DBObject dbo = la.findById(id);
            if (null == dbo) continue;
            return dbo;
        }
        return null;
    }

    void linkPatchesR() {
        for (Layer la : this.al_layers) {
            la.linkPatchesR();
        }
        for (ZDisplayable zd : this.al_zdispl) {
            zd.linkPatches();
        }
    }

    public void updateLayerTree() {
        for (Layer la : this.al_layers) {
            la.updateLayerTree();
        }
    }

    public ArrayList<ZDisplayable> find(Layer first, Layer last, Area area) {
        ArrayList<ZDisplayable> al = new ArrayList<ZDisplayable>();
        for (ZDisplayable zd : this.al_zdispl) {
            if (!zd.intersects(area, first.getZ(), last.getZ())) continue;
            al.add(zd);
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToBuckets(Displayable zd, int i) {
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            if (this.lbucks.isEmpty()) {
                return;
            }
            for (Long lid : zd.getLayerIds()) {
                Layer la = this.getLayer(lid);
                LayerBucket lb = this.lbucks.get(la);
                if (null == lb) {
                    LayerSet.nbmsg(la);
                    continue;
                }
                lb.root.put(i, zd, la, lb.db_map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFromBuckets(Displayable zd, int old_stack_index) {
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            if (this.lbucks.isEmpty()) {
                return;
            }
            for (Long lid : zd.getLayerIds()) {
                Layer la = this.getLayer(lid);
                LayerBucket lb = this.lbucks.get(la);
                if (null == lb) {
                    LayerSet.nbmsg(la);
                    continue;
                }
                this.recreateBuckets(this.getLayer(lid), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFromBuckets(Collection<ZDisplayable> zds) {
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            if (this.lbucks.isEmpty()) {
                return;
            }
            HashSet<Layer> touched = new HashSet<Layer>();
            for (ZDisplayable zd : zds) {
                touched.addAll(zd.getLayersWithData());
            }
            for (Layer la : touched) {
                LayerBucket lb = this.lbucks.remove(la);
                if (null == lb) {
                    LayerSet.nbmsg(la);
                    continue;
                }
                this.lbucks.put(la, new LayerBucket(la));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateRangeInBuckets(Displayable zd, int i, int j) {
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            if (this.lbucks.isEmpty()) {
                return;
            }
            for (Long lid : zd.getLayerIds()) {
                Layer la = this.getLayer(lid);
                LayerBucket lb = this.lbucks.get(la);
                if (null == lb) {
                    LayerSet.nbmsg(la);
                    continue;
                }
                for (Bucket bu : lb.db_map.get(zd)) {
                    bu.updateRange((Bucketable)this, zd, i, j);
                }
            }
        }
    }

    public ArrayList<ZDisplayable> getZDisplayables() {
        return new ArrayList<ZDisplayable>(this.al_zdispl);
    }

    public ArrayList<ZDisplayable> getDisplayableList() {
        return this.al_zdispl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<Displayable, HashSet<Bucket>> getBucketMap(Layer la) {
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            if (this.lbucks.isEmpty()) {
                return null;
            }
            LayerBucket lb = this.lbucks.get(la);
            if (null == lb) {
                LayerSet.nbmsg(la);
                return null;
            }
            return lb.db_map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBucket(Displayable d, Layer layer) {
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            LayerBucket lb = this.lbucks.get(layer);
            if (null != lb) {
                lb.root.updatePosition(d, layer, lb.db_map);
            }
        }
    }

    public void recreateBuckets(boolean layer_buckets) {
        this.recreateBuckets(this.al_layers, layer_buckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreateBuckets(Layer layer, boolean layer_buckets) {
        LayerBucket lb = new LayerBucket(layer);
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            this.lbucks.put(layer, lb);
        }
        if (layer_buckets && null != layer.root) {
            layer.recreateBuckets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreateBuckets(Collection<Layer> layers, final boolean layer_buckets) {
        final HashMap m = new HashMap();
        try {
            Process.progressive(layers, new TaskFactory<Layer, Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object process(Layer layer) {
                    LayerBucket lb = new LayerBucket(layer);
                    HashMap hashMap = m;
                    synchronized (hashMap) {
                        m.put(layer, lb);
                    }
                    if (layer_buckets && null != layer.root) {
                        layer.recreateBuckets();
                    }
                    return null;
                }
            }, Process.NUM_PROCESSORS - 1);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            this.lbucks.clear();
            this.lbucks.putAll(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBuckets() {
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            if (!this.lbucks.isEmpty()) {
                return;
            }
        }
        this.recreateBuckets(false);
    }

    public Rectangle getMinimalBoundingBox(Class<?> c) {
        Rectangle r = null;
        for (Layer la : this.al_layers) {
            if (null == r) {
                r = la.getMinimalBoundingBox(c);
                continue;
            }
            Rectangle box = la.getMinimalBoundingBox(c);
            if (null == box) continue;
            r.add(box);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean prepareStep(Object ob) {
        TreeMap<Long, DoStep> treeMap = this.edit_history;
        synchronized (treeMap) {
            if (0 == this.edit_history.size() || this.redo.size() > 0) {
                return true;
            }
            DoStep step = this.edit_history.get(this.edit_history.lastKey());
            boolean b = step.isIdenticalTo(ob);
            boolean bl = !b;
            return bl;
        }
    }

    boolean addPreDataEditStep(Displayable d) {
        if (null == this.current_edit_step || this.current_edit_step.getD() != d || !((Displayable.DoEdit)this.current_edit_step).containsKey("data")) {
            return this.addEditStep(new Displayable.DoEdit(d).init(d, new String[]{"data"}));
        }
        return false;
    }

    boolean addDataEditStep(Displayable d) {
        return this.addDataEditStep(d, new String[]{"data"});
    }

    boolean addDataEditStep(Displayable d, String[] fields) {
        return this.addEditStep(new Displayable.DoEdit(d).init(d, fields));
    }

    public boolean addDataEditStep(Set<? extends Displayable> ds) {
        return this.addDataEditStep(ds, new String[]{"data"});
    }

    boolean addDataEditStep(Set<? extends Displayable> ds, String[] fields) {
        Displayable.DoEdits edits = new Displayable.DoEdits(ds);
        edits.init(fields);
        return this.addEditStep(edits);
    }

    public void addTransformStep(Layer layer) {
        this.addTransformStep((Collection<? extends Displayable>)layer.getDisplayables());
    }

    public void addTransformStep(List<Layer> layers) {
        ArrayList<Displayable> all = new ArrayList<Displayable>();
        for (Layer la : layers) {
            all.addAll(la.getDisplayables());
        }
        this.addTransformStep((Collection<? extends Displayable>)all);
    }

    public void addTransformStep(Collection<? extends Displayable> col) {
        this.addEditStep(new Displayable.DoTransforms().addAll(col));
    }

    public Displayable.DoEdits addTransformStepWithData(Collection<? extends Displayable> col) {
        if (col.isEmpty()) {
            return null;
        }
        Set<Object> hs = col instanceof Set ? (Set<Object>)col : new HashSet<Displayable>(col);
        Displayable.DoEdits step = new Displayable.DoEdits((Set<? extends Displayable>)hs).init(new String[]{"data", "at", "width", "height"});
        this.addEditStep(step);
        return step;
    }

    public Collection<Displayable> addTransformStepWithDataForAll(Collection<Layer> layers) {
        if (layers.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Displayable> hs = new HashSet<Displayable>();
        for (Layer layer : layers) {
            hs.addAll(layer.getDisplayables());
        }
        block1: for (ZDisplayable zd : this.al_zdispl) {
            for (Layer layer : layers) {
                if (!zd.paintsAt(layer)) continue;
                hs.add(zd);
                continue block1;
            }
        }
        this.addTransformStepWithData(hs);
        return hs;
    }

    public void addTransformStep() {
        Displayable.DoTransforms dt = new Displayable.DoTransforms();
        for (Layer la : this.al_layers) {
            dt.addAll(la.getDisplayables());
        }
        this.addEditStep(dt);
    }

    public DoChangeTrees addChangeTreesStep() {
        DoChangeTrees step = new DoChangeTrees(this);
        if (this.prepareStep(step)) {
            Utils.log2("Added change trees step.");
            this.addEditStep(step);
        }
        return step;
    }

    public DoChangeTrees addChangeTreesStep(Set<DoStep> dependents) {
        DoChangeTrees step = this.addChangeTreesStep();
        step.addDependents(dependents);
        this.addEditStep(step);
        return step;
    }

    public void addLayerContentStep(Layer la) {
        Layer.DoContentChange step = new Layer.DoContentChange(la);
        if (this.prepareStep(step)) {
            Utils.log2("Added layer content step.");
            this.addEditStep(step);
        }
    }

    public void addLayerEditedStep(Layer layer) {
        this.addEditStep(new Layer.DoEditLayer(layer));
    }

    public void addLayerEditedStep(List<Layer> al) {
        this.addEditStep(new Layer.DoEditLayers(al));
    }

    public void addUndoStep(DoStep step) {
        this.addEditStep(step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addEditStep(DoStep step) {
        if (null == step || step.isEmpty()) {
            Utils.log2("Warning: can't add empty step " + step);
            return false;
        }
        TreeMap<Long, DoStep> treeMap = this.edit_history;
        synchronized (treeMap) {
            if (step.isIdenticalTo(this.current_edit_step)) {
                return false;
            }
            if (null != this.current_edit_step) {
                this.edit_history.put(this.current_edit_time, this.current_edit_step);
                Displayable d = this.current_edit_step.getD();
                if (null != d) {
                    TreeMap<Long, DoStep> edits = this.dedits.get(d);
                    if (null == edits) {
                        edits = new TreeMap();
                        this.dedits.put(d, edits);
                    }
                    edits.put(this.current_edit_time, this.current_edit_step);
                }
                while (this.edit_history.size() > this.project.getProperty("n_undo_steps", 32)) {
                    long t = this.edit_history.firstKey();
                    DoStep st = this.edit_history.remove(t);
                    if (null == st.getD()) continue;
                    TreeMap<Long, DoStep> m = this.dedits.get(st.getD());
                    m.remove(t);
                    if (0 != m.size()) continue;
                    this.dedits.remove(st.getD());
                }
            }
            this.current_edit_time = System.currentTimeMillis();
            this.current_edit_step = step;
            this.redo.clear();
        }
        return true;
    }

    public boolean canUndo() {
        return this.edit_history.size() > 0;
    }

    public boolean canRedo() {
        return this.redo.size() > 0 || null != this.current_edit_step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean undoOneStep() {
        TreeMap<Long, DoStep> treeMap = this.edit_history;
        synchronized (treeMap) {
            if (0 == this.edit_history.size()) {
                Utils.logAll("Empty undo history!");
                return false;
            }
            if (null != this.current_edit_step) {
                this.redo.put(this.current_edit_time, this.current_edit_step);
            }
            this.current_edit_time = this.edit_history.lastKey();
            this.current_edit_step = this.edit_history.remove(this.current_edit_time);
            if (null != this.current_edit_step.getD()) {
                this.dedits.get(this.current_edit_step.getD()).remove(this.current_edit_time);
            }
            if (!this.current_edit_step.apply(0)) {
                Utils.log("Undo: could not apply step!");
                return false;
            }
            Utils.log("Undoing " + this.current_edit_step.getClass().getSimpleName());
            Display.updateVisibleTabs(this.project);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeLastUndoStep() {
        TreeMap<Long, DoStep> treeMap = this.edit_history;
        synchronized (treeMap) {
            if (this.edit_history.isEmpty()) {
                return false;
            }
            long time = this.edit_history.lastKey();
            DoStep step = this.edit_history.remove(time);
            if (null != step.getD()) {
                this.dedits.get(step.getD()).remove(time);
            }
            if (step == this.current_edit_step) {
                this.current_edit_time = this.edit_history.lastKey();
                this.current_edit_step = this.edit_history.get(this.current_edit_time);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean redoOneStep() {
        TreeMap<Long, DoStep> treeMap = this.edit_history;
        synchronized (treeMap) {
            if (0 == this.redo.size()) {
                Utils.logAll("Empty redo history!");
                if (null != this.current_edit_step) {
                    return this.current_edit_step.apply(1);
                }
                return false;
            }
            if (null != this.current_edit_step) {
                this.edit_history.put(this.current_edit_time, this.current_edit_step);
                if (null != this.current_edit_step.getD()) {
                    this.dedits.get(this.current_edit_step.getD()).put(this.current_edit_time, this.current_edit_step);
                }
            }
            this.current_edit_time = this.redo.firstKey();
            this.current_edit_step = this.redo.remove(this.current_edit_time);
            if (!this.current_edit_step.apply(1)) {
                Utils.log("Undo: could not apply step!");
                return false;
            }
            Utils.log("Redoing " + this.current_edit_step.getClass().getSimpleName());
            Display.updateVisibleTabs(this.project);
        }
        return true;
    }

    public static void applyTransforms(Map<Displayable, AffineTransform> m) {
        for (Map.Entry<Displayable, AffineTransform> e : m.entrySet()) {
            e.getKey().setAffineTransform(e.getValue());
        }
    }

    public DoStep createUndoMoveStep(Displayable d) {
        return d instanceof ZDisplayable ? new DoMoveZDisplayable(this) : new Layer.DoMoveDisplayable(d.getLayer());
    }

    public void addUndoMoveStep(Displayable d) {
        this.addUndoStep(this.createUndoMoveStep(d));
    }

    public synchronized Overlay getOverlay() {
        if (null == this.overlay) {
            this.overlay = new Overlay();
        }
        return this.overlay;
    }

    Overlay getOverlay2() {
        return this.overlay;
    }

    public synchronized Overlay setOverlay(Overlay o) {
        Overlay old = this.overlay;
        this.overlay = o;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final DisplayCanvas.Screenshot getScreenshot(DisplayCanvas.ScreenshotProperties props) {
        HashMap<DisplayCanvas.ScreenshotProperties, DisplayCanvas.Screenshot> hashMap = this.offscreens;
        synchronized (hashMap) {
            return this.offscreens.get(props);
        }
    }

    private final void putO2(Layer la, DisplayCanvas.Screenshot sc) {
        HashSet<DisplayCanvas.Screenshot> hs = this.offscreens2.get(la);
        if (null == hs) {
            hs = new HashSet();
            this.offscreens2.put(la, hs);
        }
        hs.add(sc);
    }

    private final void removeO2(DisplayCanvas.Screenshot sc) {
        HashSet<DisplayCanvas.Screenshot> hs = this.offscreens2.get(sc.layer);
        if (null == hs) {
            return;
        }
        hs.remove(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void storeScreenshot(DisplayCanvas.Screenshot s) {
        HashMap<DisplayCanvas.ScreenshotProperties, DisplayCanvas.Screenshot> hashMap = this.offscreens;
        synchronized (hashMap) {
            this.offscreens.put(s.props, s);
            this.putO2(s.layer, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clearScreenshots() {
        HashMap<DisplayCanvas.ScreenshotProperties, DisplayCanvas.Screenshot> hashMap = this.offscreens;
        synchronized (hashMap) {
            for (DisplayCanvas.Screenshot s : this.offscreens.values()) {
                s.flush();
            }
            this.offscreens.clear();
            this.offscreens2.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void trimScreenshots() {
        HashMap<DisplayCanvas.ScreenshotProperties, DisplayCanvas.Screenshot> hashMap = this.offscreens;
        synchronized (hashMap) {
            if (this.offscreens.size() > 1000) {
                TreeMap<Long, DisplayCanvas.Screenshot> m = new TreeMap<Long, DisplayCanvas.Screenshot>();
                for (DisplayCanvas.Screenshot s : this.offscreens.values()) {
                    m.put(s.born, s);
                }
                this.offscreens.clear();
                this.offscreens2.clear();
                ArrayList t = new ArrayList(m.keySet());
                for (DisplayCanvas.Screenshot sc : m.subMap((Long)m.firstKey(), (Long)t.get(t.size() / 2)).values()) {
                    this.offscreens.put(sc.props, sc);
                    this.putO2(sc.layer, sc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeFromOffscreens(DisplayCanvas.Screenshot sc) {
        HashMap<DisplayCanvas.ScreenshotProperties, DisplayCanvas.Screenshot> hashMap = this.offscreens;
        synchronized (hashMap) {
            this.offscreens.remove(sc.props);
            this.removeO2(sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFromOffscreens(Layer la) {
        HashMap<DisplayCanvas.ScreenshotProperties, DisplayCanvas.Screenshot> hashMap = this.offscreens;
        synchronized (hashMap) {
            HashSet<DisplayCanvas.Screenshot> hs = this.offscreens2.remove(la);
            if (null != hs) {
                for (DisplayCanvas.Screenshot sc : hs) {
                    this.offscreens.remove(sc.props);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeFromOffscreens(ZDisplayable zd) {
        HashMap<DisplayCanvas.ScreenshotProperties, DisplayCanvas.Screenshot> hashMap = this.offscreens;
        synchronized (hashMap) {
            Rectangle box = zd.getBoundingBox();
            Iterator<DisplayCanvas.Screenshot> it = this.offscreens.values().iterator();
            while (it.hasNext()) {
                DisplayCanvas.Screenshot sc = it.next();
                if (!box.intersects(sc.props.srcRect)) continue;
                it.remove();
                HashSet<DisplayCanvas.Screenshot> hs = this.offscreens2.get(sc.layer);
                if (null == hs) continue;
                hs.remove(sc.props);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean containsScreenshot(DisplayCanvas.Screenshot sc) {
        HashMap<DisplayCanvas.ScreenshotProperties, DisplayCanvas.Screenshot> hashMap = this.offscreens;
        synchronized (hashMap) {
            return this.offscreens.containsKey(sc.props);
        }
    }

    protected Map<Displayable, List<Area>> findAreas(Layer layer, Rectangle box, boolean visible) {
        HashMap<Displayable, List<Area>> m = new HashMap<Displayable, List<Area>>();
        for (Displayable zd : this.findZDisplayables(layer, box, visible)) {
            List<Area> a;
            if (!(zd instanceof AreaContainer) || null == (a = ((AreaContainer)((Object)zd)).getAreas(layer, box))) continue;
            m.put(zd, a);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag putTag(String tag, int keyCode) {
        if (null == tag) {
            return null;
        }
        Map<Integer, HashMap<String, Tag>> map = this.tags;
        synchronized (map) {
            Tag t;
            Tag existing;
            HashMap<String, Tag> ts = this.tags.get(keyCode);
            if (null == ts) {
                ts = new HashMap();
                this.tags.put(keyCode, ts);
            }
            if (null == (existing = ts.get(t = new Tag(tag, keyCode)))) {
                ts.put(t.toString(), t);
                return t;
            }
            return existing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet<Tag> getTags(int keyCode) {
        Map<Integer, HashMap<String, Tag>> map = this.tags;
        synchronized (map) {
            HashMap<String, Tag> ts = this.tags.get(keyCode);
            return new TreeSet<Tag>(null == ts ? Collections.EMPTY_SET : (82 == keyCode ? this.filterReviewTags(ts.values()) : ts.values()));
        }
    }

    private final Collection<Tag> filterReviewTags(Collection<Tag> ts) {
        ArrayList<Tag> a = new ArrayList<Tag>();
        for (Tag tag : ts) {
            if ('#' == tag.toString().charAt(0)) continue;
            a.add(tag);
        }
        return a;
    }

    protected Tag askForNewTag(int keyCode) {
        GenericDialog gd = new GenericDialog("Define new tag");
        gd.addMessage("Define new tag for key: " + (char)keyCode);
        TreeSet<Tag> ts = this.getTags(keyCode);
        gd.addStringField("New tag:", "", 40);
        if (null != ts && ts.size() > 0) {
            String[] names = new String[ts.size()];
            int next = 0;
            for (Tag t : ts) {
                names[next++] = t.toString();
            }
            gd.addChoice("Existing tags for " + (char)keyCode + ":", names, names[0]);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        String tag = gd.getNextString().trim();
        if (0 == tag.length()) {
            Utils.logAll("Invalid tag " + tag);
            return null;
        }
        return this.putTag(tag, keyCode);
    }

    protected boolean askToRemoveTag(int keyCode) {
        TreeSet<Tag> ts = this.getTags(keyCode);
        if (null == ts || ts.isEmpty()) {
            return false;
        }
        String[] tags = new String[ts.size()];
        int next = 0;
        for (Tag t : ts) {
            tags[next++] = t.toString();
        }
        GenericDialog gd = new GenericDialog("Remove tag");
        gd.addMessage("Remove a tag for key: " + (char)keyCode);
        gd.addChoice("Remove:", tags, tags[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        String tag = gd.getNextChoice();
        this.removeTag(tag, keyCode);
        return true;
    }

    public void removeTag(String tag, int keyCode) {
        this.removeTag(new Tag(tag, keyCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTag(Tag t) {
        Iterator<ZDisplayable> iterator = this.tags;
        synchronized (iterator) {
            HashMap<String, Tag> ts = this.tags.get(t.getKeyCode());
            if (null == ts) {
                return;
            }
            ts.remove(t.toString());
        }
        for (Displayable d : this.getDisplayables()) {
            d.removeTag(t);
        }
        for (ZDisplayable zd : this.al_zdispl) {
            zd.removeTag(t);
        }
        Display.repaint(this);
    }

    public void removeAllTags() {
        for (HashMap<String, Tag> m : this.tags.values()) {
            for (Tag t : m.values()) {
                this.removeTag(t);
            }
        }
    }

    public String exportTags() {
        StringBuilder sb = new StringBuilder("<tags>\n");
        for (Map.Entry<Integer, HashMap<String, Tag>> e : this.tags.entrySet()) {
            char key = (char)e.getKey().intValue();
            for (Tag t : e.getValue().values()) {
                sb.append(" <tag key=\"").append(key).append("\" val=\"").append(t.toString()).append("\" />\n");
            }
        }
        return sb.append("</tags>").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTags(String path, boolean replace) {
        HashMap<Integer, HashMap<String, Tag>> backup = new HashMap<Integer, HashMap<String, Tag>>(this.tags);
        InputStream istream = null;
        try {
            if (replace) {
                this.removeAllTags();
            }
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setValidating(false);
            SAXParser parser = f.newSAXParser();
            istream = Utils.createStream(path);
            parser.parse(new InputSource(istream), (DefaultHandler)new TagsParser());
        }
        catch (Throwable t) {
            IJError.print(t);
            this.tags.clear();
            this.tags.putAll(backup);
        }
        finally {
            try {
                if (null != istream) {
                    istream.close();
                }
            }
            catch (Exception f) {}
        }
    }

    public ArrayList<ZDisplayable> getZDisplayables(Class<?> c) {
        return this.getZDisplayables(c, false);
    }

    public ArrayList<ZDisplayable> getZDisplayables(Class<?> c, boolean instance_of) {
        ArrayList<ZDisplayable> al = new ArrayList<ZDisplayable>();
        if (null == c) {
            return al;
        }
        if (Displayable.class == c || ZDisplayable.class == c) {
            al.addAll(this.al_zdispl);
            return al;
        }
        if (instance_of) {
            for (ZDisplayable zd : this.al_zdispl) {
                if (!c.isInstance(zd)) continue;
                al.add(zd);
            }
        } else {
            for (ZDisplayable zd : this.al_zdispl) {
                if (zd.getClass() != c) continue;
                al.add(zd);
            }
        }
        return al;
    }

    @Deprecated
    public ArrayList<ZDisplayable> getZDisplayables(Class<?> c, Layer layer, Area aroi, boolean visible_only) {
        return this.getZDisplayables(c, layer, aroi, visible_only, false);
    }

    @Deprecated
    public ArrayList<ZDisplayable> getZDisplayables(Class<?> c, Layer layer, Area aroi, boolean visible_only, boolean instance_of) {
        if (!ZDisplayable.class.isAssignableFrom(c)) {
            return new ArrayList<ZDisplayable>();
        }
        return new ArrayList<Displayable>(this.findZDisplayables(c, layer, aroi, visible_only, instance_of));
    }

    public ArrayList<Displayable> find(Class<?> c, Layer layer, Area aroi, boolean visible_only) {
        return this.find(c, layer, aroi, visible_only, false);
    }

    public ArrayList<Displayable> find(Class<?> c, Layer layer, Area aroi, boolean visible_only, boolean instance_of) {
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        if (!ZDisplayable.class.isAssignableFrom(c)) {
            al.addAll(layer.getDisplayables(c, aroi, visible_only, instance_of));
        }
        al.addAll(this.findZDisplayables(c, layer, aroi, visible_only, instance_of));
        return al;
    }

    public ArrayList<Displayable> find(Class<?> c, Layer layer, int x, int y, boolean visible_only) {
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        if (!ZDisplayable.class.isAssignableFrom(c)) {
            al.addAll(layer.find(c, x, y, visible_only));
        }
        al.addAll(this.findZDisplayables(c, layer, x, y, visible_only));
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Displayable> findZDisplayables(Layer layer, int x, int y, boolean visible_only) {
        LayerBucket lb;
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            lb = this.lbucks.get(layer);
        }
        if (null != lb) {
            return lb.root.find(x, y, layer, visible_only);
        }
        LayerSet.nbmsg(layer);
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (ZDisplayable zd : this.al_zdispl) {
            if (!zd.contains(layer, x, y)) continue;
            al.add(zd);
        }
        return al;
    }

    public Collection<Displayable> findZDisplayables(Class<?> c, Layer layer, int x, int y, boolean visible_only) {
        return this.findZDisplayables(c, layer, x, y, visible_only, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Displayable> findZDisplayables(Class<?> c, Layer layer, int x, int y, boolean visible_only, boolean instance_of) {
        LayerBucket lb;
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            lb = this.lbucks.get(layer);
        }
        if (null != lb) {
            return lb.root.find(c, x, y, layer, visible_only, instance_of);
        }
        LayerSet.nbmsg(layer);
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (ZDisplayable zd : this.al_zdispl) {
            if (zd.getClass() != c || !zd.contains(layer, x, y)) continue;
            al.add(zd);
        }
        return al;
    }

    public Collection<Displayable> findZDisplayables(Class<?> c, Layer layer, Rectangle r, boolean visible_only) {
        return this.findZDisplayables(c, layer, r, visible_only, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Displayable> findZDisplayables(Class<?> c, Layer layer, Rectangle r, boolean visible_only, boolean instance_of) {
        LayerBucket lb;
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            lb = this.lbucks.get(layer);
        }
        if (null != lb) {
            return lb.root.find(c, r, layer, visible_only, instance_of);
        }
        LayerSet.nbmsg(layer);
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (ZDisplayable zd : this.al_zdispl) {
            if (instance_of && !c.isInstance(zd) || zd.getClass() != c || !zd.getBounds(null, layer).intersects(r)) continue;
            al.add(zd);
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Displayable> findZDisplayables(Class<?> c, Layer layer, Area aroi, boolean visible_only, boolean instance_of) {
        LayerBucket lb;
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            lb = this.lbucks.get(layer);
        }
        if (null != lb) {
            return lb.root.find(c, aroi, layer, visible_only, instance_of);
        }
        LayerSet.nbmsg(layer);
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (ZDisplayable zd : this.al_zdispl) {
            if (visible_only && !zd.isVisible() || (!instance_of ? zd.getClass() != c : !c.isAssignableFrom(zd.getClass())) || !zd.intersects(layer, aroi)) continue;
            al.add(zd);
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Displayable> findZDisplayables(Layer layer, Rectangle r, boolean visible_only) {
        LayerBucket lb;
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            lb = this.lbucks.get(layer);
        }
        if (null != lb) {
            return lb.root.find(r, layer, visible_only);
        }
        LayerSet.nbmsg(layer);
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (ZDisplayable zd : this.al_zdispl) {
            if (visible_only && !zd.isVisible() || !zd.getBounds(null, layer).intersects(r)) continue;
            al.add(zd);
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Displayable> roughlyFindZDisplayables(Layer layer, Rectangle r, boolean visible_only) {
        LayerBucket lb;
        HashMap<Layer, LayerBucket> hashMap = this.lbucks;
        synchronized (hashMap) {
            lb = this.lbucks.get(layer);
        }
        if (null != lb) {
            return lb.root.roughlyFind(r, layer, visible_only);
        }
        LayerSet.nbmsg(layer);
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (ZDisplayable zd : this.al_zdispl) {
            if (visible_only && !zd.isVisible() || !zd.getBounds(null, layer).intersects(r)) continue;
            al.add(zd);
        }
        return al;
    }

    private static final void nbmsg(Layer la) {
        Utils.log2("No buckets for layer " + la);
    }

    public <T extends Displayable> List<T> getAll(Class<T> c) {
        ArrayList<Displayable> al;
        block5: {
            block7: {
                block6: {
                    block4: {
                        al = new ArrayList<Displayable>();
                        if (null == c) {
                            return al;
                        }
                        if (ZDisplayable.class != c) break block4;
                        al.addAll(this.al_zdispl);
                        break block5;
                    }
                    if (!ZDisplayable.class.isAssignableFrom(c)) break block6;
                    for (ZDisplayable d : this.al_zdispl) {
                        if (d.getClass() != c) continue;
                        al.add(d);
                    }
                    break block5;
                }
                if (Displayable.class != c) break block7;
                for (Layer la : this.al_layers) {
                    al.addAll(la.getDisplayables());
                }
                al.addAll(this.al_zdispl);
                break block5;
            }
            if (!Displayable.class.isAssignableFrom(c)) break block5;
            for (Layer la : this.al_layers) {
                al.addAll(la.getAll(c));
            }
        }
        return al;
    }

    static {
        try {
            sbvalue = StringBuilder.class.getSuperclass().getDeclaredField("value");
            sbvalue.setAccessible(true);
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    private class TagsParser
    extends DefaultHandler {
        private TagsParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (!"tag".equals(qName.toLowerCase())) {
                return;
            }
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = attributes.getLength() - 1; i > -1; --i) {
                m.put(attributes.getQName(i).toLowerCase(), attributes.getValue(i));
            }
            String key = (String)m.get("key");
            String content = (String)m.get("val");
            if (null == key || key.length() > 1 || Character.isDigit(key.charAt(0)) || null == content) {
                Utils.log("Ignoring invalid tag with key '" + key + "' and value '" + content + "'");
                return;
            }
            LayerSet.this.putTag(content, key.charAt(0));
        }
    }

    protected static class DoMoveZDisplayable
    implements DoStep {
        final ArrayList<ZDisplayable> al_zdispl;
        final LayerSet ls;
        HashSet<DoStep> dependents = null;

        DoMoveZDisplayable(LayerSet ls) {
            this.ls = ls;
            this.al_zdispl = new ArrayList(ls.al_zdispl);
        }

        @Override
        public boolean apply(int action) {
            this.ls.al_zdispl.clear();
            this.ls.al_zdispl.addAll(this.al_zdispl);
            Display.update(this.ls, false);
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Displayable getD() {
            return null;
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            if (!(ob instanceof DoMoveZDisplayable)) {
                return false;
            }
            DoMoveZDisplayable dmz = (DoMoveZDisplayable)ob;
            if (dmz.ls != this.ls) {
                return false;
            }
            if (dmz.al_zdispl.size() != this.al_zdispl.size()) {
                return false;
            }
            for (int i = 0; i < this.al_zdispl.size(); ++i) {
                if (dmz.al_zdispl.get(i) == this.al_zdispl.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    protected static class DoChangeTrees
    implements DoStep {
        final LayerSet ls;
        final HashMap<Thing, Boolean> ttree_exp;
        final HashMap<Thing, Boolean> ptree_exp;
        final HashMap<Thing, Boolean> ltree_exp;
        final Thing troot;
        final Thing proot;
        final Thing lroot;
        final ArrayList<Layer> all_layers;
        final HashMap<Layer, ArrayList<Displayable>> all_displ;
        final ArrayList<ZDisplayable> all_zdispl;
        final HashMap<Displayable, Set<Displayable>> links;
        final HashMap<Long, Layer> idlayers;
        final HashMap<Layer, Integer> layerindices;
        HashSet<DoStep> dependents = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DoChangeTrees(LayerSet ls) {
            this.ls = ls;
            Project p = ls.getProject();
            this.ttree_exp = new HashMap();
            this.troot = p.getTemplateTree().duplicate(this.ttree_exp);
            this.ptree_exp = new HashMap();
            this.proot = p.getProjectTree().duplicate(this.ptree_exp);
            this.ltree_exp = new HashMap();
            this.lroot = p.getLayerTree().duplicate(this.ltree_exp);
            this.all_layers = ls.getLayers();
            this.all_zdispl = ls.getZDisplayables();
            this.idlayers = new HashMap(ls.idlayers);
            Iterator<Layer> iterator = ls.layerindices;
            synchronized (iterator) {
                this.layerindices = new HashMap(ls.layerindices);
            }
            this.links = new HashMap();
            for (ZDisplayable zd : this.all_zdispl) {
                this.links.put(zd, zd.hs_linked);
            }
            this.all_displ = new HashMap();
            for (Layer layer : this.all_layers) {
                ArrayList<Displayable> al = layer.getDisplayables();
                this.all_displ.put(layer, al);
                for (Displayable d : al) {
                    this.links.put(d, (Set<Displayable>)(null == d.hs_linked ? null : new HashSet<Displayable>(d.hs_linked)));
                }
            }
        }

        @Override
        public Displayable getD() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean apply(int action) {
            Project p = this.ls.getProject();
            p.resetRootTemplateThing((TemplateThing)this.troot, this.ttree_exp);
            p.resetRootProjectThing((ProjectThing)this.proot, this.ptree_exp);
            p.resetRootLayerThing((LayerThing)this.lroot, this.ltree_exp);
            this.ls.al_layers.clear();
            this.ls.al_layers.addAll(this.all_layers);
            Iterator<Object> iterator = this.ls.IDLAYERS_WRITE_LOCK;
            synchronized (iterator) {
                this.ls.idlayers = new HashMap<Long, Layer>(this.idlayers);
            }
            iterator = this.ls.layerindices;
            synchronized (iterator) {
                this.ls.layerindices.clear();
                this.ls.layerindices.putAll(this.layerindices);
            }
            for (Map.Entry<Layer, ArrayList<Displayable>> entry : this.all_displ.entrySet()) {
                ArrayList<Displayable> al = entry.getKey().getDisplayableList();
                HashSet<Displayable> diff = new HashSet<Displayable>(al);
                diff.removeAll((Collection)entry.getValue());
                al.clear();
                al.addAll((Collection<Displayable>)entry.getValue());
                for (Displayable d : diff) {
                    if (d.getClass() != Patch.class) continue;
                    d.getProject().getLoader().tagForMipmapRemoval((Patch)d, true);
                }
                for (Displayable d : al) {
                    if (d.getClass() != Patch.class) continue;
                    d.getProject().getLoader().tagForMipmapRemoval((Patch)d, false);
                }
            }
            this.ls.al_zdispl.clear();
            this.ls.al_zdispl.addAll(this.all_zdispl);
            for (Map.Entry<DBObject, Collection<Displayable>> entry : this.links.entrySet()) {
                HashSet<Displayable> hs = ((Displayable)entry.getKey()).hs_linked;
                if (null == hs) continue;
                Set hs2 = (Set)entry.getValue();
                if (null == hs2) {
                    ((Displayable)entry.getKey()).hs_linked = null;
                    continue;
                }
                hs.clear();
                hs.addAll(hs2);
            }
            if (null != this.dependents) {
                for (DoStep doStep : this.dependents) {
                    doStep.apply(action);
                }
            }
            this.ls.recreateBuckets(true);
            Display.clearSelection(this.ls.project);
            Display.update(this.ls, false);
            return true;
        }

        public synchronized void addDependents(Set<DoStep> dep) {
            if (null == this.dependents) {
                this.dependents = new HashSet();
            }
            this.dependents.addAll(dep);
        }
    }

    private static class DoResizeLayerSet
    implements DoStep {
        final LayerSet ls;
        final HashMap<Displayable, AffineTransform> affines;
        final float width;
        final float height;

        DoResizeLayerSet(LayerSet ls) {
            this.ls = ls;
            this.width = ls.layer_width;
            this.height = ls.layer_height;
            this.affines = new HashMap();
            ArrayList<Displayable> col = ls.getDisplayables();
            col.addAll(ls.getZDisplayables());
            for (Displayable d : col) {
                this.affines.put(d, d.getAffineTransformCopy());
            }
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            if (!(ob instanceof LayerSet)) {
                return false;
            }
            LayerSet layerset = (LayerSet)ob;
            if (layerset.layer_width != this.width || layerset.height != this.height || layerset != this.ls) {
                return false;
            }
            ArrayList<Displayable> col = this.ls.getDisplayables();
            col.addAll(this.ls.getZDisplayables());
            for (Displayable d : col) {
                AffineTransform aff = this.affines.get(d);
                if (null == aff) {
                    return false;
                }
                if (aff.equals(d.getAffineTransform())) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean apply(int action) {
            boolean dobuckets;
            this.ls.layer_width = this.width;
            this.ls.layer_height = this.height;
            for (Map.Entry<Displayable, AffineTransform> e : this.affines.entrySet()) {
                e.getKey().getAffineTransform().setTransform(e.getValue());
            }
            HashMap<Layer, LayerBucket> hashMap = this.ls.lbucks;
            synchronized (hashMap) {
                dobuckets = this.ls.lbucks.isEmpty();
            }
            if (dobuckets) {
                this.ls.recreateBuckets(true);
            }
            Display.updateSelection();
            Display.update(this.ls);
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Displayable getD() {
            return null;
        }
    }

    protected final class LayerBucket {
        protected final Bucket root;
        protected final HashMap<Displayable, HashSet<Bucket>> db_map = new HashMap();

        LayerBucket(Layer la) {
            this.root = new Bucket(0, 0, (int)(5.0E-5 + (double)LayerSet.this.getLayerWidth()), (int)(5.0E-5 + (double)LayerSet.this.getLayerHeight()), Bucket.getBucketSide(LayerSet.this, la));
            this.root.populate(LayerSet.this, la, this.db_map);
        }
    }
}

