/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.AbstractOffscreenThread;
import ini.trakem2.display.AbstractRepaintThread;
import ini.trakem2.display.AffineTransformMode;
import ini.trakem2.display.AreaContainer;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.DefaultMode;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.FakeImagePlus;
import ini.trakem2.display.FakeImageWindow;
import ini.trakem2.display.FreeHandProfile;
import ini.trakem2.display.ImageData;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerPanel;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.ManualAlignMode;
import ini.trakem2.display.NonLinearTransformMode;
import ini.trakem2.display.Paintable;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Profile;
import ini.trakem2.display.Selection;
import ini.trakem2.display.Tree;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.display.graphics.GraphicsSource;
import ini.trakem2.display.inspect.InspectPatchTrianglesMode;
import ini.trakem2.imaging.Segmentation;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Lock;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Search;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.scijava.vecmath.Point2f;
import org.scijava.vecmath.Tuple2f;
import org.scijava.vecmath.Vector2f;
import org.scijava.vecmath.Vector3d;

public final class DisplayCanvas
extends ImageCanvas
implements KeyListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private Display display;
    private boolean update_graphics = false;
    private BufferedImage offscreen = null;
    private final HashSet<BufferedImage> to_flush = new HashSet();
    private ArrayList<Displayable> al_top = new ArrayList();
    private final Lock lock_paint = new Lock();
    private Rectangle box = null;
    private FakeImageWindow fake_win;
    private FreeHandProfile freehandProfile = null;
    private Robot r;
    private final Object offscreen_lock = new Object();
    private Cursor noCursor;
    private boolean snapping = false;
    private boolean dragging = false;
    private boolean input_disabled = false;
    private boolean input_disabled2 = false;
    private static Hashtable<Class<?>, Object> copy_buffer = new Hashtable();
    private static boolean openglEnabled = false;
    private static boolean quartzEnabled = false;
    private static boolean ddscaleEnabled = false;
    static final RenderingHints rhints;
    private VolatileImage volatileImage;
    private Object volatile_lock = new Object();
    private boolean invalid_volatile = false;
    private final AbstractRepaintThread RT = new AbstractRepaintThread((Component)((Object)this), "T2-Canvas-Repainter", new OffscreenThread()){

        @Override
        protected void handleUpdateGraphics(Component target, Rectangle clipRect) {
            Layer active_layer = DisplayCanvas.this.display.getLayer();
            this.off.setProperties(new RepaintProperties(clipRect, active_layer, active_layer.getParent().getColorCueLayerRange(active_layer), target.getWidth(), target.getHeight(), DisplayCanvas.this.srcRect, DisplayCanvas.this.magnification, DisplayCanvas.this.display.getActive(), DisplayCanvas.this.display.getDisplayChannelAlphas(), DisplayCanvas.this.display.getMode().getGraphicsSource()));
        }
    };
    private BasicStroke stroke = new BasicStroke(1.0f, 0, 0);
    private final AffineTransform atc = new AffineTransform();
    protected static BasicStroke DEFAULT_STROKE;
    protected static AffineTransform DEFAULT_AFFINE;
    private int x_p;
    private int y_p;
    private int x_d;
    private int y_d;
    private int x_d_old;
    private int y_d_old;
    private boolean popup = false;
    private boolean locked = false;
    private int tmp_tool = -1;
    protected Point last_popup = null;
    private boolean mouse_in = false;
    private static final int MIN_DIMENSION = 10;
    private Rectangle old_brush_box = null;
    private MouseMovedThread mouse_moved = new MouseMovedThread();
    private int last_keyCode = 27;
    private boolean tagging = false;
    private ScheduledExecutorService animator = null;
    private boolean zoom_and_pan = true;
    private final Vector<ScheduledFuture<?>> sfs = new Vector();

    static void setCopyBuffer(Class<?> c, Object ob) {
        copy_buffer.put(c, ob);
    }

    static Object getCopyBuffer(Class<?> c) {
        return copy_buffer.get(c);
    }

    private void renderVolatileImage(GraphicsConfiguration gc, BufferedImage offscreen, ArrayList<Displayable> top, Displayable active, Layer active_layer, List<Layer> layers, int c_alphas, AffineTransform at, Rectangle clipRect) {
        do {
            int w = this.getWidth();
            int h = this.getHeight();
            if (0 == w || 0 == h) {
                return;
            }
            if (null == this.volatileImage || this.volatileImage.getWidth() != w || this.volatileImage.getHeight() != h || this.volatileImage.validate(gc) == 2) {
                if (null != this.volatileImage) {
                    this.volatileImage.flush();
                }
                this.volatileImage = gc.createCompatibleVolatileImage(w, h);
                this.volatileImage.setAccelerationPriority(1.0f);
                this.invalid_volatile = false;
                clipRect = null;
            }
            Graphics2D g = this.volatileImage.createGraphics();
            if (null != clipRect) {
                g.setClip(clipRect);
            }
            g.setColor(Color.black);
            if (null == clipRect) {
                g.fillRect(0, 0, w, h);
            } else {
                g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            }
            if (null != offscreen) {
                g.drawImage((Image)offscreen, 0, 0, null);
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            if (null != active_layer) {
                boolean active_painted;
                g.setTransform(at);
                g.setStroke(this.stroke);
                boolean must_paint_active = null != active && active.isVisible() && !ImageData.class.isAssignableFrom(active.getClass());
                boolean bl = active_painted = !must_paint_active;
                if (null != top) {
                    Rectangle tmp = null != clipRect ? new Rectangle() : null;
                    Rectangle clip = null != clipRect ? new Rectangle((int)((double)clipRect.x * this.magnification) - this.srcRect.x, (int)((double)clipRect.y * this.magnification) - this.srcRect.y, (int)((double)clipRect.width * this.magnification), (int)((double)clipRect.height * this.magnification)) : null;
                    for (Displayable d : top) {
                        if (null != clipRect && !d.getBoundingBox(tmp).intersects(clip)) continue;
                        d.paint(g, this.srcRect, this.magnification, d == active, c_alphas, active_layer, layers);
                        if (active_painted) continue;
                        active_painted = d == active;
                    }
                }
                if (must_paint_active && !active_painted) {
                    active.paint(g, this.srcRect, this.magnification, true, c_alphas, active_layer, layers);
                }
            }
            this.display.getMode().getGraphicsSource().paintOnTop(g, this.display, this.srcRect, this.magnification);
            if (null != active_layer.getOverlay2()) {
                active_layer.getOverlay2().paint(g, this.srcRect, this.magnification);
            }
            if (null != active_layer.getParent().getOverlay2()) {
                active_layer.getParent().getOverlay2().paint(g, this.srcRect, this.magnification);
            }
            if (null != this.display.gridoverlay) {
                this.display.gridoverlay.paint(g);
            }
            g.dispose();
        } while (this.volatileImage.contentsLost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(Graphics g, Displayable active, Layer active_layer, List<Layer> layers, int c_alphas, AffineTransform at, Rectangle clipRect) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHints(rhints);
        do {
            ArrayList<Displayable> top;
            BufferedImage offscreen;
            Object object = this.offscreen_lock;
            synchronized (object) {
                offscreen = this.offscreen;
                top = this.al_top;
            }
            GraphicsConfiguration gc = this.getGraphicsConfiguration();
            this.display.getProject().getLoader().releaseToFit(this.getWidth() * this.getHeight() * 4 * 5);
            Object object2 = this.volatile_lock;
            synchronized (object2) {
                if (this.invalid_volatile || null == this.volatileImage || this.volatileImage.validate(gc) != 0) {
                    clipRect = null;
                    this.renderVolatileImage(gc, offscreen, top, active, active_layer, layers, c_alphas, at, clipRect);
                }
                if (null != clipRect) {
                    g2d.setClip(clipRect);
                }
                g2d.drawImage(this.volatileImage, 0, 0, null);
            }
        } while (this.volatileImage.contentsLost());
        g2d.dispose();
        Object object = this.offscreen_lock;
        synchronized (object) {
            for (BufferedImage bi : this.to_flush) {
                bi.flush();
            }
            this.to_flush.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateVolatile() {
        Object object = this.volatile_lock;
        synchronized (object) {
            this.invalid_volatile = true;
        }
    }

    public DisplayCanvas(Display display, int width, int height) {
        super((ImagePlus)new FakeImagePlus(width, height, display));
        this.fake_win = new FakeImageWindow(this.imp, this, display);
        this.display = display;
        this.imageWidth = width;
        this.imageHeight = height;
        this.removeKeyListener((KeyListener)IJ.getInstance());
        this.addKeyListener(this);
        this.addMouseWheelListener(this);
    }

    public Display getDisplay() {
        return this.display;
    }

    protected void setInitialMagnification(double mag) {
        this.magnification = mag;
    }

    public void setup(double mag, Rectangle srcRect) {
        this.magnification = mag;
        this.srcRect = (Rectangle)srcRect.clone();
        super.setDrawingSize((int)Math.ceil((double)srcRect.width * mag), (int)Math.ceil((double)srcRect.height * mag));
        this.setMagnification(mag);
    }

    public void setDimensions(double width, double height) {
        this.imageWidth = (int)Math.ceil(width);
        this.imageHeight = (int)Math.ceil(height);
        ((FakeImagePlus)this.imp).setDimensions(this.imageWidth, this.imageHeight);
    }

    public void handlePopupMenu() {
    }

    public final void update(Graphics g) {
        this.paint(g);
    }

    public void setMagnification(double mag) {
        if (mag < 1.0E-8) {
            mag = 1.0E-8;
        }
        this.stroke = new BasicStroke((float)(1.0 / mag), 0, 0);
        this.magnification = mag;
        this.imp.setTitle(this.imp.getTitle());
        this.display.getMode().magnificationUpdated(this.srcRect, mag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (null == g) {
            return;
        }
        try {
            Roi roi;
            Lock lock = this.lock_paint;
            synchronized (lock) {
                this.lock_paint.lock();
            }
            g.translate(0, 0);
            Rectangle clipRect = g.getClipBounds();
            Displayable active = this.display.getActive();
            int c_alphas = this.display.getDisplayChannelAlphas();
            Layer active_layer = this.display.getLayer();
            List<Layer> layers = active_layer.getParent().getColorCueLayerRange(active_layer);
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform at_original = g2d.getTransform();
            this.atc.setToIdentity();
            this.atc.scale(this.magnification, this.magnification);
            this.atc.translate(-this.srcRect.x, -this.srcRect.y);
            at_original.preConcatenate(this.atc);
            if (null != this.offscreen && this.dragging) {
                this.invalidateVolatile();
            }
            this.render(g, active, active_layer, layers, c_alphas, at_original, clipRect);
            g2d.setTransform(at_original);
            g2d.setStroke(this.stroke);
            g2d.setTransform(new AffineTransform());
            g2d.setStroke(new BasicStroke(1.0f, 0, 0));
            if (this.mouse_in && null != active && AreaContainer.class.isInstance(active)) {
                switch (ProjectToolbar.getToolId()) {
                    case 17: {
                        int brushSize = ProjectToolbar.getBrushSize();
                        g.setColor(active.getColor());
                        g.drawOval((int)((double)(this.xMouse - this.srcRect.x - brushSize / 2) * this.magnification), (int)((double)(this.yMouse - this.srcRect.y - brushSize / 2) * this.magnification), (int)((double)brushSize * this.magnification), (int)((double)brushSize * this.magnification));
                        break;
                    }
                    case 15: 
                    case 18: {
                        Composite co = g2d.getComposite();
                        if (IJ.isWindows()) {
                            g2d.setColor(Color.yellow);
                        } else {
                            g2d.setXORMode(Color.yellow);
                        }
                        g2d.drawRect((int)((double)(this.xMouse - this.srcRect.x - Segmentation.fmp.width / 2) * this.magnification), (int)((double)(this.yMouse - this.srcRect.y - Segmentation.fmp.height / 2) * this.magnification), (int)((double)Segmentation.fmp.width * this.magnification), (int)((double)Segmentation.fmp.height * this.magnification));
                        g2d.setComposite(co);
                    }
                }
            }
            if (null != (roi = this.imp.getRoi())) {
                roi.draw(g);
            }
            if (null != this.freehandProfile) {
                this.freehandProfile.paint(g, this.magnification, this.srcRect, true);
                if (this.noCursor == null) {
                    this.noCursor = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(1, 1, 12), new Point(0, 0), "noCursor");
                }
            }
        }
        catch (Exception e) {
            Utils.log2("DisplayCanvas.paint(Graphics) Error: " + e);
            IJError.print(e);
        }
        finally {
            Lock lock = this.lock_paint;
            synchronized (lock) {
                this.lock_paint.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRepaint() {
        this.RT.waitForOffs();
        Lock lock = this.lock_paint;
        synchronized (lock) {
            this.lock_paint.lock();
            this.lock_paint.unlock();
        }
    }

    public static void drawHandle(Graphics g, int x, int y, double magnification) {
        int width5 = (int)(5.0 / magnification + 0.5);
        int width3 = (int)(3.0 / magnification + 0.5);
        int corr2 = (int)(2.0 / magnification + 0.5);
        int corr1 = (int)(1.0 / magnification + 0.5);
        g.setColor(Color.white);
        g.drawRect(x - corr2, y - corr2, width5, width5);
        g.setColor(Color.black);
        g.drawRect(x - corr1, y - corr1, width3, width3);
        g.setColor(Color.white);
        g.fillRect(x, y, corr1, corr1);
    }

    public static void drawScreenHandle(Graphics g, int x, int y) {
        g.setColor(Color.orange);
        g.drawRect(x - 2, y - 2, 5, 5);
        g.setColor(Color.black);
        g.drawRect(x - 1, y - 1, 3, 3);
        g.setColor(Color.orange);
        g.fillRect(x, y, 1, 1);
    }

    public static void drawHandle(Graphics2D g, double x, double y, Rectangle srcRect, double magnification) {
        AffineTransform original = g.getTransform();
        g.setTransform(DEFAULT_AFFINE);
        Stroke st = g.getStroke();
        g.setStroke(DEFAULT_STROKE);
        g.setColor(Color.black);
        g.fillRect((int)((x - (double)srcRect.x) * magnification) - 1, (int)((y - (double)srcRect.y) * magnification) - 1, 3, 3);
        g.setColor(Color.white);
        g.drawRect((int)((x - (double)srcRect.x) * magnification) - 2, (int)((y - (double)srcRect.y) * magnification) - 2, 5, 5);
        g.setStroke(st);
        g.setTransform(original);
    }

    protected Point consumeLastPopupPoint() {
        Point p = this.last_popup;
        this.last_popup = null;
        return p;
    }

    public void mousePressed(MouseEvent me) {
        this.flags = me.getModifiers();
        this.x_p = this.x_d = this.srcRect.x + (int)((double)me.getX() / this.magnification);
        this.y_p = this.y_d = this.srcRect.y + (int)((double)me.getY() / this.magnification);
        this.xMouse = this.x_p;
        this.yMouse = this.y_p;
        if (this.x_p < this.srcRect.x || this.y_p < this.srcRect.y || this.x_p > this.srcRect.x + this.srcRect.width || this.y_p > this.srcRect.y + this.srcRect.height) {
            return;
        }
        this.popup = false;
        if (Utils.isPopupTrigger(me)) {
            this.popup = true;
            this.last_popup = new Point(this.x_p, this.y_p);
            this.display.getPopupMenu().show((Component)((Object)this), me.getX(), me.getY());
            return;
        }
        this.snapping = false;
        int tool = ProjectToolbar.getToolId();
        if (me.getButton() == 2) {
            this.tmp_tool = tool;
            ProjectToolbar.setTool(12);
            tool = 12;
        }
        if (!this.zoom_and_pan) {
            this.cancelAnimations();
        }
        switch (tool) {
            case 11: {
                if (me.isAltDown()) {
                    this.zoomOut(me.getX(), me.getY());
                } else {
                    this.zoomIn(me.getX(), me.getY());
                }
                return;
            }
            case 12: {
                super.setupScroll(this.x_p, this.y_p);
                return;
            }
        }
        if (this.input_disabled) {
            this.input_disabled2 = true;
            Utils.showMessage("Please wait while completing the task.\nOnly the glass and hand tool are enabled.");
            return;
        }
        Displayable active = this.display.getActive();
        if (this.isTransforming() && 10 != tool) {
            Utils.logAll("Notice: the 'Select' tool is not active!\n Activate the 'Select' tool to operate transformation modes.");
        }
        switch (tool) {
            case 15: {
                if (null == active || !active.isVisible() || active.getClass() != Profile.class) break;
                Profile prof = (Profile)active;
                this.freehandProfile = new FreeHandProfile(prof);
                this.freehandProfile.mousePressed(this.x_p, this.y_p);
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: {
                super.mousePressed(me);
                this.repaint();
                return;
            }
            case 13: {
                this.setDrawingColor(this.x_p, this.y_p, me.isAltDown());
                return;
            }
        }
        if (this.display.isReadOnly()) {
            return;
        }
        switch (tool) {
            case 9: {
                if (!this.isTransforming()) {
                    if (null == active || !active.contains(this.x_p, this.y_p)) {
                        this.display.choose(me.getX(), me.getY(), this.x_p, this.y_p, DLabel.class);
                        active = this.display.getActive();
                    }
                    if (null != active && active.isVisible() && active instanceof DLabel) {
                        ((DLabel)active).edit();
                    } else {
                        DLabel label = new DLabel(this.display.getProject(), "  ", this.x_p, this.y_p);
                        this.display.getLayer().add(label);
                        label.edit();
                    }
                }
                return;
            }
        }
        if (tool < 10) {
            return;
        }
        this.imp.killRoi();
        Selection selection = this.display.getSelection();
        if (this.isTransforming()) {
            this.box = this.display.getMode().getRepaintBounds();
            this.display.getMode().mousePressed(me, this.x_p, this.y_p, this.magnification);
            return;
        }
        if (10 == tool) {
            this.display.choose(me.getX(), me.getY(), this.x_p, this.y_p, me.isShiftDown(), null);
        }
        active = this.display.getActive();
        selection = this.display.getSelection();
        if (null == active || !active.isVisible()) {
            return;
        }
        switch (tool) {
            case 10: {
                this.box = this.display.getMode().getRepaintBounds();
                if (selection.isLocked()) {
                    this.locked = true;
                    return;
                }
                this.display.getMode().mousePressed(me, this.x_p, this.y_p, this.magnification);
                break;
            }
            default: {
                this.display.getLayerSet().addPreDataEditStep(active);
                this.box = active.getBoundingBox();
                active.mousePressed(me, this.display.getLayer(), this.x_p, this.y_p, this.magnification);
                this.invalidateVolatile();
            }
        }
    }

    public void mouseDragged(MouseEvent me) {
        this.flags = me.getModifiers();
        if (this.popup) {
            return;
        }
        if (this.x_p < this.srcRect.x || this.y_p < this.srcRect.y || this.x_p > this.srcRect.x + this.srcRect.width || this.y_p > this.srcRect.y + this.srcRect.height) {
            return;
        }
        if (10 == ProjectToolbar.getToolId() && this.locked) {
            Utils.log2("Selection is locked.");
            return;
        }
        this.dragging = true;
        this.x_d_old = this.x_d;
        this.y_d_old = this.y_d;
        this.x_d = this.srcRect.x + (int)((double)me.getX() / this.magnification);
        this.y_d = this.srcRect.y + (int)((double)me.getY() / this.magnification);
        this.xMouse = this.x_d;
        this.yMouse = this.y_d;
        int me_x = me.getX();
        int me_y = me.getY();
        if (me_x < 0 || me_x > this.getWidth() || me_y < 0 || me_y > this.getHeight()) {
            this.x_d = this.x_d_old;
            this.y_d = this.y_d_old;
            return;
        }
        int tool = ProjectToolbar.getToolId();
        switch (tool) {
            case 11: {
                return;
            }
            case 12: {
                int srx = this.srcRect.x;
                int sry = this.srcRect.y;
                this.scroll(me.getX(), me.getY());
                if (0 != srx - this.srcRect.x || 0 != sry - this.srcRect.y) {
                    this.update_graphics = true;
                    this.display.getNavigator().repaint(false);
                    this.repaint(true);
                }
                return;
            }
        }
        if (this.input_disabled2) {
            return;
        }
        Displayable active = this.display.getActive();
        if (null != active && active.getClass() == Profile.class) {
            try {
                if (this.r == null) {
                    this.r = new Robot(this.getGraphicsConfiguration().getDevice());
                }
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }
        switch (tool) {
            case 15: {
                if (null == active || !active.isVisible() || active.getClass() != Profile.class) break;
                if (this.freehandProfile == null) {
                    return;
                }
                double dx = this.x_d - this.x_d_old;
                double dy = this.y_d - this.y_d_old;
                this.freehandProfile.mouseDragged(me, this.x_d, this.y_d, dx, dy);
                this.repaint();
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: {
                super.mouseDragged(me);
                this.repaint(false);
                return;
            }
        }
        if (tool < 10) {
            return;
        }
        this.imp.killRoi();
        if (this.display.isReadOnly()) {
            return;
        }
        if (null != active && active.isVisible()) {
            if (this.display.getLayer().contains(this.x_d, this.y_d, 1)) {
                switch (tool) {
                    case 10: {
                        this.display.getMode().mouseDragged(me, this.x_p, this.y_p, this.x_d, this.y_d, this.x_d_old, this.y_d_old);
                        Rectangle box2 = this.display.getMode().getRepaintBounds();
                        this.box.add(box2);
                        Display.repaint(this.display.getLayer(), Selection.PADDING, this.box, false, active.isLinked() || active.getClass() == Patch.class);
                        this.box = box2;
                        break;
                    }
                    default: {
                        active.mouseDragged(me, this.display.getLayer(), this.x_p, this.y_p, this.x_d, this.y_d, this.x_d_old, this.y_d_old);
                        break;
                    }
                }
            } else {
                Utils.log("DisplayCanvas.mouseDragged: preventing drag beyond layer limits.");
            }
        } else if ((this.display.getMode() instanceof ManualAlignMode || this.display.getMode() instanceof InspectPatchTrianglesMode) && this.display.getLayer().contains(this.x_d, this.y_d, 1) && tool >= 10) {
            this.display.getMode().mouseDragged(me, this.x_p, this.y_p, this.x_d, this.y_d, this.x_d_old, this.y_d_old);
        }
    }

    public void mouseReleased(MouseEvent me) {
        this.flags = me.getModifiers();
        boolean dragging2 = this.dragging;
        this.dragging = false;
        boolean locked2 = this.locked;
        this.locked = false;
        if (this.popup) {
            this.popup = false;
            return;
        }
        if (this.x_p < this.srcRect.x || this.y_p < this.srcRect.y || this.x_p > this.srcRect.x + this.srcRect.width || this.y_p > this.srcRect.y + this.srcRect.height) {
            return;
        }
        int tool = ProjectToolbar.getToolId();
        switch (tool) {
            case 11: {
                this.display.updateFrameTitle();
                return;
            }
            case 12: {
                this.display.updateInDatabase("srcRect");
                if (-1 != this.tmp_tool) {
                    ProjectToolbar.setTool(this.tmp_tool);
                    this.tmp_tool = -1;
                }
                if (!dragging2) {
                    this.repaint(true);
                }
                this.display.getMode().srcRectUpdated(this.srcRect, this.magnification);
                return;
            }
        }
        if (this.input_disabled2) {
            this.input_disabled2 = false;
            return;
        }
        if (locked2 && 10 == tool) {
            if (dragging2) {
                Utils.showMessage("Selection is locked!");
            }
            return;
        }
        this.flags &= 0xFFFFFFEF;
        this.flags &= 0xFFFFFFF7;
        this.flags &= 0xFFFFFFFB;
        int x_r = this.srcRect.x + (int)((double)me.getX() / this.magnification);
        int y_r = this.srcRect.y + (int)((double)me.getY() / this.magnification);
        this.xMouse = x_r;
        this.yMouse = y_r;
        Displayable active = this.display.getActive();
        switch (tool) {
            case 15: {
                if (null == active || !active.isVisible() || active.getClass() != Profile.class) break;
                if (this.freehandProfile == null) {
                    return;
                }
                this.freehandProfile.mouseReleased(me, this.x_p, this.y_p, this.x_d, this.y_d, x_r, y_r);
                this.freehandProfile = null;
                Selection selection = this.display.getSelection();
                selection.updateTransform(this.display.getActive());
                Display.repaint(this.display.getLayer(), selection.getBox(), Selection.PADDING);
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: {
                super.mouseReleased(me);
                this.repaint();
            }
        }
        Roi roi = this.imp.getRoi();
        if (this.display.isReadOnly()) {
            return;
        }
        if (tool >= 10) {
            if (null != roi) {
                this.imp.killRoi();
            }
        } else {
            return;
        }
        Selection selection = this.display.getSelection();
        if (this.snapping) {
            this.display.getMode().mouseReleased(me, this.x_p, this.y_p, this.x_d, this.y_d, x_r, y_r);
            this.box.add(this.display.getMode().getRepaintBounds());
            Display.repaint(this.display.getLayer(), this.box, Selection.PADDING);
            Display.snap((Patch)active);
            this.snapping = false;
            return;
        }
        if (null != active && active.isVisible()) {
            switch (tool) {
                case 10: {
                    this.display.getMode().mouseReleased(me, this.x_p, this.y_p, this.x_d, this.y_d, x_r, y_r);
                    this.box.add(this.display.getMode().getRepaintBounds());
                    Display.repaint(this.display.getLayer(), Selection.PADDING, this.box, !this.isTransforming(), active.isLinked() || active.getClass() == Patch.class);
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    active.mouseReleased(me, this.display.getLayer(), this.x_p, this.y_p, this.x_d, this.y_d, x_r, y_r);
                    selection.updateTransform(active);
                    this.box.add(selection.getBox());
                    Display.repaint(this.display.getLayer(), Selection.PADDING, this.box, !this.isTransforming(), active.isLinked() || active.getClass() == Patch.class);
                    if (null != this.old_brush_box) {
                        this.repaint(this.old_brush_box, 0, false);
                        this.old_brush_box = null;
                    }
                    this.display.getLayerSet().addDataEditStep(active);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent me) {
        this.mouse_in = true;
        if (this.display.isActiveWindow() && !this.hasFocus()) {
            this.requestFocus();
        }
    }

    public void mouseExited(MouseEvent me) {
        Displayable active;
        this.mouse_in = false;
        if (ProjectToolbar.getToolId() == 17 && null != (active = this.display.getActive()) && active.isVisible() && AreaContainer.class.isInstance(active) && null != this.old_brush_box) {
            this.repaint(this.old_brush_box, 0);
            this.old_brush_box = null;
        }
    }

    public void setCursor(int sx, int sy, int ox, int oy) {
        this.xMouse = ox;
        this.yMouse = oy;
        Roi roi = this.imp.getRoi();
        if (IJ.spaceBarDown()) {
            this.setCursor(handCursor);
            return;
        }
        switch (Toolbar.getToolId()) {
            case 11: {
                if (IJ.isMacintosh()) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(moveCursor);
                break;
            }
            case 12: {
                this.setCursor(handCursor);
                break;
            }
            case 10: 
            case 15: {
                this.setCursor(defaultCursor);
                break;
            }
            default: {
                if (roi != null && roi.getState() != 0 && roi.isHandle(sx, sy) >= 0) {
                    this.setCursor(handCursor);
                    break;
                }
                if (Prefs.usePointerCursor || roi != null && roi.getState() != 0 && roi.contains(ox, oy)) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(crosshairCursor);
            }
        }
    }

    protected void setSrcRect(int x, int y, int width, int height) {
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        this.srcRect.setRect(x, y, width, height);
        this.display.updateInDatabase("srcRect");
        this.display.getMode().srcRectUpdated(this.srcRect, this.magnification);
    }

    public void setDrawingSize(int new_width, int new_height) {
        this.adjustSrcRect(new_width, new_height);
        super.setDrawingSize(new_width, new_height);
    }

    public void adjustDimensions() {
        Rectangle r = this.getBounds();
        this.adjustSrcRect(r.width, r.height);
        this.dstWidth = r.width;
        this.dstHeight = r.height;
    }

    public void adjustSrcRect(int new_width, int new_height) {
        double mag = super.getMagnification();
        if ((double)this.srcRect.width * mag < (double)new_width) {
            if ((double)new_width > (double)this.imageWidth * mag) {
                this.srcRect.x = 0;
                this.srcRect.width = this.imageWidth;
            } else {
                this.srcRect.width = (int)Math.ceil((double)new_width / mag);
                if (this.srcRect.x + this.srcRect.width > this.imageWidth) {
                    this.srcRect.x = this.imageWidth - this.srcRect.width;
                }
            }
        } else {
            this.srcRect.width = (int)Math.ceil((double)new_width / mag);
        }
        if ((double)this.srcRect.height * mag < (double)new_height) {
            if ((double)new_height > (double)this.imageHeight * mag) {
                this.srcRect.y = 0;
                this.srcRect.height = this.imageHeight;
            } else {
                this.srcRect.height = (int)Math.ceil((double)new_height / mag);
                if (this.srcRect.y + this.srcRect.height > this.imageHeight) {
                    this.srcRect.y = this.imageHeight - this.srcRect.height;
                }
            }
        } else {
            this.srcRect.height = (int)Math.ceil((double)new_height / mag);
        }
    }

    private void zoomIn2(int x, int y) {
        int h;
        if (this.magnification >= 32.0) {
            return;
        }
        double newMag = this.getHigherZoomLevel2(this.magnification);
        int cx = this.getWidth() / 2;
        int cy = this.getHeight() / 2;
        int dx = (int)((double)(x - cx) * this.magnification / newMag);
        int dy = (int)((double)(y - cy) * this.magnification / newMag);
        x -= dx;
        y -= dy;
        int w = (int)Math.round((double)this.dstWidth / newMag);
        if ((double)w * newMag < (double)this.dstWidth) {
            ++w;
        }
        if (w > this.imageWidth) {
            w = this.imageWidth;
        }
        if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
            ++h;
        }
        if (h > this.imageHeight) {
            h = this.imageHeight;
        }
        x = this.offScreenX(x);
        y = this.offScreenY(y);
        Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
        if (r.x < 0) {
            r.x = 0;
        }
        if (r.y < 0) {
            r.y = 0;
        }
        if (r.x + w > this.imageWidth) {
            r.x = this.imageWidth - w;
        }
        if (r.y + h > this.imageHeight) {
            r.y = this.imageHeight - h;
        }
        this.srcRect = r;
        this.setMagnification(newMag);
        this.display.updateInDatabase("srcRect");
        this.display.repaintAll2();
    }

    private void zoomOut2(int x, int y) {
        double newMag = this.getLowerZoomLevel2(this.magnification);
        int cx = this.getWidth() / 2;
        int cy = this.getHeight() / 2;
        int dx = (int)((double)(x - cx) * this.magnification / newMag);
        int dy = (int)((double)(y - cy) * this.magnification / newMag);
        x -= dx;
        y -= dy;
        if ((double)this.imageWidth * newMag > (double)this.dstWidth || (double)this.imageHeight * newMag > (double)this.dstHeight) {
            int h;
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            x = this.offScreenX(x);
            y = this.offScreenY(y);
            Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if (r.x + w > this.imageWidth) {
                r.x = this.imageWidth - w;
            }
            if (r.y + h > this.imageHeight) {
                r.y = this.imageHeight - h;
            }
            this.srcRect = r;
        } else {
            this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        }
        this.setMagnification(newMag);
        this.display.repaintAll2();
        this.display.updateInDatabase("srcRect");
    }

    protected double getLowerZoomLevel2(double currentMag) {
        if (Math.abs(currentMag - 0.013888888888888888) < 1.0E-8 || currentMag < 0.013888888888888888) {
            int level = 7;
            double scale = currentMag;
            while (scale * (double)this.srcRect.width > 10.0 && scale * (double)this.srcRect.height > 10.0 && (Math.abs((scale = 1.0 / Math.pow(2.0, level)) - currentMag) == 1.0E-8 || !(scale < currentMag))) {
                ++level;
            }
            return scale;
        }
        return ImageCanvas.getLowerZoomLevel((double)currentMag);
    }

    protected double getHigherZoomLevel2(double currentMag) {
        if (Math.abs(currentMag - 0.013888888888888888) > 1.0E-8 && currentMag < 0.013888888888888888) {
            double scale = currentMag;
            for (int level = 14; level >= 0 && !((scale = 1.0 / Math.pow(2.0, level)) > currentMag); --level) {
            }
            return scale;
        }
        return ImageCanvas.getHigherZoomLevel((double)currentMag);
    }

    public List<Displayable> getDisplayablesUnderMouse() {
        return this.getDisplayablesUnderMouse(new MouseEvent((Component)((Object)this), -1, 0L, 0, this.xMouse, this.yMouse, 1, false));
    }

    public List<Displayable> getDisplayablesUnderMouse(MouseEvent me) {
        Layer layer = this.display.getLayer();
        int x_p = this.offScreenX(me.getX());
        int y_p = this.offScreenY(me.getY());
        ArrayList<Displayable> al = new ArrayList<Displayable>(layer.getParent().findZDisplayables(layer, x_p, y_p, true));
        Collections.reverse(al);
        ArrayList<Displayable> al2 = new ArrayList<Displayable>(layer.find(x_p, (double)y_p, true));
        Collections.reverse(al2);
        al.addAll(al2);
        return al;
    }

    public boolean isDragging() {
        return this.display.getMode().isDragging();
    }

    public void mouseMoved(MouseEvent me) {
        this.flags = me.getModifiers();
        int tool = Toolbar.getToolId();
        switch (tool) {
            case 2: 
            case 5: 
            case 14: {
                super.mouseMoved(me);
                this.repaint();
                return;
            }
        }
        this.mouse_moved.dispatch(me);
    }

    public void zoomIn() {
        if (this.xMouse < 0 || this.screenX(this.xMouse) > this.dstWidth || this.yMouse < 0 || this.screenY(this.yMouse) > this.dstHeight) {
            this.zoomIn(this.dstWidth / 2, this.dstHeight / 2);
        } else {
            this.zoomIn(this.screenX(this.xMouse), this.screenY(this.yMouse));
        }
    }

    public void zoomIn(int x, int y) {
        this.update_graphics = true;
        this.zoomIn2(x, y);
    }

    public void zoomOut() {
        if (this.xMouse < 0 || this.screenX(this.xMouse) > this.dstWidth || this.yMouse < 0 || this.screenY(this.yMouse) > this.dstHeight) {
            this.zoomOut(this.dstWidth / 2, this.dstHeight / 2);
        } else {
            this.zoomOut(this.screenX(this.xMouse), this.screenY(this.yMouse));
        }
    }

    public void zoomOut(int x, int y) {
        this.update_graphics = true;
        this.zoomOut2(x, y);
    }

    public void showCentered(Rectangle r) {
        r.x -= r.width / 2;
        r.y -= r.height / 2;
        r.width += r.width;
        r.height += r.height;
        double magn = (double)this.getWidth() / (double)(r.width > r.height ? r.width : r.height);
        this.center(r, magn);
    }

    public void center(Rectangle r, double magn) {
        double lw = this.display.getLayer().getLayerWidth();
        double lh = this.display.getLayer().getLayerHeight();
        int cw = (int)((double)this.getWidth() / magn);
        int ch = (int)((double)this.getHeight() / magn);
        r.y += (r.height - ch) / 2;
        r.width = cw;
        r.height = ch;
        if (r.x < 0) {
            r.x = 0;
        }
        if (r.y < 0) {
            r.y = 0;
        }
        if ((double)r.width > lw) {
            r.x = 0;
            r.width = (int)lw;
        }
        if ((double)r.height > lh) {
            r.y = 0;
            r.height = (int)lh;
        }
        if ((double)(r.x + r.width) > lw) {
            r.x = (int)(lw - (double)cw);
        }
        if ((double)(r.y + r.height) > lh) {
            r.y = (int)(lh - (double)ch);
        }
        magn = (double)this.getWidth() / (double)r.width;
        this.setup(magn, r);
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update_graphics = true;
        this.RT.paint(null, this.update_graphics);
        this.display.updateInDatabase("srcRect");
        this.display.updateFrameTitle();
        this.display.getNavigator().repaint(false);
    }

    public void repaint(Displayable d) {
        this.repaint(d, 0);
    }

    public void repaint(Displayable displ, int extra) {
        this.repaint(displ, extra, this.update_graphics);
    }

    public void repaint(Displayable displ, int extra, boolean update_graphics) {
        if (null != displ) {
            Rectangle r = displ.getBoundingBox();
            r.x = (int)((double)(r.x - this.srcRect.x) * this.magnification) - extra;
            r.y = (int)((double)(r.y - this.srcRect.y) * this.magnification) - extra;
            r.width = (int)Math.ceil((double)r.width * this.magnification) + extra + extra;
            r.height = (int)Math.ceil((double)r.height * this.magnification) + extra + extra;
            this.invalidateVolatile();
            this.RT.paint(r, update_graphics);
        } else {
            this.repaint(true);
        }
    }

    public void repaint(HashSet<Displayable> hs) {
        if (null == hs) {
            return;
        }
        Rectangle r = null;
        Layer dl = this.display.getLayer();
        for (Displayable d : hs) {
            if (d.getLayer() != dl) continue;
            if (null == r) {
                r = d.getBoundingBox();
                continue;
            }
            r.add(d.getBoundingBox());
        }
        if (null != r) {
            this.invalidateVolatile();
            this.RT.paint(r, this.update_graphics);
        }
    }

    public void repaint(Rectangle r, int extra) {
        this.invalidateVolatile();
        if (null == r) {
            this.RT.paint(null, this.update_graphics);
            return;
        }
        this.RT.paint(new Rectangle((int)((double)(r.x - this.srcRect.x) * this.magnification) - extra, (int)((double)(r.y - this.srcRect.y) * this.magnification) - extra, (int)Math.ceil((double)r.width * this.magnification) + extra + extra, (int)Math.ceil((double)r.height * this.magnification) + extra + extra), this.update_graphics);
    }

    public void repaint(Rectangle box, int extra, boolean update_graphics) {
        this.update_graphics = update_graphics;
        this.repaint(box, extra);
    }

    public void repaint(boolean update_graphics) {
        this.update_graphics = update_graphics | this.update_graphics;
        this.invalidateVolatile();
        this.RT.paint(null, this.update_graphics);
    }

    public void repaint() {
        this.invalidateVolatile();
        this.RT.paint(null, this.update_graphics);
    }

    public void repaint(int x, int y, int width, int height) {
        this.invalidateVolatile();
        this.RT.paint(new Rectangle(x, y, width, height), this.update_graphics);
    }

    public void setUpdateGraphics(boolean b) {
        this.update_graphics = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.RT.quit();
        Object object = this.offscreen_lock;
        synchronized (object) {
            if (null != this.offscreen) {
                this.offscreen.flush();
                this.offscreen = null;
            }
            this.update_graphics = true;
            for (BufferedImage bi : this.to_flush) {
                bi.flush();
            }
            this.to_flush.clear();
        }
        this.mouse_moved.quit();
        try {
            object = this;
            synchronized (object) {
                if (null != this.animator) {
                    this.animator.shutdownNow();
                }
            }
            this.cancelAnimations();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.animator = null;
    }

    public void destroy() {
        this.flush();
        WindowManager.setTempCurrentImage((ImagePlus)this.imp);
        WindowManager.removeWindow((Frame)((Object)this.fake_win));
    }

    public boolean applyTransform() {
        boolean b = this.display.getMode().apply();
        if (b) {
            this.display.setMode(new DefaultMode(this.display));
            Display.repaint();
        }
        return b;
    }

    public boolean isTransforming() {
        return this.display.getMode().getClass() != DefaultMode.class;
    }

    public void cancelTransform() {
        this.display.getMode().cancel();
        this.display.setMode(new DefaultMode(this.display));
        this.repaint(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent ke) {
        Displayable active = this.display.getActive();
        if (null != this.freehandProfile && ProjectToolbar.getToolId() == 15 && ke.getKeyCode() == 27 && null != this.freehandProfile) {
            this.freehandProfile.abort();
            ke.consume();
            return;
        }
        int keyCode = ke.getKeyCode();
        try {
            if (!this.input_disabled && null != active && active instanceof Tree && ProjectToolbar.isDataEditTool(ProjectToolbar.getToolId())) {
                if (this.tagging) {
                    if (48 != keyCode || 48 == this.last_keyCode) {
                        this.tagging = false;
                    }
                    active.keyPressed(ke);
                    return;
                }
                if (84 == keyCode) {
                    this.tagging = true;
                    active.keyPressed(ke);
                    return;
                }
            }
        }
        finally {
            this.last_keyCode = keyCode;
        }
        this.tagging = false;
        if (ke.isConsumed()) {
            return;
        }
        if (!this.zoom_and_pan) {
            if (27 == keyCode) {
                this.cancelAnimations();
            }
            return;
        }
        char keyChar = ke.getKeyChar();
        boolean used = false;
        switch (keyChar) {
            case '+': 
            case '=': {
                this.zoomIn();
                used = true;
                break;
            }
            case '-': 
            case '_': {
                this.zoomOut();
                used = true;
                break;
            }
        }
        if (used) {
            ke.consume();
            return;
        }
        if (this.input_disabled) {
            if (27 == keyCode && Utils.checkYN("Really cancel job?")) {
                this.display.getProject().getLoader().quitJob(null);
                this.display.repairGUI();
            }
            ke.consume();
            return;
        }
        if (83 == keyCode && 0 == ke.getModifiers() && this.display.getProject().getLoader().isAsynchronous()) {
            this.display.getProject().getLoader().saveTask(this.display.getProject(), "Save");
            ke.consume();
            return;
        }
        if (70 == keyCode && Utils.isControlDown(ke)) {
            Search.showWindow();
            ke.consume();
            return;
        }
        switch (keyChar) {
            case ',': 
            case '<': {
                this.display.previousLayer(ke.getModifiers());
                ke.consume();
                return;
            }
            case '.': 
            case '>': {
                this.display.nextLayer(ke.getModifiers());
                ke.consume();
                return;
            }
        }
        if (null == active && null != this.imp.getRoi() && 65 != keyCode) {
            IJ.getInstance().keyPressed(ke);
            return;
        }
        if (this.display.isReadOnly()) {
            ke.consume();
            this.display.repaintAll();
            return;
        }
        if (10 == keyCode) {
            if (this.isTransforming()) {
                this.applyTransform();
                ke.consume();
                return;
            }
            IJ.getInstance().toFront();
            ke.consume();
            return;
        }
        Layer layer = this.display.getLayer();
        int mod = ke.getModifiers();
        switch (keyCode) {
            case 44: 
            case 188: {
                this.display.nextLayer(ke.getModifiers());
                break;
            }
            case 46: 
            case 190: {
                this.display.previousLayer(ke.getModifiers());
                break;
            }
            case 90: {
                if (0 == (mod ^ 1) || 0 == (mod ^ Utils.getControlModifier())) {
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Undo"){

                        @Override
                        public void exec() {
                            if (DisplayCanvas.this.isTransforming()) {
                                DisplayCanvas.this.display.getMode().undoOneStep();
                            } else {
                                DisplayCanvas.this.display.getLayerSet().undoOneStep();
                            }
                            Display.repaint(DisplayCanvas.this.display.getLayerSet());
                        }
                    }, this.display.getProject());
                    ke.consume();
                    break;
                }
                if (0 != (mod ^ 8) && 0 != (mod ^ (1 | Utils.getControlModifier()))) break;
                Bureaucrat.createAndStart((Worker)new Worker.Task("Redo"){

                    @Override
                    public void exec() {
                        if (DisplayCanvas.this.isTransforming()) {
                            DisplayCanvas.this.display.getMode().redoOneStep();
                        } else {
                            DisplayCanvas.this.display.getLayerSet().redoOneStep();
                        }
                        Display.repaint(DisplayCanvas.this.display.getLayerSet());
                    }
                }, this.display.getProject());
                ke.consume();
                break;
            }
            case 84: {
                if (null == active || this.isTransforming() || ProjectToolbar.getToolId() >= 15) break;
                ProjectToolbar.setTool(10);
                if (0 == ke.getModifiers()) {
                    this.display.setMode(new AffineTransformMode(this.display));
                } else if (1 == ke.getModifiers()) {
                    for (Displayable d : this.display.getSelection().getSelected()) {
                        if (!d.isLinked()) continue;
                        Utils.showMessage("Can't enter manual non-linear transformation mode:\nat least one image is linked.");
                        return;
                    }
                    this.display.setMode(new NonLinearTransformMode(this.display));
                }
                ke.consume();
                break;
            }
            case 65: {
                if (0 == (ke.getModifiers() ^ Utils.getControlModifier())) {
                    Roi roi = this.getFakeImagePlus().getRoi();
                    if (null != roi) {
                        this.display.getSelection().selectAll(roi, true);
                    } else {
                        this.display.getSelection().selectAllVisible();
                    }
                    Display.repaint(this.display.getLayer(), this.display.getSelection().getBox(), 0);
                    ke.consume();
                    break;
                }
                if (null == active) break;
                active.keyPressed(ke);
                if (!ke.isConsumed()) break;
                break;
            }
            case 27: {
                if (this.isTransforming()) {
                    this.cancelTransform();
                } else {
                    this.display.select(null);
                    if (17 == ProjectToolbar.getToolId()) {
                        this.repaint(this.old_brush_box, 0);
                    }
                }
                ke.consume();
                break;
            }
            case 32: {
                if (0 == ke.getModifiers()) {
                    if (null == active) break;
                    this.invalidateVolatile();
                    if (Math.abs(active.getAlpha() - 0.5f) > 0.001f) {
                        active.setAlpha(0.5f);
                    } else {
                        active.setAlpha(1.0f);
                    }
                    this.display.setTransparencySlider(active.getAlpha());
                    Display.repaint();
                    ke.consume();
                    break;
                }
                int kem = ke.getModifiers();
                if (0 == (kem & 1) || 0 == (kem & 8) || 0 == (kem & 2)) break;
                Utils.showMessage("A mathematician, like a painter or poet,\nis a maker of patterns.\nIf his patterns are more permanent than theirs,\nit is because they are made with ideas\n \nG. H. Hardy.");
                ke.consume();
                break;
            }
            case 83: {
                if (ke.isAltDown()) {
                    this.snapping = true;
                    ke.consume();
                    break;
                }
                if (!this.dragging) break;
                ke.consume();
                break;
            }
            case 72: {
                this.handleHide(ke);
                ke.consume();
                break;
            }
            case 74: {
                if (this.display.getSelection().isEmpty()) break;
                this.display.adjustMinAndMaxGUI();
                ke.consume();
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                ProjectToolbar.keyPressed(ke);
                ke.consume();
                break;
            }
            case 77: {
                if (0 != ke.getModifiers() || ProjectToolbar.getToolId() != 10) break;
                this.display.getSelection().measure();
                ke.consume();
            }
        }
        switch (keyChar) {
            case ':': 
            case ';': {
                if (null == active || !(active instanceof ZDisplayable)) break;
                if (null != this.display.getProject().getProjectTree().tryAddNewConnector(active, true)) {
                    ProjectToolbar.setTool(16);
                }
                ke.consume();
            }
        }
        if (ke.isConsumed()) {
            return;
        }
        if (null != active) {
            if (this.display.getMode().getClass() == DefaultMode.class) {
                active.keyPressed(ke);
            }
            if (ke.isConsumed()) {
                return;
            }
        }
        switch (keyCode) {
            case 71: {
                if (!this.browseToNodeLayer(ke.isShiftDown())) break;
                ke.consume();
                break;
            }
            case 73: {
                if (!ke.isAltDown()) break;
                if (ke.isShiftDown()) {
                    this.display.importImage();
                } else {
                    this.display.importNextImage();
                }
                ke.consume();
                break;
            }
            case 33: {
                if (null == active) break;
                this.update_graphics = true;
                layer.getParent().addUndoMoveStep(active);
                layer.getParent().move(14, active);
                layer.getParent().addUndoMoveStep(active);
                Display.repaint(layer, active, 5);
                Display.updatePanelIndex(layer, active);
                ke.consume();
                break;
            }
            case 34: {
                if (null == active) break;
                this.update_graphics = true;
                layer.getParent().addUndoMoveStep(active);
                layer.getParent().move(15, active);
                layer.getParent().addUndoMoveStep(active);
                Display.repaint(layer, active, 5);
                Display.updatePanelIndex(layer, active);
                ke.consume();
                break;
            }
            case 36: {
                if (null == active) break;
                this.update_graphics = true;
                layer.getParent().addUndoMoveStep(active);
                layer.getParent().move(13, active);
                layer.getParent().addUndoMoveStep(active);
                Display.repaint(layer, active, 5);
                Display.updatePanelIndex(layer, active);
                ke.consume();
                break;
            }
            case 35: {
                if (null == active) break;
                this.update_graphics = true;
                layer.getParent().addUndoMoveStep(active);
                layer.getParent().move(16, active);
                layer.getParent().addUndoMoveStep(active);
                Display.repaint(layer, active, 5);
                Display.updatePanelIndex(layer, active);
                ke.consume();
                break;
            }
            case 86: {
                if (0 != ke.getModifiers()) break;
                if (null == active || active.getClass() == Patch.class) {
                    ImagePlus clipboard = ImagePlus.getClipboard();
                    if (null == clipboard) break;
                    ImagePlus imp = new ImagePlus(clipboard.getTitle() + "_" + System.currentTimeMillis(), clipboard.getProcessor().crop());
                    Object info = clipboard.getProperty("Info");
                    if (null != info) {
                        imp.setProperty("Info", (Object)((String)info));
                    }
                    double x = this.srcRect.x + this.srcRect.width / 2 - imp.getWidth() / 2;
                    double y = this.srcRect.y + this.srcRect.height / 2 - imp.getHeight() / 2;
                    Patch pa = this.display.getProject().getLoader().addNewImage(imp, x, y);
                    this.display.getLayer().add(pa);
                    ke.consume();
                    break;
                }
                active.keyPressed(ke);
                ke.consume();
                break;
            }
            case 80: {
                if (0 != ke.getModifiers()) break;
                this.display.getLayerSet().color_cues = !this.display.getLayerSet().color_cues;
                Display.repaint(this.display.getLayerSet());
                ke.consume();
                break;
            }
            case 70: {
                if (0 == (ke.getModifiers() ^ 1)) {
                    this.display.getLayerSet().paint_tags = !this.display.getLayerSet().paint_tags;
                    Display.repaint();
                    ke.consume();
                    break;
                }
                if (0 == (ke.getModifiers() ^ 8)) {
                    this.display.getLayerSet().paint_arrows = !this.display.getLayerSet().paint_arrows;
                    Display.repaint();
                    ke.consume();
                    break;
                }
                if (0 != ke.getModifiers()) break;
                this.display.getLayerSet().paint_edge_confidence_boxes = !this.display.getLayerSet().paint_edge_confidence_boxes;
                Display.repaint();
                ke.consume();
                break;
            }
            case 127: {
                if (0 != ke.getModifiers()) break;
                this.display.getSelection().deleteAll();
                break;
            }
            case 66: {
                if (0 != ke.getModifiers() || null == active || active.getClass() != Profile.class) break;
                this.display.duplicateLinkAndSendTo(active, 0, active.getLayer().getParent().previous(layer));
                ke.consume();
                break;
            }
            case 78: {
                if (0 != ke.getModifiers() || null == active || active.getClass() != Profile.class) break;
                this.display.duplicateLinkAndSendTo(active, 1, active.getLayer().getParent().next(layer));
                ke.consume();
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (null == Utils.launchTPlugIn(ke, "Display", this.display.getProject(), this.display.getActive())) break;
                ke.consume();
            }
        }
        if (keyCode != 0 && keyChar != '\uffff' && !ke.isConsumed() && null != active && active instanceof Patch) {
            IJ.getInstance().keyPressed(ke);
            this.repaint(active, 5);
            ke.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    public void zoomToFit() {
        double magh;
        double magw = (double)this.getWidth() / (double)this.imageWidth;
        this.magnification = magw < (magh = (double)this.getHeight() / (double)this.imageHeight) ? magw : magh;
        this.srcRect.setRect(0.0, 0.0, this.imageWidth, this.imageHeight);
        this.setMagnification(this.magnification);
        this.display.updateInDatabase("srcRect");
    }

    public void setReceivesInput(boolean b) {
        this.input_disabled = !b;
    }

    public boolean isInputEnabled() {
        return !this.input_disabled;
    }

    public ImagePlus getFakeImagePlus() {
        return this.imp;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        if (this.dragging) {
            return;
        }
        int modifiers = mwe.getModifiers();
        int rotation = mwe.getWheelRotation();
        int tool = ProjectToolbar.getToolId();
        if (0 != (modifiers & Utils.getControlModifier())) {
            int h;
            if (!this.zoom_and_pan) {
                return;
            }
            int x = mwe.getX();
            int y = mwe.getY();
            if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
                x = this.getWidth() / 2;
                y = this.getHeight() / 2;
            }
            double xx = (double)x / this.magnification + (double)this.srcRect.x;
            double yy = (double)y / this.magnification + (double)this.srcRect.y;
            int px_inc = 0 != (modifiers & 1) ? (0 != (modifiers & 8) ? 1 : 5) : 20;
            double inc = (double)px_inc / this.magnification;
            Rectangle r = new Rectangle();
            if (rotation > 0) {
                r.width = this.srcRect.width + (int)(inc + 0.5);
                r.height = this.srcRect.height + (int)(inc + 0.5);
                r.x = (int)(xx - (xx - (double)this.srcRect.x) / (double)this.srcRect.width * (double)r.width + 0.5);
                r.y = (int)(yy - (yy - (double)this.srcRect.y) / (double)this.srcRect.height * (double)r.height + 0.5);
                if ((double)r.width * this.magnification < (double)this.getWidth() || (double)r.height * this.magnification < (double)this.getHeight()) {
                    Utils.showStatus("To zoom more, use -/+ keys");
                    return;
                }
            } else {
                r.width = this.srcRect.width - (int)(inc + 0.5);
                r.height = this.srcRect.height - (int)(inc + 0.5);
                if (r.width < 1 || r.height < 1) {
                    return;
                }
                r.x = (int)(xx - (xx - (double)this.srcRect.x) / (double)this.srcRect.width * (double)r.width + 0.5);
                r.y = (int)(yy - (yy - (double)this.srcRect.y) / (double)this.srcRect.height * (double)r.height + 0.5);
            }
            double newMag = this.magnification * ((double)this.srcRect.width / (double)r.width);
            r.x -= (int)((double)x / newMag + (double)r.x - xx);
            r.y -= (int)((double)y / newMag + (double)r.y - yy);
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if (w > this.imageWidth) {
                w = this.imageWidth;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            if (h > this.imageHeight) {
                h = this.imageHeight;
            }
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if (r.x + w > this.imageWidth) {
                r.x = this.imageWidth - w;
            }
            if (r.y + h > this.imageHeight) {
                r.y = this.imageHeight - h;
            }
            this.setMagnification(newMag);
            this.setSrcRect(r.x, r.y, w, h);
            this.display.repaintAll2();
        } else if (0 == (modifiers ^ 1) && null != this.display.getActive() && 16 != tool && AreaContainer.class.isInstance(this.display.getActive())) {
            int sign;
            int n = sign = rotation > 0 ? 1 : -1;
            if (17 == tool) {
                int extra;
                int brushSize;
                int brushSize_old = ProjectToolbar.getBrushSize();
                if (brushSize_old > (brushSize = ProjectToolbar.setBrushSize((int)((double)(5 * sign) / this.magnification)))) {
                    brushSize = brushSize_old;
                }
                if ((extra = (int)(10.0 / this.magnification)) < 2) {
                    extra = 2;
                }
                this.repaint(new Rectangle((int)((double)mwe.getX() / this.magnification) + this.srcRect.x - brushSize / 2 - (extra += 4), (int)((double)mwe.getY() / this.magnification) + this.srcRect.y - brushSize / 2 - extra, brushSize + extra, brushSize + extra), 0);
            } else if (15 == tool || 18 == tool) {
                int w = Segmentation.fmp.width;
                int h = Segmentation.fmp.height;
                Segmentation.fmp.resizeArea(sign, this.magnification);
                w = Math.max(w, Segmentation.fmp.width);
                h = Math.max(h, Segmentation.fmp.height);
                this.repaint(new Rectangle((int)((double)mwe.getX() / this.magnification) + this.srcRect.x - w / 2 + 2, (int)((double)mwe.getY() / this.magnification) + this.srcRect.y - h / 2 + 2, w + 4, h + 4), 0);
            }
        } else if (0 == modifiers) {
            if (rotation > 0) {
                this.display.nextLayer(modifiers);
            } else {
                this.display.previousLayer(modifiers);
            }
        } else if (null != this.display.getActive()) {
            this.display.getActive().mouseWheelMoved(mwe);
        }
    }

    private final int gatherDisplayables(Layer layer, List<Layer> layers, Rectangle srcRect, Displayable active, ArrayList<Displayable> al_paint, ArrayList<Displayable> al_top, boolean preload_patches) {
        Displayable d;
        Collection<Displayable> zdal;
        layer.getParent().checkBuckets();
        layer.checkBuckets();
        Iterator<Displayable> ital = layer.find(srcRect, true).iterator();
        LayerSet layer_set = layer.getParent();
        if (layer_set.color_cues) {
            Collection<Displayable> atlayer = layer_set.roughlyFindZDisplayables(layer, srcRect, true);
            HashSet<Displayable> others = new HashSet<Displayable>();
            for (Layer la : layers) {
                if (la == layer) continue;
                others.addAll(layer_set.roughlyFindZDisplayables(la, srcRect, true));
            }
            others.removeAll(atlayer);
            zdal = new ArrayList<Displayable>(others);
            zdal.addAll(atlayer);
        } else {
            zdal = layer_set.roughlyFindZDisplayables(layer, srcRect, true);
        }
        Iterator<Displayable> itzd = zdal.iterator();
        Displayable tmp = null;
        boolean top = false;
        ArrayList<Patch> al_patches = preload_patches ? new ArrayList<Patch>() : null;
        int first_non_patch = 0;
        while (ital.hasNext()) {
            d = ital.next();
            Class<?> c = d.getClass();
            if (DLabel.class == c || LayerSet.class == c) {
                tmp = d;
                break;
            }
            if (Patch.class == c) {
                al_paint.add(d);
                if (preload_patches) {
                    al_patches.add((Patch)d);
                }
            } else {
                if (!top && d == active) {
                    top = true;
                }
                if (top) {
                    al_top.add(d);
                } else {
                    al_paint.add(d);
                }
            }
            ++first_non_patch;
        }
        if (preload_patches) {
            Loader.preload(al_patches, this.magnification, false);
        }
        while (itzd.hasNext()) {
            Displayable zd = itzd.next();
            if (zd == active) {
                top = true;
            }
            if (top) {
                al_top.add(zd);
                continue;
            }
            al_paint.add(zd);
        }
        if (null != tmp) {
            if (tmp == active) {
                top = true;
            }
            if (top) {
                al_top.add(tmp);
            } else {
                al_paint.add(tmp);
            }
        }
        while (ital.hasNext()) {
            d = ital.next();
            if (d == active) {
                top = true;
            }
            if (top) {
                al_top.add(d);
                continue;
            }
            al_paint.add(d);
        }
        return first_non_patch;
    }

    @Deprecated
    public BufferedImage paintOffscreen(Layer active_layer, int g_width, int g_height, Rectangle srcRect, double magnification, Displayable active, int c_alphas, Rectangle clipRect, Loader loader, HashMap<Color, Layer> hm, ArrayList<LayerPanel> blending_list, int mode, GraphicsSource graphics_source, boolean prepaint, ArrayList<Displayable> al_top) {
        return this.paintOffscreen(active_layer, active_layer.getParent().getColorCueLayerRange(active_layer), g_width, g_height, srcRect, magnification, active, c_alphas, clipRect, loader, hm, blending_list, mode, graphics_source, prepaint, al_top, false);
    }

    public BufferedImage paintOffscreen(Layer active_layer, List<Layer> layers, int g_width, int g_height, Rectangle srcRect, double magnification, Displayable active, int c_alphas, Rectangle clipRect, Loader loader, HashMap<Color, Layer> hm, ArrayList<LayerPanel> blending_list, int mode, GraphicsSource graphics_source, boolean prepaint, ArrayList<Displayable> al_top, boolean preload) {
        ArrayList<Displayable> al_paint = new ArrayList<Displayable>();
        int first_non_patch = this.gatherDisplayables(active_layer, layers, srcRect, active, al_paint, al_top, preload);
        return this.paintOffscreen(active_layer, layers, al_paint, active, g_width, g_height, c_alphas, loader, hm, blending_list, mode, graphics_source, prepaint, first_non_patch);
    }

    /*
     * WARNING - void declaration
     */
    public BufferedImage paintOffscreen(Layer active_layer, List<Layer> layers, ArrayList<Displayable> al_paint, Displayable active, int g_width, int g_height, int c_alphas, Loader loader, HashMap<Color, Layer> hm, ArrayList<LayerPanel> blending_list, int mode, GraphicsSource graphics_source, boolean prepaint, int first_non_patch) {
        try {
            if (0 == g_width || 0 == g_height) {
                return null;
            }
            AffineTransform atc = new AffineTransform();
            atc.scale(this.magnification, this.magnification);
            atc.translate(-this.srcRect.x, -this.srcRect.y);
            Rectangle r1 = new Rectangle(this.srcRect.x + this.srcRect.width, this.srcRect.y, (int)((double)g_width / this.magnification) - this.srcRect.width, (int)((double)g_height / this.magnification));
            Rectangle r2 = new Rectangle(this.srcRect.x, this.srcRect.y + this.srcRect.height, this.srcRect.width, (int)((double)g_height / this.magnification) - this.srcRect.height);
            try {
                this.display.getProject().getLoader().releaseToFit(g_width * g_height * 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BufferedImage target = this.getGraphicsConfiguration().createCompatibleImage(g_width, g_height, 3);
            Graphics2D g = target.createGraphics();
            g.setTransform(atc);
            g.setStroke(this.stroke);
            g.setColor(Color.black);
            g.fillRect(0, 0, g_width - r1.x, g_height - r2.y);
            List<? extends Paintable> paintables = graphics_source.asPaintable(al_paint);
            first_non_patch = paintables.size() - (al_paint.size() - first_non_patch);
            if (0 == mode) {
                if (this.display.isLiveFilteringEnabled()) {
                    this.paintWithFiltering(g, al_paint, paintables, first_non_patch, g_width, g_height, active, c_alphas, active_layer, layers, true);
                } else {
                    int i = 0;
                    for (Paintable paintable : paintables) {
                        if (i == first_non_patch) {
                            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        }
                        if (prepaint) {
                            paintable.prePaint(g, this.srcRect, this.magnification, paintable == active, c_alphas, active_layer, layers);
                        } else {
                            paintable.paint(g, this.srcRect, this.magnification, paintable == active, c_alphas, active_layer, layers);
                        }
                        ++i;
                    }
                }
            } else if (1 == mode) {
                void var23_37;
                if (this.display.isLiveFilteringEnabled()) {
                    this.paintWithFiltering(g, al_paint, paintables, first_non_patch, g_width, g_height, active, c_alphas, active_layer, layers, false);
                } else {
                    int i = 0;
                    if (prepaint) {
                        for (Paintable paintable : paintables) {
                            if (first_non_patch != i) {
                                paintable.prePaint(g, this.srcRect, this.magnification, paintable == active, c_alphas, active_layer, layers);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (Paintable paintable : paintables) {
                            if (first_non_patch != i) {
                                paintable.paint(g, this.srcRect, this.magnification, paintable == active, c_alphas, active_layer, layers);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                }
                Composite original = g.getComposite();
                g.setTransform(new AffineTransform());
                Set<Class<?>> included = this.display.classes_to_multipaint;
                ListIterator<LayerPanel> listIterator = blending_list.listIterator(blending_list.size());
                while (listIterator.hasPrevious()) {
                    LayerPanel lp = listIterator.previous();
                    if (lp.layer == active_layer) continue;
                    active_layer.getProject().getLoader().releaseToFit(g_width * g_height * 4 + 1024);
                    BufferedImage bi = this.getGraphicsConfiguration().createCompatibleImage(g_width, g_height, 3);
                    Graphics2D gb = bi.createGraphics();
                    gb.setTransform(atc);
                    for (Displayable d : lp.layer.find(this.srcRect, true)) {
                        if (!included.contains(d.getClass())) continue;
                        d.paint(gb, this.srcRect, this.magnification, false, c_alphas, lp.layer, layers);
                    }
                    for (Displayable d : lp.layer.getParent().roughlyFindZDisplayables(lp.layer, this.srcRect, true)) {
                        if (!included.contains(d.getClass())) continue;
                        d.paint(gb, this.srcRect, this.magnification, false, c_alphas, lp.layer, layers);
                    }
                    try {
                        g.setComposite(Displayable.getComposite(this.display.getLayerCompositeMode(lp.layer), lp.getAlpha()));
                        g.drawImage(this.display.applyFilters(bi), 0, 0, null);
                    }
                    catch (Throwable t) {
                        Utils.log("Could not use composite mode for layer overlays! Your graphics card may not support it.");
                        g.setComposite(AlphaComposite.getInstance(3, lp.getAlpha()));
                        g.drawImage((Image)bi, 0, 0, null);
                        IJError.print(t);
                    }
                    bi.flush();
                }
                g.setComposite(original);
                g.setTransform(atc);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int n = first_non_patch;
                while (var23_37 < al_paint.size()) {
                    Displayable d;
                    d.paint(g, this.srcRect, this.magnification, (d = al_paint.get((int)var23_37)) == active, c_alphas, active_layer, layers);
                    ++var23_37;
                }
            } else if (2 == mode) {
                List<? extends Paintable> paintable_patches = graphics_source.asPaintable(al_paint);
                HashMap<Color, byte[]> channels = new HashMap<Color, byte[]>();
                hm.put(Color.green, active_layer);
                for (Map.Entry<Color, Layer> e : hm.entrySet()) {
                    BufferedImage bi = new BufferedImage(g_width, g_height, 10);
                    Graphics2D gb = bi.createGraphics();
                    gb.setTransform(atc);
                    Layer la = e.getValue();
                    ArrayList<? extends Paintable> list = new ArrayList<Paintable>();
                    if (la == active_layer) {
                        if (Color.green != e.getKey()) continue;
                        list.addAll(paintable_patches);
                    } else {
                        list.addAll(la.find(Patch.class, this.srcRect, true));
                    }
                    list.addAll(la.getParent().getZDisplayables(ImageData.class, true));
                    for (Paintable paintable : list) {
                        paintable.paint(gb, this.srcRect, this.magnification, false, c_alphas, la, layers);
                    }
                    channels.put(e.getKey(), (byte[])new ByteProcessor(bi).getPixels());
                }
                byte[] green = (byte[])channels.get(Color.green);
                if (null == channels.get(Color.red)) {
                    byte[] byArray = new byte[green.length];
                } else {
                    byte[] byArray = (byte[])channels.get(Color.red);
                }
                byte[] blue = null == channels.get(Color.blue) ? new byte[green.length] : (byte[])channels.get(Color.blue);
                int[] pix = new int[green.length];
                for (int i = 0; i < green.length; ++i) {
                    void var23_41;
                    pix[i] = ((var23_41[i] & 0xFF) << 16) + ((green[i] & 0xFF) << 8) + (blue[i] & 0xFF);
                }
                g.setTransform(new AffineTransform());
                ColorProcessor cp = new ColorProcessor(g_width, g_height, pix);
                if (this.display.invert_colors) {
                    cp.invert();
                }
                this.display.applyFilters((ImageProcessor)cp);
                Image img = cp.createImage();
                g.drawImage(img, 0, 0, null);
                img.flush();
                g.setTransform(atc);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                for (Displayable displayable : al_paint) {
                    if (ImageData.class.isInstance(displayable)) continue;
                    displayable.paint(g, this.srcRect, this.magnification, displayable == active, c_alphas, active_layer, layers);
                }
            }
            if (r1.width > 0 || r1.height > 0 || r2.width > 0 || r2.height > 0) {
                g.setColor(Color.gray);
                g.setClip(r1);
                g.fill(r1);
                g.setClip(r2);
                g.fill(r2);
            }
            return target;
        }
        catch (OutOfMemoryError oome) {
            IJError.print(oome);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return null;
    }

    private final void paintWithFiltering(Graphics2D g, ArrayList<Displayable> al_paint, Collection<? extends Paintable> paintables, int first_non_patch, int g_width, int g_height, Displayable active, int c_alphas, Layer layer, List<Layer> layers, boolean paint_non_images) {
        int type = 10;
        block3: for (Displayable d : al_paint) {
            if (d.getClass() != Patch.class) continue;
            switch (((Patch)d).getType()) {
                case 3: 
                case 4: {
                    type = 2;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        BufferedImage bi = new BufferedImage(g_width, g_height, type);
        Graphics2D gpre = bi.createGraphics();
        gpre.setTransform(this.atc);
        int i = 0;
        for (Paintable paintable : paintables) {
            if (i == first_non_patch) break;
            paintable.paint(gpre, this.srcRect, this.magnification, paintable == active, c_alphas, layer, layers);
            ++i;
        }
        gpre.dispose();
        ImagePlus imp = new ImagePlus("filtered", (ImageProcessor)(type == 10 ? new ByteProcessor(bi) : new ColorProcessor((Image)bi)));
        bi.flush();
        this.display.applyFilters(imp);
        AffineTransform affineTransform = g.getTransform();
        g.setTransform(new AffineTransform());
        g.drawImage(imp.getProcessor().createImage(), 0, 0, null);
        if (paint_non_images && first_non_patch != paintables.size()) {
            g.setTransform(affineTransform);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            i = 0;
            for (Paintable paintable : paintables) {
                if (i < first_non_patch) {
                    ++i;
                    continue;
                }
                paintable.paint(g, this.srcRect, this.magnification, paintable == active, c_alphas, layer, layers);
                ++i;
            }
        }
    }

    protected void scroll(int sx, int sy) {
        int ox = this.xSrcStart + (int)((double)sx / this.magnification);
        int oy = this.ySrcStart + (int)((double)sy / this.magnification);
        int newx = this.xSrcStart + (this.xMouseStart - ox);
        int newy = this.ySrcStart + (this.yMouseStart - oy);
        if (newx < 0) {
            newx = 0;
        }
        if (newy < 0) {
            newy = 0;
        }
        if (newx + this.srcRect.width > this.imageWidth) {
            newx = this.imageWidth - this.srcRect.width;
        }
        if (newy + this.srcRect.height > this.imageHeight) {
            newy = this.imageHeight - this.srcRect.height;
        }
        this.srcRect.x = newx;
        this.srcRect.y = newy;
        this.display.getMode().srcRectUpdated(this.srcRect, this.magnification);
    }

    private void handleHide(KeyEvent ke) {
        if (ke.isAltDown() && !ke.isShiftDown()) {
            Display.updateCheckboxes(this.display.getLayer().getParent().setAllVisible(false), 2);
            Display.update(this.display.getLayer());
            ke.consume();
            return;
        }
        if (ke.isShiftDown()) {
            this.display.hideDeselected(ke.isAltDown());
            ke.consume();
            return;
        }
        this.display.getSelection().setVisible(false);
        Display.update(this.display.getLayer());
        ke.consume();
    }

    Screenshot createScreenshot(Layer layer) {
        return new Screenshot(layer);
    }

    private boolean browseToNodeLayer(boolean is_shift_down) {
        try {
            Layer active_layer = this.display.getLayer();
            Point po = this.getCursorLoc();
            for (ZDisplayable zd : this.display.getLayerSet().getDisplayableList()) {
                Tree t;
                Layer la;
                if (!zd.isVisible() || !(zd instanceof Tree) || null == (la = (t = (Tree)zd).toClosestPaintedNode(active_layer, po.x, po.y, this.magnification))) continue;
                this.display.toLayer(la);
                if (!is_shift_down) {
                    this.display.getSelection().clear();
                }
                this.display.getSelection().add(t);
                switch (ProjectToolbar.getToolId()) {
                    case 16: 
                    case 17: {
                        break;
                    }
                    default: {
                        ProjectToolbar.setTool(16);
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            Utils.log2("Oops: " + e);
        }
        return false;
    }

    protected void animateBrowsing(final int dx, final int dy) {
        ScheduledFuture[] sf;
        float mag = (float)this.magnification;
        final Rectangle startSrcRect = (Rectangle)this.srcRect.clone();
        final Vector2f v = new Vector2f((float)dx, (float)dy);
        final float sqdist_to_travel = v.lengthSquared();
        v.normalize();
        v.scale(20.0f / mag);
        final Point2f cp = new Point2f(0.0f, 0.0f);
        sf = new ScheduledFuture[]{this.animate(new Runnable(){

            @Override
            public void run() {
                int y;
                int x;
                cp.add((Tuple2f)v);
                if (v.lengthSquared() >= sqdist_to_travel) {
                    x = startSrcRect.x + dx;
                    y = startSrcRect.y + dy;
                    DisplayCanvas.this.cancelAnimation(sf[0]);
                } else {
                    x = startSrcRect.x + (int)cp.x;
                    y = startSrcRect.y + (int)cp.y;
                }
                DisplayCanvas.this.setSrcRect(x, y, startSrcRect.width, startSrcRect.height);
                DisplayCanvas.this.display.repaintAll2();
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS)};
    }

    public boolean animateBrowsing(Rectangle target_, final Layer target_layer) {
        ScheduledFuture[] sf;
        Area a = new Area(target_);
        a.intersect(new Area(this.display.getLayerSet().get2DBounds()));
        final Rectangle target = a.getBounds();
        if (0 == target.width || 0 == target.height) {
            return false;
        }
        if (this.srcRect.contains(target) && target_layer == this.display.getLayer()) {
            this.playHighlight(target);
            return false;
        }
        final int ox = this.srcRect.x + this.srcRect.width / 2;
        final int oy = this.srcRect.y + this.srcRect.height / 2;
        int tx = target.x + target.width / 2;
        int ty = target.y + target.height / 2;
        final Vector2f v = new Vector2f((float)(tx - ox), (float)(ty - oy));
        v.normalize();
        v.scale(20.0f / (float)this.magnification);
        final Layer start_layer = this.display.getLayer();
        Calibration cal = this.display.getLayerSet().getCalibrationCopy();
        final double pixelWidth = cal.pixelWidth;
        final double pixelHeight = cal.pixelHeight;
        final Vector3d g = new Vector3d((double)(tx - ox) * pixelWidth, (double)(ty - oy) * pixelHeight, (target_layer.getZ() - start_layer.getZ()) * pixelWidth);
        sf = new ScheduledFuture[]{this.animate(new Runnable(){

            @Override
            public void run() {
                if (DisplayCanvas.this.srcRect.contains(target)) {
                    if (DisplayCanvas.this.display.getLayer() != target_layer) {
                        DisplayCanvas.this.display.toLayer(target_layer);
                    }
                    DisplayCanvas.this.playHighlight(target);
                    DisplayCanvas.this.cancelAnimation(sf[0]);
                } else {
                    DisplayCanvas.this.setSrcRect(((DisplayCanvas)DisplayCanvas.this).srcRect.x + (int)v.x, ((DisplayCanvas)DisplayCanvas.this).srcRect.y + (int)v.y, ((DisplayCanvas)DisplayCanvas.this).srcRect.width, ((DisplayCanvas)DisplayCanvas.this).srcRect.height);
                    if (start_layer != target_layer) {
                        int cx = ((DisplayCanvas)DisplayCanvas.this).srcRect.x + ((DisplayCanvas)DisplayCanvas.this).srcRect.width / 2;
                        int cy = ((DisplayCanvas)DisplayCanvas.this).srcRect.y + ((DisplayCanvas)DisplayCanvas.this).srcRect.height / 2;
                        double dist = Math.sqrt(Math.pow((double)(cx - ox) * pixelWidth, 2.0) + Math.pow((double)(cy - oy) * pixelHeight, 2.0) + Math.pow((DisplayCanvas.this.display.getLayer().getZ() - start_layer.getZ()) * pixelWidth, 2.0));
                        Vector3d gg = new Vector3d(g);
                        gg.normalize();
                        gg.scale((double)((float)dist));
                        Layer la = DisplayCanvas.this.display.getLayerSet().getNearestLayer(start_layer.getZ() + gg.z / pixelWidth);
                        if (la != DisplayCanvas.this.display.getLayer()) {
                            DisplayCanvas.this.display.toLayer(la);
                        }
                    }
                    DisplayCanvas.this.display.repaintAll2();
                }
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS)};
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAnimations() {
        Vector sfs;
        if (this.sfs.isEmpty()) {
            return;
        }
        Vector<ScheduledFuture<?>> vector = this.sfs;
        synchronized (vector) {
            sfs = new Vector(this.sfs);
        }
        for (ScheduledFuture scheduledFuture : sfs) {
            scheduledFuture.cancel(true);
        }
        this.sfs.clear();
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.restoreUserInput();
    }

    private void cancelAnimation(ScheduledFuture<?> sf) {
        this.sfs.remove(sf);
        sf.cancel(true);
        this.restoreUserInput();
    }

    private void restoreUserInput() {
        this.zoom_and_pan = true;
        this.display.getProject().setReceivesInput(true);
    }

    private ScheduledFuture<?> animate(Runnable run, long initialDelay, long delay, TimeUnit units) {
        ScheduledFuture[] sf;
        this.initAnimator();
        this.cancelAnimations();
        this.display.getProject().setReceivesInput(false);
        this.zoom_and_pan = false;
        sf = new ScheduledFuture[]{this.animator.scheduleWithFixedDelay(run, initialDelay, delay, units), this.animator.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (sf[0].isCancelled()) {
                    DisplayCanvas.this.zoom_and_pan = true;
                    DisplayCanvas.this.display.getProject().setReceivesInput(true);
                    sf[1].cancel(true);
                }
            }
        }, 100L, 700L, TimeUnit.MILLISECONDS)};
        this.sfs.add(sf[0]);
        return sf[0];
    }

    private ScheduledFuture<?> playHighlight(Rectangle target) {
        ScheduledFuture[] sf;
        this.initAnimator();
        final Highlighter highlight = new Highlighter(target);
        sf = new ScheduledFuture[]{this.animator.scheduleWithFixedDelay(new Animation(){

            @Override
            public void run() {
                if (!highlight.next()) {
                    DisplayCanvas.this.cancelAnimation(sf[0]);
                    highlight.cleanup();
                }
            }
        }, 10L, 100L, TimeUnit.MILLISECONDS), this.animator.scheduleWithFixedDelay(new Animation(){

            @Override
            public void run() {
                if (sf[0].isCancelled()) {
                    highlight.cleanup();
                    sf[1].cancel(true);
                }
            }
        }, 50L, 100L, TimeUnit.MILLISECONDS)};
        this.sfs.add(sf[0]);
        return sf[0];
    }

    private synchronized void initAnimator() {
        if (null == this.animator) {
            this.animator = Executors.newScheduledThreadPool(2);
        }
    }

    static {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        try {
            String openglProperty = System.getProperty("sun.java2d.opengl");
            openglEnabled = openglProperty != null && Boolean.parseBoolean(openglProperty);
        }
        catch (Exception openglProperty) {
            // empty catch block
        }
        try {
            String quartzProperty = System.getProperty("apple.awt.graphics.UseQuartz");
            quartzEnabled = Boolean.parseBoolean(quartzProperty);
        }
        catch (Exception quartzProperty) {
            // empty catch block
        }
        try {
            String ddscaleProperty = System.getProperty("sun.java2d.ddscale");
            String d3dProperty = System.getProperty("sun.java2d.d3d");
            ddscaleEnabled = Boolean.parseBoolean(ddscaleProperty) && Boolean.parseBoolean(d3dProperty);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (openglEnabled) {
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else if (quartzEnabled) {
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else if (ddscaleEnabled) {
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        rhints = new RenderingHints(hints);
        DEFAULT_STROKE = new BasicStroke(1.0f, 0, 0);
        DEFAULT_AFFINE = new AffineTransform();
    }

    private static interface Animation
    extends Runnable {
    }

    private final class Highlighter {
        Ellipse2D.Float elf;
        final Stroke stroke = new BasicStroke(2.0f, 0, 0, 3.0f, new float[]{4.0f, 4.0f, 4.0f, 4.0f}, 0.0f);
        final float dec;
        final Rectangle target;

        Highlighter(Rectangle target) {
            this.target = target;
            this.elf = new Ellipse2D.Float(target.x, target.y, target.width, target.height);
            DisplayCanvas.this.display.getLayerSet().getOverlay().add(this.elf, Color.yellow, this.stroke, true);
            this.dec = (float)((double)Math.max(target.width, target.height) * DisplayCanvas.this.magnification / 10.0 / DisplayCanvas.this.magnification);
        }

        boolean next() {
            DisplayCanvas.this.invalidateVolatile();
            DisplayCanvas.this.repaint(this.target, 5, false);
            DisplayCanvas.this.display.getLayerSet().getOverlay().remove(this.elf);
            Ellipse2D.Float elf2 = (Ellipse2D.Float)this.elf.clone();
            elf2.x += this.dec;
            elf2.y += this.dec;
            elf2.width -= this.dec + this.dec;
            elf2.height -= this.dec + this.dec;
            if (elf2.width > 1.0f || elf2.height > 1.0f) {
                this.elf = elf2;
                DisplayCanvas.this.display.getLayerSet().getOverlay().add(this.elf, Color.yellow, this.stroke, true);
                return true;
            }
            DisplayCanvas.this.display.getLayerSet().getOverlay().remove(this.elf);
            return false;
        }

        void cleanup() {
            DisplayCanvas.this.display.getLayerSet().getOverlay().remove(this.elf);
        }
    }

    public class Screenshot {
        final Layer layer;
        long sid = Long.MIN_VALUE;
        long born = 0L;
        final ArrayList<Displayable> al_top = new ArrayList();
        final ScreenshotProperties props;

        Screenshot(Layer layer) {
            this(layer, this$0.srcRect, this$0.magnification, this$0.getWidth(), this$0.getHeight(), this$0.display.getDisplayChannelAlphas(), this$0.display.getMode().getGraphicsSource());
        }

        Screenshot(Layer layer, Rectangle srcRect, double magnification, int g_width, int g_height, int c_alphas, GraphicsSource graphics_source) {
            this.layer = layer;
            this.props = new ScreenshotProperties(layer, srcRect, magnification, g_width, g_height, c_alphas, graphics_source);
        }

        public long init() {
            this.born = System.currentTimeMillis();
            this.sid = this.layer.getProject().getLoader().getNextTempId();
            return this.sid;
        }

        public long assoc(BufferedImage img) {
            this.init();
            if (null != img) {
                this.layer.getProject().getLoader().cacheAWT(this.sid, img);
            }
            return this.sid;
        }

        public void createImage() {
            BufferedImage img = DisplayCanvas.this.paintOffscreen(this.layer, this.layer.getParent().getColorCueLayerRange(this.layer), this.props.g_width, this.props.g_height, this.props.srcRect, this.props.magnification, DisplayCanvas.this.display.getActive(), this.props.c_alphas, null, this.layer.getProject().getLoader(), this.props.hm, this.props.blending_list, this.props.mode, this.props.graphics_source, false, this.al_top, false);
            this.layer.getProject().getLoader().cacheAWT(this.sid, img);
        }

        public void flush() {
            this.layer.getProject().getLoader().decacheAWT(this.sid);
        }
    }

    protected class ScreenshotProperties {
        final Layer layer;
        final Rectangle srcRect;
        final double magnification;
        final int g_width;
        final int g_height;
        final int c_alphas;
        final GraphicsSource graphics_source;
        final ArrayList<LayerPanel> blending_list;
        final HashMap<Color, Layer> hm;
        final int mode;

        ScreenshotProperties(Layer layer, Rectangle srcRect, double magnification, int g_width, int g_height, int c_alphas, GraphicsSource graphics_source) {
            this.srcRect = new Rectangle(srcRect);
            this.magnification = magnification;
            this.layer = layer;
            this.blending_list = new ArrayList();
            this.hm = new HashMap();
            this.mode = DisplayCanvas.this.display.getPaintMode(this.hm, this.blending_list);
            this.g_width = g_width;
            this.g_height = g_height;
            this.graphics_source = graphics_source;
            this.c_alphas = c_alphas;
            Layer current_layer = DisplayCanvas.this.display.getLayer();
            if (2 == this.mode) {
                Layer red = this.hm.get(Color.red);
                Layer blue = this.hm.get(Color.blue);
                if (null != red || null != blue) {
                    Layer l;
                    LayerSet ls = layer.getParent();
                    int i_layer = ls.indexOf(layer);
                    int i_current = ls.indexOf(current_layer);
                    if (null != red) {
                        int i_red = ls.indexOf(red);
                        l = red.getParent().getLayer(i_red + i_current - i_layer);
                        if (null != l) {
                            this.hm.put(Color.red, l);
                        } else {
                            this.hm.remove(Color.red);
                        }
                    }
                    if (null != blue) {
                        int i_blue = ls.indexOf(blue);
                        l = blue.getParent().getLayer(i_blue + i_current - i_layer);
                        if (null != l) {
                            this.hm.put(Color.blue, l);
                        } else {
                            this.hm.remove(Color.blue);
                        }
                    }
                }
            }
        }

        public final boolean equals(Object o) {
            ScreenshotProperties s = (ScreenshotProperties)o;
            return s.layer == this.layer && s.magnification == this.magnification && s.srcRect.x == this.srcRect.x && s.srcRect.y == this.srcRect.y && s.srcRect.width == this.srcRect.width && s.srcRect.height == this.srcRect.height && s.mode == this.mode && s.c_alphas == this.c_alphas && Utils.equalContent(s.blending_list, this.blending_list) && Utils.equalContent(s.hm, this.hm);
        }

        public int hashCode() {
            return 0;
        }
    }

    private final class OffscreenThread
    extends AbstractOffscreenThread {
        OffscreenThread() {
            super("T2-Canvas-Offscreen");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint() {
            GraphicsSource graphics_source;
            ArrayList blending_list;
            HashMap hm;
            int mode;
            Loader loader;
            Rectangle clipRect;
            int c_alphas;
            Displayable active;
            double magnification;
            Rectangle srcRect;
            int g_height;
            int g_width;
            List layers;
            Layer active_layer;
            OffscreenThread offscreenThread = this;
            synchronized (offscreenThread) {
                RepaintProperties rp = (RepaintProperties)this.rp;
                active_layer = rp.layer;
                layers = rp.layers;
                g_width = rp.g_width;
                g_height = rp.g_height;
                srcRect = rp.srcRect;
                magnification = rp.magnification;
                active = rp.active;
                c_alphas = rp.c_alphas;
                clipRect = rp.clipRect;
                loader = active_layer.getProject().getLoader();
                mode = rp.mode;
                hm = rp.hm;
                blending_list = rp.blending_list;
                graphics_source = rp.graphics_source;
            }
            BufferedImage target = null;
            ArrayList<Displayable> al_top = new ArrayList<Displayable>();
            Screenshot sc = null;
            try {
                if (DisplayCanvas.this.display.getMode().getClass() == DefaultMode.class && null != (sc = active_layer.getParent().getScreenshot(new ScreenshotProperties(active_layer, srcRect, magnification, g_width, g_height, c_alphas, graphics_source)))) {
                    target = (BufferedImage)loader.getCachedAWT(sc.sid, 0);
                    if (null == target) {
                        active_layer.getParent().removeFromOffscreens(sc);
                    } else if (sc.al_top.size() > 0 && sc.al_top.get(0) != DisplayCanvas.this.display.getActive() || 0 == sc.al_top.size() && null != DisplayCanvas.this.display.getActive()) {
                        Utils.log2("rejecting: different active object");
                        target = null;
                    } else {
                        al_top.addAll(sc.al_top);
                        DisplayCanvas.this.display.applyFilters(target);
                    }
                }
            }
            catch (Throwable t) {
                IJError.print(t);
            }
            if (null == target) {
                target = DisplayCanvas.this.paintOffscreen(active_layer, layers, g_width, g_height, srcRect, magnification, active, c_alphas, clipRect, loader, hm, blending_list, mode, graphics_source, active_layer.getParent().prepaint, al_top, true);
            }
            Object object = DisplayCanvas.this.offscreen_lock;
            synchronized (object) {
                if (null != DisplayCanvas.this.offscreen) {
                    DisplayCanvas.this.to_flush.add(DisplayCanvas.this.offscreen);
                }
                DisplayCanvas.this.offscreen = target;
                DisplayCanvas.this.update_graphics = false;
                DisplayCanvas.this.al_top = al_top;
            }
            DisplayCanvas.this.invalidateVolatile();
            DisplayCanvas.this.RT.paint(clipRect, false);
        }
    }

    protected class RepaintProperties
    implements AbstractOffscreenThread.RepaintProperties {
        private final Layer layer;
        private final List<Layer> layers;
        private final int g_width;
        private final int g_height;
        private final Rectangle srcRect;
        private final double magnification;
        private final Displayable active;
        private final int c_alphas;
        private final Rectangle clipRect;
        private final int mode;
        private final HashMap<Color, Layer> hm;
        private final ArrayList<LayerPanel> blending_list;
        private final GraphicsSource graphics_source;

        RepaintProperties(Rectangle clipRect, Layer layer, List<Layer> layers, int g_width, int g_height, Rectangle srcRect, double magnification, Displayable active, int c_alphas, GraphicsSource graphics_source) {
            this.clipRect = clipRect;
            this.layer = layer;
            this.layers = layers;
            this.g_width = g_width;
            this.g_height = g_height;
            this.srcRect = srcRect;
            this.magnification = magnification;
            this.active = active;
            this.c_alphas = c_alphas;
            this.hm = new HashMap();
            this.blending_list = new ArrayList();
            this.mode = DisplayCanvas.this.display.getPaintMode(this.hm, this.blending_list);
            this.graphics_source = graphics_source;
        }
    }

    private class MouseMovedThread
    extends Thread {
        private volatile MouseEvent me;

        MouseMovedThread() {
            super("T2-mouseMoved");
            this.me = null;
            this.setDaemon(true);
            this.setPriority(5);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(MouseEvent me) {
            MouseMovedThread mouseMovedThread = this;
            synchronized (mouseMovedThread) {
                this.me = me;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            this.interrupt();
            MouseMovedThread mouseMovedThread = this;
            synchronized (mouseMovedThread) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                MouseEvent me = this.me;
                if (null != me) {
                    try {
                        this.mouseMoved(me);
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                }
                MouseMovedThread mouseMovedThread = this;
                synchronized (mouseMovedThread) {
                    if (me == this.me) {
                        me = null;
                        this.me = null;
                        if (this.isInterrupted()) {
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mouseMoved(MouseEvent me) {
            if (null == me) {
                return;
            }
            if (DisplayCanvas.this.input_disabled || DisplayCanvas.this.display.getMode().isDragging()) {
                return;
            }
            DisplayCanvas.this.xMouse = (int)((double)me.getX() / DisplayCanvas.this.magnification) + ((DisplayCanvas)DisplayCanvas.this).srcRect.x;
            DisplayCanvas.this.yMouse = (int)((double)me.getY() / DisplayCanvas.this.magnification) + ((DisplayCanvas)DisplayCanvas.this).srcRect.y;
            Displayable active = DisplayCanvas.this.display.getActive();
            int flags = DisplayCanvas.this.flags;
            if (0 == (flags & 0x10) && 0 == (flags & 4) && null != active && active.isVisible() && AreaContainer.class.isInstance(active)) {
                int tool = ProjectToolbar.getToolId();
                RectangularShape r = null;
                if (17 == tool) {
                    int brushSize = ProjectToolbar.getBrushSize() + 2;
                    r = new Rectangle(DisplayCanvas.this.xMouse - brushSize / 2, DisplayCanvas.this.yMouse - brushSize / 2, brushSize + 1, brushSize + 1);
                } else if (15 == tool || 18 == tool) {
                    r = new Rectangle(DisplayCanvas.this.xMouse - Segmentation.fmp.width / 2 - 2, DisplayCanvas.this.yMouse - Segmentation.fmp.height / 2 - 2, Segmentation.fmp.width + 4, Segmentation.fmp.height + 4);
                }
                if (null != r) {
                    Rectangle copy = (Rectangle)r.clone();
                    if (null != DisplayCanvas.this.old_brush_box) {
                        ((Rectangle)r).add(DisplayCanvas.this.old_brush_box);
                    }
                    DisplayCanvas.this.old_brush_box = copy;
                    DisplayCanvas.this.repaint((Rectangle)r, 1);
                }
            }
            if (me.isShiftDown()) {
                Layer layer = DisplayCanvas.this.display.getLayer();
                List<Displayable> al = DisplayCanvas.this.getDisplayablesUnderMouse(me);
                if (0 == al.size()) {
                    Utils.showStatus("", false);
                    return;
                }
                StringBuilder sb = new StringBuilder();
                Project pr = layer.getProject();
                for (Displayable d : al) {
                    sb.append(pr.getShortMeaningfulTitle(d)).append(", ");
                }
                sb.setLength(sb.length() - 2);
                Utils.showStatus(sb.toString(), false);
            } else {
                List<Displayable> under = DisplayCanvas.this.getDisplayablesUnderMouse(me);
                Calibration cal = DisplayCanvas.this.display.getLayerSet().getCalibration();
                if (under.isEmpty()) {
                    Utils.showStatus("x=" + (int)((double)DisplayCanvas.this.xMouse * cal.pixelWidth) + " " + cal.getUnit() + ", y=" + (int)((double)DisplayCanvas.this.yMouse * cal.pixelHeight) + " " + cal.getUnit());
                    return;
                }
                Displayable top = under.get(0);
                String msg = "x=" + (int)((double)DisplayCanvas.this.xMouse * cal.pixelWidth) + " " + cal.getUnit() + ", y=" + (int)((double)DisplayCanvas.this.yMouse * cal.pixelHeight) + " " + cal.getUnit();
                if (top.getClass() == Patch.class) {
                    BufferedImage offsc;
                    Patch patch = (Patch)top;
                    int[] p = new int[4];
                    Object object = DisplayCanvas.this.offscreen_lock;
                    synchronized (object) {
                        offsc = DisplayCanvas.this.offscreen;
                    }
                    if (null == offsc) {
                        return;
                    }
                    try {
                        PixelGrabber pg = new PixelGrabber(offsc, me.getX(), me.getY(), 1, 1, p, 0, offsc.getWidth(null));
                        pg.grabPixels();
                    }
                    catch (InterruptedException ie) {
                        IJError.print(ie);
                        return;
                    }
                    catch (Throwable t) {
                        return;
                    }
                    patch.approximateTransferPixel(p);
                    msg = msg + ", value=";
                    switch (patch.getType()) {
                        case 0: 
                        case 1: {
                            msg = msg + p[0];
                            break;
                        }
                        case 2: {
                            msg = msg + Float.intBitsToFloat(p[0]);
                            break;
                        }
                        case 3: 
                        case 4: {
                            msg = msg + "(" + p[0] + "," + p[1] + "," + p[2] + ")";
                        }
                    }
                    msg = msg + " [Patch #" + patch.getId() + "]";
                } else {
                    Color c = top.getColor();
                    msg = msg + ", value=[" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "] [" + Project.getName(top.getClass()) + " #" + top.getId() + "]";
                }
                Utils.showStatus(msg);
            }
        }
    }
}

