/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import customnode.CustomLineMesh;
import customnode.CustomMesh;
import customnode.CustomMultiMesh;
import customnode.CustomTriangleMesh;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.ImageWindow3D;
import ij3d.UniverseListener;
import ij3d.behaviors.InteractiveBehavior;
import ini.trakem2.display.AreaContainer;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.AreaTree;
import ini.trakem2.display.Ball;
import ini.trakem2.display.Connector;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Line3D;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Pipe;
import ini.trakem2.display.Polyline;
import ini.trakem2.display.Profile;
import ini.trakem2.display.Tree;
import ini.trakem2.display.Treeline;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.display.d3d.ControlClickBehavior;
import ini.trakem2.display.d3d.Display3DGUI;
import ini.trakem2.imaging.PatchStack;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.vector.VectorString3D;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Scrollbar;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.scijava.java3d.PolygonAttributes;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.View;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;

public final class Display3D {
    private static Hashtable<LayerSet, Display3D> ht_layer_sets = new Hashtable();
    private static Object htlock = new Object();
    private Map<ProjectThing, String> ht_pt_meshes = Collections.synchronizedMap(new HashMap());
    private Image3DUniverse universe;
    private LayerSet layer_set;
    private double width;
    private double height;
    private int resample = -1;
    private static final int DEFAULT_RESAMPLE = 4;
    private final double scale = 1.0;
    private static ExecutorService launchers = Utils.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), "Display3D-launchers");
    private ExecutorService executors = Utils.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), "Display3D-executors");
    private static boolean check_j3d = true;
    private static boolean has_j3d_3dviewer = false;

    public static Hashtable<LayerSet, Display3D> getMasterTable() {
        return new Hashtable<LayerSet, Display3D>(ht_layer_sets);
    }

    private Display3D(LayerSet ls) {
        this.layer_set = ls;
        this.width = ls.getLayerWidth();
        this.height = ls.getLayerHeight();
        this.universe = new Image3DUniverse(512, 512);
        this.universe.getViewer().getView().setProjectionPolicy(1);
        Display3DGUI gui = new Display3DGUI(this.universe);
        ImageWindow3D win = gui.init();
        this.universe.init(win);
        win.pack();
        win.setVisible(true);
        this.universe.getWindow().addWindowListener((WindowListener)new IW3DListener(this, ls));
        this.universe.getWindow().setTitle(ls.getProject().toString() + " -- 3D Viewer");
        ht_layer_sets.put(ls, this);
        this.universe.addInteractiveBehavior((InteractiveBehavior)new ControlClickBehavior(this.universe, ls));
        this.universe.addUniverseListener(new UniverseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void universeClosed() {
                Map map = Display3D.this.ht_pt_meshes;
                synchronized (map) {
                    Display3D.this.ht_pt_meshes.clear();
                }
            }

            public void transformationUpdated(View arg0) {
            }

            public void transformationStarted(View arg0) {
            }

            public void transformationFinished(View arg0) {
            }

            public void contentSelected(Content arg0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void contentRemoved(Content arg0) {
                String name = arg0.getName();
                Map map = Display3D.this.ht_pt_meshes;
                synchronized (map) {
                    Iterator it = Display3D.this.ht_pt_meshes.entrySet().iterator();
                    while (it.hasNext()) {
                        if (!name.equals(it.next().getValue())) continue;
                        it.remove();
                        break;
                    }
                }
            }

            public void contentChanged(Content arg0) {
            }

            public void contentAdded(Content arg0) {
            }

            public void canvasResized() {
            }
        });
    }

    public Image3DUniverse getUniverse() {
        return this.universe;
    }

    private static boolean hasLibs() {
        if (check_j3d) {
            check_j3d = false;
            try {
                Class.forName("org.scijava.vecmath.Point3f");
                has_j3d_3dviewer = true;
            }
            catch (ClassNotFoundException cnfe) {
                Utils.log("Java 3D not installed.");
                has_j3d_3dviewer = false;
                return false;
            }
            try {
                Class.forName("ij3d.ImageWindow3D");
                has_j3d_3dviewer = true;
            }
            catch (ClassNotFoundException cnfe) {
                Utils.log("3D Viewer not installed.");
                has_j3d_3dviewer = false;
                return false;
            }
        }
        return has_j3d_3dviewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display3D get(final LayerSet ls) {
        Object object = htlock;
        synchronized (object) {
            try {
                if (!Display3D.hasLibs()) {
                    return null;
                }
                Display3D d3d = ht_layer_sets.get(ls);
                if (null != d3d) {
                    return d3d;
                }
                final boolean[] done = new boolean[]{false};
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ht_layer_sets.put(ls, new Display3D(ls));
                        done[0] = true;
                    }
                });
                while (!done[0]) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                return ht_layer_sets.get(ls);
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        return null;
    }

    public static Display3D getDisplay(LayerSet ls) {
        return ht_layer_sets.get(ls);
    }

    public static void setWaitingCursor() {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Display3D d3d : ht_layer_sets.values()) {
                    d3d.universe.getWindow().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
    }

    public static void doneWaiting() {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Display3D d3d : ht_layer_sets.values()) {
                    d3d.universe.getWindow().setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    public static Future<Vector<Future<Content>>> show(ProjectThing pt) {
        return Display3D.show(pt, false, -1);
    }

    public static void showAndResetView(final ProjectThing pt) {
        launchers.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Vector<Future<Content>> vc;
                Future<Vector<Future<Content>>> fu = Display3D.show(pt, true, -1);
                try {
                    vc = fu.get();
                }
                catch (Exception e) {
                    IJError.print(e);
                    return;
                }
                for (Future<Content> fc : vc) {
                    try {
                        Content c = fc.get();
                        if (null == c) continue;
                        ArrayList d3ds = new ArrayList();
                        Hashtable hashtable = ht_layer_sets;
                        synchronized (hashtable) {
                            d3ds.addAll(ht_layer_sets.values());
                        }
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                }
                Utils.logAll("Reset 3D view if not within field of view!");
            }
        });
    }

    public static Future<Vector<Future<Content>>> show(final ProjectThing pt, boolean wait, final int resample) {
        if (null == pt) {
            return null;
        }
        Future<Vector<Future<Content>>> fu = launchers.submit(new Callable<Vector<Future<Content>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Vector<Future<Content>> call() {
                final HashSet<ProjectThing> hs = pt.findBasicTypeChildren();
                if (null == hs || 0 == hs.size()) {
                    Utils.logAll("Node " + pt + " does not contain any 3D-displayable children");
                    return null;
                }
                Iterator<ProjectThing> it = hs.iterator();
                while (it.hasNext()) {
                    ProjectThing pt2 = it.next();
                    if (null == pt2.getObject() || pt2.getObject().getClass() != Profile.class || !pt2.getParent().getType().equals("profile_list")) continue;
                    it.remove();
                }
                Display3D.setWaitingCursor();
                final Hashtable contents = new Hashtable();
                final ScheduledExecutorService updater = Executors.newScheduledThreadPool(1);
                final AtomicInteger counter = new AtomicInteger();
                updater.scheduleWithFixedDelay(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashMap m = new HashMap();
                        Hashtable hashtable = contents;
                        synchronized (hashtable) {
                            m.putAll(contents);
                            contents.clear();
                        }
                        if (m.isEmpty()) {
                            return;
                        }
                        for (Map.Entry entry : m.entrySet()) {
                            ((Display3D)entry.getKey()).universe.addContentLater((Collection)entry.getValue());
                            counter.getAndAdd(((Vector)entry.getValue()).size());
                        }
                        Utils.showStatus("Rendered " + counter.get() + '/' + hs.size());
                    }
                }, 100L, 4000L, TimeUnit.MILLISECONDS);
                final Vector<Future<Content>> list = new Vector<Future<Content>>();
                Iterator<ProjectThing> it2 = hs.iterator();
                while (it2.hasNext()) {
                    boolean already;
                    Display3D d3d;
                    Displayable displ;
                    final ProjectThing child = it2.next();
                    Object obc = child.getObject();
                    Displayable displayable = displ = obc.getClass().equals(String.class) ? null : (Displayable)obc;
                    if (null != displ) {
                        if (displ.getClass().equals(Profile.class)) continue;
                        if (!displ.isVisible()) {
                            Utils.log("Skipping non-visible node " + displ);
                            continue;
                        }
                    }
                    if (null != displ) {
                        d3d = Display3D.get(displ.getLayerSet());
                    } else if (child.getType().equals("profile_list")) {
                        ArrayList<ProjectThing> al_children = child.getChildren();
                        if (null == al_children || 0 == al_children.size()) continue;
                        d3d = Display3D.get(((Displayable)al_children.get(0).getObject()).getLayerSet());
                    } else {
                        Utils.log("Don't know what to do with node " + child);
                        d3d = null;
                    }
                    if (null == d3d) {
                        Utils.log("Could not get a proper 3D display for node " + displ);
                        return null;
                    }
                    Map map = d3d.ht_pt_meshes;
                    synchronized (map) {
                        already = d3d.ht_pt_meshes.containsKey(child);
                    }
                    if (already) {
                        if (child.getObject() instanceof ZDisplayable) {
                            Utils.log("Updating 3D view of " + child.getObject());
                        } else {
                            Utils.log("Updating 3D view of " + child);
                        }
                    }
                    list.add(d3d.executors.submit(new Callable<Content>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Content call() {
                            Content c = null;
                            try {
                                Vector<Content> vc;
                                c = d3d.createMesh(child, displ, resample).call();
                                Hashtable hashtable = contents;
                                synchronized (hashtable) {
                                    vc = (Vector<Content>)contents.get(d3d);
                                    if (null == vc) {
                                        vc = new Vector<Content>();
                                    }
                                    contents.put(d3d, vc);
                                }
                                vc.add(c);
                            }
                            catch (Exception e) {
                                IJError.print(e);
                            }
                            return c;
                        }
                    }));
                    if (it2.hasNext()) continue;
                    d3d.executors.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (Future c : list) {
                                try {
                                    c.get();
                                }
                                catch (Throwable t) {
                                    IJError.print(t);
                                }
                            }
                            try {
                                for (Runnable r : updater.shutdownNow()) {
                                    r.run();
                                }
                            }
                            catch (Throwable e) {
                                IJError.print(e);
                            }
                            Display3D.doneWaiting();
                            Utils.showStatus("Done rendering " + counter.get() + '/' + hs.size());
                        }
                    });
                }
                return list;
            }
        });
        if (wait && -1 != resample) {
            try {
                fu.get();
            }
            catch (Throwable t) {
                IJError.print(t);
            }
        }
        return fu;
    }

    public static void resetView(LayerSet ls) {
        Display3D d3d = ht_layer_sets.get(ls);
        if (null != d3d) {
            d3d.universe.resetView();
        }
    }

    public static void showOrthoslices(Patch p) {
        Display3D d3d = Display3D.get(p.getLayerSet());
        d3d.adjustResampling();
        String title = Display3D.makeTitle(p) + " orthoslices";
        d3d.universe.removeContent(title);
        PatchStack ps = p.makePatchStack();
        ImagePlus imp = Display3D.get8BitStack(ps);
        Content ct = d3d.universe.addOrthoslice(imp, null, title, 0, new boolean[]{true, true, true}, d3d.resample);
        Display3D.setTransform(ct, ps.getPatch(0));
        ct.setLocked(true);
    }

    public static void showVolume(Patch p) {
        Display3D d3d = Display3D.get(p.getLayerSet());
        d3d.adjustResampling();
        String title = Display3D.makeTitle(p) + " volume";
        d3d.universe.removeContent(title);
        PatchStack ps = p.makePatchStack();
        ImagePlus imp = Display3D.get8BitStack(ps);
        Content ct = d3d.universe.addVoltex(imp, null, title, 0, new boolean[]{true, true, true}, d3d.resample);
        Display3D.setTransform(ct, ps.getPatch(0));
        ct.setLocked(true);
    }

    private static void setTransform(Content ct, Patch p) {
        double[] a = new double[6];
        p.getAffineTransform().getMatrix(a);
        Calibration cal = p.getLayerSet().getCalibration();
        ct.applyTransform(new Transform3D(new double[]{a[0], a[2], 0.0, a[4] * cal.pixelWidth, a[1], a[3], 0.0, a[5] * cal.pixelWidth, 0.0, 0.0, 1.0, p.getLayer().getZ() * cal.pixelWidth, 0.0, 0.0, 0.0, 1.0}));
    }

    public static void showOrthoslices(ImagePlus imp, String title, int wx, int wy, float scale2D, Layer first) {
        Display3D d3d = Display3D.get(first.getParent());
        d3d.universe.removeContent(title);
        Content ct = d3d.universe.addOrthoslice(imp, null, title, 0, new boolean[]{true, true, true}, 1);
        Calibration cal = imp.getCalibration();
        Transform3D t = new Transform3D(new double[]{1.0, 0.0, 0.0, (double)wx * cal.pixelWidth * (double)scale2D, 0.0, 1.0, 0.0, (double)wy * cal.pixelHeight * (double)scale2D, 0.0, 0.0, scale2D, first.getZ() * cal.pixelWidth * (double)scale2D, 0.0, 0.0, 0.0, 1.0});
        Utils.log(t);
        ct.applyTransform(t);
        ct.setLocked(true);
    }

    private static ImagePlus get8BitStack(PatchStack ps) {
        switch (ps.getType()) {
            case 4: {
                return ps.createColor256Copy();
            }
            case 1: 
            case 2: {
                return ps.createGray8Copy();
            }
            case 0: 
            case 3: {
                return ps;
            }
        }
        Utils.logAll("Cannot handle stacks of type: " + ps.getType());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(ProjectThing pt) {
        String name;
        if (null == pt) {
            return;
        }
        if (null == pt.getObject()) {
            return;
        }
        Object ob = pt.getObject();
        if (!(ob instanceof Displayable)) {
            return;
        }
        Displayable displ = (Displayable)ob;
        Display3D d3d = ht_layer_sets.get(displ.getLayerSet());
        if (null == d3d) {
            return;
        }
        Map<ProjectThing, String> map = d3d.ht_pt_meshes;
        synchronized (map) {
            name = d3d.ht_pt_meshes.remove(pt);
        }
        if (null == name) {
            Utils.log2("No mesh contained within " + d3d + " for ProjectThing " + pt);
            return;
        }
        d3d.universe.removeContent(name);
    }

    private Future<Content> addMesh(final ProjectThing pt, final Displayable displ, final int resample) {
        return this.executors.submit(new Callable<Content>(){

            @Override
            public Content call() {
                try {
                    Callable<Content> c = Display3D.this.createMesh(pt, displ, resample);
                    if (null == c) {
                        return null;
                    }
                    Content content = c.call();
                    if (null == content) {
                        return null;
                    }
                    String title = content.getName();
                    if (Display3D.this.universe.contains(title)) {
                        Display3D.this.universe.removeContent(title);
                    }
                    Display3D.this.universe.addContentLater(content).get();
                    return content;
                }
                catch (Exception e) {
                    IJError.print(e);
                    return null;
                }
            }
        });
    }

    private static final String makeProfileListTitle(ProjectThing pt) {
        String ob = pt.getParent().getTitle();
        String title = null == ob || ob.equals(pt.getParent().getType()) ? pt.toString() + " #" + pt.getId() : ob.toString() + " /[" + pt.getParent().getType() + "]/[profile_list] #" + pt.getId();
        return title;
    }

    public static void removeFrom3D(ProjectThing pt) {
        HashSet<ProjectThing> hs = pt.findBasicTypeChildren();
        if (null == hs || 0 == hs.size()) {
            Utils.logAll("Nothing to remove from 3D.");
            return;
        }
        for (ProjectThing child : hs) {
            if (child.getByType().equals("profile")) continue;
            LayerSet lset = null;
            if (child.getType().equals("profile_list")) {
                if (!child.hasChildren()) continue;
                for (ProjectThing p : child.getChildren()) {
                    if (null == p.getObject() || !(p.getObject() instanceof Profile)) continue;
                    lset = ((Displayable)p.getObject()).getLayerSet();
                    break;
                }
                if (null == lset) {
                    continue;
                }
            } else {
                if (child.getType().equals("profile")) continue;
                Displayable d = (Displayable)child.getObject();
                if (null == d) {
                    Utils.log("Null object for ProjectThing " + child);
                    continue;
                }
                lset = d.getLayerSet();
            }
            if (null == lset) {
                Utils.log("No LayerSet found for " + child);
                continue;
            }
            Display3D d3d = Display3D.getDisplay(lset);
            if (null == d3d) {
                Utils.log("No Display 3D found for " + child);
                continue;
            }
            String oldTitle = d3d.ht_pt_meshes.remove(child);
            if (null == oldTitle) {
                Utils.log("Could not find a title for " + child);
                continue;
            }
            Utils.log("Removed from 3D view: " + oldTitle);
            d3d.getUniverse().removeContent(oldTitle);
        }
    }

    public Callable<Content> createMesh(final ProjectThing pt, final Displayable displ, final int resample) {
        double scale = 1.0;
        return new Callable<Content>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Content call() {
                Thread.currentThread().setPriority(5);
                try {
                    String title;
                    float alpha;
                    Color color;
                    List<Point3f> triangles;
                    int line_mesh_mode;
                    boolean line_mesh;
                    Class<?> c;
                    if (null == displ) {
                        c = null;
                        line_mesh = false;
                        line_mesh_mode = Integer.MAX_VALUE;
                    } else {
                        c = displ.getClass();
                        boolean bl = line_mesh = Tree.class.isAssignableFrom(c) || Polyline.class == c;
                        line_mesh_mode = Tree.class.isAssignableFrom(c) ? 0 : (Polyline.class == c ? 1 : Integer.MAX_VALUE);
                    }
                    List<Point3f> extra_triangles = null;
                    List<Color3f> triangle_colors = null;
                    List<Color3f> extra_triangle_colors = null;
                    int rs = resample;
                    if (displ instanceof AreaContainer) {
                        rs = -1 == resample ? (Display3D.this.resample = Display3D.this.adjustResampling()) : Display3D.this.resample;
                    }
                    if (AreaList.class == c) {
                        triangles = ((AreaList)displ).generateTriangles(1.0, rs);
                    } else if (Ball.class == c) {
                        double[][][] globe = Ball.generateGlobe(12, 12);
                        triangles = ((Ball)displ).generateTriangles(1.0, globe);
                    } else if (displ instanceof Line3D) {
                        triangles = ((Line3D)((Object)displ)).generateTriangles(1.0, 12, 1);
                    } else if (displ instanceof Tree) {
                        Tree.MeshData skeleton = ((Tree)displ).generateSkeleton(1.0, 12, 1);
                        triangles = skeleton.verts;
                        triangle_colors = skeleton.colors;
                        if (displ instanceof Treeline) {
                            Tree.MeshData tube = ((Treeline)displ).generateMesh(1.0, 12);
                            extra_triangles = tube.verts;
                            extra_triangle_colors = tube.colors;
                        } else if (displ instanceof AreaTree) {
                            Tree.MeshData mesh = ((AreaTree)displ).generateMesh(1.0, rs);
                            extra_triangles = mesh.verts;
                            extra_triangle_colors = mesh.colors;
                        }
                        if (null != extra_triangles && extra_triangles.isEmpty()) {
                            extra_triangles = null;
                        }
                    } else if (Connector.class == c) {
                        Tree.MeshData octopus = ((Connector)displ).generateMesh(1.0, 12);
                        triangles = octopus.verts;
                        triangle_colors = octopus.colors;
                    } else if (null == displ && pt.getType().equals("profile_list")) {
                        triangles = Profile.generateTriangles(pt, 1.0);
                    } else {
                        Utils.log("Unrecognized type for 3D mesh generation: " + (null != displ ? displ.getClass() : null) + " : " + displ);
                        triangles = null;
                    }
                    if (null == triangles) {
                        Utils.log("Some error ocurred: can't create triangles for " + displ);
                        return null;
                    }
                    if (0 == triangles.size()) {
                        Utils.log2("Skipping empty mesh for " + displ.getTitle());
                        return null;
                    }
                    if (!line_mesh && 0 != triangles.size() % 3) {
                        Utils.log2("Skipping non-multiple-of-3 vertices list generated for " + displ.getTitle());
                        return null;
                    }
                    if (null != displ) {
                        color = displ.getColor();
                        alpha = displ.getAlpha();
                        title = Display3D.makeTitle(displ);
                    } else if (pt.getType().equals("profile_list")) {
                        Object obp = pt.getChildren().get(0).getObject();
                        if (null == obp) {
                            return null;
                        }
                        Displayable di = (Displayable)obp;
                        color = di.getColor();
                        alpha = di.getAlpha();
                        title = Display3D.makeProfileListTitle(pt);
                    } else {
                        title = pt.toString() + " #" + pt.getId();
                        color = null;
                        alpha = 1.0f;
                    }
                    boolean no_culling = true;
                    Content ct = null;
                    try {
                        PolygonAttributes pa;
                        CustomLineMesh cm;
                        Color3f c3 = new Color3f(color);
                        Display3D.this.universe.removeContent(title);
                        if (line_mesh) {
                            cm = new CustomLineMesh(triangles, line_mesh_mode, c3, 0.0f);
                        } else {
                            CustomTriangleMesh mesh = new CustomTriangleMesh(triangles, c3, 0.0f);
                            pa = mesh.getAppearance().getPolygonAttributes();
                            pa.setCullFace(0);
                            pa.setBackFaceNormalFlip(true);
                            mesh.setColor(c3);
                            cm = mesh;
                        }
                        if (null != triangle_colors) {
                            cm.setColor(triangle_colors);
                        }
                        if (null == extra_triangles || 0 == extra_triangles.size()) {
                            ct = Display3D.this.universe.createContent((CustomMesh)cm, title);
                        } else {
                            CustomTriangleMesh extra = new CustomTriangleMesh(extra_triangles, c3, 0.0f);
                            if (null != extra_triangle_colors) {
                                pa = extra.getAppearance().getPolygonAttributes();
                                pa.setCullFace(0);
                                pa.setBackFaceNormalFlip(true);
                                extra.setColor(extra_triangle_colors);
                            }
                            ct = Display3D.this.universe.createContent(new CustomMultiMesh(Arrays.asList(cm, extra)), title);
                        }
                        ct.setTransparency(1.0f - alpha);
                        ct.setLocked(true);
                        Map map = Display3D.this.ht_pt_meshes;
                        synchronized (map) {
                            Display3D.this.ht_pt_meshes.put(pt, ct.getName());
                        }
                    }
                    catch (Throwable e) {
                        Utils.logAll("Mesh generation failed for \"" + title + "\"  from " + pt);
                        IJError.print(e);
                        e.printStackTrace();
                    }
                    Utils.log2(pt.toString() + " n points: " + triangles.size());
                    return ct;
                }
                catch (Exception e) {
                    IJError.print(e);
                    return null;
                }
            }
        };
    }

    public static Future<Collection<Future<Content>>> addMesh(LayerSet ref_ls, VectorString3D vs, String title, Color color) {
        return Display3D.addMesh(ref_ls, vs, title, color, null, 1.0f);
    }

    public static Future<Collection<Future<Content>>> addMesh(LayerSet ref_ls, VectorString3D vs, String title, Color color, double[] widths, float alpha) {
        ArrayList<Content> col = new ArrayList<Content>();
        Display3D d3d = Display3D.get(ref_ls);
        col.add(new VectorStringContent(vs, title, color, widths, alpha).asContent(d3d));
        return d3d.addContent(col);
    }

    public static Future<Collection<Future<Content>>> show(LayerSet ref_ls, Collection<Content> col) {
        Display3D d3d = Display3D.get(ref_ls);
        return d3d.addContent(col);
    }

    public Future<Collection<Future<Content>>> addContent(final Collection<Content> col) {
        final FutureTask<Collection<Future<Content>>> fu = new FutureTask<Collection<Future<Content>>>(new Callable<Collection<Future<Content>>>(){

            @Override
            public Collection<Future<Content>> call() {
                Thread.currentThread().setPriority(5);
                try {
                    return Display3D.this.universe.addContentLater(col);
                }
                catch (Throwable e) {
                    IJError.print(e);
                    return null;
                }
            }
        });
        launchers.submit(new Runnable(){

            @Override
            public void run() {
                Display3D.this.executors.submit(fu);
            }
        });
        return fu;
    }

    public Future<Content> addContent(final Content c) {
        final FutureTask<Content> fu = new FutureTask<Content>(new Callable<Content>(){

            @Override
            public Content call() {
                Thread.currentThread().setPriority(5);
                try {
                    return (Content)Display3D.this.universe.addContentLater(c).get();
                }
                catch (Throwable e) {
                    IJError.print(e);
                    return null;
                }
            }
        });
        launchers.submit(new Runnable(){

            @Override
            public void run() {
                Display3D.this.executors.submit(fu);
            }
        });
        return fu;
    }

    public static final int estimateResamplingFactor(LayerSet ls, double width, double height) {
        int max_dimension = ls.getPixelsMaxDimension();
        return (int)(4.0 / (Math.max(width, height) > (double)max_dimension ? (double)max_dimension / Math.max(width, height) : 1.0));
    }

    private final int estimateResamplingFactor() {
        return Display3D.estimateResamplingFactor(this.layer_set, this.width, this.height);
    }

    private final synchronized int adjustResampling() {
        if (this.resample > 0) {
            return this.resample;
        }
        GenericDialog gd = new GenericDialog("Resample");
        int default_resample = this.estimateResamplingFactor();
        gd.addSlider("Resample: ", 1.0, (double)Math.max(default_resample, 100), -1 != this.resample ? (double)this.resample : (double)default_resample);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.resample = -1 != this.resample ? this.resample : default_resample;
            return this.resample;
        }
        this.resample = ((Scrollbar)gd.getSliders().get(0)).getValue();
        return this.resample;
    }

    public static boolean isDisplayed(Displayable d) {
        if (null == d) {
            return false;
        }
        String title = Display3D.makeTitle(d);
        for (Display3D d3d : ht_layer_sets.values()) {
            if (null == d3d.universe.getContent(title)) continue;
            return true;
        }
        return d.getClass() == Profile.class && null != Display3D.getProfileContent(d);
    }

    public static Content getProfileContent(Displayable d) {
        if (null == d) {
            return null;
        }
        if (d.getClass() != Profile.class) {
            return null;
        }
        Display3D d3d = Display3D.get(d.getLayer().getParent());
        if (null == d3d) {
            return null;
        }
        ProjectThing pt = d.getProject().findProjectThing(d);
        if (null == pt) {
            return null;
        }
        pt = (ProjectThing)pt.getParent();
        return d3d.universe.getContent(pt.toString() + " #" + pt.getId());
    }

    public static Future<Boolean> setColor(final Displayable d, final Color color) {
        final Display3D d3d = Display3D.getDisplay(d.getLayer().getParent());
        if (null == d3d) {
            return null;
        }
        return d3d.executors.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Content content = d3d.universe.getContent(Display3D.makeTitle(d));
                if (null == content) {
                    content = Display3D.getProfileContent(d);
                }
                if (null != content) {
                    content.setColor(new Color3f(color));
                    return true;
                }
                return false;
            }
        });
    }

    public static Future<Boolean> setTransparency(final Displayable d, final float alpha) {
        if (null == d) {
            return null;
        }
        Layer layer = d.getLayer();
        if (null == layer) {
            return null;
        }
        final Display3D d3d = ht_layer_sets.get(layer.getParent());
        if (null == d3d) {
            return null;
        }
        return d3d.executors.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Patch pa;
                String title = Display3D.makeTitle(d);
                Content content = d3d.universe.getContent(title);
                if (null == content) {
                    content = Display3D.getProfileContent(d);
                }
                if (null != content) {
                    content.setTransparency(1.0f - alpha);
                } else if (null == content && d.getClass().equals(Patch.class) && (pa = (Patch)d).isStack()) {
                    title = pa.getProject().getLoader().getFileName(pa);
                    for (Display3D dd : ht_layer_sets.values()) {
                        for (Content c : dd.universe.getContents()) {
                            if (!c.getName().startsWith(title)) continue;
                            c.setTransparency(1.0f - alpha);
                        }
                    }
                }
                return true;
            }
        });
    }

    public static String makeTitle(Displayable d) {
        return d.getProject().getMeaningfulTitle(d) + " #" + d.getId();
    }

    public static String makeTitle(Patch p) {
        return new File(p.getProject().getLoader().getAbsolutePath(p)).getName() + " #" + p.getProject().getLoader().getNextId();
    }

    public static Future<Content> update(Displayable d) {
        Layer layer = d.getLayer();
        if (null == layer) {
            return null;
        }
        Display3D d3d = ht_layer_sets.get(layer.getParent());
        if (null == d3d) {
            return null;
        }
        return d3d.addMesh(d.getProject().findProjectThing(d), d, d3d.resample);
    }

    public static final boolean contains(LayerSet ls, String title) {
        Display3D d3d = Display3D.getDisplay(ls);
        if (null == d3d) {
            return false;
        }
        return null != d3d.universe.getContent(title);
    }

    public static void destroy() {
        launchers.shutdownNow();
    }

    public static void init() {
        if (launchers.isShutdown()) {
            launchers = Utils.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), "Display3D-launchers");
        }
    }

    public List<Point3f> createFatPoint(double wx, double wy, double wz, double wr, Calibration cal) {
        double[][][] globe = Ball.generateGlobe(12, 12);
        int sign = cal.pixelDepth < 0.0 ? -1 : 1;
        for (int z = 0; z < globe.length; ++z) {
            for (int k = 0; k < globe[0].length; ++k) {
                globe[z][k][0] = (globe[z][k][0] * wr + wx) * 1.0 * cal.pixelWidth;
                globe[z][k][1] = (globe[z][k][1] * wr + wy) * 1.0 * cal.pixelHeight;
                globe[z][k][2] = (globe[z][k][2] * wr + wz) * 1.0 * cal.pixelWidth * (double)sign;
            }
        }
        ArrayList<Point3f> list = new ArrayList<Point3f>();
        for (int z = 0; z < globe.length - 1; ++z) {
            for (int k = 0; k < globe[0].length - 1; ++k) {
                list.add(new Point3f((float)globe[z][k][0], (float)globe[z][k][1], (float)globe[z][k][2]));
                list.add(new Point3f((float)globe[z + 1][k + 1][0], (float)globe[z + 1][k + 1][1], (float)globe[z + 1][k + 1][2]));
                list.add(new Point3f((float)globe[z + 1][k][0], (float)globe[z + 1][k][1], (float)globe[z + 1][k][2]));
                list.add(new Point3f((float)globe[z][k][0], (float)globe[z][k][1], (float)globe[z][k][2]));
                list.add(new Point3f((float)globe[z][k + 1][0], (float)globe[z][k + 1][1], (float)globe[z][k + 1][2]));
                list.add(new Point3f((float)globe[z + 1][k + 1][0], (float)globe[z + 1][k + 1][1], (float)globe[z + 1][k + 1][2]));
            }
        }
        return list;
    }

    public static final Future<Content> addFatPoint(String title, LayerSet ls, double wx, double wy, double wz, double wr, Color color) {
        Display3D d3d = Display3D.get(ls);
        d3d.universe.removeContent(title);
        Content ct = d3d.universe.createContent((CustomMesh)new CustomTriangleMesh(d3d.createFatPoint(wx, wy, wz, wr, ls.getCalibrationCopy()), new Color3f(color), 0.0f), title);
        ct.setLocked(true);
        return d3d.addContent(ct);
    }

    public static class VectorStringContent {
        VectorString3D vs;
        String title;
        Color color;
        double[] widths;
        float alpha;

        public VectorStringContent(VectorString3D vs, String title, Color color, double[] widths, float alpha) {
            this.vs = vs;
            this.title = title;
            this.color = color;
            this.widths = widths;
            this.alpha = alpha;
        }

        public Content asContent(Display3D d3d) {
            double[] wi = this.widths;
            if (null == this.widths) {
                wi = new double[this.vs.getPoints(0).length];
                Arrays.fill(wi, 2.0);
            } else if (this.widths.length != this.vs.length()) {
                Utils.log("ERROR: widths.length != VectorString3D.length()");
                return null;
            }
            float transp = 1.0f - this.alpha;
            if (transp < 0.0f) {
                transp = 0.0f;
            }
            if (transp > 1.0f) {
                transp = 1.0f;
            }
            if (1.0f == transp) {
                Utils.log("WARNING: adding a 3D object fully transparent.");
            }
            List<Point3f> triangles = Pipe.generateTriangles(Pipe.makeTube(this.vs.getPoints(0), this.vs.getPoints(1), this.vs.getPoints(2), wi, 1, 12, null), 1.0);
            Content ct = d3d.universe.createContent((CustomMesh)new CustomTriangleMesh(triangles, new Color3f(this.color), 0.0f), this.title);
            ct.setTransparency(transp);
            ct.setLocked(true);
            return ct;
        }
    }

    private class IW3DListener
    extends WindowAdapter {
        private Display3D d3d;
        private LayerSet ls;

        IW3DListener(Display3D d3d, LayerSet ls) {
            this.d3d = d3d;
            this.ls = ls;
        }

        @Override
        public void windowClosing(WindowEvent we) {
            this.d3d.executors.shutdownNow();
            ht_layer_sets.remove(this.ls);
        }

        @Override
        public void windowClosed(WindowEvent we) {
            ht_layer_sets.remove(this.ls);
        }
    }
}

