/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.IJ;
import ij.gui.GUI;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.GroupingMode;
import ini.trakem2.display.Patch;
import ini.trakem2.imaging.ContrastPlot;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContrastAdjustmentMode
extends GroupingMode {
    private MinMaxData min_max = new MinMaxData();
    private ImageProcessor initial;
    private ImageProcessor transformed;
    private final JFrame frame;
    private final ContrastPlot plot;
    private final JLabel minLabel;
    private final JLabel maxLabel;
    private int sliderRange;

    @Override
    protected void doPainterUpdate(Rectangle r, double m) {
        try {
            MinMaxData md = this.min_max.clone();
            HashMap screenPatchRanges = this.screenPatchRanges;
            for (GroupingMode.ScreenPatchRange spr : screenPatchRanges.values()) {
                if (screenPatchRanges == this.screenPatchRanges) {
                    ((ScreenPatchRange)spr).update(md);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected GroupingMode.GroupedGraphicsSource createGroupedGraphicSource() {
        return new ContrastAdjustmentSource();
    }

    protected ScreenPatchRange createScreenPathRange(GroupingMode.PatchRange range, Rectangle srcRect, double magnification) {
        return new ScreenPatchRange(range, srcRect, magnification);
    }

    private final double[] toImage(double slider_min, double slider_max) {
        double imin = this.initial.getMin();
        double imax = this.initial.getMax();
        double ratio = (imax - imin) / (double)this.sliderRange;
        return new double[]{imin + slider_min * ratio, slider_max * ratio};
    }

    private final void updateLabelsAndPlot(double min, double max) {
        double[] m = this.toImage(min, max);
        this.minLabel.setText(Utils.cutNumber(m[0], 1));
        this.maxLabel.setText(Utils.cutNumber(m[1], 1));
        this.plot.update(m[0], m[1]);
    }

    public ContrastAdjustmentMode(final Display display, List<Displayable> selected) throws Exception {
        super(display, selected);
        int type = ((Patch)this.originalPatches.get(0)).getType();
        for (Patch p : this.originalPatches) {
            if (p.getType() == type) continue;
            throw new Exception("All images must be of the same type!\nFirst offending image: " + p);
        }
        ArrayList<Patch> patches = new ArrayList<Patch>(this.originalPatches);
        Patch first = (Patch)patches.get(0);
        int pad = (int)(100.0 / this.magnification);
        Rectangle box = new Rectangle(this.srcRect.x - pad, this.srcRect.y - pad, this.srcRect.width + 2 * pad, this.srcRect.height + 2 * pad);
        this.initial = Patch.makeFlatImage(first.getType(), this.layer, box, this.magnification, patches, Color.black);
        this.initial.resetMinAndMax();
        this.transformed = this.initial.duplicate();
        this.transformed.setMinAndMax(first.getMin(), first.getMax());
        this.transformed.snapshot();
        Utils.log2("transformed min, max: " + this.transformed.getMin() + ", " + this.transformed.getMax());
        ImageStatistics stats = ImageStatistics.getStatistics((ImageProcessor)this.transformed, (int)27, (Calibration)this.layer.getParent().getCalibrationCopy());
        Utils.log2("stats.min " + stats.min + ", stats.max " + stats.max);
        if (stats.min < this.initial.getMin()) {
            stats.min = this.initial.getMin();
        }
        if (stats.max > this.initial.getMax()) {
            stats.max = this.initial.getMax();
        }
        this.plot = new ContrastPlot(this.initial.getMin(), this.initial.getMax(), first.getMin(), first.getMax());
        this.plot.setHistogram(stats, Color.black);
        this.sliderRange = this.computeSliderRange();
        this.frame = new JFrame("Contrast adjustment");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                display.getCanvas().cancelTransform();
            }
        });
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gb);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 10;
        c.insets = new Insets(10, 10, 0, 10);
        gb.setConstraints(this.plot, c);
        panel.add(this.plot);
        JPanel mm = new JPanel();
        mm.setMinimumSize(new Dimension(this.plot.getWidth(), 15));
        mm.setBackground(Color.white);
        Font monoFont = new Font("Monospaced", 0, 12);
        GridBagLayout gbm = new GridBagLayout();
        GridBagConstraints cm = new GridBagConstraints();
        mm.setLayout(gbm);
        this.minLabel = new JLabel("      ");
        this.minLabel.setFont(monoFont);
        this.minLabel.setBackground(Color.white);
        this.maxLabel = new JLabel("      ");
        this.maxLabel.setFont(monoFont);
        this.maxLabel.setBackground(Color.white);
        cm.gridx = 0;
        cm.gridy = 0;
        cm.anchor = 17;
        gbm.setConstraints(this.minLabel, cm);
        mm.add(this.minLabel);
        cm.gridx = 1;
        cm.anchor = 10;
        cm.fill = 2;
        cm.weightx = 1.0;
        JPanel empty = new JPanel();
        empty.setBackground(Color.white);
        gbm.setConstraints(empty, cm);
        mm.add(empty);
        cm.weightx = 0.0;
        cm.fill = 0;
        cm.gridx = 2;
        cm.anchor = 13;
        gbm.setConstraints(this.maxLabel, cm);
        mm.add(this.maxLabel);
        gbm = null;
        cm = null;
        c.gridy = 1;
        c.insets = new Insets(0, 10, 0, 10);
        c.fill = 2;
        gb.setConstraints(mm, c);
        panel.add(mm);
        Utils.log2("first min, max " + first.getMin() + ", " + first.getMax());
        double ratio = (double)this.sliderRange / (this.initial.getMax() - this.initial.getMin());
        double firstMin = (first.getMin() - this.initial.getMin()) * ratio;
        double firstMax = (first.getMax() - this.initial.getMin()) * ratio;
        this.plot.update(first.getMin(), first.getMax());
        int sliderMin = (int)firstMin;
        int sliderMax = (int)firstMax;
        if (sliderMin < 0) {
            sliderMin = 0;
        }
        if (sliderMax > this.sliderRange - 1) {
            sliderMax = this.sliderRange - 1;
        }
        if (sliderMin > sliderMax) {
            sliderMin = sliderMax;
        }
        Utils.log2("After checking, slider min and max values are: " + sliderMin + ", " + sliderMax + " for range " + this.sliderRange);
        final JSlider minslider = this.createSlider(panel, gb, c, "Minimum", monoFont, this.sliderRange, sliderMin);
        final JSlider maxslider = this.createSlider(panel, gb, c, "Maximum", monoFont, this.sliderRange, sliderMax);
        ChangeListener adl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                double smin = minslider.getValue();
                double smax = maxslider.getValue();
                Utils.log2("smin, smax: " + smin + ", " + smax);
                ContrastAdjustmentMode.this.min_max.set(smin, smax);
                ContrastAdjustmentMode.this.updateLabelsAndPlot(smin, smax);
                ContrastAdjustmentMode.this.painter.update();
            }
        };
        minslider.addChangeListener(adl);
        maxslider.addChangeListener(adl);
        final JButton cancel = new JButton("Cancel");
        final JButton apply = new JButton("Apply");
        ActionListener actlis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object source = ae.getSource();
                if (cancel == source) {
                    display.getCanvas().cancelTransform();
                } else if (apply == source) {
                    display.getCanvas().applyTransform();
                }
            }
        };
        cancel.addActionListener(actlis);
        apply.addActionListener(actlis);
        JPanel buttons = new JPanel();
        buttons.setBackground(Color.white);
        gbm = new GridBagLayout();
        buttons.setLayout(gbm);
        cm = new GridBagConstraints();
        cm.gridx = 0;
        cm.gridy = 0;
        cm.weightx = 0.0;
        cm.anchor = 17;
        cm.fill = 0;
        gbm.setConstraints(cancel, cm);
        buttons.add(cancel);
        JPanel space = new JPanel();
        space.setBackground(Color.white);
        cm.gridx = 1;
        cm.weightx = 1.0;
        cm.anchor = 10;
        cm.fill = 2;
        gbm.setConstraints(space, cm);
        buttons.add(space);
        cm.gridx = 2;
        cm.weightx = 0.0;
        cm.anchor = 13;
        cm.fill = 0;
        gbm.setConstraints(apply, cm);
        buttons.add(apply);
        gbm = null;
        cm = null;
        ++c.gridy;
        c.fill = 2;
        gb.setConstraints(buttons, c);
        panel.add(buttons);
        this.frame.getContentPane().add(panel);
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContrastAdjustmentMode.this.min_max.set(minslider.getValue(), maxslider.getValue());
                ContrastAdjustmentMode.this.frame.pack();
                Dimension dim = new Dimension(ContrastAdjustmentMode.this.plot.getWidth(), 15);
                minslider.setMinimumSize(dim);
                maxslider.setMinimumSize(dim);
                ContrastAdjustmentMode.this.frame.pack();
                GUI.center((Window)ContrastAdjustmentMode.this.frame);
                ContrastAdjustmentMode.this.frame.setAlwaysOnTop(true);
                ContrastAdjustmentMode.this.frame.setVisible(true);
                ContrastAdjustmentMode.super.initThreads();
            }
        });
    }

    private int computeSliderRange() {
        double defaultMin = this.initial.getMin();
        double defaultMax = this.initial.getMax();
        int valueRange = (int)(defaultMax - defaultMin);
        int newSliderRange = valueRange;
        if (newSliderRange > 640 && newSliderRange < 1280) {
            newSliderRange /= 2;
        } else if (newSliderRange >= 1280) {
            newSliderRange /= 5;
        }
        if (newSliderRange < 256) {
            newSliderRange = 256;
        }
        if (newSliderRange > 1024) {
            newSliderRange = 1024;
        }
        return newSliderRange;
    }

    private JSlider createSlider(JPanel panel, GridBagLayout gb, GridBagConstraints c, String title, Font font, int sliderRange, int start) {
        Utils.log2("createSlider range: " + sliderRange + ", start: " + start);
        JSlider s = new JSlider(0, 0, sliderRange, start);
        s.setPaintLabels(false);
        s.setPaintTicks(false);
        s.setBackground(Color.white);
        ++c.gridy;
        c.insets = new Insets(2, 10, 0, 10);
        gb.setConstraints(s, c);
        panel.add(s);
        JLabel l = new JLabel(title);
        l.setBackground(Color.white);
        l.setFont(font);
        ++c.gridy;
        c.insets = new Insets(0, 10, IJ.isMacOSX() ? 4 : 0, 0);
        JPanel p = new JPanel();
        p.setBackground(Color.white);
        p.setLayout(new FlowLayout(1, 0, 0));
        gb.setConstraints(p, c);
        p.add(l);
        panel.add(p);
        return s;
    }

    @Override
    public void mousePressed(MouseEvent me, int x_p, int y_p, double magnification) {
    }

    @Override
    public void mouseDragged(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
    }

    @Override
    public void mouseReleased(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
    }

    @Override
    public boolean isDragging() {
        return false;
    }

    private final void setUndoState() {
        this.layer.getParent().addEditStep(new Displayable.DoEdits(new HashSet(this.originalPatches)).init(new String[]{"data"}));
    }

    @Override
    public boolean apply() {
        this.setUndoState();
        Bureaucrat.createAndStart((Worker)new Worker.Task("Applying transformations"){

            @Override
            public void exec() {
                ContrastAdjustmentMode.this.frame.dispose();
                double[] m = ContrastAdjustmentMode.this.toImage(((ContrastAdjustmentMode)ContrastAdjustmentMode.this).min_max.min, ((ContrastAdjustmentMode)ContrastAdjustmentMode.this).min_max.max);
                ArrayList<Future<Boolean>> fus = new ArrayList<Future<Boolean>>();
                for (Patch patch : ContrastAdjustmentMode.this.originalPatches) {
                    patch.setMinAndMax(m[0], m[1]);
                    fus.add(patch.getProject().getLoader().regenerateMipMaps(patch));
                }
                for (Future future : fus) {
                    try {
                        future.get();
                    }
                    catch (Throwable t) {
                        IJError.print(t);
                    }
                }
                ContrastAdjustmentMode.this.setUndoState();
            }
        }, this.layer.getProject());
        super.quitThreads();
        return true;
    }

    @Override
    public boolean cancel() {
        super.cancel();
        this.frame.dispose();
        return true;
    }

    private static class MinMaxData {
        double min = 0.0;
        double max = 0.0;

        public MinMaxData() {
        }

        public MinMaxData(double min, double max) {
            this.set(min, max);
        }

        public synchronized void set(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public synchronized MinMaxData clone() {
            return new MinMaxData(this.min, this.max);
        }
    }

    private class ScreenPatchRange
    extends GroupingMode.ScreenPatchRange<MinMaxData> {
        ScreenPatchRange(GroupingMode.PatchRange range, Rectangle srcRect, double magnification) {
            super(range, srcRect, magnification);
            this.transformedImage = this.makeImage(null, null);
        }

        @Override
        protected BufferedImage makeImage(ImageProcessor ignored, FloatProcessor mask) {
            if (null == ContrastAdjustmentMode.this.transformed) {
                return null;
            }
            return super.makeImage(ContrastAdjustmentMode.this.transformed, this.mask);
        }

        @Override
        public void update(MinMaxData m) {
            double[] mm = ContrastAdjustmentMode.this.toImage(m.min, m.max);
            ContrastAdjustmentMode.this.transformed.reset();
            ContrastAdjustmentMode.this.transformed.setMinAndMax(mm[0], mm[1]);
            this.transformedImage = this.makeImage(null, this.mask);
        }
    }

    private class ContrastAdjustmentSource
    extends GroupingMode.GroupedGraphicsSource {
        private ContrastAdjustmentSource() {
        }

        @Override
        public void paintOnTop(Graphics2D g, Display display, Rectangle srcRect, double magnification) {
        }
    }
}

