/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.Coordinate;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Node;
import ini.trakem2.display.Tree;
import ini.trakem2.display.Treeline;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scijava.vecmath.Point3f;

public class Connector
extends Treeline {
    private static final Color brightGreen = new Color(33, 255, 0);

    public Connector(Project project, String title) {
        super(project, title);
    }

    public Connector(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean locked, AffineTransform at) {
        super(project, project.getLoader().getNextId(), title, width, height, alpha, visible, color, locked, at);
    }

    public Connector(Project project, long id, HashMap<String, String> ht_attr, HashMap<Displayable, String> ht_links) {
        super(project, id, ht_attr, ht_links);
    }

    @Override
    public Tree<Float> newInstance() {
        return new Connector(this.project, this.project.getLoader().getNextId(), this.title, this.width, this.height, this.alpha, this.visible, this.color, this.locked, this.at);
    }

    @Override
    public Node<Float> newNode(float lx, float ly, Layer la, Node<?> modelNode) {
        return new ConnectorNode(lx, ly, la, null == modelNode ? 0.0f : ((ConnectorNode)modelNode).r);
    }

    @Override
    public Node<Float> newNode(HashMap<String, String> ht_attr) {
        return new ConnectorNode(ht_attr);
    }

    public void readLegacyXML(LayerSet ls, HashMap<String, String> ht_attr, HashMap<Displayable, String> ht_links) {
        String origin = ht_attr.get("origin");
        String targets = ht_attr.get("targets");
        if (null != origin) {
            int i;
            boolean new_format;
            String[] o = origin.split(",");
            String[] t = null;
            int len = 1;
            boolean bl = new_format = 0 == o.length % 4;
            if (null != targets) {
                t = targets.split(",");
                len = new_format ? (len += t.length / 4) : (len += t.length / 3);
            }
            float[] p = new float[len + len];
            long[] lids = new long[len];
            float[] radius = new float[len];
            p[0] = Float.parseFloat(o[0]);
            p[1] = Float.parseFloat(o[1]);
            lids[0] = Long.parseLong(o[2]);
            if (new_format) {
                radius[0] = Float.parseFloat(o[3]);
            }
            if (null != targets && targets.length() > 0) {
                int inc = new_format ? 4 : 3;
                i = 0;
                int k = 1;
                while (i < t.length) {
                    p[k + k] = Float.parseFloat(t[i]);
                    p[k + k + 1] = Float.parseFloat(t[i + 1]);
                    lids[k] = Long.parseLong(t[i + 2]);
                    if (new_format) {
                        radius[k] = Float.parseFloat(t[i + 3]);
                    }
                    i += inc;
                    ++k;
                }
            }
            ConnectorNode root = new ConnectorNode(p[0], p[1], ls.getLayer(lids[0]), radius[0]);
            for (i = 1; i < lids.length; ++i) {
                ConnectorNode nd = new ConnectorNode(p[i + i], p[i + i + 1], ls.getLayer(lids[i]), radius[i]);
                root.add(nd, (byte)5);
            }
            this.setRoot(root);
            this.calculateBoundingBox(null);
        }
    }

    public int addTarget(float x, float y, long layer_id, float r) {
        if (null == this.root) {
            return -1;
        }
        this.root.add(new ConnectorNode(x, y, this.layer_set.getLayer(layer_id), r), (byte)5);
        return this.root.getChildrenCount() - 1;
    }

    public int addTarget(double x, double y, long layer_id, double r) {
        return this.addTarget((float)x, (float)y, layer_id, (float)r);
    }

    protected void mergeTargets(Connector c) throws NoninvertibleTransformException {
        if (null == c.root) {
            return;
        }
        if (null == this.root) {
            this.root = this.newNode(c.root.x, c.root.y, c.root.la, c.root);
        }
        AffineTransform aff = new AffineTransform(c.at);
        aff.preConcatenate(this.at.createInverse());
        float[] f = new float[4];
        for (Map.Entry e : c.root.getChildren().entrySet()) {
            ConnectorNode nd = (ConnectorNode)e.getKey();
            f[0] = nd.x;
            f[1] = nd.y;
            f[2] = nd.x + nd.r;
            f[3] = nd.y;
            aff.transform(f, 0, f, 0, 2);
            this.root.add(new ConnectorNode(f[0], f[1], nd.la, Math.abs(f[2] - f[0])), e.getValue());
        }
    }

    public boolean intersectsOrigin(Area area, Layer la) {
        if (null == this.root || this.root.la != la) {
            return false;
        }
        Area a = this.root.getArea();
        a.transform(this.at);
        return M.intersects(area, a);
    }

    public boolean intersectsOrigin(double wx, double wy, Layer la) {
        if (null == this.root || this.root.la != la) {
            return false;
        }
        Area a = this.root.getArea();
        a.transform(this.at);
        return a.contains(wx, wy);
    }

    public Set<Displayable> getOrigins(Class<?> c) {
        int m = c.getModifiers();
        return this.getOrigins(c, Modifier.isAbstract(m) || Modifier.isInterface(m));
    }

    public Set<Displayable> getOrigins(Class<?> c, boolean instance_of) {
        if (null == this.root) {
            return new HashSet<Displayable>();
        }
        return this.getUnder(this.root, c, instance_of);
    }

    private final Set<Displayable> getUnder(Node<Float> node, Class<?> c, boolean instance_of) {
        Area a = node.getArea();
        a.transform(this.at);
        HashSet<Displayable> targets = new HashSet<Displayable>(this.layer_set.find(c, node.la, a, false, instance_of));
        targets.remove(this);
        return targets;
    }

    public Set<Displayable> getOrigins() {
        if (null == this.root) {
            return new HashSet<Displayable>();
        }
        return this.getUnder(this.root, Displayable.class, true);
    }

    public List<Set<Displayable>> getTargets(Class<?> c, boolean instance_of) {
        ArrayList<Set<Displayable>> al = new ArrayList<Set<Displayable>>();
        if (null == this.root || !this.root.hasChildren()) {
            return al;
        }
        for (Node<Float> node : this.root.getChildrenNodes()) {
            al.add(this.getUnder(node, c, instance_of));
        }
        return al;
    }

    public List<Set<Displayable>> getTargets(Class<?> c) {
        int m = c.getModifiers();
        return this.getTargets(c, Modifier.isAbstract(m) || Modifier.isInterface(m));
    }

    public List<Set<Displayable>> getTargets() {
        return this.getTargets(Displayable.class, true);
    }

    public int getTargetCount() {
        if (null == this.root) {
            return 0;
        }
        return this.root.getChildrenCount();
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        Tree.exportDTD(sb_header, hs, indent);
        String type = "t2_connector";
        if (hs.contains("t2_connector")) {
            return;
        }
        hs.add("t2_connector");
        sb_header.append(indent).append("<!ELEMENT t2_connector (t2_node*,").append(Displayable.commonDTDChildren()).append(")>\n");
        Displayable.exportDTD("t2_connector", sb_header, hs, indent);
    }

    @Override
    public Connector clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Connector copy = new Connector(pr, nid, this.title, this.width, this.height, this.alpha, true, this.color, this.locked, this.at);
        copy.root = null == this.root ? null : this.root.clone(pr);
        copy.addToDatabase();
        if (null != copy.root) {
            copy.cacheSubtree(copy.root.getSubtreeNodes());
        }
        return copy;
    }

    private final void insert(Node<Float> nd, ResultsTable rt, int i, Calibration cal, float[] f) {
        f[0] = nd.x;
        f[1] = nd.y;
        this.at.transform(f, 0, f, 0, 1);
        rt.incrementCounter();
        rt.addLabel("units", cal.getUnits());
        rt.addValue(0, (double)this.id);
        rt.addValue(1, (double)i);
        rt.addValue(2, (double)f[0] * cal.pixelWidth);
        rt.addValue(3, (double)f[1] * cal.pixelHeight);
        rt.addValue(4, nd.la.getZ() * cal.pixelWidth);
        rt.addValue(5, (double)((ConnectorNode)nd).r);
        rt.addValue(6, (double)nd.confidence);
    }

    @Override
    public ResultsTable measure(ResultsTable rt) {
        if (null == this.root) {
            return rt;
        }
        if (null == rt) {
            rt = Utils.createResultsTable("Connector results", new String[]{"id", "index", "x", "y", "z", "radius", "confidence"});
        }
        Calibration cal = this.layer_set.getCalibration();
        float[] f = new float[2];
        this.insert(this.root, rt, 0, cal, f);
        if (null == this.root.children) {
            return rt;
        }
        for (int i = 0; i < this.root.children.length; ++i) {
            this.insert(this.root.children[i], rt, i + 1, cal, f);
        }
        return rt;
    }

    public List<Point3f> getTargetPoints(boolean calibrated) {
        if (null == this.root) {
            return null;
        }
        ArrayList<Point3f> targets = new ArrayList<Point3f>();
        if (null == this.root.children) {
            return targets;
        }
        float[] f = new float[2];
        for (Node nd : this.root.children) {
            targets.add(this.fix(nd.asPoint(), calibrated, f));
        }
        return targets;
    }

    public Coordinate<Node<Float>> getCoordinateAtOrigin() {
        if (null == this.root) {
            return null;
        }
        return this.createCoordinate(this.root);
    }

    public Coordinate<Node<Float>> getCoordinate(int i) {
        if (null == this.root || !this.root.hasChildren()) {
            return null;
        }
        return this.createCoordinate(this.root.children[i]);
    }

    @Override
    public String getInfo() {
        if (null == this.root) {
            return "Empty";
        }
        return "Targets: " + this.root.getChildrenCount() + '\n';
    }

    @Override
    protected boolean layerRemoved(Layer la) {
        if (null == this.root) {
            return true;
        }
        if (this.root.la == la) {
            super.removeNode(this.root);
            return true;
        }
        return super.layerRemoved(la);
    }

    public static Connector merge(List<Connector> col) throws NoninvertibleTransformException {
        if (null == col || 0 == col.size()) {
            return null;
        }
        Connector base = col.get(0);
        for (Connector con : col.subList(1, col.size())) {
            base.mergeTargets(con);
            if (con.remove2(false)) continue;
            Utils.log("FAILED to merge Connector " + con + " into " + base);
            return null;
        }
        return base;
    }

    @Override
    public void mousePressed(MouseEvent me, Layer layer, int x_p, int y_p, double mag) {
        if (16 != ProjectToolbar.getToolId()) {
            return;
        }
        if (-1.0f == last_radius) {
            last_radius = 10.0f / (float)mag;
        }
        if (null != this.root) {
            int x_pl = x_p;
            int y_pl = y_p;
            if (!this.at.isIdentity()) {
                Point2D.Double po = this.inverseTransformPoint(x_p, y_p);
                x_pl = (int)po.x;
                y_pl = (int)po.y;
            }
            Node<Object> found = this.findNode(x_pl, y_pl, layer, mag);
            this.setActive(found);
            if (null != found) {
                if (2 == me.getClickCount()) {
                    this.setLastMarked(found);
                    this.setActive(null);
                    return;
                }
                if (me.isShiftDown() && Utils.isControlDown(me)) {
                    if (found == this.root) {
                        this.layer_set.addChangeTreesStep();
                        if (this.remove2(true)) {
                            this.setActive(null);
                            this.layer_set.addChangeTreesStep();
                        } else {
                            this.layer_set.removeLastUndoStep();
                        }
                        return;
                    }
                    this.removeNode(found);
                }
            } else {
                if (2 == me.getClickCount()) {
                    this.setLastMarked(null);
                    return;
                }
                found = this.newNode(x_pl, y_pl, layer, this.root);
                ((ConnectorNode)found).setData(Float.valueOf(last_radius));
                this.addNode(this.root, found, (byte)5);
                this.setActive(found);
                this.repaint(true, layer);
            }
            return;
        }
        this.root = this.newNode(x_p, y_p, layer, null);
        this.addNode(null, this.root, (byte)0);
        ((ConnectorNode)this.root).setData(Float.valueOf(last_radius));
        this.setActive(this.root);
    }

    @Override
    protected boolean requireAltDownToEditRadius() {
        return false;
    }

    @Override
    protected Rectangle getBounds(Collection<? extends Node<Float>> nodes) {
        Rectangle nb = new Rectangle();
        Rectangle box = null;
        for (Treeline.RadiusNode radiusNode : nodes) {
            int r;
            int n = r = 0.0f == radiusNode.r ? 1 : (int)radiusNode.r;
            if (null == box) {
                box = new Rectangle((int)radiusNode.x - r, (int)radiusNode.y - r, r + r, r + r);
                continue;
            }
            nb.setBounds((int)radiusNode.x - r, (int)radiusNode.y - r, r + r, r + r);
            box.add(nb);
        }
        return box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean crop(List<Layer> range) {
        if (null == this.root) {
            return true;
        }
        if (!range.contains(this.root.la)) {
            this.root = null;
            Map map = this.node_layer_map;
            synchronized (map) {
                this.clearCache();
            }
            return true;
        }
        return super.crop(range);
    }

    public static class ConnectorNode
    extends Treeline.RadiusNode {
        public ConnectorNode(float lx, float ly, Layer la) {
            super(lx, ly, la);
        }

        public ConnectorNode(float lx, float ly, Layer la, float radius) {
            super(lx, ly, la, radius);
        }

        public ConnectorNode(HashMap<String, String> attr) {
            super(attr);
        }

        @Override
        public final Node<Float> newInstance(float lx, float ly, Layer layer) {
            return new ConnectorNode(lx, ly, layer, 0.0f);
        }

        @Override
        public void paintData(Graphics2D g, Rectangle srcRect, Tree<Float> tree, AffineTransform to_screen, Color cc, Layer active_layer) {
            g.setColor(cc);
            g.draw(to_screen.createTransformedShape(new Ellipse2D.Float(this.x - this.r, this.y - this.r, this.r + this.r, this.r + this.r)));
        }

        @Override
        public boolean intersects(Area a) {
            if (0.0f == this.r) {
                return a.contains(this.x, this.y);
            }
            return M.intersects(a, this.getArea());
        }

        @Override
        public boolean isRoughlyInside(Rectangle localbox) {
            float r = this.r <= 0.0f ? 1.0f : this.r;
            return localbox.intersects(this.x - r, this.y - r, r + r, r + r);
        }

        @Override
        public Area getArea() {
            if (0.0f == this.r) {
                return super.getArea();
            }
            return new Area(new Ellipse2D.Float(this.x - this.r, this.y - this.r, this.r + this.r, this.r + this.r));
        }

        @Override
        public void paintHandle(Graphics2D g, Rectangle srcRect, double magnification, Tree<Float> t) {
            Point2D.Double po = t.transformPoint(this.x, this.y);
            float x = (float)((po.x - (double)srcRect.x) * magnification);
            float y = (float)((po.y - (double)srcRect.y) * magnification);
            if (null == this.parent) {
                g.setColor(brightGreen);
                g.fillOval((int)x - 6, (int)y - 6, 11, 11);
                g.setColor(Color.black);
                g.drawString("o", (int)x - 4, (int)y + 3);
            } else {
                g.setColor(Color.white);
                g.fillOval((int)x - 6, (int)y - 6, 11, 11);
                g.setColor(Color.black);
                g.drawString("x", (int)x - 4, (int)y + 3);
            }
        }
    }
}

