/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpicbg.models.CoordinateTransform;
import org.scijava.vecmath.Point3f;

public class Ball
extends ZDisplayable
implements VectorData {
    protected int n_points;
    protected double[][] p;
    protected long[] p_layer;
    protected double[] p_width;
    private static double last_radius = -1.0;
    private boolean fill_paint = true;
    static int index = -1;

    public Ball(Project project, String title, double x, double y) {
        super(project, title, x, y);
        this.n_points = 0;
        this.p = new double[2][5];
        this.p_layer = new long[5];
        this.p_width = new double[5];
        this.addToDatabase();
    }

    public Ball(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean locked, AffineTransform at) {
        super(project, id, title, locked, at, width, height);
        this.visible = visible;
        this.alpha = alpha;
        this.color = color;
        this.n_points = -1;
    }

    public Ball(Project project, long id, HashMap<String, String> ht, HashMap<Displayable, String> ht_links) {
        super(project, id, ht, ht_links);
        this.n_points = 0;
        this.p = new double[2][5];
        this.p_layer = new long[5];
        this.p_width = new double[5];
        String ob_data = ht.get("fill");
        try {
            if (null != ob_data) {
                this.fill_paint = "true".equals(ob_data.trim().toLowerCase());
            }
        }
        catch (Exception e) {
            Utils.log("Ball: could not read fill_paint value from XML:" + e);
        }
    }

    public void addBall(double x, double y, double r, long layer_id) {
        if (this.p[0].length == this.n_points) {
            this.enlargeArrays();
        }
        this.p[0][this.n_points] = x;
        this.p[1][this.n_points] = y;
        this.p_width[this.n_points] = r;
        this.p_layer[this.n_points] = layer_id;
        ++this.n_points;
    }

    private void enlargeArrays() {
        int length = this.p[0].length;
        double[][] p_copy = new double[2][length + 5];
        long[] p_layer_copy = new long[length + 5];
        double[] p_width_copy = new double[length + 5];
        System.arraycopy(this.p[0], 0, p_copy[0], 0, length);
        System.arraycopy(this.p[1], 0, p_copy[1], 0, length);
        System.arraycopy(this.p_layer, 0, p_layer_copy, 0, length);
        System.arraycopy(this.p_width, 0, p_width_copy, 0, length);
        this.p = p_copy;
        this.p_layer = p_layer_copy;
        this.p_width = p_width_copy;
    }

    protected int findPoint(double[][] a, int x_p, int y_p, double magnification, long lid) {
        int index = -1;
        double d = 10.0 / magnification;
        if (d < 4.0) {
            d = 4.0;
        }
        for (int i = 0; i < this.n_points; ++i) {
            if (this.p_layer[i] != lid || !(Math.abs((double)x_p - a[0][i]) + Math.abs((double)y_p - a[1][i]) <= this.p_width[i])) continue;
            index = i;
        }
        return index;
    }

    protected void removePoint(int index) {
        if (index < 0) {
            return;
        }
        if (this.n_points - 1 == index) {
            --this.n_points;
        } else {
            --this.n_points;
            for (int i = index; i < this.n_points; ++i) {
                this.p[0][i] = this.p[0][i + 1];
                this.p[1][i] = this.p[1][i + 1];
                this.p_layer[i] = this.p_layer[i + 1];
                this.p_width[i] = this.p_width[i + 1];
            }
        }
        this.updateInDatabase("points");
    }

    private void dragPoint(int index, int dx, int dy) {
        double[] dArray = this.p[0];
        int n = index;
        dArray[n] = dArray[n] + (double)dx;
        double[] dArray2 = this.p[1];
        int n2 = index;
        dArray2[n2] = dArray2[n2] + (double)dy;
    }

    private static double getFirstWidth() {
        if (null == Display.getFront()) {
            return 10.0;
        }
        if (-1.0 != last_radius) {
            return last_radius;
        }
        return 10.0 / Display.getFront().getCanvas().getMagnification();
    }

    protected int addPoint(double x_p, double y_p, long layer_id, double radius) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (this.p[0].length == this.n_points) {
            this.enlargeArrays();
        }
        this.p[0][this.n_points] = x_p;
        this.p[1][this.n_points] = y_p;
        this.p_layer[this.n_points] = layer_id;
        this.p_width[this.n_points] = radius;
        index = this.n_points++;
        this.updateInDatabase("INSERT INTO ab_ball_points (ball_id, x, y, width, layer_id) VALUES (" + this.id + "," + x_p + "," + y_p + "," + this.p_width[index] + "," + layer_id + ")");
        return index;
    }

    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        Color above;
        Color below;
        Composite perimeter_composite;
        if (0 == this.n_points) {
            return;
        }
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        Composite original_composite = g.getComposite();
        Composite composite = perimeter_composite = this.alpha == 1.0f ? original_composite : AlphaComposite.getInstance(3, this.alpha);
        Composite area_composite = this.fill_paint ? (this.alpha > 0.4f ? AlphaComposite.getInstance(3, 0.4f) : perimeter_composite) : null;
        AffineTransform gt = g.getTransform();
        g.setTransform(DisplayCanvas.DEFAULT_AFFINE);
        Stroke stroke = g.getStroke();
        g.setStroke(DisplayCanvas.DEFAULT_STROKE);
        double[][] p = this.p;
        double[] p_width = this.p_width;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            p_width = (double[])ob[1];
        }
        boolean color_cues = this.layer_set.color_cues;
        int n_layers_color_cue = this.layer_set.n_layers_color_cue;
        if (this.layer_set.use_color_cue_colors) {
            below = Color.red;
            above = Color.blue;
        } else {
            below = this.color;
            above = this.color;
        }
        double current_layer_z = active_layer.getZ();
        int current_layer_index = this.layer_set.indexOf(active_layer);
        long active_lid = active_layer.getId();
        for (int j = 0; j < this.n_points; ++j) {
            double z;
            double depth;
            if (active_lid == this.p_layer[j]) {
                g.setColor(this.color);
                int radius = (int)p_width[j];
                int x = (int)((p[0][j] - (double)radius - (double)srcRect.x) * magnification);
                int y = (int)((p[1][j] - (double)radius - (double)srcRect.y) * magnification);
                int w = (int)((double)(2 * radius) * magnification);
                if (this.fill_paint) {
                    g.setComposite(area_composite);
                    g.fillOval(x, y, w, w);
                }
                g.setComposite(perimeter_composite);
                g.drawOval(x, y, w, w);
                continue;
            }
            if (!color_cues) continue;
            boolean can_paint = -1 == n_layers_color_cue;
            Layer layer = this.layer_set.getLayer(this.p_layer[j]);
            if (!can_paint) {
                boolean bl = can_paint = Math.abs(current_layer_index - this.layer_set.indexOf(layer)) <= n_layers_color_cue;
            }
            if (!can_paint || !((depth = Math.abs(current_layer_z - (z = layer.getZ()))) < this.p_width[j])) continue;
            if (z < current_layer_z) {
                g.setColor(below);
            } else {
                g.setColor(above);
            }
            int slice_radius = (int)(p_width[j] * Math.sqrt(1.0 - Math.pow(depth / p_width[j], 2.0)));
            int x = (int)((p[0][j] - (double)slice_radius - (double)srcRect.x) * magnification);
            int y = (int)((p[1][j] - (double)slice_radius - (double)srcRect.y) * magnification);
            int w = (int)((double)(2 * slice_radius) * magnification);
            if (this.fill_paint) {
                g.setComposite(area_composite);
                g.fillOval(x, y, w, w);
            }
            g.setComposite(perimeter_composite);
            g.drawOval(x, y, w, w);
        }
        if (active) {
            long layer_id = active_layer.getId();
            for (int j = 0; j < this.n_points; ++j) {
                if (layer_id != this.p_layer[j]) continue;
                DisplayCanvas.drawScreenHandle(g, (int)((p[0][j] - (double)srcRect.x) * magnification), (int)((p[1][j] - (double)srcRect.y) * magnification));
            }
        }
        g.setComposite(original_composite);
        g.setTransform(gt);
        g.setStroke(stroke);
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void mousePressed(MouseEvent me, Layer layer, int x_p, int y_p, double mag) {
        int tool;
        if (!this.at.isIdentity()) {
            Point2D.Double po = this.inverseTransformPoint(x_p, y_p);
            x_p = (int)po.x;
            y_p = (int)po.y;
        }
        if (16 == (tool = ProjectToolbar.getToolId())) {
            long layer_id = layer.getId();
            index = Utils.isControlDown(me) && me.isShiftDown() ? Ball.findNearestPoint(this.p, this.p_layer, this.n_points, x_p, y_p, layer.getId()) : this.findPoint(this.p, x_p, y_p, mag, layer.getId());
            if (-1 != index) {
                if (layer_id == this.p_layer[index]) {
                    if (Utils.isControlDown(me) && me.isShiftDown() && this.p_layer[index] == Display.getFrontLayer().getId()) {
                        this.removePoint(index);
                        index = -1;
                        this.repaint(false, layer);
                        return;
                    }
                } else {
                    index = -1;
                }
                if (-1 != index) {
                    last_radius = this.p_width[index];
                }
            }
            if (-1 == index) {
                index = this.addPoint(x_p, y_p, layer_id, 0 == this.n_points ? Ball.getFirstWidth() : this.p_width[this.n_points - 1]);
                this.repaint(false, layer);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        int tool;
        if (!this.at.isIdentity()) {
            Point2D.Double p = this.inverseTransformPoint(x_p, y_p);
            x_p = (int)p.x;
            y_p = (int)p.y;
            Point2D.Double pd = this.inverseTransformPoint(x_d, y_d);
            x_d = (int)pd.x;
            y_d = (int)pd.y;
            Point2D.Double pdo = this.inverseTransformPoint(x_d_old, y_d_old);
            x_d_old = (int)pdo.x;
            y_d_old = (int)pdo.y;
        }
        if (16 == (tool = ProjectToolbar.getToolId()) && -1 != index) {
            if (me.isShiftDown()) {
                this.p_width[Ball.index] = Math.sqrt(((double)x_d - this.p[0][index]) * ((double)x_d - this.p[0][index]) + ((double)y_d - this.p[1][index]) * ((double)y_d - this.p[1][index]));
                last_radius = this.p_width[index];
                Utils.showStatus("radius: " + this.p_width[index], false);
            } else {
                this.dragPoint(index, x_d - x_d_old, y_d - y_d_old);
            }
            this.repaint(false, layer);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        if (-1 != index && index != this.n_points) {
            this.updateInDatabase("points");
        }
        if (-1 != index) {
            this.updateInDatabase("transform+dimensions");
        }
        index = -1;
        this.repaint(true, layer);
    }

    @Override
    protected boolean calculateBoundingBox(Layer la) {
        this.calculateBoundingBox(true, la);
        return true;
    }

    private void calculateBoundingBox(boolean adjust_position, Layer la) {
        int i;
        double min_x = Double.MAX_VALUE;
        double min_y = Double.MAX_VALUE;
        double max_x = 0.0;
        double max_y = 0.0;
        if (0 == this.n_points) {
            this.height = 0.0f;
            this.width = 0.0f;
            this.updateBucket(la);
            return;
        }
        if (0 != this.n_points) {
            for (i = 0; i < this.n_points; ++i) {
                if (this.p[0][i] - this.p_width[i] < min_x) {
                    min_x = this.p[0][i] - this.p_width[i];
                }
                if (this.p[1][i] - this.p_width[i] < min_y) {
                    min_y = this.p[1][i] - this.p_width[i];
                }
                if (this.p[0][i] + this.p_width[i] > max_x) {
                    max_x = this.p[0][i] + this.p_width[i];
                }
                if (!(this.p[1][i] + this.p_width[i] > max_y)) continue;
                max_y = this.p[1][i] + this.p_width[i];
            }
        }
        this.width = (float)(max_x - min_x);
        this.height = (float)(max_y - min_y);
        if (adjust_position) {
            i = 0;
            while (i < this.n_points) {
                double[] dArray = this.p[0];
                int n = i;
                dArray[n] = dArray[n] - min_x;
                double[] dArray2 = this.p[1];
                int n2 = i++;
                dArray2[n2] = dArray2[n2] - min_y;
            }
            this.at.translate(min_x, min_y);
            this.updateInDatabase("transform+dimensions");
        } else {
            this.updateInDatabase("dimensions");
        }
        this.updateBucket(la);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.p = null;
        this.p_layer = null;
        this.p_width = null;
    }

    public void repaint(boolean repaint_navigator, Layer layer) {
        Rectangle box = this.getBoundingBox(null);
        this.calculateBoundingBox(true, layer);
        box.add(this.getBoundingBox(null));
        Display.repaint(this.layer_set, (Displayable)this, box, 5, repaint_navigator);
    }

    private void setupForDisplay() {
        if (null == this.p) {
            ArrayList<?> al = this.project.getLoader().fetchBallPoints(this.id);
            this.n_points = al.size();
            this.p = new double[2][this.n_points];
            this.p_layer = new long[this.n_points];
            this.p_width = new double[this.n_points];
            Iterator<?> it = al.iterator();
            int i = 0;
            while (it.hasNext()) {
                Object[] ob = (Object[])it.next();
                this.p[0][i] = (Double)ob[0];
                this.p[1][i] = (Double)ob[1];
                this.p_width[i] = (Double)ob[2];
                this.p_layer[i] = (Long)ob[3];
                ++i;
            }
        }
    }

    public void flush() {
        this.p = null;
        this.p_width = null;
        this.p_layer = null;
        this.n_points = -1;
    }

    @Override
    public Polygon getPerimeter() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        double[][] p = this.p;
        double[] p_width = this.p_width;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            p_width = (double[])ob[1];
        }
        if (-1 != index) {
            return new Polygon(new int[]{(int)(p[0][index] - p_width[index]), (int)(p[0][index] + p_width[index]), (int)(p[0][index] + p_width[index]), (int)(p[0][index] - p_width[index])}, new int[]{(int)(p[1][index] - p_width[index]), (int)(p[1][index] + p_width[index]), (int)(p[1][index] + p_width[index]), (int)(p[1][index] - p_width[index])}, 4);
        }
        return super.getPerimeter();
    }

    public void toShapesFile(StringBuffer data, String group, String color, double z_scale) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        HashMap<Long, StringBuffer> ht = new HashMap<Long, StringBuffer>();
        int l = 10;
        double[][] p = this.p;
        double[] p_width = this.p_width;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            p_width = (double[])ob[1];
        }
        StringBuffer sb = new StringBuffer();
        sb.append("type=ball").append('\n').append("name=").append(this.project.getMeaningfulTitle(this)).append('\n').append("group=").append(group).append('\n').append("color=").append(color).append('\n').append("supergroup=").append("null").append('\n').append("supercolor=").append("null").append('\n').append("in slice=");
        StringBuffer tmp = null;
        for (int i = 0; i < this.n_points; ++i) {
            Long layer_id = new Long(this.p_layer[i]);
            for (Map.Entry e : ht.entrySet()) {
                if ((Long)e.getKey() != this.p_layer[i]) continue;
                tmp = (StringBuffer)e.getValue();
            }
            if (null == tmp) {
                tmp = new StringBuffer(sb.toString());
                tmp.append(this.layer.getParent().getLayer(this.p_layer[i]).getZ() * z_scale).append('\n');
                ht.put(layer_id, tmp);
            }
            tmp.append("x").append(p[0][i]).append('\n').append("y").append(p[1][i]).append('\n').append("r").append(p_width[i]).append('\n');
            tmp = null;
        }
        for (StringBuffer s : ht.values()) {
            data.append(s).append('\n');
            Utils.log("s : " + s.toString());
        }
    }

    public String[] getPointsForSQL() {
        String[] sql = new String[this.n_points];
        for (int i = 0; i < this.n_points; ++i) {
            StringBuilder sb = new StringBuilder("INSERT INTO ab_ball_points (ball_id, x, y, width, layer_id) VALUES (");
            sb.append(this.id).append(",").append(this.p[0][i]).append(",").append(this.p[1][i]).append(",").append(this.p_width[i]).append(",").append(this.p_layer[i]).append(")");
            sql[i] = sb.toString();
        }
        return sql;
    }

    @Override
    public boolean isDeletable() {
        return 0 == this.n_points;
    }

    @Override
    public boolean contains(Layer layer, double x, double y) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return false;
        }
        Point2D.Double po = this.inverseTransformPoint(x, y);
        x = po.x;
        y = po.y;
        long layer_id = layer.getId();
        for (int i = 0; i < this.n_points; ++i) {
            if (layer_id != this.p_layer[i] || !(x >= this.p[0][i] - this.p_width[i]) || !(x <= this.p[0][i] + this.p_width[i]) || !(y >= this.p[1][i] - this.p_width[i]) || !(y <= this.p[1][i] + this.p_width[i])) continue;
            return true;
        }
        return false;
    }

    private Rectangle[] getSubPerimeters(Layer layer) {
        ArrayList<Rectangle> al = new ArrayList<Rectangle>();
        long layer_id = layer.getId();
        double[][] p = this.p;
        double[] p_width = this.p_width;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            p_width = (double[])ob[1];
        }
        for (int i = 0; i < this.n_points; ++i) {
            if (layer_id != this.p_layer[i]) continue;
            al.add(new Rectangle((int)(p[0][i] - p_width[i]), (int)(p[1][i] - p_width[i]), (int)Math.ceil(p_width[i] + p_width[i]), (int)Math.ceil(p_width[i] + p_width[i])));
        }
        if (al.isEmpty()) {
            return null;
        }
        Rectangle[] rects = new Rectangle[al.size()];
        al.toArray(rects);
        return rects;
    }

    @Override
    public boolean linkPatches() {
        this.unlinkAll(Patch.class);
        ArrayList<Displayable> al = this.layer.getDisplayables(Patch.class);
        Rectangle[] perimeters = this.getSubPerimeters(this.layer);
        if (null == perimeters) {
            return false;
        }
        boolean must_lock = false;
        Rectangle box = new Rectangle();
        block0: for (Displayable displ : al) {
            for (int i = 0; i < perimeters.length; ++i) {
                if (!perimeters[i].intersects(displ.getBoundingBox(box))) continue;
                this.link(displ);
                if (!displ.locked) continue block0;
                must_lock = true;
                continue block0;
            }
        }
        if (must_lock && !this.locked) {
            this.setLocked(true);
            return true;
        }
        return false;
    }

    @Override
    public Layer getFirstLayer() {
        if (0 == this.n_points) {
            return this.layer;
        }
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        Layer la = this.layer;
        double z = Double.MAX_VALUE;
        for (int i = 0; i < this.n_points; ++i) {
            Layer layer = this.layer_set.getLayer(this.p_layer[i]);
            if (!(layer.getZ() < Double.MAX_VALUE)) continue;
            la = layer;
        }
        return la;
    }

    public Map<Layer, double[]> getRawBalls() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        HashMap<Layer, double[]> m = new HashMap<Layer, double[]>();
        for (int i = 0; i < this.n_points; ++i) {
            m.put(this.layer_set.getLayer(this.p_layer[i]), new double[]{this.p[0][i], this.p[1][i], this.p_width[i]});
        }
        return m;
    }

    public double[][] getBalls() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        double[][] b = new double[this.n_points][4];
        for (int i = 0; i < this.n_points; ++i) {
            b[i][0] = this.p[0][i];
            b[i][1] = this.p[1][i];
            b[i][2] = this.layer_set.getLayer(this.p_layer[i]).getZ();
            b[i][3] = this.p_width[i];
        }
        return b;
    }

    public double[][] getWorldBalls() {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        double[][] b = new double[this.n_points][4];
        Calibration cal = this.getLayerSet().getCalibrationCopy();
        int sign = cal.pixelDepth < 0.0 ? -1 : 1;
        for (int i = 0; i < this.n_points; ++i) {
            Point2D.Double po = this.transformPoint(this.p[0][i], this.p[1][i]);
            b[i][0] = po.x * cal.pixelWidth;
            b[i][1] = po.y * cal.pixelHeight;
            b[i][2] = this.layer_set.getLayer(this.p_layer[i]).getZ() * cal.pixelWidth * (double)sign;
            b[i][3] = this.p_width[i] * cal.pixelWidth;
        }
        return b;
    }

    public List<Point3f> asWorldPoints() {
        ArrayList<Point3f> ps = new ArrayList<Point3f>();
        for (double[] d : this.getWorldBalls()) {
            ps.add(new Point3f((float)d[0], (float)d[1], (float)d[2]));
        }
        return ps;
    }

    @Override
    public void exportSVG(StringBuffer data, double z_scale, String indent) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return;
        }
        String in = indent + "\t";
        String[] RGB = Utils.getHexRGBColor(this.color);
        double[] a = new double[6];
        this.at.getMatrix(a);
        data.append(indent).append("<ball_ob\n>").append(in).append("id=\"").append(this.id).append("\"").append(in).append("transform=\"matrix(").append(a[0]).append(',').append(a[1]).append(',').append(a[2]).append(',').append(a[3]).append(',').append(a[4]).append(',').append(a[5]).append(")\"\n").append(in).append("style=\"fill:none;stroke-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";stroke-width:1.0px;stroke-opacity:1.0\"\n").append(in).append("links=\"");
        if (null != this.hs_linked && 0 != this.hs_linked.size()) {
            int ii = 0;
            int len = this.hs_linked.size();
            for (Displayable d : this.hs_linked) {
                data.append(d.getId());
                if (ii != len - 1) {
                    data.append(",");
                }
                ++ii;
            }
        }
        data.append("\"\n").append(indent).append(">\n");
        for (int i = 0; i < this.n_points; ++i) {
            data.append(in).append("<ball x=\"").append(this.p[0][i]).append("\" y=\"").append(this.p[1][0]).append("\" z=\"").append(this.layer_set.getLayer(this.p_layer[i]).getZ() * z_scale).append("\" r=\"").append(this.p_width[i]).append("\" />\n");
        }
        data.append(indent).append("</ball_ob>\n");
    }

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        String in = indent + "\t";
        String[] RGB = Utils.getHexRGBColor(this.color);
        sb_body.append(indent).append("<t2_ball\n");
        super.exportXML(sb_body, in, options);
        if (!this.fill_paint) {
            sb_body.append(in).append("fill=\"").append(this.fill_paint).append("\"\n");
        }
        sb_body.append(in).append("style=\"fill:none;stroke-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";stroke-width:1.0px;\"\n");
        sb_body.append(indent).append(">\n");
        for (int i = 0; i < this.n_points; ++i) {
            sb_body.append(in).append("<t2_ball_ob x=\"").append(this.p[0][i]).append("\" y=\"").append(this.p[1][i]).append("\" layer_id=\"").append(this.p_layer[i]).append("\" r=\"").append(this.p_width[i]).append("\" />\n");
        }
        super.restXML(sb_body, in, options);
        sb_body.append(indent).append("</t2_ball>\n");
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_ball";
        if (hs.contains("t2_ball")) {
            return;
        }
        hs.add("t2_ball");
        sb_header.append(indent).append("<!ELEMENT t2_ball (").append(Displayable.commonDTDChildren()).append(",t2_ball_ob)>\n");
        Displayable.exportDTD("t2_ball", sb_header, hs, indent);
        sb_header.append(indent).append("<!ATTLIST t2_ball fill NMTOKEN #REQUIRED>\n").append(indent).append("<!ELEMENT t2_ball_ob EMPTY>\n").append(indent).append("<!ATTLIST t2_ball_ob x NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_ball_ob y NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_ball_ob r NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST t2_ball_ob layer_id NMTOKEN #REQUIRED>\n");
    }

    @Override
    public boolean paintsAt(Layer layer) {
        if (!super.paintsAt(layer)) {
            return false;
        }
        long lid_previous = this.layer_set.previous(layer).getId();
        long lid_next = this.layer_set.next(layer).getId();
        long lid = layer.getId();
        for (int i = 0; i < this.p_layer.length; ++i) {
            if (lid != this.p_layer[i] && lid_previous != this.p_layer[i] && lid_next != this.p_layer[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getInfo() {
        HashMap<Long, ArrayList<Integer>> ht = new HashMap<Long, ArrayList<Integer>>();
        for (int i = 0; i < this.n_points; ++i) {
            ArrayList<Integer> al = (ArrayList<Integer>)ht.get(new Long(this.p_layer[i]));
            if (null == al) {
                al = new ArrayList<Integer>();
                ht.put(this.p_layer[i], al);
            }
            al.add(i);
        }
        int total = 0;
        StringBuilder sb1 = new StringBuilder("Ball id: ").append(this.id).append('\n');
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : ht.entrySet()) {
            long lid = (Long)entry.getKey();
            ArrayList al = (ArrayList)entry.getValue();
            sb.append("\tLayer ").append(this.layer_set.getLayer(lid).toString()).append(":\n");
            sb.append("\t\tcount : ").append(al.size()).append('\n');
            total += al.size();
            double average = 0.0;
            for (Integer i : al) {
                average += this.p_width[i];
            }
            sb.append("\t\taverage radius: ").append(average / (double)al.size()).append('\n');
        }
        return sb1.append("Total count: ").append(total).append('\n').append((CharSequence)sb).toString();
    }

    @Override
    public Displayable clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Ball copy = new Ball(pr, nid, null != this.title ? this.title.toString() : null, this.width, this.height, this.alpha, this.visible, new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()), this.locked, (AffineTransform)this.at.clone());
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        copy.n_points = this.n_points;
        copy.p = new double[][]{(double[])this.p[0].clone(), (double[])this.p[1].clone()};
        copy.p_layer = (long[])this.p_layer.clone();
        copy.p_width = (double[])this.p_width.clone();
        copy.addToDatabase();
        return copy;
    }

    public static double[][][] generateGlobe(int meridians, int parallels) {
        if (meridians < 3) {
            meridians = 3;
        }
        if (parallels < 3) {
            parallels = 3;
        }
        double angle_increase = Math.PI * 2 / (double)meridians;
        double temp_angle = 0.0;
        double[][] xy_points = new double[meridians + 1][2];
        xy_points[0][0] = 1.0;
        xy_points[0][1] = 0.0;
        for (int m = 1; m < meridians; ++m) {
            temp_angle = angle_increase * (double)m;
            xy_points[m][0] = Math.cos(temp_angle);
            xy_points[m][1] = Math.sin(temp_angle);
        }
        xy_points[xy_points.length - 1][0] = 1.0;
        xy_points[xy_points.length - 1][1] = 0.0;
        angle_increase = Math.PI / (double)parallels;
        double[][][] xyz = new double[parallels + 1][xy_points.length][3];
        for (int p = 1; p < xyz.length - 1; ++p) {
            double radius = Math.sin(angle_increase * (double)p);
            double Z = Math.cos(angle_increase * (double)p);
            for (int mm = 0; mm < xyz[0].length - 1; ++mm) {
                xyz[p][mm][0] = xy_points[mm][0] * radius;
                xyz[p][mm][1] = xy_points[mm][1] * radius;
                xyz[p][mm][2] = Z;
            }
            xyz[p][xyz[0].length - 1][0] = xyz[p][0][0];
            xyz[p][xyz[0].length - 1][1] = xyz[p][0][1];
            xyz[p][xyz[0].length - 1][2] = xyz[p][0][2];
        }
        for (int ns = 0; ns < xyz[0].length; ++ns) {
            xyz[0][ns][0] = 0.0;
            xyz[0][ns][1] = 0.0;
            xyz[0][ns][2] = 1.0;
            xyz[xyz.length - 1][ns][0] = 0.0;
            xyz[xyz.length - 1][ns][1] = 0.0;
            xyz[xyz.length - 1][ns][2] = -1.0;
        }
        return xyz;
    }

    public List<Point3f> generateTriangles(double scale, double[][][] globe) {
        try {
            Class.forName("org.scijava.vecmath.Point3f");
        }
        catch (ClassNotFoundException cnfe) {
            Utils.log("Java3D is not installed.");
            return null;
        }
        Calibration cal = this.layer_set.getCalibrationCopy();
        ArrayList<Point3f> list = new ArrayList<Point3f>();
        double[][] p = this.p;
        double[] p_width = this.p_width;
        if (!this.at.isIdentity()) {
            Object[] ob = this.getTransformedData();
            p = (double[][])ob[0];
            p_width = (double[])ob[1];
        }
        int sign = cal.pixelDepth < 0.0 ? -1 : 1;
        for (int i = 0; i < this.n_points; ++i) {
            int k;
            int z;
            double[][][] ball = new double[globe.length][globe[0].length][3];
            for (z = 0; z < ball.length; ++z) {
                for (k = 0; k < ball[0].length; ++k) {
                    ball[z][k][0] = (globe[z][k][0] * p_width[i] + p[0][i]) * scale * cal.pixelWidth;
                    ball[z][k][1] = (globe[z][k][1] * p_width[i] + p[1][i]) * scale * cal.pixelHeight;
                    ball[z][k][2] = (globe[z][k][2] * p_width[i] + this.layer_set.getLayer(this.p_layer[i]).getZ()) * scale * cal.pixelWidth * (double)sign;
                }
            }
            for (z = 0; z < ball.length - 1; ++z) {
                for (k = 0; k < ball[0].length - 1; ++k) {
                    list.add(new Point3f((float)ball[z][k][0], (float)ball[z][k][1], (float)ball[z][k][2]));
                    list.add(new Point3f((float)ball[z + 1][k + 1][0], (float)ball[z + 1][k + 1][1], (float)ball[z + 1][k + 1][2]));
                    list.add(new Point3f((float)ball[z + 1][k][0], (float)ball[z + 1][k][1], (float)ball[z + 1][k][2]));
                    list.add(new Point3f((float)ball[z][k][0], (float)ball[z][k][1], (float)ball[z][k][2]));
                    list.add(new Point3f((float)ball[z][k + 1][0], (float)ball[z][k + 1][1], (float)ball[z][k + 1][2]));
                    list.add(new Point3f((float)ball[z + 1][k + 1][0], (float)ball[z + 1][k + 1][1], (float)ball[z + 1][k + 1][2]));
                }
            }
        }
        return list;
    }

    private final Object[] getTransformedData() {
        return this.getTransformedData(null);
    }

    private final Object[] getTransformedData(AffineTransform additional) {
        double[][] p = this.transformPoints(this.p, additional);
        double[][] pw = new double[2][this.n_points];
        for (int i = 0; i < this.n_points; ++i) {
            pw[0][i] = this.p[0][i] + this.p_width[i];
            pw[1][i] = this.p[1][i] + this.p_width[i];
        }
        pw = this.transformPoints(pw, additional);
        double[] p_width = new double[this.n_points];
        for (int i = 0; i < this.n_points; ++i) {
            p_width[i] = (Math.abs(pw[0][i] - p[0][i]) + Math.abs(pw[1][i] - p[1][i])) / 2.0;
        }
        return new Object[]{p, p_width};
    }

    @Override
    public boolean intersects(Area area, double z_first, double z_last) {
        int i;
        double min_z = Double.MAX_VALUE;
        double max_z = 0.0;
        for (i = 0; i < this.n_points; ++i) {
            double laz = this.layer_set.getLayer(this.p_layer[i]).getZ();
            if (laz < min_z) {
                min_z = laz;
            }
            if (!(laz > max_z)) continue;
            max_z = laz;
        }
        if (z_last < min_z || z_first > max_z) {
            return false;
        }
        for (i = 0; i < this.n_points; ++i) {
            Rectangle[] rec = this.getSubPerimeters(this.layer_set.getLayer(this.p_layer[i]));
            for (int k = 0; k < rec.length; ++k) {
                Area a = new Area(rec[k]);
                a.intersect(area);
                Rectangle r = a.getBounds();
                if (0 == r.width || 0 == r.height) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized Area getAreaAt(Layer layer) {
        Area a = new Area();
        for (int i = 0; i < this.n_points; ++i) {
            if (this.p_layer[i] != layer.getId()) continue;
            a.add(new Area(new Ellipse2D.Float((float)(this.p[0][i] - this.p_width[i] / 2.0), (float)(this.p[1][i] - this.p_width[i] / 2.0), (float)this.p_width[i], (float)this.p_width[i])));
        }
        a.transform(this.at);
        return a;
    }

    @Override
    protected boolean isRoughlyInside(Layer layer, Rectangle r) {
        if (0 == this.n_points) {
            return false;
        }
        try {
            Rectangle box = this.at.createInverse().createTransformedShape(r).getBounds();
            for (int i = 0; i < this.n_points; ++i) {
                if (!box.contains(this.p[0][i], this.p[1][i])) continue;
                return true;
            }
        }
        catch (NoninvertibleTransformException nite) {
            IJError.print(nite);
        }
        return false;
    }

    @Override
    public ResultsTable measure(ResultsTable rt) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        if (0 == this.n_points) {
            return rt;
        }
        if (null == rt) {
            rt = Utils.createResultsTable("Ball results", new String[]{"id", "index", "x", "y", "z", "radius", "name-id"});
        }
        Object[] ob = this.getTransformedData();
        double[][] p = (double[][])ob[0];
        double[] p_width = (double[])ob[1];
        Calibration cal = this.layer_set.getCalibration();
        for (int i = 0; i < this.n_points; ++i) {
            rt.incrementCounter();
            rt.addLabel("units", cal.getUnit());
            rt.addValue(0, (double)this.id);
            rt.addValue(1, (double)(i + 1));
            rt.addValue(2, p[0][i] * cal.pixelWidth);
            rt.addValue(3, p[1][i] * cal.pixelHeight);
            rt.addValue(4, this.layer_set.getLayer(this.p_layer[i]).getZ() * cal.pixelWidth);
            rt.addValue(5, p_width[i] * cal.pixelWidth);
            rt.addValue(6, this.getNameId());
        }
        return rt;
    }

    @Override
    Class<?> getInternalDataPackageClass() {
        return DPBall.class;
    }

    @Override
    Object getDataPackage() {
        return new DPBall(this);
    }

    @Override
    public synchronized boolean crop(List<Layer> range) {
        if (-1 == this.n_points) {
            this.setupForDisplay();
        }
        HashSet<Long> lids = new HashSet<Long>();
        for (Layer l : range) {
            lids.add(l.getId());
        }
        for (int i = 0; i < this.n_points; ++i) {
            if (lids.contains(this.p_layer[i])) continue;
            this.removePoint(i);
            --i;
        }
        this.calculateBoundingBox(true, null);
        return true;
    }

    @Override
    protected synchronized boolean layerRemoved(Layer la) {
        super.layerRemoved(la);
        for (int i = 0; i < this.p_layer.length; ++i) {
            if (la.getId() != this.p_layer[i]) continue;
            this.removePoint(i);
            --i;
        }
        return true;
    }

    @Override
    public synchronized boolean apply(Layer la, Area roi, CoordinateTransform ict) throws Exception {
        double[] fp = null;
        CoordinateTransform chain = null;
        Area localroi = null;
        AffineTransform inverse = null;
        for (int i = 0; i < this.n_points; ++i) {
            if (this.p_layer[i] != la.getId()) continue;
            if (null == localroi) {
                inverse = this.at.createInverse();
                localroi = roi.createTransformedArea(inverse);
            }
            if (!localroi.contains(this.p[0][i], this.p[1][i])) continue;
            if (null == chain) {
                chain = M.wrap(this.at, ict, inverse);
                fp = new double[2];
            }
            double ox = this.p[0][i];
            double oy = this.p[1][i];
            M.apply(chain, this.p, i, fp);
            fp[0] = (float)(ox + this.p_width[i]);
            fp[1] = (float)oy;
            chain.applyInPlace(fp);
            this.p_width[i] = Math.abs(fp[0] - this.p[0][i]);
        }
        if (null != chain) {
            this.calculateBoundingBox(true, la);
        }
        return true;
    }

    @Override
    public boolean apply(VectorDataTransform vdt) throws Exception {
        double[] fp = new double[2];
        VectorDataTransform vlocal = vdt.makeLocalTo(this);
        block0: for (int i = 0; i < this.n_points; ++i) {
            if (vlocal.layer.getId() != this.p_layer[i]) continue;
            for (VectorDataTransform.ROITransform rt : vlocal.transforms) {
                if (!rt.roi.contains(this.p[0][i], this.p[1][i])) continue;
                double ox = this.p[0][i];
                double oy = this.p[1][i];
                M.apply(rt.ct, this.p, i, fp);
                fp[0] = (float)(ox + this.p_width[i]);
                fp[1] = (float)oy;
                rt.ct.applyInPlace(fp);
                this.p_width[i] = Math.sqrt(Math.pow(fp[0] - this.p[0][i], 2.0) + Math.pow(fp[1] - this.p[1][i], 2.0));
                continue block0;
            }
        }
        this.calculateBoundingBox(true, vlocal.layer);
        return true;
    }

    @Override
    public synchronized Collection<Long> getLayerIds() {
        return Utils.asList(this.p_layer, 0, this.n_points);
    }

    @Override
    public void adjustProperties() {
        GenericDialog gd = this.makeAdjustPropertiesDialog();
        gd.addCheckbox("Paint as outlines", !this.fill_paint);
        gd.addCheckbox("Apply paint mode to all Ball instances", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        Displayable.DoEdit prev = this.processAdjustPropertiesDialog(gd);
        boolean fp = !gd.getNextBoolean();
        boolean to_all = gd.getNextBoolean();
        if (to_all) {
            for (ZDisplayable zd : this.layer_set.getZDisplayables()) {
                if (zd.getClass() != Ball.class) continue;
                Ball b = (Ball)zd;
                b.fill_paint = fp;
                b.updateInDatabase("fill_paint");
            }
            Display.repaint(this.layer_set);
        } else if (this.fill_paint != fp) {
            prev.add("fill_paint", fp);
            this.fill_paint = fp;
            this.updateInDatabase("fill_paint");
        }
        Displayable.DoEdit current = new Displayable.DoEdit(this).init(prev);
        if (this.isLinked()) {
            current.add(new Displayable.DoTransforms().addAll(this.getLinkedGroup(null)));
        }
        this.getLayerSet().addEditStep(current);
    }

    public void set(int i, double x, double y, Layer la, double radius) {
        if (i < 0 || i > this.n_points) {
            throw new IndexOutOfBoundsException("i must be 0<=i<n_points, but it is " + i);
        }
        this.p[0][i] = x;
        this.p[1][i] = y;
        this.p_layer[i] = la.getId();
        this.p_width[i] = radius;
    }

    public int getCount() {
        return this.n_points;
    }

    public void setRadius(int i, double radius) {
        if (i < 0 || i > this.n_points) {
            throw new IndexOutOfBoundsException("i must be 0<=i<n_points, but it is " + i);
        }
        this.p_width[i] = radius;
    }

    private static final class DPBall
    extends Displayable.DataPackage {
        final double[][] p;
        final double[] p_width;
        final long[] p_layer;

        DPBall(Ball ball) {
            super(ball);
            this.p = new double[][]{Utils.copy(ball.p[0], ball.n_points), Utils.copy(ball.p[1], ball.n_points)};
            this.p_width = Utils.copy(ball.p_width, ball.n_points);
            this.p_layer = new long[ball.n_points];
            System.arraycopy(ball.p_layer, 0, this.p_layer, 0, ball.n_points);
        }

        @Override
        final boolean to2(Displayable d) {
            super.to1(d);
            Ball ball = (Ball)d;
            int len = this.p[0].length;
            ball.p = new double[][]{Utils.copy(this.p[0], len), Utils.copy(this.p[1], len)};
            ball.n_points = this.p[0].length;
            ball.p_layer = new long[len];
            System.arraycopy(this.p_layer, 0, ball.p_layer, 0, len);
            ball.p_width = Utils.copy(this.p_width, len);
            return true;
        }
    }
}

