/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr.cache;

import com.google.gson.JsonElement;
import org.janelia.saalfeldlab.n5.cache.N5JsonCache;
import org.janelia.saalfeldlab.n5.cache.N5JsonCacheableContainer;

public class ZarrJsonCache
extends N5JsonCache {
    public ZarrJsonCache(N5JsonCacheableContainer container) {
        super(container);
    }

    @Override
    public void updateCacheInfo(String normalPathKey, String normalCacheKey, JsonElement uncachedAttributes) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.addNewCacheInfo(normalPathKey, normalCacheKey, uncachedAttributes);
            return;
        }
        if (cacheInfo == emptyCacheInfo) {
            cacheInfo = this.newCacheInfo();
        }
        if (normalCacheKey != null) {
            JsonElement attributesToCache = uncachedAttributes == null ? this.container.getAttributesFromContainer(normalPathKey, normalCacheKey) : uncachedAttributes;
            this.updateCacheAttributes(cacheInfo, normalCacheKey, attributesToCache);
            if (normalCacheKey.equals(".zgroup")) {
                if (this.container.isGroupFromAttributes(normalCacheKey, attributesToCache)) {
                    this.updateCacheIsGroup(cacheInfo, true);
                    this.updateCacheIsDataset(cacheInfo, false);
                }
            } else if (normalCacheKey.equals(".zarray") && this.container.isDatasetFromAttributes(normalCacheKey, attributesToCache)) {
                this.updateCacheIsGroup(cacheInfo, false);
                this.updateCacheIsDataset(cacheInfo, true);
            }
        } else {
            this.updateCacheIsGroup(cacheInfo, this.container.isGroupFromContainer(normalPathKey));
            this.updateCacheIsDataset(cacheInfo, this.container.isDatasetFromContainer(normalPathKey));
        }
        this.updateCache(normalPathKey, cacheInfo);
    }

    public N5JsonCache.N5CacheInfo forceAddNewCacheInfo(String normalPathKey, String normalCacheKey, JsonElement uncachedAttributes, boolean isGroup, boolean isDataset) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null || cacheInfo == emptyCacheInfo) {
            cacheInfo = this.newCacheInfo();
        }
        this.updateCacheAttributes(cacheInfo, ".zgroup", null);
        this.updateCacheAttributes(cacheInfo, ".zarray", null);
        this.updateCacheAttributes(cacheInfo, ".zattrs", null);
        if (normalCacheKey != null) {
            this.updateCacheAttributes(cacheInfo, normalCacheKey, uncachedAttributes);
        }
        this.updateCacheIsGroup(cacheInfo, isGroup);
        this.updateCacheIsDataset(cacheInfo, isDataset);
        this.updateCache(normalPathKey, cacheInfo);
        return cacheInfo;
    }

    @Override
    public boolean isDataset(String normalPathKey, String normalCacheKey) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.addNewCacheInfo(normalPathKey, normalCacheKey, null);
            cacheInfo = this.getCacheInfo(normalPathKey);
        } else {
            if (cacheInfo == emptyCacheInfo || cacheInfo.isGroup()) {
                return cacheInfo.isDataset();
            }
            if (!cacheInfo.containsKey(".zarray")) {
                this.updateCacheIsDataset(cacheInfo, this.container.isDatasetFromContainer(normalPathKey));
            }
        }
        return cacheInfo.isDataset();
    }

    @Override
    public boolean isGroup(String normalPathKey, String normalCacheKey) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.addNewCacheInfo(normalPathKey, normalCacheKey, null);
            cacheInfo = this.getCacheInfo(normalPathKey);
        } else {
            if (cacheInfo == emptyCacheInfo || cacheInfo.isDataset()) {
                return cacheInfo.isGroup();
            }
            if (!cacheInfo.containsKey(".zgroup")) {
                this.updateCacheIsGroup(cacheInfo, this.container.isGroupFromContainer(normalPathKey));
            }
        }
        return cacheInfo.isGroup();
    }
}

