/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.janelia.saalfeldlab.n5.StringDataBlock;

public class ZarrStringDataBlock
extends StringDataBlock {
    public ZarrStringDataBlock(int[] size, long[] gridPosition, String[] data) {
        super(size, gridPosition, data);
    }

    public ZarrStringDataBlock(int[] size, long[] gridPosition, byte[] data) {
        super(size, gridPosition, data);
    }

    @Override
    public void readData(ByteBuffer buffer) {
        try {
            this.serializedData = buffer.array();
        }
        catch (UnsupportedOperationException e) {
            this.serializedData = new byte[buffer.limit()];
            buffer.get(this.serializedData, 0, this.serializedData.length);
        }
        this.actualData = this.deserialize(this.serializedData);
    }

    @Override
    protected byte[] serialize(String[] strings) {
        int N = strings.length;
        byte[][] encodedStrings = (byte[][])Arrays.stream(strings).map(str -> str.getBytes(ENCODING)).toArray(x$0 -> new byte[x$0][]);
        int[] lengths = Arrays.stream(encodedStrings).mapToInt(arr -> ((byte[])arr).length).toArray();
        int totalLength = Arrays.stream(lengths).sum();
        ByteBuffer buf = ByteBuffer.wrap(new byte[totalLength + 4 * N + 4]);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(N);
        for (int i = 0; i < N; ++i) {
            buf.putInt(lengths[i]);
            buf.put(encodedStrings[i]);
        }
        return buf.array();
    }

    @Override
    protected String[] deserialize(byte[] rawBytes) {
        ByteBuffer buf = ByteBuffer.wrap(rawBytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        if (rawBytes.length < 4) {
            throw new RuntimeException("Corrupt buffer, data seems truncated.");
        }
        int n = buf.getInt();
        if (rawBytes.length < n) {
            throw new RuntimeException("Corrupt buffer, data seems truncated.");
        }
        String[] strings = new String[n];
        for (int i = 0; i < n; ++i) {
            int length = buf.getInt();
            byte[] encodedString = new byte[length];
            buf.get(encodedString);
            strings[i] = new String(encodedString, ENCODING);
        }
        return strings;
    }
}

