/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.compress.utils.IOUtils;
import org.janelia.saalfeldlab.n5.BlockReader;
import org.janelia.saalfeldlab.n5.ByteArrayDataBlock;
import org.janelia.saalfeldlab.n5.CachedGsonKeyValueN5Reader;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.CompressionAdapter;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.DefaultBlockReader;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.blosc.BloscCompression;
import org.janelia.saalfeldlab.n5.cache.N5JsonCacheableContainer;
import org.janelia.saalfeldlab.n5.zarr.DType;
import org.janelia.saalfeldlab.n5.zarr.Filter;
import org.janelia.saalfeldlab.n5.zarr.ZArrayAttributes;
import org.janelia.saalfeldlab.n5.zarr.ZarrCompressor;
import org.janelia.saalfeldlab.n5.zarr.ZarrDatasetAttributes;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueWriter;
import org.janelia.saalfeldlab.n5.zarr.ZarrStringDataBlock;
import org.janelia.saalfeldlab.n5.zarr.cache.ZarrJsonCache;

public class ZarrKeyValueReader
implements CachedGsonKeyValueN5Reader,
N5JsonCacheableContainer {
    public static final N5Reader.Version VERSION_ZERO = new N5Reader.Version(0, 0, 0);
    public static final N5Reader.Version VERSION = new N5Reader.Version(2, 0, 0);
    public static final String ZARR_FORMAT_KEY = "zarr_format";
    public static final String ZARRAY_FILE = ".zarray";
    public static final String ZATTRS_FILE = ".zattrs";
    public static final String ZGROUP_FILE = ".zgroup";
    protected final KeyValueAccess keyValueAccess;
    protected final Gson gson;
    protected final ZarrJsonCache cache;
    protected final boolean cacheMeta;
    protected URI uri;
    protected final boolean mapN5DatasetAttributes;
    protected final boolean mergeAttributes;

    public ZarrKeyValueReader(boolean checkVersion, KeyValueAccess keyValueAccess, String basePath, GsonBuilder gsonBuilder, boolean mapN5DatasetAttributes, boolean mergeAttributes, boolean cacheMeta) throws N5Exception {
        this(checkVersion, keyValueAccess, basePath, gsonBuilder, mapN5DatasetAttributes, mergeAttributes, cacheMeta, true);
    }

    protected ZarrKeyValueReader(boolean checkVersion, KeyValueAccess keyValueAccess, String basePath, GsonBuilder gsonBuilder, boolean mapN5DatasetAttributes, boolean mergeAttributes, boolean cacheMeta, boolean checkRootExists) {
        this.keyValueAccess = keyValueAccess;
        this.gson = ZarrKeyValueReader.registerGson(gsonBuilder);
        this.cacheMeta = cacheMeta;
        this.mapN5DatasetAttributes = mapN5DatasetAttributes;
        this.mergeAttributes = mergeAttributes;
        try {
            this.uri = keyValueAccess.uri(basePath);
        }
        catch (URISyntaxException e) {
            throw new N5Exception(e);
        }
        this.cache = cacheMeta ? this.newCache() : null;
        if (checkRootExists && !this.exists("/")) {
            throw new N5Exception.N5IOException("No container exists at " + basePath);
        }
    }

    public ZarrKeyValueReader(KeyValueAccess keyValueAccess, String basePath, GsonBuilder gsonBuilder, boolean mapN5DatasetAttributes, boolean mergeAttributes, boolean cacheMeta) throws N5Exception {
        this(true, keyValueAccess, basePath, gsonBuilder, mapN5DatasetAttributes, mergeAttributes, cacheMeta);
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public ZarrJsonCache newCache() {
        return new ZarrJsonCache(this);
    }

    @Override
    public boolean cacheMeta() {
        return this.cacheMeta;
    }

    @Override
    public ZarrJsonCache getCache() {
        return this.cache;
    }

    @Override
    public KeyValueAccess getKeyValueAccess() {
        return this.keyValueAccess;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public N5Reader.Version getVersion() throws N5Exception {
        if (this.datasetExists("")) {
            return ZarrKeyValueReader.getVersion(this.getZArray(""));
        }
        if (this.groupExists("")) {
            return ZarrKeyValueReader.getVersion(this.getZGroup(""));
        }
        return VERSION;
    }

    @Override
    public boolean exists(String pathName) {
        String normalPathName = N5URI.normalizeGroupPath(pathName);
        return this.groupExists(normalPathName) || this.datasetExists(normalPathName);
    }

    public boolean existsFromContainer(String normalPathName) {
        return this.keyValueAccess.exists(this.keyValueAccess.compose(this.uri, normalPathName, ZGROUP_FILE)) || this.keyValueAccess.exists(this.keyValueAccess.compose(this.uri, normalPathName, ZARRAY_FILE));
    }

    @Override
    public boolean groupExists(String pathName) {
        String normalPath = N5URI.normalizeGroupPath(pathName);
        if (this.cacheMeta()) {
            return this.cache.isGroup(normalPath, ZGROUP_FILE);
        }
        return this.isGroupFromContainer(normalPath);
    }

    @Override
    public boolean isGroupFromContainer(String normalPath) {
        return this.keyValueAccess.isFile(this.keyValueAccess.compose(this.uri, normalPath, ZGROUP_FILE));
    }

    @Override
    public boolean isGroupFromAttributes(String normalCacheKey, JsonElement attributes) {
        return attributes != null && attributes.isJsonObject() && attributes.getAsJsonObject().has(ZARR_FORMAT_KEY);
    }

    @Override
    public boolean datasetExists(String pathName) throws N5Exception.N5IOException {
        if (this.cacheMeta()) {
            String normalPathName = N5URI.normalizeGroupPath(pathName);
            return this.cache.isDataset(normalPathName, ZARRAY_FILE);
        }
        return this.isDatasetFromContainer(pathName);
    }

    @Override
    public boolean isDatasetFromContainer(String normalPathName) throws N5Exception {
        if (this.keyValueAccess.isFile(this.keyValueAccess.compose(this.uri, normalPathName, ZARRAY_FILE))) {
            return this.isDatasetFromAttributes(ZARRAY_FILE, this.getAttributesFromContainer(normalPathName, ZARRAY_FILE));
        }
        return false;
    }

    @Override
    public boolean isDatasetFromAttributes(String normalCacheKey, JsonElement attributes) {
        if (normalCacheKey.equals(ZARRAY_FILE) && attributes != null && attributes.isJsonObject()) {
            return this.createDatasetAttributes(attributes) != null;
        }
        return false;
    }

    @Override
    public ZarrDatasetAttributes getDatasetAttributes(String pathName) throws N5Exception {
        return this.createDatasetAttributes(this.getZArray(pathName));
    }

    public ZArrayAttributes getZArrayAttributes(String pathName) throws N5Exception {
        return this.getZArrayAttributes(this.getZArray(pathName));
    }

    protected ZArrayAttributes getZArrayAttributes(JsonElement attributes) {
        return this.gson.fromJson(attributes, ZArrayAttributes.class);
    }

    @Override
    public ZarrDatasetAttributes createDatasetAttributes(JsonElement attributes) {
        ZArrayAttributes zarray = this.getZArrayAttributes(attributes);
        return zarray != null ? zarray.getDatasetAttributes() : null;
    }

    @Override
    public <T> T getAttribute(String pathName, String key, Class<T> clazz) throws N5Exception {
        String normalizedAttributePath = N5URI.normalizeAttributePath(key);
        JsonElement attributes = this.getAttributes(pathName);
        try {
            return GsonUtils.readAttribute(attributes, normalizedAttributePath, clazz, this.gson);
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            throw new N5Exception.N5ClassCastException(e);
        }
    }

    @Override
    public <T> T getAttribute(String pathName, String key, Type type) throws N5Exception {
        String normalizedAttributePath = N5URI.normalizeAttributePath(key);
        JsonElement attributes = this.getAttributes(pathName);
        try {
            return GsonUtils.readAttribute(attributes, normalizedAttributePath, type, this.gson);
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            throw new N5Exception.N5ClassCastException(e);
        }
    }

    protected JsonElement getJsonResource(String normalPath, String jsonName) throws N5Exception {
        if (this.cacheMeta()) {
            return this.cache.getAttributes(normalPath, jsonName);
        }
        return this.getAttributesFromContainer(normalPath, jsonName);
    }

    protected static JsonElement reverseAttrsWhenCOrder(JsonElement elem) {
        if (elem == null || !elem.isJsonObject()) {
            return elem;
        }
        JsonObject attrs = elem.getAsJsonObject();
        if (attrs.get("order").getAsString().equals("C")) {
            JsonArray shape = attrs.get("shape").getAsJsonArray();
            ZarrKeyValueWriter.reorder(shape);
            attrs.add("shape", shape);
            JsonArray chunkSize = attrs.get("chunks").getAsJsonArray();
            ZarrKeyValueWriter.reorder(chunkSize);
            attrs.add("chunks", chunkSize);
        }
        return attrs;
    }

    protected JsonElement getZGroup(String path) throws N5Exception {
        return this.getJsonResource(N5URI.normalizeGroupPath(path), ZGROUP_FILE);
    }

    protected JsonElement getZArray(String path) throws N5Exception {
        return this.getJsonResource(N5URI.normalizeGroupPath(path), ZARRAY_FILE);
    }

    protected JsonElement zarrToN5DatasetAttributes(JsonElement elem) {
        if (!this.mapN5DatasetAttributes || elem == null || !elem.isJsonObject()) {
            return elem;
        }
        JsonObject attrs = elem.getAsJsonObject();
        ZArrayAttributes zattrs = this.getZArrayAttributes(attrs);
        if (zattrs == null) {
            return elem;
        }
        attrs.add("dimensions", attrs.get("shape"));
        attrs.add("blockSize", attrs.get("chunks"));
        attrs.addProperty("dataType", zattrs.getDType().getDataType().toString());
        JsonElement e = attrs.get("compressor");
        if (e == JsonNull.INSTANCE) {
            attrs.add("compression", this.gson.toJsonTree(new RawCompression()));
        } else {
            attrs.add("compression", this.gson.toJsonTree(this.gson.fromJson(attrs.get("compressor"), ZarrCompressor.class).getCompression()));
        }
        return attrs;
    }

    protected JsonElement n5ToZarrDatasetAttributes(JsonElement elem) {
        if (!this.mapN5DatasetAttributes || elem == null || !elem.isJsonObject()) {
            return elem;
        }
        JsonObject attrs = elem.getAsJsonObject();
        if (attrs.has("dimensions")) {
            attrs.add("shape", attrs.get("dimensions"));
        }
        if (attrs.has("blockSize")) {
            attrs.add("chunks", attrs.get("blockSize"));
        }
        if (attrs.has("dataType")) {
            attrs.add("dtype", attrs.get("dataType"));
        }
        return attrs;
    }

    public JsonElement getZAttributes(String path) throws N5Exception {
        return this.getJsonResource(N5URI.normalizeGroupPath(path), ZATTRS_FILE);
    }

    @Override
    public JsonElement getAttributes(String path) throws N5Exception {
        JsonElement out = this.mergeAttributes ? ZarrKeyValueReader.combineAll(this.getJsonResource(N5URI.normalizeGroupPath(path), ZGROUP_FILE), this.zarrToN5DatasetAttributes(ZarrKeyValueReader.reverseAttrsWhenCOrder(this.getJsonResource(N5URI.normalizeGroupPath(path), ZARRAY_FILE))), this.getJsonResource(N5URI.normalizeGroupPath(path), ZATTRS_FILE)) : this.getZAttributes(path);
        return out;
    }

    protected JsonElement getAttributesUnmapped(String path) throws N5Exception {
        JsonElement out = this.mergeAttributes ? ZarrKeyValueReader.combineAll(this.getJsonResource(N5URI.normalizeGroupPath(path), ZGROUP_FILE), ZarrKeyValueReader.reverseAttrsWhenCOrder(this.getJsonResource(N5URI.normalizeGroupPath(path), ZARRAY_FILE)), this.getJsonResource(N5URI.normalizeGroupPath(path), ZATTRS_FILE)) : this.getZAttributes(path);
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonElement getAttributesFromContainer(String normalResourceParent, String normalResourcePath) throws N5Exception {
        String absolutePath = this.keyValueAccess.compose(this.uri, normalResourceParent, normalResourcePath);
        if (!this.keyValueAccess.isFile(absolutePath)) {
            return null;
        }
        try (LockedChannel lockedChannel = this.keyValueAccess.lockForReading(absolutePath);){
            JsonElement jsonElement = GsonUtils.readAttributes(lockedChannel.newReader(), this.gson);
            return jsonElement;
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to read " + absolutePath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataBlock<?> readBlock(String pathName, DatasetAttributes datasetAttributes, long ... gridPosition) throws N5Exception {
        ZarrDatasetAttributes zarrDatasetAttributes = datasetAttributes instanceof ZarrDatasetAttributes ? (ZarrDatasetAttributes)datasetAttributes : this.getDatasetAttributes(pathName);
        String absolutePath = this.keyValueAccess.compose(this.uri, pathName, ZarrKeyValueReader.getZarrDataBlockPath(gridPosition, zarrDatasetAttributes.getDimensionSeparator(), zarrDatasetAttributes.isRowMajor()));
        if (!this.keyValueAccess.isFile(absolutePath)) {
            return null;
        }
        try (LockedChannel lockedChannel = this.keyValueAccess.lockForReading(absolutePath);){
            DataBlock<?> dataBlock = ZarrKeyValueReader.readBlock(lockedChannel.newInputStream(), zarrDatasetAttributes, gridPosition);
            return dataBlock;
        }
        catch (Throwable e) {
            throw new N5Exception.N5IOException("Failed to read block " + Arrays.toString(gridPosition) + " from dataset " + pathName, e);
        }
    }

    protected static DataBlock<?> readBlock(InputStream in, ZarrDatasetAttributes datasetAttributes, long ... gridPosition) throws IOException {
        int[] blockSize = datasetAttributes.getBlockSize();
        DType dType = datasetAttributes.getDType();
        ByteArrayDataBlock byteBlock = dType.createByteBlock(blockSize, gridPosition);
        BlockReader reader = datasetAttributes.getCompression().getReader();
        if (dType.getDataType() == DataType.STRING) {
            return ZarrKeyValueReader.readVLenStringBlock(in, reader, byteBlock);
        }
        reader.read(byteBlock, in);
        switch (dType.getDataType()) {
            case UINT8: 
            case INT8: {
                return byteBlock;
            }
        }
        DataBlock<?> dataBlock = dType.createDataBlock(blockSize, gridPosition);
        ByteBuffer byteBuffer = byteBlock.toByteBuffer();
        byteBuffer.order(dType.getOrder());
        dataBlock.readData(byteBuffer);
        return dataBlock;
    }

    private static ZarrStringDataBlock readVLenStringBlock(InputStream in, BlockReader reader, ByteArrayDataBlock byteBlock) throws IOException {
        ZarrStringDataBlock dataBlock = new ZarrStringDataBlock(byteBlock.getSize(), byteBlock.getGridPosition(), new String[0]);
        if (reader instanceof BloscCompression) {
            reader.read(dataBlock, in);
        } else if (reader instanceof DefaultBlockReader) {
            try (InputStream inflater = ((DefaultBlockReader)reader).getInputStream(in);){
                DataInputStream dis = new DataInputStream(inflater);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)dis, (OutputStream)out);
                dataBlock.readData(ByteBuffer.wrap(out.toByteArray()));
            }
        } else {
            throw new UnsupportedOperationException("Only Blosc compression or algorithms that use DefaultBlockReader are supported.");
        }
        return dataBlock;
    }

    protected static String getZarrDataBlockPath(long[] gridPosition, String dimensionSeparator, boolean isRowMajor) {
        StringBuilder pathStringBuilder = new StringBuilder();
        if (isRowMajor) {
            pathStringBuilder.append(gridPosition[gridPosition.length - 1]);
            for (int i = gridPosition.length - 2; i >= 0; --i) {
                pathStringBuilder.append(dimensionSeparator);
                pathStringBuilder.append(gridPosition[i]);
            }
        } else {
            pathStringBuilder.append(gridPosition[0]);
            for (int i = 1; i < gridPosition.length; ++i) {
                pathStringBuilder.append(dimensionSeparator);
                pathStringBuilder.append(gridPosition[i]);
            }
        }
        return pathStringBuilder.toString();
    }

    public String toString() {
        return String.format("%s[access=%s, basePath=%s]", this.getClass().getSimpleName(), this.keyValueAccess, this.uri.getPath());
    }

    protected static N5Reader.Version getVersion(JsonElement json) {
        if (json == null || !json.isJsonObject()) {
            return VERSION_ZERO;
        }
        JsonElement fmt = json.getAsJsonObject().get(ZARR_FORMAT_KEY);
        if (fmt.isJsonPrimitive()) {
            return new N5Reader.Version(fmt.getAsInt(), 0, 0);
        }
        return null;
    }

    protected static JsonElement combineAll(JsonElement ... elements) {
        return Arrays.stream(elements).reduce(null, ZarrKeyValueReader::combine);
    }

    protected static JsonElement combine(JsonElement base, JsonElement add) {
        if (base == null) {
            return add == null ? null : add.deepCopy();
        }
        if (add == null) {
            return base == null ? null : base.deepCopy();
        }
        if (base.isJsonObject() && add.isJsonObject()) {
            JsonObject baseObj = base.getAsJsonObject().deepCopy();
            JsonObject addObj = add.getAsJsonObject();
            for (String k : addObj.keySet()) {
                baseObj.add(k, addObj.get(k));
            }
            return baseObj;
        }
        if (base.isJsonArray() && add.isJsonArray()) {
            JsonArray baseArr = base.getAsJsonArray().deepCopy();
            JsonArray addArr = add.getAsJsonArray();
            for (int i = 0; i < addArr.size(); ++i) {
                baseArr.add(addArr.get(i));
            }
            return baseArr;
        }
        return base == null ? null : base.deepCopy();
    }

    static Gson registerGson(GsonBuilder gsonBuilder) {
        return ZarrKeyValueReader.addTypeAdapters(gsonBuilder).create();
    }

    protected static GsonBuilder addTypeAdapters(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter((Type)((Object)DataType.class), new DataType.JsonAdapter());
        gsonBuilder.registerTypeAdapter((Type)((Object)ZarrCompressor.class), ZarrCompressor.jsonAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)ZarrCompressor.Raw.class), ZarrCompressor.rawNullAdapter);
        gsonBuilder.registerTypeHierarchyAdapter(Compression.class, CompressionAdapter.getJsonAdapter());
        gsonBuilder.registerTypeAdapter((Type)((Object)Compression.class), CompressionAdapter.getJsonAdapter());
        gsonBuilder.registerTypeAdapter((Type)((Object)ZArrayAttributes.class), ZArrayAttributes.jsonAdapter);
        gsonBuilder.registerTypeHierarchyAdapter(Filter.class, Filter.jsonAdapter);
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.serializeNulls();
        return gsonBuilder;
    }
}

