/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.zarr.DType;
import org.janelia.saalfeldlab.n5.zarr.Filter;
import org.janelia.saalfeldlab.n5.zarr.ZarrCompressor;
import org.janelia.saalfeldlab.n5.zarr.ZarrDatasetAttributes;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueWriter;

public class ZArrayAttributes {
    public static final String zarrFormatKey = "zarr_format";
    public static final String shapeKey = "shape";
    public static final String chunksKey = "chunks";
    public static final String dTypeKey = "dtype";
    public static final String compressorKey = "compressor";
    public static final String fillValueKey = "fill_value";
    public static final String orderKey = "order";
    public static final String filtersKey = "filters";
    public static final String dimensionSeparatorKey = "dimension_separator";
    public static final String[] requiredKeys = new String[]{"zarr_format", "shape", "chunks", "dtype", "compressor", "fill_value", "filters"};
    public static final String[] allKeys = new String[]{"zarr_format", "shape", "chunks", "dtype", "compressor", "fill_value", "filters", "order", "dimension_separator"};
    private final int zarr_format;
    private final long[] shape;
    private final int[] chunks;
    private final DType dtype;
    private final ZarrCompressor compressor;
    private final JsonElement fill_value;
    private final char order;
    private final String dimensionSeparator;
    private final List<Filter> filters = new ArrayList<Filter>();
    public static JsonAdapter jsonAdapter = new JsonAdapter();

    public ZArrayAttributes(int zarr_format, long[] shape, int[] chunks, DType dtype, ZarrCompressor compressor, String fill_value, char order, String dimensionSeparator, Collection<Filter> filters) {
        this.zarr_format = zarr_format;
        this.shape = shape;
        this.chunks = chunks;
        this.dtype = dtype;
        this.compressor = compressor == null ? new ZarrCompressor.Raw() : compressor;
        this.fill_value = ZArrayAttributes.parseFillValue(fill_value, dtype.getDataType());
        this.order = order;
        this.dimensionSeparator = dimensionSeparator;
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    public ZArrayAttributes(int zarr_format, long[] shape, int[] chunks, DType dtype, ZarrCompressor compressor, String fill_value, char order, Collection<Filter> filters) {
        this(zarr_format, shape, chunks, dtype, compressor, fill_value, order, "", filters);
    }

    public ZarrDatasetAttributes getDatasetAttributes() {
        boolean isRowMajor = this.order == 'C';
        long[] dimensions = (long[])this.shape.clone();
        int[] blockSize = (int[])this.chunks.clone();
        if (isRowMajor) {
            ZarrKeyValueWriter.reorder(dimensions);
            ZarrKeyValueWriter.reorder(blockSize);
        }
        return new ZarrDatasetAttributes(dimensions, blockSize, this.dtype, this.compressor.getCompression(), isRowMajor, this.fill_value.getAsString(), this.dimensionSeparator);
    }

    private static JsonElement parseFillValue(String fillValue, DataType dtype) {
        if (fillValue == null || fillValue.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        try {
            return new JsonPrimitive(Long.parseLong(fillValue));
        }
        catch (NumberFormatException numberFormatException) {
            return new JsonPrimitive(Double.parseDouble(fillValue));
        }
    }

    public long[] getShape() {
        return this.shape;
    }

    public int getNumDimensions() {
        return this.shape.length;
    }

    public int[] getChunks() {
        return this.chunks;
    }

    public ZarrCompressor getCompressor() {
        return this.compressor;
    }

    public DType getDType() {
        return this.dtype;
    }

    public int getZarrFormat() {
        return this.zarr_format;
    }

    public char getOrder() {
        return this.order;
    }

    public String getDimensionSeparator() {
        return this.dimensionSeparator;
    }

    public String getFillValue() {
        return this.fill_value.getAsString();
    }

    public HashMap<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(zarrFormatKey, this.zarr_format);
        map.put(shapeKey, this.shape);
        map.put(chunksKey, this.chunks);
        map.put(dTypeKey, this.dtype.toString());
        map.put(fillValueKey, this.fill_value);
        map.put(orderKey, Character.valueOf(this.order));
        map.put(filtersKey, this.filters);
        map.put(dimensionSeparatorKey, this.dimensionSeparator);
        map.put(compressorKey, this.compressor instanceof RawCompression ? JsonNull.INSTANCE : this.compressor);
        return map;
    }

    public Collection<Filter> getFilters() {
        return this.filters;
    }

    public static class JsonAdapter
    implements JsonDeserializer<ZArrayAttributes> {
        @Override
        public ZArrayAttributes deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonElement sepElem = obj.get(ZArrayAttributes.dimensionSeparatorKey);
            try {
                Collection filters = (Collection)context.deserialize(obj.get(ZArrayAttributes.filtersKey), TypeToken.getParameterized(Collection.class, new Type[]{Filter.class}).getType());
                String typestr = (String)context.deserialize(obj.get(ZArrayAttributes.dTypeKey), (Type)((Object)String.class));
                DType dType = new DType(typestr, filters);
                return new ZArrayAttributes(obj.get(ZArrayAttributes.zarrFormatKey).getAsInt(), (long[])context.deserialize(obj.get(ZArrayAttributes.shapeKey), (Type)((Object)long[].class)), (int[])context.deserialize(obj.get(ZArrayAttributes.chunksKey), (Type)((Object)int[].class)), dType, (ZarrCompressor)context.deserialize(obj.get(ZArrayAttributes.compressorKey), (Type)((Object)ZarrCompressor.class)), obj.get(ZArrayAttributes.fillValueKey).getAsString(), obj.get(ZArrayAttributes.orderKey).getAsCharacter(), sepElem != null ? sepElem.getAsString() : ".", filters);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

