/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr;

import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import org.janelia.saalfeldlab.n5.FileSystemKeyValueAccess;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.zarr.ZarrCompressor;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueReader;

public class N5ZarrReader
extends ZarrKeyValueReader {
    protected static N5Reader.Version VERSION = new N5Reader.Version(2, 0, 0);

    public N5ZarrReader(String basePath, GsonBuilder gsonBuilder, boolean mapN5DatasetAttributes, boolean mergeAttributes, boolean cacheMeta) throws N5Exception {
        super(new FileSystemKeyValueAccess(FileSystems.getDefault()), basePath, gsonBuilder.registerTypeAdapter((Type)((Object)ZarrCompressor.class), ZarrCompressor.jsonAdapter), mapN5DatasetAttributes, mergeAttributes, cacheMeta);
        if (!this.exists("/")) {
            throw new N5Exception.N5IOException("No container exists at " + basePath);
        }
    }

    public N5ZarrReader(String basePath, GsonBuilder gsonBuilder, boolean cacheMeta) throws N5Exception {
        this(basePath, gsonBuilder, true, true, cacheMeta);
    }

    public N5ZarrReader(String basePath, boolean cacheMeta) throws N5Exception {
        this(basePath, new GsonBuilder(), cacheMeta);
    }

    public N5ZarrReader(String basePath, GsonBuilder gsonBuilder) throws N5Exception {
        this(basePath, gsonBuilder, false);
    }

    public N5ZarrReader(String basePath) throws N5Exception {
        this(basePath, new GsonBuilder(), false);
    }
}

