/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public interface Filter {
    public static final Filter VLEN_UTF8 = new VLenStringFilter();
    public static final JsonAdapter jsonAdapter = new JsonAdapter();

    public String getId();

    public static Filter fromString(String id) {
        if (VLEN_UTF8.getId().equals(id)) {
            return VLEN_UTF8;
        }
        return null;
    }

    public static class JsonAdapter
    implements JsonDeserializer<Filter>,
    JsonSerializer<Filter> {
        @Override
        public Filter deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement jsonId = json.getAsJsonObject().get("id");
            if (jsonId == null) {
                return null;
            }
            String stringId = jsonId.getAsString();
            return Filter.fromString(stringId);
        }

        @Override
        public JsonElement serialize(Filter filter, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject serialization = new JsonObject();
            serialization.add("id", new JsonPrimitive(filter.getId()));
            return serialization;
        }
    }

    public static class VLenStringFilter
    implements Filter {
        private static final String id = "vlen-utf8";

        @Override
        public String getId() {
            return id;
        }
    }
}

