/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.scijava.Context;
import sc.fiji.labkit.pixel_classification.gui.AccordionSection;
import sc.fiji.labkit.pixel_classification.gui.FeatureInfo;
import sc.fiji.labkit.pixel_classification.gui.NonParametrizedRow;
import sc.fiji.labkit.pixel_classification.gui.ParametrizedRow;
import sc.fiji.labkit.pixel_classification.gui.SelectableRow;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSetting;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSettings;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

public class FiltersListSection
extends AccordionSection {
    private List<FeatureInfo> featureInfos;
    private final JPanel titlePanel;
    private final JPanel expandablePanel;

    public FiltersListSection(String title, Context context, FeatureSettings featureSettings, List<FeatureInfo> featureInfos, boolean isExpanded) {
        super(isExpanded);
        this.featureInfos = featureInfos;
        this.setLayout(new BoxLayout(this, 1));
        this.titlePanel = this.createTitlePanel(title);
        this.add((Component)this.titlePanel, "North");
        this.expandablePanel = this.createExpandablePanel(context, featureSettings);
        this.add((Component)this.expandablePanel, "Center");
    }

    private JPanel createTitlePanel(String title) {
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add((Component)this.getIconButton(), "West");
        titlePanel.add(this.createTitleComponent(title));
        return titlePanel;
    }

    private JLabel createTitleComponent(String title) {
        JLabel titleComponent = new JLabel(title);
        Font f = titleComponent.getFont();
        titleComponent.setFont(f.deriveFont(f.getStyle() | 1));
        titleComponent.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(2, 8, 2, 2), titleComponent.getBorder()));
        return titleComponent;
    }

    private JPanel createExpandablePanel(Context context, FeatureSettings featureSettings) {
        JPanel expandablePanel = new JPanel();
        expandablePanel.setLayout(new BoxLayout(expandablePanel, 1));
        for (FeatureInfo featureInfo : this.featureInfos) {
            JPanel row = featureInfo.hasParameters() ? new ParametrizedRow(context, featureInfo, featureSettings) : new NonParametrizedRow(featureInfo, featureSettings);
            expandablePanel.add(row);
        }
        return expandablePanel;
    }

    @Override
    protected int preferredCollapsedHeight() {
        return this.titlePanel.getPreferredSize().height;
    }

    @Override
    protected int preferredExpandedHeight() {
        return this.titlePanel.getPreferredSize().height + this.expandablePanel.getPreferredSize().height;
    }

    public List<FeatureSetting> getSelectedFeatureSettings() {
        Component[] children;
        ArrayList<FeatureSetting> selected = new ArrayList<FeatureSetting>();
        for (Component child : children = this.expandablePanel.getComponents()) {
            if (!(child instanceof SelectableRow)) continue;
            selected.addAll(((SelectableRow)((Object)child)).getSelectedFeatureSettings());
        }
        return selected;
    }

    public void setGlobalSettings(GlobalSettings globalSettings) {
        Component[] children;
        for (Component child : children = this.expandablePanel.getComponents()) {
            if (!(child instanceof SelectableRow)) continue;
            ((SelectableRow)((Object)child)).setGlobalSettings(globalSettings);
        }
    }
}

