/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.translation;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataNode;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadataParser;
import org.janelia.saalfeldlab.n5.universe.translation.ContainerTranslation;
import org.janelia.saalfeldlab.n5.universe.translation.JqContainerTranslation;
import org.janelia.saalfeldlab.n5.universe.translation.JqUtils;

public class TranslatedTreeMetadataParser
extends CanonicalMetadataParser {
    private ContainerMetadataNode translatedRoot;
    private ContainerTranslation translationFun;

    public TranslatedTreeMetadataParser(String translation) {
        this(translation, x -> true);
    }

    public TranslatedTreeMetadataParser(String translation, Predicate<CanonicalMetadata> filter) {
        super(filter);
        this.translationFun = new JqContainerTranslation(translation, JqUtils.buildGson(null));
    }

    public boolean validTranslation() {
        return this.translationFun != null;
    }

    public TranslatedTreeMetadataParser(N5Reader n5, String n5Tree, String translation) {
        super(null);
        this.translationFun = new JqContainerTranslation(translation, JqUtils.buildGson(n5));
    }

    @Override
    protected void setup(N5Reader n5) {
        this.setGson(JqUtils.buildGson(n5));
        this.root = ContainerMetadataNode.build(n5, this.gson);
        this.translatedRoot = (ContainerMetadataNode)this.translationFun.apply(this.root);
        if (this.translatedRoot != null) {
            this.translatedRoot.addPathsRecursive();
        }
    }

    @Override
    public Optional<CanonicalMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
        this.setup(n5);
        return this.parseMetadata(node, n5.getGroupSeparator());
    }

    @Override
    public Optional<CanonicalMetadata> parseMetadata(N5Reader n5, String dataset) {
        return this.parseMetadata(n5, new N5TreeNode(dataset));
    }

    @Override
    public Optional<CanonicalMetadata> parseMetadata(String dataset, String groupSep) {
        return this.parseMetadata(new N5TreeNode(dataset), groupSep);
    }

    @Override
    public Optional<CanonicalMetadata> parseMetadata(N5TreeNode node, String groupSep) {
        if (this.translatedRoot == null) {
            return Optional.empty();
        }
        return this.translatedRoot.getChild(node.getPath(), groupSep).map(ContainerMetadataNode::getContainerAttributes).map(this::canonicalMetadata).filter(this.filter);
    }

    @Override
    public CanonicalMetadata canonicalMetadata(HashMap<String, JsonElement> attrMap) {
        return this.gson.fromJson(this.gson.toJson(attrMap), CanonicalMetadata.class);
    }
}

