/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.translation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.janelia.saalfeldlab.n5.universe.translation.JqUtils;

public class JqPredicate<S>
implements Predicate<S> {
    private final Scope scope;
    private final ObjectMapper objMapper;
    private final Gson gson;
    private final JsonQuery query;

    public JqPredicate(String translation, Gson gson) {
        this.gson = gson;
        this.scope = JqUtils.buildRootScope();
        this.objMapper = new ObjectMapper();
        JsonQuery qTmp = null;
        try {
            qTmp = JsonQuery.compile((String)JqUtils.resolveImports(translation), (Version)Versions.JQ_1_6);
        }
        catch (JsonQueryException e) {
            e.printStackTrace();
        }
        this.query = qTmp;
    }

    @Override
    public boolean test(S src) {
        if (this.query == null) {
            return false;
        }
        try {
            JsonNode jsonNode = this.objMapper.readTree(this.gson.toJson(src));
            ArrayList out = new ArrayList();
            this.query.apply(this.scope, jsonNode, out::add);
            StringBuffer stringOutput = new StringBuffer();
            for (JsonNode n : out) {
                stringOutput.append(n.toString() + "\n");
            }
            return this.gson.fromJson(stringOutput.toString(), Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

