/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.PositionFieldTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.RealComposite;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractParametrizedFieldTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;

public class CoordinateFieldCoordinateTransform<T extends RealType<T>>
extends AbstractParametrizedFieldTransform<PositionFieldTransform, T> {
    public static final transient String KEY = "coordinates";
    protected transient PositionFieldTransform transform;
    protected transient int positionAxisIndex = 0;
    protected static final transient String vectorAxisType = "coordinate";

    public CoordinateFieldCoordinateTransform(String name, RealRandomAccessible<RealComposite<T>> field, String interpolation, String input, String output) {
        super("coordinate_field", name, null, interpolation, input, output);
        this.buildTransform(field);
    }

    public CoordinateFieldCoordinateTransform(String name, N5Reader n5, String path, String interpolation, String input, String output) {
        super("coordinate_field", name, path, interpolation, input, output);
    }

    public CoordinateFieldCoordinateTransform(String name, String path, String interpolation, String input, String output) {
        super("coordinate_field", name, path, interpolation, input, output);
    }

    @Override
    public int getVectorAxisIndex() {
        return this.positionAxisIndex;
    }

    @Override
    public PositionFieldTransform buildTransform(RealRandomAccessible<RealComposite<T>> field) {
        return new PositionFieldTransform(field);
    }

    @Override
    public PositionFieldTransform getTransform() {
        if (this.field != null && this.transform == null) {
            this.buildTransform(this.field);
        }
        return this.transform;
    }

    @Override
    public int parseVectorAxisIndex(N5Reader n5) {
        try {
            CoordinateSystem[] spaces = n5.getAttribute(this.getParameterPath(), "coordinateSystems", CoordinateSystem[].class);
            CoordinateSystem space = spaces[0];
            for (int i = 0; i < space.numDimensions(); ++i) {
                if (!space.getAxisTypes()[i].equals(vectorAxisType)) continue;
                return i;
            }
        }
        catch (N5Exception n5Exception) {
            // empty catch block
        }
        return -1;
    }

    public static <T extends RealType<T> & NativeType<T>> CoordinateFieldCoordinateTransform writePositionFieldTransform(N5Writer n5, String dataset, RandomAccessibleInterval<T> posField, int[] blockSize, Compression compression, CoordinateSystem[] spaces, CoordinateTransform[] transforms) {
        try {
            N5Utils.save(posField, (N5Writer)n5, (String)dataset, (int[])blockSize, (Compression)compression);
            n5.setAttribute(dataset, "spaces", spaces);
            n5.setAttribute(dataset, "transformations", transforms);
        }
        catch (N5Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

