/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.TransformUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractLinearCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.InvertibleCoordinateTransform;

public class BaseLinearCoordinateTransform<T extends AffineGet>
extends AbstractLinearCoordinateTransform<T, double[]>
implements InvertibleCoordinateTransform<T> {
    protected JsonElement affine;
    public transient double[] affineFlat;
    public transient T transform;

    public BaseLinearCoordinateTransform(String type) {
        super(type);
    }

    public BaseLinearCoordinateTransform(String type, double[] affineFlat) {
        super(type);
        this.affineFlat = affineFlat;
        this.buildJsonParameter();
    }

    public BaseLinearCoordinateTransform(BaseLinearCoordinateTransform<T> other) {
        super(other.type, other.path);
        this.affine = other.affine;
        this.affineFlat = other.affineFlat;
        this.transform = other.transform;
        this.name = other.name;
        this.input = other.input;
        this.output = other.output;
        this.buildJsonParameter();
    }

    public BaseLinearCoordinateTransform(String type, String name, String inputSpace, String outputSpace) {
        super(type, name, null, inputSpace, outputSpace);
    }

    public BaseLinearCoordinateTransform(String type, String name, String inputSpace, String outputSpace, double[] affineFlat) {
        super(type, name, null, inputSpace, outputSpace);
        this.affineFlat = affineFlat;
        this.buildJsonParameter();
    }

    public BaseLinearCoordinateTransform(String type, String name, N5Reader n5, String path, String inputSpace, String outputSpace) {
        super(type, name, path, inputSpace, outputSpace);
    }

    public BaseLinearCoordinateTransform(String type, String name, String[] inputAxes, String[] outputAxes) {
        super(type, name, null, inputAxes, outputAxes);
    }

    public BaseLinearCoordinateTransform(String type, String name, String[] inputAxes, String[] outputAxes, double[] affineFlat) {
        super(type, name, null, inputAxes, outputAxes);
        this.affineFlat = affineFlat;
        this.buildJsonParameter();
    }

    public BaseLinearCoordinateTransform(String type, String name, String path, String inputSpace, String outputSpace) {
        super(type, name, path, inputSpace, outputSpace);
    }

    public JsonElement getJsonParameter() {
        return this.affine;
    }

    protected void buildJsonParameter() {
        if (this.affineFlat != null) {
            this.affine = new Gson().toJsonTree(this.affineFlat);
        }
    }

    public void interpretParameters() {
        if (!this.affine.isJsonArray()) {
            return;
        }
        JsonArray arr = this.affine.getAsJsonArray();
        JsonElement e0 = this.affine.getAsJsonArray().get(0);
        if (e0.isJsonPrimitive()) {
            this.affineFlat = new double[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                this.affineFlat[i] = arr.get(i).getAsDouble();
            }
        } else if (e0.isJsonArray()) {
            double[][] nested = null;
            for (int row = 0; row < arr.size(); ++row) {
                JsonArray jsonRowArray = arr.get(row).getAsJsonArray();
                if (row == 0) {
                    nested = new double[arr.size()][jsonRowArray.size()];
                }
                for (int col = 0; col < jsonRowArray.size(); ++col) {
                    nested[row][col] = jsonRowArray.get(col).getAsDouble();
                }
            }
            this.affineFlat = TransformUtils.flatten(nested);
        }
    }

    @Override
    public T buildTransform(double[] parameters) {
        if (parameters == null) {
            return null;
        }
        if (parameters.length == 6) {
            AffineTransform2D tmp = new AffineTransform2D();
            tmp.set(parameters);
            this.transform = tmp;
        } else if (parameters.length == 12) {
            AffineTransform3D tmp = new AffineTransform3D();
            tmp.set(parameters);
            this.transform = tmp;
        } else {
            int nd = (int)Math.floor(Math.sqrt(parameters.length));
            AffineTransform tmp = new AffineTransform(nd);
            tmp.set(parameters);
            this.transform = tmp;
        }
        return this.transform;
    }

    @Override
    public double[] getParameters(N5Reader n5) {
        if (n5 == null) {
            return null;
        }
        double[] paramsFlat = BaseLinearCoordinateTransform.getDoubleArray(n5, this.getParameterPath());
        if (paramsFlat != null) {
            return paramsFlat;
        }
        double[][] params2d = BaseLinearCoordinateTransform.getDoubleArray2(n5, this.getParameterPath());
        return TransformUtils.flattenColMajor(params2d);
    }

    @Override
    public T getTransform() {
        if (this.affine != null && this.transform == null) {
            this.buildTransform(this.affineFlat);
        }
        return this.transform;
    }

    @Override
    public T getTransform(N5Reader n5) {
        if (this.affineFlat != null) {
            return this.getTransform();
        }
        if (this.affine != null) {
            this.interpretParameters();
            if (this.affineFlat != null) {
                return this.getTransform();
            }
        }
        return this.buildTransform(this.getParameters(n5));
    }
}

