/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.Common;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractParametrizedTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.InvertibleCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ParametrizedTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.SequenceCoordinateTransform;

public abstract class AbstractParametrizedFieldTransform<T extends RealTransform, S extends RealType<S>>
extends AbstractParametrizedTransform<T, RealRandomAccessible<RealComposite<S>>> {
    public static final String LINEAR_INTERPOLATION = "linear";
    public static final String NEAREST_INTERPOLATION = "nearest";
    public static final String CUBIC_INTERPOLATION = "cubic";
    protected final String interpolation;
    protected transient RealRandomAccessible<RealComposite<S>> field;
    protected transient int vectorAxisIndex;

    public AbstractParametrizedFieldTransform(String type, String name, String input, String output) {
        this(type, name, null, LINEAR_INTERPOLATION, input, output);
    }

    public AbstractParametrizedFieldTransform(String type, String name, String parameterPath, String interpolation, String input, String output) {
        super(type, name, parameterPath, input, output);
        this.interpolation = interpolation;
    }

    public AbstractParametrizedFieldTransform(String type, String name, String parameterPath, String interpolation, String[] inputAxes, String[] outputAxes) {
        super(type, name, parameterPath, inputAxes, outputAxes);
        this.interpolation = interpolation;
    }

    public int getVectorAxisIndex() {
        return this.vectorAxisIndex;
    }

    public String getInterpolation() {
        return this.interpolation;
    }

    public abstract int parseVectorAxisIndex(N5Reader var1);

    public RealRandomAccessible<RealComposite<S>> getField() {
        return this.field;
    }

    @Override
    public RealRandomAccessible<RealComposite<S>> getParameters(N5Reader n5) {
        int nd;
        AffineGet affineTotal;
        AffineGet affine;
        CachedCellImg fieldRaw;
        String path = this.getParameterPath();
        this.vectorAxisIndex = this.parseVectorAxisIndex(n5);
        InvertibleRealTransform ixfm = null;
        CoordinateTransform[] transforms = null;
        transforms = n5.getAttribute(path, "coordinateTransformations", CoordinateTransform[].class);
        if (transforms != null && transforms.length >= 1 && transforms[0] instanceof InvertibleCoordinateTransform) {
            ixfm = ((InvertibleCoordinateTransform)transforms[0]).getInvertibleTransform();
        }
        try {
            fieldRaw = N5Utils.open((N5Reader)n5, (String)path);
        }
        catch (N5Exception e) {
            return null;
        }
        CompositeIntervalView collapsedFirst = Views.collapseReal((RandomAccessibleInterval)Views.moveAxis((RandomAccessibleInterval)fieldRaw, (int)0, (int)(fieldRaw.numDimensions() - 1)));
        RealRandomAccessible fieldInterp = Views.interpolate((EuclideanSpace)Views.extendBorder((RandomAccessibleInterval)collapsedFirst), (InterpolatorFactory)new NLinearInterpolatorFactory());
        CoordinateTransform<?> pixelToPhysicalCt = AbstractParametrizedFieldTransform.findPixelToPhysicalTransformStrict(n5, path, this.getOutput());
        if (pixelToPhysicalCt == null) {
            pixelToPhysicalCt = AbstractParametrizedFieldTransform.findPixelToPhysicalTransformCheckSelfRef(n5, path, this.getOutput());
        }
        if (pixelToPhysicalCt == null) {
            this.field = fieldInterp;
            return this.field;
        }
        if (pixelToPhysicalCt.getType().equals("sequence") && (affine = Common.removeDimension(this.vectorAxisIndex, affineTotal = ((SequenceCoordinateTransform)pixelToPhysicalCt).asAffine(nd = fieldRaw.numDimensions()))) != null) {
            this.field = RealViews.affine((RealRandomAccessible)fieldInterp, (AffineGet)affine);
            return this.field;
        }
        System.err.println("Warning: only affine pixel to physical transforms are currently supported");
        return null;
    }

    public static CoordinateTransform<?> findPixelToPhysicalTransformStrict(N5Reader n5, String group, String output) {
        String normGrp = N5URI.normalizeGroupPath(group);
        CoordinateTransform[] transforms = n5.getAttribute(group, "coordinateTransformations", CoordinateTransform[].class);
        if (transforms == null) {
            return null;
        }
        for (CoordinateTransform ct : transforms) {
            String nrmInput = N5URI.normalizeGroupPath(ct.getInput());
            if (!nrmInput.equals(normGrp) || !ct.getOutput().equals(output)) continue;
            return ct;
        }
        return null;
    }

    public static CoordinateTransform<?> findPixelToPhysicalTransformCheckSelfRef(N5Reader n5, String group, String output) {
        CoordinateTransform[] transforms = n5.getAttribute(group, "coordinateTransformations", CoordinateTransform[].class);
        if (transforms == null) {
            return null;
        }
        for (CoordinateTransform ct : transforms) {
            if (ct instanceof ParametrizedTransform) {
                ParametrizedTransform pct = (ParametrizedTransform)ct;
                String path = pct.getParameterPath();
                if (pct.getParameterPath().equals(".") || N5URI.normalizeGroupPath(group).equals(N5URI.normalizeGroupPath(path))) continue;
                return ct;
            }
            return ct;
        }
        return null;
    }

    public static RealTransform findFieldTransformStrict(N5Reader n5, String group, String output) {
        String normGrp = N5URI.normalizeGroupPath(group);
        CoordinateTransform[] transforms = n5.getAttribute(group, "coordinateTransformations", CoordinateTransform[].class);
        if (transforms == null) {
            return null;
        }
        for (CoordinateTransform ct : transforms) {
            String nrmInput = N5URI.normalizeGroupPath(ct.getInput());
            if (!nrmInput.equals(normGrp) || !ct.getOutput().equals(output)) continue;
            return ct.getTransform(n5);
        }
        return null;
    }
}

