/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph;

import java.util.LinkedList;
import java.util.List;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.Common;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.TransformUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.TransformGraph;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.SequenceCoordinateTransform;

public class TransformPath {
    private final String start;
    private final TransformPath parentPath;
    private final CoordinateTransform<?> transform;
    private final String end;

    public TransformPath(CoordinateTransform<?> transform) {
        this.start = transform.getInput();
        this.transform = transform;
        this.end = transform.getOutput();
        this.parentPath = null;
    }

    public TransformPath(TransformPath parentPath, CoordinateTransform<?> transform) {
        this.start = parentPath.getStart();
        this.parentPath = parentPath;
        this.transform = transform;
        this.end = transform.getOutput();
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public double getCost() {
        return 1.0;
    }

    public boolean hasSpace(CoordinateSystem cs) {
        if (this.start.equals(cs.getName()) || this.end.equals(cs.getName())) {
            return true;
        }
        if (this.parentPath != null) {
            return this.parentPath.hasSpace(cs);
        }
        return false;
    }

    public List<CoordinateTransform<?>> flatTransforms() {
        LinkedList flatTransforms = new LinkedList();
        this.flatTransforms(flatTransforms);
        return flatTransforms;
    }

    public RealTransform totalTransform(N5Reader n5, TransformGraph g) {
        RealTransformSequence total = new RealTransformSequence();
        this.flatTransforms().forEach(t -> {
            if (t instanceof SequenceCoordinateTransform) {
                SequenceCoordinateTransform s = (SequenceCoordinateTransform)t;
                if (s.isAffine()) {
                    int nd = g.getInput((CoordinateTransform<?>)t).getAxes().length;
                    total.add((RealTransform)TransformUtils.toAffine(s, nd));
                } else {
                    total.add(t.getTransform());
                }
            } else {
                total.add(t.getTransform(n5));
            }
        });
        return total;
    }

    public RealTransform totalTransform(N5Reader n5) {
        RealTransformSequence total = new RealTransformSequence();
        this.flatTransforms().forEach(t -> total.add(t.getTransform(n5)));
        return total;
    }

    public RealTransform totalTransform() {
        RealTransformSequence total = new RealTransformSequence();
        this.flatTransforms().forEach(t -> total.add(t.getTransform()));
        return total;
    }

    public AffineTransform3D totalAffine3D(N5Reader n5) {
        return Common.toAffine3D(n5, this.flatTransforms());
    }

    public AffineTransform3D totalAffine3D() {
        return Common.toAffine3D(this.flatTransforms());
    }

    private void flatTransforms(LinkedList<CoordinateTransform<?>> queue) {
        if (this.transform != null) {
            queue.addFirst(this.transform);
        }
        if (this.parentPath != null) {
            this.parentPath.flatTransforms(queue);
        }
    }

    public List<String> flatSpace() {
        LinkedList<String> flatSpace = new LinkedList<String>();
        this.flatSpace(flatSpace);
        flatSpace.addFirst(this.start);
        return flatSpace;
    }

    private void flatSpace(LinkedList<String> queue) {
        if (this.end != null) {
            queue.addFirst(this.end);
        }
        if (this.parentPath != null) {
            this.parentPath.flatSpace(queue);
        }
    }

    public String toString() {
        List<String> spaceList = this.flatSpace();
        List<CoordinateTransform<?>> transformList = this.flatTransforms();
        if (transformList.size() < 1) {
            return "(" + spaceList.get(0) + ")";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < transformList.size(); ++i) {
            out.append("(" + spaceList.get(i));
            out.append(") --");
            out.append(transformList.get(i));
            out.append("-> ");
        }
        out.append("(" + this.end + ")");
        return out.toString();
    }
}

