/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.SequenceCoordinateTransform;

public class CoordinateSystems {
    private static final String PREFIX = "DEFAULTSPACE-";
    private final HashMap<String, CoordinateSystem> nameToSpace = new HashMap();
    private final HashMap<String, Axis> nameToAxis = new HashMap();
    private final HashMap<Axis, ArrayList<CoordinateSystem>> axesToSpaces = new HashMap();

    public CoordinateSystems() {
    }

    public CoordinateSystems(Collection<CoordinateSystem> spaceList) {
        this();
        this.addAll(spaceList);
    }

    public CoordinateSystems(Stream<CoordinateSystem> spaces) {
        this();
        this.addAll(spaces);
    }

    public CoordinateSystems(CoordinateSystem[] coordinateSystems) {
        this();
        for (CoordinateSystem s : coordinateSystems) {
            this.add(s);
        }
    }

    public Stream<CoordinateSystem> coordinateSystems() {
        return this.nameToSpace.entrySet().stream().map(e -> (CoordinateSystem)e.getValue());
    }

    public Collection<CoordinateSystem> getCollection() {
        return this.nameToSpace.values();
    }

    public Stream<Axis> axes() {
        return this.nameToAxis.entrySet().stream().map(e -> (Axis)e.getValue());
    }

    public Axis[] axesFromLabels(String ... axisLabels) {
        return (Axis[])Arrays.stream(axisLabels).map(l -> {
            if (this.nameToAxis.containsKey(l)) {
                return this.nameToAxis.get(l);
            }
            Axis a = CoordinateSystems.makeDefaultAxis(l);
            this.add(a);
            return a;
        }).toArray(Axis[]::new);
    }

    public void addAll(Collection<CoordinateSystem> spaces) {
        for (CoordinateSystem s : spaces) {
            this.add(s);
        }
    }

    public void addAll(Stream<CoordinateSystem> spaces) {
        spaces.forEach(s -> this.add((CoordinateSystem)s));
    }

    public boolean add(CoordinateSystem s) {
        if (this.nameToSpace.containsKey(s.getName())) {
            CoordinateSystem other = this.nameToSpace.get(s.getName());
            if (!s.equals(other)) {
                return false;
            }
        } else {
            this.nameToSpace.put(s.getName(), s);
        }
        for (Axis a : s.getAxes()) {
            if (!this.add(a)) continue;
            ArrayList<CoordinateSystem> list = new ArrayList<CoordinateSystem>();
            list.add(s);
            this.axesToSpaces.put(a, list);
        }
        return true;
    }

    public boolean add(Axis a) {
        if (this.nameToAxis.containsKey(a.getName())) {
            Axis other = this.nameToAxis.get(a.getName());
            if (!a.equals(other)) {
                return false;
            }
        } else {
            this.nameToAxis.put(a.getName(), a);
        }
        return true;
    }

    public CoordinateSystem getSpace(String name) {
        return this.nameToSpace.get(name);
    }

    public String[] axesForSpace(String name) {
        return this.getSpace(name).getAxisNames();
    }

    public boolean hasSpace(String name) {
        return this.nameToSpace.containsKey(name);
    }

    public String defaultSpaceName(String ... axisLabels) {
        return PREFIX + Arrays.stream(axisLabels).collect(Collectors.joining("-"));
    }

    public CoordinateSystem makeDefaultSpace(String ... axisLabels) {
        return this.makeDefaultSpace(this.defaultSpaceName(axisLabels), axisLabels);
    }

    public static Axis makeDefaultAxis(String name) {
        return new Axis(name, "", "", false);
    }

    public CoordinateSystem makeDefaultSpace(String name, String ... axisLabels) {
        Axis[] axes = new Axis[axisLabels.length];
        for (int i = 0; i < axisLabels.length; ++i) {
            Axis a = this.nameToAxis.get(axisLabels[i]);
            if (a == null) {
                return null;
            }
            axes[i] = a;
        }
        CoordinateSystem s = new CoordinateSystem(name, axes);
        this.add(s);
        return s;
    }

    public CoordinateSystem getSpaceFromAxes(String ... axisLabels) {
        return this.getSpacesFromAxes(axisLabels).get(0);
    }

    public ArrayList<CoordinateSystem> getSpacesFromAxes(String ... axisLabels) {
        ArrayList<CoordinateSystem> list = new ArrayList<CoordinateSystem>(this.coordinateSystems().filter(s -> s.axesLabelsMatch(axisLabels)).collect(Collectors.toList()));
        if (list.isEmpty()) {
            list.add(this.makeDefaultSpace(axisLabels));
        }
        return list;
    }

    public ArrayList<CoordinateSystem> getSpacesContainingAxes(String ... axisLabels) {
        ArrayList<CoordinateSystem> list = new ArrayList<CoordinateSystem>(this.coordinateSystems().filter(s -> s.hasAllLabels(axisLabels)).collect(Collectors.toList()));
        if (list.isEmpty()) {
            list.add(this.makeDefaultSpace(axisLabels));
        }
        return list;
    }

    public ArrayList<CoordinateSystem> getSpacesOld(String ... axisLabels) {
        ArrayList<CoordinateSystem> candidates = null;
        for (String l : axisLabels) {
            Axis a = this.nameToAxis.get(l);
            if (a == null) continue;
            ArrayList<CoordinateSystem> spaces = this.axesToSpaces.get(a);
            if (candidates == null) {
                candidates = new ArrayList<CoordinateSystem>();
                candidates.addAll(spaces);
                continue;
            }
            for (CoordinateSystem s : spaces) {
                if (candidates.contains(s)) continue;
                candidates.remove(s);
            }
        }
        if (candidates.isEmpty()) {
            candidates.add(this.makeDefaultSpace(axisLabels));
        }
        return candidates;
    }

    public Axis getAxis(String name) {
        return this.nameToAxis.get(name);
    }

    public CoordinateSystem spaceFrom(String[] axes) {
        return this.getSpaceFromAxes(axes);
    }

    public CoordinateSystem spaceFrom(String name) {
        return this.getSpace(name);
    }

    public String[] getInputAxes(CoordinateTransform<?> t) {
        String[] inAxes = null;
        if (t.getInputAxes() != null) {
            inAxes = t.getInputAxes();
        } else if (t.getInput() != null) {
            inAxes = this.getSpace(t.getInput()).getAxisNames();
        }
        return inAxes;
    }

    public String[] getOutputAxes(CoordinateTransform<?> t) {
        String[] outAxes = null;
        if (t.getOutputAxes() != null) {
            outAxes = t.getOutputAxes();
        } else if (t.getOutput() != null) {
            outAxes = this.getSpace(t.getOutput()).getAxisNames();
        }
        return outAxes;
    }

    public boolean inputIsSubspace(CoordinateTransform<?> t, CoordinateSystem s) {
        return s.isSubspaceOf(this.getSpace(t.getInput()));
    }

    public boolean inputHasAxis(CoordinateTransform<?> t, String axisLabel) {
        return this.getSpace(t.getInput()).hasAxis(axisLabel);
    }

    public boolean outputIsSubspace(CoordinateTransform<?> t, CoordinateSystem s) {
        if (t.getOutputAxes() != null) {
            return s.isSubspaceOf(t.getOutputAxes());
        }
        if (t.getOutput() != null) {
            return s.isSubspaceOf(this.getSpace(t.getOutput()));
        }
        return false;
    }

    public boolean outputIsSuperspace(CoordinateTransform<?> t, CoordinateSystem s) {
        if (t.getOutputAxes() != null) {
            return s.isSuperspaceOf(t.getOutputAxes());
        }
        if (t.getOutput() != null) {
            return s.isSuperspaceOf(this.getSpace(t.getOutput()));
        }
        return false;
    }

    public boolean outputHasAxis(CoordinateTransform<?> t, String axisLabel) {
        if (t.getOutputAxes() != null) {
            return Arrays.stream(t.getOutputAxes()).anyMatch(x -> x.equals(axisLabel));
        }
        if (t.getOutput() != null) {
            return this.getSpace(t.getOutput()).hasAxis(axisLabel);
        }
        return false;
    }

    public boolean outputMatchesAny(CoordinateTransform<?> t, Set<String> axisLabels) {
        String[] outAxes = null;
        if (t.getOutputAxes() != null) {
            outAxes = t.getOutputAxes();
        } else if (t.getOutput() != null) {
            outAxes = this.getSpace(t.getOutput()).getAxisNames();
        } else {
            return false;
        }
        for (String axisLabel : t.getOutputAxes()) {
            if (!axisLabels.contains(axisLabel)) continue;
            return true;
        }
        return false;
    }

    public boolean outputMatchesAny(CoordinateTransform<?> t, String[] axisLabels) {
        String[] outAxes = null;
        if (t.getOutputAxes() != null) {
            outAxes = t.getOutputAxes();
        } else if (t.getOutput() != null) {
            outAxes = this.getSpace(t.getOutput()).getAxisNames();
        } else {
            return false;
        }
        for (String axisLabel : t.getOutputAxes()) {
            if (Arrays.stream(axisLabels).filter(x -> x.equals(axisLabel)).count() <= 0L) continue;
            return true;
        }
        return false;
    }

    public <T extends CoordinateTransform<?>> void updateTransforms(Stream<T> transforms) {
        transforms.forEach(s -> {
            if (s instanceof AbstractCoordinateTransform) {
                this.updateTransform((AbstractCoordinateTransform)s);
            }
            if (s instanceof SequenceCoordinateTransform) {
                SequenceCoordinateTransform t = (SequenceCoordinateTransform)s;
                this.updateTransforms(Arrays.stream(t.getTransformations()));
            }
        });
    }

    public <T extends AbstractCoordinateTransform<?>> void updateTransform(T t) {
        if (t.getInput() != null) {
            t.setInput(this.nameToSpace.get(t.getInput()));
        } else if (t.getInputAxes() != null) {
            t.setInput(this.makeDefault(t.getInputAxes()));
        }
        if (t.getOutput() != null) {
            t.setOutput(this.nameToSpace.get(t.getOutput()));
        } else if (t.getOutputAxes() != null) {
            t.setOutput(this.makeDefault(t.getOutputAxes()));
        }
    }

    public static String defaultName(String[] axes) {
        return String.join((CharSequence)"", axes) + "(DEFAULT)";
    }

    public CoordinateSystem makeDefault(String[] axes) {
        Axis[] a = this.axesFromLabels(axes);
        if (Arrays.stream(a).allMatch(x -> x != null)) {
            return new CoordinateSystem(CoordinateSystems.defaultName(axes), a);
        }
        return null;
    }

    public CoordinateSystem addDefault(String[] axes) {
        CoordinateSystem space = this.makeDefault(axes);
        this.add(space);
        return space;
    }
}

