/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.axes.ArrayCoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.CoordinateSystems;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.TransformGraph;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransformAdapter;

public class SpacesTransforms {
    public CoordinateSystem[] spaces;
    public CoordinateTransform<?>[] transforms;

    public SpacesTransforms(CoordinateSystem[] spaces, CoordinateTransform<?>[] transforms) {
        this.spaces = spaces;
        this.transforms = transforms;
    }

    public static Gson buildGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)CoordinateTransform.class), new CoordinateTransformAdapter(null));
        Gson gson = gsonBuilder.create();
        return gson;
    }

    public static SpacesTransforms load(Reader reader) {
        Gson gson = SpacesTransforms.buildGson();
        SpacesTransforms st = gson.fromJson(reader, SpacesTransforms.class);
        return st;
    }

    public static SpacesTransforms load(File f) throws FileNotFoundException {
        return SpacesTransforms.load(new FileReader(f.getAbsolutePath()));
    }

    public static SpacesTransforms loadFile(String path) throws FileNotFoundException {
        return SpacesTransforms.load(new FileReader(path));
    }

    public CoordinateSystems buildSpaces() {
        return this.buildSpaces(0);
    }

    public CoordinateSystems buildSpaces(String name, int nd) {
        CoordinateSystems s = new CoordinateSystems(this.spaces);
        if (nd > 0) {
            s.add(new ArrayCoordinateSystem(name, nd));
        }
        return s;
    }

    public CoordinateSystems buildSpaces(int nd) {
        return this.buildSpaces("", nd);
    }

    public TransformGraph buildTransformGraph() {
        return this.buildTransformGraph(0);
    }

    public TransformGraph buildTransformGraph(int nd) {
        return this.buildTransformGraph("", nd);
    }

    public TransformGraph buildTransformGraph(String dataset) {
        return this.buildTransformGraph(dataset, 0);
    }

    public TransformGraph buildTransformGraph(String dataset, int nd) {
        if (this.transforms == null) {
            return new TransformGraph();
        }
        return new TransformGraph(Arrays.asList(this.transforms), this.buildSpaces(dataset, nd));
    }
}

