/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.AxisAdapter;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.DatasetAdapter;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.MultiscalesAdapter;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.NgffSingleScaleAxesMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.CoordinateTransformation;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.CoordinateTransformationAdapter;
import org.janelia.saalfeldlab.n5.zarr.ZarrDatasetAttributes;

public class OmeNgffMetadataParser
implements N5MetadataParser<OmeNgffMetadata>,
N5MetadataWriter<OmeNgffMetadata> {
    private final Gson gson = OmeNgffMetadataParser.gsonBuilder().create();

    public OmeNgffMetadataParser(boolean reverse) {
    }

    public OmeNgffMetadataParser() {
        this(false);
    }

    public static GsonBuilder gsonBuilder() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)CoordinateTransformation.class), new CoordinateTransformationAdapter()).registerTypeAdapter((Type)((Object)OmeNgffMultiScaleMetadata.OmeNgffDataset.class), new DatasetAdapter()).registerTypeAdapter((Type)((Object)Axis.class), new AxisAdapter()).registerTypeAdapter((Type)((Object)OmeNgffMultiScaleMetadata.class), new MultiscalesAdapter());
    }

    @Override
    public Optional<OmeNgffMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
        OmeNgffMultiScaleMetadata[] multiscales;
        try {
            JsonElement base = n5.getAttribute(node.getPath(), "multiscales", JsonElement.class);
            multiscales = this.gson.fromJson(base, OmeNgffMultiScaleMetadata[].class);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        if (multiscales == null || multiscales.length == 0) {
            return Optional.empty();
        }
        int nd = -1;
        HashMap<String, N5TreeNode> scaleLevelNodes = new HashMap<String, N5TreeNode>();
        for (N5TreeNode childNode : node.childrenList()) {
            if (!childNode.isDataset() || childNode.getMetadata() == null) continue;
            scaleLevelNodes.put(childNode.getPath(), childNode);
            if (nd >= 0) continue;
            nd = ((N5DatasetMetadata)childNode.getMetadata()).getAttributes().getNumDimensions();
        }
        if (nd < 0) {
            return Optional.empty();
        }
        for (int j = 0; j < multiscales.length; ++j) {
            OmeNgffMultiScaleMetadata ms = multiscales[j];
            String[] paths = ms.getPaths();
            DatasetAttributes[] attrs = new DatasetAttributes[ms.getPaths().length];
            N5DatasetMetadata[] dsetMeta = new N5DatasetMetadata[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                dsetMeta[i] = (N5DatasetMetadata)((N5TreeNode)scaleLevelNodes.get(MetadataUtils.canonicalPath(node, paths[i]))).getMetadata();
                attrs[i] = dsetMeta[i].getAttributes();
            }
            ArrayUtils.reverse((Object[])ms.axes);
            N5Metadata[] msChildrenMeta = OmeNgffMultiScaleMetadata.buildMetadata(nd, node.getPath(), ms.datasets, attrs, ms.coordinateTransformations, ms.metadata, ms.axes);
            MetadataUtils.updateChildrenMetadata(node, msChildrenMeta, false);
            multiscales[j] = new OmeNgffMultiScaleMetadata(ms, (NgffSingleScaleAxesMetadata[])msChildrenMeta);
        }
        return Optional.of(new OmeNgffMetadata(node.getPath(), multiscales));
    }

    @Override
    public void writeMetadata(OmeNgffMetadata t, N5Writer n5, String groupPath) throws Exception {
        OmeNgffMultiScaleMetadata[] ms = t.multiscales;
        JsonElement jsonElem = this.gson.toJsonTree(ms);
        for (JsonElement e : jsonElem.getAsJsonArray().asList()) {
            JsonArray axes = e.getAsJsonObject().get("axes").getAsJsonArray();
            Collections.reverse(axes.asList());
        }
        n5.setAttribute(groupPath, "multiscales", jsonElem);
    }

    public static boolean cOrder(DatasetAttributes datasetAttributes) {
        if (datasetAttributes instanceof ZarrDatasetAttributes) {
            ZarrDatasetAttributes zattrs = (ZarrDatasetAttributes)datasetAttributes;
            return zattrs.isRowMajor();
        }
        return false;
    }
}

