/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Optional;
import net.imglib2.realtransform.ScaleAndTranslation;
import org.apache.commons.lang3.ArrayUtils;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.NgffSingleScaleAxesMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.CoordinateTransformation;

public class NgffSingleScaleMetadataParser
implements N5MetadataParser<NgffSingleScaleAxesMetadata>,
N5MetadataWriter<NgffSingleScaleAxesMetadata> {
    private final Gson gson = OmeNgffMetadataParser.gsonBuilder().create();

    @Override
    public Optional<NgffSingleScaleAxesMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
        Map<String, Class<?>> attrs = n5.listAttributes(node.getPath());
        if (attrs.containsKey("axes") && attrs.containsKey("coordinateTransformations")) {
            JsonArray axArr = n5.getAttribute(node.getPath(), "axes", JsonArray.class);
            Object[] axes = this.gson.fromJson((JsonElement)axArr, Axis[].class);
            JsonArray ctArr = n5.getAttribute(node.getPath(), "coordinateTransformations", JsonArray.class);
            CoordinateTransformation[] cts = this.gson.fromJson((JsonElement)ctArr, CoordinateTransformation[].class);
            if (cts == null || cts.length == 0) {
                return Optional.of(new NgffSingleScaleAxesMetadata(node.getPath(), null, null, null));
            }
            ScaleAndTranslation scaleAndTranslation = MetadataUtils.scaleTranslationFromCoordinateTransformations(cts);
            double[] scale = scaleAndTranslation.getScaleCopy();
            double[] translation = scaleAndTranslation.getTranslationCopy();
            DatasetAttributes dsetAttrs = n5.getDatasetAttributes(node.getPath());
            if (OmeNgffMetadataParser.cOrder(dsetAttrs)) {
                ArrayUtils.reverse((Object[])axes);
            }
            return Optional.of(new NgffSingleScaleAxesMetadata(node.getPath(), scale, translation, (Axis[])axes, null));
        }
        return Optional.empty();
    }

    @Override
    public void writeMetadata(NgffSingleScaleAxesMetadata t, N5Writer n5, String path) throws Exception {
        JsonElement json = this.gson.toJsonTree(t);
        n5.setAttribute(path, "axes", json.getAsJsonObject().get("axes"));
        n5.setAttribute(path, "coordinateTransformations", t.getCoordinateTransformations());
    }
}

